/*******************************************************************************

    uBlock Origin Lite - a comprehensive, MV3-compliant content blocker
    Copyright (C) 2014-present Raymond Hill

    This program is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program.  If not, see {http://www.gnu.org/licenses/}.

    Home: https://github.com/gorhill/uBlock
*/

/* jshint esversion:11 */

'use strict';

/******************************************************************************/

// Important!
// Isolate from global scope
(function uBOL_cssGenericImport() {

/******************************************************************************/

// annoyances-overlays

const toImport = [[5248787,"#Bloque_EX_Newsletter"],[15567475,"#Bloque_EX_NewsletterTematico"],[12443352,"#EmailOptin"],[567841,"#FlyoutSignupModalWrapper"],[60059,"#FooterNewsletter"],[3807510,"#GlobalSlotHeaderNewsletter"],[4714019,"#HPNewsletter"],[6582396,"#NNSubscribeBar"],[8874637,"#NewsletterOverlay"],[3929565,"#NewsletterSignUpSidebar"],[4266791,"#NewsletterSticky_pnlNewsletterSticky"],[11537022,"#NewsletterSubscribe"],[8298395,"#PopupSignupForm_0"],[10657684,"#RColNewslatter"],[2719580,"#SideNewsletterBox"],[10261905,"#Subscribe-Article-Bottom"],[6732049,"#SubscribePopUpBox"],[7117571,"#SubscribePushNotificationPanel"],[3381336,"#Widget-Newsletter"],[13696748,"#ajax-newsletter-form"],[3077961,"#alertNewsletter"],[5106808,"#app_newsletter"],[9547174,"#article-newsletter-signup"],[13127782,"#article-newsletter-slot"],[15434998,"#article-promo-newsletter"],[11860171,"#barNewsletter"],[1594905,"#bloc-newsletter"],[11957611,"#bloc_newsletter"],[7990826,"#block-dfp-subscriptions-block"],[14775285,"#block-mailchimp-signup-newsletter"],[7921125,"#block-newsletteraside"],[6466410,"#block-newsletteroverlay"],[7921148,"#block-newsletterpopup"],[860133,"#block-quick-subscribe-footer"],[9036837,"#block-sailthru-basic-newsletter"],[2908505,"#block-sailthru-newsletters"],[11265900,"#bottom_newsletter"],[5583489,"#boxNewsletter"],[3077160,"#boxes-box-newsletter"],[13902127,"#cm-popup-overlay"],[11568439,"#collapse-newsletter"],[12754979,"#collapse-newsletter-trigger"],[12928289,"#divNewsletterPromoPopup"],[11320046,"#divnewslettertipo_1"],[11320045,"#divnewslettertipo_2"],[14174247,"#e2ma_signup_form"],[11180312,"#email-alerts-button"],[11225730,"#email-display-trigger"],[12078565,"#email-exitintent-widget"],[2278155,"#email-footer"],[7359787,"#email-marketing-widget"],[1014594,"#email-modal-bg"],[5325106,"#email-news-subscribe"],[14771882,"#email-opt-in-bottom"],[1910762,"#email-popup-back"],[10263492,"#email-posts-to-subscribers-2"],[14643321,"#email-rotator-wrapper"],[242158,"#email-signup-sidebar"],[4945186,"#email-widget-wrapper"],[8357974,"#engagement-newsletter"],[10854975,"#exit-overlay-inline"],[12079089,"#floating_subscribe"],[6252791,"#footer-newsletter-mobile"],[6251694,"#footer-newsletter-signup"],[7289186,"#footer-newsletter-subscribe"],[13275766,"#footer-subscription-modal"],[5917051,"#footerNewsletter"],[11938430,"#footerSubscribe"],[2009703,"#footer__newsletter-signup"],[14788798,"#footer_block_newsletter"],[8482076,"#footer_newsletter_signup"],[9456238,"#form-footer-newsletters"],[8365715,"#form-newsletter-footer"],[5802524,"#fusion-email-signup-modal"],[13347266,"#gastro-email-roadblock-modal"],[2608479,"#gigya-newsletter-social"],[15807909,"#gnt_atomsnc"],[10077126,"#id_newsletter_subscription"],[3478035,"#id_newsletter_subscription_popup"],[16650818,"#injected-newsletter"],[4293497,"#injector-signup"],[4036577,"#inline-subscribe-form"],[4564091,"#inscription_newsletter"],[2173628,"#instream_newsletter_signup"],[5097308,"#iscrizione_newsletter"],[12145667,"#js-mobile-subscribe-bar"],[4281188,"#js-newslettermodal"],[16362852,"#js-overlayEmailSignup"],[5016207,"#js-subscription-box"],[8105576,"#leaflet-newsletter-form"],[6101933,"#left-footer-subscribe"],[5457039,"#left-newsletters-form"],[12204018,"#leftcol_subscribe"],[8558799,"#leftnewslettersubsblock"],[1332013,"#list-newsletter-form"],[14606822,"#m-inline-newsletter"],[3762246,"#mailchimp-top-bar"],[16192995,"#mailing-list-popup"],[1169573,"#mailing-list-signup"],[2341641,"#mc-frontpage-subscribe"],[9414353,"#mc-signup-in-post"],[12190290,"#mc_embed_signup_nojs"],[8667858,"#misty-newsletter-subscribe"],[5296406,"#ml-newsletterform"],[14014089,"#mm_newsletter"],[7373401,"#mobileNewsletterInput"],[13294931,"#mod-newsletter-1"],[12332339,"#mod-newsletter-signup-1,#mod-newsletter-signup-2"],[1339429,"#modale_inscription_newsletter"],[15105714,"#new-nl-placeholder"],[1987039,"#new_newsletter_subscription"],[16317312,"#newsLetterFooterDiv,#newsletterFooterDiv"],[10985011,"#newsLetterWidgetSection"],[12798307,"#newsletter-ad"],[10697963,"#newsletter-alert-signup"],[9976894,"#newsletter-background"],[13127149,"#newsletter-banner"],[5811058,"#newsletter-banner-bottom"],[9973296,"#newsletter-below-post"],[9962159,"#newsletter-bottom-bar"],[14506532,"#newsletter-callout"],[7568144,"#newsletter-cta"],[9982716,"#newsletter-exit-modal"],[6411310,"#newsletter-flag"],[16322644,"#newsletter-floating"],[13126947,"#newsletter-footer"],[2262993,"#newsletter-form-footer"],[2589434,"#newsletter-incentive"],[13126921,"#newsletter-inline"],[6192688,"#newsletter-inline-widget"],[10480187,"#newsletter-interstitial"],[14507024,"#newsletter-overlay"],[13126959,"#newsletter-pop-in"],[12534812,"#newsletter-popin"],[2340636,"#newsletter-popup-fixed"],[6464677,"#newsletter-popup-overlay,#newsletter_popup_overlay"],[12534437,"#newsletter-promo"],[6411208,"#newsletter-rail"],[2596450,"#newsletter-roadblock"],[2595764,"#newsletter-shortcode"],[2470394,"#newsletter-side-widget"],[14506273,"#newsletter-sidebar"],[6115822,"#newsletter-signup-footer,#newsletter_signup_footer"],[12809144,"#newsletter-signup-overlay"],[6431176,"#newsletter-signup-short-form"],[12809170,"#newsletter-signup-sidebar"],[2403976,"#newsletter-single-step"],[12535026,"#newsletter-slide"],[16322166,"#newsletter-slideout"],[13126976,"#newsletter-slider"],[12534759,"#newsletter-strip"],[6321495,"#newsletter-subscribe-sidebar"],[652919,"#newsletter-subscription-popup"],[13127273,"#newsletter-teaser"],[12421243,"#newsletterFooter"],[10007988,"#newsletterLBContainer"],[13127277,"#newsletterOverlay"],[16331944,"#newsletterOverlayBg"],[7565770,"#newsletterPush"],[3314617,"#newsletterPush-overlay"],[13127244,"#newsletterSidebar"],[2599686,"#newsletterSidebarBox"],[2417634,"#newsletterStickyBanner"],[2596149,"#newsletter_form_3div"],[12855107,"#newsletter_info_container"],[13126892,"#newsletter_middle"],[7565625,"#newsletter_mod"],[12412978,"#newsletter_popup"],[13126895,"#newsletter_ribbon"],[10848873,"#newsletter_sidebar_form"],[2594774,"#newsletter_signup_ft"],[5324302,"#newsletter_signup_fullwidth"],[2404420,"#newsletter_signup_side"],[16323648,"#newsletter_smartbar"],[16349077,"#newsletter_sub_form"],[11727095,"#newsletter_subscription_footer"],[16319093,"#newsletter_widget-2"],[1689642,"#newsletterad"],[6493145,"#newsletterflyin"],[14505076,"#newsletters-1-form"],[8199722,"#newsletters-1-form-wrapper"],[14504919,"#newsletters-2-form"],[10602364,"#newsletters-footer-content"],[10418512,"#newsletters-signup-sidebar"],[6504251,"#newsletters_rdr"],[760088,"#nl-fixed-bottom"],[10468861,"#nlSliderSignup"],[5838942,"#nl_popin"],[12885339,"#nl_signup_rr"],[12158140,"#nlpopupmask"],[6893252,"#nm-subscribe-box"],[16085113,"#nm-subscribe-wrapper"],[3954338,"#node-basic-newsletter"],[3091668,"#node-email-widget"],[15845709,"#noti_wrap"],[12224073,"#notification-subscribe-newsletter"],[3638864,"#onesignal-popover-container"],[729210,"#overlayPopinNewsletter"],[3610069,"#piano-article-newsletter"],[5024273,"#piano-newsletter-inline"],[16302473,"#pnlFooterNewsletterSignup"],[7709111,"#popinNewsletter"],[7448809,"#popupNewsletter"],[3254747,"#popup_newslettter"],[1982692,"#pp-subscribe"],[2946575,"#rail-newsletter"],[10944200,"#rhs_newsletter"],[7609506,"#rr-newsletter-signup"],[16760790,"#rr_newsletter"],[358590,"#sailthru-basic-newsletter-form"],[11806003,"#sailthru-email-form-wrapper"],[8756018,"#sailthru-newsletters-email-form-wrapper"],[10004810,"#sailthru-subscribe-sidebar"],[383981,"#sdac_subscribe_widget-3"],[10210345,"#sendpress_signup"],[98976,"#share-newsletter"],[11095648,"#sib_embed_signup"],[4935332,"#side-newsletter-signup"],[14927570,"#sidebar-block-newsletters"],[2709669,"#sidebar-email-subscription"],[11543550,"#sidebar-email-widget"],[7361576,"#sidebar-newsletter"],[16218834,"#sidebar-newsletter-form"],[10631893,"#sidebar-newsletter-signup"],[9464024,"#sidebar-newsletter-wrapper"],[2587071,"#signup-inline-newsletter"],[15096205,"#signup_interstitial"],[10424521,"#signup_interstitial_overlay"],[3026536,"#signup_right_sidebar"],[11637935,"#sleek-subscribe"],[6463424,"#slice-container-newsletterForm-articleInbodyContent"],[16057509,"#slice-container-newsletterForm-exitIntent"],[3927320,"#ssnewsletter"],[6382914,"#sssubscribe-wrapper"],[11812490,"#subNewsletter"],[4608249,"#subNewsletterV1"],[1921002,"#subscribe-block-bottom"],[2390696,"#subscribe-box-mobile"],[5791676,"#subscribe-popin"],[11544059,"#subscribe-widget"],[14738656,"#subscribe-widget-bottom"],[2403404,"#subscribe-widget-top"],[1799749,"#subscribeCTA"],[15945097,"#subscribePopup,#subscribepopup"],[6745362,"#subscribePopupform"],[10070049,"#subscribeRect"],[554992,"#subscribe_form_fixed"],[1106683,"#subscribe_modal_container"],[5178161,"#subscribe_overlay_container"],[5791650,"#subscribe_popup"],[6745655,"#subscribe_widget-3"],[8611792,"#ta_newsletter"],[2521343,"#tab_newsletter"],[14191734,"#taboola-newsletter"],[2972446,"#td-box-newsletter"],[13489201,"#td-newsletter-home"],[773102,"#td-sailthru-form"],[4092815,"#teaser-newsletter"],[15169527,"#uglipop_content_fixed"],[8828618,"#uglipop_overlay"],[3719037,"#ui-join-newsletter"],[849595,"#v-subscribe-article-form"],[1173021,"#v-subscribe-short-form"],[4303692,"#widget-newsletter-signup"],[4245313,"#widgetNewsletter"],[12236291,"#wp-subscribe"],[7690899,"#wp_newsletter"],[7676211,".BannerNewsletter"],[4151084,".BoxNewsletter"],[1468418,".CampaignType--popup.exit-intent"],[7422839,".GRDC_newsletters"],[9609388,".Homepage-newsletter"],[4917322,".MultiColorSubscribeWidget"],[239176,".NewsLetterLeftSide"],[239709,".Newsletter-Overlay"],[11784921,".Newsletter-shortcode"],[11763155,".NewsletterBanner"],[10033770,".NewsletterBox--footer"],[10017572,".NewsletterSignupInset"],[6221665,".NewsletterWidget--style-full-width"],[13317048,".Sailthru_Subscribe"],[66481,".StageNewsletterSimple"],[7481734,"._newsletterContentPromo"],[14515623,".a-newsletter"],[7507706,".actions-newsletter"],[16421246,".alo_easymail_widget"],[13321053,".area-newsletter"],[10584782,".article-block--newsletter"],[10449482,".article-bottom-newsletter"],[2652918,".article-bottom-newsletter_box"],[16330648,".article-chimp-subscribe"],[5908484,".article-footer-newsletter,.article_footer_newsletter"],[5897539,".article-footer__subscribe"],[8502427,".article-gutter-signup"],[11225342,".article-news-letter"],[15077112,".article-newsletter-module"],[8253242,".article-newsletter-subscription"],[12394022,".article-newsletter-wrapper"],[13616416,".article-sidebar-newsletter"],[9482650,".article-signup-widget"],[1450396,".article-signup_wrapper"],[13307911,".article-slidein-newsletter"],[2787554,".article-subscribe-container"],[2810137,".article-subscription-widget"],[751271,".article-tile-newsletter"],[10576312,".article_footer_subscribe"],[15076907,".article_newsletter_signup,div.article-newsletter-signup"],[1699920,".article_page_right_subscribe"],[11392395,".articles-newsletter"],[16176715,".aside-common-subscribe"],[4067372,".aside-little_newsletter"],[5103896,".aside-subscribe-module"],[2007944,".at_nwletters"],[2093962,".at_subscribe"],[13234265,".b-email-popup"],[15361457,".b-email-popup-backdrop"],[7799250,".b-email-subscribe-drawer"],[4257796,".b-email-subscribe-form"],[51389,".b-footer-subscribe"],[10501444,".b-newsletter"],[16181514,".b-newsletter-modal"],[8767032,".b-newsletter-signup"],[1808343,".b-post-subscription"],[14173266,".bNewsletter"],[4228521,".banner-newsletter"],[4842715,".banner_newsletter"],[5151988,".bar_newsletter"],[11990521,".bb-newsletter"],[4778616,".bd-subscribe-wrapper"],[9400895,".bg-newsletter-signup"],[15100229,".bk-section-subscribe"],[12452859,".bk-subscribe-email"],[12452842,".bk-subscribe-popup"],[5696139,".bl_newsletter"],[9437551,".bloc-info-newsletter"],[7490420,".bloc-newsletter,div.bloc-newsletter"],[6505863,".bloc-recup-email"],[14312207,".blocSubscribeRight"],[2058138,".block--newsletter--alt"],[2499728,".block--newsletter-signup"],[2248841,".block-content-newsletter"],[14475095,".block-email-alerts-footer"],[8149131,".block-mailchimp-signup"],[590751,".block-newsletter-signup"],[4765272,".block-social-newsletter"],[11194956,".block-sp-frontpage-newsletter"],[14588348,".block_newsletter"],[16003259,".blog-signup-container"],[15702334,".blog_signup_box"],[7161491,".blog_subscription"],[814937,".body-subscribtion-box"],[9231541,".bottom_signup_newsletter"],[6265102,".bottom_subscribe"],[11823715,".box--newsletter"],[11615081,".box-iscrizione-newsletter"],[740493,".box-newsletter-article"],[2182741,".box-newsletter-category"],[625284,".bs-newsletter-pack"],[4814408,".bs-subscribe-newsletter"],[3198265,".btmNewsletter"],[7813097,".btn-newsletter-head"],[12686459,".btn_big_newsletter"],[9346254,".bx-teaser-container--newsletter"],[15107998,".c-Footer__subscribe"],[8296240,".c-articleNewsletter_form"],[12813358,".c-call--newsletter"],[12098770,".c-cta--newsletter"],[2436377,".c-list-subscribe"],[8799023,".c-native-newsletterbox"],[10738744,".c-newsletter--cta"],[3461304,".c-newsletter--default"],[8735619,".c-newsletter--footer"],[14812562,".c-newsletter-article__content"],[11487826,".c-newsletter-banner"],[8735871,".c-newsletter-context"],[10738750,".c-newsletter-form"],[13772326,".c-newsletter-form__inner"],[5931040,".c-newsletter-promo"],[8735749,".c-newsletter-section"],[11488057,".c-newsletter-signup"],[12483582,".c-newsletter-subscribe"],[11488030,".c-newsletter-widget"],[5928018,".c-newsletterSticky"],[7583443,".c-newsletterSubscribe_form"],[8065742,".c-popular__collection--newsletter"],[7211161,".c-popular__newsletter"],[11303854,".c-post-actions__newsletter"],[11297138,".c-promo-box--newsletter"],[7677225,".c-reengageNewsletter"],[12481679,".c-subscribe-newsletter-banner"],[4660993,".c-touchpoint-newsletters"],[605167,".c-widget--newsletter"],[15698109,".c25__newsletter"],[11856558,".callout--subscribe"],[14925790,".captation-email-bottom"],[7843334,".card--newsletter"],[10907912,".card-newsletter"],[8845272,".card-newsletter-signup"],[15950215,".chunk-newsletter"],[1113802,".cm_newsletter"],[5011093,".cmg_signup_box"],[6151226,".column--newsletter"],[10777683,".column-newsletter"],[675015,".column-subscribe"],[13268647,".comp-newsletter-newslettersignup"],[853602,".component-emailsubscription"],[11390201,".component-newsletter-cta"],[1468813,".component-newsletter-signup"],[13165303,".component-newsletter-subscribe"],[6543892,".cont-newsletter"],[16037900,".cont-newsletter-header"],[14557464,".cont_popup_suscripicion_boletin_load"],[8235303,".container-form-newsletter"],[9403435,".container_newsletter"],[8140034,".container_row--newsletter"],[3254591,".contains-newsletter"],[4390053,".content--newsletter"],[102156,".content-c__newsletter--box"],[1574615,".content-mod-newsletter-right"],[3528943,".content-subscribe-block"],[2190009,".content-toaster--newsletter"],[3052741,".content-well-newsletter"],[10779775,".cta-subscribe"],[13384835,".cta__item--newsletter"],[15210890,".daily-news-letter"],[4380974,".daily-newsletter"],[9099621,".daily_email_signup"],[16034940,".divFooterEmailSignUp"],[10574937,".divSubscrbtionBox"],[1142232,".duet--cta--newsletter"],[10853923,".e-newsletter"],[16150502,".e-newsletter-block"],[3481501,".e-newsletter-block__initial"],[5240450,".e-newsletter-block_footer"],[2131915,".e-newsletter-overlay"],[2132043,".e-newsletter-wrapper"],[16147743,".e-newsletter_modal"],[4331381,".ebm-subscribe,.edm-subscribe"],[13613549,".email-cta"],[6570991,".email-subscription-div"],[11580664,".email-subscription-promo"],[15054033,".email-subscription-sidebar"],[12379257,".email-subscription-wrap"],[5590716,".email-widget-container"],[10434792,".emailSubscribeBox"],[416607,".email_podpis-wrapper"],[15004696,".email_subscribe__container"],[5911039,".email_subscribe_box"],[3508709,".email_subscribe_container"],[5854081,".encart-newsletter"],[14494957,".endpage_newsletter_signup"],[9381863,".enews-widget"],[9551012,".enews-wrapper"],[2352933,".entry-footer-subscribe"],[5908754,".entry-newsletter"],[6055836,".entryNewsletter"],[8170405,".eoa__newsletter-signup"],[14669221,".essb-subscribe-form-content"],[4674243,".et_bloom_flyin"],[12116072,".et_newsletter_widget"],[15774402,".et_pb_newsletter:not(.et_pb_login)"],[6839744,".f-newsletter"],[15983793,".featured_newsletter"],[9567374,".fixed-overlay-subscription"],[10010698,".fixed_newslettor"],[1458442,".flexible-content--newsletter"],[9398855,".float-newsletter-bar"],[6569851,".floating-newsletter-container"],[13983291,".flyout-newsletter-rr"],[1580657,".flyover-email-cta"],[2328977,".follow-embed__newsletter"],[7186336,".follow-subscribe"],[1769593,".followit--follow-form-container"],[16034445,".foo-newsletter"],[11984094,".footer--newsletter"],[11663624,".footer-banner-newsletter"],[16466621,".footer-col-subscribe"],[3206318,".footer-email-signup-container"],[1548397,".footer-n__newsletter"],[15426431,".footer-nav-newsletters"],[12268339,".footer-newslatter"],[12268215,".footer-newsletter"],[13588849,".footer-newsletter-box"],[13588848,".footer-newsletter-cta"],[16467963,".footer-newsletter-form"],[12407563,".footer-newsletter-section"],[7145667,".footer-newsletter-signup"],[7145668,".footer-newsletter-social"],[12407765,".footer-newsletter-wrapper"],[11994804,".footer-newsletters"],[16775699,".footer-sign-up"],[10264603,".footer-sign-up-form"],[11802549,".footer-signup"],[10119404,".footer-social-email"],[16522239,".footer-subscrabe-box"],[15881471,".footer-subscribe-widget"],[11265324,".footer__newsletter"],[6870038,".footer__newsletter-form"],[9504134,".footer__subscribe"],[6437651,".footer_box_newsletter"],[2039804,".footer_form_newsletter"],[9497797,".footer_newsletter"],[12900187,".footer_subscribe"],[10560851,".footer_subscription_block"],[12270945,".footeremail"],[4131574,".footernewsletter"],[15827307,".form-newsletter-container"],[8054786,".form-newsletter-content"],[4715538,".form-signup-articlebottom"],[8631154,".form__newsletter-subscribe"],[3882737,".form__newsletter-subscribe--block"],[15201347,".formkit-slide-in"],[2571151,".ft_newsletter"],[11330169,".ftr-nwsltr"],[12243863,".fuzoBox--newsletter"],[6473019,".gdm-newsletter-banner__container"],[4766775,".getresponse-signup"],[13519934,".getresponse-signup-container"],[11162750,".gh-subscribe"],[10666121,".giga-email-subscribe"],[8085317,".gigyaNewsletterSignup"],[12137411,".gk-amp-newsletter"],[9534845,".global-article-newsletter"],[6141415,".global-nav__subscribe-toggle"],[2701012,".global-newsletter-sign-up"],[5557001,".gmg-subscribe-widget"],[16588644,".gnt_m_nls"],[9862798,".h-newsletter"],[7098122,".h-register-newsletter"],[11367251,".h-subscribe"],[2650446,".h-teaser-newsletter"],[2988271,".ha-c-newsletter-promo"],[15233516,".ha-c-newsletter-promo__content"],[15788525,".hasNewsletter"],[9923694,".head-email-signup"],[6333167,".header-newsletter-box"],[15559950,".headerNewsletterCtaOverlay"],[4833906,".header__newsletter"],[1718001,".hellobar-signup"],[13322191,".hero-sidebar-newsletter"],[16162620,".home-newsletter"],[10958565,".home-newsletter-container"],[3960021,".home-newsletter-widget"],[11133894,".home-subscribe-col"],[9093736,".home-subscribe__signup-form"],[12215073,".homeNewsletter"],[5600282,".homeSubscribeCTAContainer"],[7395613,".homepage-bottom-email-signup"],[287180,".homepage-newsletter"],[10782017,".hs-subscribe-form-wrap"],[11742766,".hypelab-newsletter"],[10368644,".ibnewsletter-embedded"],[1970037,".ibnewsletter-popup"],[10728775,".ibnewsletter-wrapper"],[3053195,".ifklicked-subscribe"],[7470287,".ifklicked-subscribe-form"],[4904859,".ifklicked-subscribe-form-below"],[5776803,".in-article-newsletter-form"],[10547556,".inarticle-newsletter-widget"],[1655075,".incontent-newsletter"],[6455053,".ing-newsletter-box"],[13262218,".inline-email-signup-container"],[14263627,".inline-newsletter-campaign"],[10686245,".inline-newsletter-middle"],[10686260,".inline-newsletter-module"],[14567307,".inline-newsletter-subscribe"],[12638012,".inline-subscription-module"],[15613844,".inlineNewsletterSignup"],[16026002,".inlineNewsletterSubscription"],[12693695,".inlineNewsletter__wrapper"],[15926678,".inscription-newsletter"],[1388451,".ipWidget-Newsletter"],[4734416,".is-style-newsletter"],[5207442,".iscriviti-newsletter"],[5570449,".iscrizione-newsletter,.iscrizione_newsletter"],[7938650,".iscrizionenewsletter"],[12713699,".item-list-newsletter-box"],[15977973,".item-newsletter-article"],[13512832,".j-subscribe-block"],[14885986,".jetpack_subscription_widget"],[3559921,".jq-Newsletter"],[10419687,".jq_inscription_newsletter"],[3348238,".js-captation-email-bottom"],[1199633,".js-email-promo"],[4462997,".js-email-widget"],[7686068,".js-inline-newsletter-signup"],[6093489,".js-magazineSubscriptionPopin"],[3734953,".js-newsletter-sign-up-form"],[3504060,".js-newsletter-subscribe"],[16603712,".js-newsletter-subscription-footer"],[2309213,".js-newsletter-subscription-popup"],[1053735,".js-newsletter-widget"],[14686505,".js-popup-newsletter"],[14688002,".js-react-mailchimp-newsletter"],[15695277,".js-sidebar-signup"],[5913927,".js-subscription-combo-box"],[16032473,".js-tealium-newsletter"],[16459203,".js_newsletter-btn--subscribe"],[5480022,".js_newsletter-form-inline"],[13305535,".js_newsletter_curation_form"],[9520754,".keystone-newsletter-class"],[1713252,".kl-bx-newsletter"],[14568806,".klaviyo_flyout"],[9446484,".l-footer__newsletter"],[14506939,".link-newsletter"],[4926489,".listbuilder-popup-embedded"],[12940035,".lnk-newsletter"],[4559659,".m-brand-engagement"],[3109953,".m-footer-newsletter"],[6341127,".m-form-newsletter"],[15624378,".m-generic-cta--email-signup"],[2515221,".m-newsletter-box"],[6524855,".m-newsletter-signup"],[7333443,".m-newsletter-toaster"],[5628948,".m-newsletter_light"],[8790117,".m-site-foot--newsletter"],[3481685,".m-subscribe-widget"],[14232865,".m4p-newsletter-form"],[2516189,".mail-newsletter"],[15703754,".mailchimp-lists-user-subscribe-form"],[1304407,".mailerlite-form"],[553896,".mailing-list-signup"],[106919,".mailingList--sidebar"],[7377416,".mailmunch-popover"],[15597895,".mailmunch-popover-content"],[7344793,".mailmunch-scrollbox"],[5697801,".mailpoet_form_popup_overlay"],[14812056,".main-footer__newsletter"],[3903346,".mainbody-subscribe"],[16611713,".markato-form-wrapper-tall"],[8933279,".mashicon-subscribe"],[7014134,".mb-newsletter,.md-newsletter"],[1908469,".mc-newsletter-alertes"],[9442883,".mc-newsletter-image"],[3768944,".mc-newsletter-signup"],[2321914,".memo-newsletter-widget"],[7554468,".mf-subscribe-widget"],[1574577,".ml-webforms-popup-overlay"],[9933928,".ml_signup_article"],[13821450,".mo-has-email.moOptinForm"],[14985565,".mo-optin-form-lightbox"],[12091052,".mobile-newsletter-mobile"],[70841,".mobile-subscribeBox"],[2418931,".mobile_newsletter"],[874700,".modal-email-widget"],[2079079,".modal-suggest-newsletter"],[4263054,".modal-suggest-newsletter-pro"],[12499192,".modal-wide-newsletter"],[10838061,".module-footer-newsletter-signup"],[7477325,".module-newsletter-subscribe"],[7078882,".moduletable_newsletterform"],[6808066,".molecule-newsletter"],[8326724,".mom-newsletter"],[10257617,".momizat-news_letter"],[14578228,".mt-subscribe"],[13285276,".mtbn-newsletter-bar"],[15549543,".multi-newsletter-signup"],[2703123,".mvp-post-sub-wrap"],[9425149,".naf-newsletter-footer"],[9670524,".nav-newsletter"],[7804865,".nav-newsletter-subsribe-form"],[3779315,".needsclick.amped-wrapper,.needsclick[aria-label][style]"],[15579484,".nesting_newsletter"],[11349274,".newLetterSectionBox"],[3073298,".new_newsletter_subscription"],[9089871,".newedge-newsletter"],[11550239,".newletter-main-wrapper"],[10417377,".newletter-sidebar"],[14931521,".newletter_container"],[10372291,".newletterpopupbox"],[1507064,".news-article__newsletter"],[12229169,".news-letter-widget"],[13162507,".newsLetter-subscription"],[928799,".newsLetter-subscription-wrapper"],[10904234,".newsLetterCon"],[9826395,".newsLetterHolder"],[10904759,".newsLetterSec"],[16748502,".newsLettetPb"],[16171496,".newsSignupRR"],[12229052,".news_letter_signup"],[8750906,".newsleterHome"],[14891307,".newsletter--article"],[12497421,".newsletter--blog-container"],[14797273,".newsletter--container"],[14048769,".newsletter--dark"],[16322889,".newsletter--floatfixed"],[12764021,".newsletter--footer"],[14900119,".newsletter--initial"],[16538065,".newsletter--logged-out"],[14797902,".newsletter-abo-header"],[7189124,".newsletter-acton-form-rightsidebar"],[8709133,".newsletter-advertisement"],[1678875,".newsletter-area"],[13506188,".newsletter-article-bottom"],[16758430,".newsletter-article-cta"],[13506195,".newsletter-article-footer"],[16149019,".newsletter-b2b"],[11009792,".newsletter-banner,.newsletterWrapper"],[13804181,".newsletter-banner-sidebar"],[16149064,".newsletter-bar"],[6993402,".newsletter-bar-right"],[7004419,".newsletter-block-new"],[8406760,".newsletter-block-wrapper"],[11010116,".newsletter-bottom"],[14453699,".newsletter-bottom-article"],[14897492,".newsletter-box-news"],[13810664,".newsletter-call-to-action"],[12764105,".newsletter-callout,.newsletter_callout"],[12764115,".newsletter-capture"],[1678381,".newsletter-card"],[16538247,".newsletter-cleverreach"],[16149062,".newsletter-col,.newsletter-pop,.newsletter-top"],[12764041,".newsletter-compact"],[12938850,".newsletter-content-page"],[16149085,".newsletter-cta"],[12764465,".newsletter-cta-box"],[12763990,".newsletter-desktop"],[8599173,".newsletter-diverter-card"],[11010559,".newsletter-dropin"],[8405684,".newsletter-element__form"],[11010057,".newsletter-fields"],[14049211,".newsletter-fixed"],[12871270,".newsletter-fixed-container"],[11009953,".newsletter-fly-in"],[16555229,".newsletter-flyout-wrap"],[1678451,".newsletter-foot"],[11010126,".newsletter-footer,.newsletter_footer,.newsletter_holder"],[14809576,".newsletter-footer-bar"],[13003023,".newsletter-footer__content"],[16424321,".newsletter-form-border"],[7005506,".newsletter-form-wrap"],[11265501,".newsletter-form__wrapper--inbodyContent"],[14048456,".newsletter-frame,.newsletter-promo"],[1678872,".newsletter-grab"],[14887050,".newsletter-headline"],[16602429,".newsletter-inline-flex"],[3740135,".newsletter-inline-newsletter-signup-wrapper"],[16602882,".newsletter-inline-unit"],[8625373,".newsletter-inline-widget"],[14494344,".newsletter-inline-wrapper"],[12997462,".newsletter-interstitial"],[14049099,".newsletter-intro"],[7010584,".newsletter-introtext"],[1053579,".newsletter-l"],[12761998,".newsletter-l-modal"],[8886684,".newsletter-layer-wrapper"],[14900099,".newsletter-lightbox"],[11010119,".newsletter-mobile"],[6891246,".newsletter-modal-background,.newsletter-popup-background"],[8378196,".newsletter-modal-overlay"],[3726569,".newsletter-modal__background"],[6830079,".newsletter-notification-box"],[16149081,".newsletter-opt"],[14048398,".newsletter-optin"],[12764541,".newsletter-overlay"],[13636442,".newsletter-overlay-footer"],[1678275,".newsletter-plug"],[11010114,".newsletter-pop-in"],[14049137,".newsletter-popin"],[12934560,".newsletter-popup-container"],[8382435,".newsletter-popup-desktop"],[14810189,".newsletter-popup-wrap"],[14049133,".newsletter-popup.kadence-conversion-popup"],[11010139,".newsletter-popups,.newsletter_rodape"],[11923485,".newsletter-promo-container"],[1679032,".newsletter-pure"],[1679029,".newsletter-push"],[786080,".newsletter-recomendation-wrapper"],[7002035,".newsletter-right-col"],[14799580,".newsletter-right-rail"],[14900105,".newsletter-rightbar"],[12764060,".newsletter-rotator,.newsletter-toaster"],[8736616,".newsletter-sb"],[7001017,".newsletter-shortcode"],[12764364,".newsletter-sidebar,.newsletter_sidebar"],[14111973,".newsletter-sidebar-widget"],[12810220,".newsletter-sidebar-wrapper"],[8511723,".newsletter-sign-up-block"],[11226945,".newsletter-sign-up-popup-mask"],[6887205,".newsletter-signup--homepage"],[10660597,".newsletter-signup-article-wrapper"],[8588061,".newsletter-signup-banner"],[12751583,".newsletter-signup-block"],[14799614,".newsletter-signup-box"],[6887395,".newsletter-signup-component"],[6887179,".newsletter-signup-container"],[3973420,".newsletter-signup-container2"],[14799608,".newsletter-signup-dnd"],[16460436,".newsletter-signup-form"],[16460498,".newsletter-signup-home"],[16460376,".newsletter-signup-link"],[14799601,".newsletter-signup-mod"],[8588521,".newsletter-signup-module"],[14093749,".newsletter-signup-overlay,.newsletter_signup_overlay"],[14093369,".newsletter-signup-primary"],[12750979,".newsletter-signup-promo,.newsletter_signup_promo"],[14093727,".newsletter-signup-sidebar"],[14799594,".newsletter-signup-vue"],[16459960,".newsletter-signup-wrap"],[14093626,".newsletter-signup-wrapper"],[12764379,".newsletter-signup2"],[11010049,".newsletter-simple"],[14896763,".newsletter-slideout"],[14049078,".newsletter-small"],[11010122,".newsletter-social,.newsletter_social"],[14453088,".newsletter-social-wrapper"],[11010235,".newsletter-sticky"],[13203708,".newsletter-sticky-block"],[7013663,".newsletter-stickybar"],[12102108,".newsletter-subscribe-panel"],[7498150,".newsletter-subscribe-popup-overlay"],[3006987,".newsletter-subscribe-section"],[12773914,".newsletter-subscription-popup"],[11009668,".newsletter-teaser"],[12764658,".newsletter-trigger"],[1678226,".newsletter-unit"],[1678116,".newsletter-wide"],[11010056,".newsletter-widget,.newsletter_widget"],[10118393,".newsletter-widget-outer-container"],[12790777,".newsletter-widget__wrapper"],[11980204,".newsletter-wrapper-sidebar"],[1678434,".newsletter-zone"],[4117792,".newsletter.cta,.newsletter.widget"],[15801936,".newsletter1"],[11010236,".newsletterArticle"],[8735348,".newsletterBg1"],[11009981,".newsletterCallout"],[12764416,".newsletterCassetto"],[16152105,".newsletterCont"],[12967425,".newsletterContentModule"],[8735301,".newsletterCta"],[16158903,".newsletterCtaContainer"],[12764033,".newsletterFloating"],[14158614,".newsletterFooter"],[13519520,".newsletterForm-exitIntent"],[16152205,".newsletterHead"],[14891198,".newsletterPlacement"],[14143381,".newsletterPrompt"],[11009697,".newsletterSidebar"],[12610708,".newsletterSidebarContainer"],[8669144,".newsletterSignup-wrapper"],[14144555,".newsletterSingle"],[8735830,".newsletterSub"],[6998272,".newsletterSubsModule"],[14894803,".newsletterSubscribe"],[3611704,".newsletterSubscribeContainer"],[16201321,".newsletterSubscription"],[14148972,".newsletterWidget"],[14893213,".newsletter__callout"],[14140372,".newsletter__card"],[7000483,".newsletter__headline"],[12764442,".newsletter__signup"],[14910367,".newsletter__slidein"],[14905619,".newsletter__wrapper"],[14811252,".newsletter_and_social"],[1660521,".newsletter_area"],[14790323,".newsletter_background"],[8857961,".newsletter_banner_inline"],[16152762,".newsletter_bar"],[8735967,".newsletter_bg"],[16159242,".newsletter_callout_box"],[14140289,".newsletter_email"],[6817487,".newsletter_footer_container"],[1660880,".newsletter_home"],[1660923,".newsletter_info"],[11010148,".newsletter_inline"],[14140858,".newsletter_promo"],[8588163,".newsletter_signup_footer"],[16460158,".newsletter_signup_unit"],[8587681,".newsletter_signup_widget"],[6197764,".newsletter_subscribe_banner"],[14140052,".newsletter_testo"],[8734283,".newsletterban"],[1053636,".newsletterbg"],[16151145,".newsletterbloc"],[14121539,".newsletterbottom"],[6988538,".newslettergf_wrapper"],[11010149,".newsletterlinebox"],[12764219,".newslettermultiple"],[14116034,".newsletteronpage"],[7075323,".newsletters-subscribe-form-ajax"],[13143398,".newsmail-signup"],[2497432,".newspack-inline-popup"],[9873150,".newspack-lightbox-placement-bottom"],[1552124,".newspack-newsletter-prompt-inline"],[5652484,".newspack-newsletter-prompt-overlay"],[2668093,".newspack-popup"],[4112732,".newssignup"],[434933,".ng-newsletter"],[5514547,".nl-newsletter_signup"],[12773249,".nl-signup-inline"],[10413413,".nl-signup-scrollbox"],[1740039,".nl-subscription-container"],[1746095,".nl-subscription-inarticle"],[11280761,".nlSignUpForm"],[9543669,".nlSubscribe"],[14528333,".nlWidgetMain2"],[2087072,".nls-subscribe"],[676356,".nlsubscribe-block"],[7379238,".node-newsletter-subscribe"],[10127991,".nws-cnt"],[7229330,".nyp-zephr-flyout"],[6856457,".o-Newsletter"],[12232791,".o-footer__newsletter"],[6760618,".o-footer__newsletter-signup"],[12541673,".o-newsletter"],[6199491,".o-site-footer__newsletter"],[15267985,".o-widget__newsletter"],[3317492,".ob-Newsletter"],[7288287,".oi-dailyalerts"],[8759001,".oi-dailyalerts-signup"],[1365651,".optin-monster"],[8371365,".optin-monster-api"],[11608299,".optin-monster-overlay"],[11517791,".optin-monster-saas-overlay"],[1441225,".optin-overlay"],[11111974,".ot-subscribe-widget"],[5694319,".p-footer-subscribe"],[11106016,".page--newsletter"],[10305388,".page-footer-signups"],[7066568,".pane-mailchimp-signup-newsletter"],[13912378,".pane-newsletter-modal"],[13186836,".pane-newsletter-newsletter-subscribe"],[12238392,".pane-newsletters"],[1190623,".pane-subscribe-box"],[8340290,".pane-subscribe-callout"],[4681335,".panel-newsletter-subscribe"],[2761023,".partial-cta-newsletter"],[11462377,".partial-newsletter"],[6893065,".pb-subscribe"],[7225122,".pgevoke-header-row2-right-newsletters"],[7303038,".piano--sidebar"],[7138144,".piano-inline-promo"],[7710436,".piano-newsletter"],[4958184,".piano_newsletter_large_widget-2"],[5733956,".polaris__newsletter"],[5649357,".polaris__newsletter--form"],[12348628,".popin-newsletter"],[16235984,".popinNewsletter-content"],[16235764,".popinNewsletter-overlay"],[3780420,".pre-footer-email-signup"],[7046926,".pre-footer-subscribe"],[9118464,".pre-header-subscribe"],[158572,".prism-newsletter-form"],[14479578,".promo-newsletter-dfp"],[10264922,".promo-newsletter-signup-2"],[7305017,".promo-newsletters"],[9061496,".r-footer--newsletter"],[4496253,".rc-newsletter-widget-new"],[11368870,".react-newsletter-overlay"],[3364360,".revue-embed-form"],[6215362,".rhs_subscribe_outer"],[10124878,".row__newsletter"],[16675576,".rst-newsletterbox"],[1890133,".sailthru-signup-widget"],[4276364,".saxon-subscribe-block"],[8330827,".sb-signup-container"],[1345065,".send-us-your-news-cta"],[1761322,".sendinblue-newsletter-mergefields"],[6699061,".sendinblue-signup-subscribe-form"],[3122991,".seva-overlay"],[10424240,".sfba_subscribe_form"],[6669867,".sfsi_subscribe_Popinner"],[920017,".shortcode-inline-newsletter"],[16064782,".shortcode-newsletter"],[11941183,".sib-newsletter-form"],[1272066,".sidebar--newsletter,.sidebar__newsletter"],[2398312,".sidebar-block-newsletter"],[6000948,".sidebar-mailchimp"],[8965165,".sidebar-newsletter-promo"],[9339661,".sidebar-newsticker-wrapper"],[1317222,".sidebar-signup-box"],[5213436,".sidebar-subscribe-box-wrapper"],[9911761,".sidebar-subscribe-container"],[9209827,".sidebar-subscribe-form"],[9034861,".sidebar-tile-subscribe"],[15122529,".sidebar-widget--subscribe"],[15137702,".sidebar-widget-newsletter"],[5989996,".sidebarNewsletter"],[1035594,".sidebarNewsletterAd"],[1415059,".sidebarSubscription"],[13454219,".sidebar__widget_subscribe"],[4669795,".sidebar_email_signup"],[8478142,".sidebar_newsletter_sign_up"],[5987887,".sidebar_subscribe"],[8117810,".sidebar_subscriber_body"],[6417690,".sidebarbox_newsletter"],[7414204,".signup-bar_wrapper"],[13566863,".signup-form--footer"],[13566657,".signup-form--header"],[7095797,".signup-newsletter-sidebar"],[7863745,".simplenews_custom-newsletter"],[4861477,".single-newsletter-signup"],[10316393,".single-post-newsletter"],[4560100,".single-sidebar--newsletter"],[14980863,".site-footer-newsletter"],[14997197,".site-footer__newsletter"],[10387930,".site-footer__section-newsletter"],[2437515,".skinny-sign-up"],[10311469,".skinny-signup"],[4684915,".slice-container-newsletterForm"],[3649886,".slide-in--newsletter"],[1548504,".slidedown-newsletter"],[11009521,".slider_newsletter-container"],[8330805,".slideup-newsletter-optin"],[2178778,".sm_newsletter"],[2941046,".smart-ajax-subscribe-form"],[2197758,".smartmag-widget-newsletter"],[7649581,".smile-prompt-frame-container"],[6608495,".sml_subscribe_widget"],[8679547,".ssb-subscribe-box"],[13416190,".st-newsletter-widget"],[11788100,".stickyNewsletterBar"],[8949433,".stickybar--newsletter"],[14795900,".subscribe-article-bottom"],[9746473,".subscribe-box-wide"],[9120677,".subscribe-box-wrapper"],[11360802,".subscribe-float"],[5152034,".subscribe-header-panel"],[10499283,".subscribe-newsletters-cta"],[2641191,".subscribe-popup-fade"],[2820420,".subscribe-popup-overlay"],[11348904,".subscribe-share"],[11348640,".subscribe-slide"],[3608377,".subscribe-widget-container"],[15344905,".subscribe-widget-sidebar"],[7539012,".subscribePopup"],[12698262,".subscribeShortcodeContainer"],[11363941,".subscribeWidget"],[10413910,".subscribeWidgetContainer"],[7539411,".subscribe_cont"],[3309740,".subscribe_footer"],[3324176,".subscribe_popup1"],[11229408,".subscription-box-cntr"],[9577465,".subscription-cta-widget"],[11284017,".subscription-form-container"],[8554867,".subscription-newsletter-button"],[180191,".subscription-popup-overlay"],[9818782,".subscription-promo"],[4877363,".subscription-toaster"],[2388187,".subscription-unit"],[14184252,".subscription_popup__wrapper"],[5937428,".suc-newsletter"],[1548306,".t-newsletter"],[15602691,".tds-newsletter"],[12933602,".teaser-newsletter"],[12956399,".tg-newsletter,.ts-newsletter"],[10528392,".tgc-newsletter-signup"],[14963256,".thb-newsletter-form"],[976582,".thim-newlleter-homepage"],[11559154,".tm-editoral-subscription"],[6378874,".tnp-subscription"],[1384705,".tnp-subscription-minimal"],[12746347,".tpd-newsletters-form"],[12960491,".ts-newslatter"],[6934089,".tsq_sailthru_newsletter_widget"],[5928094,".tt-newsletter-subscribe-footer"],[859700,".ttgFooterNewsletterFlyInWrapper"],[11086983,".tve-leads-widget"],[7355950,".type-newsletter-signup"],[1910870,".ue-c-article__newsletter-widget"],[2137326,".ue-c-newsletter-widget"],[7950293,".vc-email-subscribe__wrapper"],[9823903,".vc_newsletters_subscription"],[13951937,".vspl__section--newsletter"],[7490747,".wcpopupmodal-open"],[11947681,".wcpopupmodal-wrapper-open"],[7789706,".wide-newsletter"],[5095691,".wideNewsletterWrap"],[14232831,".widget--subscribe-inline"],[13636856,".widget-email-cta"],[1230609,".widget-embed.newsletter"],[3009734,".widget-newsletter-fter"],[11623473,".widget-newsletter-newsletter"],[5124928,".widget-newsletter-sign-up"],[12389417,".widget-newsletter-sign-up__form"],[16252577,".widget-newsletter-signup"],[16252475,".widget-newsletter-wrap-2"],[1612576,".widget-ngs-subscribe"],[13915731,".widget-subscribe"],[15067421,".widget-subscribe_widget"],[8271218,".widget-tsq_sailthru_newsletter_widget"],[666724,".widget__subscribe"],[15467350,".widget_blog_subscription"],[4556670,".widget_bs-newsletter-mailchimp"],[9896413,".widget_bs-subscribe-newsletter"],[12764592,".widget_email-subscribers-form"],[10918492,".widget_email_subscribe"],[269953,".widget_home_newsletter"],[2137830,".widget_jnews_module_element_ads"],[4675894,".widget_jtsvnewslettersignupwidget"],[9766178,".widget_mailchimpsf_widget"],[3650726,".widget_mailerlite_widget"],[7060926,".widget_mailpoet_form"],[4716866,".widget_mailster_signup"],[12312432,".widget_mc4wp_form_widget"],[6921992,".widget_mymail_signup"],[15645883,".widget_newsletter-pack"],[5125163,".widget_newsletter_manager"],[5125089,".widget_newsletter_sidebar"],[6324318,".widget_newsletter_widget"],[6078116,".widget_newsletters"],[5592141,".widget_newsletterwidget"],[11597535,".widget_newsletterwidgetminimal"],[3801284,".widget_nls_form_widget"],[13530684,".widget_ns_mailchimp"],[8427379,".widget_sailthru_signup_widget"],[12725717,".widget_signupwidget"],[491918,".widget_subscribe-form"],[6936047,".widget_subscribe_box"],[13108335,".widget_subscribe_widget"],[2061756,".widget_subscriber_widget"],[1448596,".widget_text_newsletter"],[15878334,".widget_woo_customsubscribewidget"],[7123278,".widget_woo_subscribe"],[13407197,".wp-block-ione-newsletter-sign-up"],[10307184,".wp-block-newsletter"],[10760876,".wp-block-signup-new"],[6914484,".wp-block-xwp-newsletter-subscription"],[7857955,".wp-nwletter-popup"],[1200604,".wp_email_capture_widget"],[6700396,".wpdev-newsletter-signup"],[1240357,".wpdiscuz-subscribe-bar"],[8839439,".wrap-newsletter"],[9719471,".wrapper-button-newsletter"],[4901155,".wrapper_suscribe_home"],[15246572,".yel-email-popup"],[11131117,".yel-popup-main-wrapper"],[3816077,".yikes-mailchimp-container"],[8134689,".yt-mailchimp-subscription-form-widget"],[2331971,".z-newsletter-signup-bottom"],[8587864,"div#NewsletterPromo"],[1900392,"div#inline-newsletter"],[12809685,"div#newsletter_signup_article"],[15273495,"div.aside-newsletter"],[11955691,"div.aside-newsletter-box"],[10508358,"div.bloc_newsletter"],[63145,"div.bs-mailchimp-newsletter"],[8736433,"div.c-newsletter-article"],[8511732,"div.newsletter-sign-up-popup"],[6199359,"div.newsletter-subscribe-widget"],[3306238,"div.newsletter-subscription-inline"],[3306360,"div.newsletter-subscription-module"],[11413390,"#ctl00_NewsletterFooter_UpdateForm"],[3141304,".markup.body > .subscribe-widget"],[5791117,".pc-reset > ._container_cjrxc_1"],[10158248,".single-post-container > .subscribe-footer"],[4841685,".cpcta-flyin"],[10517040,"#nlgate"],[3213355,"#nlgate-overlay-0"],[10099751,".newsletter-widget__new-story-page"],[1960695,".kl-private-reset-css-Xuajs1.needsclick"],[7527171,".drawer__header-container.is-moved-by-drawer"],[15062355,".adblock-whitelist-messaging__article-wrapper"],[12703215,".adblock-whitelist-messaging__wrapper"],[1899196,"#kanews-modal-adblock"]];

const genericSelectorMap = self.genericSelectorMap || new Map();

if ( genericSelectorMap.size === 0 ) {
    self.genericSelectorMap = new Map(toImport);
    return;
}

for ( const toImportEntry of toImport ) {
    const existing = genericSelectorMap.get(toImportEntry[0]);
    genericSelectorMap.set(
        toImportEntry[0],
        existing === undefined
            ? toImportEntry[1]
            : `${existing},${toImportEntry[1]}`
    );
}

self.genericSelectorMap = genericSelectorMap;

/******************************************************************************/

})();

/******************************************************************************/
