/* eslint no-unused-vars: 0 */
/* Website rules to remove warnings */
/* const rules {
  s = css rule
  j = commonJSHandler
  c = commonCSSRule
}
  const blockUrls = {
   q = false(default)/true include query string in matcher
   r = URL that you want to block.
   e = false(default)/ array of domains that you want to exclude
} */

const commonJSHandlers = {
  0: "0_defaultClickHandler",
  2: "2_sessionStorageHandler",
  3: "3_localStorageHandler",
  5: "5_clickHandler",
  6: "6_cookieHandler",
  8: "8_googleHandler",
};

const commons = {
  0: "#cookie,.cookie,#cookies,.cookies{display:none !important}",
  1: "body > div:not([id]):not([class]){display:none !important}",
  2: "html.noscroll{overflow:unset !important; padding-right:unset !important} .cookie{display:none !important}",
  3: "#gdpr,.gdpr,#gdpr-modal,.gdpr-modal,#GDPR,.GDPR{display:none !important}",
  4: "#consent,.consent{display:none !important}",
  5: ".elementor-popup-modal{display:none !important}",
  6: "#cookie-consent,.cookie-consent{display:none !important}",
  7: ".alert-dismissible,.alert-dismissable,.alert--dismissable,.pmd-alert-dismissible{display:none !important}",
  8: "#disclaimer,.disclaimer{display:none !important}",
  9: "#notification,.notification,#notifications,.notifications{display:none !important}",
  10: "#alert,.alert{display:none !important}",
  11: "#notice,.notice,#notices,.notices{display:none !important}",
  12: 'body > div:not([id]):not([class])[style*="fixed"],body > div:not([id]):not([class])[style*="absolute"]{display:none !important}',
  13: "#popup,.popup{display:none !important}",
  14: ".modal-backdrop,.veil{display:none !important} .modal-open{overflow:unset !important; padding-right: 0px !important}",
  15: "#toast,.toast{display:none !important}",
  16: "#privacy,.privacy{display:none !important}",
  17: "#overlay,.overlay{display:none !important}",
  18: '#lithium-root > [role="button"]{display:none !important}',
  19: '#SITE_ROOT ~ div[data-reactid*="siteAspectsContainer"]{display:none !important}',
  20: "#cookie-modal,.cookie-modal{display:none !important}",
  21: ".banner,#banner{display:none !important}",
  22: ".config-messages{display:none !important}",
  23: "#cnil,.cnil,#CNIL{display:none !important}",
  24: ".MuiSnackbar-root{display:none !important}",
  25: ".alert-info,.alert-warning,.alert-box{display:none !important}",
  26: "#privacy-policy,.privacy-policy,#privacyPolicy,.privacyPolicy{display:none !important}",
  27: ".ui-widget,.ui-widget-overlay{display:none !important}",
  28: "#root > footer ~ div{display:none !important}",
  29: ".uk-position-fixed{display:none !important}",
  30: "#cc{display:none !important}",
  31: "#cc_container,.cc_container{display:none !important}",
  32: "snack-bar-container{display:none !important}",
  33: "#cook,.cook{display:none !important}",
  34: "#privacy-popup,.privacy-popup{display:none !important}",
  35: "#fancybox-overlay,#fancybox-wrap{display:none !important}",
  36: ".configMessages{display:none !important}",
  37: "#message,.message{display:none !important}",
  38: "#system-message,#system-messages,#system-message-container{display:none !important}",
  39: "#cookies-modal,.cookies-modal{display:none !important}",
  40: ".uk-notification{display:none !important}",
  41: ".st_notification_wrap{display:none !important}",
  42: ".navbar-fixed-bottom{display:none !important}",
  43: ".sqs-announcement-bar{display:none !important}",
  44: ".head-page-information{display:none !important}",
  45: "body > form{display:none !important}",
  46: "#lbmodal-overlay,#lbmodal{display:none !important}",
  47: ".policy,#policy,.cpolicy{display:none !important}",
  48: ".activebar-container{display:none !important}",
  49: ".cdk-overlay-container{display:none !important}",
  50: "#container > footer ~ div{display:none !important}",
  51: "ticketswap-portal > ul{display:none !important}",
  52: ".flash-info{display:none !important}",
  53: ".popupbox{display:none !important}",
  54: "#hinweise{display:none !important}",
  55: ".clm{display:none !important}",
  56: "#chorus_notifiations{display:none !important}",
  57: "#SITE_ROOT ~ .siteAspectsContainer{display:none !important}",
  58: ".modal__bg{display:none !important}",
  59: "#modal-cookie,.modal-cookie,#modal-cookies,.modal-cookies{display:none !important}",
  60: ".ec-notices{display:none !important}",
  61: "#popup_wrapper{display:none !important}",
  62: ".confidentialite{display:none !important}",
  63: ".policy-window{display:none !important}",
  64: "#POPUPS_ROOT{display:none !important}",
  65: "#modal,.modal{display:none !important}",
  66: "#cbar{display:none !important}",
  67: "#info_message{display:none !important}",
  68: "#notice_bar{display:none !important}",
  69: ".snackbar{display:none !important}",
  70: ".alertbanner{display:none !important}",
  71: ".notification-wrapper{display:none !important}",
  72: ".cookies-wrapper{display:none !important}",
  73: "#info-bar{display:none !important}",
  74: "body > .c_128{display:none !important}",
  75: ".alert-info{display:none !important}",
  76: "#stickyFooter,.sticky-footer{display:none !important}",
  77: "#colorbox,#cboxOverlay{display:none !important}",
  78: ".notifications-manager{display:none !important}",
  79: ".JSWrapper{display:none !important}",
  80: ".header-banner{display:none !important}",
  81: "#cono{display:none !important}",
  82: ".v-overlay,.v-dialog__content{display:none !important}",
  83: "#toast-container{display:none !important}",
  84: "#cookieman-modal{display:none !important}",
  85: "html,body{overflow-y:unset !important; overflow:unset !important; position:unset !important}",
  86: "#notify-container{display:none !important}",
  87: "#bt_notification{display:none !important}",
  88: ".opt-in{display:none !important}",
  89: "#footerSlideContainer{display:none !important}",
  90: "#topbar{display:none !important}",
  91: "#polityka{display:none !important}",
  92: ".user-notes-notification{display:none !important}",
  93: "#cw{display:none !important}",
  94: "#balaMainContainer{display:none !important}",
  95: ".notice-wrap{display:none !important}",
  96: "#nomnom{display:none !important}",
  97: ".spu-box{display:none !important}",
  98: "#consent-modal{display:none !important}",
  99: "#modalCookies{display:none !important}",
  100: ".alert-warning{display:none !important}",
  101: "#jGrowl{display:none !important}",
  102: ".m1-footer-messages{display:none !important}",
  103: ".ui-widget-overlay{display:none !important}",
  104: "#data_protection{display:none !important}",
  105: "app-cookie{display:none !important}",
  106: "#cookieDiv{display:none !important}",
  107: "#cp{display:none !important}",
  108: ".CampaignType--floating{display:none !important}",
  109: ".noty_cont,.noty_bar{display:none !important}",
  110: ".cookie-consent-modal{display:none !important}",
  111: "#cookieModal{display:none !important}",
  112: ".cookie-container{display:none !important}",
  113: ".bloc-notifications{display:none !important}",
  114: "body > div[id][class]{display:none !important}",
  115: "#bottom-banner{display:none !important}",
  116: "#message_wrap{display:none !important}",
  117: "#note{display:none !important}",
  118: ".identity-noticebar-content{display:none !important}",
  119: ".euc{display:none !important}",
  120: "#warning{display:none !important}",
  121: ".top-header{display:none !important}",
  122: "#sbox-window,#sbox-overlay{display:none !important}",
  123: "#popup-container{display:none !important}",
  124: ".notification-bar{display:none !important}",
  125: ".floatFooter{display:none !important}",
  126: "#notify2{display:none !important}",
  127: "#footer{display:none !important}",
  128: ".region-disclaimer{display:none !important}",
  129: "#fixedBar{display:none !important}",
  130: "#cookie-b{display:none !important}",
  131: "#sticky-popup{display:none !important}",
  132: "#system-message{display:none !important}",
  133: "#hinweis{display:none !important}",
  134: "#coo{display:none !important}",
  135: "#privacy-info{display:none !important}",
  136: ".infobar{display:none !important}",
  137: ".rodo{display:none !important}",
  138: 'div[class*="CookieBar"]{display:none !important}',
  139: "#toolbar{display:none !important}",
  140: "#important-notice{display:none !important}",
  141: ".navbar-qards{display:none !important}",
  142: "#__next > div > .fixed{display:none !important}",
  143: 'body > div[style*="fixed"]{display:none !important}',
  144: 'body > div[class^="app"]{display:none !important}',
  145: "#outer-consent{display:none !important}",
  146: "#root > div:first-child{display:none !important}",
  147: "#lawdiv{display:none !important}",
  148: ".popup-overlay{display:none !important}",
  149: "#myModal{display:none !important}",
  150: ".disclamer{display:none !important}",
  151: "#CookieModal{display:none !important}",
  152: ".disclaimer-container{display:none !important}",
  153: ".coockies{display:none !important}",
  154: ".CA{display:none !important}",
  155: ".cookie__wrap{display:none !important}",
  156: "#wpfront-notification-bar-spacer{display:none !important}",
  157: ".consent-container,#consent-container{display:none !important}",
  158: ".in2-modal__blackbox{display:none !important}",
  159: "#__next > footer ~ div{display:none !important}",
  160: "#root > div > main ~ div{display:none !important}",
  161: ".modal--cookies{display:none !important}",
  162: ".ig_bottom{display:none !important}",
  163: ".dis_message{display:none !important}",
  164: "#cookie-law{display:none !important}",
  165: "#klaro{display:none !important}",
  166: "#cookiesModal{display:none !important}",
  167: ".cookie-box{display:none !important}",
  168: "main ~ div{display:none !important}",
  169: "body{touch-action:unset !important; overflow: unset !important; overscroll-behavior: unset !important;}",
};

const rules = {
  "google.com": { j: "8" },
  "youtube.com": {
    j: "5",
    s: "ytd-consent-bump-v2-lightbox,tp-yt-iron-overlay-backdrop,.consent-bump-lightbox{display:none !important}",
  },
  "consent.youtube.com": { j: "8" },
  "facebook.com": {
    s: 'div[data-cookiebanner="banner"],.hasCookieBanner #root ~ .accelerate,body[tabindex] > div > #viewport > div:first-child:not(#MChromeHeader),div[data-testid="cookie-policy-dialog"],div[data-testid="cookie-policy-manage-dialog"]{display:none !important}.uiLayer[data-testid="cookie-policy-banner"]{display:none !important}.hasCookieBanner > div{position:static !important}',
    j: "5",
  },
  "m.facebook.com": {
    s: 'div[data-testid="cookie-policy-manage-dialog"],body > div[id] ~ script ~ div{display:none !important}',
  },
  "fb.com": {
    j: "5",
    s: 'div[class*="cookieBanner"]{display:none !important}',
  },
  "messenger.com": { j: "5" },
  "instagram.com": { j: "5" },
  "linkedin.com": {
    s: '#js-notification-wrapper[role="alert"],.global-alert.global-alert--yield,#global-alert-queue,#artdeco-global-alert-container,.alert,#alert{display:none !important}',
  },
  "twitter.com": {
    j: "5",
    s: ".twtr-data-protection{display:none !important}",
  },
  "yahoo.com": {
    s: '#guce-inline-consent-iframe,#gdpr[style*="padding"],#y-shade,#applet_p_50000174,.tdv2-applet-nagbar,.login-body + .login-footer{display:none !important}',
  },
  "guce.yahoo.com": { j: "5" },
  "consent.yahoo.com": { j: "5" },
  "duckduckgo.com": {
    s: ".badge-link.ddg-extension-hide{display:none !important}",
  },
  "msn.com": { j: "5" },
  "bing.com": {
    s: '#bnp_cookie_banner[aria-modal="false"],#bnp_ttc_div,#thp_notf_div,.b_hide.bnp_ttc,#t_termsInfo{display:none !important}#hp_cellCenter{padding-top:0 !important}',
    j: "5",
  },
  "microsoft.com": {
    s: "#multy-lang-betanotifier,body > .row-fluid:first-child,#notificationBanner,#ux-banner,#h_popup{display:none !important}#megabladeIframe{top:0 !important}#BodyBackground{border-top:none !important}",
  },
  "ask.com": { s: "#ccbar,#cp-banner{display:none !important}" },
  "ted.com": { c: 1 },
  "google.co.uk": { j: "8" },
  "google.it": { j: "8" },
  "google.at": { j: "8" },
  "google.es": { j: "8" },
  "google.ee": { j: "8" },
  "google.pl": { j: "8" },
  "google.cz": { j: "8" },
  "google.dk": { j: "8" },
  "google.ie": { j: "8" },
  "google.fr": { j: "8" },
  "google.si": { j: "8" },
  "google.hu": { j: "8" },
  "google.sk": { j: "8" },
  "google.se": { j: "8" },
  "google.fi": { j: "8" },
  "google.lt": { j: "8" },
  "google.gr": { j: "8" },
  "google.ro": { j: "8" },
  "google.bg": { j: "8" },
  "google.be": { j: "8" },
  "google.hr": { j: "8" },
  "google.de": { j: "8" },
  "google.pt": { j: "8" },
  "google.nl": { j: "8" },
  "google.no": { j: "8" },
  "google.is": { j: "8" },
  "google.lu": { j: "8" },
  "google.cl": { j: "8" },
  "google.lv": { j: "8" },
  "google.ch": { j: "8" },
  "google.ba": { j: "8" },
  "google.co.ve": { j: "8" },
  "google.com.au": { j: "8" },
  "google.ae": { j: "8" },
  "google.lk": { j: "8" },
  "google.ru": { j: "8" },
  "google.co.th": { j: "8" },
  "google.co.in": { j: "8" },
  "google.com.ph": { j: "8" },
  "google.com.br": { j: "8" },
  "google.com.hk": { j: "8" },
  "google.ca": { j: "8" },
  "google.co.jp": { j: "8" },
  "google.ac": { j: "8" },
  "google.ms": { j: "8" },
  "google.je": { j: "8" },
  "google.com.ag": { j: "8" },
  "google.com.mx": { j: "8" },
  "google.com.ua": { j: "8" },
  "google.com.eg": { j: "8" },
  "google.cat": { j: "8" },
  "google.co.il": { j: "8" },
  "google.com.sg": { j: "8" },
  "google.am": { j: "8" },
  "google.com.ar": { j: "8" },
  "google.fm": { j: "8" },
  "google.as": { j: "8" },
  "google.li": { j: "8" },
  "google.al": { j: "8" },
  "google.cf": { j: "8" },
  "google.sh": { j: "8" },
  "google.com.tr": { j: "8" },
  "google.co.kr": { j: "8" },
  "google.com.na": { j: "8" },
  "google.com.sl": { j: "8" },
  "google.co.za": { j: "8" },
  "google.co.id": { j: "8" },
  "google.com.pe": { j: "8" },
  "google.co.nz": { j: "8" },
  "google.mv": { j: "8" },
  "google.rs": { j: "8" },
  "google.pn": { j: "8" },
  "google.com.tw": { j: 8 },
  "google.gg": { j: 8 },
  "google.vg": { j: 8 },
  "google.co.ma": { j: 8 },
  "google.com.uy": { j: 8 },
  "google.com.cy": { j: 8 },
  "google.com.ai": { j: 8 },
  "google.cm": { j: 8 },
  "toldosalsina.com": { s: "#aviso{display:none !important}" },
  "barcelona.cat": { s: "#bcn-ccwr{display:none !important}" },
  "barclays.com": { s: ".dialogMask{display:none !important}" },
  "britannia.co.uk": { s: "#noticePanel{display:none !important}" },
  "hostgator.com": { s: "#alertBar{display:none !important}" },
  "theregister.co.uk": { s: "#RegCTBWF{display:none !important}" },
  "rapturetv.com": { s: "#apDiv1{display:none !important}" },
  "civilsociety.co.uk": { s: ".announcement-banner{display:none !important}" },
  "cofunds.co.uk": {
    s: "#idrMasthead .idrPageRow .smContainer{display:none !important}",
  },
  "channelregister.co.uk": { s: "#RegCCO{display:none !important}" },
  "ordnancesurvey.co.uk": { s: "#messages{display:none !important}" },
  "hrportfolio.hr": { s: "#kolac{display:none}" },
  "ecdl.hr": { s: "#admin_sys_notif{display:none !important}" },
  "sajmovi.eu": { s: "#mBox1,#mBox1+div{display:none !important}" },
  "poba.hr": { s: "#meerkat-wrap{display:none !important}" },
  "heinz.co.uk": { c: 1 },
  "tvlicensing.co.uk": { s: "#blq-global{display:none !important}" },
  "esure.com": { s: "#slideMenu{display:none !important}" },
  "mggp.com.pl": { c: 42 },
  "neckermann.com": {
    s: "#st_popup,#st_overlay,#ewcm_container{display:none !important}",
  },
  "thejournal.ie": { c: 86 },
  "dba.dk": { c: 1 },
  "gosc.pl": { c: 12 },
  "bilbasen.dk": { c: 1 },
  "stargreen.com": { c: 1 },
  "wrzucacz.pl": { s: "#logo .info{display:none !important}" },
  "wattsindustries.com": { s: "#header1_overlay2{display:none !important}" },
  "mistrzowie.org": { c: 12 },
  "muddymatches.co.uk": { j: "5" },
  "korwin-mikke.pl": { c: 1 },
  "element14.com": { s: ".e14-cookie-directive{display:none !important}" },
  "oushop.com": { c: 1 },
  "mocnopomocni.pl": { c: 1 },
  "instal.si": {
    s: "body > img,.urejanjecenter,.urejanjecenter + table{display:none !important}",
  },
  "megashopbot.com": { s: "#alertBar{display:none !important}" },
  "daft.ie": {
    s: "#notify-container,.strapline-container{display:none !important}",
  },
  "vegetus.nl": { s: "#tracking{display:none !important}" },
  "thetoyshop.com": { s: "#entCNDiv{display:none !important}" },
  "direct-croatia.com": { s: "#site_nt{display:none !important}" },
  "odjechani.com.pl": { s: ".guest_warn{display:none !important}" },
  "kulturstyrelsen.dk": { c: 46 },
  "bosw.pl": { c: 13 },
  "zend.com": {
    s: ".ui-dialog.ui-widget.ui-widget-content.ui-corner-all.ui-front.ui-draggable.ui-resizable{display:none !important}",
  },
  "clinique.co.uk": { c: 87 },
  "vente-privee.com": {
    s: ".showCookiesBanner #headerWrapper{top:0 !important}.cookiesTxt{display:none !important}",
  },
  "rk.dk": { c: 46 },
  "krsystem.pl": { c: 33 },
  "shelldriversclub.co.uk": { s: "#modal_container{display:none !important}" },
  "boards.ie": { c: 86 },
  "katowice-airport.com": { c: 1 },
  "oferia.pl": { c: 1 },
  "grafoteka.pl": { s: "#info-container{display:none !important}" },
  "shopusa.com": { s: "body > .box{display:none !important}" },
  "ohra.nl": { s: "#wrapper-overlay{display:none !important}" },
  "dynos.es": {
    s: "#cuerpo > div:not([id]):not([class]){display:none !important}",
  },
  "pobieralnia.org": { s: "#close{display:none !important}" },
  "amadeus.com": {
    s: ".wayfinder-component,.country-lightbox.cookies{display:none !important}",
  },
  "fiskarsgroup.com": { s: ".q_cookies{display:none !important}" },
  "androidmagazine.pl": { c: 1 },
  "smulweb.nl": { s: ".accept_container{display:none !important}" },
  "epiotrkow.pl": { s: ".user_politic_pop{display:none !important}" },
  "bygningskultur2015.dk": { c: 46 },
  "racjonalista.pl": { s: "#_ci{display:none !important}" },
  "xtremmedia.com": { s: "#mensacok{display:none !important}" },
  "herbaciani.pl": { c: 1 },
  "waw.pl": {
    s: "#wip.stability,.alert-warning,.komunikat{display:none !important}",
  },
  "costco.co.uk": { s: ".site-messages-container{display:none !important}" },
  "adverts.ie": {
    s: "#notify-container-sticky-wrapper{display:none !important}",
  },
  "siemens.pl": { s: ".alert.block.show,.PopupDiv{display:none !important}" },
  "open.fm": { j: "5" },
  "laznianowa.pl": { c: 1 },
  "swiatnauki.pl": { s: "#menu{display:none !important}" },
  "oxfordshire.gov.uk": {
    s: ".occlss-alert--cookiepopup{display:none !important}",
  },
  "mtvmobile.nl": {
    s: "#exposeMask,#TMobile_nl_WebPortals_UI_PageComponents_CookieSettingsOverlay_CookieSettingsOverlayController_OverlayRootDiv{display:none !important}",
  },
  "dropbox.com": {
    s: "#consent-iframe{display:none !important}",
  },
  "legolas.pl": { s: "#kuki{display:none !important}" },
  "slke.dk": { c: 46 },
  "ists.pl": { s: ".polityka{display:none !important}" },
  "fora.pl": { s: ".pp-t-a-c{display:none !important}" },
  "petardas.com": {
    s: 'body > div[style*="color:white"],body > div:not([id]) > div[style*="color:white"]{display:none !important}',
  },
  "winrar.es": { s: "#ckwarn{display:none !important}" },
  "racunovodja.com": { s: ".polprosojno{display:none !important}" },
  "reviewcentre.com": { s: "#growlcontainer{display:none !important}" },
  "pensioenleeftijdberekenen.nl": { s: "#ckpol{display:none !important}" },
  "toysrus.es": { c: 1 },
  "cepsa.com": { s: ".b-home-modal{display:none !important}" },
  "omegasoft.pl": { s: ".ui-dialog{display:none !important}" },
  "mpolska24.pl": { s: ".infoBox{display:none !important}" },
  "smakizycia.pl": { c: 73 },
  "tabletsmagazine.nl": { c: 88 },
  "szpital-chrzanow.pl": { s: ".warp_top_message{display:none !important}" },
  "automapa.pl": {
    s: 'body > div[style*="fixed"],.error.rounded{display:none !important}',
  },
  "zwangerschapspagina.nl": { j: "5" },
  "szkolkikornickie.pl": { c: 44 },
  "kikocosmetics.es": { s: ".mod-notification{display:none !important}" },
  "shellsmart.com": { s: "#modal_container{display:none !important}" },
  "webm2.dk": { s: "#footer_notification{display:none !important}" },
  "storm24.pl": { c: 13 },
  "weespreventief.nl": { c: 13 },
  "danskernesdigitalebibliotek.dk": { c: 46 },
  "24hgold.com": { s: ".divTop{display:none !important}" },
  "policja.pl": { s: ".informationBar,.JSWrapper{display:none !important}" },
  "ford-esklep.pl": { s: "#box_alert{display:none !important}" },
  "healthcare.siemens.dk": { c: 10 },
  "centraalbeheer.nl": { c: 31 },
  "layar.com": { s: ".remarketing-banner{display:none !important}" },
  "wiz.pl": { s: "#menu{display:none !important}" },
  "cartoonnetwork.com": { s: "#tos-bar{display:none !important}" },
  "testigo.pl": { s: "#cp_wrap{display:none !important}" },
  "wiara.pl": { c: 12 },
  "tyrdanmark.dk": { s: "#C46703f08cookie{display:none !important}" },
  "markgum.com.pl": { s: 'body > div[id=""]{display:none !important}' },
  "kopland.pl": { c: 37 },
  "wampirki.com": { j: "5" },
  "zorgbelang-noordholland.nl": {
    s: ".telecom-tracking-dialog{display:none !important}",
  },
  "unizg.hr": { s: "#cms_area_admin_bar{display:none !important}" },
  "4hifi.pl": { s: ".myModal-box{display:none !important}" },
  "office.com": {
    s: "#BannerContainer,#h_popup,.sortable-control > .row-fluid.pmg-txt-align-center.pmg-grid-content-no-padding.pmg-grid-content{display:none !important}",
  },
  "aktieinfo.net": { s: "#eufis{display:none !important}" },
  "sainsburysbank.co.uk": {
    s: ".showing-notification #shell{margin-top:0 !important}",
  },
  "ksiegaimion.com": { s: "#euci{display:none !important}" },
  "ecfr.eu": { s: "#footerr{display:none !important}" },
  "lrb.co.uk": {
    s: "#wrapper > div:not([id]):not([class]){display:none !important}",
  },
  "kunst.dk": { c: 46 },
  "oesterreichinstitut.cz": { s: "#cook-cont{display:none !important}" },
  "foto4u.pl": { c: 73 },
  "napovednik.com": { c: 10 },
  "maty.com": { s: ".banner-wrapper{display:none !important}" },
  "skitour.fr": { s: "#coo_aut{display:none !important}" },
  "vttour.fr": { s: "#coo_aut{display:none !important}" },
  "olsztyn.com.pl": { s: ".rodoaccept{display:none !important}" },
  "sondagenational.com": { s: "#legalCookies{display:none !important}" },
  "truste.com": { j: "5" },
  "love.dk": { s: "#scw{display:none !important}" },
  "sodisce.si": { c: 38 },
  "zepass.com": { c: 113 },
  "reactor.pl": { s: "#einfo{display:none !important}" },
  "energiemoinschere.fr": { s: "#headband{display:none !important}" },
  "mutuelle.com": { c: 33 },
  "zombiearmy.com": { s: ".warning{display:none !important}" },
  "buziak.pl": { s: "#cffc{display:none !important}" },
  "hop.com": { s: "#cnil-layer{display:none !important}" },
  "notre-planete.info": { s: "#npimsg{display:none !important}" },
  "kingston.com": { s: "#policy_message{display:none !important}" },
  "lomza.pl": {
    s: "body.polityka-cookies{background-position:center top !important;margin-top:0 !important}",
  },
  "zeroturnaround.com": { s: ".hud{display:none !important}" },
  "pewnykantor.pl": { s: "#cu_bar{display:none !important}" },
  "hth.dk": { s: ".nb-message{display:none !important}" },
  "hi-tec.com.pl": { c: 0 },
  "unisys.com": { s: "#AlertWrapper{display:none !important}" },
  "thelawpages.com": { s: "#terms{display:none !important}" },
  "yachtbasen.com": { s: "body > .hidden-print{display:none !important}" },
  "nba.com": { s: "#nba_tos{display:none !important}" },
  "danmarklaeser.dk": { c: 46 },
  "aso.fr": { c: 62 },
  "blogs-r.com": { c: 12 },
  "cio-online.com": {
    s: "#didomi-popup{display:none !important} .didomi-popup-open{overflow: unset !important}",
  },
  "grandeavenue.fr": { s: ".fixedBanner{display:none !important}" },
  "motomoto.pl": { s: "#itlbox{display:none !important}" },
  "bluearan.co.uk": { s: "#slider{display:none !important}" },
  "themudday.com": { c: 62 },
  "zien.tv": { c: 66 },
  "talerzpokus.tv": { c: 12 },
  "radioluisteren.fm": { c: 66 },
  "aceprensa.com": { s: "#anuncio{display:none !important}" },
  "off-road.pl": { s: "#popslide{display:none !important}" },
  "mininstitution.dk": { c: 12 },
  "ihg.com": { s: "#topSpot,.mod-modal{display:none !important}" },
  "fora.se": { c: 10 },
  "mediametrie.fr": { s: "#cooks{display:none !important}" },
  "unoform.dk": { s: ".notificationbar{display:none !important}" },
  "lotnictwo.net.pl": { s: "#navbar_notice_123{display:none !important}" },
  "environmentlaw.org.uk": { s: "#nf_htmlonly{display:none !important}" },
  "werkenbijstayokay.com": { s: "#sliderWrap{display:none !important}" },
  "sfinks.org.pl": { c: 1 },
  "macrojuegos.com": { s: "#popupmsg_wrapper{display:none !important}" },
  "glyphweb.com": { c: 12 },
  "bitmarket24.pl": { c: 10 },
  "merixstudio.pl": { c: 37 },
  "purinaonline.es": { s: "#__afpc{display:none !important}" },
  "selexion.be": { s: "#splash_footer{display:none !important}" },
  "kinoteka.pl": { c: 1 },
  "minmyndighetspost.se": { s: ".alertWrap{display:none !important}" },
  "minameddelanden.se": { s: ".alertWrap{display:none !important}" },
  "thagson.com": { s: ".init_message{display:none !important}" },
  "licytacje.komornik.pl": {
    s: '#sign_up,body > div[style*="margin-top: 100"]{display:none !important}',
  },
  "sprezyny-strozyk.pl": { c: 44 },
  "emagister.fr": { s: ".fixed-footer{display:none !important}" },
  "ulabox.com": { s: ".flash-message-bar{display:none !important}" },
  "bloodhoundssc.com": { s: ".ccwrap{display:none !important}" },
  "malygosc.pl": { c: 12 },
  "lodz.pl": {
    s: '#stpdueckmsg,.sticked-widgets__widget-trigger[href*="ochrona-danych-osobowych"]{display:none !important}',
  },
  "cieem.net": { c: 1 },
  "brouwland.com": { s: ".notification-top{display:none !important}" },
  "podatnik.info": {
    s: ".p14-footer > div:not([class]){display:none !important}",
  },
  "survey-remover.com": { c: 12 },
  "clubhyundai.es": { c: 114 },
  "biznes2biznes.com": { s: "#stickynote2{display:none !important}" },
  "droitshumains.fr": {
    s: "#unblcn{display:none !important}body{margin-top:0 !important}",
  },
  "morrisonsislistening.co.uk": { j: "5" },
  "mundosexanuncio.com": { s: "#alegal{display:none !important}" },
  "avogel.dk": { s: ".slideOutContainer{display:none !important}" },
  "sizzle.co.uk": { c: 10 },
  "mysnapp.co.uk": { s: ".cookies-content{display:none !important}" },
  "botrans.eu": { s: "#c_tlo{display:none !important}" },
  "minigamers.com": { s: "#popupmsg_wrapper{display:none !important}" },
  "runinreims.com": { c: 62 },
  "ogaming.tv": { c: 42 },
  "fitzpatrickreferrals.co.uk": { s: "#hellobar{display:none !important}" },
  "xuletas.es": { s: "#privacy_w{display:none !important}" },
  "konkolnieruchomosci.pl": { c: 44 },
  "otabletach.pl": { s: "#cop{display:none !important}" },
  "kikocosmetics.com": { s: ".mod-notification{display:none !important}" },
  "parkguell.cat": { s: "#fixdiv{display:none !important}" },
  "dvdfr.com": { s: "#dvdfrCnil{display:none !important}" },
  "digitenne.nl": { c: 1 },
  "macquarie.com": { s: "#alert-first{display:none !important}" },
  "kanpai.fr": { s: "#f_r_e_e{display:none !important}" },
  "motonotes.pl": { c: 1 },
  "weber.dk": { c: 52 },
  "fifa.com": { j: "5" },
  "seges.dk": { s: "#vcc_container{display:none !important}" },
  "die-linke.de": { c: 8 },
  "net.hr": { c: 8 },
  "dielinke.berlin": { c: 8 },
  "opera-comique.com": { c: 8 },
  "valtra.de": { c: 8 },
  "fellow.pl": { c: 1 },
  "salonroman.pl": { c: 1 },
  "pss-archi.eu": { s: "#miam_div{display:none !important}" },
  "lafi.fr": { s: ".nota{display:none !important}" },
  "flatme.it": { s: "#ic{display:none !important}" },
  "123partyshop.nl": { c: 1 },
  "volkswagen.com": {
    s: "#vwd4_m509,.system-notification{display:none !important}",
  },
  "visitleevalley.org.uk": { s: "#howdy{display:none !important}" },
  "nageurs.com": { c: 1 },
  "pusc.it": { s: "#pixelfabrica-cs-banner{display:none !important}" },
  "agroterra.com": { c: 10 },
  "doka.com": { j: "5" },
  "allekoszyk.pl": {
    s: '#allekoszyk > div[style*="fixed"]{display:none !important}',
  },
  "nutrimuscle.com": { s: "#messageBox{display:none !important}" },
  "forumcommunity.net": { s: ".note,.jnote{display:none !important}" },
  "londontechweek.com": { s: ".festival-cookie{display:none !important}" },
  "ragepluginhook.net": { j: "5" },
  "ondarock.it": { c: 115 },
  "fcarreras.org": { s: ".NoticesBox{display:none !important}" },
  "homecinemamagazine.nl": { c: 88 },
  "bahnhof.se": { s: ".top-line-block{display:none !important}" },
  "southwestcoastpath.org.uk": { s: ".roar-body{display:none !important}" },
  "jal.com": {
    s: "#JS_ciBox,#JS_ciBox_filter,#JS_ciBox_filter_iframe,#JS_ciBox_style{display:none !important}",
  },
  "cochranelibrary.com": {
    s: ".system-message-container{display:none !important}",
  },
  "lindex.com": { c: 9 },
  "klockolandia.pl": { c: 1 },
  "smhi.se": { s: ".polopolyNotification{display:none !important}" },
  "magazynpracy.pl": { c: 1 },
  "devilpage.pl": { c: 1 },
  "laga.se": { s: ".site-info-message{display:none !important}" },
  "elektrozysk.pl": { c: 1 },
  "krakow.pl": {
    s: 'body > #ci[style*="fixed"],body > #kuki,body > #mainCookie{display:none !important}',
  },
  "bywajtu.pl": { s: "#co15ie87a{display:none !important}" },
  "tecnun.es": { s: "#alertbar{display:none !important}" },
  "invita.dk": { s: ".notificationbar{display:none !important}" },
  "juzaphoto.com": { s: ".s_bluebox{display:none !important}" },
  "telesystem-world.com": { s: "#cover,#cookies{display:none !important}" },
  "holding-graz.at": { s: ".blockOverlay{display:none !important}" },
  "efax.fr": { s: ".stickyFooter{display:none !important}" },
  "mountain.es": { s: "#messagebar{display:none !important}" },
  "dictzone.com": { s: "#ac{display:none !important}" },
  "qrzcq.com": { c: 1 },
  "stoeger.net": { c: 43 },
  "gore-ljudje.net": { c: 62 },
  "winsornewton.com": { s: "#PECR{display:none !important}" },
  "flugladen.de": { s: ".notificationContainer{display:none !important}" },
  "serwiskarcher.pl": { s: ".config-messages{margin-top:-35px}" },
  "lca.pl": { s: "#popupDiv{display:none !important}" },
  "baulinks.de": { c: 1 },
  "estos.de": { s: "#cpol-banner{display:none !important}" },
  "spreaker.com": { s: "#ly_flash_message{display:none !important}" },
  "auxmp.com": { s: ".policy-label{display:none !important}" },
  "linuxportal.pl": { c: 1 },
  "modeoutlet.nl": { c: 13 },
  "9maand.be": { s: ".flashup{display:none !important}" },
  "blogfree.net": { s: "body > .jnote{display:none !important}" },
  "browar.biz": {
    s: '.page > div > div[style*="gray"]{display:none !important}',
  },
  "ents24.com": { s: ".cookie-nudge{display:none !important}" },
  "xe.gr": { s: ".google_diaclaimer{display:none !important}" },
  "newhallhospital.co.uk": { c: 53 },
  "jotti.org": { c: 7 },
  "ikalender.se": {
    s: 'body > center > table[style*="F0F0F0"]{display:none !important}',
  },
  "milan7.it": { s: "#site-content > .row > h2{display:none !important}" },
  "polomarket.pl": { c: 1 },
  "les-champignons.com": { s: "#pub{display:none !important}" },
  "beko.es": { s: ".sayfaIcDiv .row300{display:none !important}" },
  "centrumpiwowarstwa.pl": {
    s: '.page > div > div[style*="gray"]{display:none !important}',
  },
  "parliamentlive.tv": { j: "5" },
  "superstart.se": {
    s: 'body > div > div > div[style*="777"]{display:none !important}',
  },
  "discounto.de": { c: 7 },
  "prezzoforte.it": { s: "#bottombar{display:none !important}" },
  "toysrus.pt": { c: 1 },
  "paivyri.fi": {
    s: 'body > center > table[style*="width:100%"]{display:none !important}',
  },
  "giochigratisonline.it": {
    s: "#boxRichiesta{display:none !important}body{background-position:0 0;margin-top: 0}",
  },
  "netcarshow.com": { s: "#cNag{display:none !important}" },
  "euromaster.de": { s: "#lytic_layer,#lytic_askbox{display:none !important}" },
  "netvaerkslokomotivet.dk": { s: "#ck_row{display:none !important}" },
  "codziennikfeministyczny.pl": {
    s: "#bazinga-muffin-container{display:none !important}",
  },
  "box10.com": { s: "#cwarn-box{display:none !important}" },
  "costaclub.com": { s: ".alertMessaging{display:none !important}" },
  "stamboomonderzoek.com": { c: 45 },
  "kalendarzswiat.pl": { s: "#consent_box_wrapper{display:none !important}" },
  "muzyczneradio.pl": { j: "5" },
  "saltogpeber.dk": {
    s: '.push-up[data-id="sp-cookie"]{display:none !important}',
  },
  "linkem.com": { c: 115 },
  "fiskars.de": {
    s: "body.s-show-cookie-consent .m-navigation.s-show .desktop{top:0 !important}",
  },
  "stubhub.de": { s: "#banner-container{display:none !important}" },
  "360qpon.it": { c: 89 },
  "medarbejdernet.dk": { s: "#modalLayer{display:none !important}" },
  "mdsrl.it": { j: "5" },
  "qr.cz": { s: "#eu-fck{display:none !important}" },
  "leyprodatos.es": { s: "#cs_informationBar{display:none !important}" },
  "ktotv.com": { s: ".headline{display:none !important}" },
  "sallyx.org": { s: ".topInfo{display:none !important}" },
  "wowza.com": { s: "#ck_pu{display:none !important}" },
  "litmind.com": { s: "#bottom_notice{display:none !important}" },
  "costacroisieres.fr": { s: ".alertMessaging{display:none !important}" },
  "huaweivenicemarathon.it": { s: "#cp-cont{display:none !important}" },
  "latagliatellayyo.es": { j: "5" },
  "pyrex.fr": { s: "#popajax{display:none !important}" },
  "eservice.pl": { s: "#zwcc{display:none !important}" },
  "discountoffice.nl": { c: 42 },
  "vijfhart.nl": { j: "5" },
  "saperesalute.it": { j: "5" },
  "uctovani.net": { c: 116 },
  "mangaclassics.mboards.com": { c: 114 },
  "eurojackpot.it": { s: ".popup-view.modal{display:none !important}" },
  "freo.nl": { j: "5" },
  "timing.pt": { c: 47 },
  "swiat-agd.com.pl": { c: 1 },
  "sunday.dk": { j: "5" },
  "teamers.com": { j: "6" },
  "fiatklubpolska.pl": {
    s: "#navbar_notice_1.restore{display:none !important}",
  },
  "szlakpiastowski.com.pl": { c: 44 },
  "lainox.it": {
    s: ".background_overlay,#overlay_form{display:none !important}",
  },
  "opel-sklep.com": {
    s: "#simple-modal-overlay,#simple-modal{display:none !important}",
  },
  "filminstitutet.se": { s: ".info-banner{display:none !important}" },
  "chateauxhotels.com": { s: "#notificationBar{display:none !important}" },
  "distritopostal.es": { s: "#ecl-container-box{display:none !important}" },
  "soeren-hentzschel.at": { s: "#storage-notice{display:none !important}" },
  "nas-forum.com": { s: ".ipsMessage_error{display:none !important}" },
  "fundedbyme.com": { s: ".pageNotification{display:none !important}" },
  "blasapisguncuevas.blogcindario.com": { c: 114 },
  "smgcookies.nl": { j: "5" },
  "intrage.it": { s: ".BoxPrivacy{display:none !important}" },
  "ingemecanica.com": { s: ".encabez{display:none !important}" },
  "fxsolver.com": { s: "#tframe{display:none !important}" },
  "infiniti.nl": { c: 74 },
  "infiniti.de": { c: 74 },
  "nkd.com": { s: "#DIV_1{display:none !important}" },
  "eksiegarnia.pl": { s: "#kuki{display:none !important}" },
  "dailyedge.ie": { c: 86 },
  "blauarbeit.de": { s: "#messages-container{display:none !important}" },
  "email.it": {
    s: '#inckem,#FrstCksDiv,body > div:not([id]):not([class])[style*="000"]{display:none !important}',
  },
  "e-lawresources.co.uk": { s: ".topbarBox{display:none !important}" },
  "rast.hr": { s: "#blokDiv{display:none !important}" },
  "livescores.com": { s: ".info-msg{display:none !important}" },
  "akcneletaky.sk": { s: "#infoCoo{display:none !important}" },
  "paysdelaloire.fr": { s: ".tx-pnfcnil{display:none !important}" },
  "ingyen-van.hu": { s: "#figyu{display:none !important}" },
  "steffen-hanske.de": { c: 117 },
  "infiniti.co.uk": { c: 74 },
  "firstsave.co.uk": { s: ".msgBox p{display:none !important}" },
  "hrportal.hu": { s: "#fixdivgoogle{display:none !important}" },
  "miplo.pl": { s: ".error.rounded{display:none !important}" },
  "drivepad.fr": { c: 16 },
  "the42.ie": { c: 86 },
  "hpobchod.sk": { s: "#hpmGmtT{display:none !important}" },
  "vas.com.pl": { c: 1 },
  "federacja-konsumentow.org.pl": { s: "#cu_bar{display:none !important}" },
  "bancomparador.com": { s: "#cuki{display:none !important}" },
  "amaterky.sk": { c: 1 },
  "previ-direct.com": { c: 10 },
  "o2.pl": { j: "5" },
  "kodilive.eu": { s: "#claw{display:none !important}" },
  "areatour.pl": { c: 90 },
  "userbenchmark.com": { s: "#notForm{display:none !important}" },
  "kinonh.pl": { s: "#div_ac{display:none !important}" },
  "novatech.com.pl": { s: "#cooki{display:none !important}" },
  "st-ab.nl": {
    s: 'table[width="941"] td[height="38"][width="100%"]{display:none !important}',
  },
  "montura.it": { c: 1 },
  "spaziorock.it": { c: 115 },
  "mobil-1.nl": { s: ".fancybox-container{display:none !important}" },
  "gratisfaction.co.uk": { s: "#grey-bar{display:none !important}" },
  "spielfilm.de": { c: 10 },
  "runmap.net": { s: ".messages.temporary{display:none !important}" },
  "acara.cz": { c: 1 },
  "allomarie.fr": { c: 1 },
  "scuolerimini.it": { s: "#upper_div{display:none !important}" },
  "radiosetv.com": { s: ".fck{display:none !important}" },
  "asd.pl": { c: 1 },
  "miastograf.pl": { c: 27 },
  "ihrzeszow.ires.pl": { s: ".PopupOverlay,.Popup{display:none !important}" },
  "controcampus.it": {
    s: "#Controcampus_cookie_advice{display:none !important}",
  },
  "soft112.com": { s: "#s112_accept_cookies{display:none !important}" },
  "giappo.com": { s: "#normativa{display:none !important}" },
  "linnunrata.org": { c: 1 },
  "rentl.io": { s: "#scroll-popup{display:none !important}" },
  "rankomat.pl": { s: ".rank-cookie-bar{display:none !important}" },
  "foto.no": { s: "#allwrapper > div[style]{display:none !important}" },
  "bonappetit.hu": { s: "#foodfood_cookie{display:none !important}" },
  "neue-freunde-finden.com": { s: "#privacy-bar{display:none !important}" },
  "almacen-informatico.com": { s: "#Informacion{display:none !important}" },
  "vienormali.it": { s: ".info{display:none !important}" },
  "kvalster.se": { s: "noindex #y{display:none !important}" },
  "wander-community.de": { s: "#privacy-bar{display:none !important}" },
  "ildesertofiorira.org": { c: 38 },
  "origin.com": { s: "origin-global-sitestripe{display:none !important}" },
  "istotne.pl": { c: 9 },
  "firefoxosdevices.org": { s: "#storage-notice{display:none !important}" },
  "inelenco.com": { s: "#hid{display:none !important}" },
  "calcolostipendio.it": { s: ".bold_text{display:none !important}" },
  "decrypterlenergie.org": { s: "#alert-mention{display:none !important}" },
  "demaiogroup.it": { s: "#normativa{display:none !important}" },
  "apdmarket.pl": { c: 13 },
  "zosiaikevin.pl": { s: "#novem-slot{display:none !important}" },
  "zdrowemiasto.pl": { s: "#_mo{display:none !important}" },
  "amarone.pl": { s: "#contBanner{display:none !important}" },
  "rckik.poznan.pl": { c: 1 },
  "avery-zweckform.poznan.pl": { c: 1 },
  "peka.poznan.pl": { s: "#popup-peka{display:none !important}" },
  "wydawca.com.pl": { s: "#kuki{display:none !important}" },
  "wirtualis.pl": { s: "#info_container{display:none !important}" },
  "webelite.pl": { s: "#infobar{display:none !important}" },
  "simba.com.pl": { s: "#cContainer{display:none !important}" },
  "metairie.fr": { s: ".popup-notification{display:none !important}" },
  "sapo.tl": { s: ".bsu-v2-ntfs{display:none !important}" },
  "traningspartner.se": {
    s: ".top > .container > .sd-surface > .sd-object-if{display:none !important}",
  },
  "alatest.it": { c: 118 },
  "lstsoft.com.pl": { c: 1 },
  "jordbruksverket.se": {
    s: "#svid10_7824f13e14ed0d5e4dcbbcf0{display:none !important}",
  },
  "uabstyle.it": { c: 7 },
  "supermarchesmatch.fr": { s: "#fevad{display:none !important}" },
  "vergelijk.nl": {
    s: 'div[data-bind*="PageLocationLinksBehavior"] > div[data-bind*="PopupBehavior"]{display:none !important}',
  },
  "marbaro.it": { s: "#marbaro_cookielaw_banner{display:none !important}" },
  "z-ciziny.cz": { c: 119 },
  "eset.com": { s: "#cook,.oks_pp_msgs{display:none !important}" },
  "legnica.pl": { s: "#popupDiv{display:none !important}" },
  "strefa.fm": { s: ".cookskom{display:none !important}" },
  "przyspiesz.pl": { s: "#container_vsm{display:none !important}" },
  "buliba.pl": { s: "#tooltip-hook{display:none !important}" },
  "platinumoil.eu": { c: 44 },
  "e-gratka.info": { s: "#pojemnik{display:none !important}" },
  "imp.gda.pl": { s: "#cp_wrap{display:none !important}" },
  "kupbilet.pl": { c: 7 },
  "krosnocity.pl": { s: "#polcia{display:none !important}" },
  "hemp.pl": { c: 0 },
  "fandemonium.pl": { c: 1 },
  "expozdrowie.pl": { s: "#alert_popup{display:none !important}" },
  "eteacher.pl": { s: "#info_container{display:none !important}" },
  "kielce.eu": { s: "#belka_dolna{display:none !important}" },
  "aftermarket.pl": { s: "#part-cookies{display:none !important}" },
  "getem.pl": { c: 91 },
  "archiwumalle.pl": { c: 91 },
  "anonse.com": { c: 91 },
  "kosmetykizameryki.pl": { c: 91 },
  "basketzone.pl": { c: 91 },
  "teletec.it": { s: "#cookieNewTeletecMainSitoInfo{display:none !important}" },
  "playme.it": { s: "#msg-close{display:none !important}" },
  "wrigleys.co.uk": { s: "#rpcm{display:none !important}" },
  "dexigner.com": { s: "#cwarn{display:none !important}" },
  "netonnet.se": { s: ".topInfo{display:none !important}" },
  "netonnet.no": { s: ".topInfo{display:none !important}" },
  "lawyersonline.co.uk": { c: 10 },
  "allianz.hu": { s: "#idAllianzCookiePolicy{display:none !important}" },
  "scanbot.io": { s: ".sb-banners--cookie{display:none !important}" },
  "antalis.co.uk": { c: 17 },
  "urban-rivals.com": { c: 10 },
  "poxilina.com.pl": { s: "#back-lightbox{display:none !important}" },
  "unifrance.org": { s: ".headerInfos{display:none !important}" },
  "scutt.eu": { s: "#pojemnik{display:none !important}" },
  "svensktnaringsliv.se": { c: 120 },
  "hkr.se": { c: 0 },
  "mercateo.nl": { s: "#header-popup-info{display:none !important}" },
  "tipsmidler.dk": { c: 46 },
  "udlodningsmidler.dk": { c: 46 },
  "hpmarket.cz": { s: 'body > div[style*="FFF"]{display:none !important}' },
  "mygame.co.uk": { s: "#footer ~ div[id]{display:none !important}" },
  "hankooktire.com": { s: ".top_ep_wrap{display:none !important}" },
  "po-sloveniji.com": { s: "#cookN{display:none !important}" },
  "forumplay.pl": { c: 11 },
  "grandix.nl": { s: "#popup,#overlay{display:none !important}" },
  "bleacherreport.com": { s: ".privacy_notice{display:none !important}" },
  "spalensky.com": { s: "#w_notice{display:none !important}" },
  "austrian.com": { s: ".cop{display:none !important}" },
  "teogkaffespecialisten.dk": { c: 7 },
  "apogeum.net.pl": { c: 1 },
  "uk-oak.co.uk": { s: "#cc-conf{display:none !important}" },
  "finefish.cz": { c: 1 },
  "dentisti-italia.it": { s: ".di-banner{display:none !important}" },
  "zeelandhome.nl": { s: ".onderbalk{display:none !important}" },
  "radioplay.se": {
    s: "#root > div > div:first-child{display:none !important}",
  },
  "ecodallecitta.it": { s: "#consenso{display:none !important}" },
  "lesportecles.com": { c: 75 },
  "autosjbperformance.fr": { s: ".cekomeadsbottom{display:none !important}" },
  "b-travel.com": { s: "#fb-cd{display:none !important}" },
  "salonocasion.com": { s: "#fb-cd{display:none !important}" },
  "lediomedee.it": { s: "#cookie-choices{display:none !important}" },
  "arguedas.es": { s: "#barra{display:none !important}" },
  "avalon.me": { c: 76 },
  "radiofama.com.pl": { c: 1 },
  "eena.pl": { s: "#whole_page_loader{display:none !important}" },
  "izi.si": { c: 0 },
  "affaronissimo.it": { s: "#af-cw-box{display:none !important}" },
  "brobygning.net": { c: 1 },
  "orliman.pl": { j: "5" },
  "iit.it": { s: "#messageOuter{display:none !important}" },
  "opengapps.org": { s: ".mdl-snackbar{display:none !important}" },
  "hudo.com": { s: ".cookie-screen{display:none !important}" },
  "texxas.de": { s: "#texxas-cookie-accept{display:none !important}" },
  "atg.se": { s: ".notice__info-info,.alert--info{display:none !important}" },
  "seasaltcornwall.co.uk": { s: ".global-promotion{display:none !important}" },
  "w3logistics.com": { s: "#w3l-cookiebox{display:none !important}" },
  "actionforme.org.uk": { s: ".afme_cookie{display:none !important}" },
  "jajco.pl": { s: 'div[id*="cookies-notification"]{display:none !important}' },
  "messe.de": { c: 92 },
  "jdrp.fr": { s: "#jdrp_cookie_notice{display:none !important}" },
  "gam.com": { s: ".gamNotice{display:none !important}" },
  "compteurdelettres.com": { c: 121 },
  "electronique-mag.com": { s: "#alert_trk{display:none !important}" },
  "tge.com.pl": { c: 1 },
  "allianz.de": { j: "5" },
  "apartmanija.hr": { s: "#site_nt{display:none !important}" },
  "chordbook.com": { s: "#cbeu_container{display:none !important}" },
  "ridewill.it": { j: "5" },
  "alipaczka.pl": { s: "#bottom-charm,.cookies{display:none !important}" },
  "pani-teresa.com.pl": { c: 44 },
  "viralagenda.com": { s: "#viral-footer{display:none !important}" },
  "alatest.nl": { c: 118 },
  "aicanet.it": { s: ".popup-view{display:none !important}" },
  "firstdraftnews.com": { s: ".welcome-message{display:none !important}" },
  "solarenvi.cz": { s: "#cs_bx{display:none !important}" },
  "wibank.de": {
    s: ".mod-Disclaimer{display:none !important}.has-disclaimer body{overflow:visible !important}.has-disclaimer body::before{content:none !important}",
  },
  "enerpoint.it": { s: "#container > div[style]{display:none !important}" },
  "qbasic.at": { s: "#ckkasten-container{display:none !important}" },
  "sapsalis.gr": { s: ".termsnote{display:none !important}" },
  "sconfini.eu": { c: 122 },
  "ulianavalerio.it": { c: 25 },
  "komunitnicestiny.cz": { c: 10 },
  "cyclingarchives.com": {
    s: '#header > div[id*="zxcw"]{display:none !important}',
  },
  "destinyghosthunter.net": { c: 7 },
  "auditoriaswireless.net": { s: "#adk_acblock{display:none !important}" },
  "zs1mm.edu.pl": { c: 1 },
  "fowtcg.it": { c: 7 },
  "alcoholics-anonymous.org.uk": { c: 33 },
  "forumlekarza.pl": { s: "#cpolicy_wrap{display:none !important}" },
  "ncplusgo.pl": { s: ".js-messages{display:none !important}" },
  "autogasnord.it": { s: ".pre-privacy-container{display:none !important}" },
  "moly.hu": { s: "#eu{display:none !important}" },
  "infiniti.fr": { c: 74 },
  "lotus-planete.com": { s: "#lotus-cookies-wrap{display:none !important}" },
  "docdroid.net": { s: ".ui-pnotify{display:none !important}" },
  "aegonalapkezelo.hu": { s: "#AEGONCookieLine{display:none !important}" },
  "monptivoisinage.com": {
    s: "#com-message,#bandHead{display:none !important}",
  },
  "tvgids24.nl": { c: 66 },
  "noto.sr.it": {
    s: "#policy_id{display:none !important}body{padding-top:0 !important}",
  },
  "theinvergordonarchive.org": { s: "#CQ{display:none !important}" },
  "meteo-service.nl": { c: 123 },
  "valher.si": { s: "body > table{display:none !important}" },
  "zahradnikrby.cz": { s: "#cs_bx{display:none !important}" },
  "portal.ou.nl": {
    s: "#M093A{display:none !important}#page_body{padding-top:0 !important}",
  },
  "v10.pl": { c: 12 },
  "hlidacipes.org": { s: "#hlidacipes_cookies{display:none !important}" },
  "affecto.fi": { s: ".privacy-policy-container{display:none !important}" },
  "datatypes.net": { c: 93 },
  "preparegreentea.com": {
    s: ".wdpu-container{display:none !important}.has-popup.no-scroll{overflow:auto !important}",
  },
  "regalideidesideri.it": {
    s: ".centered-container .msg{display:none !important}",
  },
  "teemo.gg": { c: 10 },
  "dnevnik.si": { s: "#app-messages{display:none !important}" },
  "einbuergerungstest-online.eu": { c: 25 },
  "cinquantamila.it": { s: "#privacy_advisor{display:none !important}" },
  "englishgratis.com": { s: "#privacy_box_container{display:none !important}" },
  "sexomercadobcn.com": { s: ".hidder,.disclamer{display:none !important}" },
  "netrisk.hu": {
    s: "#netrisk_header > div{display:none !important}a + #netrisk_homepage{margin-top:0 !important}",
  },
  "nordschleswiger.dk": {
    s: ".TopAdvertising-Content-Wrapper > .Seeems-CollapsibleArea{display:none !important}",
  },
  "heim-und-haustiere.de": { c: 54 },
  "librogame.net": { c: 38 },
  "concordiaubezpieczenia.pl": { c: 44 },
  "farmacosmo.it": { s: "#bottombar{display:none !important}" },
  "ttela.se": { s: ".ttelcGRCookieContainer{display:none !important}" },
  "carmenthyssenmalaga.org": { s: "#divAlertas{display:none !important}" },
  "orgoglionerd.it": { s: ".irpclw{display:none !important}" },
  "mediterraneaolive.it": {
    s: "#psmcookie_popup,#psmcookie_popup_layer{display:none !important}body{overflow:visible !important}",
  },
  "gmsystem.pl": { c: 45 },
  "therapia.cz": { s: ".CC_wrap{display:none !important}" },
  "tagsistant.net": { c: 122 },
  "rhp.nl": { s: "#cn-wrapper{display:none !important}" },
  "helbling-ezone.com": { s: "#statusBar{display:none !important}" },
  "andyhoppe.com": { s: "#cmsg{display:none !important}" },
  "faqin.org": { c: 7 },
  "hyperxgaming.com": {
    s: "#policy_message,.notification-center{display:none !important}",
  },
  "mtv.com": { c: 94 },
  "geoprostor.net": { s: "#REALISCCBAR{display:none !important}" },
  "uni-kl.de": { s: "#cookie-uni-kl{display:none !important}" },
  "merlin.pl": { s: ".merlin-legal-note{display:none !important}" },
  "parcoappiaantica.it": {
    s: ".moduletable-privacy-popup{display:none !important}",
  },
  "volvo.com": { s: ".headerNotification{display:none !important}" },
  "geekhebdo.com": { s: ".cookiegeek{display:none !important}" },
  "essilorpro.co.uk": { s: "#mentions{display:none !important}" },
  "bouwformatie.nl": { s: "#stickyHeader{display:none !important}" },
  "itwayvad.com": { s: "#light{display:none !important}" },
  "nousmotards.com": { s: ".csa-popup{display:none !important}" },
  "game-ready.com": { s: ".ly-cookie{display:none !important}" },
  "nite-ize.eu": { s: ".blockMsg{display:none !important}" },
  "draagle.com": { s: "#nonsense_root{display:none !important}" },
  "notariado.org": { c: 25 },
  "senarrubia.it": { c: 1 },
  "relpol.pl": { s: "#powiadomiony{display:none !important}" },
  "el-klinikken.dk": { c: 1 },
  "forbot.pl": { s: "#ForbotCookies{display:none !important}" },
  "swm.de": { s: ".mod-029{display:none !important}" },
  "polipc.hu": { s: "#sutik_elf{display:none !important}" },
  "luxicarshireltd.co.uk": {
    s: "body > div[data-rule-type]{display:none !important}",
  },
  "wearewater.org": { s: ".messages{display:none !important}" },
  "alsacechampagneardennelorraine.eu": {
    s: ".cm-message{display:none !important}",
  },
  "homejardin.com": {
    s: 'td[valign="top"] > p[style*="text-align:justify"]{display:none !important}',
  },
  "flyordie.com": { s: "#eucc{display:none !important}" },
  "sickbrain.org": { s: "#popslide{display:none !important}" },
  "rychlyrande.cz": { s: ".cok{display:none !important}" },
  "convert-my-image.com": { c: 7 },
  "vedian.io": { s: "ve-cookies{display:none !important}" },
  "adeccomedical.fr": { s: ".bannerContainer{display:none !important}" },
  "raikaritten.it": { s: ".bottom_note{display:none !important}" },
  "vanitybamboo.com": { s: "#div_c{display:none !important}" },
  "edenred.fr": {
    s: "#cookies-navigation + #page > header{top:0 !important}#cookies-navigation + #page > div{margin-top:80px !important}",
  },
  "alectia.com": {
    s: '#NavigationHeader > .smart-object[style*="white"]{display:none !important}',
  },
  "flitsers.nl": { s: "#cc_overlay{display:none !important}" },
  "grupazywiec.pl": { s: "#apollo-bar{display:none !important}" },
  "abt-s.pl": { c: 38 },
  "telefonoassistenza.net": { s: "#window{display:none !important}" },
  "ako-uctovat.sk": { c: 116 },
  "professioneparquet.it": { c: 38 },
  "loterieplus.com": { s: ".ck_popin{display:none !important}" },
  "fotozine.org": { s: "#kukijima{display:none !important}" },
  "praktiker.bg": { s: "#infomessage{display:none !important}" },
  "tysiagotuje.pl": {
    s: 'body > div > div:not([id]):not([class])[style*="fixed"]{display:none !important}',
  },
  "numericable.mobi": { s: ".toastComponent{display:none !important}" },
  "bordersdown.net": { s: "#message-1{display:none !important}" },
  "diyaudio.pl": { s: "#navbar_notice_11{display:none !important}" },
  "kelloggs.fr": { s: "#kelloggsfrance{display:none !important}" },
  "xilo1934.it": { c: 1 },
  "mediatheque.sainthilairederiez.fr": { c: 67 },
  "wabeco-remscheid.de": { c: 38 },
  "ardes.bg": { s: ".c-msg{display:none !important}" },
  "villamadruzzo.com": { s: ".tpca{display:none !important}" },
  "tma-winding.com": { c: 38 },
  "eaux-de-normandie.fr": { s: "#notifybar{display:none !important}" },
  "mcclic.com": { s: "#dialog{display:none !important}" },
  "musicworks.it": { s: "#infromativap{display:none !important}" },
  "lonelyplanet.com": { c: 10 },
  "sabrain.com": {
    s: '.message-panel[data-notice-id="brainscookienotice"]{display:none !important}',
  },
  "matoga.com.pl": { c: 1 },
  "ravenblack.net": { j: "5" },
  "swarovskioptik.com": { s: "#cpp-wrapper{display:none !important}" },
  "sep.gr": { j: "5" },
  "voiceanddatazone.com": { s: "#popup,.blocker{display:none !important}" },
  "expogatemilano.org": { c: 12 },
  "kreuzwort-raetsel.net": { c: 1 },
  "jobdiagnosis.com": { s: "#benefits{display:none !important}" },
  "repostuj.pl": { s: ".jumbotron{display:none !important}" },
  "visit.brussels": { s: ".confirm{display:none !important}" },
  "variart.org": { c: 7 },
  "maccosmetics.it": { s: ".bt-content{display:none !important}" },
  "artemis.co.uk": { s: "#container{top:0 !important}" },
  "gewoonvegan.nl": { s: "#tracking{display:none !important}" },
  "lopolis.si": { c: 27 },
  "nowlive.eu": { s: "#overlayPopup1,#opacity{display:none !important}" },
  "lucachiesi.com": { s: ".wpcp{display:none !important}" },
  "postrabbit.pl": { c: 25 },
  "maklarhuset.se": { s: "body > .uk-panel-box{display:none !important}" },
  "mediaspeed.net": { s: ".cp_overly,#cpContainer{display:none !important}" },
  "promotionbasis.de": { s: "#c_test_box{display:none !important}" },
  "whitehorsedc.gov.uk": { s: ".ccwrap{display:none !important}" },
  "goodenergy.co.uk": { c: 14 },
  "tan.io": { s: "#panel_11 .widget.plgText{display:none !important}" },
  "mgr.farm": { s: "#mgr_cookie_notice{display:none !important}" },
  "como-se-escribe.com": { s: "#pck{display:none !important}" },
  "vfl.dk": { s: "#vcc_container{display:none !important}" },
  "compassionuk.org": { c: 124 },
  "gmp.police.uk": { c: 10 },
  "vidahost.com": { s: "#vh-cookie-terms{display:none !important}" },
  "nissan.be": { c: 74 },
  "omnitel.lt": { s: ".oop-notification{display:none !important}" },
  "hardloopschema.nl": {
    s: "#interContainer,#interVeil{display:none !important}",
  },
  "ahlens.se": { s: ".ah-warning{display:none !important}" },
  "almamarket.pl": { s: "#claw{display:none !important}" },
  "g5tiregala.it": { s: "#n1_popup{display:none !important}" },
  "toborrow.se": { c: 7 },
  "retromarket.club": { s: "#doc_injected{display:none !important}" },
  "gunof.net": { s: "body > p{display:none !important}" },
  "nlite.it": { c: 38 },
  "gautier.fr": {
    s: "#block-lchuser-user-preferences{display:none !important}",
  },
  "jnjmedical.it": { c: 115 },
  "rosacea-info.de": { s: ".infobox{display:none !important}" },
  "koakdesign.info": { s: "#barre{display:none !important}" },
  "anticocaffetoti.com": { c: 7 },
  "vespaonline.de": { s: ".footerBar{display:none !important}" },
  "oriocenter.it": { c: 7 },
  "azimutyachts.com": { c: 125 },
  "fr12.nl": { j: "5" },
  "squarespace.com": {
    s: ".squarespace-banner{display:none !important}body{margin-top:0 !important}",
  },
  "resultados-futbol.com": { c: 26 },
  "partyflock.nl": { s: "#ckcnsnt{display:none !important}" },
  "megadev.info": {
    s: "#footer2{display:none !important}#footer{bottom:0 !important}",
  },
  "pampling.com": { s: "#mensaje_aprobacion{display:none !important}" },
  "datocapital.com": { s: "#ckp{display:none !important}" },
  "smac-casa.it": { s: ".ccp-banner{display:none !important}" },
  "hosch-kleber.hu": { s: "#cinfo{display:none !important}" },
  "aegon.hu": { s: "#AEGONCookieLine{display:none !important}" },
  "biosystems.es": {
    s: '#aspnetForm > div[style*="fixed"]{display:none !important}',
  },
  "forumwodne.pl": {
    s: 'body > div[id] > div[style*="fixed"]{display:none !important}',
  },
  "piqd.de": { s: ".pq-flash_message-outer_wrap{display:none !important}" },
  "gangnam.lv": { s: "#menu_side{display:none !important}" },
  "binck.fr": { c: 31 },
  "eco07.com": { c: 19 },
  "pikore.com": { c: 7 },
  "gafas.es": { s: ".header_cookie_gfs{display:none !important}" },
  "transcend-info.com": { s: "#legal_notice{display:none !important}" },
  "mojcomp.net": { s: ".q-ico-container{display:none !important}" },
  "ragazzon.com": { c: 1 },
  "amnesia.es": { s: "#barra{display:none !important}" },
  "siegwerk.com": { s: ".popover{display:none !important}" },
  "bilka.com.pl": { s: "#mod99{display:none !important}" },
  "solagrifood.com": { s: "#ecl{display:none !important}" },
  "activexsoft.es": {
    s: 'body > div[class*="msg-cookies"]{display:none !important}',
  },
  "biunsinnorden.de": { s: ".header-top-cookie-text{margin-top:0 !important}" },
  "doku5.com": { s: "#msgWindowX{display:none !important}" },
  "domain.com": { s: "#alertBar{display:none !important}" },
  "zoiglapp.de": { c: 53 },
  "infiniti.hu": { c: 74 },
  "theerlangelist.com": { s: "#privacy_note{display:none !important}" },
  "suzuki2wheels.be": { c: 63 },
  "aviva.es": { s: "#ventanaFlotante{display:none !important}" },
  "soundsgood.co": { c: 7 },
  "peugeotscooters.be": { c: 63 },
  "ravanson.pl": { s: 'body > div[style*="cookies"]{display:none !important}' },
  "konkurrensverket.se": { c: 25 },
  "thecoupleconnection.net": { s: "#anon_mode{display:none !important}" },
  "globalassicurazioni.it": { c: 12 },
  "gamesgrabr.com": { s: ".alerts-wrap{display:none !important}" },
  "rd.nl": { j: "5" },
  "webzeen.fr": { s: ".footer-fixed-bottom{display:none !important}" },
  "bitpalast.net": { s: ".con{display:none !important}" },
  "schoolandvacation.it": { c: 12 },
  "maxifoot.fr": { s: "#mfcok1{display:none !important}" },
  "payoneer.com": { s: ".gb-popup{display:none !important}" },
  "lavorar.it": { s: ".headerline2{display:none !important}" },
  "mtech.pl": { s: "#content_jquery_bottom{display:none !important}" },
  "jomalone.co.uk": { c: 87 },
  "czarymary.pl": { s: ".ek-bar{display:none !important}" },
  "vera.com.pl": { c: 44 },
  "ncplus.pl": { s: ".js-messages{display:none !important}" },
  "mccruddens-repair.co.uk": {
    s: 'body > div[data-rule-type="notification"]{display:none !important}',
  },
  "bristoltransmissions.co.uk": { c: 12 },
  "companycheck.co.uk": { s: "footer .news-bar{display:none !important}" },
  "buzzfil.net": { s: "#popup1{display:none !important}" },
  "zoomalia.com": { s: ".cnil_container{display:none !important}" },
  "majestic.co.uk": { s: "#ens_overlay_main{display:none !important}" },
  "idealing.com": {
    s: "#idealing-cookie-consent-wrapper{display:none !important}",
  },
  "tuandco.com": { s: ".jnotify-container{display:none !important}" },
  "simpelkoken.nl": { c: 77 },
  "pavillonfrance.fr": { c: 1 },
  "afcwimbledon.co.uk": {
    s: ".optional_module.profile_summary{display:none !important}",
  },
  "getagift.pl": { s: "#header > div[style]{display:none !important}" },
  "mojapogoda.com": { s: "#IR{display:none !important}" },
  "uzdrowisko-wieniec.pl": { s: "#statement{display:none !important}" },
  "deshgold.com": {
    s: ".rltcp_information_cookie,.rltcp_overlay{display:none !important}",
  },
  "woolrich.eu": { s: ".firstvisit{display:none !important}" },
  "fratinardi.it": {
    s: '.wrapper > div[id*="cookie"]{display:none !important}',
  },
  "casadei.com": { s: ".firstvisit{display:none !important}" },
  "camcom.it": { s: "#fine{display:none !important}" },
  "portalodo.com": { c: 10 },
  "leaandperrins.co.uk": { c: 1 },
  "burn-out-forum.de": {
    s: ".ifancybox-overlay-fixed{display:none !important}",
  },
  "pemp.pl": { s: "#divCiacho{display:none !important}" },
  "gospodari.com": {
    s: ".biscuits{display:none !important}#header.opened-bisc{top:0 !important}",
  },
  "swiat-laptopow.pl": { c: 12 },
  "monsterdoodles.co.uk": { s: "#msgBox{display:none !important}" },
  "maggi.com.my": { s: ".agreebox,.transparent{display:none !important}" },
  "hannovermesse.de": { c: 92 },
  "pavinviaggi.com": { s: "#otp-privacy{display:none !important}" },
  "ipodnikatel.cz": { s: ".footer-banner-container{display:none !important}" },
  "uta.com": { s: "#hinweisoverlay{display:none !important}" },
  "vivatechnologyparis.com": {
    s: "#content > .full > .fixed{display:none !important}",
  },
  "synpeka.gr": { s: "#trumpet_message{display:none !important}" },
  "informationisbeautiful.net": { s: "#iib-cookies{display:none !important}" },
  "hss.com": { s: "body > div > .center_block{display:none !important}" },
  "monchio-delle-corti.pr.it": { c: 38 },
  "groupeelectrogene.com": { s: "#cFrame{display:none !important}" },
  "guideastuces.com": { s: "#agreeMsg{display:none !important}" },
  "myairbridge.com": { s: "#terms{display:none !important}" },
  "privatesportshop.fr": { c: 1 },
  "persgroepwielerspel.nl": {
    s: "#st_popup,#st_overlay{display:none !important}",
  },
  "mots-croises.ch": { s: "#askCk{display:none !important}" },
  "adamequipment.com": { s: "#fl_menu{display:none !important}" },
  "atlasdepoesia.blogcindario.com": {
    s: "body > div[id][class]:not(#math_parentdiv):not(#pagina){display:none !important}",
  },
  "promet.si": { s: "#REALISCCBAR{display:none !important}" },
  "hang-sluitwerk.nl": { c: 27 },
  "bonnejournee-by-up.fr": { s: ".bandeau{display:none !important}" },
  "eknjiga.hr": { c: 53 },
  "whoisanna.com": { s: ".popup-background,.popup{display:none !important}" },
  "heythroppark.co.uk": { s: "#pecr_summary{display:none !important}" },
  "headfirstbristol.co.uk": { c: 33 },
  "elternchecker.de": { c: 31 },
  "xlbygg.se": { s: ".main.cookiewarning{margin-top:0 !important}" },
  "penzionist.info": { c: 122 },
  "aerlingus.com": {
    s: ".ng-isolate-scope[cookie-content]{display:none !important}",
  },
  "practicalphysics.org": { s: "#alerttop{display:none !important}" },
  "riomare.it": { s: ".ccp-banner{display:none !important}" },
  "hypemerchants.nl": {
    s: ".body-innerwrapper + div[id]{display:none !important}",
  },
  "autohaus-brandt.com": { c: 126 },
  "merckmanual.nl": { j: "5" },
  "msdmanuals.nl": { j: "5" },
  "nombra.me": { s: "#privacy_w{display:none !important}" },
  "dobrarada.com.pl": { c: 68 },
  "lcfc.com": {
    s: ".optional_module.profile_summary{display:none !important}",
  },
  "adventureinsel.de": { s: ".infobox{display:none !important}" },
  "goteo.org": { s: "#message.info{display:none !important}" },
  "valvolgyikisvasut.hu": { s: "#SITE_ROOT + div{display:none !important}" },
  "germinalbio.it": { c: 12 },
  "transcend.de": { s: "#legal_notice{display:none !important}" },
  "withgoogle.com": { j: "5" },
  "aidonslesnotres.fr": { s: "#cnil-wrapper{display:none !important}" },
  "unicreditgroup.eu": {
    s: "#header{top:0 !important}.body-container-table{margin-top: 0 !important}",
  },
  "unicreditbank.cz": { s: "#pop-down{display:none !important}" },
  "opel-rupprecht-wernberg.de": {
    s: "#tooltip-privacy-shown{display:none !important}",
  },
  "filmsorozatok.hu": {
    s: "#modal-adult{display:none !important}",
    c: 14,
  },
  "mmtv.pl": { s: "#policyInfo{display:none !important}" },
  "regupedia.de": { s: ".wr_regupedia-header-cookie{display:none !important}" },
  "ardanta.nl": { s: "#cookie-bar-ardanta{display:none !important}" },
  "environnement-magazine.fr": {
    s: ".enviro-cookies{display:none !important}",
  },
  "italiaracing.net": { s: "#Allpopup_PW0{display:none !important}" },
  "bbbell.it": { s: "#slideit{display:none !important}" },
  "drittemanntour.at": {
    s: "#selfedit-privacy-window{display:none !important}",
  },
  "e-weber.it": { c: 52 },
  "visionaidoverseas.org": { c: 1 },
  "trainstationgame.com": { c: 25 },
  "wearablesmagazine.nl": { c: 88 },
  "hirealestate.es": { c: 76 },
  "olib.oclc.org": { s: "#userMessaging{display:none !important}" },
  "esklep-sbs.pl": { s: "#cibMessage{display:none !important}" },
  "seaheroquest.com": { s: ".tab-cookies{display:none !important}" },
  "davidviner.com": { s: "#cklmsg{display:none !important}" },
  "chceauto.pl": { s: ".cookue{display:none !important}" },
  "masymasbarato.com": { s: "#galetes{display:none !important}" },
  "mysearch.com": { s: "#cp-banner{display:none !important}" },
  "bpm.it": { s: "#inline-cookie-tab{display:none !important}" },
  "cz.it": { s: "#dviT{display:none !important}" },
  "butagaz.fr": { s: "#prehead{display:none !important}" },
  "heyn.at": { c: 45 },
  "lalocandadeigirasoli.it": { s: ".allowBox{display:none !important}" },
  "commentseruiner.com": { s: "#uec_wrap{display:none !important}" },
  "bongacams.com": { s: ".popup_18_plus .block.two{display:none !important}" },
  "bruno-bedaride-notaire.fr": { s: ".avertissement{display:none !important}" },
  "sklepbiegowy.com": { c: 1 },
  "covertimes.com": { c: 26 },
  "autohus.de": { s: ".c-toast-notification{display:none !important}" },
  "stresninosice.cz": { s: ".remarketing_allow{display:none !important}" },
  "node-os.com": { s: "#westoredata{display:none !important}" },
  "bigbank.lt": { s: ".sticky{display:none !important}" },
  "classcroute.com": { c: 25 },
  "vh1.com": { s: ".preventAcceptance{display:none !important}" },
  "magazzinirossi.eu": { s: "#informativaBreve{display:none !important}" },
  "rawranime.tv": {
    s: '.site-news[data-id="acceptcookies"]{display:none !important}',
  },
  "sentinellelagazuoi.it": { s: "#contact{display:none !important}" },
  "lyrics.cat": { s: "#cxcx{display:none !important}" },
  "rock-in-chiado.com": { s: "#SITE_ROOT + div{display:none !important}" },
  "avtoset.si": { s: 'body > div[style*="2A2A2A"]{display:none !important}' },
  "termalfurdo.hu": {
    s: "#layout_advertising_bottom{display:none !important}",
  },
  "blackoise.de": { s: ".wppn-wrapper{display:none !important}" },
  "profiloptik.dk": { s: ".message-large{display:none !important}" },
  "parcoittico.it": { c: 19 },
  "leporelo.info": { s: ".bg-info{display:none !important}" },
  "prohibita.pl": { s: ".ciachbtm-wrap-container{display:none !important}" },
  "elumbus-reisen.de": { c: 25 },
  "suder.eu": { c: 12 },
  "dela.nl": { s: "#dela-cookie-bar{display:none !important}" },
  "kelformation.com": { c: 10 },
  "pyrexuk.com": { s: "#popajax{display:none !important}" },
  "drukowalnia.pl": { s: ".ek-bar{display:none !important}" },
  "alfakan.si": { s: ".jquery-bar{display:none !important}" },
  "autotask.com": { s: ".alertbar{display:none !important}" },
  "zvono.eu": { s: "#footer > table{display:none !important}" },
  "gsbk.pl": { s: "#ci{display:none !important}" },
  "lacapracampa.com": {
    s: "#psmcookie_popup,#psmcookie_popup_layer{display:none !important}body{overflow:visible !important}",
  },
  "trovanumeri.com": { s: "#hid{display:none !important}" },
  "chateauversailles.fr": { c: 113 },
  "buyamower.co.uk": { c: 47 },
  "memorialhenrykapuzonia.pl": { s: "#sc{display:none !important}" },
  "referendumcostituzionale.online": { c: 19 },
  "also.com": { c: 7 },
  "paramountplants.co.uk": { s: ".uk-notify{display:none !important}" },
  "bndunlimited.com": { s: "#header-banner{display:none !important}" },
  "nationalacademic.nl": { s: "#footer_fixed{display:none !important}" },
  "unimib.it": { s: "#bico-bscn-cnt,#cookies{display:none !important}" },
  "centromedicobeb.it": { c: 10 },
  "sosulski.pl": { c: 45 },
  "howdidido.com": { c: 25 },
  "bryncynonstrategy.co.uk": { c: 19 },
  "teaminternet.dk": { c: 12 },
  "highworthrec.co.uk": { s: "#cookiebtn{display:none !important}" },
  "oszkar.com": { s: "#footerbar{display:none !important}" },
  "ekko.com.pl": { s: "#messagePopup{display:none !important}" },
  "ministerstworeklamy.pl": { s: "#messagePopup{display:none !important}" },
  "zilverenkruis.nl": { j: "5" },
  "jak-ksiegowac.pl": { c: 116 },
  "cowsep.com": { s: ".cg-notify-message{display:none !important}" },
  "eg.dk": { s: ".top-alert{display:none !important}" },
  "albrevin.org": { c: 7 },
  "weclap.fr": {
    s: ".front_web_app_main_menu_front-web-app-main-menu-component_front_show_cookie_container{display:none !important}",
  },
  "llttf.com": { s: ".ico{display:none !important}" },
  "cronacaqui.it": { s: "#footerprivacy{display:none !important}" },
  "camping-les-loges.com": { s: "#MenuCnil{display:none !important}" },
  "scavino.it": { s: "#fanback{display:none !important}" },
  "radsportseiten.net": { s: "#zxcw03{display:none !important}" },
  "startupmalta.com": { c: 10 },
  "mtsmarkets.com": { s: "#headerDropDownPanel{display:none !important}" },
  "atmanavillarospigliosi.it": { c: 43 },
  "teamliquid.net": { c: 12 },
  "gcpat.com": { s: ".ms-dlgOverlay,.ms-dlgContent{display:none !important}" },
  "conservateur.fr": { c: 21 },
  "instytutlogopedyczny.pl": { s: "#flash-msg{display:none !important}" },
  "bestiloghent.dk": { s: ".popup-container{display:none !important}" },
  "theblues-thatjazz.com": { s: ".transbox1{display:none !important}" },
  "mini.it": {
    s: ".md-custom-overlay,.md-custom-overlay-veil{display:none !important}",
  },
  "zeewolde-actueel.nl": { s: "#CARD-optin-header{display:none !important}" },
  "ef.com.es": { s: ".aa{display:none !important}" },
  "scorito.com": { j: "5" },
  "sg-weber.de": { c: 52 },
  "hypersunday.com": { s: "#menu-who{display:none !important}" },
  "editionlimiteepays.com": { s: ".alertAgegate{display:none !important}" },
  "medtronic.nl": { j: "5" },
  "kalenderpedia.de": { c: 12 },
  "next-gamer.de": { s: "#ingameCookie{display:none !important}" },
  "artedas.it": { s: "#cookiemex{display:none !important}" },
  "marcel-lameijer.nl": {
    s: ".wpmui-overlay,.wpmui-popup{display:none !important}html.no-scroll,html.no-scroll body{overflow:visible !important}",
  },
  "medatixx.de": { s: "#cky-notification{display:none !important}" },
  "cottages.com": { s: "#createCookie{display:none !important}" },
  "quotazero.com": { c: 21 },
  "qsoftnet.com": { s: ".art-sheet > table{display:none !important}" },
  "vrty.org": { s: ".usage-notice > strong{display:none !important}" },
  "3dtvmagazine.nl": { c: 88 },
  "blikopzeewolde.nl": { j: "5" },
  "aziendasicura.net": { s: "#FrstCksDiv{display:none !important}" },
  "hardreset.hu": { c: 38 },
  "yogenfruz.pl": { s: ".shotimoo{display:none !important}" },
  "brdfinance.ro": { c: 33 },
  "ebok.jmdi.pl": { s: ".ui-notificationbar.top{display:none !important}" },
  "battlecam.com": { s: ".navigation-notify{display:none !important}" },
  "lma.eu.com": { c: 21 },
  "crowdstrike.com": { s: "#optInMessage{display:none !important}" },
  "cplusplus.com": { c: 1 },
  "ezermester.hu": { c: 7 },
  "kapszulavadasz.hu": { c: 33 },
  "kalkulatorkalorii.net": { s: ".ek-bar{display:none !important}" },
  "manualslib.com": { c: 47 },
  "alablaboratoria.pl": { s: "#cover{display:none !important}" },
  "kkuriren.se": { c: 45 },
  "alko-memy.pl": { s: "#cookieMain{display:none !important}" },
  "remax.at": { s: "#datenschutz{display:none !important}" },
  "kierunekspozywczy.pl": { c: 33 },
  "blackspur.com": {
    s: '#MainTable div[style*="background:#333"]{display:none !important}',
  },
  "visahq.co.uk": { s: "#main_visa_warning{display:none !important}" },
  "dopdf.com": { s: "#dopdf_accept_cookies{display:none !important}" },
  "beardsmen.co.uk": { c: 1 },
  "sanef.com": { s: ".bandeaux{display:none !important}" },
  "ah-finmekanik.dk": { c: 1 },
  "uitdatabank.be": { c: 25 },
  "azimutyachts.cz": { c: 125 },
  "fitneszvilag.hu": { s: "#id_accptTerrms{display:none !important}" },
  "varese.it": { s: "#headervarese ~ a{display:none !important}" },
  "para.it": { s: ".popup-alert-notice{display:none !important}" },
  "buderus.de": {
    s: ".tt-mybuderus-common-cookiebar{display:none !important}",
  },
  "appdynamics.de": { s: ".announcement-bar{display:none !important}" },
  "mimio.com": { s: ".botmid{display:none !important}" },
  "sausageandciderfestival.co.uk": {
    s: "#CC_Bar,#CC_Shade{display:none !important}",
  },
  "cinemacity.sk": { c: 47 },
  "grottapalazzese.it": { s: ".modal-strip{display:none !important}" },
  "crescent.se": {
    s: "body > div[data-am-cookie-information]{display:none !important}",
  },
  "kozy.pl": { s: "#claw{display:none !important}" },
  "wislaportal.pl": { c: 33 },
  "liebl.de": { s: ".ish-global-notice-container{display:none !important}" },
  "sussexarchaeology.org": { c: 19 },
  "lords.org": { s: ".global-notice-wrap{display:none !important}" },
  "weber-terranova.hu": { c: 52 },
  "southoxon.gov.uk": { s: ".ccwrap{display:none !important}" },
  "auto-schorn.de": { c: 126 },
  "viu.es": { s: "#sst_container{display:none !important}" },
  "breakingitaly.it": { c: 43 },
  "mare2000.it": { s: "#avviso{display:none !important}" },
  "serialefilmyonline.pl": { c: 7 },
  "uuid.cz": { s: "#fuckies_info{display:none !important}" },
  "unicreditbank.si": { s: "#pop-down{display:none !important}" },
  "federconsumatoripavia.it": { c: 12 },
  "mountstuarthospital.co.uk": { c: 53 },
  "alatest.no": { c: 118 },
  "tyrolia.at": { c: 45 },
  "motorcycles-motorbikes.com": { s: "#CQ{display:none !important}" },
  "nowtv.it": { c: 12 },
  "almaimotthona.hu": { s: ".aszfLayerText{display:none !important}" },
  "spelsberg.de": { s: ".tx-elsbase-notification{display:none !important}" },
  "stylefactoryproductions.com": { c: 43 },
  "negrita.fr": { s: "#slidebox{display:none !important}" },
  "ingwb.com": { s: ".glass,.dialog{display:none !important}" },
  "voloweb.it": { s: "#popupDivC{display:none !important}" },
  "ilfruttarolo.it": { s: "#decretopr{display:none !important}" },
  "e-cegjegyzek.hu": { s: "#suti_csik{display:none !important}" },
  "coisas.com": { s: ".fixebar{display:none !important}" },
  "runinmarseille.com": { c: 62 },
  "carhartt-wip.com": { s: ".standard-message{display:none !important}" },
  "wnt.com": { s: "#trackerBanner{display:none !important}" },
  "sherburnaeroclub.com": { c: 19 },
  "e-stave.com": { c: 37 },
  "satispay.com": { c: 25 },
  "alpintouren.com": { s: ".humane{display:none !important}" },
  "jooas.com": { c: 10 },
  "quazer.com": { s: ".fullscreen-notification{display:none !important}" },
  "szyj.pl": { c: 1 },
  "alyt.com": { s: "#ALYT_privacyCookie{display:none !important}" },
  "epexspot.com": { s: "#ub{display:none !important}" },
  "privatesportshop.it": {
    s: 'body > div[style*="FFFFE1"]{display:none !important}',
  },
  "laatumaa.fi": { s: "#PrivacyNotice{display:none !important}" },
  "frivolausgehen.eu": { c: 54 },
  "daiwa-info.hu": { s: "#wrap{display:none !important}" },
  "americancentury.com": { s: "#instruction_message{display:none !important}" },
  "mimprendo.it": { c: 1 },
  "katorishintoryu.it": { c: 19 },
  "podcrto.si": { s: "#cc-note{display:none !important}" },
  "mycircle.tv": { s: "#notif_ck{display:none !important}" },
  "filedesc.com": { s: "#cwarn{display:none !important}" },
  "vrn.de": { s: "#vrn-cookie{display:none !important}" },
  "mywebook.com": { s: ".cui-coks{display:none !important}" },
  "rendi.hu": { c: 1 },
  "overcoming.co.uk": { s: "#msg_top_bar{display:none !important}" },
  "somethingartistic.net": { s: "#hellobar-slider{display:none !important}" },
  "valtifest.nl": {
    s: "#cerabox,#cerabox-background{display:none !important}",
  },
  "volvotrucks.nl": { s: ".headerNotification{display:none !important}" },
  "havoline.com": { c: 62 },
  "zetchilli.pl": { s: ".giodoContainer{display:none !important}" },
  "marathondumontsaintmichel.com": { c: 62 },
  "humanic.net": { s: "#privacyOverlay{display:none !important}" },
  "webmaster-rank.info": { c: 89 },
  "216dt.com": { s: '#bdy > div[style*="fixed"]{display:none !important}' },
  "pingvinpatika.hu": { c: 25 },
  "voglioviverecosi.com": { c: 7 },
  "ekuriren.se": { c: 45 },
  "britmodeller.com": { s: ".ipsMessage_error{display:none !important}" },
  "liquiddota.com": { c: 1 },
  "digivaardigdigiveilig.nl": { c: 53 },
  "liveuamap.com": { s: ".user-msg{display:none !important}" },
  "mongars.fr": {
    s: "#metacontainer > div:not([id]):not([class]){display:none !important}",
  },
  "ig.com": { c: 76 },
  "usm.com": { s: ".usm-cookie{display:none !important}" },
  "suchdichgruen.de": { j: "5" },
  "smarthomemagazine.nl": { c: 88 },
  "aircostcontrol.com": { s: ".question{display:none !important}" },
  "stubhub.co.uk": { s: "#banner-container{display:none !important}" },
  "did.ie": { c: 86 },
  "peugeot-scooters.nl": { c: 63 },
  "tuv.com": {
    s: "#simplemodal-container,#simplemodal-overlay{display:none !important}",
  },
  "printerman.pt": { c: 1 },
  "neti.ee": { s: ".neti_reminder{display:none !important}" },
  "hirpress.hu": { s: "#cooky{display:none !important}" },
  "os-naklo.si": { c: 37 },
  "fis.tv": { s: ".messagesWrapper{display:none !important}" },
  "eloben.hu": { s: ".law-accept{display:none !important}" },
  "tudorwatch.com": { s: ".tdr-ribbon{display:none !important}" },
  "videosection.com": { c: 1 },
  "boraszportal.hu": {
    s: "#layout_advertising_bottom{display:none !important}",
  },
  "meteo.lt": { s: "#ecl{display:none !important}" },
  "diochan.com": { s: "#di5c141m3r{display:none !important}" },
  "uneto-vni.nl": { s: "#euBackground{display:none !important}" },
  "kotburger.pl": { c: 1 },
  "rocchietta.fr": {
    s: ".wpmui-overlay,.wpmui-popup{display:none !important}html.no-scroll,html.no-scroll body{overflow:visible !important}",
  },
  "liberal.hr": { c: 127 },
  "byom.de": { c: 7 },
  "versatel.nl": { s: "#targetedPopupFrame{display:none !important}" },
  "handleidingzoek.nl": {
    s: "body.cookie-notice > #wrapper,body.cookie-notice > #footer-bottom,body.cookie-notice > #footer{filter:none;-webkit-filter:none;-moz-filter:none}",
  },
  "chathispano.com": { c: 7 },
  "forzearmate.org": { s: "#WPS_popup_message{display:none !important}" },
  "ntp-shop.it": { s: ".bottomBarMessage{display:none !important}" },
  "grazia-magazin.de": { s: ".safeSpaceForClose{display:none !important}" },
  "twed.com": { s: ".topline_wrapper{display:none !important}" },
  "audito.fr": { s: "#iframe_cc{display:none !important}" },
  "watfordfc.com": { s: ".wfc-m-cookie{display:none !important}" },
  "badkissingen.de": { s: "#chint{display:none !important}" },
  "liquidhearth.com": { c: 1 },
  "nick.com": { c: 94 },
  "sogeti.nl": { j: "5" },
  "brenntag.com": { s: ".page-hint-box{display:none !important}" },
  "luebben.de": { s: "#datenschutz-wrapper{display:none !important}" },
  "teamliquidpro.com": { c: 1 },
  "sheknows.com": { s: "#dfp-interstitial-holder{display:none !important}" },
  "mrsmithcasino.co.uk": {
    s: ".global-inline-notifications{display:none !important}",
  },
  "robertsspaceindustries.com": {
    s: ".bottom-notif-bar,.l-notification-bar{display:none !important}",
  },
  "surveycircle.com": { s: "#consent_info{display:none !important}" },
  "amnesty.fr": {
    s: "#content > div > div:not([style]):not([id]){display:none !important}",
  },
  "daimler.de": { j: "5" },
  "zomoto.nl": { j: "5" },
  "willys.se": { s: ".ax-global-messages{display:none !important}" },
  "greek-weather.org": { s: ".notice-top{display:none !important}" },
  "anisearch.de": { s: ".urgent-msg{display:none !important}" },
  "rocva.nl": {
    s: ".brochure-overlay,.brochure-overlay-bg{display:none !important}",
  },
  "giornalepop.it": { s: "#policy-alert{display:none !important}" },
  "badplaats.nl": { s: ".cnotice{display:none !important}" },
  "futurelearn.com": {
    s: '.m-heads-up-banner[aria_label="Cookie banner"]{display:none !important}',
  },
  "ksk-koeln.de": { s: "#dpWarningWrapper{display:none !important}" },
  "infogreffe.fr": {
    s: ".trackingCookiesDisclaimer .header{margin-top:0 !important}",
  },
  "bulls.de": {
    s: 'footer > div[class*="cookie-hinweis"]{display:none !important}',
  },
  "fairmondo.de": { s: ".l-news-header{display:none !important}" },
  "ou.nl": { s: "#M093A{display:none !important}" },
  "vodafone.hu": { s: ".cookie_fix{display:none !important}" },
  "tarifaexpert.hu": { s: ".lablec_suti_szabaly{display:none !important}" },
  "grammophon-platten.de": { c: 54 },
  "supercanemagic.com": { s: "#SE-disclaimer{display:none !important}" },
  "suzuki.nl": { s: ".page-helper__content--cookies{display:none !important}" },
  "symscooters.nl": { c: 63 },
  "mypeopledoc.com": { s: ".tall .update{display:none !important}" },
  "viewsoniceurope.com": { c: 7 },
  "kuki.cz": { s: "#fuckeu{display:none !important}" },
  "psc.cz": { c: 12 },
  "l1.nl": { s: "#l1_cookie_policy{display:none !important}" },
  "eclipsecomputers.com": { s: ".pagecookie{display:none !important}" },
  "vertaa.fi": {
    s: 'div[data-rendering-area="dialogs"] [data-bind*="ui.dialogs.PopupBehavior"]{display:none !important}',
  },
  "efset.org": { s: "body > .aa{display:none !important}" },
  "hemkop.se": { s: ".ax-global-messages{display:none !important}" },
  "wuerzburg.de": { s: "#chint{display:none !important}" },
  "hdi.global": { s: ".js-top-header{display:none !important}" },
  "inforete.it": { c: 1 },
  "keyforweb.it": { s: "#dcb-black-screen{display:none !important}" },
  "wseven.info": { s: "#ntf{display:none !important}" },
  "akrapovic.com": { s: ".cookies-bubble{display:none !important}" },
  "poigps.com": { s: "#poigps_cookie_advice{display:none !important}" },
  "gourmet.at": { s: ".row-wrapper.blackbox{display:none !important}" },
  "mondial-assistance.fr": { c: 128 },
  "rabla.ro": { s: 'body > div[id=""]{display:none !important}' },
  "manualsearcher.com": {
    s: "body.cookie-notice > #wrapper,body.cookie-notice > #footer-bottom,body.cookie-notice > #footer{filter:none;-webkit-filter:none;-moz-filter:none}",
  },
  "smartenergygb.org": { s: ".segb-cookiecompliance{display:none !important}" },
  "vectonemobile.nl": { s: "#alert_home{display:none !important}" },
  "runtervomgas.de": { j: "5" },
  "ristorantegellius.it": { c: 43 },
  "shopwelt.de": { s: "#dateschutzinfo{display:none !important}" },
  "rankinglekarzy.pl": { c: 37 },
  "robeco.nl": { s: "#container{margin:0 auto !important}" },
  "teesbusinesscompass.co.uk": { j: "5" },
  "lovepedia.net": { s: ".policy-banner{display:none !important}" },
  "weather2umbrella.com": { s: "#w2u_cookie_notice{display:none !important}" },
  "euractiv.es": { s: "#avisosusc{display:none !important}" },
  "qlstats.net": { j: "5" },
  "nacesty.cz": { s: "#term-of-use{display:none !important}" },
  "tallsay.com": { j: "5" },
  "viactt.pt": { s: ".popupContainer{display:none !important}" },
  "procyclingstats.com": { c: 1 },
  "lesoriginelles.fr": { c: 19 },
  "fatface.com": { s: "#messages{display:none !important}" },
  "openlibra.com": { j: "5" },
  "casinoeuro.com": { s: ".growl-container{display:none !important}" },
  "emtecko.cz": { s: "#__loadCookie{display:none !important}" },
  "fishersci.fr": { s: "#legalMessageWrapper{display:none !important}" },
  "telkom.co.za": { s: "#PrivacyNotice{display:none !important}" },
  "broughtons.com": { c: 95 },
  "idee-fuer-mich.de": { s: ".subNaviNotification{display:none !important}" },
  "hessenchemie.de": { s: ".readcookie{display:none !important}" },
  "erkel.hu": { s: "#suti_info{display:none !important}" },
  "freeonlinegames.com": { s: "#cwarn-box{display:none !important}" },
  "paf.es": { s: ".mo-notification-bar-fixed{display:none !important}" },
  "metropolisweb.it": { s: "#informativa{display:none !important}" },
  "vocabolariotreccani.it": { s: "footer{display:none !important}" },
  "kum.dk": { c: 46 },
  "my-supps.de": { s: ".pn_container{display:none !important}" },
  "yomoni.fr": { s: ".header__cook{display:none !important}" },
  "enel.it": { s: ".message-notification{display:none !important}" },
  "tradukka.com": { j: "5" },
  "radioveronica.nl": { j: "5" },
  "zorgverzekeringhema.nl": { j: "5" },
  "prorun.nl": { s: "body > div[id]:not([class]){display:none !important}" },
  "go4celebrity.com": { s: ".ccc{display:none !important}" },
  "werkstatt-betrieb.de": { s: ".cooco-window{display:none !important}" },
  "bapr.it": {
    s: "#policy_id{display:none !important}#wrapper{padding-top:0 !important}",
  },
  "meandermc.nl": { j: "5" },
  "accessibilitacentristorici.it": {
    s: "#htmlbox_div1{display:none !important}",
  },
  "innoq.com": { s: ".tracking-wrapper{display:none !important}" },
  "maschinewerkzeug.de": { s: ".cooco-window{display:none !important}" },
  "freetranslation.com": {
    s: "w-div{display:none !important}html.wf-active body[class]::before{height:0 !important}",
  },
  "magiogo.sk": { s: ".headerMessages{display:none !important}" },
  "naacesrf.com": { s: "#cklbox{display:none !important}" },
  "ajurveda-brno.cz": { s: ".notify{display:none !important}" },
  "studioevil.com": { s: "#SE-disclaimer{display:none !important}" },
  "miciny.cz": { c: 129 },
  "dagelijksestandaard.nl": { s: ".dgd_stb_box{display:none !important}" },
  "energiedirect.nl": { s: "#wall{display:none !important}" },
  "volvotrucks.gr": { s: ".headerNotification{display:none !important}" },
  "net-s.pl": { s: ".regulations{display:none !important}" },
  "rozwojowiec.pl": { c: 129 },
  "jobbio.com": { c: 25 },
  "hotel-sonnblick.at": { s: ".pageCookie{display:none !important}" },
  "haalo.pl": { s: "#cooks{display:none !important}" },
  "holfuy.com": { c: 12 },
  "alatest.de": { c: 118 },
  "floriantravel.com": { s: ".cookieatata{display:none !important}" },
  "canrosendo.com": { s: "#cookies-wrapper2{display:none !important}" },
  "czesci-samochodowe.wroclaw.pl": { c: 13 },
  "sockshop.co.uk": { s: "#CNwrap{display:none !important}" },
  "scandtrack.com": { s: "#st_cookie{display:none !important}" },
  "bzwbk.pl": { s: ".cookie-btn{display:none !important}" },
  "newsnow.co.uk": { s: "#pmbar{display:none !important}" },
  "gruppocarraro.it": { c: 1 },
  "riddarhuset.se": { s: ".cookieWidget{display:none !important}" },
  "dvdbluray.hu": { s: "#sutibox{display:none !important}" },
  "nickjr.com": { c: 94 },
  "loto.ro": { s: ".top-cookies{display:none !important}" },
  "volkswagen.it": { s: "#trackingPolicy{display:none !important}" },
  "guidastudenti.it": { s: ".barraPrivacy{display:none !important}" },
  "sokkaljobb.hu": { s: "#SPS_noaccept{display:none !important}" },
  "webmonkeysoftware.it": { s: "#Divcookie{display:none !important}" },
  "staffettaonline.com": {
    s: "#ctl00_CtrlLogAbbonato1_cookiealert{display:none !important}",
  },
  "sportetstyle.fr": { c: 55 },
  "juegosdiarios.com": { s: ".bottombar{display:none !important}" },
  "voicegroup.co.uk": { s: ".cookie-menu{display:none !important}" },
  "vicenteamigo.com": { s: ".cva_accept{display:none !important}" },
  "mixare.org": { s: ".rain1-cp-container{display:none !important}" },
  "hilzingen.de": { c: 53 },
  "faelectronic.it": { c: 55 },
  "fastalp.biz": { c: 47 },
  "svapoworld.com": { s: "#policy-alert{display:none !important}" },
  "kyokugym.nl": { c: 19 },
  "digiminster.com": { c: 25 },
  "grebbeberg.nl": { s: "#acceptscp2012{display:none !important}" },
  "365curtains.com": { s: ".top_warning{display:none !important}" },
  "hybridshop.co.uk": { c: 19 },
  "urbanfires.co.uk": { c: 19 },
  "fuba.com": { s: "#cover{display:none !important}" },
  "batcmd.com": { s: "#cmsg{display:none !important}" },
  "mtom-mag.com": { s: "#alert_trk{display:none !important}" },
  "itrebon.cz": { s: ".info-okno{display:none !important}" },
  "jeveuxlafibre.re": { s: "#les_cookies{display:none !important}" },
  "eko-care.si": { s: ".ndp-panel{display:none !important}" },
  "miliboo.com": { s: ".m-milibooCookie{display:none !important}" },
  "capgroup.com": { s: "#sb-container{display:none !important}" },
  "aquaparksenec.sk": { s: "#PovInfCoo{display:none !important}" },
  "muzeummw.pl": { s: ".cookieForm{display:none !important}" },
  "netbridge.dk": { s: "#bkg{display:none !important}" },
  "uresmykker.dk": { c: 1 },
  "gov.wales": {
    s: "#govwales-cookie-notice{display:none !important}body.cookie-message-visible{background-position:0 0 !important}",
  },
  "seguroscity.com": { s: "#galleta{display:none !important}" },
  "molfettalive.it": { s: "#Info{display:none !important}" },
  "bloomsbury.com": { s: ".stickyFooter{display:none !important}" },
  "twojliquid.pl": { c: 37 },
  "fragasyv.se": { s: "#siteflash{display:none !important}" },
  "campisiconserve.it": { s: "body > span{display:none !important}" },
  "szexpartnerindex.hu": { s: "#cookiewindow{display:none !important}" },
  "gocards.nl": { c: 66 },
  "uneo-avantages.fr": { s: ".bCnil{display:none !important}" },
  "algerieinfo.com": { s: "body > center > font{display:none !important}" },
  "geoblog.pl": { s: "#cContainer{display:none !important}" },
  "mojbrzuch.pl": { s: "#__cookies_{display:none !important}" },
  "weetabix.co.uk": { s: ".oCookie{display:none !important}" },
  "lacnews24.it": { s: "#overlay_pri,#box1{display:none !important}" },
  "talentsoft.com": { s: "#cnil_message{display:none !important}" },
  "italradio.org": { s: ".privacyStatement{display:none !important}" },
  "misterfox.co": { c: 1 },
  "fijlkam.it": { s: "#privacy-wrapper{display:none !important}" },
  "dieantenne.it": { s: "#camp{display:none !important}" },
  "sigmastudio.it": { c: 38 },
  "candycastle.nl": { s: ".cookiesC{display:none !important}" },
  "tokiomarine.com": {
    s: ".navigation-secondary-top{display:none !important}",
  },
  "privatesportshop.es": { c: 1 },
  "online24.pt": { c: 55 },
  "sydmaquinaria.com": { s: "#infoContainer{display:none !important}" },
  "lettercount.com": { c: 121 },
  "dirtyrhino.com": { c: 1 },
  "gdjenamore.com": { s: ".kolacic{display:none !important}" },
  "immense-serie.com": { s: "#cookie_auth{display:none !important}" },
  "pirk.lt": { s: "#toolbar_container{display:none !important}" },
  "caferosenhaven.dk": { c: 1 },
  "confort-sauter.com": { s: "#block-notice{display:none !important}" },
  "digi-work.com": { s: "#mobileHeader{display:none !important}" },
  "allplay.pl": { c: 1 },
  "krups.com.pl": { c: 1 },
  "vlmedicina.lt": { s: ".div_cookie_bg{display:none !important}" },
  "longines.it": { j: "5" },
  "pierreetvacances.com": {
    s: "#didomi-host{display:none !important} .didomi-popup-open{overflow:unset !important}",
  },
  "teoma.com": { s: "#cp-banner{display:none !important}" },
  "coinucid.it": { c: 19 },
  "alternativa.fr": { j: "5" },
  "nextdoor.nl": { s: "#top_banner{display:none !important}" },
  "groepsaccomodaties.org": { j: "5" },
  "sportechplc.com": { s: ".mdl-notification{display:none !important}" },
  "oneyeartarget.com": { c: 122 },
  "france.fr": { s: ".atfcookie{display:none !important}" },
  "tetrainfo.com": { s: "#tetrainfo_eu{display:none !important}" },
  "xxxvogue.net": { c: 1 },
  "futbolenvivoargentina.com": { c: 7 },
  "mols-linien.dk": { s: ".CInfo{display:none !important}" },
  "prague-catering.cz": { s: ".feuc{display:none !important}" },
  "k-tuinskool.com": { s: "#c-cookies{display:none !important}" },
  "musixmatch.com": { s: ".mxm-cookie-alert{display:none !important}" },
  "megascans.se": {
    s: "#react-app > div:not([data-reactid]){display:none !important}",
  },
  "nosolosalud.com": { s: "#downbar{display:none !important}" },
  "fahrrad-kuechler.de": {
    s: '.cookieHintVisible div[class*="cookie-hinweis"]{display:none !important}',
  },
  "gerlach.org.pl": { s: "#top0info{display:none !important}" },
  "cartests.net": { s: ".messi{display:none !important}" },
  "wellmall.cz": { c: 119 },
  "entirelyholby.co.uk": { c: 19 },
  "belfastmet.ac.uk": { s: "#div-alerts-wrapper{display:none !important}" },
  "medizzine.com": { s: ".alerta{display:none !important}" },
  "riassuntini.com": { s: ".banner.section.white-bg{display:none !important}" },
  "paskoluklubas.lt": { j: "5" },
  "motohid.pl": {
    s: "#simple-modal-overlay,#simple-modal{display:none !important}",
  },
  "copyrightpolska.pl": { s: "#cookie-ack{display:none !important}" },
  "beeshary.com": { c: 21 },
  "neobiznes.pl": { s: "#cpolicyHolder{display:none !important}" },
  "zgodafc.pl": { c: 1 },
  "benissa.net": { s: "#faldon{display:none !important}" },
  "latiendahome.com": { s: ".cookie_validation{display:none !important}" },
  "lincelot.com": { s: ".columbus-background{display:none !important}" },
  "capri-lublin.pl": { s: "#mod98{display:none !important}" },
  "dafmuseum.com": { s: ".page-overlay{display:none !important}" },
  "rw2010.pl": { c: 44 },
  "wecare.gr": { s: ".ee-cookie{display:none !important}" },
  "esinvesticijos.lt": { s: "#pre_header{display:none !important}" },
  "casaktua.com": { c: 10 },
  "procycles43.fr": { s: "#divacacher{display:none !important}" },
  "tuodi.it": { c: 13 },
  "beko.gr": {
    s: ".sayfaDisDiv > .sayfaIcDiv > .row300{display:none !important}",
  },
  "nordpasdecalais.fr": { s: "#bandeauCnil{display:none !important}" },
  "bubblebed.bg": { s: ".gs-cookies-review{display:none !important}" },
  "hijob.me": { s: ".flash-cookie{display:none !important}" },
  "iabfrance.com": { s: "#boxAlert{display:none !important}" },
  "thejukeboxman.com": { s: ".promo-banner{display:none !important}" },
  "wholefoodsmarket.com": { s: ".QSISlider{display:none !important}" },
  "bad-wildbad.de": { c: 53 },
  "eleonline.it": {
    s: '#content > div[style*="fixed"]{display:none !important}',
  },
  "evopayments.eu": { s: "#zwcc{display:none !important}" },
  "noleggiodiy.it": { s: "#privacySlider{display:none !important}" },
  "echevarne.com": { c: 117 },
  "asuntosaatio.fi": { s: ".js-disclaimer-dismiss{display:none !important}" },
  "osiander.de": { s: "#onlyCookie{display:none !important}" },
  "lyleandscott.com": { s: "#cookieCont{display:none !important}" },
  "get-notes.com": { c: 19 },
  "sachsen-tourismus.de": { s: "#xcm-bar{display:none !important}" },
  "significados.com.br": { c: 55 },
  "daimonin.org": { s: "#ecl_outer{display:none !important}" },
  "karvancevitam.nl": { c: 1 },
  "homelet.co.uk": { s: ".cp-wrapper{display:none !important}" },
  "desall.com": { s: "#stripe{display:none !important}" },
  "gel.com": { c: 38 },
  "buddhismguide.org": { s: "#info_text_header{display:none !important}" },
  "afs.de": { s: ".afs_coi{display:none !important}" },
  "autoklicecz.cz": { s: "#cookiesI{display:none !important}" },
  "gamerswalk.com": {
    s: ".cookies--visible + .header,.cookies--visible + .header + .main,.cookies--visible + .header-fos{margin-top:0 !important}",
  },
  "ggintegral.fr.nf": { c: 1 },
  "learn-french-free-with-stories.weebly.com": {
    s: "#header-top{display:none !important}",
  },
  "inzeratyzadarmo.sk": { s: "#coo_source{display:none !important}" },
  "myproducts.bandce.co.uk": { c: 21 },
  "d-cycling.nl": { c: 27 },
  "initalia.it": { c: 95 },
  "playinfinity.it": { c: 7 },
  "vta.lt": { s: ".cooask{display:none !important}" },
  "thefourthphase.com": {
    s: "#red-bull-cookie-notification{display:none !important}",
  },
  "radiologie-mannheim.de": { c: 38 },
  "securedbydesign.com": { s: ".interimpopup{display:none !important}" },
  "fc-koeln.de": { s: ".mod-alert{display:none !important}" },
  "rkw-kompetenzzentrum.de": { s: "#rkw-infolayer{display:none !important}" },
  "mivoq.it": { s: ".check-policy{display:none !important}" },
  "atlas-roslin.pl": { s: ".tytul > span{display:none !important}" },
  "bptour.pl": { c: 1 },
  "chaptercheats.com": { s: ".headertp{display:none !important}" },
  "jusan.it": { c: 34 },
  "drivingskillsforlife.nl": { s: "#popup_custom{display:none !important}" },
  "autentiek.nl": { s: "#ciWrapper{display:none !important}" },
  "hezkakoupelna.cz": { c: 119 },
  "noclegi24h.pl": { c: 1 },
  "etransport.pl": { j: "5" },
  "agenceecofin.com": { s: ".pwebbox{display:none !important}" },
  "eco-sunglasses.com": { s: "#first_visit_message{display:none !important}" },
  "sg-weber.at": { c: 52 },
  "thebtas.co.uk": { s: ".slidepanel_oter{display:none !important}" },
  "alphotel.at": { s: "#tx_tracking{display:none !important}" },
  "cimoc.com": { s: "#styleUp{display:none !important}" },
  "spglobal.com": { s: "#privacyPlicyBanner{display:none !important}" },
  "maregel.net": { c: 21 },
  "barclays.it": { s: "#boxTextCookie{display:none !important}" },
  "cantinesettesoli.it": {
    s: ".modal-privacy.attiva{display:none !important}",
  },
  "hdr-photographer.com": { s: "#rn_container{display:none !important}" },
  "dnbfeed.no": { c: 1 },
  "mct-corp.com": { s: ".uk-alert{display:none !important}" },
  "acierto.com": { s: "#blockdisclaimer{display:none !important}" },
  "rio2016.coni.it": { s: "#privacy-wrapper{display:none !important}" },
  "singles-in-stuttgart.de": { s: "#DC{display:none !important}" },
  "lycos.fr": { c: 96 },
  "alpenradio.net": {
    s: 'div[data-wzb="CookieNotification"] iframe{display:none !important}',
  },
  "skyradio.nl": { j: "5" },
  "valeofglamorgan.gov.uk": { s: "#fixed-bar{display:none !important}" },
  "slikomat.com": { s: ".jquery-bar{display:none !important}" },
  "societapiemonteseautomobili.com": { c: 21 },
  "life365.eu": { c: 1 },
  "taxipedia.info": { s: "#fpub-popup{display:none !important}" },
  "openprof.com": { s: "#cookie_id{display:none !important}" },
  "przelewy24.pl": { s: "#policy_container{display:none !important}" },
  "bankomatfinder.at": { s: "#c-cookie{display:none !important}" },
  "drive-smart.com": { s: ".dri-ncookies-alert{display:none !important}" },
  "tns.fr": { s: "#pop-cnil{display:none !important}" },
  "casinodeparis.fr": { c: 27 },
  "hoelangnog.nl": {
    s: "body > .container.transparency h3{display:none !important}",
  },
  "arch-homes.co.uk": {
    s: "#cookiepaneltab,#cookiepaneltab ~ .ui-dialog{display:none !important}",
  },
  "claremontconsulting.co.uk": { s: "#demo-bar{display:none !important}" },
  "sgp.nl": { s: ".footer-msg{display:none !important}" },
  "24chasa.bg": { c: 130 },
  "ismatteirecanati.it": { c: 19 },
  "sonypictures.net": { s: "#sp-nettrack{display:none !important}" },
  "axa.cz": { s: ".axa-cookies{display:none !important}" },
  "payback.it": { j: "5" },
  "kcprofessional.nl": {
    s: "#optIn,#optIn ~ .reveal-modal-bg,.alert-box{display:none !important}",
  },
  "midas.pt": { s: ".bg_cookie{display:none !important}" },
  "rocdesalpes.com": { c: 62 },
  "symfonia.org": { s: "#eu-dir{display:none !important}" },
  "lirelactu.fr": {
    s: '#app > div[data-reactroot] > div[class*="container"]{display:none !important}',
  },
  "contratprive-recette.6tzen.fr": { c: 7 },
  "lecrazyhorseparis.com": {
    s: "#wrapper.home_cookie #header{margin:0 !important}",
  },
  "quotidianoenergia.it": { c: 12 },
  "certina.com": { s: ".footer-cnil-wr{display:none !important}" },
  "opticjungle.gr": { s: "#sid-container{display:none !important}" },
  "drinkdruid.com": { s: "#sid-container{display:none !important}" },
  "cyclemiles.co.uk": { s: "#messages-cont{display:none !important}" },
  "droidchart.com": { c: 93 },
  "techknow.ie": { c: 19 },
  "weetabixfoodcompany.co.uk": { s: ".oCookie{display:none !important}" },
  "venditamobiligiapponesi.it": {
    s: ".sa-notification-bar{display:none !important}body{padding-top:0 !important}",
  },
  "wyrobieniepaszportu.pl": { c: 1 },
  "loccioni.com": { s: "#box.fascia{display:none !important}" },
  "mediatheque-chabris.net": { c: 67 },
  "bartek.com.pl": { s: "#journal-cookies{display:none !important}" },
  "galnet.fr": { s: "#topnotecontainer{display:none !important}" },
  "mybustracker.co.uk": { s: "#zoneCookie{display:none !important}" },
  "cliente.enerxenia.it": {
    s: ".commons-alert-overlay,.commons-alert-box{display:none !important}",
  },
  "musicclub.eu": { c: 7 },
  "hiboox.fr": { c: 55 },
  "checklistwebwinkel.nl": { s: "#smbv_splash{display:none !important}" },
  "portalinvatamant.ro": { s: "#terms{display:none !important}" },
  "designfund.dk": { s: ".sleeknote{display:none !important}" },
  "eleicoes2014.com.br": { c: 55 },
  "digitalshoping.com": { c: 21 },
  "ophetwww.net": {
    s: '#footer_container ~ div,script[src*="cookies.min.js"] ~ div{display:none !important}',
  },
  "killarneyroyal.ie": { s: ".PPContent{display:none !important}" },
  "fishersci.nl": { s: "#legalMessageWrapper{display:none !important}" },
  "digimobil.it": { c: 131 },
  "tarhely.eu": { s: "#sutik{display:none !important}" },
  "rail.phototrans.eu": { c: 1 },
  "kwf.nl": { s: ".cbar-wrapper{display:none !important}" },
  "viciodigital.es": { s: "#adk_acblock{display:none !important}" },
  "privacy.sbs.nl": { j: "5" },
  "prixtel.com": { s: "#wpx_cookie{display:none !important}" },
  "wishy.it": { c: 7 },
  "mora.nl": {
    s: ".clNotice{display:none !important}.clNoticeVisible{margin-top:0 !important}",
  },
  "weberbeamix-dhz.nl": { c: 52 },
  "hotmilfzone.com": { c: 1 },
  "armedunity.com": { s: ".ipsMessage_error{display:none !important}" },
  "maribor-pohorje.si": { s: ".cookeEnabler{display:none !important}" },
  "google-cache.de": { s: "#meldungContainer{display:none !important}" },
  "ajoto.com": { c: 43 },
  "linkgroup.pl": { s: "#lg_cookies{display:none !important}" },
  "avia.de": { s: ".cs-info-wrapper{display:none !important}" },
  "viber.com": { c: 47 },
  "skapiec.pl": { s: ".cookies-rwd{display:none !important}" },
  "telia.fi": {
    s: '.app-content-scroll-container .notification-inline,.notification[data-cookiename="cookies_fi"],#yhteiso-messages,.notification--blue{display:none !important}',
  },
  "ultrahack.org": {
    s: ".app > hr:first-child + div:not([class]):not([id]){display:none !important}",
  },
  "radio24syv.dk": { s: ".r24syv-cookie-notice{display:none !important}" },
  "cercolavoro.com": { c: 25 },
  "tp.lpp.si": { s: 'body > table[height="20"]{display:none !important}' },
  "piib.org.pl": {
    s: "#divcooinf{display:none !important}body{background-position:0 0 !important}",
  },
  "allianz-assistance.es": { c: 128 },
  "trony.it": {
    s: ".smcc_overlay_cokkieaccept,.smcc_modal_cokkieaccept{display:none !important}",
  },
  "hmerologio.gr": { s: "#sid-container{display:none !important}" },
  "prawobrzeze.info": { c: 1 },
  "sanprobi-superformula.pl": { c: 1 },
  "boxannunci.com": { s: ".terms{display:none !important}" },
  "shopforshop.it": { s: "body > span{display:none !important}" },
  "upendo.tv": { c: 10 },
  "virginmoneygiving.com": { s: "#blank-container{display:none !important}" },
  "mjam.net": { s: "#__Mjam__CookieBanner{display:none !important}" },
  "vercapas.com": { s: ".footerck{display:none !important}" },
  "168chasa.bg": { c: 130 },
  "wienerborse.at": { s: "#page-alert{display:none !important}" },
  "opel.nl": { c: 27 },
  "familylawweek.co.uk": { s: "#zeus_box{display:none !important}" },
  "egarage.de": { s: "#fpub-popup{display:none !important}" },
  "banaxi.com": { s: "#form2 > div[style]{display:none !important}" },
  "prawdaobiektywna.pl": { s: "#mcpc{display:none !important}" },
  "irozhlas.cz": { s: ".b-cookie{display:none !important}" },
  "pravda.sk": { s: ".sticky-cookies{display:none !important}" },
  "telegraafvandaag.nl": { j: "5" },
  "dewereldmorgen.be": {
    s: "#cookie-consent-overlay ~ div[style]{display:none !important}",
  },
  "wanttoknow.nl": { c: 77 },
  "donnons.org": { s: ".head-line{display:none !important}" },
  "tastedive.com": { s: ".tk-Footer-cc{display:none !important}" },
  "polygon.com": { c: 56 },
  "toffeeweb.com": { s: "#fixedFooter{display:none !important}" },
  "bgfermer.bg": { c: 130 },
  "watchfinder.co.uk": { s: "#cookie_{display:none !important}" },
  "mediamarkt.nl": { j: 5 },
  "mediamarkt.de": { j: 5 },
  "mediamarkt.it": { j: 5 },
  "mediamarkt.at": { j: 5 },
  "mediamarkt.be": { j: 5 },
  "mediaworld.it": { j: 5 },
  "mediamarkt.es": { j: 5 },
  "saturn.de": { j: 5 },
  "gonnesa.ca.it": { s: "#fake-div{display:none !important}" },
  "motorsport.com": {
    s: ".ms-footer-fixbox,.ms-header-messages,#privacy_accept{display:none !important}",
  },
  "lifeisstrange.com": { s: ".comp-flash-notice{display:none !important}" },
  "zumba.com": { c: 26 },
  "plt.nl": { j: "5" },
  "bgdnes.bg": { c: 130 },
  "acquabella-construplas.com": { s: "#ico_wrapper{display:none !important}" },
  "gorillaz.com": { c: 127 },
  "toornament.com": { s: ".cookie-legal{display:none !important}" },
  "manikowski.de": { c: 126 },
  "streetz.se": { c: 19 },
  "hudsonsbay.nl": { s: ".gk-stickymessage{display:none !important}" },
  "minecraft-serverlist.net": { s: "#ingameCookie{display:none !important}" },
  "distri.cz": { c: 1 },
  "mojehobby.pl": { s: ".message-footer-panel{display:none !important}" },
  "wegenerwordpress.nl": { j: "5" },
  "receptentabel.nl": {
    s: "#loading,#loading + .noblur{display:none !important}",
  },
  "omnires.pl": { s: ".cookie-allcontent{display:none !important}" },
  "plazilla.com": { j: "5" },
  "pathfinder-w.space": { s: "#pf-cookie-hint{display:none !important}" },
  "flyingtiger.com": { s: ".save-cookies{display:none !important}" },
  "upolujebooka.pl": { c: 42 },
  "ingdirect.fr": { s: "#cookieManagement{display:none !important}" },
  "racked.com": { s: "#privacy-options{display:none !important}" },
  "drmartens.com": { s: ".dm-cookie-container{display:none !important}" },
  "meubella.nl": { s: ".cnotice{display:none !important}" },
  "plan.de": { s: ".psg-cookie{display:none !important}" },
  "niknot.com": { s: ".cLaw_mainCnt{display:none !important}" },
  "ftb.world": { c: 7 },
  "socialmediaacademie.nl": { j: "5" },
  "restaurantweek.pl": { s: ".cookiesLaw{display:none !important}" },
  "zerochan.net": { c: 12 },
  "hemglass.se": { s: ".message-popup{display:none !important}" },
  "umziehen.de": { s: "#mcCookie{display:none !important}" },
  "asendia.de": { s: ".body.body--is-alerted{padding-top:0 !important}" },
  "skoda-connect.com": {
    s: ".notification-container{display:none !important}",
  },
  "agenziademanio.it": { s: "#bannerInfo{display:none !important}" },
  "fashionlab.nl": { j: "5" },
  "kortingscouponcodes.nl": { c: 97 },
  "swaper.com": { s: "#confirm-stripe{display:none !important}" },
  "smarkets.com": { s: ".notices-wrapper{display:none !important}" },
  "mooiedeal.nl": { c: 66 },
  "weequizz.com": { s: ".bt_cookie{display:none !important}" },
  "wyevalegardencentres.co.uk": {
    s: "#privacyStatement{display:none !important}",
  },
  "maquillalia.com": { s: "#coke{display:none !important}" },
  "opencaching.de": { j: "5" },
  "conseils-thermiques.org": { s: ".display_cookies{display:none !important}" },
  "nazwa.pl": { s: "#policy-box{display:none !important}" },
  "animod.de": { s: "#animod-c{display:none !important}" },
  "gogift.com": { s: ".iziToast-wrapper{display:none !important}" },
  "autozeeland.nl": { s: "#cpol{display:none !important}" },
  "zeta.nu": { s: "#oddcookie{display:none !important}" },
  "fitnessuebungen-zuhause.de": {
    s: "#cookie[type] + div{display:none !important}",
  },
  "reco.se": { s: ".pms.bg-white.cntr{display:none !important}" },
  "asiaflash.com": { c: 31 },
  "qshops.org": { s: ".loading.cache-loading{display:none !important}" },
  "kfc.co.uk": { s: ".cookies-view{display:none !important}" },
  "openmind-shop.de": { s: ".content-cookie{display:none !important}" },
  "valleyvet.com": { s: "#ToU_float{display:none !important}" },
  "hellostudent.co.uk": { c: 7 },
  "amref.it": { s: "#divCk{display:none !important}" },
  "tube.nl": { j: "5" },
  "rechtopgeld.nl": { j: "5" },
  "hboespana.com": { s: "#main-warning{display:none !important}" },
  "lsb.dk": { s: "#notificationBar{display:none !important}" },
  "kamilianie.eu": { c: 12 },
  "weshop.co.uk": { c: 11 },
  "moneybird.nl": {
    s: ".biscuit-message-is-active .page,.biscuit-message-is-active .header{transform:none !important}",
  },
  "destockplus.com": { s: ".page_warning{display:none !important}" },
  "gwp.pl": { c: 68 },
  "ragusanews.com": { s: "#barra{display:none !important}" },
  "curverstyle.pl": { c: 1 },
  "pro-bikegear.com": { c: 37 },
  "ingmarkets.com": {
    s: ".no-cookies-pref{position:static !important}.no-cookies-pref:after{display:none !important}",
  },
  "helicomicro.com": { s: ".cp-info-bar{display:none !important}" },
  "pendlerinfo.org": { s: "#containerDataProtection{display:none !important}" },
  "stargazerslounge.com": {
    s: ".ipsfocus-globalMessage{display:none !important}",
  },
  "asst-pg23.it": { s: "#divInformativaBreve{display:none !important}" },
  "teb.com.tr": { s: "#cokieMain{display:none !important}" },
  "palma.cat": { s: "#avisolssi{display:none !important}" },
  "nolotech.jimdo.com": {
    s: ".powr-popup.powrLoaded{display:none !important}",
  },
  "framtiden.com": { s: ".sol-cookies{display:none !important}" },
  "uhren-miquel.de": { s: ".ui-dialog.innoPrivacy{display:none !important}" },
  "tysol.pl": { s: "#cooinfo{display:none !important}" },
  "torebrings.se": { c: 25 },
  "lesinfos.ma": { s: "#bottomBar{display:none !important}" },
  "scio.pw": { c: 54 },
  "tooba.pl": { s: ".dialog-serwis-msg.dialog-fixed{display:none !important}" },
  "historicengland.org.uk": { s: ".alert-banner{display:none !important}" },
  "pensburgh.com": { c: 56 },
  "yoy.tv": { c: 11 },
  "habitat76.fr": { s: ".header-cnil{display:none !important}" },
  "recast.ai": { s: ".Toasts{display:none !important}" },
  "meetic.fr": { s: ".main-frame-bottom-strip{display:none !important}" },
  "chinamobiel.nl": { c: 19 },
  "calorielijst.nl": {
    s: "#loading,#loading + .noblur{display:none !important}",
  },
  "theonlinesurgery.co.uk": { s: ".alert.ue-content{display:none !important}" },
  "youmobile.es": { s: ".iklon{display:none !important}" },
  "lxax.com": {
    s: "body > div:not([id]):not([class]):not([title]){display:none !important}",
  },
  "reindicium.com": { j: "5" },
  "lbp.me": { s: "#error-overlay{display:none !important}" },
  "fdrive.cz": { s: ".sys-alert{display:none !important}" },
  "voxmedia.com": { c: 56 },
  "kabeltje.com": { s: "body > .mbdialog{display:none !important}" },
  "fristadskansas.com": { j: "5" },
  "regiobank.nl": { s: "#cleanPageContainer{display:none !important}" },
  "sbnation.com": { c: 56 },
  "societegenerale.rs": { s: "#sgs_cookie{display:none !important}" },
  "spycolor.com": { s: "#policy-window{display:none !important}" },
  "weck.com.pl": { s: "#popup2{display:none !important}" },
  "aab.dk": { s: ".cookieinject{display:none !important}" },
  "ikgastarten.nl": { j: "5" },
  "cookiesv2.publiekeomroep.nl": { j: "5" },
  "curbed.com": { c: 56 },
  "eumostwanted.eu": { s: "#sortingPreference{display:none !important}" },
  "swedoor.dk": { s: "#swedoor_privacy_widget{display:none !important}" },
  "davplus.de": { s: ".cookiesmanager{display:none !important}" },
  "salus.de": {
    s: '.notification[data-identifier="cookie"]{display:none !important}',
  },
  "tripplite.com": { j: "5" },
  "e-b-z.de": { s: "#cooklay{display:none !important}" },
  "janrain.com": { s: ".wptbbarheaddiv{display:none !important}" },
  "dccomics.com": { c: 98 },
  "liquidlegends.net": { c: 12 },
  "allianz-voyage.fr": { c: 128 },
  "sane.org.uk": { s: "#jxcc-bar{display:none !important}" },
  "gotobrno.cz": { s: ".b-cookie{display:none !important}" },
  "krug.com": { s: "#_evh-ric-age-gate{display:none !important}" },
  "ekino-tv.pl": { c: 0 },
  "stilenaturale.com": { s: "#adw-bottombanner{display:none !important}" },
  "dyson.co.uk": { s: ".js-notifications{display:none !important}" },
  "torinostar.it": { s: "#footerprivacy{display:none !important}" },
  "software4u.de": { s: "#mainNav{top:0 !important}" },
  "sahamassurance.ma": { s: "#rubon{display:none !important}" },
  "toolbox.com": {
    s: "#m_privacyPolicy_privacyNotice{display:none !important}",
  },
  "phoneklinik.com": {
    s: ".jcncontainer.jcntopoverlay{display:none !important}",
  },
  "freemeteo.gr": { c: 0 },
  "petsie.nl": { j: "5" },
  "hmc.org.uk": { s: "#modal-mask{display:none !important}" },
  "rajsvitidel.cz": { s: ".cc_wrapper{display:none !important}" },
  "spotlight.pl": { s: ".statement-container{display:none !important}" },
  "inver.com": { c: 11 },
  "hkik.hu": { c: 25 },
  "reading.gov.uk": { c: 25 },
  "alpenski.pl": { c: 10 },
  "lesara.nl": { s: ".notification__container{display:none !important}" },
  "spartacus-educational.com": { s: "#new-domain{display:none !important}" },
  "etstur.com": { s: ".protectionOfData{display:none !important}" },
  "libertas.pl": { c: 12 },
  "relaischateaux.com": { j: "5" },
  "wetterheute.at": { s: ".cookie-insert{display:none !important}" },
  "parasol.com.pl": {
    s: "#black_background,#black_background_panel{display:none !important}",
  },
  "codeplay.com": { s: "#notificationPopup{display:none !important}" },
  "freemeteo.rs": { c: 0 },
  "fhpelikan.com.pl": {
    s: "#simple-modal,#simple-modal-overlay{display:none !important}",
  },
  "minstercleaning.co.uk": { s: "#ecld_bar{display:none !important}" },
  "fc.de": { s: ".mod-alert{display:none !important}" },
  "safc.com": { s: ".global-notice-wrap{display:none !important}" },
  "akh.hu": { s: "#macookie{display:none !important}" },
  "flottagumiszerviz.hu": { s: "#macookie{display:none !important}" },
  "peters.de": { s: ".loading_cookie_mainkuangjia{display:none !important}" },
  "colchones.es": { s: "#avisosusc{display:none !important}" },
  "upvx.es": { s: "#lean_overlay,#change_cookies{display:none !important}" },
  "chambre-vienne.notaires.fr": { s: "#cnil-notice{display:none !important}" },
  "bechbruun.com": { s: ".header-notice{display:none !important}" },
  "trekking-koenig.de": { s: ".cookie5{display:none !important}" },
  "pierotofy.it": { c: 1 },
  "fishersci.es": { s: "#legalMessageWrapper{display:none !important}" },
  "efinancialcareers.de": { s: "#pageMessages{display:none !important}" },
  "dokumentyzastrzezone.pl": { s: "#gkTopBar{display:none !important}" },
  "ftopadova.it": { c: 19 },
  "symmotos.ch": { c: 63 },
  "stayinwales.co.uk": { s: ".ckinfo-panel{display:none !important}" },
  "generatorkodowkreskowych.pl": { s: "#cn{display:none !important}" },
  "coopalleanza3-0.it": { s: ".cookieDisplay{display:none !important}" },
  "wsim.de": { s: "#dataPrivacyPolicy{display:none !important}" },
  "lycos.es": { c: 96 },
  "elektroaktivisten.de": { s: ".main-alert{display:none !important}" },
  "seriale.co": { s: "#komunikat{display:none !important}" },
  "tournamentsoftware.com": { j: "5" },
  "tuvlita.lt": { s: ".section.accept{display:none !important}" },
  "battle-of-glory.com": {
    s: ".ui-pnotify.background-transparent{display:none !important}",
  },
  "onninen.com": { s: "#OnninenCookieInfo{display:none !important}" },
  "koolhydratentabel.nl": {
    s: "#loading,#loading + .noblur{display:none !important}",
  },
  "gloucestershire.gov.uk": { c: 27 },
  "wallangues.be": { s: "#wallangues-eu-cookie{display:none !important}" },
  "pcbox.com": { c: 0 },
  "vintage-radio.net": { c: 11 },
  "traconelectric.com": { s: ".cookie-row{display:none !important}" },
  "operasanfrancesco.it": { s: "#avviso{display:none !important}" },
  "cosiepsuje.com": { s: ".ciacha{display:none !important}" },
  "alberidinataleartificiale.it": { c: 117 },
  "foliesbergere.com": { c: 27 },
  "m.peruzzosrl.com": { c: 1 },
  "cookies-accept-nl.weeronline.cloud": { j: "5" },
  "infodefensa.com": { c: 0 },
  "atleticodemadrid.com": { c: 0 },
  "almapress.com.pl": { c: 37 },
  "hoxa.hu": { s: "#container > div[style]{display:none !important}" },
  "roly.eu": { s: ".jq-toast-wrap{display:none !important}" },
  "aquaquiz.com": { c: 89 },
  "passmyparcel.com": { c: 21 },
  "receptnajidlo.cz": { s: "#cxcx{display:none !important}" },
  "gruppoeuromobil.com": { c: 12 },
  "brain-magazine.fr": { c: 0 },
  "meteoconsult.fr": { s: "#top_head{display:none !important}" },
  "mesmateriaux.com": { s: "#CookiesValid{display:none !important}" },
  "coolermaster.com": {
    s: "#coolermaster-cookie-policy{display:none !important}",
  },
  "guenstiger.de": { s: "#ck-pop{display:none !important}" },
  "gunnars.fr": { s: ".cp-slidein-popup-container{display:none !important}" },
  "exweb.exchange.uk.com": { s: "#ibox{display:none !important}" },
  "lacsiboltja.hu": { s: "#uzeno{display:none !important}" },
  "sermicro.com": { s: "#galletas{display:none !important}" },
  "mercedes-amg.com": {
    s: "#emb-cp-overlay,#emb-cp-dialog{display:none !important}",
  },
  "scooter-system.fr": { s: ".avertissement{display:none !important}" },
  "polskifrontend.pl": { j: "5" },
  "nbazar.sk": { s: ".eu{display:none !important}" },
  "ordineveterinariroma.it": { s: "#privacywarn{display:none !important}" },
  "wecanjob.it": { s: "#trace-form{display:none !important}" },
  "carnovo.com": { s: ".fixed-alert{display:none !important}" },
  "10clouds.com": { s: ".tenc-header__cookies{display:none !important}" },
  "desokupa.com": { c: 19 },
  "bib-cclachatrestesevere.net": { c: 67 },
  "kepmegoszto.com": { c: 93 },
  "guglwald.at": { s: "#tx_tracking{display:none !important}" },
  "symfrance.com": { c: 63 },
  "rymer.org": { s: "#divzasobu{display:none !important}" },
  "conjuga-me.net": { c: 17 },
  "fahrschulcard.de": { c: 99 },
  "nuget.org": { c: 21 },
  "comarsport.com": { s: "#cooking{display:none !important}" },
  "twinset.com": { s: "#ckInfo{display:none !important}" },
  "isa-sociology.org": { s: "#politica{display:none !important}" },
  "skystore.com": { s: ".top-notification-container{display:none !important}" },
  "eralsolution.com": { s: "#stato{display:none !important}" },
  "enel.ro": { s: ".message-notification{display:none !important}" },
  "offerraadgivning.dk": { s: "#ck_row{display:none !important}" },
  "uroda.com": { s: "#blockPopupInformation{display:none !important}" },
  "demaralimentari.it": { s: "#privacy-advise{display:none !important}" },
  "tmt-magazine.com": { s: ".sitealert{display:none !important}" },
  "pianho97.hu": { s: "#alertify,#alertify-cover{display:none !important}" },
  "ssangyong.es": { s: "#eltexto{display:none !important}" },
  "eshop.silicmedia.cz": { s: ".box.notify{display:none !important}" },
  "sonypicturesreleasing.es": { s: "#track-layer{display:none !important}" },
  "hays.nl": { s: "#header-msg{display:none !important}" },
  "pozyx.io": { c: 7 },
  "governmentcomputing.com": { s: ".privacy_notice{display:none !important}" },
  "consumind.nl": { s: "#csm-optin-bar{display:none !important}" },
  "maccosmetics.be": { c: 87 },
  "kunstveiling.nl": {
    s: "#kunstveiling-accept-form{display:none !important}",
  },
  "gelighting.com": { s: "#privacy-message{display:none !important}" },
  "tiendagonzalezbyass.com": { s: "#stickyFooter{display:none !important}" },
  "24kitchen.nl": { j: "5" },
  "ligne-adsl.fr": { c: 1 },
  "parafarma.be": { c: 13 },
  "toutabo.com": { s: ".cookie-text{display:none !important}" },
  "henkel-reiniger.de": { j: "5" },
  "fieraforli.it": { s: ".ns-box.ns-bar{display:none !important}" },
  "myparliament.info": { s: "#data-disclaimer{display:none !important}" },
  "06gids.nl": { s: ".ilikecookies{display:none !important}" },
  "adernats.cat": { c: 0 },
  "airlinecheckins.com": {
    s: ".app-header + .layout-row{display:none !important}",
  },
  "czytio.pl": { c: 0 },
  "masodomov.sk": { c: 10 },
  "microgiochi.com": { s: "#popupmsg_wrapper{display:none !important}" },
  "sorelfootwear.fr": { s: "#notify-bar{display:none !important}" },
  "weltdergoetter.de": { c: 11 },
  "dugout.com": { s: ".simplemodal-bg.snap-bottom{display:none !important}" },
  "acf-amphibians.com": { c: 19 },
  "ifp.si": { s: "body > table{display:none !important}" },
  "mediatheque.ville-montrouge.fr": { c: 67 },
  "cipriani-phe.com": { s: "#myAlert{display:none !important}" },
  "fibs.it": { s: "#privacy-wrapper{display:none !important}" },
  "witaminy-mineraly.choroby.biz": { s: "#wcp{display:none !important}" },
  "kreoart.com.pl": { s: "#popupContact{display:none !important}" },
  "uva.es": { c: 0 },
  "transformacni-technologie.cz": { s: ".upozorneni{display:none !important}" },
  "acega.es": { s: ".aviso{display:none !important}" },
  "informatica7.com": { s: "#sumome-smartbar-popup{display:none !important}" },
  "gerritveldman.nl": { j: "5" },
  "mspy.fr": { s: "#infoToolbar{display:none !important}" },
  "szabadkeresztyen.hu": { c: 1 },
  "spike.com": { c: 94 },
  "bbcsolution.it": { c: 19 },
  "hampshire.spydus.co.uk": { j: "5" },
  "piab.com": { s: ".topBanner{display:none !important}" },
  "hora.com.es": { s: "#ley{display:none !important}" },
  "regione.abruzzo.it": { c: 132 },
  "tchncs.de": { c: 7 },
  "wizdeo.com": { s: "#cookieGA{display:none !important}" },
  "faperme.it": { c: 10 },
  "if.lt": { s: ".btx-expandable{display:none !important}" },
  "shipton-mill.com": { c: 0 },
  "bongu.de": { s: "#infoBar{display:none !important}" },
  "dulcogas.it": { j: "5" },
  "ingsprinters.nl": {
    s: '.modal[data-module="cookie-settings"]{display:none !important}',
  },
  "lira.nl": { s: ".highslide-container{display:none !important}" },
  "video-virali.it": { s: 'div[id*="cookie_pres"]{display:none !important}' },
  "ornikar.com": { s: "#message--cnil{display:none !important}" },
  "securetrading.com": { c: 1 },
  "stenatechnoworld.com": { s: ".stickyfooter{display:none !important}" },
  "yonos.pt": { c: 12 },
  "elaee.com": { s: "#bcnil{display:none !important}" },
  "lanebypost.com": { c: 43 },
  "bubblegumstuff.com": { c: 19 },
  "scez.nl": { s: "#overlay2{display:none !important}" },
  "records.team": { c: 43 },
  "egscans.com": { s: "#egs-cookie-popup{display:none !important}" },
  "mediathequeouestprovence.fr": { c: 67 },
  "amphion.nl": { j: "5" },
  "autoreflex.com": { s: "#legal{display:none !important}" },
  "forbit.it": { s: '.page > div[id*="cookie"]{display:none !important}' },
  "dpo-consulting.fr": { c: 64 },
  "24zdrave.bg": { c: 0 },
  "wandermap.net": { s: ".messages.temporary{display:none !important}" },
  "archiviodistatotorino.beniculturali.it": { c: 132 },
  "mpm.pl": { s: "#__cookies_{display:none !important}" },
  "spiceworks.com": {
    s: ".sui-site-message-container{display:none !important}",
  },
  "heavengroup.it": { s: "#cookup{display:none !important}" },
  "molgroupitaly.it": { s: "#mgit_notification{display:none !important}" },
  "portalkucharski.pl": { c: 1 },
  "esdemarca.com": { s: "#cookie_informativa_esd{display:none !important}" },
  "bati-orient-import.com": {
    s: "#overlayCookie2015{display:none !important}",
  },
  "discoverychannel.it": { c: 1 },
  "maccosmetics.de": { c: 87 },
  "casando.it": {
    s: 'div[id*="ctrlCookies_divCookie"]{display:none !important}',
  },
  "intu.at": { c: 45 },
  "keil.com": { s: "#privacymodule{display:none !important}" },
  "xxxmilfpics.com": { c: 1 },
  "buquebus.com": { s: ".cart_cookie{display:none !important}" },
  "plutobooks.com": { s: ".pp-cookie{display:none !important}" },
  "swiat-sypialni.pl": { s: "#box_alert{display:none !important}" },
  "paramedyk24.pl": { c: 68 },
  "veritas-shop.com": { c: 45 },
  "forsvarsmakten.se": { s: ".s-cookies{display:none !important}" },
  "wallpapermania.eu": { s: ".uk-alert{display:none !important}" },
  "vornamen-weltweit.de": { c: 1 },
  "i4a.pl": { s: "#hideMe{display:none !important}" },
  "steinadler.com": { s: "#countrySelectOverlay{display:none !important}" },
  "ticnologia.pt": { s: "#rt-drawer{display:none !important}" },
  "giulianomazzuoli.it": { s: "#cookievjw{display:none !important}" },
  "marko.pl": { s: "#cookie_nav{display:none !important}" },
  "lamuscle.com": { s: "#info_banner{display:none !important}" },
  "postnauka.ru": { s: "notifications{display:none !important}" },
  "hivehome.com": { s: ".header-stacked-message{display:none !important}" },
  "evs.com": { s: ".language-switcher{display:none !important}" },
  "presscut.hr": { s: "#kolacici{display:none !important}" },
  "ceske-sjezdovky.cz": { c: 45 },
  "milanoajto.hu": { s: ".cdisclaimer{display:none !important}" },
  "calculatrice.lu": { s: "#cookies-content{display:none !important}" },
  "enelgreenpower.com": { s: ".message-notification{display:none !important}" },
  "gw2treasures.com": { c: 9 },
  "delkom.pl": { c: 0 },
  "wirklichweiterkommen.de": {
    s: ".lsa-dialog.lsa-js-active{display:none !important}",
  },
  "cross.bg": { c: 12 },
  "ordineavvocati.bari.it": { c: 0 },
  "cyberdoktor.de": { c: 31 },
  "versace.com": { s: ".first-visit-banner{display:none !important}" },
  "entreprenor.se": { c: 120 },
  "scseleccion.com": { s: ".vgcookies{display:none !important}" },
  "pierosangiorgio.kyani.com": { c: 1 },
  "lucidsamples.com": { s: "#blocksplash{display:none !important}" },
  "atrio.it": { c: 1 },
  "tactical-equipements.fr": { s: ".warning{display:none !important}" },
  "bigbang.si": { c: 0 },
  "edcom.fr": { c: 0 },
  "dzamlinggar.net": { s: "#cookieID{display:none !important}" },
  "tubacex.com": { s: ".containerBlack{display:none !important}" },
  "cirquedusoleil.com": {
    s: 'div[data-cookie="cookieWarning"]{display:none !important}',
  },
  "flatcast.net": { s: ".h_dataprot{display:none !important}" },
  "abbottsaab.com": { s: "#cc-container{display:none !important}" },
  "alterego.waw.pl": { c: 57 },
  "frichti.co": { s: ".notification--CNIL{display:none !important}" },
  "gwpharm.com": {
    s: ".main > .block.block-block.show{display:none !important}",
  },
  "ttv.pl": { s: "#msgLayer{display:none !important}" },
  "androidcentral.com": { s: ".usr-msg{display:none !important}" },
  "oysteryachts.com": { c: 121 },
  "vrin.fr": { s: "#Disclaimer{display:none !important}" },
  "locservice.fr": {
    s: "#CookiesInfos,#CookiesInfosPrefix{display:none !important}",
  },
  "mymagazine.co.uk": { s: 'span[id$="cookiePanel"]{display:none !important}' },
  "konsbud-hifi.com.pl": { c: 76 },
  "halens.ee": { s: "#site-message-container{display:none !important}" },
  "thefamilycurator.com": { s: ".cn_box{display:none !important}" },
  "azorek.pl": { s: ".giodoContainer{display:none !important}" },
  "artboxone.de": { s: "#ab1_cookie_bar{display:none !important}" },
  "brunel.ac.uk": { s: "#brunelcookies{display:none !important}" },
  "therugbychannel.it": { c: 57 },
  "dewijkgaard.nl": { s: "#popup_melding{display:none !important}" },
  "jpopasia.com": { c: 1 },
  "telewizjapolska24.pl": { c: 44 },
  "stylecaster.com": { s: "#dfp-interstitial-holder{display:none !important}" },
  "geo-fs.com": { s: ".geofs-cooked{display:none !important}" },
  "air-indemnite.com": {
    s: "#general-conditions-of-use{display:none !important}",
  },
  "mynet.com": { s: "#privacy-notification{display:none !important}" },
  "hashflare.io": {
    s: ".alert-dismissible:not(.alert-success){display:none !important}",
  },
  "microhowto.info": { c: 0 },
  "formulacionquimica.com": { s: "#pck{display:none !important}" },
  "wind.it": {
    s: "#cookies,body > #track,.contentCntr + .messageOverlay{display:none !important}",
  },
  "portugalglobal.pt": { s: "#barramensagem{display:none !important}" },
  "openbookpublishers.com": { s: ".menu-header{display:none !important}" },
  "dmty.pl": { c: 1 },
  "heal-link.gr": { c: 10 },
  "fieldgulls.com": { c: 56 },
  "ku.dk": { c: 26 },
  "pfarrverband-koenigslutter.de": { c: 133 },
  "webnovel.com": { s: ".m-streamer{display:none !important}" },
  "reittiopas.fi": { s: "#messageBar{display:none !important}" },
  "zenith.gr": { c: 0 },
  "kimovil.com": { s: "#code_cookies{display:none !important}" },
  "rmastri.it": { s: "#cokadv{display:none !important}" },
  "vitrasa.es": { c: 0 },
  "oddo-bhf.com": {
    s: '.durandal-wrapper[data-view*="CookiesSettings"]{display:none !important}',
  },
  "oet-redwell.it": { s: ".magnus-cookie{display:none !important}" },
  "elsignificadode.net": { s: "#bn-cookies{display:none !important}" },
  "louder.com": { s: ".hint{display:none !important}" },
  "coherent.com": { c: 1 },
  "survio.com": { c: 0 },
  "m.omroepwest.nl": { s: ".c-cbp-container{display:none !important}" },
  "aktionspreis.de": { s: ".leiste_vollstaendig{display:none !important}" },
  "moment-liege.be": { c: 134 },
  "mega-mania.com.pt": { s: ".pl-cookies{display:none !important}" },
  "go4pro.lt": { s: ".wu_holder-wrapper{display:none !important}" },
  "lifescience.net": { c: 10 },
  "cortesdecima.com": { s: ".row.notice.s_active{display:none !important}" },
  "forum-windows.net": { s: "#ntf{display:none !important}" },
  "viennaautoshow.at": {
    s: "body .cookie-message-box.cookie-message-box--open ~ .container header,body .cookie-message-box.cookie-message-box--open ~ .container{margin-top:0 !important}",
  },
  "vitek.cz": { s: "#cookiesI{display:none !important}" },
  "crizal.pl": { s: "#__cookies_{display:none !important}" },
  "draeger.com": {
    s: "dw-global-notification{display:none !important}",
    j: "5",
  },
  "basilica.ro": { c: 10 },
  "tpd.sk": { s: ".header__notice{display:none !important}" },
  "ogrtorino.it": {
    s: "#__next > div[data-reactroot] > div[data-reactid] > div[class]{display:none !important}",
  },
  "giftsandcare.com": { s: "#divbottom{display:none !important}" },
  "kempa-satellite.com": { s: "#mc_top_bar{display:none !important}" },
  "turbocso.hu": { s: "#auroraOverlay{display:none !important}" },
  "thinkwithgoogle.com": { s: ".global-toast{display:none !important}" },
  "konicci.cz": { c: 129 },
  "games.fm": { s: "#cxcx{display:none !important}" },
  "malihu.gr": { s: "#malihu-cookies{display:none !important}" },
  "askabox.fr": { s: "#id_div_bandeau{display:none !important}" },
  "gpstraining.co.uk": { c: 0 },
  "internationalchips.com": { s: ".ba{display:none !important}" },
  "klar-im-vorteil.de": {
    s: "#footer > .inner > p:first-child{display:none !important}",
  },
  "clickatell.com": { s: ".cookie-show{display:none !important}" },
  "bookbeat.com": { s: ".banner.purple{display:none !important}" },
  "xapes.net": { s: "#as-uc-wrapper{display:none !important}" },
  "xm.co.uk": { s: "#cookies-block{display:none !important}" },
  "collibra.com": { s: ".collibra-cookie-accept{display:none !important}" },
  "vivus.es": {
    s: '.background[class*="warning-module"]{display:none !important}',
  },
  "cefarm24.pl": { c: 68 },
  "linkmatepr-soritweb.servizienti.it": {
    s: '.normal[eventproxy="isc_HLayout_1"][style*="absolute"]{display:none !important}',
  },
  "subaru.de": { j: "5" },
  "cookshop.gr": { s: "#cookies-region{display:none !important}" },
  "pfefferminzia.de": { s: "#acceptUserExperience{display:none !important}" },
  "royalmailgroup.com": {
    s: "#block-rmg-cookie-policy-cookie-policy{display:none !important}",
  },
  "slyvent.com": { s: "#cookiesCard{display:none !important}" },
  "lostgames.net": { s: "#entryCookie{display:none !important}" },
  "kookeiland.be": { c: 89 },
  "rooms4valencia.com": { c: 57 },
  "solveigmm.com": { s: "#agreement{display:none !important}" },
  "dicionariodesimbolos.com.br": { c: 55 },
  "occhiox.com": { s: "#consenso{display:none !important}" },
  "boss-nekretnine.hr": { c: 11 },
  "yodiez.com": { s: "#system-message-container{display:none !important}" },
  "e-elektron.pl": { c: 1 },
  "sms.priv.pl": { c: 0 },
  "stjornarradid.is": { s: ".session-text{display:none !important}" },
  "upc.at": { s: ".lgi-bgcontainer-privacybanner{display:none !important}" },
  "hbkik.hu": { s: "#alert-box{display:none !important}" },
  "pixabay.com": { s: ".message_box{display:none !important}" },
  "vr.se": { c: 21 },
  "gaes.es": { c: 0 },
  "10khits.com": {
    s: 'cloudflare-app[app="welcome-bar"]{display:none !important}',
  },
  "cleverdialer.de": { s: "#cdweb-cookie-law-info{display:none !important}" },
  "kropelka.com": { s: "#back-lightbox{display:none !important}" },
  "centauria.it": { s: ".header-welcome{display:none !important}" },
  "energologistic.it": { s: "#dc-cnb-container{display:none !important}" },
  "stiga.it": { s: "#privacyDisclaimer{display:none !important}" },
  "rhomberg-reisen.com": {
    s: ".rho-toast--top.rho-pagelane{display:none !important}",
  },
  "enikom-m.com": { c: 0 },
  "blazaar.com": { s: ".ng-toast--top{display:none !important}" },
  "idgspa.it": { s: "#showimage{display:none !important}" },
  "papapiqueetmamancoud.fr": {
    s: "#id_suivi_publicites{display:none !important}",
  },
  "zinodavidoff.com": { s: "#footer + div{display:none !important}" },
  "mundo-pecuario.com": { s: "#msjadd{display:none !important}" },
  "rentokil.fr": {
    s: "#cookie-policy-header .cookie-popup-header{display:none !important}",
  },
  "mashable.com": {
    s: "#peek > div:not([id]):not([class]){display:none !important}",
  },
  "ovhcloud.com": { s: "#block-ovhcookieconsent{display:none !important}" },
  "lemoiszerozero.fr": { s: "#root > div:not([id]){display:none !important}" },
  "sita.aero": {
    s: "#privacyPopupOverlay,.privacyPopup{display:none !important}",
  },
  "sapabuildingsystem.com": { s: "#header .message{display:none !important}" },
  "mx1-360.com": { s: ".cookie-legal{display:none !important}" },
  "beko.pl": {
    s: "#cookies,#cookie_margin{display:none !important}header.cookies-margin{top:0 !important}",
  },
  "facebookafmelden.nl": { s: "#cookiespanel{display:none !important}" },
  "tablademareas.com": { c: 0 },
  "porschebank.at": { s: ".statisticsOptBox{display:none !important}" },
  "theringer.com": { c: 56 },
  "bancopopular.es": { c: 0 },
  "sharesmagazine.co.uk": { c: 123 },
  "spot-a-shop.de": { s: "#popup-notifications{display:none !important}" },
  "dplay.no": {
    s: '#app > div > dialog[class^="notification"]{display:none !important}',
  },
  "makewarnotlove.com": { s: ".cp-wrap{display:none !important}" },
  "deutscheam.com": { s: ".flash-message__wrapper{display:none !important}" },
  "seibert-media.net": { s: "#privacy_protection{display:none !important}" },
  "lariveracioccolato.com": { c: 53 },
  "doctoranytime.gr": { s: "#notif--privacy{display:none !important}" },
  "risvegliocomune.com": { c: 57 },
  "lerepairedesmotards.com": { c: 0 },
  "dplay.se": {
    s: '#app > div > dialog[class^="notification"]{display:none !important}',
  },
  "dplay.dk": {
    s: '#app > div > dialog[class^="notification"]{display:none !important}',
  },
  "cewe-print.de": { c: 0 },
  "winflector.com": { c: 1 },
  "korisnaknjiga.com": { s: "#kukiji{display:none !important}" },
  "obaku.com": { s: ".alert.callout{display:none !important}" },
  "jal.co.jp": {
    s: "#JS_ciBox,#JS_ciBox_filter,#JS_ciBox_filter_iframe{display:none !important}",
  },
  "haglofs.com": { s: "#privacy-policy-modal{display:none !important}" },
  "dissidiafinalfantasynt.com": {
    s: "#react-mount > .locale-container > div[style]{display:none !important}",
  },
  "diamond-air.at": { c: 135 },
  "itmagination.com": {
    s: 'div[class$="cookie-info"]{display:none !important}',
  },
  "adacreisen.de": { s: ".FooterNotification{display:none !important}" },
  "tradeplace.com": { j: "5" },
  "euronova-italia.it": { s: ".cc-customdialog{display:none !important}" },
  "crunch.co.uk": {
    s: "#reactAppRoot > div > .text-content{display:none !important}",
  },
  "ziffit.com": { s: ".notificationholder{display:none !important}" },
  "cosmo.ru": { s: ".disclame_block{display:none !important}" },
  "educalingo.com": { c: 0 },
  "geekbrains.ru": { s: ".gb-bottom-banners{display:none !important}" },
  "trespasse.com": { c: 0 },
  "uhu.de": { s: ".message.fixed{display:none !important}" },
  "idc.com": { s: ".idc-privacy-notice{display:none !important}" },
  "envivas.de": { s: ".box-hint-layer{display:none !important}" },
  "disidentia.com": { s: "#snppopup-welcome{display:none !important}" },
  "dutchbirding.nl": { c: 0 },
  "beepjob.com": { s: "#cgCookies{display:none !important}" },
  "dahuasecurity.com": { s: ".top_tip_wrap{display:none !important}" },
  "cision.com": { s: "#cision-cookie-policy-banner{display:none !important}" },
  "upctv.at": { c: 78 },
  "investec.com": {
    s: '.alerts-top[data-type*="acceptCookies"]{display:none !important}',
  },
  "speedyhen.com": { c: 1 },
  "lasante.net": { s: ".cookies__container{display:none !important}" },
  "meyer.it": { s: "#zf--alerts-panel{display:none !important}" },
  "portamx.com": { s: "#ecl_outer{display:none !important}" },
  "ifp-school.com": { s: "#cnilWrapper{display:none !important}" },
  "codicesconto.org": { s: ".bloque_lopd{display:none !important}" },
  "nuovatecnodelta.it": { s: "body > div[style]{display:none !important}" },
  "naturenergieplus.de": { s: ".announcement{display:none !important}" },
  "detnyeskotterup.dk": { s: ".clWindow{display:none !important}" },
  "eujuicers.cz": {
    s: "#snippet-browserBootstrap-flashMessages-{display:none !important}",
  },
  "bet.com": {
    s: ".asset_balaNotification,.asset_balaNotificationOverlay{display:none !important}",
  },
  "emp-online.es": { s: ".browser-check{display:none !important}" },
  "hestragloves.com": { s: ".user-message-list{display:none !important}" },
  "remax-centarnekretnina.com": { c: 11 },
  "millennium-nekretnine.hr": { c: 11 },
  "bws.net": { s: ".block--cookie{display:none !important}" },
  "ofgem.gov.uk": { s: "#ofgem-cookies{display:none !important}" },
  "mm-kancelaria.com": { c: 44 },
  "polsonic.com": { s: "body > .widgets-list{display:none !important}" },
  "energy-storage.news": { s: ".site-notices{display:none !important}" },
  "placeandsee.com": { s: "#bnrckie{display:none !important}" },
  "napivicc.hu": { s: "#kki_div{display:none !important}" },
  "docciabox.com": { s: "#site-cookie{display:none !important}" },
  "mulinobianco.it": { s: ".mb_cookie{display:none !important}" },
  "riftherald.com": { c: 56 },
  "team-rauscher.at": { j: "5" },
  "gmanetwork.com": { s: ".ckn-container{display:none !important}" },
  "portalento.es": { s: ".cpMainPanel{display:none !important}" },
  "elektrobit.com": { s: "#ckBar{display:none !important}" },
  "sefaireaider.com": { s: "#cookies-charter{display:none !important}" },
  "thueringenforst.de": { s: ".opt-out{display:none !important}" },
  "ecotrade.bio": { s: ".global-alert{display:none !important}" },
  "allianzworldwidecare.com": { c: 128 },
  "novapdf.com": { s: "#novapdf_accept_cookies{display:none !important}" },
  "reischecker.nl": { c: 66 },
  "bitster.cz": { s: ".cookies-window{display:none !important}" },
  "stasonline.ro": { s: "#form_cookie{display:none !important}" },
  "adslalvolo.it": { s: "#popupDivC{display:none !important}" },
  "hrhibiza.com": { s: "#websiteNotification{display:none !important}" },
  "pleternica.hr": { c: 127 },
  "tovedo.hr": { s: "#COOKIES,#COOKIES ~ div{display:none !important}" },
  "lider.hr": { c: 11 },
  "bora.hr": { s: ".modal-mask{display:none !important}" },
  "autogaleria.hu": { s: "#info-suti{display:none !important}" },
  "aol.de": { s: ".m-user-consent,#alerts-policy{display:none !important}" },
  "karman.cc": { s: "#ico_wrapper{display:none !important}" },
  "smiile.com": { s: "#com-message{display:none !important}" },
  "fc-hansa.de": { c: 1 },
  "uni-greifswald.de": { s: "#piwik-flyin{display:none !important}" },
  "livescore.net": { s: '.row[data-id="infobar"]{display:none !important}' },
  "domwroc24.pl": { s: ".black_overlay{display:none !important}" },
  "kaiserkraft.ie": { s: ".policy_notification{display:none !important}" },
  "aiponet.it": { s: "#cl_wrapp{display:none !important}" },
  "donadeimonti.it": { c: 132 },
  "emagister.com": { s: ".fixed-footer{display:none !important}" },
  "alecoair.ro": { c: 11 },
  "kvn.ru": { s: ".disclame_block{display:none !important}" },
  "standardandpoors.com": {
    s: "#wrapper > .portlet-boundary.portlet-static{display:none !important}",
  },
  "ssls.cz": { s: "#ckb{display:none !important}" },
  "kemkik.hu": { s: "#alert-box{display:none !important}" },
  "huidkanker.nl": { s: "#persistent-messages{display:none !important}" },
  "mhiae.com": { c: 13 },
  "checkthatcar.com": { s: ".csent{display:none !important}" },
  "leselupe.de": { c: 1 },
  "buywithconfidence.gov.uk": { s: "#uptopbar{display:none !important}" },
  "reed.co.uk": { s: ".cookie-legislation{display:none !important}" },
  "monkey-tie.com": { s: "#cookiemt{display:none !important}" },
  "lululemon.com": { s: "#promoted-alert-bar{display:none !important}" },
  "infrarot-fussboden.de": {
    s: 'div[class*="cookie-hint-wrapper"]{display:none !important}',
  },
  "turtlecereals.com": { c: 57 },
  "ambitionspersonnel.com": { c: 1 },
  "partycasino.com": { s: ".info-message{display:none !important}" },
  "nextpharmajob.com": { s: ".userBar{display:none !important}" },
  "seifensieder.at": { c: 57 },
  "wurmberg.de": { s: ".datenschutz{display:none !important}" },
  "fisherinvestments.com": { s: "#privNotice{display:none !important}" },
  "101xp.com": { s: ".ui-notification-wrapper{display:none !important}" },
  "carnevale.venezia.it": { s: "#privacySlider{display:none !important}" },
  "shortpixel.com": { s: "#shortpixel-cookies{display:none !important}" },
  "co-opinsurance.co.uk": { s: "#noticePanel{display:none !important}" },
  "autoampel.de": { c: 0 },
  "lysman.no": { c: 136 },
  "autoweetjes.com": {
    s: "body > div[id]:not([class]){display:none !important}",
  },
  "monedo.mx": { s: ".wr-notification-panel{display:none !important}" },
  "debgen.fr": {
    s: 'cloudflare-app[app="welcome-bar"]{display:none !important}',
  },
  "merseyfire.gov.uk": { s: "#popup_box{display:none !important}" },
  "baumtronics.com": { c: 21 },
  "autohaus-eberstein.de": { c: 126 },
  "01-telecharger.com": { s: "#cokkies{display:none !important}" },
  "impelshop.com": { s: "#privacy_policy{display:none !important}" },
  "capitandenim.com": { s: "#menscookie{display:none !important}" },
  "optochtenkalender.nl": { s: ".PanelPopUp{display:none !important}" },
  "thinkshoes.com": { s: "#data-privacy-bar{display:none !important}" },
  "tevaitalia.it": { s: ".riquadroAvvisoPrivacy{display:none !important}" },
  "sep-ensemble.fr": { s: ".disclaimer-bar{display:none !important}" },
  "kaerntentherme.com": { c: 134 },
  "tuttostoria.net": { s: "#avviso{display:none !important}" },
  "porsche-toledo.com": { s: "#popupbox{display:none !important}" },
  "hbo.pl": { c: 17 },
  "pirkis.lt": { s: "#alert_tuscias,#alertt{display:none !important}" },
  "theoutlinerofgiants.com": { s: "#toog-cookies{display:none !important}" },
  "keefcooks.com": { s: ".cookiecon{display:none !important}" },
  "savio.it": { s: "#box-overlay{display:none !important}" },
  "mobileworldcentre.com": { c: 100 },
  "kupigume.hr": { s: ".ant-notification{display:none !important}" },
  "wiener-metropol.at": { c: 1 },
  "fnvzzp.nl": { s: "#bottom{display:none !important}" },
  "vzdusin.cz": { c: 119 },
  "lacompagnie.com": { s: "#cnil-layer{display:none !important}" },
  "hjheinz.de": { c: 1 },
  "superfi.co.uk": {
    s: ".superfi-cookie-info-wrapper{display:none !important}",
  },
  "osservatoriocalcioitaliano.it": {
    s: "#dc-cnb-container{display:none !important}",
  },
  "lingea.sk": { s: ".lck-wrapper{display:none !important}" },
  "simonly.nl": { c: 0 },
  "ray-ban.com": { s: ".wcs-top-message-container{display:none !important}" },
  "greencity.de": { s: ".cnwrap{display:none !important}" },
  "lafotelektronik.com": {
    s: 'div[id$="cookiesInfo"]{display:none !important}',
  },
  "casadelloscaffale.com": {
    s: "body > div[class][id]{display:none !important}",
  },
  "skygroup.sky": { s: ".corporate-notice-banner{display:none !important}" },
  "placelibertine.com": { s: ".cookieText{display:none !important}" },
  "tim.it": { s: "#privacy_disclaimer{display:none !important}" },
  "plaques-immatriculation.info": { c: 0 },
  "lottosurprise.be": { s: "._cookies-cookie{display:none !important}" },
  "oksofas.es": { s: ".jCookie{display:none !important}" },
  "mescommercantsdugrandhainaut.com": {
    s: "#divacacher{display:none !important}",
  },
  "winteroutlet.ro": { s: "#haveCookie{display:none !important}" },
  "dnelectronic.com": { s: "#ctl00_ley{display:none !important}" },
  "muenchen-heilpraktiker-psychotherapie.de": {
    s: ".jtci-block{display:none !important}",
  },
  "swiggle.org.uk": { s: "#slide-out-div{display:none !important}" },
  "sinonimosonline.com": { c: 55 },
  "eibtron.com": {
    s: ".dijitDialog,.dijitDialogUnderlayWrapper{display:none !important}",
  },
  "ttunited.com": {
    s: 'div[id$="FrameHolder"] > iframe{display:none !important}',
  },
  "accenture.com": { s: ".cookie-nav{display:none !important}" },
  "vlajo.org": { s: "#vlajoCookieLegalContainer{display:none !important}" },
  "renaultkatowice.pl": { s: ".fixedInfo{display:none !important}" },
  "assuronline.com": { s: ".bottom_cookie{display:none !important}" },
  "vespa-forum.at": { s: "#dkmcookie{display:none !important}" },
  "fontfreak.com": { c: 131 },
  "capitalinn.it": { s: "#divPrivacy{display:none !important}" },
  "youinvest.org": { s: "#Lab0cookie_pres{display:none !important}" },
  "ekobiuro24.pl": { c: 13 },
  "coopmaster.it": { s: "#h-navbar{display:none !important}" },
  "labelleadresse.com": { s: "._cd{display:none !important}" },
  "electraplus.si": { s: ".ndp-panel{display:none !important}" },
  "paperflies.com": {
    s: "#content > div[data-reactroot] > div > div[class]{display:none !important}",
  },
  "gramwzielone.pl": { s: "#gwz-cookies{display:none !important}" },
  "netweber.pl": { c: 52 },
  "cideon.de": { j: "5" },
  "bookgig.com": { s: 'div[class^="__alertCookies"]{display:none !important}' },
  "romet.pl": { s: ".top-msg{display:none !important}" },
  "recepty.cz": { c: 1 },
  "shop.ticketpro.cz": { c: 1 },
  "seat.dk": { s: ".notify-bar{display:none !important}" },
  "devex.com": { s: "#alerts-container{display:none !important}" },
  "legalandgeneral.com": { s: "#st_box{display:none !important}" },
  "szegedvaros.hu": { c: 127 },
  "newnownext.com": { c: 94 },
  "emerson.com": {
    s: 'div[class$="global-cookie-notification"]{display:none !important}',
  },
  "ridi-group.com": { s: ".occ-inline{display:none !important}" },
  "santucciservice.it": { c: 1 },
  "fdjesport.fr": { s: ".fdj__footer{display:none !important}" },
  "geemba.net": { s: "#BODY > .window.container{display:none !important}" },
  "gigant.pl": { s: "#cookie_txt{display:none !important}" },
  "softwareag.com": { s: "#blanket,#popUpDiv{display:none !important}" },
  "mariskalrock.com": { s: ".pcookies{display:none !important}" },
  "sapo.cv": { s: ".bsu-v2-ntfs{display:none !important}" },
  "meblemagnat.pl": { c: 1 },
  "libra.com.pl": { s: "#under_footer{display:none !important}" },
  "budapestpark.hu": { s: "#cooker_container{display:none !important}" },
  "lepavelillois.com": { s: "#stickyHeader{display:none !important}" },
  "win3x.org": { c: 1 },
  "greta.shop": { s: "#paragraph_cookie{display:none !important}" },
  "jpgames.de": { s: "#ingameCookie{display:none !important}" },
  "lataamo.akuankka.fi": { c: 31 },
  "akuankka.fi": { s: ".cb-container{display:none !important}" },
  "ligna.de": { c: 92 },
  "francja.goal.pl": {
    s: "#viewCookies,#viewCookiesClose{display:none !important}",
  },
  "rockthetraveller.com": { s: ".pie_cookie{display:none !important}" },
  "znak.pl": { c: 1 },
  "ffsa.org": { s: "#DeltaPageStatusBar{display:none !important}" },
  "redmenta.com": { c: 136 },
  "dambros.it": { s: "#dambros-data{display:none !important}" },
  "betsafe.ee": { s: "#MsgAreaBottom{display:none !important}" },
  "bcn.cat": { s: "#bcn-ccwr{display:none !important}" },
  "yer.nl": { s: ".headerCookie{display:none !important}" },
  "sharpspixley.com": { s: ".otpOut{display:none !important}" },
  "keolis.nl": { c: 10 },
  "sklep.vertus.com.pl": {
    s: "#simple-modal,#simple-modal-overlay{display:none !important}",
  },
  "warrantydirect.co.uk": { c: 4 },
  "ucando.pl": { s: "notifications{display:none !important}" },
  "midparts.com.pl": {
    s: "#simple-modal,#simple-modal-overlay{display:none !important}",
  },
  "velenje.com": { s: "td.style5 > table{display:none !important}" },
  "discountbabyequip.co.uk": { s: ".notify{display:none !important}" },
  "passvigo.vigo.org": { c: 0 },
  "bb-promotion.com": { s: "#sf_fb_retargeting{display:none !important}" },
  "lizipaina.es": { s: "#additional{display:none !important}" },
  "numismatica.land63.com": { c: 1 },
  "abchomeopathy.com": { s: "#cookieQ{display:none !important}" },
  "almhof.nl": { s: ".cm.container{display:none !important}" },
  "schwedisch-translator.de": { c: 54 },
  "nationaalcomputerforum.nl": { c: 11 },
  "record.com.mx": { s: "#zone-user-wrapper{display:none !important}" },
  "420tv.com": { s: "#appBarHeaderContainer{display:none !important}" },
  "glovoapp.com": { s: ".down-banner{display:none !important}" },
  "drupalet.com": { c: 99 },
  "orgasmatrix.com": { c: 0 },
  "starbt.ro": { s: ".ava_2.display{display:none !important}" },
  "joe.pl": { s: "#j_all > div[style]{display:none !important}" },
  "lifeofvinyl.com": { s: "#msgBox{display:none !important}" },
  "gbif.org": { s: "#termsOfUse{display:none !important}" },
  "topskwlfilter.at": { s: "#granola{display:none !important}" },
  "kolbi.pl": { c: 1 },
  "kodi-forum.nl": { c: 11 },
  "clinique.com": { c: 87 },
  "atlantis-travel.eu": { s: "#ook{display:none !important}" },
  "poundshop.com": { s: "#top-promo{display:none !important}" },
  "nordseecamping.de": { c: 57 },
  "animationsource.org": { s: "#cprv{display:none !important}" },
  "catwalker.hu": { s: "#CWCookie{display:none !important}" },
  "jjfoodservice.com": {
    s: 'proto-orderpad > div[style*="fixed"]{display:none !important}',
  },
  "jman.tv": { s: "#ActionBar{display:none !important}" },
  "dragonpass.com.cn": { s: ".indexCookies{display:none !important}" },
  "pressreader.com": { s: "#snackbar-container{display:none !important}" },
  "denovali.com": { s: "#growls2{display:none !important}" },
  "jazzwruinach.pl": { s: "#info-window{display:none !important}" },
  "aktivo.nl": { s: "#epd{display:none !important}" },
  "pila.pl": { c: 1 },
  "mijnleninginzicht.nl": { c: 1 },
  "befsztyk.pl": { c: 68 },
  "herz-lungen-praxis-ebersberg.de": {
    s: 'section[data-module="cookies"]{display:none !important}',
  },
  "pommiers.com": { s: "body > center > div{display:none !important}" },
  "ratebeer.com": { j: "5" },
  "danstonchat.com": { s: ".cls-cookie{display:none !important}" },
  "mrmen.com": { s: "#mrmen-cookies{display:none !important}" },
  "meridionews.it": { s: ".leaderboard{display:none !important}" },
  "raritysoft.com": { s: ".bootstrap-growl{display:none !important}" },
  "inqnable.es": { s: "#kgc-consent{display:none !important}" },
  "intersurgical.de": { s: "#ccPopup{display:none !important}" },
  "fettspielen.de": { s: "#cwarn{display:none !important}" },
  "londynek.net": { s: "#ldnk-cookie{display:none !important}" },
  "mkik.hu": { s: "#alert-box{display:none !important}" },
  "irisopenpayslips.co.uk": { s: "#outerdiv{display:none !important}" },
  "sportpartner-boerse.com": { s: "#DC{display:none !important}" },
  "weber-beamix.nl": { c: 52 },
  "led-flash.fr": { s: "#eocookie{display:none !important}" },
  "radiofreccia.it": {
    s: ".off-canvas-content > div[style]{display:none !important}",
  },
  "rogosport.si": { s: "#biscuits{display:none !important}" },
  "rgbdruk.pl": { s: "#message-bar{display:none !important}" },
  "treningspartner.no": {
    s: ".top > .container > .sd-surface > .sd-object-if{display:none !important}",
  },
  "ufopedia.it": { s: "#PrivacyPolicyBar{display:none !important}" },
  "grafcan.es": { s: "#divConsent{display:none !important}" },
  "digitalagencynetwork.com": { s: "#popupDiv{display:none !important}" },
  "leoexpress.com": { s: ".js-footer + div{display:none !important}" },
  "cuatro.com": { s: 'div[class^="cookiesAlert"]{display:none !important}' },
  "aocz.it": {
    s: "#policy_id{display:none !important}body{padding-top:0 !important}",
  },
  "odbojka.si": { s: "#footer_message{display:none !important}" },
  "luxplus.dk": { s: "#lp-euc{display:none !important}" },
  "aandelencheck.be": { s: "#site-alert-container{display:none !important}" },
  "orthomol.com": { s: ".alert-box{display:none !important}" },
  "kunstnet.de": { c: 4 },
  "thescore.com": {
    s: 'div[class^="PrivacyPolicyPopup"]{display:none !important}',
  },
  "listesdemots.net": { s: "#cd{display:none !important}" },
  "casino.dk": { s: "#MsgAreaBottom{display:none !important}" },
  "laligue.be": { s: ".bottom_message{display:none !important}" },
  "camp-firefox.de": { s: "#storage-notice{display:none !important}" },
  "kamzakrasou.sk": { s: ".cookie-row{display:none !important}" },
  "angolotesti.it": { c: 0 },
  "large.nl": { s: ".notification-box-bottom{display:none !important}" },
  "active-traveller.com": { s: "#mixcookies{display:none !important}" },
  "livep2000.nl": { j: "5" },
  "member.europe.yamaha.com": { c: 10 },
  "graze.com": { s: "#graze-cookie-message{display:none !important}" },
  "friendsoftheearth.uk": {
    s: "#foe_cookienotice_wrapper{display:none !important}",
  },
  "brillen.de": { s: ".main-cookie-title{display:none !important}" },
  "weekday.com": { s: ".m-error-banner{display:none !important}" },
  "dandomain.dk": { s: ".no-cookie-wrapper{display:none !important}" },
  "fondationcartier.com": { s: ".c-policy{display:none !important}" },
  "elster-americanmeter.com": { s: ".topRibbon{display:none !important}" },
  "mutua.es": { c: 0 },
  "auxoriginesdugout.fr": { c: 97 },
  "france-cadenas.fr": { s: "#cookie_legal{display:none !important}" },
  "protys.fr": { c: 0 },
  "epictv.com": { s: ".epic-cookie-banner{display:none !important}" },
  "hankkija.fi": { s: "#divVVL{display:none !important}" },
  "smorgasbord.com": { c: 10 },
  "schultz-kalecher.dk": { s: ".cookieoptions{display:none !important}" },
  "brinta.nl": { c: 1 },
  "mediatheque.chatillon-sur-indre.fr": { c: 67 },
  "pantamera.nu": { s: "#cookie-list{display:none !important}" },
  "mspy.it": { s: "#infoToolbar{display:none !important}" },
  "frei-wild.net": { s: "#privacyAnnouncement{display:none !important}" },
  "madhumanshow.com": { c: 57 },
  "secureworks.co.uk": { j: "5" },
  "pensioenschoonmaak.nl": { s: "#cwet{display:none !important}" },
  "e-mediatheque.sqy.fr": { c: 67 },
  "haier.com": { s: ".swiper-slide-img-txt{display:none !important}" },
  "musikki.com": { s: ".status-cookies{display:none !important}" },
  "wolkyshop.co.uk": { s: "#wolkyshopCookieBar{display:none !important}" },
  "apmg-international.com": { s: ".status-messages{display:none !important}" },
  "nobistex.com": { s: "#sw_cookies{display:none !important}" },
  "leboisfae.com": { c: 57 },
  "grezzo.de": { s: "body > div[style]{display:none !important}" },
  "mailplanet.it": { s: "#discl{display:none !important}" },
  "fabled.com": { c: 10 },
  "vergelijk.be": {
    s: 'div[data-rendering-area="dialogs"] > div > div > div[data-bind*="PopupBehavior"]:not([data-role]){display:none !important}',
  },
  "citybee.cz": { s: ".cookies-rules{display:none !important}" },
  "switchbay.com": { s: ".ant-notification{display:none !important}" },
  "depv.de": {
    s: "#root > div > div:first-child[class]{display:none !important}",
  },
  "szpitalkarowa.pl": { c: 0 },
  "oldrailwaylinegc.co.uk": { c: 95 },
  "michael-mueller-verlag.de": { s: "#coo_note{display:none !important}" },
  "weerg.com": { s: "#blultpdfbanner{display:none !important}" },
  "nowaelektro.pl": { c: 1 },
  "traum-pizza.de": {
    s: "#gc_message_bar_open,#gc_message_bar{display:none !important}",
  },
  "justgoride.co.uk": { c: 9 },
  "newsbelow.de": { s: ".flash{display:none !important}" },
  "baracuta.com": { s: ".firstvisit{display:none !important}" },
  "chinamobilemag.de": { c: 132 },
  "borgerforslag.dk": {
    s: '.site--content > div[id] > section[style*="transform"]{display:none !important}',
  },
  "paginasamarillas.es": {
    s: "#m-notification--bottom{display:none !important}",
  },
  "adtorpedo66.es": { s: "#laputapolitica{display:none !important}" },
  "tcxboots.com": { s: ".main-copy{display:none !important}" },
  "bm.lv": { s: ".cookie-txt{display:none !important}" },
  "tempmailaddress.com": { c: 42 },
  "thegadgetflow.com": { s: ".gfl-widget-gdpr-wrap{display:none !important}" },
  "deutscher-fenstershop.de": { s: ".rule_assept{display:none !important}" },
  "restplatzboerse.at": { s: "#rpb_cookie-banner{display:none !important}" },
  "cer-eau.fr": { c: 0 },
  "stockwatch.pl": { s: ".cppa{display:none !important}" },
  "dalendo.com": { s: ".dr-footer-fixed-bar{display:none !important}" },
  "bally.fr": { s: ".first-visit-banner{display:none !important}" },
  "cv.lt": { s: ".cookies-wr{display:none !important}" },
  "heroesneverdie.com": { c: 56 },
  "essential.com": { s: "#footerNotice{display:none !important}" },
  "muji.eu": { s: "#cokbar{display:none !important}" },
  "ranorex.com": { s: "#rx-cookie-wrapper{display:none !important}" },
  "9bis.net": { s: 'body > div[style*="width"]{display:none !important}' },
  "bpp.com": { s: "#consentDiv{display:none !important}" },
  "szyszunia.com": { s: "body > center{display:none !important}" },
  "mobidrome.com": {
    s: ".mobidrome-websiteStatisticsOptBox{display:none !important}",
  },
  "bussgeldkatalog.org": { s: ".legalAdvice{display:none !important}" },
  "leaderdrive.fr": { s: ".base-cookies{display:none !important}" },
  "abt-sportsline.de": {
    s: ".abt-cookieNotification{display:none !important}",
  },
  "blende-und-zeit.sirutor-und-compur.de": { c: 54 },
  "transportfever.net": { c: 9 },
  "acorianooriental.pt": { s: ".allow-cookies{display:none !important}" },
  "wattsindustries.nl": { s: "#header1_overlay2{display:none !important}" },
  "digi-film.ro": { c: 131 },
  "namemc.com": { c: 100 },
  "manche.fr": { s: ".cmHeaderTop{display:none !important}" },
  "re.public.polimi.it": { c: 101 },
  "azurewebsites.net": { s: "#legal-info{display:none !important}" },
  "passware.com": { s: ".notifino{display:none !important}" },
  "fitnessvoordeelpas.be": { s: ".cb-modal{display:none !important}" },
  "najdise.cz": { c: 31 },
  "akf-shop.de": { s: ".akf__cookie{display:none !important}" },
  "zmotor.it": { s: "#bannerC{display:none !important}" },
  "beeoffice.com": { s: "#info{display:none !important}" },
  "gruppodimensione.com": { c: 125 },
  "lanidor.com": { s: "#divCookiesF{display:none !important}" },
  "sacoorbrothers.com": { s: ".legal-warning{display:none !important}" },
  "bletchleypark.org.uk": {
    s: "main.relative > div > div{display:none !important}",
  },
  "motuk.com": { s: "#csent10{display:none !important}" },
  "tvnotas.com.mx": { s: "#zone-headertwo-wrapper{display:none !important}" },
  "shetland.gov.uk": { s: "body > .container > span{display:none !important}" },
  "toscana-notizie.it": {
    s: "#banner-overlay-top-page{display:none !important}",
  },
  "hspdat.to": { c: 11 },
  "tripping.com": { s: ".navbar__banner{display:none !important}" },
  "rustimation.eu": { s: "body > p{display:none !important}" },
  "minitokyo.net": { c: 1 },
  "na-kd.com": {
    s: "#container > div > div:not([class]){display:none !important}",
  },
  "bekohu.com": { s: ".sayfaIcDiv > .row300{display:none !important}" },
  "whoismocca.com": { s: "#main-bottom-bar{display:none !important}" },
  "ashtangayogaantibes.com": { s: "#stickyHeader{display:none !important}" },
  "my.moneypolo.com": { j: "5" },
  "armorgames.com": { s: "#cc-alert{display:none !important}" },
  "edx.org": { s: ".edx-cookie-banner-wrapper{display:none !important}" },
  "johnlewisbroadband.com": { s: ".cf__main-block{display:none !important}" },
  "1000dokumente.de": { s: "#bscookie{display:none !important}" },
  "match.com": { j: "5" },
  "neu.de": { j: "5" },
  "aalst.be": { s: ".footer-notification{display:none !important}" },
  "kringloopapp.nl": { j: "5" },
  "imhd.sk": { j: "5" },
  "apparata.nl": {
    s: '#ab_main_nav_container + div[class^="app_"] > div[class^="popup_"]{display:none !important}',
  },
  "sz-online.de": { s: "#szoCookieBar{display:none !important}" },
  "tindie.com": { s: "#tindie_cookie_alert{display:none !important}" },
  "lebrassageestunerichesse.fr": {
    s: "#root > div:not([id]){display:none !important}",
  },
  "canadianoutages.com": { s: "#overlay.container{display:none !important}" },
  "sportal.de": { s: "#dgsvoLayer{display:none !important}" },
  "parczoologiquedeparis.fr": {
    s: ".bloc-notifications-bottom{display:none !important}",
  },
  "clubcard.cz": { s: ".ucks{display:none !important}" },
  "mooiland.nl": {
    s: ".clNotice{display:none !important}.clNoticeVisible{margin-top:0 !important}",
  },
  "skat-spielen.de": { s: "#cookieTest{display:none !important}" },
  "dogma-exclusive.com": { c: 11 },
  "incomediary.com": { c: 0 },
  "atgtickets.com": { s: "#atgcookies-container{display:none !important}" },
  "doctorwho.tv": { c: 31 },
  "setafika.hu": { s: "#popup_bottom{display:none !important}" },
  "chilly.domains": { s: "#chilly-cookie-accept{display:none !important}" },
  "narodowy.pl": { c: 0 },
  "forum.valka.cz": { c: 10 },
  "speedtestcustom.com": {
    s: ".stc-wrapper > div[style]{display:none !important}",
  },
  "kissonline.com": { s: "#consent-slide{display:none !important}" },
  "cassaforense.it": { s: "#cassaforense-cookies{display:none !important}" },
  "ueltje.de": { s: ".ueltje-cookie-accept{display:none !important}" },
  "clinique-veterinaire.fr": { c: 10 },
  "polimarky.pl": { c: 42 },
  "hareskovskole.dk": { c: 101 },
  "pabo.nl": { s: ".disclaimer_wrapper{display:none !important}" },
  "weersvoorspelling.nl": { c: 1 },
  "euroclix.nl": { j: "5" },
  "openclassrooms.com": { s: "#showDisclaimer{display:none !important}" },
  "unitymedia.de": { c: 1 },
  "9gag.com": { j: "5" },
  "mendrulandia.es": { j: "5" },
  "machcomedyfest.co.uk": { s: ".wander-cookie{display:none !important}" },
  "cookiewall.finnik.nl": { j: "5" },
  "livesmarter.pl": { s: "#rodo{display:none !important}" },
  "funpot.net": { c: 37 },
  "tetrisfriends.com": { s: ".iziToast-wrapper{display:none !important}" },
  "hm.com": { j: "5" },
  "irisnet.be": { s: "#cookieIndicator{display:none !important}" },
  "alarabiya.net": { c: 4 },
  "netdyredoktor.dk": { s: ".ct-popup{display:none !important}" },
  "forum-de.msi.com": { s: ".privacy_popup{display:none !important}" },
  "tenuser.com": { s: "#rsp{display:none !important}" },
  "fanbike.de": { c: 4 },
  "salzgitter-ag.com": { s: ".sz-meta__cookies-wrap{display:none !important}" },
  "optyczne.pl": { s: ".w3-modal{display:none !important}" },
  "nuevocaceres-sanfrancisco.es": {
    s: ".index_cookies{display:none !important}",
  },
  "sunny-dessous.de": { s: ".cookie_licence{display:none !important}" },
  "rynekzdrowia.pl": { c: 137 },
  "telering.at": { s: ".uc-fab.uc-fab-open{display:none !important}" },
  "dijaspora.online": { s: ".cookie-uslovi{display:none !important}" },
  "motodesguacehnosgonzalez.com": { j: "5" },
  "i-say.com": { j: "5" },
  "purevpn.com": { j: "5" },
  "kaspersky.pt": { s: ".notification-bar.bottom{display:none !important}" },
  "verkkokauppa.com": { s: ".vk-cookie-notification{display:none !important}" },
  "grrif.ch": { s: "#RGPD{display:none !important}" },
  "discordbots.org": { j: "5" },
  "loggly.com": { s: ".promotion{display:none !important}" },
  "rtp.pt": { s: "#rtpprivacycontent{display:none !important}" },
  "slate.com": { j: "5" },
  "netdoctor.co.uk": { s: ".policy-bar{display:none !important}" },
  "wizaserwis.pl": { j: "5" },
  "mtc-it4.be": { j: "5" },
  "digitalcombatsimulator.com": { c: 0 },
  "time.com": { j: "5" },
  "playtv.fr": { j: "5" },
  "dvdfab.cn": { s: ".cookie-opa{display:none !important}" },
  "wtatennis.com": { s: ".wta-cookies-policy{display:none !important}" },
  "vanpartner.com": { j: "5" },
  "esug.dk": { s: "#COOKIE{display:none !important}" },
  "strava.com": { s: "#stravaCookieBanner{display:none !important}" },
  "guce.oath.com": { j: "5" },
  "userstyles.org": { s: ".NotificationLine{display:none !important}" },
  "grammarly.com": {
    s: 'div[class*="gdpr_notification"]{display:none !important}',
  },
  "pathe.nl": { j: "5" },
  "allyouneedfresh.de": { j: "5" },
  "shmoop.com": { j: "5" },
  "techniconnexion.com": { s: "#fb-root ~ div{display:none !important}" },
  "memrise.com": {
    s: "#legal-modals",
    c: 14,
  },
  "webcamera.pl": { s: "#rodo-modal{display:none !important}" },
  "pkl.pl": { s: ".popup-pkl{display:none !important}" },
  "mercateo.com": { s: "#header-popup-info{display:none !important}" },
  "psychomedia.qc.ca": { c: 1 },
  "digi24.ro": { c: 3 },
  "theforestmap.com": { j: "5" },
  "choicefurnituresuperstore.co.uk": { s: ".fixBar{display:none !important}" },
  "magix.info": { s: ".mgxCookieConsent{display:none !important}" },
  "krautreporter.de": {
    s: ".js-flash-messages-container{display:none !important}",
  },
  "orcadian.co.uk": { s: ".cd-container{display:none !important}" },
  "boxer.se": { c: 138 },
  "gadgetsnow.com": { s: ".consent-popup{display:none !important}" },
  "memsql.com": { s: "#memsql-cookie-banner{display:none !important}" },
  "refresher.sk": { s: ".gdpr-panel{display:none !important}" },
  "refresher.cz": { s: ".gdpr-panel{display:none !important}" },
  "opgevenisgeenoptie.nl": { s: ".cbar-wrapper{display:none !important}" },
  "optical-center.fr": { s: "#cookieOk{display:none !important}" },
  "usporedi.hr": {
    s: "#privacyPolicyModal",
    c: 14,
  },
  "skdd.hr": { s: ".newsBottom{display:none !important}" },
  "hrdlog.net": { s: "#DivCookies{display:none !important}" },
  "mercola.com": { s: ".gdpr-container{display:none !important}" },
  "netflixlovers.it": { s: "#cs_container{display:none !important}" },
  "toutcomment.com": { c: 4 },
  "hs-emden-leer.de": { s: "#zwcc,#zwcc-spc{display:none !important}" },
  "iiyama.com": { s: ".infobar-message{display:none !important}" },
  "avaaz.org": {
    s: ".gdpr-block-cookies,.gdpr-block-privacy{display:none !important}",
  },
  "chilloutzone.net": { s: "#cozConsentNugget{display:none !important}" },
  "supercell.com": { s: ".bs-site-alert{display:none !important}" },
  "themaven.net": { s: ".consent-ui{display:none !important}" },
  "coop.se": { s: ".js-personalInformationNotice{display:none !important}" },
  "broadcom.com": { s: ".ribbon-wrapper{display:none !important}" },
  "technischeunie.nl": {
    s: "#footer-slideup-highlight-banner{display:none !important}",
  },
  "cryptokitties.co": { s: ".BottomBanner{display:none !important}" },
  "gnkdinamo.hr": { j: "5" },
  "telia.ee": {
    s: "iframe.login_top,.header__notice{display:none !important}",
  },
  "giphy.com": {
    s: 'div[class*="flash-message__MessageWrapper"]{display:none !important}',
  },
  "trustradius.com": {
    s: ".notification-banner-footer{display:none !important}",
  },
  "logitech.com": { s: ".cForum_Footer{display:none !important}" },
  "jdvhotels.com": { s: "#ccs-notification{display:none !important}" },
  "delock.de": { s: "#cookie_private{display:none !important}" },
  "neoprofs.org": { s: "#page-footer ~ div{display:none !important}" },
  "classic-trader.com": { c: 101 },
  "soompi.com": { s: "#gdpr-root{display:none !important}" },
  "windguru.cz": { j: "5" },
  "thomsonreuters.com": {
    s: ".dismissible-banner,.pl_announcements{display:none !important}",
  },
  "trafikverket.se": {
    s: "#ctl00_Content_EmptyPage_CoockieInformation_CookieContainer{display:none !important}",
  },
  "jobbird.com": { j: "5" },
  "openweathermap.org": { s: "#stick-footer-panel{display:none !important}" },
  "starressa.com": { s: "#modal-home{display:none !important}" },
  "rapidssl.com": { c: 139 },
  "perforce.com": { s: ".EUc{display:none !important}" },
  "detektor.fm": {
    s: ".stb-container.stb-top-right-container{display:none !important}",
  },
  "siropsport.fr": { s: ".analytics{display:none !important}" },
  "easyeda.com": { s: ".priv-tips{display:none !important}" },
  "bw-online-shop.com": {
    s: ".modal-mask-class.show-modal{display:none !important}",
  },
  "freemake.com": { s: "#bottombar{display:none !important}" },
  "planeteanimal.com": { c: 4 },
  "tsb.co.uk": { c: 0 },
  "lyricsfreak.com": { s: ".wrapper ~ div{display:none !important}" },
  "flertkontakt.com": { s: "#overlay-content{display:none !important}" },
  "alarmeringen.nl": { j: "5" },
  "avherald.com": { s: "#avhcookieconsent{display:none !important}" },
  "ticketea.com": { j: "5" },
  "sparbau-dortmund.de": { s: ".sg-scn{display:none !important}" },
  "kongregate.com": { s: ".policy-bar{display:none !important}" },
  "growdiaries.com": { s: ".popup_secure{display:none !important}" },
  "drivereasy.com": { s: ".float-bar{display:none !important}" },
  "emma-matras.nl": { s: ".ucn-block{display:none !important}" },
  "raider.io": {
    s: 'div[class*="cookieFooter-module"]{display:none !important}',
  },
  "emclient.com": { s: "#emcCookieNotification{display:none !important}" },
  "drugs.com": { s: ".ddc-overlay,.ddc-modal{display:none !important}" },
  "vesselfinder.com": { s: ".pprem_active{display:none !important}" },
  "keithurban.net": { c: 140 },
  "onvz.nl": { s: ".popup_overlay{display:none !important}" },
  "newatlas.com": {
    s: 'body > div[style*="transparent"]{display:none !important}',
  },
  "escapefromtarkov.com": { s: "#legalLightBlock{display:none !important}" },
  "myspace.com": { s: "#termsOfService{display:none !important}" },
  "digiromania.ro": { c: 3 },
  "maxict.nl": { s: ".wallpop-overlay{display:none !important}" },
  "flightview.com": { s: "#eea-confirmation-outer{display:none !important}" },
  "square-enix-games.com": {
    s: 'footer > div[class*="notice"]{display:none !important}',
  },
  "arkivmusic.com": { c: 3 },
  "aoib.dk": { j: "5" },
  "opisopvoordeelshop.nl": {
    s: ".cv-notifier-container{display:none !important}",
  },
  "lachainemeteo.com": { c: 0 },
  "deutschland-spielt.de": { s: "#gamigoCookie{display:none !important}" },
  "lenstip.com": { s: ".w3-modal{display:none !important}" },
  "zvv.ch": { s: ".mod_content_infobanner{display:none !important}" },
  "code42.com": { s: ".QSIInfoBar{display:none !important}" },
  "invenglobal.com": { s: "#ige-cookie-policy{display:none !important}" },
  "letgo.hr": { s: "#container > div{display:none !important}" },
  "letgo.cz": { s: "#container > div{display:none !important}" },
  "luftlinie.org": { c: 4 },
  "bandcamp.com": { s: ".tos-update{display:none !important}" },
  "revouninstaller.com": { s: "#consentAccepted{display:none !important}" },
  "transilien.com": { s: "cnil{display:none !important}" },
  "mythemeshop.com": { s: "#mts_gdpr_popup{display:none !important}" },
  "krombacher.de": { s: ".trackingNotice{display:none !important}" },
  "trendsmap.com": { s: "#header_message{display:none !important}" },
  "bueromarkt-ag.de": { s: "#cC{display:none !important}" },
  "brodportal.hr": { s: ".privatnost{display:none !important}" },
  "034portal.hr": { s: "#footer.tekst{display:none !important}" },
  "hajduk.hr": { j: "5" },
  "germaniasport.hr": { s: "#gdpr-wrapper{display:none !important}" },
  "tifon.hr": { s: ".tifon_cookies{display:none !important}" },
  "americangreetings.com": { s: "#privacy_manager{display:none !important}" },
  "teknologisk.dk": { s: ".bottom-warning{display:none !important}" },
  "askmen.com": { s: ".privacy_policy__container{display:none !important}" },
  "cloudways.com": { s: "#cookies-bot{display:none !important}" },
  "dji.de": { s: "#dji-eucookie{display:none !important}" },
  "vinchain.io": { s: ".bottom.stick{display:none !important}" },
  "tappedout.net": { j: "5" },
  "soccerstats.com": { j: "5" },
  "iscte-iul.pt": { s: "#cookies,#cookiesXs{display:none !important}" },
  "streetinsider.com": { s: "#zeroIDModal{display:none !important}" },
  "marathi.tv": { c: 1 },
  "hanos.nl": { j: "5" },
  "orgosolo.nu.it": { s: "#CookieDiv{display:none !important}" },
  "steadyhealth.com": { c: 1 },
  "leclercdrive.fr": {
    s: 'div[class*="BandeauCookies"]{display:none !important}',
  },
  "teletexto.com": { s: "#priv{display:none !important}" },
  "caib.es": { s: ".imc-cookie{display:none !important}" },
  "forumrowerowe.org": { s: ".ckg{display:none !important}" },
  "opswat.com": { s: "#cookie-ntc{display:none !important}" },
  "brooksrunning.com": { j: "5" },
  "planet.com": { s: ".pl-cookies-cta-contain{display:none !important}" },
  "dormando.de": { s: "#up-cookie{display:none !important}" },
  "tomtop.com": { s: ".m_privacy_statement{display:none !important}" },
  "revouninstallerpro.com": { s: "#consentAccepted{display:none !important}" },
  "freeimages.com": { c: 141 },
  "datafox.de": { s: ".popup-banner{display:none !important}" },
  "hindustantimes.com": { j: "5" },
  "lyricsmode.com": { c: 1 },
  "recurly.com": { s: ".recurly-gdpr{display:none !important}" },
  "pokewiki.de": { s: "#gl-topbar-bg,#gl-topbar{display:none !important}" },
  "aa.com": { s: "#aa_optoutmulti-Modal{display:none !important}" },
  "lzinios.lt": { c: 1 },
  "heroku.com": { s: "#heroku-cookie-banner{display:none !important}" },
  "msnbc.com": { s: ".dy_bottom_notification{display:none !important}" },
  "logicsupply.com": { j: "5" },
  "vr-world.com": { s: "#privacy_policy{display:none !important}" },
  "huawei.ru": { s: "#cookie__panel-help{display:none !important}" },
  "rentalens.ch": { s: "#dabar{display:none !important}" },
  "ehl.de": { s: ".popup_bg{display:none !important}" },
  "roosterteeth.com": { s: ".policy-banner{display:none !important}" },
  "find-dvd.co.uk": { c: 4 },
  "visdeal.nl": { s: ".site-message-overlay{display:none !important}" },
  "jori.com": { c: 31 },
  "hpe.com": {
    s: "#hpealertcomp_container,#hpe_privacy_banner_container{display:none !important}",
  },
  "skype.com": {
    s: '.notification.info[role="alert"]{display:none !important}',
  },
  "push4site.com": { s: ".gdpr__container{display:none !important}" },
  "works-hub.com": { s: ".tracking-popup{display:none !important}" },
  "fdb.pl": { c: 4 },
  "liberte.pl": { c: 0 },
  "digisport.ro": { c: 3 },
  "grafana.com": { c: 76 },
  "gezondheidaanhuis.nl": { s: ".hover_bkgr_fricc{display:none !important}" },
  "smartcockpit.com": { c: 1 },
  "infostrada.it": { c: 0 },
  "worthpoint.com": { s: ".bannerContainer{display:none !important}" },
  "utwente.nl": { s: ".utwente-cookiebar{display:none !important}" },
  "fantasyfootballscout.co.uk": { c: 73 },
  "thephone.coop": { s: ".ll_banner{display:none !important}" },
  "digiday.com": {
    s: ".bx-has-close-inside .bx-slab{display:none !important}",
  },
  "osb-alliance.de": { s: "#cookieonpage{display:none !important}" },
  "thewalrus.ca": { c: 97 },
  "france-galop.com": { c: 1 },
  "edoc.site": { s: "#EDOCSITE_cookie_box{display:none !important}" },
  "hollywoodreporter.com": { s: ".tos-change{display:none !important}" },
  "omnium.cat": { s: ".omnium_cookies_popup_wrapper{display:none !important}" },
  "poulpeo.com": { s: ".legal-banner{display:none !important}" },
  "team-neusta.de": {
    s: ".c-slide-up,.c-slide-up ~ div{display:none !important}",
  },
  "maa.nl": { j: "5" },
  "swissgrid.ch": { s: ".swg-overlay-cookie{display:none !important}" },
  "enternity.gr": { s: "#enternity_consent{display:none !important}" },
  "chomikuj.pl": { j: "5" },
  "trustnet.com": { s: "#deployment_banner{display:none !important}" },
  "visir.is": { s: ".bottom-disclaimer{display:none !important}" },
  "ndsas.sk": { s: ".navbar-fixed-top > .container{display:none !important}" },
  "iberley.es": { c: 39 },
  "thesleepdoctor.com": {
    s: 'body > p[style*="fixed"]{display:none !important}',
  },
  "nhl.com": { s: ".btm-nhl-announcement-modal{display:none !important}" },
  "singlereisen.de": { s: ".cp-dialog{display:none !important}" },
  "searchlock.com": { s: "#fixedFooter{display:none !important}" },
  "comviq.se": { c: 10 },
  "araihelmet.eu": { s: ".top-banner{display:none !important}" },
  "redleonardo.es": { s: ".cookies-label{display:none !important}" },
  "immobilien.net": { j: "5" },
  "monsterhunterworld.com": { j: "5" },
  "konyvelozona.hu": { s: ".snackbar-container{display:none !important}" },
  "maxdome.de": { s: "#mx-js-bar{display:none !important}" },
  "containerbestellung24.de": {
    s: "#active-popup,#popup-container{display:none !important}",
  },
  "royalcaribbean.co.uk": {
    s: ".rccl_cookieConsentStickeyFooterInformation{display:none !important}",
  },
  "indiancaller.com": { s: ".pn_notebox{display:none !important}" },
  "danielaburke.com": { s: ".fixed-banner{display:none !important}" },
  "knuddels.de": {
    s: '#root > div[class*="ColumnFluid"] > div[class*="ColumnFluid"] > div[class*="ColumnFluid"] > div[class*="Column__Column"][style*="opacity"]{display:none !important}',
  },
  "ouicar.fr": { s: ".ce_cookies{display:none !important}" },
  "adtraction.com": { s: "#adtrprivacy{display:none !important}" },
  "bombich.com": { s: "body > .text-center{display:none !important}" },
  "epix.com": { s: ".messaging-container{display:none !important}" },
  "volkswagen-classic-parts.de": {
    s: ".dataProtection{display:none !important}",
  },
  "volkswagen-nutzfahrzeuge.de": {
    s: "#trackingPolicy{display:none !important}",
  },
  "gsp.ro": { s: ".center-gdpr{display:none !important}" },
  "acotelnet.com": { s: "#box_resp,#overlay_resp{display:none !important}" },
  "icicibank.co.uk": { s: ".siteCapture{display:none !important}" },
  "autovandaag.nl": { s: ".bo-cb-bar{display:none !important}" },
  "virginmedia.com": { c: 78 },
  "cumberland.co.uk": { s: ".Notice{display:none !important}" },
  "inverto.tv": { s: "body > .section{display:none !important}" },
  "gryna2.pl": { c: 0 },
  "blog200porcento.com": { s: "#consent_200{display:none !important}" },
  "wyld.de": { s: ".optin{display:none !important}" },
  "bl.uk": { c: 0 },
  "dazeddigital.com": { s: "#cookie-view{display:none !important}" },
  "zacks.com": { s: ".disclosure-fixed-slab{display:none !important}" },
  "imvu.com": { j: "5" },
  "weber.ee": { c: 52 },
  "figyelo.hu": { c: 4 },
  "bancobpi.pt": {
    s: 'div[id^="webcarePopup"] > div[id^="bbo_"]{display:none !important}',
  },
  "vip-usedom.de": { s: "#confirmation{display:none !important}" },
  "csmarket.pt": { s: 'body > div[style*="black"]{display:none !important}' },
  "isaca.org": { s: "#isaca-consent-wrapper{display:none !important}" },
  "nrj-games.fr": { c: 0 },
  "best-bottrop.de": {
    s: '.mm-slideout > div[style*="fixed"]{display:none !important}',
  },
  "musicglue.com": { s: ".CookieFooter{display:none !important}" },
  "fool.de": { s: "#dogfish,#consent-modal{display:none !important}" },
  "fool.co.uk": { s: "#dogfish,#consent-modal{display:none !important}" },
  "maison-laborie.fr": { s: "ion-toast{display:none !important}" },
  "samebug.io": { c: 142 },
  "zoo.wroclaw.pl": { s: "#okno_18only{display:none !important}" },
  "picnic-supermarkt.nl": { s: "#switch2{display:none !important}" },
  "faidateshop.eu": { c: 1 },
  "krankenkassen-direkt.de": { s: "#cbanner{display:none !important}" },
  "delock.com": { s: "#cookie_private{display:none !important}" },
  "digitalocean.com": { s: "#DO_CC_PANEL{display:none !important}" },
  "weatherbug.com": { s: "notification-footer{display:none !important}" },
  "rewolucjawoc.pl": { s: ".footer + .copy{display:none !important}" },
  "postermywall.com": { s: "#user-consent-form{display:none !important}" },
  "pogodynka.pl": { s: "#accept{display:none !important}" },
  "livvin.com": { j: "5" },
  "firstdraftnews.org": { s: ".welcome-message{display:none !important}" },
  "similarweb.com": { s: ".sw-notification{display:none !important}" },
  "q-park.de": { s: ".service-messages{display:none !important}" },
  "crazyhairs.de": { c: 0 },
  "distance.to": { c: 4 },
  "peugeottalk.de": { s: "#ptalkcookie{display:none !important}" },
  "balls.ie": {
    s: 'body > div[style*="transparent"]{display:none !important}',
  },
  "scalemates.com": { s: "#prv{display:none !important}" },
  "werksite.nl": { j: "5" },
  "blackfire.io": { s: "#about-trackers{display:none !important}" },
  "bygghemma.se": {
    s: '#header ~ div[class]:not([id]):not([class*="_"]){display:none !important}',
  },
  "toolband.com": { c: 140 },
  "endless-space.com": {
    s: 'div[id^="cookies-policy"]{display:none !important}',
  },
  "findicons.com": { c: 141 },
  "engelbert-strauss.at": { c: 1 },
  "metalshop.cz": { s: "#nextcreBotDialog{display:none !important}" },
  "teoria.com": { s: ".alert-danger{display:none !important}" },
  "zamunda-net.com": { s: ".ipc-window-overlay{display:none !important}" },
  "davinotti.com": { s: ".privacy-nav{display:none !important}" },
  "webinarjam.com": { s: ".bs-example{display:none !important}" },
  "diil.ee": { s: ".header__notice{display:none !important}" },
  "blv.no": { s: 'body > div[class*="prompt"]{display:none !important}' },
  "allbinos.com": { j: "5" },
  "peoplenet.dk": {
    s: '.pum[data-popmake*="cookies"]{display:none !important}',
  },
  "max.se": { j: "5" },
  "honda.com.br": { s: ".info-notification{display:none !important}" },
  "fear-the-wolves.com": { s: "#cookies-interface{display:none !important}" },
  "uk-yankee.com": {
    s: "#announcement,#announcement ~ #overlay{display:none !important}",
  },
  "loliv.com": { s: ".noti_full{display:none !important}" },
  "freetrackplans.com": { s: ".topbarBox{display:none !important}" },
  "newstalk.com": { j: "5" },
  "finnairshop.com": { s: ".js-consent-popup{display:none !important}" },
  "mazeikiai.lt": { c: 75 },
  "filehorst.de": { c: 0 },
  "sadem.it": { c: 0 },
  "robertplant.com": { s: "#cookieplugin{display:none !important}" },
  "online.no": { j: "5" },
  "modelrailwaysdirect.co.uk": { c: 95 },
  "mql5.com": { s: ".float-vertical-panel{display:none !important}" },
  "aeiou.pt": { s: "#aeiou-barrier-wrapper{display:none !important}" },
  "thunderhead.com": { s: "#js-thcb-banner{display:none !important}" },
  "alaraby.co.uk": { s: ".privacy_prompt{display:none !important}" },
  "befestigungsfuchs.de": { s: "#disclaimer_bg{display:none !important}" },
  "malopolska.pl": {
    s: 'div[id*="cookieinfoarticle"]{display:none !important}',
  },
  "foodkombi.de": { s: ".warning-app{display:none !important}" },
  "vivus.dk": { s: ".global-notification{display:none !important}" },
  "vergleich.org": { s: ".legal-note{display:none !important}" },
  "uni-goettingen.de": { s: ".legal_footer{display:none !important}" },
  "matchbook.com": {
    s: 'div[class^="Cookies__cookies"]{display:none !important}',
  },
  "epdf.tips": { s: "#EPDFTIPS_cookie_box{display:none !important}" },
  "openpli.org": { j: "5" },
  "myg21.com": { s: "#policymodal{display:none !important}" },
  "upctv.ch": { c: 78 },
  "varden.no": { s: 'body > div[class*="isSimple"]{display:none !important}' },
  "freemeteo.hu": { c: 0 },
  "lucidchart.com": { s: ".lucid-cookie-compliance{display:none !important}" },
  "cursbnr.ro": { s: "#avert_all_page{display:none !important}" },
  "sportingbet.com": { s: ".info-message.summaries{display:none !important}" },
  "mudrunner-spintires.com": {
    s: "#cookies-interface{display:none !important}",
  },
  "ville-ideale.fr": { c: 0 },
  "bostadoliv.se": { s: ".uk-notify{display:none !important}" },
  "wsieciprawdy.pl": { s: "#rdModal{display:none !important}" },
  "veritasbooksonline.com": { c: 95 },
  "220.ro": { s: "#popup-versiune-2018{display:none !important}" },
  "cifas.org.uk": { c: 0 },
  "parrucchieri-italia.it": { s: ".policy-modal{display:none !important}" },
  "pamiec.pl": { c: 79 },
  "mazowieckie.pl": { c: 79 },
  "csp.edu.pl": { c: 79 },
  "mzkjastrzebie.com": { c: 79 },
  "vlan.be": { s: "#modalCookie{display:none !important}" },
  "ww-ag.com": { s: ".WW-cookiemodul{display:none !important}" },
  "bicyclette-verte.fr": {
    s: 'div[class*="cookies"]{display:none !important}',
  },
  "tantra-massage-prague.cz": { s: ".window_foot{display:none !important}" },
  "city-sightseeing.com": { s: ".footer-legal-textB{display:none !important}" },
  "domenovecentrum.cz": { c: 129 },
  "damianharriscycles.co.uk": { s: "#info-message{display:none !important}" },
  "investmap.pl": {
    s: ".cookie,.popup-back,.popup-rodo{display:none !important}",
  },
  "musica.com": { s: "#priv{display:none !important}" },
  "monedo.pl": { s: ".NotificationBar{display:none !important}" },
  "dotacedestovka.cz": { s: "fnx-cc{display:none !important}" },
  "uncomo.com": { s: ".consent,.app_gdpr--2{display:none !important}" },
  "loot.io": { s: "#app > main > div:first-child{display:none !important}" },
  "mvhs.de": { s: ".cookie-usgae{display:none !important}" },
  "nextbike.de": { s: ".nb-cookie{display:none !important}" },
  "thehamradio.website": { s: "body > p{display:none !important}" },
  "ciklum.com": { s: ".b-cookies{display:none !important}" },
  "glose.media": { s: "body > span{display:none !important}" },
  "qixxit.com": { s: ".policy-container{display:none !important}" },
  "redbet.com": { c: 9 },
  "wmeentertainment.com": { c: 9 },
  "idea-bank.ro": { c: 9 },
  "delfortgroup.com": { c: 9 },
  "bertil.com": { c: 9 },
  "salvaunbambino.it": { c: 48 },
  "isathens.gr": { c: 48 },
  "imunify360.com": { c: 48 },
  "cassoni-usati.it": { c: 48 },
  "camara.net": { c: 48 },
  "akeebabackup.com": {
    s: "#akeeba-dccc-banner-container{display:none !important}",
  },
  "bose.com": { s: ".bottom_banner{display:none !important}" },
  "luisaviaroma.com": { s: ".privacy-box{display:none !important}" },
  "westword.com": { s: ".compliance{display:none !important}" },
  "rain-alarm.com": { j: "5" },
  "shouldianswer.co.uk": { c: 4 },
  "zurich.de": { s: ".mod-notification-teaser{display:none !important}" },
  "rockhard.de": { s: "#yt-message{display:none !important}" },
  "myth-weavers.com": { s: "#consent_container{display:none !important}" },
  "sportskeeda.com": { s: ".consent-pop-up{display:none !important}" },
  "tzorg.nl": { c: 9 },
  "bluelagoon.com": { j: "5" },
  "bitzarium.com": {
    s: "#textBox,#masque,#BoutClose{display:none !important}",
  },
  "greengenius.lt": { s: ".cookies-sticky{display:none !important}" },
  "frognews.bg": { s: ".hover-mask,.gdpr-blk{display:none !important}" },
  "dekk1.no": { s: ".ModuleGroup.name_infobar{display:none !important}" },
  "mesampoulesgratuites.fr": { c: 13 },
  "rockstarcoders.com": { s: "#myAlert{display:none !important}" },
  "aeriagames.com": { c: 143 },
  "ricaud.com": { s: ".hamon{display:none !important}" },
  "ereading.cz": { c: 3 },
  "atwonline.com": { c: 3 },
  "oxygen.com": { c: 3 },
  "palmknihy.cz": { c: 3 },
  "tipp24.com": { c: 3 },
  "elevensports.it": { j: "5" },
  "anothermag.com": { s: "#cookie-view{display:none !important}" },
  "skoda-kariera.cz": {
    s: ".page__wrap ~ div[class]:not([id]){display:none !important}",
  },
  "pjmedia.com": { s: "#policy-warning-container{display:none !important}" },
  "sax.co.uk": { s: ".notify{display:none !important}" },
  "autokostencheck.de": { c: 89 },
  "ferrariparts.co.uk": { s: "#system_message{display:none !important}" },
  "bitcatcha.com": { s: ".site-notification{display:none !important}" },
  "ps.com.pl": { s: "#ckInfo{display:none !important}" },
  "voat.co": { s: ".eppnotice{display:none !important}" },
  "dina.se": { s: ".dina-cookiebanner{display:none !important}" },
  "capterra.com": { s: ".welcome-banner{display:none !important}" },
  "findaphd.com": { j: "5" },
  "cliquojeux.com": { s: "#cook_aff{display:none !important}" },
  "enmark2.com": { c: 0 },
  "audio-parts.de": { s: ".popup_notification{display:none !important}" },
  "jewish-places.de": {
    s: 'div[class*="CookiesFooter__Banner"]{display:none !important}',
  },
  "predathor.pl": { s: ".spu-bg,.spu-box{display:none !important}" },
  "akamai.com": { j: "5" },
  "rocketleague.com": { s: "#privmessage,#message{display:none !important}" },
  "brennstoffboerse.de": {
    s: ".cs-info-wrapper,.cs-info-wrapper-spacer{display:none !important}",
  },
  "strandhotel.se": {
    s: "#mb_modules_popups_Container{display:none !important}",
  },
  "bcb-online.nl": { s: ".jqibox{display:none !important}" },
  "twojesoczewki.com": { s: ".popup_bg{display:none !important}" },
  "factmag.com": { s: "#vf-pop{display:none !important}" },
  "warrobots.net": {
    s: "#app-root > div > footer ~ div{margin-top:0 !important}",
  },
  "mtmad.es": { j: "5" },
  "e-tron.audi": { s: ".e-tron-cookies-notice{display:none !important}" },
  "quake.com": { c: 9 },
  "thefamouspeople.com": {
    s: ".ppreloaded_lightbox,.preloaded_m_lightbox{display:none !important}",
  },
  "jamesgalway.com": { c: 43 },
  "ford-maiwald.de": { s: "#popupDiv,#overlayDiv{display:none !important}" },
  "momsport.hu": { s: "#slider{display:none !important}" },
  "solwininfotech.com": { s: ".sol-cookie-cover{display:none !important}" },
  "photocamera.bg": { c: 0 },
  "nationalpost.com": { c: 12 },
  "art.pl": { s: "#mnp_cookie_confirmation{display:none !important}" },
  "ville-rail-transports.com": { s: "#cookies_b{display:none !important}" },
  "electrokit.com": { s: "#top-bar{display:none !important}" },
  "hmb-gorzow.pl": { s: "aside.widget{display:none !important}" },
  "werum.com": { s: ".c-callout{display:none !important}" },
  "shadycharacters.co.uk": { s: "#banner-sidebar{display:none !important}" },
  "todopvr.com": { j: "5" },
  "pxhere.com": { s: ".policy-info{display:none !important}" },
  "air-austral.com": { s: "#legalconcerns{display:none !important}" },
  "freemeteo.nl": { c: 0 },
  "yola.com": { c: 9 },
  "rideapart.com": { c: 102 },
  "artwizz.com": { s: ".aw2-nav-top-cookie{display:none !important}" },
  "pro-tools-expert.com": { c: 43 },
  "skrattsajten.com": { s: ".cookieScript{display:none !important}" },
  "europe-pharm.com": { s: ".ep_cookies{display:none !important}" },
  "kolding.dk": { c: 101 },
  "finance-angels.de": {
    s: "body > div > div > [jsmodel]{display:none !important}",
  },
  "stedwards.edu": { s: ".region-alert-section{display:none !important}" },
  "tv5.ca": { s: ".top-alertes{display:none !important}" },
  "youronlinechoices.com": {
    s: ".fl-page.dnone,.mainContentInside .info{display:none !important}",
  },
  "tourtel-twist.fr": { c: 0 },
  "utopya.fr": { s: ".banner-header{display:none !important}" },
  "clusterr.io": { j: "5" },
  "nec.com": { s: ".func-cookie{display:none !important}" },
  "amcharts.com": { c: 11 },
  "indusface.com": { s: ".disclaimer_block{display:none !important}" },
  "framtid.se": { s: "#siteflash{display:none !important}" },
  "seazon.fr": { s: "#root > div > .flexRow{display:none !important}" },
  "massivum.de": { s: ".cn_box{display:none !important}" },
  "e-cooline.de": { s: "#privacy-protection{display:none !important}" },
  "paulmccartney.com": {
    s: ".pmc-cookie-consent-block{display:none !important}",
  },
  "schneider-umformen.de": { j: "5" },
  "arubanetworks.com": {
    s: "#aruba_cookie_privacy_popup{display:none !important}",
  },
  "schaeffler.com": { s: "#dataprotection{display:none !important}" },
  "troax.com": { s: ".troax-messages{display:none !important}" },
  "mapal.com": { s: "#ctrlck{display:none !important}" },
  "prestosoft.com": { s: "#consent-footer{display:none !important}" },
  "swishmax.pl": {
    s: '#main-container-home ~ div > div[style*="fixed"]{display:none !important}',
  },
  "halifax.dk": { s: "#page-cookies{display:none !important}" },
  "cityexpress.com": { s: ".ctn-cookies{display:none !important}" },
  "crans-montana.ch": {
    s: '.mm-page > div[style*="fixed"]{display:none !important}',
  },
  "diabeter.nl": { j: "5" },
  "bip.um.wroc.pl": { c: 0 },
  "hd.se": { c: 3 },
  "toldot.ru": { s: "#prbl{display:none !important}" },
  "haewa.de": { s: ".occ-lock,.occ-overlay{display:none !important}" },
  "lincolnelectric.com": { s: "#cp_wrapper{display:none !important}" },
  "okian.ro": { s: ".HCCC__container--style{display:none !important}" },
  "wddty.com": { s: "#SiteMessageWrap{display:none !important}" },
  "varian.com": { s: "#varian-gdpr-consent{display:none !important}" },
  "kempenhaeghe.nl": { s: ".overlay2{display:none !important}" },
  "texmania.sk": { s: "#note-holder{display:none !important}" },
  "gooienom.nl": { s: "#notification_area{display:none !important}" },
  "onedayonly.nl": {
    s: "#ods_modal_action,#ods_modal_fade{display:none !important}",
  },
  "logistik-express.com": { j: "5" },
  "thevinylfactory.com": { s: "#vf-pop{display:none !important}" },
  "fusion.tv": { s: ".blockCookies{display:none !important}" },
  "powerreviews.com": { s: ".prd-wrap{display:none !important}" },
  "liesegang-projects.com": { s: "#lpcookies{display:none !important}" },
  "news5.de": { s: "#privacyContainer{display:none !important}" },
  "gamblejoe.com": { s: ".c-area{display:none !important}" },
  "tti.at": { c: 0 },
  "uchicago.edu": { s: ".js_gdpr{display:none !important}" },
  "bambergfacts.de": { s: 'div[id^="cookiebar"]{display:none !important}' },
  "backpackerguide.nz": { s: "#fbGroupMini{display:none !important}" },
  "swisslife.fr": { s: ".mod-disclaimer{display:none !important}" },
  "trennung.de": { s: "#allowCookie{display:none !important}" },
  "kramp.com": { j: "5" },
  "oebv.net": { c: 45 },
  "bien-dans-mon-train.com": { s: ".cookiecall{display:none !important}" },
  "xg1.li": { s: "#privacy-footer{display:none !important}" },
  "nrjmobile.fr": { s: "#ei_cookie{display:none !important}" },
  "kiwi.com": {
    s: 'div[class*="CookiesConsentContainer"]{display:none !important}',
  },
  "d-secour.de": { s: "#importantMessages{display:none !important}" },
  "dupuis.com": { s: ".dp-cookie-legal{display:none !important}" },
  "metal-shop.eu": { s: "#nextcreBotDialog{display:none !important}" },
  "negrini.com": { s: "#cksModal{display:none !important}" },
  "best-sound.com": { c: 21 },
  "dartinfo.nl": { c: 144 },
  "the-match-factory.com": { s: "#infoBar{display:none !important}" },
  "botify.com": { s: ".fixed.pin-l.pin-b.z-10.flex{display:none !important}" },
  "pacesuite.com": { s: "#notification-cont{display:none !important}" },
  "getfilecloud.com": { s: "#gdpr_accept{display:none !important}" },
  "priberam.org": { s: ".pb-cookies{display:none !important}" },
  "provantage.com": { s: "#PP{display:none !important}" },
  "grotekleren-webwinkel.nl": { c: 4 },
  "broadleyautomotive.co.uk": { s: "#esc-wrapper{display:none !important}" },
  "bip.piaseczno.eu": { c: 0 },
  "rotterdam.info": { c: 0 },
  "daf.co.uk": { c: 14 },
  "onboarding.daf.com": { c: 14 },
  "daf.nl": { c: 14 },
  "oskolaf.pl": { j: "5" },
  "papyrus.com": {
    s: "#consentManager,#cookieConsentAreaModal{display:none !important}",
    c: 14,
  },
  "prvikvadrat.hr": { j: "5" },
  "routereflector.com": {
    s: ".modal{display:none !important}",
    c: 14,
  },
  "salter.es": {
    s: "#modal-start{overflow:unset !important}",
    c: 14,
  },
  "walserprivatbank.com": { s: ".block_consent{display:none !important}" },
  "keenfootwear.com": { s: ".notice-top{display:none !important}" },
  "sega.co.uk": { s: ".cp-wrap{display:none !important}" },
  "globalpetrolprices.com": { c: 0 },
  "phoenixcontact.com": { s: "#infoBoxFrame{display:none !important}" },
  "blogs.timesofisrael.com": { c: 37 },
  "cff.ch": { s: ".messageBar{display:none !important}" },
  "carglass.it": { j: "5" },
  "sinonimos.com.br": { c: 55 },
  "aquacoimbra.com": { s: "#cookiescontainer{display:none !important}" },
  "musikzirkus.eu": { s: ".infobox{display:none !important}" },
  "domotex.de": { c: 92 },
  "annualreviews.org": { s: ".ar-news-footer{display:none !important}" },
  "isidewith.com": { s: ".overlayBG,.overlayContent{display:none !important}" },
  "csu.de": { s: ".mod-layer{display:none !important}" },
  "voria.gr": { s: "#cookies_area{display:none !important}" },
  "praktiker.ro": { s: ".cookie-form{display:none !important}" },
  "vova.com": { s: ".activity-cookie{display:none !important}" },
  "rebirth-hannover.de": { s: ".c-callout{display:none !important}" },
  "parkindigo.com": { s: "idg-cookie-info-bar{display:none !important}" },
  "vw.com.br": { c: 120 },
  "ms.gov.pl": { s: '#MS[style*="block"]{display:none !important}' },
  "warszawa.so.gov.pl": { c: 0 },
  "mkidn.gov.pl": { j: "5" },
  "archiwa.gov.pl": { s: "#message_box{display:none !important}" },
  "gdansk.wios.gov.pl": { j: "5" },
  "monitoring.krakow.pios.gov.pl": { s: ".a-footer{display:none !important}" },
  "purepla.net": { j: "5" },
  "imagine-r.com": { c: 0 },
  "henryschein.at": { s: ".hs-block-ui,.hs-dialog{display:none !important}" },
  "paypal-community.com": { j: "5" },
  "patience-is-a-virtue.org": { s: "#copy > p{display:none !important}" },
  "opi.org.pl": { s: "jsa-cookie{display:none !important}" },
  "bloomandwild.com": { s: ".bwCookieMessage{display:none !important}" },
  "devart.com": { s: ".popup-wrapper{display:none !important}" },
  "isa.org": {
    s: "#simplemodal-container,#simplemodal-overlay{display:none !important}",
  },
  "pfeiffer-vacuum.com": { s: "#pfCookieNotice{display:none !important}" },
  "malmo.se": { j: "5" },
  "asroma.com": {
    s: ".s-navigation-tool-panel-disclaimer{display:none !important}",
  },
  "wavesplatform.com": { j: "5" },
  "picload.org": { c: 0 },
  "benu.cz": { s: ".info-bar{display:none !important}" },
  "pb.edu.pl": { c: 0 },
  "ad.win.nl": { j: "5" },
  "bpsa.co.uk": { s: "#terms_container{display:none !important}" },
  "arridgegaragedoors.co.uk": {
    s: ".small-cookie-notice .tingle-modal{display:none !important}",
  },
  "berentzen-gruppe.de": { c: 9 },
  "kiplinger.com": { j: "5" },
  "suelo.pl": { c: 99 },
  "bazarcom.cz": { s: ".colorbox-agreement{display:none !important}" },
  "forum.snsbank.nl": { s: "#clcback,#consentdiv{display:none !important}" },
  "digminecraft.com": { c: 4 },
  "unifilm.de": { s: ".form-dsgvo{display:none !important}" },
  "thelanguagehouse.net": { s: ".site-cookie{display:none !important}" },
  "rabobank.com": { j: "5" },
  "cifempleo.com": { c: 0 },
  "edingershops.de": { s: ".bggrey,.alertbox{display:none !important}" },
  "gnhm.gr": { c: 3 },
  "robens-dn.de": { j: "5" },
  "zora.bg": { s: ".bottom-freezed-bar{display:none !important}" },
  "exki.be": { s: ".lang-cookie{display:none !important}" },
  "hotelquickly.com": {
    s: '#app > div > div[style*="height"]{display:none !important}',
  },
  "elempleo.com": { s: ".politics_cookie{display:none !important}" },
  "everything5pounds.com": {
    s: '.__ADORIC__[style*="fixed"]{display:none !important}',
  },
  "ring.com": { s: "#teconsent{display:none !important}" },
  "netflix-nederland.nl": { c: 144 },
  "sothebys.com": { s: "#NotificationOverlay{display:none !important}" },
  "srf.ch": { s: ".personalizationMessageWrapper{display:none !important}" },
  "retailtrends.nl": { j: "5" },
  "rusmeteo.net": { s: ".alert-danger.in{display:none !important}" },
  "programiz.com": { c: 26 },
  "rofl-nerd.net": { j: "5" },
  "buzzpeoplemag.com": { s: ".sca.block{display:none !important}" },
  "zeek.me": { s: ".zk-footer ~ div{display:none !important}" },
  "ideo.com": { s: '.App > div[class*="Fixed"]{display:none !important}' },
  "planningwiz.com": { j: "5" },
  "bad-mergentheim.de": { c: 53 },
  "ing.com": { j: "5" },
  "qxl.no": { c: 0 },
  "coinomi.com": {
    s: '.dialog[data-dialog-id="cookies"]{display:none !important}',
  },
  "cocoscope.com": { c: 75 },
  "royalenfield.com": { j: "5" },
  "jobrad.org": { s: ".generic-note{display:none !important}" },
  "teenmegaworld.net": { j: "5" },
  "hasselblad.com": { s: ".prompt-content{display:none !important}" },
  "morticeandgreensashwindowrepairs.co.uk": {
    s: ".b-modal,.pps-popup{display:none !important}",
  },
  "online.auktionsverket.se": { c: 27 },
  "ming-fahrschull.de": {
    s: '.notification[data-cookie*="cookies_demo"]{display:none !important}',
  },
  "bsdforen.de": { c: 11 },
  "ckib.de": { s: ".tve-leads-ribbon{display:none !important}" },
  "calendarpedia.com": { c: 12 },
  "triglavzdravje.si": { s: "#cookie_module{display:none !important}" },
  "pmmp.io": { s: "#remindTos{display:none !important}" },
  "paks-bayern.weebly.com": { j: "5" },
  "cubbit.net": { s: "#root > div > footer ~ div{display:none !important}" },
  "lesara.de": { c: 9 },
  "light.co": { c: 3 },
  "hackerone.com": { s: ".footer-popup{display:none !important}" },
  "asdinfowales.co.uk": { c: 1 },
  "recevoirlatnt.fr": { c: 23 },
  "dormezbien.fr": { c: 23 },
  "air-cosmos.com": { c: 23 },
  "villeneuve92.com": { c: 23 },
  "chassis-en-bois.fr": { c: 23 },
  "bourse-immobilier.fr": { c: 23 },
  "tinkco.com": { c: 23 },
  "fontenayenscenes.fr": { c: 23 },
  "hardstyle-industry.com": { c: 23 },
  "cestfrais.fr": { c: 23 },
  "sucredorge.com": { c: 23 },
  "iseki.fr": { c: 23 },
  "moncompte.sodexopass.fr": { c: 23 },
  "bitrise.io": { s: "bitrise-cookie-tab{display:none !important}" },
  "robots.ox.ac.uk": { s: ".slidingDiv{display:none !important}" },
  "imobie.com": { s: ".fixedbot{display:none !important}" },
  "techvorace.com": { s: "#tfade,#tlight{display:none !important}" },
  "ftg-frankfurt.de": { s: "#dataInfoBox{display:none !important}" },
  "winkel.parool.nl": { c: 58 },
  "iradio.ie": { j: "5" },
  "arukhaza.com": { c: 1 },
  "lpexpress.lt": { s: "#cookies-block{display:none !important}" },
  "blockchainsecurity.services": { c: 136 },
  "factorymarket.de": { s: ".header-notification{display:none !important}" },
  "austria.info": {
    s: ".header-notification{display:none !important}.header-notification-active .inner-wrap{padding-top:0 !important}",
  },
  "damuels.travel": {
    s: ".header-notification{display:none !important}body.header-notification-active div.w2{margin-top:0 !important}",
  },
  "paladins.com": { s: "section.footer ~ div{display:none !important}" },
  "webyog.com": { s: "#top-banner{display:none !important}" },
  "fran.si": { c: 12 },
  "datarecoverynederland.nl": { s: "#cookie-contest{display:none !important}" },
  "onehowto.com": { s: ".consent,.app_gdpr--2{display:none !important}" },
  "screenseven.com": { s: "#gamigoCookie{display:none !important}" },
  "bonkersabouttech.com": { s: ".legal-info{display:none !important}" },
  "holadoctor.com": { s: ".gdpr-space{display:none !important}" },
  "hegau-archers.de": { c: 1 },
  "about.me": { s: '.bubble[class*="cookie_notice"]{display:none !important}' },
  "amerisourcebergen.com": {
    s: ".legal-acknowledgement{display:none !important}",
  },
  "buydifferent.it": { c: 1 },
  "chordify.net": { j: "5" },
  "aerospace-lab.de": { s: ".themify-popup{display:none !important}" },
  "check.toys": { s: "#COO{display:none !important}" },
  "ered.gr": { s: ".coucou{display:none !important}" },
  "alanus.edu": { s: ".stoerer-wrapper{display:none !important}" },
  "realmroyale.com": { s: ".footer + div{display:none !important}" },
  "beardbrand.com": { j: "5" },
  "jointcommission.org": { j: "5" },
  "usehoney.io": {
    s: 'iframe[src*="usehoney.io/embed/widget/"]{display:none !important}',
  },
  "schwarzberlin.com": { c: 0 },
  "itrack.it": { s: "#ga-accept{display:none !important}" },
  "nats.io": { s: "#main_gdpr{display:none !important}" },
  "moveforwardpt.com": { s: "#stickyMessage{display:none !important}" },
  "mediaplus.com": { s: ".fixed_top{display:none !important}" },
  "pixflow.net": { c: 34 },
  "pmg-mainz.de": { s: "#footer > section{display:none !important}" },
  "movimento5stelle.it": { s: "#disclaimerC{display:none !important}" },
  "accorhotels.jobs": { s: "#cookiesAccorJobs{display:none !important}" },
  "myworkdayjobs.com": {
    s: 'div[data-automation-id="legalNotice"]{display:none !important}',
  },
  "digi-animalworld.tv": { c: 3 },
  "dmc-watch.com": { s: ".promo-bar-container{display:none !important}" },
  "tshirt-corner.com": { s: ".tc-cnil{display:none !important}" },
  "modesens.com": { s: "#tip_container{display:none !important}" },
  "max.fr": { s: ".notice-cook{display:none !important}" },
  "act-store.com": { s: "#POPUPS_WRAPPER{display:none !important}" },
  "kartunsy.pl": { s: "#ait-infobar{display:none !important}" },
  "kurfuerstenschaenke-dresden.de": { c: 64 },
  "huaweipolska.pl": { s: ".huawei-cookie{display:none !important}" },
  "carrando.com": { s: "#dsg{display:none !important}" },
  "sportraw.pl": {
    s: 'body > div[id^="tws"]:not(.toplayerSpecialClass),#topLayerBackDrop{display:none !important}',
  },
  "rail-sim.de": { s: ".popupBase.notification{display:none !important}" },
  "noir.pl": { c: 0 },
  "tutoriauxpc.com": { c: 1 },
  "speckproducts.co.uk": { c: 103 },
  "chess.org": { s: ".messages{display:none !important}" },
  "sticksnsushi.com": {
    s: 'div[data-module="CookieBanner"]{display:none !important}',
  },
  "krasniykarandash.ru": {
    s: ".site-footer + div[class]:not([id]){display:none !important}",
  },
  "ratedpeople.com": {
    s: 'div[class*="cookie-acceptance-banner"]{display:none !important}',
  },
  "telecinco.es": { j: "6" },
  "portalsamorzadowy.pl": { j: "5" },
  "dplay.fi": { s: 'div[class^="notification"]{display:none !important}' },
  "virginmediastore.com": { c: 124 },
  "mobilepay.fi": { s: 'div[class*="cookie-dialog"]{display:none !important}' },
  "e-fo.fr": { s: "#spanLien > div:first-child{display:none !important}" },
  "pip.gov.pl": { s: "#privacyOverlay{display:none !important}" },
  "mesago.de": { s: "#privacy_overlay{display:none !important}" },
  "panattasport.com": { s: ".notification-block{display:none !important}" },
  "conforti.it": {
    s: "#ll_banner,#ll_info,.ll_link_bottom{display:none !important}",
  },
  "spectacles.com": { c: 9 },
  "kerbalspaceprogram.com": { j: "5" },
  "wiki.kerbalspaceprogram.com": {
    s: "#my-js-modal,#cover{display:none !important}",
  },
  "mquadr.at": { s: "#info{display:none !important}" },
  "truevalue.es": { s: ".cookies-lay{display:none !important}" },
  "pharmindex-online.hu": { j: "5" },
  "egmnow.com": { s: ".egm-cookie-flyout{display:none !important}" },
  "tennis-warehouse.com": { c: 104 },
  "goodhoodstore.com": { s: ".cc_msg{display:none !important}" },
  "hastens.com": { c: 98 },
  "easterngraphics.com": { c: 1 },
  "zaliastotele.lt": { s: "#wrapperCookie{display:none !important}" },
  "serpstat.com": { s: ".gdpr-tab{display:none !important}" },
  "derkonzert.de": { s: "footer ~ div:last-child{display:none !important}" },
  "bekendeburen.nl": { s: "#AVG-message{display:none !important}" },
  "mspy.com": { s: ".cookie-l{display:none !important}" },
  "brainpop.com": { s: "#announcment_alert{display:none !important}" },
  "close-up.it": { s: ".stickyFooter{display:none !important}" },
  "remosoftware.com": { s: ".visitornotice{display:none !important}" },
  "autotrader.nl": { j: "5" },
  "lunchtime.de": { s: ".overlay_gray_bg{display:none !important}" },
  "pluralsight.com": { c: 21 },
  "adata.com": { s: "#chk_remark{display:none !important}" },
  "tupperware.de": {
    s: ".is-cookie-bar .flyout,.is-cookie-bar .header,.is-cookie-bar .page-content,.is-cookie-bar .search{animation:none !important}",
  },
  "rems71.ru": { s: 'body > div[id^="div"]{display:none !important}' },
  "aurubis.com": { j: "5" },
  "fullscreenmedia.co": { c: 21 },
  "hsl.fi": { s: "#messageBar{display:none !important}" },
  "septima.dk": { s: ".septimacc{display:none !important}" },
  "teldust.com": { s: ".cookies-tab{display:none !important}" },
  "medicshop.de": { s: "#cookiemedic{display:none !important}" },
  "hpinfomedia.de": { s: "#dataPrivacy{display:none !important}" },
  "gpgroot.nl": { s: "#ckc_hdr{display:none !important}" },
  "tvasta.pl": { j: "5" },
  "powiatslubicki.pl": { j: "5" },
  "techonthenet.com": { c: 4 },
  "gea.com": { s: ".language-detection__cookie{display:none !important}" },
  "metcheck.com": { s: "#EUModal,.reveal-modal-bg{display:none !important}" },
  "sbsr.fm": {
    s: '.bl-block[data-bl-name="CokiesWrap"]{display:none !important}',
  },
  "nox-xtreme.com": {
    s: "#root > div > div[class]:not([data-reactid]){display:none !important}",
  },
  "iam8bit.com": { s: ".alertify{display:none !important}" },
  "letgo.si": { s: "#container > div{display:none !important}" },
  "astro-seek.com": { c: 31 },
  "spiking.io": { s: ".PopupCookies{display:none !important}" },
  "mount10.ch": { s: ".ck-bn{display:none !important}" },
  "sociall.io": { s: "mat-dialog-container{display:none !important}" },
  "crackwatch.com": { s: ".Overlay{display:none !important}" },
  "dinamalar.com": { s: ".quickslide{display:none !important}" },
  "f1racing.pl": { j: "5" },
  "vivaldi.com": { j: "5" },
  "iqoption.com": {
    s: 'div[data-test-id="notification-position-container-block"]{display:none !important}',
  },
  "flows.be": { s: "#flows-cookie-compliance-popup{display:none !important}" },
  "netflixinbelgie.be": { c: 144 },
  "fansbreak.com": { c: 0 },
  "pipelife.at": { c: 134 },
  "infosecurity.nl": { j: "5" },
  "ricominciodaquattro.com": { s: "#cbox-notice{display:none !important}" },
  "zurzeit.eu": { j: "5" },
  "re.is": { s: ".cookiemodal{display:none !important}" },
  "infotorg.no": { s: ".sticky-footer-banner{display:none !important}" },
  "brendon.hu": { c: 27 },
  "acronymfinder.com": { c: 1 },
  "newrelic.com": { s: "#intercom-container{display:none !important}" },
  "timberfarm.de": {
    s: "#block-timberfarm-cms-cookie{display:none !important}",
  },
  "labor-stephansplatz.de": { s: "#bho_infobar{display:none !important}" },
  "curiouscat.me": { s: ".consentWrapper{display:none !important}" },
  "webstaurantstore.com": { j: "5" },
  "sterrenoptv.nl": { c: 144 },
  "mirantis.com": { c: 11 },
  "americares.org": { s: ".snipe-banner{display:none !important}" },
  "portfoliospreadsheets.com": { c: 32 },
  "architecture.com": { s: ".info-bar{display:none !important}" },
  "moneyonline.gr": { s: "#cookies-shell{display:none !important}" },
  "spreds.com": {
    s: '.u-marginless[data-react-props*="cookies"]{display:none !important}',
  },
  "outsphera.it": { c: 48 },
  "stockhouse.com": { j: "5" },
  "wolterskluwer.pl": { s: "#wk-brg-cookie-info{display:none !important}" },
  "orange.be": { s: ".zpWinThemeBanner{display:none !important}" },
  "sibur.ru": { c: 26 },
  "fis-ski.com": {
    s: ".s-navigation-tool-panel-disclaimer{display:none !important}",
  },
  "popuz.com": { c: 26 },
  "supermemo.com": { c: 105 },
  "redlight.net": { c: 1 },
  "raceface.com": { s: "#privacy,#cookies{display:none !important}" },
  "hamburgsud.com": { s: ".m-cookie__content{display:none !important}" },
  "stundin.is": { s: ".bottom-banner{display:none !important}" },
  "galileo.tv": { s: "#cookieBannerGTV{display:none !important}" },
  "myaustrianblog.at": { s: ".cop{display:none !important}" },
  "go1a.de": { s: ".mod-layer{display:none !important}" },
  "1aautoservice.de": { s: ".mod-layer{display:none !important}" },
  "visaquarium.nl": { s: ".tb{display:none !important}" },
  "awattar.com": { s: "#agree{display:none !important}" },
  "nettrading.ro": { c: 80 },
  "agroarbo.nl": { s: ".cookie,.lights--out{display:none !important}" },
  "new-rock-france.com": { s: "#brl-cookie{display:none !important}" },
  "bright-products.com": {
    s: "#ncm.ncm-collapsed.ncm-ready{display:none !important}",
  },
  "vpeag.com": { s: ".Footer + .BottomLine{display:none !important}" },
  "aripaev.ee": { c: 138 },
  "meldpuntwegen.be": { j: "5" },
  "crowdestate.eu": { j: "5" },
  "agcocorp.com": { s: ".disclaimerpopup{display:none !important}" },
  "explaineverything.com": { s: "footer + div{display:none !important}" },
  "ludwig.guru": { s: 'div[class*="__disclaimer"]{display:none !important}' },
  "soldaatvanoranje.nl": { c: 17 },
  "groen.be": { c: 8 },
  "gorillasports.de": { c: 8 },
  "gamingoase.de": { c: 8 },
  "elektrotresen.de": { c: 8 },
  "bitmoji.com": { c: 8 },
  "kaffee-melangerie.de": { c: 8 },
  "liveradio.ie": { c: 8 },
  "letsdeal.no": { s: 'div[class^="gdpr-panel"]{display:none !important}' },
  "letsdeal.se": { s: 'div[class^="gdpr-panel"]{display:none !important}' },
  "transitionnetwork.org": {
    s: "#tofino-notification{display:none !important}",
  },
  "wotinfo.net": { c: 134 },
  "find.com.tr": { s: "#KVK_Cerez{display:none !important}" },
  "fctwente.nl": { j: "5" },
  "ittrend.hu": { s: "#suti{display:none !important}" },
  "rocketleagueesports.com": { c: 37 },
  "kon-boot.com": {
    s: "#myModal{display:none !important}",
    c: 14,
  },
  "makita.fr": { c: 8 },
  "jmmgc.com": { s: "#cnotice{display:none !important}" },
  "pipe-organ-recordings.com": {
    s: ".cookies--container{display:none !important}",
  },
  "carhartt.com": {
    s: "#consentModal,.reveal-modal-bg{display:none !important}",
  },
  "operadeparis.fr": { c: 113 },
  "shadertoy.com": { s: "#compliance{display:none !important}" },
  "ipla.tv": { j: "5" },
  "zanotti.com": {
    s: "#ll_banner,#ll_info,.ll_link_bottom{display:none !important}",
  },
  "shrm.org": { s: ".shrm-gdpr{display:none !important}" },
  "tcroomburg.nl": { j: "5" },
  "mvagusta.com": {
    s: 'div[class^="bannerContainer"]{display:none !important}',
  },
  "mediafour.com": { s: "#wpnb-bar{display:none !important}" },
  "messe-kassel.de": { s: ".note{display:none !important}" },
  "askthepsych.com": { s: "#cks{display:none !important}" },
  "iboysoft.com": { s: "#user_popup{display:none !important}" },
  "durszlak.pl": { s: ".privacy-layer{display:none !important}" },
  "globallogic.com": { s: "#ac-wrapper{display:none !important}" },
  "milanos.pl": { s: "#rodo-pop{display:none !important}" },
  "watispilling.nl": { s: ".fancybox-overlay{display:none !important}" },
  "ruba535.ca": { s: "#disclaimer-box{display:none !important}" },
  "humbersideairport.com": { c: 0 },
  "wasserklinik.com": { s: "#snppopup-welcome{display:none !important}" },
  "romedic.ro": { s: "#cookbox{display:none !important}" },
  "skechers.com": { s: "#cookiep{display:none !important}" },
  "okpal.com": { j: "5" },
  "martinus.cz": { j: "5" },
  "ivet.pl": { s: "#popup1{display:none !important}" },
  "clubheldvanhetjaar.nl": {
    s: "#SiteWrapper > .wp > .wp + .wp{display:none !important}",
  },
  "vox.pl": { j: "5" },
  "jobmensa.de": { s: ".js-usermessage{display:none !important}" },
  "nouw.com": { s: "#ConsentBanner{display:none !important}" },
  "pizza.de": { s: 'div[data-qa*="notification"]{display:none !important}' },
  "wiertz.com": { j: "5" },
  "mx.recepedia.com": { c: 12 },
  "ruedesplantes.com": { s: 'div[class^="cookies"]{display:none !important}' },
  "sdrplugins.com": {
    s: ".widget-footer > section > div:not([class]){display:none !important}",
  },
  "appi.org": { j: "6" },
  "laptopsystem.hu": { c: 12 },
  "pallottinum.pl": { c: 1 },
  "bock-kunststofftechnik.de": {
    s: 'div[id^="cookielaw_"]{display:none !important}',
  },
  "niveamen.co.uk": { c: 13 },
  "mcsuk.org": { s: "#a3prompt{display:none !important}" },
  "biblio.co.uk": { c: 42 },
  "results.decisiondeskhq.com": { c: 8 },
  "colormango.com": { s: ".setprivacy{display:none !important}" },
  "hik-connect.com": { s: ".coverShow{display:none !important}" },
  "twentemilieu.nl": { s: ".balloon_notification{display:none !important}" },
  "e-conomic.dk": { c: 21 },
  "mijndomein.nl": { s: "#dd_overlay,#dd_popup{display:none !important}" },
  "corso-saunamanufaktur.com": {
    s: "#dataprotection{display:none !important}",
  },
  "rdvconso.org": { j: "5" },
  "live365.com": {
    s: '.site > div[class*="root"] > div:not(.action-bar){display:none !important}',
  },
  "tipsyelves.com": { j: "5" },
  "egym.com": { s: ".egym-prompt{display:none !important}" },
  "totaljs.com": { s: ".ui-cookie2{display:none !important}" },
  "riot.im": { s: ".mx_MatrixToolbar{display:none !important}" },
  "waff.at": { s: ".en-pn-bar.en-notification{display:none !important}" },
  "alldent-zahnzentrum.de": { s: "#dialog{display:none !important}" },
  "dana.at": { s: ".theCookie{display:none !important}" },
  "thefreelibrary.com": { c: 1 },
  "ams.at": { s: ".ams-m-cookie-warning{display:none !important}" },
  "receiver.de": { s: ".legalAdvice{display:none !important}" },
  "66.ru": { s: ".t-i-agree{display:none !important}" },
  "schmidtnorm.at": {
    s: "#infoleiste > .container > .row > .col-12:not(.text-md-right){display:none !important}",
  },
  "codra.net": { j: "5" },
  "flamcogroup.com": {
    s: ".stn-cookies,.stn-cookies-enlarge{display:none !important}",
  },
  "icebug.se": { s: "#root > div > [delay]{display:none !important}" },
  "keskeces.com": { s: "#cook,#cook2{display:none !important}" },
  "hostkey.com": { s: "#collectData{display:none !important}" },
  "fliesenoutlet.com": { c: 8 },
  "reifen-service-rostock.de": { s: "#my_cw_label{display:none !important}" },
  "propellets.at": { c: 31 },
  "dipisoft.com": { s: ".accookie{display:none !important}" },
  "infodent24.pl": { j: "5" },
  "kidioui.fr": { j: "5" },
  "wps.com": { c: 3 },
  "skargards.com": { s: "#cc_dialog{display:none !important}" },
  "casopis-rozmaryna.cz": { s: "#fucktheEU{display:none !important}" },
  "comhem.se": { c: 138 },
  "pacsun.com": { s: "#consent-tracking{display:none !important}" },
  "milliman.com": { j: "5" },
  "vk.se": { s: ".ReactModal__Overlay--after-open{display:none !important}" },
  "liander.nl": { s: "#webLianderCookieBanner{display:none !important}" },
  "stofa.dk": { s: 'div[class*="CookieDisclaimer"]{display:none !important}' },
  "toluna.com": { s: ".notification-center{display:none !important}" },
  "ticketmarket.lt": { c: 4 },
  "webwinkel.ad.nl": { c: 58 },
  "webwinkel.ed.nl": { c: 58 },
  "webwinkel.pzc.nl": { c: 58 },
  "webwinkel.bndestem.nl": { c: 58 },
  "webwinkel.gelderlander.nl": { c: 58 },
  "webwinkel.destentor.nl": { c: 58 },
  "webwinkel.volkskrant.nl": { c: 58 },
  "poe.de": { c: 11 },
  "ozcouponscode.com": { s: ".policy_footer{display:none !important}" },
  "onlinetvrecorder.com": {
    s: '#footerdiv > div[style*="z-index"]{display:none !important}',
  },
  "drivetribe.com": {
    s: '#root > div ~ div[class*=" "]{display:none !important}',
  },
  "ibm.com": {
    s: ".ibm-canada-notice,.ibm-canada-notice-button{display:none !important}",
  },
  "infomir.eu": { s: "#cb{display:none !important}" },
  "bdew.de": { s: ".bdew__cookiebanner{display:none !important}" },
  "brainandlife.org": { s: ".breaking-container{display:none !important}" },
  "vivanta.es": { s: ".dv-cookies{display:none !important}" },
  "si-vreme.com": { s: "#siv_cookieBanner{display:none !important}" },
  "loteriainpost.pl": { s: "#pop_up{display:none !important}" },
  "gadzetomania.pl": { j: "5" },
  "mojoreads.com": {
    s: 'div[class*="cookiesPolicy"]{display:none !important}',
  },
  "online2pdf.com": { s: "#privacy_msg{display:none !important}" },
  "laznevbechyni.cz": { s: ".fixed-box{display:none !important}" },
  "mee.com": { s: "#cboxOverlay{display:none !important}" },
  "strefakursow.pl": { s: ".b-cookies{display:none !important}" },
  "satakunnanautotalo.fi": {
    s: ".AVS-evasteseloste-container{display:none !important}",
  },
  "psicologia-online.com": { c: 4 },
  "ben.nl": { j: "5" },
  "medlibrary.org": { s: "#cks{display:none !important}" },
  "cathaypacific.com": { s: ".system-alert-wrapper{display:none !important}" },
  "wylecz.to": { j: "5" },
  "gab-umweltservice.de": { s: "#rcpm{display:none !important}" },
  "nasze-kino.tv": { c: 0 },
  "bettyblocks.com": { s: "#ageNotification{display:none !important}" },
  "hansvanwijk.nl": { s: "#cookiewall-modal{display:none !important}" },
  "bn.ru": { s: ".cookie--form{display:none !important}" },
  "noritake-itron.jp": { s: "#gdpr_nav{display:none !important}" },
  "guitaretab.com": { c: 1 },
  "tsuldotejo.pt": { c: 106 },
  "themagpiesalute.com": { c: 140 },
  "metatrader4.com": { s: "#float-vertical-panel{display:none !important}" },
  "aboardtheworld.com": { s: ".popmake{display:none !important}" },
  "enzopennetta.it": { s: ".popmake{display:none !important}" },
  "penseurope.com": { s: '.container[role="alert"]{display:none !important}' },
  "eonline.com": { s: ".view-gdpr{display:none !important}" },
  "lloyd.com": { s: "#globalerror{display:none !important}" },
  "hario.com": { s: "#sample-dialog.dialog{display:none !important}" },
  "ads.nipr.ac.jp": { s: ".backdrop{display:none !important}" },
  "urbia.de": { s: ".layer-confirm-bottom{display:none !important}" },
  "lactalisfoodservice.es": { s: ".LSSI{display:none !important}" },
  "hoteldiamant.cz": { s: ".nl_cookies{display:none !important}" },
  "gewinnspiel.toom.de": { c: 9 },
  "shotsdeciencia.com": {
    s: '.x-el[data-ux="Widget"][class*="widget-footer-footer"]{display:none !important}',
  },
  "united.com": {
    s: 'div[class*="cookiedisclaimer"]{display:none !important}',
  },
  "domi.com": { s: "#CoockiesPage{display:none !important}" },
  "dreamworksanimation.com": {
    s: ".dwa-embed-cookie-consent-container{display:none !important}",
  },
  "theburgerhouse.com": { s: "#close-cookies{display:none !important}" },
  "euromaxx.nu": { c: 27 },
  "mybiclighter.com": { c: 0 },
  "stokokkino.gr": { s: "#popupform1{display:none !important}" },
  "peugeotscooters.pt": { c: 63 },
  "foundry.com": { s: ".EUc{display:none !important}" },
  "apps-drones.com": { c: 23 },
  "sww.de": { s: "#cookieadd{display:none !important}" },
  "e-sochaczew.pl": { j: "5" },
  "norgips.pl": { j: "5" },
  "modr.pl": { s: ".region-gdpr{display:none !important}" },
  "gazetapraca.pl": { s: "#overlayJS{display:none !important}" },
  "sightseeing-kontor.de": { s: "#sk-info{display:none !important}" },
  "nationalezorggids.nl": { s: ".cookieModal{display:none !important}" },
  "nginx.com": { s: 'div[id*="nx_gdpr_modal"]{display:none !important}' },
  "mareespeche.com": { c: 0 },
  "bergische-energie.de": { c: 1 },
  "bestlivecamsites.com": { s: ".ntfc-bar{display:none !important}" },
  "fast-mirror.de": { s: "body > div[align]{display:none !important}" },
  "shoppable.com": { j: "5" },
  "kaliber.pl": { j: "5" },
  "travelchannel.co.uk": { j: "5" },
  "letssingit.com": { j: "6" },
  "lyricsbox.com": { j: "6" },
  "doc.fr": { j: "6" },
  "etletstalk.com": { s: 'body > div[id^="ulp-"]{display:none !important}' },
  "zenhotels.com": { s: ".zen-privacypolicypopup{display:none !important}" },
  "db.com": { s: ".dbe-content_cookie.alert{display:none !important}" },
  "payscale.com": { j: "6" },
  "skolakov.eu": { s: "#cookieslista{display:none !important}" },
  "semanticscholar.org": { s: ".copyright-banner{display:none !important}" },
  "advatus.pl": { s: ".myModal-box{display:none !important}" },
  "ip-sa.pl": { s: ".myModal-box{display:none !important}" },
  "fabrykacukiernika.pl": { j: "5" },
  "totalcasino.pl": { j: "5" },
  "worldsbiggestchat.com": { c: 96 },
  "lycoschat.com": { c: 96 },
  "kleiderkreisel.de": { c: 76 },
  "checkdomain.de": { s: "#notifications-container{display:none !important}" },
  "canadiansolar.com": { c: 0 },
  "royaldesign.no": { j: "6" },
  "trubendorffer.nl": { j: "5" },
  "jobserve.com": { j: "5" },
  "toto.com": { s: ".cookieSection{display:none !important}" },
  "smarturl.it": { s: "#consent-block{display:none !important}" },
  "aignes.com": { s: "#aignescookie{display:none !important}" },
  "unive.nl": { j: "5" },
  "mjamjam-petfood.de": {
    s: ".cookie5,.cookie5 + .allover{display:none !important}",
  },
  "vicisitudysordidez.com": { s: ".lwpcngNotice{display:none !important}" },
  "eneco.nl": { j: "5" },
  "hotel.de": { s: 'div[class*="cookieWrapper"]{display:none !important}' },
  "pieseauto.ro": { j: "5" },
  "mafiadoc.com": { s: "#MAFIADOCCOM_cookie_box{display:none !important}" },
  "aamuset.fi": { c: 1 },
  "kult-portal.com": { c: 136 },
  "wallpapershome.com": { s: ".cc-dialog{display:none !important}" },
  "fotocommunity.de": { c: 10 },
  "urraeroi.it": { c: 0 },
  "wurth.es": { j: "5" },
  "spinnaker-watches.com": { s: ".fixedbar{display:none !important}" },
  "superpedestrian.com": {
    s: '.sp-overlay[ng-show="!showApp"]{display:none !important}',
  },
  "castbox.fm": { s: ".cookies-conf{display:none !important}" },
  "pkspolonus.pl": { s: "#popek{display:none !important}" },
  "bein.net": {
    s: '.app-container > div[class]:not(.app-content):not([class*=" "]){display:none !important}',
  },
  "youngsseafood.co.uk": { c: 10 },
  "arlestourisme.com": { c: 0 },
  "conan-kolekcja.pl": { c: 0 },
  "dkl24.pl": { s: "#cookies_accepted{display:none !important}" },
  "antyczek.pl": { c: 80 },
  "humanoffice.pl": { s: "#cookie_cointer{display:none !important}" },
  "mobilier-mirjan24.ro": { s: "#window_overlay{display:none !important}" },
  "midas.co.za": { j: "5" },
  "checkyourmath.com": { c: 4 },
  "harper-adams.ac.uk": { c: 0 },
  "devhut.net": {
    s: ".ht-notification-text .su-note{display:none !important}",
  },
  "engelsrufer.de": { s: "#backcolorcookies{display:none !important}" },
  "mcafeestore.com": { s: ".cookie_module{display:none !important}" },
  "nperf.com": { c: 4 },
  "canadacomputers.com": { s: ".privacy-modal{display:none !important}" },
  "alivecolors.com": { c: 10 },
  "goodvibes.com": { s: "#bottomAlert{display:none !important}" },
  "asnbank.nl": { j: "5" },
  "red-carparts.de": { c: 8 },
  "carlovalentini.it": { s: "#footer-widget-area{display:none !important}" },
  "streamcraft.com": { s: ".privacy-wraper{display:none !important}" },
  "helemaalshea.nl": { s: ".fancybox-overlay{display:none !important}" },
  "voidu.com": { j: "5" },
  "cv-sanitairkorting.nl": { c: 27 },
  "redaccionmedica.com": { s: ".iframe_cookies{display:none !important}" },
  "helmet.fi": {
    s: ".notification,.notifier_warning{display:none !important}",
  },
  "yourbaroness.com": { c: 140 },
  "commsec.com.au": { s: ".announcements{display:none !important}" },
  "lavalleedestortues.fr": { j: "5" },
  "changelly.com": { s: ".clly-notification{display:none !important}" },
  "breakplan.pl": { s: ".cookie_logo{display:none !important}" },
  "durs.si": { s: "#trCookie{display:none !important}" },
  "smartshop.hu": { j: "5" },
  "higherlowergame.com": {
    s: ".app-store-icons ~ section{display:none !important}",
  },
  "new-life-soundmagazine.com": { c: 27 },
  "educazionesanitaria.com": { s: ".privacy_check{display:none !important}" },
  "tkmaxx.com": { j: "6" },
  "alpin-chalets.com": { j: "5" },
  "morningstar.fr": {
    s: ".audienceTypeConfirmPopupContentCss,#dialog-mask{display:none !important}",
  },
  "siemens.co.uk": { s: "#c-info,.cm-banner{display:none !important}" },
  "medischcontact.nl": { s: ".cc-popup{display:none !important}" },
  "fimfiction.net": { j: "5" },
  "nos.io": { s: 'div[class*="gdprBanner"]{display:none !important}' },
  "builds.gg": { c: 4 },
  "lot.com": { c: 0 },
  "bakken.nl": { j: "5" },
  "lawine.at": { s: ".header-notification{display:none !important}" },
  "ipax.at": { s: "#ipaxCC{display:none !important}" },
  "acehighradio.com": {
    s: ".widget-footer section > div:not([class]){display:none !important}",
  },
  "grandswissbangkok.com": { s: ".footer-fix-popup{display:none !important}" },
  "kafeteria.pl": { j: "5" },
  "ritzau.dk": { s: ".footer__notification{display:none !important}" },
  "utlandssvenskar.com": { s: "#my-welcome-message{display:none !important}" },
  "fotosik.pl": {
    s: "#rodo-info{display:none !important}",
    c: 14,
  },
  "grand-seiko.com": { s: ".blk-Cookie{display:none !important}" },
  "designwebkit.com": { s: ".cookie_block{display:none !important}" },
  "apidura.com": { s: "#hiddenCookie{display:none !important}" },
  "arcolresistors.com": { s: "#close-me{display:none !important}" },
  "extreme-d0wn.net": { s: "#a-cn-wrapper{display:none !important}" },
  "worditout.com": { s: "body > #g{display:none !important}" },
  "thread.com": { s: "thread-cookie-notice{display:none !important}" },
  "dobreprogramy.pl": { j: "5" },
  "thelily.com": { j: "5" },
  "mapsofworld.com": { s: "#dialog{display:none !important}" },
  "nowness.com": { s: ".ns-info-bar{display:none !important}" },
  "swiftkey.com": { s: ".alert-banner{display:none !important}" },
  "quizme.pl": { j: "5" },
  "o2family.cz": { s: "#o2fCookieConsentDialog{display:none !important}" },
  "super.ee": { s: ".header__notice{display:none !important}" },
  "capitalone.ca": { s: "#alert-privacy-update{display:none !important}" },
  "eutelsat.com": { s: "#header_higher{display:none !important}" },
  "cylance.com": { s: ".cylance-mod-cookiebanner{display:none !important}" },
  "webd.pl": { s: "#cffc{display:none !important}" },
  "hs-kl.de": { c: 75 },
  "ntbinfo.no": { s: ".footer__notification{display:none !important}" },
  "leech360.com": { s: "#cookie-required{display:none !important}" },
  "wsis.pt": { s: "#termosdiv{display:none !important}" },
  "cdkeys.com": { s: "#cookieCDkeys{display:none !important}" },
  "tor.com": { s: "#entry-content__footer-popup{display:none !important}" },
  "booking-channel.com": {
    s: '#sta-cookies ~ div[class*="tpl-cookies"]{display:none !important}',
  },
  "instituteforgovernment.org.uk": {
    s: ".popup-text{display:none !important}",
  },
  "ninkasi.fr": { s: ".nq-c-rgpdBar{display:none !important}" },
  "ukmotorists.com": { s: ".csent{display:none !important}" },
  "k-mag.pl": { j: "5" },
  "tetley.fr": {
    s: ".topFix{display:none !important}#PublicWrapper{margin-top:0 !important}",
  },
  "pagellapolitica.it": { c: 10 },
  "2fast4buds.com": { s: ".popup_secure{display:none !important}" },
  "pacman.io": { s: "#priv_notice{display:none !important}" },
  "spartagym.hr": {
    s: ".floatton-btn,.floatton-container{display:none !important}",
  },
  "fotoblogia.pl": { j: "5" },
  "epom.com": { c: 1 },
  "jazzradio.com": { s: "#terms-message-region{display:none !important}" },
  "gea-waldviertler.at": { c: 10 },
  "campana-schott.com": { s: "#cookie-copy{display:none !important}" },
  "nieuwspoort.nl": { j: "5" },
  "sumup.de": { s: '.su-footer ~ div[class*="css"]{display:none !important}' },
  "htmlcolorcodes.com": { s: "#js-alert{display:none !important}" },
  "flybe.com": { j: "5" },
  "spd-einbeck.de": { s: ".spd-cookie{display:none !important}" },
  "chinesenewyear.net": { s: ".js-alert{display:none !important}" },
  "gqitalia.it": {
    s: '.app > div[class^="FadeWrap"]{display:none !important}',
  },
  "bustle.com": {
    s: 'body > div > header ~ div[class*=" "]{display:none !important}',
  },
  "antenna.gr": { c: 4 },
  "rwjf.org": { s: ".masthead__message{display:none !important}" },
  "staatsschauspiel-dresden.de": {
    s: ".dataprotection{display:none !important}",
  },
  "sexvideoall.com": { s: ".fixed-nav-bar{display:none !important}" },
  "marklogic.com": { s: "#marklogic-eucl-notice{display:none !important}" },
  "sklepkoszykarza.pl": { c: 1 },
  "bitdefender.ru": { s: ".mtsnb-top{display:none !important}" },
  "buzz.ie": { j: "5" },
  "mopolis.de": { c: 4 },
  "qantas.com": { s: "#bottomAlert{display:none !important}" },
  "rjwatches.com": { j: "5" },
  "cortefiel.com": {
    s: "#general-popup,.euCookiesPolicy{display:none !important}",
  },
  "wizbii.com": { s: 'aside[class*="gdpr_banner"]{display:none !important}' },
  "contractix.de": { j: "5" },
  "moontracks.com": { s: "#dropinboxv2cover{display:none !important}" },
  "startsmarthome.de": { j: "5" },
  "investintech.com": { s: "#geoPolicy{display:none !important}" },
  "nationalbooktokens.com": {
    s: 'div[id*="UpdatePanelCookie"]{display:none !important}',
  },
  "expertoanimal.com": { c: 4 },
  "citusdata.com": { s: "#consentBox{display:none !important}" },
  "hech.be": { j: "5" },
  "pekao.com.pl": { j: "6" },
  "alfred.com": { s: ".privacy-policy.content{display:none !important}" },
  "protegerse.com": { c: 33 },
  "ontinet.com": { c: 33 },
  "dafmuseum.nl": {
    s: ".page-overlay{display:none !important}",
    c: 14,
  },
  "rpguides.de": { s: "#pitchblack{display:none !important}" },
  "geotrust.com": { c: 139 },
  "mindennapkonyv.hu": {
    s: '#wrapper > div[style*="fixed"]{display:none !important}',
  },
  "zattoo.com": { j: "6" },
  "houseoftracks.com": { s: ".overflow-container{display:none !important}" },
  "lojasrenner.com.br": { c: 9 },
  "getcomposting.com": { s: "#top-notice{display:none !important}" },
  "skoleporten.dk": { c: 101 },
  "hondanews.eu": { j: "5" },
  "cameo.com": { j: "5" },
  "gr8.com": {
    s: 'div[data-editable="boxCookieNotification"]{display:none !important}',
  },
  "freetorrent.tk": { s: "#alert_system_notice{display:none !important}" },
  "nederpix.nl": { j: "5" },
  "birdpix.nl": { j: "5" },
  "gebuhrenfrei.com": { s: ".cc_wrapper{display:none !important}" },
  "allelectronics.com": { j: "5" },
  "kickresume.com": {
    s: 'div[class*="CookieConsentBanner"]{display:none !important}',
  },
  "purehelp.no": {
    s: "#consent_popup{display:none !important}",
    c: 14,
  },
  "l2db.info": { s: ".access-cookies{display:none !important}" },
  "hetzner.com": { j: "6" },
  "evengreener.com": { s: "#top-notice{display:none !important}" },
  "flyingflowers.co.uk": { s: ".overlayTxtDiv{display:none !important}" },
  "dclaw.co.uk": { j: "5" },
  "voguebusiness.com": {
    s: '.app > div[class*="FadeWrap"]{display:none !important}',
  },
  "jcacinemes.com": { s: "body > .overlay{display:none !important}" },
  "kicks.fi": {
    s: '#container > div > div > div > div > div[style*="opacity"][style*="height"]{display:none !important}',
  },
  "eatbu.com": {
    s: '.mod-cookie-consent{display:none !important}body[style*="padding"]{padding:0 !important}',
  },
  "tapatalk.com": {
    s: ".slideout-panel > #pp_b,#gdpr_b{display:none !important}",
  },
  "ferragamo.com": { s: ".cc-customdialog{display:none !important}" },
  "zorgdirect.nl": { j: "5" },
  "ing.nl": { j: "6" },
  "bosch-mobility-solutions.com": { j: "5" },
  "tidal.com": {
    s: 'div[data-test="GDPRNotification"]{display:none !important}',
  },
  "studio-eight.com": { j: "5" },
  "grodkow.pl": { s: "#jbar-push,#jbar{display:none !important}" },
  "salidzini.lv": { s: "#consent-box{display:none !important}" },
  "ryzerobotics.com": {
    s: 'footer > div[class*="pop-up"]{display:none !important}',
  },
  "tayyar.org": { s: "#popUpModelID{display:none !important}" },
  "tenzingtravel.nl": {
    s: ".fancybox-overlay,.fancybox-wrap{display:none !important}",
  },
  "alexamaster.net": { c: 75 },
  "babylonhealth.com": {
    s: ".web-app__GlobalAlert__globalAlert{display:none !important}",
  },
  "tmdn.org": { j: "5" },
  "prevision.io": { s: "#legal-banner{display:none !important}" },
  "rituals.com": { j: "5" },
  "zlm.nl": { j: "5" },
  "mmogames.com": { s: ".mmogames_cookie_modal{display:none !important}" },
  "pd-f.de": { s: "#matomo_info{display:none !important}" },
  "gosh.no": { j: "5" },
  "filmfront.no": { s: ".pvern{display:none !important}" },
  "bokadirekt.se": { j: "5" },
  "321auto.com": { c: 0 },
  "appzio.com": { s: ".modal-mask-class{display:none !important}" },
  "skionline.pl": { s: "#popup_rodo,#popup_tlo{display:none !important}" },
  "iotransfer.net": { s: ".fl-accept{display:none !important}" },
  "guitartabs.cc": { s: "#main_content ~ div{display:none !important}" },
  "dictionnaire-academie.fr": { s: "#blocCookies{display:none !important}" },
  "china-certification.com": {
    s: ".blueline-content-popup{display:none !important}",
  },
  "apprrr.hr": { s: ".dialog-widget{display:none !important}" },
  "hrblock.com": { j: "5" },
  "jomy.com": {
    s: "#jomy-header-dialog-cookie-consent{display:none !important}",
  },
  "mz.gov.pl": { s: ".popup-bg{display:none !important}" },
  "n11.com": { s: ".warningAlert{display:none !important}" },
  "wso2.com": { s: ".cGDPR{display:none !important}" },
  "mallorca312.com": { c: 0 },
  "boticas23.com": { c: 0 },
  "crex24.com": { s: 'div[class*="cookies_block"]{display:none !important}' },
  "taskmanagement24.com": { s: "#cookiesBlock{display:none !important}" },
  "thezoereport.com": {
    s: 'body > div > div[class*=" "]{display:none !important}',
  },
  "jumbo.com": { s: ".jum-cookie-message{display:none !important}" },
  "labvolution.de": { c: 92 },
  "nfs.as": { c: 15 },
  "szybko.pl": { c: 15 },
  "lafrancaise-am-partenaires.com": { c: 15 },
  "guess.eu": { c: 15 },
  "familycarebadanti.it": { c: 15 },
  "lostintheusa.fr": { c: 15 },
  "startnext.com": { c: 15 },
  "domeble.com": { c: 15 },
  "ilovepdf.com": { c: 15 },
  "nautic-way.com": { c: 15 },
  "mygon.com": { c: 15 },
  "toradex.com": { c: 15 },
  "iloveimg.com": { c: 15 },
  "mimanchitu.it": { c: 15 },
  "broadnet.no": { c: 15 },
  "kundalini.it": { c: 15 },
  "szybkopraca.pl": { c: 15 },
  "homenet.no": { c: 15 },
  "tellshell.shell.com": { c: 15 },
  "sotec-consulting.com": { c: 24 },
  "stodola.pl": { c: 24 },
  "wakelet.com": { j: "5" },
  "r-studio.com": { s: "#pp-info{display:none !important}" },
  "cheapsslsecurity.com": { s: ".popuphome{display:none !important}" },
  "notariat-schoeffmann.at": { c: 1 },
  "wallpaperup.com": { j: "6" },
  "nimbusweb.me": { s: ".ncp1-message{display:none !important}" },
  "brieffreund-gesucht.de": { c: 16 },
  "vouchers.dailyselect.co.uk": { c: 16 },
  "e-codepromo.fr": { c: 16 },
  "emezeta.com": { c: 16 },
  "explicite.info": { c: 16 },
  "domuswire.com": { c: 16 },
  "mieszko.pl": { c: 16 },
  "spectrumled.pl": { c: 16 },
  "portal.dsv.com": { c: 16 },
  "boxtal.com": { c: 16 },
  "karmy.com.pl": { c: 16 },
  "prevac.eu": { c: 16 },
  "bmjv.de": { c: 16 },
  "antyweb.pl": { j: "6" },
  "intact-batterien.de": { s: ".notes{display:none !important}" },
  "atticadps.gr": { c: 0 },
  "learnosm.org": { s: "#optout-form{display:none !important}" },
  "lexika.hu": { c: 0 },
  "trucoswindows.com": { s: ".modalCookies{display:none !important}" },
  "fmstream.org": { c: 106 },
  "pepperworldhotshop.com": {
    s: "#OM-popups-container{display:none !important}",
  },
  "mon-horoscope-du-jour.com": { s: "#rgpd{display:none !important}" },
  "archief.amsterdam": { j: "6" },
  "blanco-germany.com": { s: ".privacyTop{display:none !important}" },
  "smtvsanmarino.sm": { s: ".privacy-top{display:none !important}" },
  "fidelidade.pt": { c: 0 },
  "plume.com": { s: '#root > div[class*="GDPR"]{display:none !important}' },
  "versobooks.com": { c: 21 },
  "giz.berlin": { j: "5" },
  "sadzawka.pl": { c: 0 },
  "jemogfix.dk": { c: 0 },
  "lawebdelprogramador.com": { c: 0 },
  "m4sport.hu": { c: 0 },
  "naturo.pl": { c: 0 },
  "nimbus-lighting.com": { c: 0 },
  "supernet.hr": { c: 0 },
  "wypad.com.pl": { c: 0 },
  "sklep.zielonyfront.pl": { c: 0 },
  "yesgolive.com": { c: 9 },
  "megawrzuta.pl": {
    s: ".slickModal.isActive,.notification{display:none !important}",
  },
  "zaplo.dk": { c: 9 },
  "supremecard.se": { c: 9 },
  "electan.com": { c: 9 },
  "denic.de": { c: 9 },
  "agendapompierului.ro": { c: 9 },
  "pelit.fi": { c: 9 },
  "puregym.com": { c: 9 },
  "mymicroinvest.com": { c: 9 },
  "brandalley.co.uk": { c: 9 },
  "der-audio-verlag.de": { c: 9 },
  "altaprofits.com": { c: 9 },
  "aujourdhui.com": { c: 9 },
  "checkpoint.com": { c: 9 },
  "cm.be": { s: ".new-notification{display:none !important}" },
  "bk.com": { j: "5" },
  "gla.ac.uk": { s: "#consent,#editconsent{display:none !important}" },
  "eyeonspain.com": { c: 107 },
  "dsm.com": { c: 107 },
  "1mot.net": { c: 107 },
  "bytom.com.pl": { s: "byt-cookie-law-info{display:none !important}" },
  "qsrinternational.com": { c: 3 },
  "cypruspolicenews.com": { c: 65 },
  "lyricstraining.com": { j: "5" },
  "infotrafic.com": { s: "app-snack-bar{display:none !important}" },
  "wallpaperdirect.com": {
    s: "footer ~ .fixed-bottom{display:none !important}",
  },
  "anzdoc.com": { s: "#ANZDOCCOM_cookie_box{display:none !important}" },
  "shootingtimes.com": { j: "5" },
  "gunsandammo.com": { j: "5" },
  "wikieventi.it": { s: "#corpo > div:not([id]){display:none !important}" },
  "pizzacasa.hu": { c: 0 },
  "vacancesbleues.fr": { s: ".vb-cnil--banner{display:none !important}" },
  "revenue.ie": { s: ".darker{display:none !important}" },
  "drupal.org": { s: "#drupalorg-crosssite-gdpr{display:none !important}" },
  "gosu.ai": { s: "gosu-notification{display:none !important}" },
  "coinsquare.com": { s: "#body ~ div{display:none !important}" },
  "mapy.geoportal.gov.pl": { j: "5" },
  "starmoney.de": { s: ".footer-banner-wrap{display:none !important}" },
  "prudential.co.za": {
    s: ".investor-type-box .cookie-policy-text{display:none !important}",
  },
  "bravotv.com": { c: 3 },
  "portalspozywczy.pl": { j: "5" },
  "marseille.fr": {
    s: '#app > div > div[style*="fixed"] > div > div[role="alertdialog"]{display:none !important}',
  },
  "mallorca-wandern-trekking.com": { s: "#iwcookies{display:none !important}" },
  "kuebler-hallenheizungen.de": { s: "#consent_info{display:none !important}" },
  "ruhrbarone.de": { c: 0 },
  "brfares.com": { c: 4 },
  "ituudised.ee": { c: 138 },
  "add0n.com": { c: 0 },
  "mayflower.org.uk": { s: ".bottomBanner{display:none !important}" },
  "transparency.org": { s: ".mk-c-modal{display:none !important}" },
  "printn1.ru": { s: "#info-bott-message{display:none !important}" },
  "hautesavoiexperience.fr": { s: "#globalWarning{display:none !important}" },
  "mckp.uj.edu.pl": { s: "#cookie_filter{display:none !important}" },
  "kiddle.co": { j: "5" },
  "programyzadarmo.net.pl": { s: ".notice--primary{display:none !important}" },
  "qpony.pl": { s: ".rodo-wrapper{display:none !important}" },
  "sklep.polberis.pl": { c: 0 },
  "miliboo.ch": { s: ".m-milibooCookie{display:none !important}" },
  "westjet.com": { s: ".wj-header-usercookies{display:none !important}" },
  "projects.newforma.com": { c: 21 },
  "winstar.com.tw": { s: ".cookie-sec{display:none !important}" },
  "homebrewing.pl": { s: ".rodo-popupbox{display:none !important}" },
  "pilz.com": { c: 0 },
  "patchstorage.com": { c: 143 },
  "jastrzebieonline.pl": { s: "#rodo_popup{display:none !important}" },
  "aerobilet.ru": { s: "#dialog.is-fixed-box{display:none !important}" },
  "synerghetic.net": { s: ".tracking-modal{display:none !important}" },
  "livrariaalfarrabista.com": { c: 33 },
  "eb2b.com.pl": {
    s: "#footer ~ .x-css-shadow,#footer ~ .x-window{display:none !important}",
  },
  "freebooksummary.com": { c: 80 },
  "motocms.com": { s: ".cookie_block{display:none !important}" },
  "snowmagazine.com": { s: "#mixcookies{display:none !important}" },
  "ivi.tv": { s: ".lowest-teaser{display:none !important}" },
  "aze.com.pl": { c: 0 },
  "zorg-en-ict.nl": { j: "5" },
  "mircscripts.net": { s: "#corner{display:none !important}" },
  "planner5d.com": { c: 59 },
  "netology.ru": {
    s: '#app > div > div[class*="cookies"]{display:none !important}',
  },
  "md5hashing.net": { s: ".pp-footer{display:none !important}" },
  "lucasentertainment.com": { c: 9 },
  "naklejkomania.eu": { s: "#tlo_cookie{display:none !important}" },
  "technoarena.bg": { s: ".bottom-freezed-bar{display:none !important}" },
  "flanco.ro": { s: "#cc-wrapper{display:none !important}" },
  "bogijn.nl": { s: "#cc-wrapper{display:none !important}" },
  "sfr.re": { s: "body > .cc{display:none !important}" },
  "cryptohopper.com": { s: ".notifyjs-consent-base{display:none !important}" },
  "decalgirl.com": { s: ".cookieBubble{display:none !important}" },
  "preferred411.com": { s: ".toasterCookie{display:none !important}" },
  "idw-online.de": { s: "#idwcookie{display:none !important}" },
  "aktionen.payback.de": { c: 9 },
  "vizrt.com": {
    s: 'div[data-module="CookieBanner"]{display:none !important}',
  },
  "badtaste.it": { s: ".premium-float-footer{display:none !important}" },
  "weblium.com": { s: ".weblium-notify{display:none !important}" },
  "taboola.com": { s: "#tbp-consent{display:none !important}" },
  "bauder.de": { j: "5" },
  "hs-wismar.de": { s: ".hswBannerOverlay{display:none !important}" },
  "mousqueton.eu": { s: "cookie{display:none !important}" },
  "hanos.be": { j: "5" },
  "dinstation.dk": {
    s: '#root > div > div > div[style*="fixed"]{display:none !important}',
  },
  "hitachiaircon.pl": { c: 39 },
  "webmail.unity-mail.de": { c: 3 },
  "ipgphotonics.com": { s: ".alert-box{display:none !important}" },
  "worldbookday.com": { s: ".section--alert-panel{display:none !important}" },
  "surplus-lemarsouin.com": { j: "5" },
  "oetztaler-radmarathon.com": {
    s: 'div[class*="CookieAlert"]{display:none !important}',
  },
  "esea.net": { j: "6" },
  "ridikul.hu": { c: 0 },
  "plugshare.com": { c: 0 },
  "hollandse-hoogte.nl": { s: "#ctr-cookies{display:none !important}" },
  "slatersplastikard.com": { c: 0 },
  "tgp.com.ph": { s: ".section__consent{display:none !important}" },
  "reimmaschine.de": { c: 0 },
  "clo3d.com": { c: 21 },
  "hankook-promotion.de": { s: "#privacy_layer{display:none !important}" },
  "ostrzegamy.online": { j: "5" },
  "cheeca.com": { s: "#hebs-consent{display:none !important}" },
  "teramind.co": { s: "#teramind_cookies_message{display:none !important}" },
  "gn-online.de": { s: "#gn_maxlayer{display:none !important}" },
  "mustangandfords.com": {
    s: "#mod-banned-users-popup{display:none !important}body{overflow:visible !important}",
  },
  "thetranet.fr": {
    s: ".TelerikModalOverlay,#RadWindowWrapper_ctl00_CPH1_RdWRgpd{display:none !important}",
  },
  "atlasruraldegrancanaria.com": { c: 0 },
  "spacebrowser.io": { s: "#overlay-wrapper{display:none !important}" },
  "regio15.nl": {
    s: 'body > div[class*="app"] > div[class*="popup"]{display:none !important}',
  },
  "worldarchitecture.org": { j: "5" },
  "azartgaming6u.com": { s: ".sidebar-cookie{display:none !important}" },
  "bcc.nl": { j: "5" },
  "wufoo.com": { s: "#wufoo-privacy-banner{display:none !important}" },
  "enviolo.com": {
    s: "#app > div > main ~ div:not([data-reactid]){display:none !important}",
  },
  "fanlink.to": { s: ".link-terms{display:none !important}" },
  "pz.gov.pl": { s: "#gdprPopup{display:none !important}" },
  "cebit.com.pl": { c: 0 },
  "pna.ro": { s: ".ui-sidebar.ui-widget{display:none !important}" },
  "sensorsmag.com": { s: 'body > div[id*="pronto"]{display:none !important}' },
  "icims.com": { s: "#multy-lang-betanotifier{display:none !important}" },
  "przypinka.pl": { c: 0 },
  "cfd.dk": { s: "#cn_footerSlideContainer{display:none !important}" },
  "nomenclator.org": { s: "#barrack{display:none !important}" },
  "allegorithmic.com": {
    s: "#root > div > div > .ui.container > .ui.inverted.segment{display:none !important}",
  },
  "meteored.com.ar": { c: 3 },
  "ilmeteo.net": { c: 3 },
  "tempo.pt": { c: 3 },
  "antena3.ro": { c: 3 },
  "quag.com": { c: 3 },
  "meteored.pe": { c: 3 },
  "yourweather.co.uk": { c: 3 },
  "klei.com": { c: 3 },
  "bit-tech.net": { c: 3 },
  "litscape.com": { c: 3 },
  "amazeta.com": { c: 3 },
  "filmnow.ro": { c: 3 },
  "internetspeedtracker.com": { c: 3 },
  "branah.com": { c: 3 },
  "boredbutton.com": { c: 3 },
  "datalounge.com": { c: 3 },
  "meteored.mx": { c: 3 },
  "kleientertainment.com": { c: 3 },
  "t2informatik.de": { s: "#sidebar-divibar{display:none !important}" },
  "quirion.de": { c: 10 },
  "tierisch-wohnen.de": { s: ".m-cc{display:none !important}" },
  "idopontfoglalo.kh.gov.hu": { c: 0 },
  "finect.com": { s: 'div[class*="CookiesPartials"]{display:none !important}' },
  "datasystem.ru": { s: ".specialAlert{display:none !important}" },
  "cmore.se": { j: "6" },
  "iceland.co.uk": { s: ".policy-dialog{display:none !important}" },
  "karum.pl": { c: 0 },
  "tunnelbear.com": { s: ".banner-wrap{display:none !important}" },
  "tygodniksiedlecki.com": { s: ".rodo-bg{display:none !important}" },
  "private.com": { c: 0 },
  "siemoneit-racing.de": { s: "#getnoticeData{display:none !important}" },
  "moneymaven.io": { s: ".consent-ui{display:none !important}" },
  "3t.no": { c: 9 },
  "means.media": { s: 'section[class*="Gdpr"]{display:none !important}' },
  "lrt.lt": { s: ".consent-block{display:none !important}" },
  "herdt-campus.de": {
    s: "body > .container-fluid.bg-white > .container{display:none !important}",
  },
  "omnimoto.it": { c: 102 },
  "superelectronic2000.ro": {
    s: "#lbMain,#lbOverlay{display:none !important}",
  },
  "mobiquity.amsterdam": {
    s: 'div[class*="CookieWarning"]{display:none !important}',
  },
  "zamowienia.gov.pl": {
    s: "#footer ~ .x-css-shadow,#footer ~ .x-window{display:none !important}",
  },
  "unisa.edu.au": { s: ".__gdpr-container{display:none !important}" },
  "gruenderservice.at": { j: "5" },
  "gamesaver.pl": { c: 0 },
  "tymit.co.uk": { s: ".main_cookie_view{display:none !important}" },
  "flinkscykel.se": { c: 9 },
  "lrytas.lt": {
    s: '#lrytas-fe-root > div[class*="root"]{display:none !important}',
  },
  "thewirecutter.com": { j: "5" },
  "detecon.com": { s: 'div[class*="CookieNote"]{display:none !important}' },
  "wealthx.com": { s: "#wx-gdpr-message-box{display:none !important}" },
  "hypovbg.at": { s: ".hlv-cookie{display:none !important}" },
  "forin.gr": { s: ".cc-dialog{display:none !important}" },
  "zemskidki.ru": { j: "5" },
  "tuz.pl": { s: "#for-cookies-container{display:none !important}" },
  "thriveglobal.com": {
    s: 'div[class*="notificationBar"]{display:none !important}',
  },
  "sauber-waldpreis.de": { c: 10 },
  "mesosphere.com": { s: ".banner-alert{display:none !important}" },
  "iota.org": { s: "#__next > main > div:not(.page){display:none !important}" },
  "audi.co.uk": { j: "5" },
  "rideshimano.com": { c: 37 },
  "choosist.com": { j: "6" },
  "schweinfurt.de": { s: "#chint{display:none !important}" },
  "watchadvisor.com": { j: "5" },
  "camh.ca": { s: ".alert-container{display:none !important}" },
  "liberal-international.org": {
    s: ".footer-message{display:none !important}",
  },
  "cubbit.io": { s: 'div[class*="StyledCookie"]{display:none !important}' },
  "eanuncios.com": { s: ".ue-accept-bg{display:none !important}" },
  "getgrover.com": { s: ".snackbar-enter-done{display:none !important}" },
  "grover.com": { s: ".snackbar-enter-done{display:none !important}" },
  "deas.dk": { c: 0 },
  "mtglotusvalley.com": { j: "5" },
  "ip-info.org": { s: "#divbottom01{display:none !important}" },
  "noventis.cz": { s: 'body > div[id*="object"]{display:none !important}' },
  "elements-show.pl": { s: "#popup_container{display:none !important}" },
  "51degrees.com": { s: "#pop-wrapper{display:none !important}" },
  "jpost.com": {
    s: 'body > div[class*="ADORIC"] > div[style*="111"]{display:none !important}',
  },
  "apracas.pt": { c: 1 },
  "ccs.utc.com": { c: 0 },
  "powietrze.katowice.wios.gov.pl": { s: ".a-footer{display:none !important}" },
  "depo-diy.lt": { s: ".depo-cookies{display:none !important}" },
  "nettbuss.se": { s: ".header__banner{display:none !important}" },
  "florsheim.eu": { s: ".cookiesMask{display:none !important}" },
  "canyon.com": { j: "5" },
  "talparadio.nl": { j: "5" },
  "which.co.uk": {
    s: 'body > div[data-which-id="eprivacy-banner"]{display:none !important}',
  },
  "fssprus.ru": { s: ".user-data-fixed{display:none !important}" },
  "marathonfitness.de": { s: ".wpfront-fixed{display:none !important}" },
  "toyota-media.de": { s: "#footer-box{display:none !important}" },
  "rimowa.com": {
    s: '.b-modal,.b-modal ~ div[class*="privacy"]{display:none !important}',
  },
  "jigsawplanet.com": { s: ".ts-msg{display:none !important}" },
  "sapphiretech.com": {
    s: 'div[data-component-class*="GdprWidget"]{display:none !important}',
  },
  "otodom.pl": { c: 28 },
  "aeroport.fr": { s: "#cookiesfr{display:none !important}" },
  "komorkomania.pl": { j: "5" },
  "geoportal-bw.de": { s: "#gdibw-cookie{display:none !important}" },
  "autoscuolacatelli.it": { s: "#d_cook{display:none !important}" },
  "bigbigchannel.com.hk": { j: "5" },
  "scubaland.fr": {
    s: 'body > div[class^="cookies"]{display:none !important}',
  },
  "icl-group.de": { s: "#drkf5_overlay{display:none !important}" },
  "somatex.com": { s: ".notification-system{display:none !important}" },
  "kranten.com": { s: "#whatever{display:none !important}" },
  "lifeworks.com": {
    s: 'div[class*="cookie-law-module"]{display:none !important}',
  },
  "asap-gmbh.de": { c: 0 },
  "zev-energie.de": { s: "#bauch-binder{display:none !important}" },
  "neoness.fr": { c: 0 },
  "rockstarenergy.com": { c: 8 },
  "mp4bolt.hu": { s: "body > .ct{display:none !important}" },
  "ps.be": { j: "5" },
  "madison.nl": { s: ".avg-toaster{display:none !important}" },
  "trachten.de": {
    s: '.page-wrap > div[class*="cookie"]{display:none !important}',
  },
  "man-es.com": { c: 106 },
  "soesterberg.nu": { j: "5" },
  "internationale-computerspielesammlung.de": {
    s: ".mod_lafli_notification_bar{display:none !important}",
  },
  "yousee.dk": {
    s: '.app > div[data-radium] > div[data-radium][style*="fixed"]{display:none !important}',
  },
  "go4convert.com": { c: 8 },
  "ghostlyhaks.com": { c: 48 },
  "anyfin.com": {
    s: 'div[class*="CookieDisclaimer"]{display:none !important}',
  },
  "artscolumbia.org": { c: 80 },
  "erste-hilfe-fuer-kinder.de": { s: ".txBsdCookie{display:none !important}" },
  "fluidui.com": { j: "5" },
  "fotowien.at": { j: "5" },
  "usefyi.com": { j: "5" },
  "klugo.de": { s: 'div[class*="CookieHint"]{display:none !important}' },
  "billigflieger.de": { s: "#Notifications{display:none !important}" },
  "viennaticketoffice.com": { c: 133 },
  "gewinnspiele-markt.de": { c: 81 },
  "happy-spots.de": { c: 81 },
  "ezys.lt": { j: "6" },
  "devon.gov.uk": { c: 0 },
  "sdamgia.ru": { s: 'body > div[style*="silver"]{display:none !important}' },
  "axway.com": { s: 'div[id*="cookiePolicyWarning"]{display:none !important}' },
  "questdiagnostics.com": {
    s: "#bodycontent > table{display:none !important}",
  },
  "athenesaccueil.com": { c: 1 },
  "subzero-wolf.com": { s: ".footer-announcement{display:none !important}" },
  "soakandsleep.com": { s: "#wagento-cp-wrap{display:none !important}" },
  "reimageplus.com": { j: "6" },
  "saxion.edu": { j: "5" },
  "patient.info": { j: "5" },
  "atlants.lv": { s: ".atlants_cook_wrapper{display:none !important}" },
  "mcvities.co.uk": { c: 0 },
  "bca.uk.com": { c: 0 },
  "shueisha.co.jp": {
    s: '#app > div > div[class*="styles"] > div[class*="yellow"],#app > div > div[class*="styles"] > div[class*="yellow"] ~ *{display:none !important}',
  },
  "kalenderwoche.de": { j: "6" },
  "msasafety.com": { s: ".region-alert-wrapper{display:none !important}" },
  "royalora.hu": { s: "#cc-holder{display:none !important}" },
  "milanoo.com": { s: "#remember_cookie{display:none !important}" },
  "apacer.com": { s: "#cookie_lightbox{display:none !important}" },
  "linfodurable.fr": { c: 0 },
  "lejournaldesarts.fr": { c: 0 },
  "any.run": { c: 0 },
  "vifa-recht.de": { s: "#tracking-info{display:none !important}" },
  "staatsbibliothek-berlin.de": {
    s: "#tracking-info{display:none !important}",
  },
  "kotimikro.fi": { s: ".afubar-top{display:none !important}" },
  "treated.com": { s: "#gdprTreated{display:none !important}" },
  "blog.bankinter.com": { c: 0 },
  "gizmodo.com": { s: "#privacypolicy .privacy-box{display:none !important}" },
  "falriver.co.uk": { c: 3 },
  "immo24.direct": {
    s: ".uk-first-column > .uk-text-center ~ .uk-panel{display:none !important}",
  },
  "radarvirtuel.com": { c: 23 },
  "bankhapoalim.co.il": { s: ".cookieClass{display:none !important}" },
  "manufaktur-bavaria.de": { c: 8 },
  "prestigeelectriccar.com": { s: "#acept_todo{display:none !important}" },
  "poolia.se": { j: "6" },
  "esn-tt.de": { s: "#CookieInformations{display:none !important}" },
  "iobit.com": { s: ".float-bar.active{display:none !important}" },
  "boomlibrary.com": { j: "5" },
  "suncorp.com.au": {
    s: ".sg-Box--neutral.one-pixel-margin-bottom{display:none !important}",
  },
  "ca-mobile.com": { s: "#bannerDiv{display:none !important}" },
  "azoresgetaways.com": { j: "5" },
  "researchgate.net": { j: "6" },
  "bango.com": {
    s: '#__next > div > div > div > div[style*="height"]{display:none !important}',
  },
  "tl.net": { c: 1 },
  "lalena.ro": { s: "#consent-ui{display:none !important}" },
  "optus.com.au": { s: ".ux-header-conformation{display:none !important}" },
  "abv.bg": { s: "#abv-GDPR-frame{display:none !important}" },
  "galeria-kaufhof.de": {
    s: 'react-root[data-component="PRIVACY_SETTINGS"]{display:none !important}',
  },
  "axa-corporatesolutions.com": { j: "5" },
  "collegetimes.com": {
    s: 'body > div[style*="transp"]{display:none !important}',
  },
  "data-modul.com": { s: ".js_consent{display:none !important}" },
  "biogo.pl": { c: 0 },
  "festicket.com": {
    s: '#root > main > div[class*="styles"]{display:none !important}',
  },
  "fitmart.de": {
    s: "#n_pop_overlayer,#n_cookie-popup{display:none !important}",
  },
  "eltim.eu": { c: 4 },
  "luga.ch": { s: "#cookiegdpr{display:none !important}" },
  "buoyant.io": { s: "#apoptin{display:none !important}" },
  "ausschreibungen-deutschland.de": {
    s: "#am_pop-up{display:none !important}",
  },
  "versus.com": { s: 'div[class*="cookiebanner"]{display:none !important}' },
  "poperblocker.com": { s: "body > .dialog-widget{display:none !important}" },
  "lasillavacia.com": { s: ".cuadro{display:none !important}" },
  "ericom.com": { c: 0 },
  "gutscheinsammler.de": {
    s: ".gs-privacy-policy-widget{display:none !important}",
  },
  "eigene-ip.de": { j: "5" },
  "yithlibrary.com": { c: 10 },
  "teamliquid.com": { c: 12 },
  "buoyhealth.com": {
    s: "#___gatsby #solutions ~ div,#search > section ~ div[class]{display:none !important}",
  },
  "american-historama.org": { c: 145 },
  "moderne-landwirtschaft.de": { j: "5" },
  "westmarine.com": {
    s: ".privacy-disclaimer-wrapper{display:none !important}",
  },
  "tangent.co.uk": { s: 'div[class*="CookieMsg"]{display:none !important}' },
  "realassetmgt.co.uk": { c: 48 },
  "markertek.com": { s: "#Privacy_Popup{display:none !important}" },
  "shore.com": { c: 146 },
  "cindicator.com": { j: "6" },
  "historysearch.com": { s: ".hs-state-left{display:none !important}" },
  "opensport.es": { c: 0 },
  "drjacobs-shop.de": { j: "5" },
  "sqlgate.com": { s: ".popup.download-page{display:none !important}" },
  "zwickautourist.de": { s: "#bauch-binder{display:none !important}" },
  "archimag.com": { j: "5" },
  "insideevs.com": { c: 102 },
  "foramax.hu": { s: "body > .ct,body > .cc{display:none !important}" },
  "coin360.com": { s: ".Popup{display:none !important}" },
  "greentechmedia.com": {
    s: 'body > div[style*="transp"]{display:none !important}',
  },
  "the-beam.com": { c: 26 },
  "hop-on-hop-off-bus.com": { s: ".ckPol{display:none !important}" },
  "topclassactions.com": { c: 108 },
  "renasterea.ro": { s: ".spu-bg,.spu-box{display:none !important}" },
  "informatica.com": { s: ".tms-fixed-footer{display:none !important}" },
  "tixr.com": { j: "5" },
  "bd.com": { c: 10 },
  "petdrugsonline.co.uk": {
    s: "#checkout-loader,.loading-mask{display:none !important}",
  },
  "puydufou.com": { j: "5" },
  "almirall.de": { s: ".popupCookies{display:none !important}" },
  "nationallighting.co.uk": { s: ".nlcookies-bottom{display:none !important}" },
  "alanboswell.com": { s: ".ab_notification{display:none !important}" },
  "bsi-software.com": { s: ".we-love-cookies{display:none !important}" },
  "chatra.io": { s: 'div[id^="yeps"]{display:none !important}' },
  "yeps.io": { s: 'div[id^="yeps"]{display:none !important}' },
  "samsaraubud.com": { s: "#bottom-fixed{display:none !important}" },
  "studymoose.com": { c: 80 },
  "praca.gov.pl": { s: "#klauzula-background{display:none !important}" },
  "betterhelp.com": { j: "6" },
  "cheapoair.com": { s: "#gdprWrap{display:none !important}" },
  "kokoroe.fr": { j: "5" },
  "dayz.xam.nu": { c: 4 },
  "gbaweather.net": { c: 3 },
  "admagazine.ru": {
    s: ".modal--bottom-right.bg-color-dark{display:none !important}",
  },
  "vitacost.com": { s: "#cookieJar{display:none !important}" },
  "draftium.com": { s: "#cta ~ div,#cta ~ section{display:none !important}" },
  "cesifo-group.de": { s: "#cob{display:none !important}" },
  "badlion.net": {
    s: "#root > .Flex > .__react_component_tooltip ~ .Flex ~ .Block{display:none !important}",
  },
  "pitax.pl": { c: 0 },
  "skoda-auto.com": { s: "#MessageArea{display:none !important}" },
  "moovielive.com": { s: ".sticky_footer{display:none !important}" },
  "otr-max.de": { s: 'body > div[style*="scroll"]{display:none !important}' },
  "dogma-nekretnine.com": { c: 11 },
  "artuk.org": { s: "#top-notice{display:none !important}" },
  "bladi.info": { c: 11 },
  "bauhaus-nl.com": { c: 11 },
  "cgtrader.com": { c: 11 },
  "dublininquirer.com": { c: 11 },
  "exposition-osiris.com": { c: 11 },
  "boundingbox.klokantech.com": { c: 11 },
  "motorvision.tv": { c: 11 },
  "outsideonline.com": { c: 11 },
  "theatrechampselysees.fr": { c: 11 },
  "tassimo.at": { s: "#overlay-off-banner{display:none !important}" },
  "homelyfe.com": {
    s: "#root > div > div > .center-horizontal:not(.undefined){display:none !important}",
  },
  "passbase.com": { c: 20 },
  "milliescookies.com": { s: "privacy-settings{display:none !important}" },
  "gtarcade.com": { s: "#agreement-box{display:none !important}" },
  "tapperuse.nl": { j: "5" },
  "wabtec.com": {
    s: ".forceCommunityVisualforcePage{display:none !important}",
  },
  "startupnamecheck.com": { s: ".snotify-confirm{display:none !important}" },
  "ostsee.de": { c: 0 },
  "naslovi.net": { c: 3 },
  "fideliti.co.uk": { j: "5" },
  "spaste.com": { s: "#resultPolicyDatap{display:none !important}" },
  "dellmont.com": { j: "5" },
  "norbar.com": { c: 9 },
  "alarmanlagen-osnabrueck.de": { s: "#cookieclaim{display:none !important}" },
  "guggenheim.org": { s: ".guggen-consent{display:none !important}" },
  "hrsonline.org": { c: 13 },
  "diconium.com": { s: ".diconium-site-cookie{display:none !important}" },
  "di.fm": { s: "#terms-message-region{display:none !important}" },
  "asix.com.tw": { s: "#PrivacyNotes{display:none !important}" },
  "warehouse2.de": { c: 8 },
  "blueflag.global": { c: 43 },
  "kontaktbazar.at": { j: "6" },
  "hoernews.de": { j: "6" },
  "myswitzerland.com": { s: "#notification_alert{display:none !important}" },
  "ltsh.de": { s: ".mm-page > .header{display:none !important}" },
  "lagenhetsbyte.se": { c: 69 },
  "gelmar.co.za": { j: "5" },
  "lechia.pl": { s: "#rodo-wrapper{display:none !important}" },
  "fotoc.dk": { j: "6" },
  "stopad.io": { s: ".js-gdpr-modal{display:none !important}" },
  "mediaklikk.hu": { s: ".resultCookie{display:none !important}" },
  "talkshop.live": {
    s: '.notifications-wrapper ~ div[style*="black"]{display:none !important}',
  },
  "marcotec-shop.de": { c: 0 },
  "datev-community.de": {
    s: "#datev-cookie-disclaimer{display:none !important}",
  },
  "hagerzplan.de": { j: "5" },
  "strefakierowcy.pl": { c: 68 },
  "riderarmourmoto.com": { s: ".widget-footer{display:none !important}" },
  "klopfers-web.de": { s: "#kwcookieconsent{display:none !important}" },
  "itt.bg": { c: 4 },
  "etsglobal.org": { s: "#ets_popup_cookie_modal{display:none !important}" },
  "bagira.bg": { c: 4 },
  "mein-schauinsland.de": { s: ".popup-top-header{display:none !important}" },
  "swann-morton.com": { s: "#easyNotification{display:none !important}" },
  "brcauto.eu": { s: ".cookies_law{display:none !important}" },
  "arhivanalitika.hr": { c: 0 },
  "boilerguide.co.uk": { s: ".consent-bar{display:none !important}" },
  "atro-provita.de": { j: "6" },
  "cm-fima.com": { c: 0 },
  "polskieradio24.pl": { s: ".rodo-modal{display:none !important}" },
  "fretlink.com": { c: 0 },
  "kuehlschrank.com": { s: ".legalAdvice{display:none !important}" },
  "wisemushroom.org": { s: "#site_notice{display:none !important}" },
  "parc-marais-poitevin.fr": { s: "#aci{display:none !important}" },
  "seasonpros.com": { c: 0 },
  "mortgageafterlife.com": { c: 147 },
  "sklep.wodbud.com.pl": { c: 0 },
  "gezondeideetjes.nl": { j: "5" },
  "runland.cz": { s: "#user-info-banner{display:none !important}" },
  "ipc.be": { j: "5" },
  "ernieball.com": { c: 3 },
  "kombiverkehr.de": { s: "#ntcc{display:none !important}" },
  "unicheck.com": { j: "6" },
  "debex-potsdam.de": { c: 0 },
  "4clik.com": { s: ".kHolder{display:none !important}" },
  "strikermanager.com": { s: "body > #ue{display:none !important}" },
  "mic.com": { s: 'body > div > div[class*=" "]{display:none !important}' },
  "celly.com": {
    s: 'app-footer ~ div[style*="fixed"]{display:none !important}',
  },
  "wellcard.cc": { c: 0 },
  "stadtreiniger.de": { s: ".note{display:none !important}" },
  "gefran.com": { j: "5" },
  "framar.bg": { c: 4 },
  "giraffetongueorchestra.com": { c: 4 },
  "plasico.bg": { c: 4 },
  "bostools.nl": { c: 26 },
  "doctor-telephone.fr": { c: 26 },
  "mp.pl": { c: 26 },
  "safedns.com": { c: 26 },
  "evolutrans.fr": { c: 0 },
  "weforum.org": { j: "5" },
  "fonds-im-fokus.de": { s: ".footer #slider{display:none !important}" },
  "sugarsync.com": { s: "#agreementBar{display:none !important}" },
  "digitale-schule.nrw": {
    s: ".bottom-sheet,.bottom-sheet ~ .modal-overlay{display:none !important}",
  },
  "novema-nova.hr": { c: 0 },
  "instock.nl": { j: "5" },
  "treinenweb.nl": { s: "#cb{display:none !important}" },
  "aia.gr": { j: "5" },
  "finreport.sk": {
    s: 'div[id*="CookieInfoWrapper"]{display:none !important}',
  },
  "tff.se": { s: ".component-cookie{display:none !important}" },
  "agria.se": {
    s: 'body > div > div[class*="Collapse"]{display:none !important}',
  },
  "unideb.hu": { s: "#unideb-gdpr-block{display:none !important}" },
  "reise-zikaden.de": { s: "#ConsentLayerWrapper{display:none !important}" },
  "mathematiques-lycee.com": { c: 1 },
  "racezone.pl": { s: "#sky-cookies{display:none !important}" },
  "handy-games.com": { s: ".bugme{display:none !important}" },
  "cquand.fr": { s: "footer > div{display:none !important}" },
  "onetravel.com": { s: ".gdpr-wraper{display:none !important}" },
  "agenttravel.es": { c: 0 },
  "maps.arcgis.com": { j: "5" },
  "magentatv.at": { c: 78 },
  "zone.msn.com": { s: "#cdmDiv{display:none !important}" },
  "ucsusa.org": { s: "#ucs-cookie-notice{display:none !important}" },
  "limscave.com": { c: 8 },
  "apogeum.com.pl": { c: 0 },
  "textbroker.de": { s: ".tb-cookie{display:none !important}" },
  "tnt-click.it": { j: "5" },
  "welcomemrbaby.com": { j: "5" },
  "bremen.de": {
    s: "body > div.js-vue-app,body > #privacy-popup{display:none !important}",
  },
  "stalderag.ch": { c: 0 },
  "yamahawaverunners.com": {
    s: ".modal--popover.us-popover{display:none !important}",
  },
  "tiger.nl": { j: "5" },
  "gberardi.com": { j: "6" },
  "wirexapp.com": {
    s: "wx-cookie-policy-notification{display:none !important}",
  },
  "electricireland.ie": { s: "#eiCookie{display:none !important}" },
  "ockovacicentrum.cz": { s: "#notificationBox{display:none !important}" },
  "market24hclock.com": { s: "#cookiespp{display:none !important}" },
  "ediclube.com": { c: 0 },
  "vietnamairlines.com": { j: "5" },
  "amnesty.nl": { c: 93 },
  "globelink.co.uk": { s: ".gl_cookies{display:none !important}" },
  "gebag.de": { c: 0 },
  "b12.io": { c: 3 },
  "make-it-in-germany.it": { s: "#nagscreen{display:none !important}" },
  "solidwoodendoors.com": {
    s: "#myModalCookies{display:none !important}",
    c: 14,
  },
  "ausschreibungen-oesterreich.at": {
    s: "#am_pop-up{display:none !important}",
  },
  "osa.org": { s: ".maintenance-popup{display:none !important}" },
  "saevioapps.com": { s: "div[data-cookie-path]{display:none !important}" },
  "choiceandmedication.org": { j: "6" },
  "fiaworldrallycross.com": { j: "6" },
  "michael-martin.de": { s: "#coo_note{display:none !important}" },
  "finanze.it": { s: "#bannerInfo{display:none !important}" },
  "arbetsmarknadsnytt.se": { c: 120 },
  "ornox.fr": { c: 42 },
  "mbc.net": { s: "#DGPR{display:none !important}" },
  "pansci.asia": { j: "6" },
  "swimming.org": { s: ".asa-cookie-notification{display:none !important}" },
  "topsecretrecipes.com": {
    s: ".ui-widget-overlay,.gdpr-terms-popup{display:none !important}",
  },
  "slewo.com": { s: ".cookie_ack{display:none !important}" },
  "cherwellsigns.co.uk": { s: "#cookieOut{display:none !important}" },
  "bmw-hebergement.fr": { s: "#xpr_banner{display:none !important}" },
  "sveip.no": { s: ".kake_wrap{display:none !important}" },
  "gardets.nu": { s: ".cookies-field{display:none !important}" },
  "windows-love.de": {
    s: "#wl-cookie-datenschutz-message{display:none !important}",
  },
  "lactostop.de": { s: "#datencookie{display:none !important}" },
  "kita-chinderschloessli.ch": {
    s: "body > div > div > div[jsname] + div[jsmodel]{display:none !important}",
  },
  "medicines.org.uk": { s: ".privacyouterwrapper{display:none !important}" },
  "gotokyo.org": { s: "#tmp_local_bar{display:none !important}" },
  "accobrands.com": {
    s: ".Promotional-corner,.gdpr--popup{display:none !important}",
  },
  "meineabgeordneten.at": {
    s: '#privatBanner h2 ~ div[style*="center"] ~ *{display:none !important}',
  },
  "infozona.hr": { c: 148 },
  "shoestring.de": { s: "#privacyDisclaimer{display:none !important}" },
  "ritdye.com": {
    s: '.footer ~ div[class*="peach-300"]{display:none !important}',
  },
  "racquetballwarehouse.com": { c: 104 },
  "elegantthemes.com": { s: ".et_cookie_consent{display:none !important}" },
  "kvvks.de": { s: "footer .note{display:none !important}" },
  "subscribercounter.com": {
    s: '#app > div > div[class*="ModalContainer"]{display:none !important}',
  },
  "gewusst-wo.de": { s: "#permission_request_box{display:none !important}" },
  "calciomercato.com": { s: "#gdpr-law{display:none !important}" },
  "globe.com.ph": { c: 47 },
  "refinitiv.com": { s: ".dismissible-banner{display:none !important}" },
  "gazeo.pl": { s: "#rodo_accept,#cookies_all{display:none !important}" },
  "gtalfh.com": { c: 10 },
  "newspaperdirect.com": { s: "#dialog_cookies{display:none !important}" },
  "oferty-dom.pl": { s: "#dspcookie{display:none !important}" },
  "selectel.ru": { s: ".ui-cookies{display:none !important}" },
  "nbcsports.com": {
    s: '#activation-form ~ div[style*="fixed"]{display:none !important}',
  },
  "scentre.pl": { c: 4 },
  "mariobarthtattoo.com": { s: "#POPUPS_WRAPPER{display:none !important}" },
  "veloenfrance.fr": { j: "5" },
  "xn--nringslivnorge-0ib.no": { j: "5" },
  "nextgentel.no": { s: ".blocker{display:none !important}" },
  "parliament.scot": { s: ".projects-takeover{display:none !important}" },
  "flikflak.com": { j: "5" },
  "crello.com": {
    s: 'div[class*="footerNotification"]{display:none !important}',
  },
  "kwantum.nl": { s: ".cc-wrapper{display:none !important}" },
  "carl-walther.de": { s: "#disclaimer-bar{display:none !important}" },
  "salesforce.com": {
    s: '.slds-notify_container,.toast-success,div[class*="GlobalBanner__Wrapper"]{display:none !important}',
  },
  "dwell.com": { j: "6" },
  "rpgrealm.nl": { j: "5" },
  "norma-ammunition.com": { s: ".on-screen-messages{display:none !important}" },
  "pentagon-group.co.uk": { c: 0 },
  "renault-koenig.de": { c: 33 },
  "renaultfinanciacion.es": { j: "5" },
  "dewilgo.de": { c: 48 },
  "allemagne-romantique.fr": { c: 149 },
  "rogerfederer.com": { c: 104 },
  "growthtechnology.com": { s: "#popupbanner{display:none !important}" },
  "f-secure.com": { s: ".fs-consent{display:none !important}" },
  "meurthe-et-moselle.fr": { j: "5" },
  "fwg-vg-linz.de": { c: 143 },
  "smart-digital.at": { s: "#policy-popup{display:none !important}" },
  "e3expo.com": { j: "5" },
  "birchbox.es": { s: 'div[class*="CookieNotice"]{display:none !important}' },
  "akasha.org": {
    s: "#___gatsby > div > div:first-child{display:none !important}",
  },
  "rome2rio.com": { s: "#alert-banner{display:none !important}" },
  "usz.ch": { s: ".consentManagement{display:none !important}" },
  "zbmath.org": { c: 0 },
  "drkehayov.com": { s: ".notice-tou{display:none !important}" },
  "rossmann.de": { s: "#nagme{display:none !important}" },
  "ticketingcine.fr": { s: "#ctCookie{display:none !important}" },
  "saudia.com": { j: "5" },
  "kaffepaussi.fi": { c: 1 },
  "aliciagame.com": {
    s: ".region-inner > #block-system-main ~ .block{display:none !important}",
  },
  "zkl.hr": { c: 0 },
  "fullscreen.com": { s: "body > .banner{display:none !important}" },
  "kube.no": { c: 0 },
  "creative.com": { s: ".ck-notiz{display:none !important}" },
  "improbable.io": {
    s: 'div[class*="CookieBarstyled"]{display:none !important}',
  },
  "binance.je": { j: "5" },
  "weymuller.fr": { s: "#tracker-warning{display:none !important}" },
  "nordkurier.de": { s: "#nk-cookie-consent{display:none !important}" },
  "casadellibro.com": { j: "5" },
  "ezvizlife.com": { s: ".footer ~ .coverShow{display:none !important}" },
  "pepboys.com": { s: "#ccContainer{display:none !important}" },
  "salesmanago.pl": { c: 13 },
  "thermostaat.eu": { s: ".fancybox-overlay{display:none !important}" },
  "ricelake.com": { c: 32 },
  "ncsc.gov.uk": { s: ".pcf-cookie{display:none !important}" },
  "hirado.hu": { j: "5" },
  "sapo.ao": { s: ".bsu-v2-ntfs{display:none !important}" },
  "webwinkel.tubantia.nl": { c: 58 },
  "proteum.co.uk": { c: 0 },
  "saa.nl": { j: "5" },
  "e-scooter.co": { s: "#gdpr-w,#gdpr-o{display:none !important}" },
  "xn--ko-roller-z7a.de": { s: "#gdpr-w,#gdpr-o{display:none !important}" },
  "misterfly.com": { s: "#i-cook{display:none !important}" },
  "mltracker.co.uk": { j: "5" },
  "ibeesoft.com": { c: 0 },
  "typeform.com": { s: 'div[class*="CookieWrapper"]{display:none !important}' },
  "rosewe.com": { s: "#accept_agree{display:none !important}" },
  "arlingtoncemetery.mil": { c: 14 },
  "bighorn.no": { c: 4 },
  "hidive.com": { s: "#siteMsgSlideUpBG{display:none !important}" },
  "voxi.co.uk": {
    s: '#root > div[data-reactroot] > div > div[style*="opacity"]{display:none !important}',
  },
  "biketech24.de": { s: ".cookies_apply{display:none !important}" },
  "spanishunicorn.com": {
    s: '.pum[data-popmake*="cookies"]{display:none !important}',
  },
  "anydesk.com": { s: "#any-cookieBar{display:none !important}" },
  "otpportalok.hu": { j: "5" },
  "radiovlna.sk": { s: ".b-cookies{display:none !important}" },
  "filati.cc": { c: 0 },
  "willitclassic.com": { j: "6" },
  "bienvenue-a-la-ferme.com": { j: "5" },
  "sakharov-center.ru": { s: "#kuk{display:none !important}" },
  "dna.fi": { s: "#dna-gdpr-info{display:none !important}" },
  "wedos.cz": { s: ".dialog-message{display:none !important}" },
  "infovojna.sk": { s: "#gpCookie{display:none !important}" },
  "camelcamelcamel.com": { s: "#cmp-ui-iframe{display:none !important}" },
  "criticker.com": { s: "#i_cookies{display:none !important}" },
  "warka.com.pl": { s: "#rodo_env,.cookies{display:none !important}" },
  "dialight.com": { c: 11 },
  "depo.lv": { s: ".depo-cookies{display:none !important}" },
  "2ask.de": { s: "#cadvise_bar{display:none !important}" },
  "story.tl": { s: 'div[class*="CookieConsent"]{display:none !important}' },
  "rohan.co.uk": { s: "#ccpop{display:none !important}" },
  "gog.com": {
    s: 'body > div[data-editable="boxCookieNotification"]{display:none !important}',
  },
  "lisa.ru": { c: 150 },
  "arte.tv": { j: "5" },
  "a2s.pl": { s: ".cookieForm{display:none !important}" },
  "skanetrafiken.se": { c: 0 },
  "trendsales.dk": {
    s: "#main > .inner ~ div[class]{display:none !important}",
  },
  "speedof.me": {
    s: ".cc-dialog-pane,.cc-window-banner{display:none !important}.body-margin-top{margin-top:0 !important}",
  },
  "thule.com": { j: "5" },
  "olymp.com": { s: ".legal-banner{display:none !important}" },
  "bergstraesserwinzer.de": { s: ".cp-dialog{display:none !important}" },
  "cip.nl": { j: "5" },
  "jm.se": { j: "5" },
  "ovfietsbeschikbaar.nl": { c: 151 },
  "blackvue.com": { s: ".allreadycookie{display:none !important}" },
  "motofaktor.pl": { j: "5" },
  "pactcoffee.com": { j: "5" },
  "kikatek.com": { s: "#Piper-Consent{display:none !important}" },
  "danishfamilysearch.com": { j: "5" },
  "intentmedia.net": { s: ".IM_cb.IM_show{display:none !important}" },
  "motoscout24.ch": { s: "main ~ .global-banner{display:none !important}" },
  "alkam-security.pl": { s: "#spop{display:none !important}" },
  "carbonite.com": { c: 11 },
  "wuestenrot.cz": { j: "5" },
  "cote.co.uk": { s: "#root > div > .fixed{display:none !important}" },
  "opusteno.rs": { s: "#conditions-l{display:none !important}" },
  "erleben-im-alltag.de": { c: 70 },
  "tus-almena.de": { c: 70 },
  "tokuweb.de": { c: 70 },
  "kbaur-gmbh.com": { c: 70 },
  "gestaltamwerk.de": { c: 70 },
  "ajs-bw.de": { c: 70 },
  "medicijnnodig.nu": { j: "5" },
  "hetweeractueel.nl": { c: 14 },
  "achteruitkijkspiegel.nl": { c: 14 },
  "recordplanet.nl": { c: 14 },
  "fdu.org.ua": { s: "#pd_popup{display:none !important}" },
  "telehit.com": { s: ".Privacy.Telehit{display:none !important}" },
  "voetbalnederland.nl": {
    s: 'body > div[style*="border"]{display:none !important}',
  },
  "walmart.ca": { j: "5" },
  "pearlizumi-eu.com": { s: ".cc_notification{display:none !important}" },
  "byggshop.se": { j: "6" },
  "seaheroquest.gr": { s: ".tab-cookies{display:none !important}" },
  "awwapp.com": { s: "#bottom-notification{display:none !important}" },
  "911tabs.com": { c: 1 },
  "dieharke.de": { s: "#cookieblack{display:none !important}" },
  "audiondemand.com": {
    s: ".axs-md-cookie,aod-cookie-consent{display:none !important}",
  },
  "lvr.de": { c: 0 },
  "frankenmarkter.at": { s: ".c-window{display:none !important}" },
  "graco.com": { s: "#alertbox{display:none !important}" },
  "nyan.ax": { c: 3 },
  "msr.ch": { s: ".msr-cookie-notification{display:none !important}" },
  "momox-shop.fr": { s: "#cookietroll{display:none !important}" },
  "rodoviariadooeste.pt": { j: "5" },
  "hscollective.org": { j: "5" },
  "eurocirc.org": { s: "#msgBox_error{display:none !important}" },
  "jax.hr": { c: 11 },
  "podravski.hr": { s: ".dialog-widget{display:none !important}" },
  "ghetaldus.hr": { c: 0 },
  "chocolateminecraft.com": { s: "#popup1{display:none !important}" },
  "hapih.hr": { s: ".dialog-widget{display:none !important}" },
  "reddingo.ch": { c: 47 },
  "reddingo.com": { c: 47 },
  "blockstack.org": { j: "6" },
  "mypolacy.de": { j: "6" },
  "volksblatt.li": {
    s: ".cookie_rolldown{display:none !important}.main_cookies{position:static !important}.main_cookies .subheader{top:0 !important}",
  },
  "morfars.dk": {
    s: 'body > span[style*="transform"]{display:none !important}',
  },
  "cruise.jobs": { j: "6" },
  "swinton.co.uk": {
    s: "#app > div > header > small{display:none !important}",
  },
  "swissict.ch": { s: "#dpcc-wrapper{display:none !important}" },
  "contarcaracteres.com": { c: 121 },
  "elsate.com": { j: "5" },
  "portwell.com.tw": {
    s: '.ui-dialog[aria-describedby="dialog-confirm"],.ui-widget-overlay{display:none !important}',
  },
  "ventilation-system.com": { s: ".cookie-wr{display:none !important}" },
  "dzone.com": { s: 'body > div[id^="om-"]{display:none !important}' },
  "landg.com": { s: "#st_box{display:none !important}" },
  "waterfordinyourpocket.com": {
    s: ".ntm_optin_popup{display:none !important}",
  },
  "itinari.com": {
    s: '#app > footer ~ div[class^="root"]{display:none !important}',
  },
  "jobup.ch": { s: ".c-alert{display:none !important}" },
  "testmy.net": { c: 17 },
  "yodiz.com": { s: "#footMsgYodiz{display:none !important}" },
  "formidable.com": { s: ".formidaCookie{display:none !important}" },
  "noriel.ro": { j: "5" },
  "gofundme.com": { j: "5" },
  "macway.com": { s: "#grpd-consent{display:none !important}" },
  "amtempo.de": { c: 13 },
  "bilety.mazowieckie.com.pl": { j: "6" },
  "molecaten.nl": { s: "#cookies_modal{display:none !important}" },
  "linnaleht.ee": {
    s: ".style-wrapper > .ntf-container{display:none !important}",
  },
  "lekiosk.com": { s: "btb-app > banner{display:none !important}" },
  "trzemeszno.pl": { c: 1 },
  "buro247.hr": { s: "#subscriptionPopupBottom{display:none !important}" },
  "kink.nl": { j: "6" },
  "vinbanken.se": { j: "5" },
  "dailyhive.com": { s: "#cookies-module{display:none !important}" },
  "holidayfactory.co.za": { s: "#polgpr{display:none !important}" },
  "sporttotal.tv": {
    s: '#root > div[role="navigation"] ~ div{display:none !important}',
  },
  "qioz.fr": { j: "5" },
  "ericeirasurfskate.pt": { s: ".footer-fixed-bar{display:none !important}" },
  "union.nl": { j: "5" },
  "melcloud.com": { j: "5" },
  "parallels.com": { s: ".notification.orange{display:none !important}" },
  "dane.gov.pl": { j: "5" },
  "tugramy.pl": { c: 0 },
  "autoscout24.ch": { s: ".global-banner{display:none !important}" },
  "epapern.present-perfect.de": { j: "6" },
  "totum.com": { j: "5" },
  "frosmo.com": { s: "#frosmoPopup{display:none !important}" },
  "aquaphor.ru": { s: "#modal-kuki{display:none !important}" },
  "tribunesandtriumphs.org": { c: 145 },
  "ing.be": { j: "6" },
  "multikino.pl": { j: "6" },
  "heavenhr.com": {
    s: "#fullDarkVeil,#compliAcceptCookies{display:none !important}",
  },
  "mmafighting.com": { j: "5" },
  "theverge.com": { j: "5" },
  "krefting.de": { j: "5" },
  "focus-arztsuche.de": { s: ".tracking-box{display:none !important}" },
  "scrabble-triche.fr": { s: ".cookie-wr{display:none !important}" },
  "packtpub.com": { s: "#packt_gdpr_container{display:none !important}" },
  "mlexmarketinsight.com": {
    s: ".banner-message-cpopup{display:none !important}",
  },
  "hometree.co.uk": {
    s: ".ht-nav-cookienotification{display:none !important}",
  },
  "portugalforum.org": { j: "6" },
  "imobily.eu": { s: ".gmt_gdpr{display:none !important}" },
  "slovenia.info": { j: "6" },
  "commonsensemedia.org": { s: ".region.region-top{display:none !important}" },
  "tarifhaus.de": { s: "#data-protection-regulation{display:none !important}" },
  "visitwales.com": { s: ".m-noticeBar{display:none !important}" },
  "usercontrol.co.uk": { j: "5" },
  "shellenergy.co.uk": { s: "#js-footer > div{display:none !important}" },
  "greatist.com": { j: "5" },
  "777score.ru": { s: ".PolicyNotifications{display:none !important}" },
  "esselunga.it": { c: 0 },
  "aktionsfinder.at": { j: "6" },
  "viberate.io": { j: "5" },
  "bosch-climate.be": { j: "6" },
  "ffonts.net": { c: 131 },
  "domhouse.pl": { j: "6" },
  "bandsintown.com": {
    s: '#main > div > div[class*="index"]:first-child{display:none !important}',
  },
  "gyakorikerdesek.hu": { j: "6" },
  "volvic.fr": { s: "#_legal{display:none !important}" },
  "vergleichen-und-sparen.de": {
    s: "#vs-cookiehinweis{display:none !important}",
  },
  "cruisebare.com": { j: "6" },
  "ortograf.ws": { s: "#cd{display:none !important}" },
  "clubdelzapato.com": { c: 0 },
  "listesdemots.com": { s: "#cd{display:none !important}" },
  "opticaldiscount.com": {
    s: "#cookie-authorization{display:none !important}",
  },
  "agroneo.com": { j: "6" },
  "myscience.org": { s: "#footer ~ .block{display:none !important}" },
  "jsonquerytool.com": { s: ".navbar.fixed-bottom{display:none !important}" },
  "stadtfeste-in-deutschland.de": { c: 81 },
  "spatiicomerciale.ro": { j: "5" },
  "migliori-siti-di-incontri.it": { c: 8 },
  "park-skocjanske-jame.si": { s: "#all ~ div{display:none !important}" },
  "coolbet.com": {
    s: "#main-layout > .main-container ~ div{display:none !important}",
  },
  "sciencex.com": { c: 9 },
  "sainsburysenergy.com": { c: 0 },
  "tunnelmb.net": { s: "#app-root > footer ~ div{display:none !important}" },
  "cryps.info": { c: 33 },
  "mforos.com": {
    s: "body > style + div[id][class]:not([style]){display:none !important}",
  },
  "bmihealthcare.co.uk": {
    s: "body.cookie-overlay__dark::after{content:none !important}",
  },
  "snyk.io": { j: "5" },
  "vaneesterenmuseum.nl": { j: "6" },
  "e-horyzont.pl": { j: "6" },
  "resources.techcommunity.microsoft.com": { j: "5" },
  "cesanta.com": { c: 1 },
  "littlethings.com": {
    s: '#___gatsby > div[role="group"] .headroom-wrapper + div[class^="css"]{display:none !important}',
  },
  "elca.ch": { s: ".elca-gdpr{display:none !important}" },
  "tikkio.com": { j: "5" },
  "support.onepeloton.com": { c: 21 },
  "igvault.com": { s: ".header-perm{display:none !important}" },
  "stratoscale.com": { c: 108 },
  "tricentis.com": { s: ".site-banner{display:none !important}" },
  "ipaddress.com": { j: "5" },
  "ip-adress.com": { s: "#cc-wrapper{display:none !important}" },
  "tuttishop.ch": { c: 109 },
  "farnhammaltings.com": { c: 109 },
  "ledluxor.com": { c: 109 },
  "sammic.fr": { c: 109 },
  "swdec.de": { c: 109 },
  "knowledgecottonapparel.com": { c: 31 },
  "keolis.com": { s: "vad-cookie{display:none !important}" },
  "viatransilvanica.com": { s: "#accept-popup{display:none !important}" },
  "legebatterijen.nl": { c: 0 },
  "atom8.com": { s: "#LandingPopUp{display:none !important}" },
  "robinwieruch.de": {
    s: '#___gatsby div[class^="AnalyticsFooter"]{display:none !important}',
  },
  "zoomin.tv": { s: "#privacyoverlay{display:none !important}" },
  "airtel.in": { c: 0 },
  "binary.com": { s: "#dialog_notification{display:none !important}" },
  "bandi.pl": { c: 0 },
  "myscript.com": { c: 9 },
  "cartegie.com": { s: "#modal-overlay{display:none !important}" },
  "framatube.org": { s: ".row.privacy-concerns{display:none !important}" },
  "insurancebusinessmag.com": {
    s: ".notification_strip{display:none !important}",
  },
  "architecturalrecord.com": { j: "6" },
  "friv-games.com": { c: 34 },
  "regione.vda.it": { s: "#disclaimer-box{display:none !important}" },
  "italiarail.com": {
    s: 'body > div[style*="block"]{display:none !important}',
  },
  "wsj.com": { s: "#cx-notification{display:none !important}" },
  "avanza.se": { s: "aza-cookie-message{display:none !important}" },
  "wofox.com": { s: ".main-privacy-popup{display:none !important}" },
  "suzukimoto.pt": { c: 63 },
  "horizon.tv": { c: 78 },
  "comptabilisation.fr": { c: 116 },
  "hiberworld.com": {
    s: "#__next > main > div:first-child:not(.outer){display:none !important}",
  },
  "hario.jp": { s: "#sample-dialog{display:none !important}" },
  "normandiealaferme.com": { j: "5" },
  "24h-pflege-check.de": { c: 7 },
  "viewsonic.com": { c: 7 },
  "ukpressonline.co.uk": { c: 7 },
  "pianetadragonball.altervista.org": { c: 7 },
  "m-a.org.uk": { c: 7 },
  "futbolenlatv.es": { c: 7 },
  "fgh-info.de": { c: 7 },
  "efinancialcareers.com": { c: 7 },
  "askdifference.com": { c: 7 },
  "materialdistrict.com": { j: "5" },
  "schaapcitroen.nl": { s: "#cookie-wall{display:none !important}" },
  "volcanoteide.com": { s: ".cc-grower{display:none !important}" },
  "alan.com": { j: "5" },
  "himsa.com": { s: ".cookieApprove{display:none !important}" },
  "elsevier.com": { j: "5" },
  "niceareas.co.uk": { s: ".rayAlertBox{display:none !important}" },
  "foxrenderfarm.com": {
    s: '#gatsby-focus-wrapper > div[class*="Contact"] ~ div{display:none !important}',
  },
  "ifema.es": { c: 0 },
  "singellooputrecht.nl": { s: ".cc-wrapper{display:none !important}" },
  "miles-and-more-kreditkarte.com": { s: ".stoerer{display:none !important}" },
  "tiershop.de": { c: 15 },
  "chess24.com": { j: "5" },
  "weinfeste-in-deutschland.de": { c: 81 },
  "veka.es": { s: "#darkener_cookie{display:none !important}" },
  "weerplaza.nl": { c: 6 },
  "corbby.com.pl": { j: "5" },
  "e-plytki.eu": { c: 0 },
  "copperconcept.org": { s: ".coco-cookiebar{display:none !important}" },
  "ftm.nl": { c: 6 },
  "phphulp.nl": { c: 0 },
  "ensingerplastics.com": { c: 6 },
  "cube3x3.com": { s: "#stickyCookie{display:none !important}" },
  "lonewolfonline.net": { j: "6" },
  "configcat.com": { s: "#configcat-consent{display:none !important}" },
  "liigume.ee": {
    s: ".style-wrapper > .ntf-container{display:none !important}",
  },
  "ohtuleht.ee": {
    s: ".style-wrapper > .ntf-container{display:none !important}",
  },
  "digitalrisks.co.uk": {
    s: "#app > div > .fixed.left{display:none !important}",
  },
  "mazdahandsfree.com": {
    s: ".gdprbox,.gdprbox + .modal-overlay{display:none !important}",
  },
  "german-pavilion.com": { s: "#privacy-flyout{display:none !important}" },
  "marsh.com": {
    s: "#modalWindow.alt-opt-secure,.reveal-modal-bg-white{display:none !important}",
  },
  "astridlindgrensvarld.se": {
    s: ".bottom__footer__text-container ~ div{display:none !important}",
  },
  "luxmeble.eu": { c: 0 },
  "pietsmiet.de": { s: "#main ~ .fixed{display:none !important}" },
  "pof.com": {
    s: "#gatsby-focus-wrapper > div:not([id]) > div{display:none !important}",
  },
  "boligsiden.dk": { j: "5" },
  "cfos.de": { j: "5" },
  "newstral.com": { c: 6 },
  "bookchoice.com": { j: "6" },
  "labor28.de": { c: 6 },
  "gev-online.com": { s: "#cookies-convention{display:none !important}" },
  "beamerleinwande.de": {
    s: 'body > div[style*="z-index"]{display:none !important}',
  },
  "codementor.io": { j: "6" },
  "lg-academy.de": { s: ".cp-dialog{display:none !important}" },
  "agronews.gr": { c: 0 },
  "cogentoa.com": { s: ".legal-banner{display:none !important}" },
  "labour.org.uk": { s: ".alert-bar-footer{display:none !important}" },
  "kingslandscapes.com": {
    s: ".themify-popup.bottom-center{display:none !important}",
  },
  "filmon.com": { s: "#design-switcher{display:none !important}" },
  "jenksgroup.co.uk": {
    s: 'body > div[class^="cookie"],#mySidenav{display:none !important}',
  },
  "weldricks.co.uk": { c: 0 },
  "lifeinkrakow.pl": { s: "#rodo-popup{display:none !important}" },
  "arcteryx.com": { j: "5" },
  "itsfoss.com": { c: 108 },
  "vogue.com.tr": { s: ".cookie-item{display:none !important}" },
  "pihlajalinna.fi": {
    s: '#root > div[role="alert"]{display:none !important}',
  },
  "nullaostalavoro.dlci.interno.it": { s: "#panel{display:none !important}" },
  "joma-sport.com": { s: "#modal-policy{display:none !important}" },
  "hilditchandkey.co.uk": {
    s: "#shopify-section-disclaimer{display:none !important}",
  },
  "signavio.com": { c: 152 },
  "addons.prestashop.com": { c: 0 },
  "ziggogo.tv": { c: 78 },
  "dokterdokter.nl": { j: "5" },
  "youglish.com": { s: "#gdprModal{display:none !important}" },
  "messingschlager.com": { s: "#modalCookie{display:none !important}" },
  "tru-thoughts.co.uk": { c: 6 },
  "sttinfo.fi": {
    s: 'footer > [class*="notification"]{display:none !important}',
  },
  "simba-dickie-group.com": { s: ".cookie_block{display:none !important}" },
  "bob-emploi.fr": {
    s: '#app > div > div > div > div > nav ~ div[style*="hidden"] > div > section ~ div{display:none !important}',
  },
  "fathers-4-justice.org": { s: "#snppopup-welcome{display:none !important}" },
  "streamlabs.com": { s: ".s-callout--cookies{display:none !important}" },
  "openwire.tv": { c: 123 },
  "tierpark-ueckermuende.de": {
    s: ".cookie-einwilligung{display:none !important}",
  },
  "varma.fi": {
    s: '.ng-scope[ng-controller="CookieCtrl"]{display:none !important}',
  },
  "rote-liste.de": { s: "jhi-main > div > .banner{display:none !important}" },
  "ziekenhuis.nl": { j: "5" },
  "caricos.com": { s: "#cookiediv{display:none !important}" },
  "gamercortex.com": { s: ".gc-cookies{display:none !important}" },
  "alfred.camera": { s: ".noty_layout{display:none !important}" },
  "atomizer.gr": { c: 42 },
  "ateliertuffery.com": { s: "#pmtv-cookie{display:none !important}" },
  "pantaflix.com": {
    s: 'div[class^="CookieBar"],.panta-js-cookieNotificationBar{display:none !important}',
  },
  "hayu.com": {
    s: 'div[class^="styled__AlertsContainer"]{display:none !important}',
  },
  "imovirtual.com": { c: 28 },
  "riccos-camera.de": { s: "#cookieholder{display:none !important}" },
  "restaurant-liris.lu": { c: 153 },
  "labor-staber.de": { s: "#lwcook{display:none !important}" },
  "cloudvps.com": { j: "5" },
  "brainly.com.br": {
    s: ".brn-cookie-policy-wrapper{display:none !important}",
  },
  "primocanale.it": { c: 0 },
  "calovo.de": { s: ".ga-opt-in{display:none !important}" },
  "endesaclientes.com": { s: "#GeneralCookies{display:none !important}" },
  "techpulse.be": { s: '#eucookie + header[role="banner"]{top:0 !important}' },
  "nebo.app": { s: ".app-notifications{display:none !important}" },
  "my5.tv": {
    s: 'body > .view > .view > .view > .view[style*="black"]{display:none !important}',
  },
  "lethalpass.com": { s: ".global-notif{display:none !important}" },
  "delfino.cr": { s: "#__next > #modal ~ div{display:none !important}" },
  "kitsound.co.uk": { j: "5" },
  "best2serve.com": { s: ".cc_notification{display:none !important}" },
  "apemans.com": { s: ".xpop{display:none !important}" },
  "mulesoft.com": { s: ".gdpr-row,.gdpr.show{display:none !important}" },
  "skip-me.top": { j: "5" },
  "leticketdesexperts.fr": { c: 0 },
  "atea.ee": { c: 0 },
  "nitrohouse.com": { s: ".iCookie{display:none !important}" },
  "fachinfo.de": { s: ".row.banner{display:none !important}" },
  "sanistaal.com": { s: ".info-message{display:none !important}" },
  "elisaviihde.fi": { s: ".ea-cookie-disclaimer{display:none !important}" },
  "amsterdam-dance-event.nl": { s: ".ade-cookie-bar{display:none !important}" },
  "hermann.bio": { c: 11 },
  "cssociety.org": { s: ".icd-overlay{display:none !important}" },
  "redbubble.com": {
    s: ".ds-theme-find-your-thing ~ .Toastify{display:none !important}",
  },
  "schufa-ombudsmann.de": { s: "#AC_layout{display:none !important}" },
  "ziggo.nl": { s: ".cookiewall__wrapper{display:none !important}" },
  "abczdrowie.pl": { j: "5" },
  "disneyplus.com": { s: "#webAppFooter ~ div{display:none !important}" },
  "paradoxplaza.com": { j: "5" },
  "verkeerplaza.nl": { c: 6 },
  "lovense.com": { s: ".u-cookie{display:none !important}" },
  "stellarium-web.org": { s: ".v-snack{display:none !important}" },
  "kk.org": { s: "body > .modal-footer{display:none !important}" },
  "komtet.ru": { s: "#alert-users{display:none !important}" },
  "actionaid.fr": { s: ".rgpd{display:none !important}" },
  "costillasalhorno.com": { c: 0 },
  "nfumutual.co.uk": {
    s: 'section[aria-describedby="cookiedesc"]{display:none !important}',
  },
  "r-wipe.com": { s: "#pp-info{display:none !important}" },
  "epdf.pub": { s: "#EPDFPUB_cookie_box{display:none !important}" },
  "1plus1.video": {
    s: ".cookies.is-shown{display:none !important}.show-cookies{padding-top:0 !important}.show-cookies .header{top:0 !important}",
  },
  "go.com": {
    s: 'body[data-ad_system] > div[style*="fixed"],.terms-alert-fixed{display:none !important}',
  },
  "espn.com": {
    s: ".Tooltip--fixed.Tooltip--fixed-bottom,.alert.alert--fixed{display:none !important}",
  },
  "baywa-re.it": { s: ".gg_cookie{display:none !important}" },
  "wikifixes.com": { c: 34 },
  "government.is": { s: ".session-text.active{display:none !important}" },
  "geeklectic.io": { c: 4 },
  "mara.photos": {
    s: "#pothos_cookie_consent_dialog{display:none !important}",
  },
  "pantip.com": { s: ".pt-snackbar{display:none !important}" },
  "activate-here.com": { c: 7 },
  "medicalnewstoday.com": { j: "5" },
  "qobuz.com": {
    s: ".alert.alert-info,.alert.alert-cnil{display:none !important}",
  },
  "boilerroom.tv": {
    s: '#app > div[class^="Dialogs"] > div[class^="Dialog"]{display:none !important}',
  },
  "amazingmarvin.com": { s: "#live-chat-banner{display:none !important}" },
  "endemolshine.de": { c: 0 },
  "automatyka.istore.pl": { c: 0 },
  "radpdf.com": { s: "#pdfe_cmp{display:none !important}" },
  "wifimap.io": { s: "#__next > div:first-child{display:none !important}" },
  "cosmote.gr": { s: "#modalCookie,#cookies-one{display:none !important}" },
  "emmamerch.de": { s: ".CookieHeader{display:none !important}" },
  "keepass.info": { s: "#consent_c{display:none !important}" },
  "cookiewall.vice.com": { j: "5" },
  "streema.com": { s: ".footer ~ .alert{display:none !important}" },
  "trusted.de": { j: "5" },
  "radioaustria.at": { j: "6" },
  "sonymobile.com": { s: ".bnw-module.header{margin-top:0 !important}" },
  "ecoreporter.de": { s: "#cookieTop{display:none !important}" },
  "ichip.ru": { c: 150 },
  "i-fundusze.pl": { c: 14 },
  "columbia.edu": { s: ".sticky-notice-wrap{display:none !important}" },
  "webhint.io": { c: 8 },
  "rambus.com": { j: "5" },
  "blonded.co": { s: ".FooterNotice{display:none !important}" },
  "coselpalais-dresden.de": { s: "#POPUP_ROOT{display:none !important}" },
  "rosbank.ru": { s: "#personal-data-processing{display:none !important}" },
  "celle-uelzennetz.de": { c: 0 },
  "edenred.cz": { s: ".Footer .InfoBar{display:none !important}" },
  "conrad-katalog.at": { s: "#nagme{display:none !important}" },
  "bs-ffb.de": { j: "5" },
  "e-syntagografisi.gr": { j: "6" },
  "bankintercomite.es": { s: ".cajatxt{display:none !important}" },
  "coinmarketcap.com": {
    s: "#cmc-cookie-policy-banner{display:none !important}",
  },
  "fundamenta.hu": { s: "#fund-cookie-info-layer{display:none !important}" },
  "ingelheimer-marktplatz.de": { s: "#dsgvo_once{display:none !important}" },
  "rubart.de": { s: "#newShopAttention{display:none !important}" },
  "fjshop.dk": { j: "6" },
  "planbusstib.be": { c: 6 },
  "biblio.com": { c: 42 },
  "kayak.pl": { j: "5" },
  "rockymountainatvmc.com": {
    s: ".cookieText,.cookieMon{display:none !important}",
  },
  "advodan.dk": { j: "6" },
  "bakker.com": { s: "#footerDiv{display:none !important}" },
  "pubgesports.com": {
    s: 'body > div > div > div > [class^="view__ModalWindowContainer"]{display:none !important}',
  },
  "awo.org": { s: "#kekse{display:none !important}" },
  "g-sport.si": { s: ".fff{display:none !important}" },
  "weihnachtsmaerkte-in-deutschland.de": { c: 81 },
  "werkenbijhanos.nl": { j: "6" },
  "berkshirecommunities.com": { s: ".sticky-banner{display:none !important}" },
  "portfolium.com": { s: "pf-gdpr-snackbar{display:none !important}" },
  "megustaleer.com": { s: ".cookie,.cookie_mobile{display:none !important}" },
  "klaxoon.com": { s: ".banner-wrapper.is-active{display:none !important}" },
  "estjob.com": { s: ".rgpd{display:none !important}" },
  "tv7.com": { s: "#gsoi-cmp{display:none !important}" },
  "das.co.uk": {
    s: ".cookie,.secnav-links__item:last-child{display:none !important}",
  },
  "daslaw.co.uk": {
    s: ".cookie,.secnav-links__item:last-child{display:none !important}",
  },
  "dasinsurance.co.uk": {
    s: ".cookie,.secnav-links__item:last-child{display:none !important}",
  },
  "strefawalut.pl": { c: 2 },
  "10-4.dk": { c: 2 },
  "dia.es": { c: 2 },
  "daparto.de": { c: 2 },
  "dalmatinskiportal.hr": { c: 2 },
  "alcampo.es": { c: 2 },
  "technetium.pl": { c: 2 },
  "karatekyokushin.hu": { c: 2 },
  "trafiken.nu": { c: 2 },
  "schaffrath.com": { c: 2 },
  "bug.hr": { c: 2 },
  "upc.cz": { c: 2 },
  "nationalcircus.org.uk": { c: 2 },
  "fischer.de": { c: 2 },
  "macorlux.pt": { c: 2 },
  "techmart.bg": { c: 2 },
  "oetkercollection.com": { c: 2 },
  "happywithyoga.com": { c: 2 },
  "skiline.cc": { c: 2 },
  "ulsterbank.ie": { c: 2 },
  "roncadin.it": { c: 2 },
  "spartanien.de": { c: 2 },
  "dutchcarparts.nl": { c: 2 },
  "dirk.nl": { c: 2 },
  "allekabels.nl": { c: 2 },
  "model-kartei.de": { c: 2 },
  "otouczelnie.pl": { c: 2 },
  "ceramicspeed.com": { c: 2 },
  "negozicuorebio.it": { c: 2 },
  "szerszamoutlet.hu": { c: 2 },
  "findbolig.nu": { c: 2 },
  "rbs.com": { c: 2 },
  "pildyk.lt": { c: 2 },
  "utilities.nl": { c: 2 },
  "del.org": { c: 2 },
  "18virginsex.com": { c: 2 },
  "sense.org.uk": { c: 2 },
  "wannawork.com": { c: 2 },
  "signal-iduna.de": { c: 2 },
  "twitchstrike.com": { c: 2 },
  "agromedia.rs": { c: 2 },
  "oldgoesyoung.com": { c: 2 },
  "vigszinhaz.hu": { c: 2 },
  "akme.hu": { c: 2 },
  "borgware.de": { c: 2 },
  "quelpneu.com": { c: 2 },
  "onlineszerszam.hu": { c: 2 },
  "virtualtrucker.pl": { c: 2 },
  "karls-shop.de": { c: 2 },
  "conferencemanager.dk": { c: 2 },
  "stoffe-hemmers.de": { c: 2 },
  "jeffery-west.co.uk": { c: 2 },
  "autourdebebe.com": { c: 2 },
  "guthaben.de": { c: 2 },
  "autoreisen.com": { c: 2 },
  "kodi.de": { c: 2 },
  "union.hu": { c: 2 },
  "machinestock.com": { c: 2 },
  "ombudsman-services.org": { c: 2 },
  "dermashop.hu": { c: 2 },
  "amnesty.org.uk": { c: 2 },
  "anybus.com": { c: 2 },
  "neon-service.pl": { c: 2 },
  "draytek.com": { c: 2 },
  "dis.rs": { c: 2 },
  "matratzen-concord.ch": { c: 2 },
  "everysize.com": { c: 2 },
  "youtubedownloadersite.com": { c: 2 },
  "tutti-pizza.com": { c: 2 },
  "markel.com": { c: 2 },
  "engbers.com": { c: 2 },
  "prodir.com": { c: 2 },
  "unumotors.com": { c: 2 },
  "necgroup.co.uk": { c: 2 },
  "knuffmann.de": { c: 2 },
  "axioart.com": { c: 2 },
  "hiya.com": { c: 2 },
  "techem.de": { c: 2 },
  "mazowieckie.com.pl": { c: 2 },
  "sprawdzonyfizjoterapeuta.pl": { c: 2 },
  "parat.com": { c: 2 },
  "youtubedownload.altervista.org": { c: 2 },
  "medianauka.pl": { c: 2 },
  "munich-business-school.de": { c: 2 },
  "rientiestuinmachines.nl": { c: 2 },
  "tacklifetools.com": { c: 2 },
  "rutoken.ru": { c: 2 },
  "sleek-mag.com": { c: 2 },
  "allobebe.fr": { c: 0 },
  "wilko.com": { c: 0 },
  "kafelanka.cz": { c: 0 },
  "auto10.com": { c: 0 },
  "omaweetraad.nl": { c: 0 },
  "singulart.com": { c: 0 },
  "previssima.fr": { c: 0 },
  "cp.pt": { c: 0 },
  "makandracards.com": { c: 0 },
  "mabanqueprivee.bnpparibas": { c: 0 },
  "sexipedia.gr": { c: 0 },
  "mobylines.de": { c: 0 },
  "mobylines.fr": { c: 0 },
  "moby.it": { c: 0 },
  "365.bank": { c: 0 },
  "ukmail.com": { c: 0 },
  "conforama.pt": { c: 0 },
  "bezux.com": { c: 0 },
  "moldurashergon.es": { c: 0 },
  "unian.ua": { c: 0 },
  "selfhost.de": { c: 0 },
  "intermarche.be": { c: 0 },
  "gheed.com": { c: 0 },
  "crytek.com": { c: 0 },
  "teletorium.pl": { c: 0 },
  "farecompare.com": { c: 0 },
  "conforama.es": { c: 0 },
  "reifenlehmann.de": { c: 0 },
  "lost24.eu": { c: 0 },
  "plodine.hr": { c: 0 },
  "veggiecommunity.org": { c: 0 },
  "carowall.com": { c: 0 },
  "success.ivanti.com": { c: 0 },
  "epresse.fr": { c: 0 },
  "coopbank.dk": { c: 0 },
  "omdenken.nl": { c: 0 },
  "zadovoljstvozaposlenika.hr": { c: 0 },
  "fitpatrol.pl": { c: 0 },
  "maxchocolatier.com": { c: 0 },
  "inagrm.com": { c: 0 },
  "nederlandsebrouwers.nl": { c: 0 },
  "lunamum.de": { c: 0 },
  "free3dbase.com": { c: 0 },
  "hyundai.es": { c: 0 },
  "lelieuunique.com": { c: 0 },
  "srazenazver.cz": { c: 0 },
  "sudzibas.lv": { c: 0 },
  "tuenti.es": { c: 0 },
  "dvdmax.pl": { c: 0 },
  "abbeylegal.com": { c: 0 },
  "magniflex.cz": { c: 0 },
  "francecars.fr": { c: 0 },
  "kliniken-koeln.de": { c: 0 },
  "used.jaguar.co.uk": { c: 0 },
  "sunstargum.com": { c: 0 },
  "huntshowdown.com": { c: 0 },
  "tuplus.com.co": { c: 0 },
  "autempoeuropie.pl": { c: 0 },
  "distilnetworks.com": { c: 0 },
  "lakelucerne.ch": { c: 0 },
  "hotel-spider.com": { c: 0 },
  "m.brettspielwelt.de": { c: 0 },
  "vizologi.com": { c: 0 },
  "almasi.sk": { c: 0 },
  "forsettlement.com": { c: 0 },
  "netia.pl": { c: 0 },
  "xxe.fr": { c: 0 },
  "kalfor.dk": { c: 0 },
  "cbeci.org": { c: 0 },
  "egyptair.com": { c: 0 },
  "taylorandfrancis.com": { c: 0 },
  "indepth.dev": { c: 0 },
  "livretzesto.fr": { c: 0 },
  "dur.ac.uk": { c: 0 },
  "vogue.pt": { c: 0 },
  "o2online.es": { c: 0 },
  "mitsubishi-motors.fr": { c: 0 },
  "wybory.gov.pl": { c: 0 },
  "topvintage.net": { c: 0 },
  "arsene50.brussels": { c: 0 },
  "shots.net": { c: 0 },
  "udruga-gradova.hr": { c: 0 },
  "zoom.earth": { c: 0 },
  "userinyerface.com": { c: 0 },
  "cosmosmagazine.com": { c: 6 },
  "reifen-dinser.de": { c: 0 },
  "tang-freres.fr": { s: ".welcome{display:none !important}" },
  "spotify.com": {
    s: "#main > .Root > section,.mh-message-bar{display:none !important}",
  },
  "ovplaza.nl": { c: 6 },
  "spox.com": { s: ".spxcib.open{display:none !important}" },
  "scholieren.com": { c: 6 },
  "asket.com": { s: ".site-notice{display:none !important}" },
  "scummvm.org": { c: 6 },
  "web-axioma.ru": { s: ".confform{display:none !important}" },
  "parenting.pl": { j: "5" },
  "imaginanet.com": { c: 0 },
  "otwarteklatki.pl": { j: "5" },
  "clubmed.co.uk": {
    s: ".Line-container > .fixed.shadow{display:none !important}",
  },
  "adelaida.ro": { s: "#barwrap{display:none !important}" },
  "mikronis.hr": { c: 0 },
  "buket.hr": { s: ".kukip{display:none !important}" },
  "hoval.hr": { s: "#pageAlertBox{display:none !important}" },
  "triglav.hr": { s: "#cookie_module{display:none !important}" },
  "035portal.hr": { s: ".privatnost{display:none !important}" },
  "webuy.com": { s: ".cookies_div{display:none !important}" },
  "shopstyle.co.uk": { c: 49 },
  "explo.hu": { s: "#marketingConsent{display:none !important}" },
  "aniflix.tv": { c: 6 },
  "comixology.eu": { s: "body > div > .overlay{display:none !important}" },
  "shop.rema1000.dk": { c: 2 },
  "thingsmobile.com": { c: 2 },
  "lelivrescolaire.fr": { s: ".Cookie_modal{display:none !important}" },
  "vboxxcloud.nl": { c: 0 },
  "gulfstream.com": { c: 11 },
  "erdinger.de": { j: "5" },
  "regain.us": { j: "6" },
  "luxortheater.nl": { j: "5" },
  "beko-technologies.com": { s: "#info-overlay{display:none !important}" },
  "travelmatters.ro": { c: 3 },
  "environmental-finance.com": { s: ".modal-dialog{display:none !important}" },
  "goodlight.co.uk": { s: ".cp-slidein{display:none !important}" },
  "enbw.com": { j: "5" },
  "slagelse.info": { j: "5" },
  "quick.be": { j: "6" },
  "roseburnbar.co.uk": { s: "#POPUP_ROOT{display:none !important}" },
  "milkywire.com": { j: "6" },
  "join-the-crew.com": {
    s: 'footer ~ div > div[role="alertdialog"]{display:none !important}',
  },
  "soundtoys.com": {
    s: '.content-info ~ section[style*="background"]{display:none !important}',
  },
  "oekk.ch": { s: ".mod-disclaimer{display:none !important}" },
  "stadt-kuehlungsborn.de": { j: "5" },
  "alapblog.hu": { s: ".sutiSzorny{display:none !important}" },
  "sklep.regmot.com.pl": { j: "5" },
  "woningnetregioamsterdam.nl": {
    s: ".growlcontainer{display:none !important}",
  },
  "woningnetregiomiddenholland.nl": {
    s: ".growlcontainer{display:none !important}",
  },
  "engie-energie.nl": { j: "5" },
  "monety.it": { c: 8 },
  "boxcryptor.com": {
    s: '.mdl-layout__inner-container > .mdl-layout__header ~ div[style*="transform"]{display:none !important}',
  },
  "hilleberg.com": { s: "#subBar{display:none !important}" },
  "renaultretailgroup.es": { c: 0 },
  "tacklewarehouse.com": { c: 104 },
  "theblackfriday.com": { s: ".fixed.legal-text{display:none !important}" },
  "compteur.fr": { j: "6" },
  "walkers.co.uk": { s: ".pepsi-Cookies{display:none !important}" },
  "tastemade.co.uk": { s: ".legal-change-banner{display:none !important}" },
  "forever21.com": { j: "5" },
  "kivipaberkaarid.ee": { c: 2 },
  "speedy.bg": { s: "#system_message{display:none !important}" },
  "bottle.li": { c: 153 },
  "proglib.io": { c: 0 },
  "marketfinance.com": { c: 3 },
  "bpost.be": { c: 0 },
  "spellshelp.com": { s: ".consent_breadcrumbs{display:none !important}" },
  "buelow-palais.de": { s: "#confirmation{display:none !important}" },
  "toyexpress24.com": { c: 0 },
  "adac-shop.de": { j: "5" },
  "einsteinkultur.de": { s: ".page-cn.cn-active{display:none !important}" },
  "atos.net": { c: 107 },
  "planplus.rs": {
    s: ".cookie-consent2,.cookie-consent{display:none !important}",
  },
  "issuu.com": { s: ".icc-Root{display:none !important}" },
  "manporn.xxx": { s: ".copyrights ~ .black-bg{display:none !important}" },
  "bito.com": { c: 2 },
  "smartclinic.hu": {
    s: "#gdprModal{display:none !important}",
    c: 14,
  },
  "akvis.com": { s: ".awarning{display:none !important}" },
  "linkmenuezerai.lt": { s: ".cookies-hold{display:none !important}" },
  "qv.co.nz": {
    s: ".bootbox{display:none !important}",
    c: 14,
  },
  "m.economictimes.com": { j: "5" },
  "resume.se": { j: "5" },
  "supplementa.com": {
    s: "body > div[data-ez-module-cookiedirective],body > div[data-ez-overlay]{display:none !important}",
  },
  "personal.natwest.com": { c: 2 },
  "andinet.de": { s: ".coo.show{display:none !important}" },
  "forum.suunto.com": { c: 6 },
  "mondo-tech.it": { j: "6" },
  "starnow.co.uk": { s: ".popup__entrance{display:none !important}" },
  "tulodz.pl": { c: 99 },
  "autozine.nl": { c: 0 },
  "decrypt.co": { j: "6" },
  "web-factory.at": { s: ".cookie-outter{display:none !important}" },
  "webmd.com": { j: "5" },
  "ostsee-charter-yacht.de": { c: 0 },
  "wetter.team": { j: "6" },
  "henderson.ru": { s: ".politica{display:none !important}" },
  "bubble.ru": { c: 9 },
  "coffeecollective.dk": { j: "6" },
  "ztm.waw.pl": { s: ".page-consent{display:none !important}" },
  "indonesia-publisher.id": { j: "6" },
  "nordpass.com": {
    s: "#gatsby-focus-wrapper > div > .fixed{display:none !important}",
  },
  "stenstroms.com": {
    s: "#currentPageContent + div + div + div:last-child{display:none !important}",
  },
  "deondernemer.nl": { j: "5" },
  "eponuda.com": { c: 2 },
  "die-ip-adresse.de": { c: 66 },
  "nextapro.hu": { c: 0 },
  "dlapacjenta.pl": { c: 90 },
  "dacter.pl": { c: 90 },
  "krovni-nosaci.hr": { s: ".topbarBox{display:none !important}" },
  "myshiptracking.com": { s: ".alert_bar{display:none !important}" },
  "uni-tech.pl": { c: 90 },
  "mobil.com": { c: 35 },
  "crpa.it": { s: ".fancybox-overlay,.fancybox-wrap{display:none !important}" },
  "biomet.lt": { c: 35 },
  "centreceramique.nl": { c: 35 },
  "deutschebank.nl": { c: 35 },
  "manetti.com": {
    s: ".fancybox-overlay,.fancybox-wrap{display:none !important}",
  },
  "stw.berlin": { c: 8 },
  "clementoni.com": { c: 8 },
  "casaleggio.it": { s: "#disclaimerC{display:none !important}" },
  "eestiloto.ee": { s: ".disclaimer-wrapper{display:none !important}" },
  "greybox.com": { c: 8 },
  "amundi.pl": { s: "#disclaimer_amundi{display:none !important}" },
  "biodiv.be": { c: 8 },
  "prevenzioneatavola.it": { s: "#disclaimerC{display:none !important}" },
  "overunity.com": { s: "#ecl_outer{display:none !important}" },
  "brettspiel-angebote.de": { s: "#privacyhint{display:none !important}" },
  "polstor.pl": { c: 2 },
  "distrokid.com": { j: "6" },
  "wtp.waw.pl": { s: ".page-consent{display:none !important}" },
  "musescore.com": {
    s: "body > div:not([id]):not([class]):not([style]),body > section > section{display:none !important}",
  },
  "financenancy.com": { c: 147 },
  "marusik.cz": { c: 154 },
  "fitnessclubs4.pl": { c: 2 },
  "pepco.hu": { c: 0 },
  "tadeevo.com": { c: 0 },
  "linuxcompatible.org": { s: ".alert-block{display:none !important}" },
  "signatur.frontlab.com": { j: "5" },
  "mercedesamgf1.com": { s: ".cLayer{display:none !important}" },
  "trans-missions.eu": { j: "5" },
  "zoomagazin.eu": { s: "#cookieForm{display:none !important}" },
  "dunense.com": { c: 5 },
  "budgetinsurance.com": { c: 5 },
  "blocksite.co": { c: 5 },
  "correctiv.org": { c: 5 },
  "funnelytics.io": { c: 5 },
  "schwabenhaus.de": { c: 5 },
  "selle-proust.fr": { c: 5 },
  "stoppub.fr": { c: 5 },
  "golder.com": { s: ".popcookies{display:none !important}" },
  "amara.com": { c: 98 },
  "r-tt.com": { s: "#pp-info{display:none !important}" },
  "grainsystems.com": { s: ".disclaimerpopup{display:none !important}" },
  "warmbat.nl": { c: 2 },
  "wasted.fr": { c: 0 },
  "rotterdammersvoorelkaar.nl": { j: "5" },
  "stylefile.de": { s: ".ui-dialog{display:none !important}" },
  "chainethermale.fr": { j: "5" },
  "engvig.no": { c: 0 },
  "layerstack.com": { s: ".promotion-footer{display:none !important}" },
  "accor.com": { s: "#cookiesAccorJobs{display:none !important}" },
  "pazienti.it": { s: ".pz-disclaimer--cookie{display:none !important}" },
  "dealz.pl": { s: ".jet-popup{display:none !important}" },
  "nfpa.org": { s: "#fixed_footer{display:none !important}" },
  "moveon4.de": { c: 6 },
  "bakkt.com": { j: "6" },
  "orthopaedie-mediapark.de": { s: ".consentOverlay{display:none !important}" },
  "lunii.fr": { j: "5" },
  "mtva.hu": { s: ".resultCookie{display:none !important}" },
  "diplon.net": { c: 42 },
  "radiofamily-sound.de": {
    s: ".jq-toast-single.jq-icon-warning{display:none !important}",
  },
  "bodum.com": { s: "#gdpr-popup-modal{display:none !important}" },
  "blitzhangar.com": { j: "5" },
  "pipedrive.com": { c: 2 },
  "comparium.app": { s: ".sticky-message__wrap{display:none !important}" },
  "creativecommunity.fr": { s: ".cookie-nav{display:none !important}" },
  "arcadja.com": { s: "#headerTopLog > center{display:none !important}" },
  "metolijf.nl": { c: 123 },
  "mybodepro.com": { c: 27 },
  "photobite.uk": { s: ".pb19_gdpr{display:none !important}" },
  "agenda.brussels": { c: 0 },
  "big5sportinggoods.com": { c: 4 },
  "translated.net": { c: 26 },
  "mychildcarevouchers.co.uk": { s: "#divBanner{display:none !important}" },
  "allgeier-experts.com": { s: ".site-cookie{display:none !important}" },
  "healthsoul.com": { j: "5" },
  "sintaxis.org": { s: "#hsup{display:none !important}" },
  "montecryptoscasino.com": { s: ".cookie-button{display:none !important}" },
  "hartfordbusiness.com": { j: "6" },
  "resideo.com": { s: "#HOMESEUCookie-Banner{display:none !important}" },
  "inetprint.cz": { s: "#stickyFooter{display:none !important}" },
  "nspcc.org.uk": { c: 0 },
  "szklarskaporeba.pl": { c: 0 },
  "solmax.com": { s: "._bloc_cookies{display:none !important}" },
  "sonax.de": { s: ".snx-notification{display:none !important}" },
  "psycom.net": { s: "#vhn{display:none !important}" },
  "zepsute.pl": { s: "#overlay_uv,#ov_panel{display:none !important}" },
  "vostron.com": { j: "6" },
  "nastopy.pl": { s: ".rodo,.rodo ~ .mask{display:none !important}" },
  "flens.de": { j: "6" },
  "iberiaexpress.com": { j: "5" },
  "exponea.com": { s: ".exp-cookies{display:none !important}" },
  "monespaceclient.cnp.fr": { c: 0 },
  "lahtipro.pl": { s: "#alert_bar{display:none !important}" },
  "pnp.be": { s: "#upGDPR{display:none !important}" },
  "i-trekkings.net": {
    s: ".trekk-barre-pied-de-page{display:none !important}",
  },
  "lebenslauf.com": {
    s: 'div[class*="CookieConsent"]{display:none !important}',
  },
  "recharge.fr": { c: 2 },
  "monsieur-meuble.com": { c: 0 },
  "ebi.ac.uk": {
    s: '#interpro-root > div[style*="fixed"]{display:none !important}',
  },
  "gknpm.com": { s: "clients-cookie-policy{display:none !important}" },
  "alfabank.ru": {
    s: "#alfa > .platform > noindex,#agreement-popup{display:none !important}",
  },
  "ncalculators.com": { c: 4 },
  "valais.ch": { c: 9 },
  "stayfriends.de": { c: 2 },
  "enjoynu.com": { s: "#coookie{display:none !important}" },
  "vanderpoelmontage.nl": { s: ".cookie-settings{display:none !important}" },
  "kvb.de": {
    s: "#cc_hint,#cc_technical,#cc_statistical{display:none !important}",
  },
  "getdigital.de": { s: ".privacy-wrapper{display:none !important}" },
  "pdfescape.com": { s: "#pdfe_cmp{display:none !important}" },
  "cgtn.com": { s: ".cg-tools-dialog{display:none !important}" },
  "schwab.de": { s: ".cj-privacy-settings{display:none !important}" },
  "hogrefe.de": { j: "5" },
  "shop.hfo.pl": { c: 0 },
  "bbcchildreninneed.co.uk": { j: "5" },
  "mclaren.com": { s: ".messages.show{display:none !important}" },
  "scad.edu": { s: ".consent-footer{display:none !important}" },
  "sbonline.net": { s: "#footer.tekst{display:none !important}" },
  "my.dhlparcel.nl": { j: "6" },
  "mytheresa.com": {
    s: "#privacy-overlay,#privacy-container{display:none !important}",
  },
  "primaryhomeworkhelp.co.uk": {
    s: 'body > table:first-child tr[bgcolor="#CCFF99"]{display:none !important}',
  },
  "airbank.cz": { c: 0 },
  "friendsfit.cz": { c: 0 },
  "tutu.ru": { s: ".style__disclaimer{display:none !important}" },
  "steamgriddb.com": {
    s: "#noty_layout__bottomRight{display:none !important}",
  },
  "nekedterem.hu": { s: ".cookie_sav{display:none !important}" },
  "basecamelectronics.com": { s: "#agreement-alert{display:none !important}" },
  "kreafunk.com": { s: ".l-notifications{display:none !important}" },
  "garesys.com": { s: ".js-go-notification{display:none !important}" },
  "immigroup.com": { s: "#ccdiv{display:none !important}" },
  "cotic.co.uk": { s: "#promptdialogue{display:none !important}" },
  "mozgo.com": { s: "#app > .w-full.fixed{display:none !important}" },
  "ifi-audio.com": { s: ".l-cookie{display:none !important}" },
  "owlcatgames.com": { s: ".GPRD,.cookies{display:none !important}" },
  "alberabike.fr": { s: ".cookies_v16{display:none !important}" },
  "hardwareparadijs.nl": { s: "#cookieWall{display:none !important}" },
  "remorepair.com": { s: ".visitorcookie{display:none !important}" },
  "zone5g.com": { c: 1 },
  "mulders-opel.nl": { j: "5" },
  "consumer.org.nz": {
    s: ".consent-confirmation-banner{display:none !important}",
  },
  "kruizinga.nl": {
    s: ".c-header{display:none !important}.contentwrapper--cookie{margin-top:0 !important}",
  },
  "merida.nl": {
    s: ".c-header{display:none !important}.header--cookie{margin-top:0 !important}",
  },
  "mydraw.com": { c: 2 },
  "succesagenda.com": { c: 71 },
  "javlibrary.com": { s: "#adultwarningmask{display:none !important}" },
  "diplomatie.be": { s: ".ui-pnotify{display:none !important}" },
  "parfuemerie.de": { j: "5" },
  "justhype.co.uk": { c: 31 },
  "mobileshop.eu": { s: ".fixed-warning{display:none !important}" },
  "eaglemoss.com": {
    s: "privacy-settings.pos-fixed,main-overlay{display:none !important}",
  },
  "brightree.com": { c: 11 },
  "wearebo.co.uk": { j: "6" },
  "eluniverso.com": { s: ".block-eluniverso-gdpr{display:none !important}" },
  "monzo.com": {
    s: '#___gatsby div[class*="Alert-module"]{display:none !important}',
  },
  "gestoriaverdugo.es": { c: 2 },
  "sharafdg.com": { c: 0 },
  "fijiairways.com": {
    s: ".dumbBoxWrap.terms-of-use{display:none !important}",
  },
  "lucky7bonus.com": { j: "6" },
  "aigle.com": { s: ".CookiesLayer{display:none !important}" },
  "filmboxlive.com": { j: "5" },
  "paecklipunkt.ch": { s: "pp-cookie-dialog{display:none !important}" },
  "rankersta.com": { c: 2 },
  "nissannews.com": { s: "#privacyModal{display:none !important}}" },
  "android.com": { c: 32 },
  "lastminutetravel.com": { s: ".weUseCookies{display:none !important}" },
  "leti.com": { s: ".NoticesBox{display:none !important}" },
  "fmscan.org": { c: 106 },
  "govirtuo.com": {
    s: '#__next > div[style*="bottom"]{display:none !important}',
  },
  "depo-diy.ee": { s: ".depo-cookies{display:none !important}" },
  "laurentwillen.be": { s: "#overlay-bg{display:none !important}" },
  "waterfordwhispersnews.com": {
    s: ".wwn-gdpr-modal{display:none !important}",
  },
  "novaline.de": { c: 70 },
  "addgene.org": { c: 75 },
  "alpedhuez.com": { c: 5 },
  "saverioriotto.it": { s: "#policy_id{display:none !important}" },
  "bec-oglasi.com": { s: ".cookie-uslovi{display:none !important}" },
  "formulare-bfinv.de": { s: "#datenschutz{display:none !important}" },
  "lubimyczytac.pl": { j: "6" },
  "seitenbacher.de": {
    s: "#sb-cookie-compliance-overlay{display:none !important}",
  },
  "lagermaulwurf.de": { s: ".mfp-bg,.mfp-wrap{display:none !important}" },
  "olimerca.com": { j: "5" },
  "bondex.de": { c: 6 },
  "siea.sk": { s: "#cac{display:none !important}" },
  "artisansdegeneve.com": { s: "#popup-disclaimer{display:none !important}" },
  "dazn.com": {
    s: 'aside[class*="cookie-banner"],div[class*="cookieDisclaimer"]{display:none !important}',
  },
  "reportz.io": { s: ".rp-CookiesConsent{display:none !important}" },
  "roche.com": {
    s: "#myDataPrivacyPopup{display:none !important}",
    c: 14,
  },
  "zorgbaar.be": { c: 11 },
  "unbound.com": { s: "#js-cookies{display:none !important}" },
  "fallentitans.com": { s: ".footer{display:none !important}" },
  "refurbished.sk": { c: 0 },
  "player.pl": { s: ".modal-rodo{display:none !important}" },
  "howardrecords.com": { j: "5" },
  "legalstart.fr": { s: "#pop{display:none !important}" },
  "global.commerce-connector.com": { j: "5" },
  "halfmooninn.com": { s: "#hebs-consent{display:none !important}" },
  "hammarinsahko.fi": { s: "#cookie-conset-bar{display:none !important}" },
  "iplogger.org": { c: 37 },
  "fitx.de": { j: "5" },
  "speisebaron.de": { s: ".navbar.fixed-bottom{display:none !important}" },
  "boyden.ca": { s: "#site-terms{display:none !important}" },
  "bgee.org": { s: "#bgee_privacy_banner{display:none !important}" },
  "commonsense.org": {
    s: "#cse-cookie-consent-message{display:none !important}",
  },
  "arthrex.com": {
    s: "#cookie-disclaimer-modal{display:none !important}",
    c: 14,
  },
  "lamium.io": { s: ".lamium-cookie-consent{display:none !important}" },
  "heinemanngalabau.de": {
    s: ".popup_anchor .Container.wp-panel-active{display:none !important}",
  },
  "netbet.de": { s: "section#NBCookieWarning{display:none !important}" },
  "videobolt.net": { s: ".cookieBlock{display:none !important}" },
  "flexport.com": { s: "#gatsby-focus-wrapper ~ div{display:none !important}" },
  "nerim.com": { j: "5" },
  "epiroc.com": {
    s: "#cookieDiv{display:none !important}#navigationDivBusiness{margin-top:0 !important}",
  },
  "ugenr.dk": { j: "5" },
  "energyavenue.com": { j: "5" },
  "lemoncode.net": { c: 43 },
  "disk-o.cloud": {
    s: '#root div[class^="src-ui-Cookie"]{display:none !important}',
  },
  "contasconnosco.pt": { j: "5" },
  "otomoto.pl": { j: "6" },
  "slideshare.net": { s: ".lms-notice-wrapper{display:none !important}" },
  "theawesomer.com": { j: "5" },
  "kiwipress.hu": { c: 2 },
  "2020.anderzorg.nl": { s: "#ckb-container{display:none !important}" },
  "tenniswarehouse-europe.com": { c: 104 },
  "heineken.hr": { j: "6" },
  "doctolib.de": { s: ".dl-drawer-bottom{display:none !important}" },
  "searchpeoplefree.com": { s: ".cookie-terms{display:none !important}" },
  "stoffenshop.eu": { j: "5" },
  "ethereumprice.org": { s: ".zxc-msg{display:none !important}" },
  "e-dewocjonalia.eu": { c: 0 },
  "cct.hu": { c: 2 },
  "informazione.it": { s: "#cmp-tb{display:none !important}" },
  "darricau.com": { c: 13 },
  "pfefferhaus.de": { c: 8 },
  "smartystreets.com": { c: 3 },
  "vodafonetvonline.es": { j: "5" },
  "eyeque.com": { c: 8 },
  "clipper-teas.com": {
    s: '.v--modal-overlay[data-modal="cookie"]{display:none !important}',
  },
  "ortsdienst.de": { c: 4 },
  "teenage.engineering": { s: "#te-layer{display:none !important}" },
  "mundoclasico.com": { s: ".jconfirm{display:none !important}" },
  "nowystylgroup.com": {
    s: ".nsg--notification.nsg--cookies{display:none !important}",
  },
  "bancobpm.it": { s: "#footer ~ div{display:none !important}" },
  "outbyte.com": { c: 34 },
  "taleo.net": {
    s: "#taleo-cookie-law,#modal_cookie-law{display:none !important}",
  },
  "myparcel.me": { s: ".card.fixed-bottom{display:none !important}" },
  "hackintoshpro.com": { s: "footer ~ .pop{display:none !important}" },
  "kastinger.com": { s: ".cache-notice{display:none !important}" },
  "gp-ddws.com": {
    s: ".dataprivacy{display:none !important}.is-dataprivacy-active .header{margin-top:20px !important}",
  },
  "viasana.nl": { s: ".Cookie__container{display:none !important}" },
  "admiral.at": { s: "asw-cookie-acceptance-overlay{display:none !important}" },
  "edicionesobelisco.com": {
    s: "#sticky_header-sticky-wrapper{display:none !important}",
  },
  "smplayer.info": { j: "5" },
  "peoplesproblems.org": { c: 149 },
  "saloppe.de": { c: 0 },
  "cimri.com": { j: "6" },
  "unify.com": { c: 107 },
  "hazelbrugger.com": { s: "footer ~ div{display:none !important}" },
  "ado1szazalek.com": {
    s: "#layout_advertising_bottom{display:none !important}",
  },
  "puzzleyou.be": { j: "5" },
  "fotondo.cz": { j: "5" },
  "fun.com": { s: ".cookieSettings{display:none !important}" },
  "terracaching.com": { s: ".warning_banner{display:none !important}" },
  "btv.at": { s: "body > .cc{display:none !important}" },
  "gzcss.co.uk": { s: ".cookie-flash{display:none !important}" },
  "lebens.guru": { j: "6" },
  "live.globalplayer.com": { j: "5" },
  "globalplayer.com": { j: "6" },
  "win2day.at": { j: "5" },
  "gruntwork.io": { s: "#gruntyCookie{display:none !important}" },
  "diwaro.de": {
    s: "#opt-in-modal{display:none !important}",
    c: 14,
  },
  "urmet.fr": { c: 26 },
  "laborx.io": { s: ".header-index.with-cookie{display:none !important}" },
  "urteile-gesetze.de": { s: "#stickyFooter{display:none !important}" },
  "mojedenred.sk": { s: "edn-cookie{display:none !important}" },
  "make-it-in-germany.com": { s: "#nagscreen{display:none !important}" },
  "przystanekhistoria.pl": { c: 79 },
  "d2m-summit.de": { j: "5" },
  "knative.dev": { j: "5" },
  "careers.yardi.com": { j: "5" },
  "montecarlosbm.com": { s: "#cookieLab{display:none !important}" },
  "paperlessmovement.com": { c: 5 },
  "profilculture.com": { c: 2 },
  "transferwise.com": { s: "#twcc__mechanism{display:none !important}" },
  "persoonlijkegezondheidscheck.nl": { c: 0 },
  "uktaxcalculators.co.uk": { c: 1 },
  "pixiv.net": {
    s: "#root > div:first-child > div:only-child{display:none !important}",
  },
  "corvusbelli.com": {
    s: "app-cookies-message,mdb-modal-backdrop{display:none !important}",
  },
  "playpilot.com": { c: 6 },
  "swindi.de": { j: "5" },
  "dinsakerhet.se": { c: 0 },
  "morhipo.com": { s: "#legal-alert{display:none !important}" },
  "speedwaynews.pl": {
    s: "#myModal{display:none !important}",
    c: 14,
  },
  "drogisterij.net": { s: "#simple-modal{display:none !important}" },
  "digitalrealty.com": { s: "#__next > aside{display:none !important}" },
  "lifecell.net": { j: "5" },
  "bodybuilding.com": {
    s: 'body > div[style*="transparent"]{display:none !important}',
  },
  "hausinfo.ch": { s: ".m-privacy{display:none !important}" },
  "funkypigeon.com": { s: ".fp_cookies{display:none !important}" },
  "british-legal-centre.com": { s: "#targetDiv{display:none !important}" },
  "ciustekno.me": { j: "6" },
  "cocinaabuenashoras.com": { c: 0 },
  "devdocs.io": { j: "5" },
  "abschied-nehmen.info": {
    s: ".tscUiNotificationWrapper{display:none !important}",
  },
  "chainreactioncycles.com": {
    s: ".crc_cookie_overlay,.crc_cookie_opt_in{display:none !important}",
  },
  "livejasmin.com": { j: "6" },
  "livesexasian.com": { j: "6" },
  "stib-mivb.be": { c: 2 },
  "naekranie.pl": { j: "5" },
  "blick.ch": { j: "5" },
  "captrader.com": { s: ".informationContainer{display:none !important}" },
  "kreuzwerker.de": { c: 0 },
  "independent.com.mt": {
    s: ".privacy-policy-container{display:none !important}",
  },
  "lycos.social": { c: 96 },
  "amazingfables.com": {
    s: "#cookie_consent ~ #overlay{display:none !important}",
  },
  "bouwinfo.be": {
    s: 'div[class^="bi-cookie-alert"]{display:none !important}',
  },
  "sanuslife.com": {
    s: 'footer ~ div[class^="cookie"]{display:none !important}',
  },
  "citifirst.com": { s: "#popup-disclaimer{display:none !important}" },
  "we-worldwide.com": { j: "5" },
  "currencyrate.today": { s: ".cc-alert{display:none !important}" },
  "rp.pl": { j: "5" },
  "parkiet.com": { j: "5" },
  "teb.pl": { j: "5" },
  "technikum.pl": { j: "5" },
  "credit-agricole.it": {
    s: 'section[class^="Cookies_dck-manager"]{display:none !important}',
  },
  "auva.cz": { s: "#cookiediv{display:none !important}" },
  "wallpaperhub.app": {
    s: "body > div > div > .dropshadow > p{display:none !important}",
  },
  "cwm.edu.pl": { s: "#cookies-glass{display:none !important}" },
  "gensdeconfiance.fr": {
    s: 'div[class^="CookieRibbon__Wrapper"]{display:none !important}',
  },
  "rocketbank.ru": { s: "#modal-root{display:none !important}" },
  "adalo.com": { s: "#consentPopup{display:none !important}" },
  "iriedaily.de": { j: "5" },
  "pamgolding.co.za": { s: "#popi-notification{display:none !important}" },
  "posao.ba": { s: "#posaoba-footer + div + div{display:none !important}" },
  "advfn.com": { s: "#cnwrapper{display:none !important}" },
  "apartmenttherapy.com": { j: "5" },
  "hpb.com": { s: "#ccpa-notice{display:none !important}" },
  "interspar.at": { j: "5" },
  "spar.at": { j: "5" },
  "spar.hu": { j: "5" },
  "spar.hr": { j: "5" },
  "spar.si": { j: "5" },
  "telink-semi.com": { s: ".b--cookie-window{display:none !important}" },
  "olavshallen.no": { c: 0 },
  "xn--30-wka.de": { s: "#privacy-bar{display:none !important}" },
  "tigase.net": { c: 24 },
  "civey.com": {
    s: '#__next > div[class^="notifications"]{display:none !important}',
  },
  "hightech-summit-bayern.de": { c: 0 },
  "cointelegraph.com": {
    s: ".b-privacy-policy,.privacy-policy{display:none !important}",
  },
  "meinauto.de": { s: ".MaCookieLayer{display:none !important}" },
  "irishrail.ie": { s: "body > .m34{display:none !important}" },
  "skincity.se": { s: "#promotion-alert{display:none !important}" },
  "skruvat.se": { c: 6 },
  "engelbert-strauss.se": { c: 1 },
  "engelbert-strauss.cz": { c: 1 },
  "wacom.com": { j: "5" },
  "ganinex.com.pl": { j: "5" },
  "entrepreneur.com": { s: "#noticepolicy{display:none !important}" },
  "schuttetweewielers.nl": {
    s: ".popup-wrapper--bottom-fw{display:none !important}",
  },
  "bosincasso.nl": { c: 0 },
  "achat-or-et-argent.fr": { c: 0 },
  "lescommis.com": { j: "5" },
  "bewustnieuwbouw.nl": { s: "#c-bar{display:none !important}" },
  "crtm.es": { j: "6" },
  "cookieservice.aginsurance.be": { j: "5" },
  "arzttermine.de": { s: ".cc_dialog_box{display:none !important}" },
  "sanego.de": { s: ".cc_dialog_box{display:none !important}" },
  "jelszo.co": { s: ".cookie-back{display:none !important}" },
  "bimedis.com": { s: ".b-cookie-text{display:none !important}" },
  "hasura.io": { j: "5" },
  "stingray.com": { s: "#tracking-popup{display:none !important}" },
  "newmotion.com": {
    s: ".homepage-hero ~ div:last-child{display:none !important}",
  },
  "laboiteauxparoles.com": {
    s: ".dialogue-fixe.nuisance{display:none !important}",
  },
  "interface.com": { c: 149 },
  "tirerack.com": { j: "5" },
  "itsnicethat.com": { j: "5" },
  "ebookfriendly.com": { s: "#ecmr{display:none !important}" },
  "greenenergyuk.com": { s: ".divPrivacy{display:none !important}" },
  "cirrus.com": {
    s: ".page-canvas .links-are-reversed{display:none !important}",
  },
  "arc.dev": {
    s: "#__next > div > header ~ div[class]:last-child{display:none !important}",
  },
  "redislabs.com": { c: 3 },
  "yello.de": { j: "5" },
  "badminton.de": {
    s: "#cookieGradient,#cookiePrivacy{display:none !important}",
  },
  "altima-sfi.com": { s: "#politica{display:none !important}" },
  "picdumps.com": { s: "#pcdc{display:none !important}" },
  "pewdiepie.store": { j: "5" },
  "sberbank.com": { s: ".personal-data-warning{display:none !important}" },
  "caldigit.com": { s: ".elementor-location-popup{display:none !important}" },
  "jbl.de": {
    s: ".uim .overlay,.uim .overlay ~ .container.basic-modal{display:none !important}",
  },
  "bytbil.com": { j: "5" },
  "pacjent.gov.pl": {
    s: "#cookies,#zgoda.sekcja-ciasteczka{display:none !important}",
  },
  "hp.com": { s: "#privacy-notification{display:none !important}" },
  "key4biz.it": { s: "#consent-toolbar{display:none !important}" },
  "camperscaravans.nl": {
    s: 'div[id^="cookieConsentForm"]{display:none !important}',
  },
  "inshared.nl": { j: "5" },
  "deutsche-anwaltshotline.de": {
    s: "#dah-consent-manager-overlay{display:none !important}",
  },
  "iheart.com": { s: ".component-legal-notice{display:none !important}" },
  "pointblankmusicschool.com": { j: "5" },
  "werkenbijpathe.nl": { j: "5" },
  "mla.org": { s: ".donate-banner{display:none !important}" },
  "gatestoneinstitute.org": { s: ".float-bar{display:none !important}" },
  "kempen.com": { j: "5" },
  "gaia.com": { s: ".blocks.layer-modal-footer{display:none !important}" },
  "d4t4solutions.com": { s: "#privacy-overlay{display:none !important}" },
  "ada.com": { s: "#page-wrap ~ aside{display:none !important}" },
  "rapidtables.com": { c: 21 },
  "auktionssuche.de": { c: 54 },
  "ingtechpoland.com": { c: 16 },
  "ervaringensite.nl": { s: "#header-coockie{display:none !important}" },
  "ikeafamily.eu": { s: "#ikeaTermsConsentModal{display:none !important}" },
  "lightyear.one": {
    s: '#___gatsby > div[role="group"] > div > div:first-child{display:none !important}',
  },
  "influencermarketingforum.de": { j: "5" },
  "smile.io": {
    s: ".smile-cookie-notification-container{display:none !important}",
  },
  "wuestenrot.at": { j: "5" },
  "bonuszbrigad.hu": { s: "#newASZFLayer{display:none !important}" },
  "voli-diretti.it": { j: "5" },
  "caser.es": { s: "#gdpr-modal > div{display:none !important}" },
  "alltombostad.se": { s: "#pop_contact{display:none !important}" },
  "pinkvilla.com": { s: 'body > div[class^="ccc"]{display:none !important}' },
  "officiallondontheatre.com": { j: "5" },
  "comelelettroforniture.it": {
    s: 'body > div[id^="kitgdpr"]{display:none !important}',
  },
  "roomiapp.com": {
    s: '#react-root > div > div[class^="jss"]:first-child + div[class^="jss"]{display:none !important}',
  },
  "tripinview.com": { s: "#tiv-cookie-bar{display:none !important}" },
  "upc.sk": { c: 2 },
  "pocketracy.com": { s: ".dsclmr{display:none !important}" },
  "foodhub.co.uk": { c: 0 },
  "schuldnerhilfe-neuesleben.de": {
    s: "#idDatenschutzText{display:none !important}",
  },
  "ferienwohnungen-ferienhaeuser-weltweit.de": { j: "5" },
  "zolecka.pl": { j: "5" },
  "sumcumo.com": { c: 0 },
  "biorender.com": { j: "5" },
  "nassauparadiseisland.com": {
    s: "https://www.ahliunited.com.kw/ar/about/special-needs.greyCookie{display:none !important}",
  },
  "usabilitest.com": { c: 7 },
  "ixxat.com": { c: 2 },
  "ahliunited.com.kw": { s: ".greyCookie{display:none !important}" },
  "httpstatus.io": { c: 69 },
  "maxmind.com": { s: "#mm-ccpa-notice{display:none !important}" },
  "computertotaal.nl": { j: "6" },
  "ozon.ru": {
    s: "#__nuxt > .layout-page > div:last-child:not([class]){display:none !important}",
  },
  "head-fi.org": { c: 11 },
  "tradingview.com": {
    s: 'div[class^="toast-positioning-wrapper"]{display:none !important}',
  },
  "pcmweb.nl": { j: "5" },
  "webastoconnect.com": { s: ".alert.ecc.show-ecc{display:none !important}" },
  "jobnet.dk": { j: "5" },
  "toptal.com": { s: "#modal-host ~ div{display:none !important}" },
  "tune.de": { c: 124 },
  "ts.fi": { c: 1 },
  "begindot.com": { c: 5 },
  "infineon.com": { j: "5" },
  "ntp.msn.com": {
    s: ".cookieWallBanner-1,.ComplianceHyperlink-1{display:none !important}",
  },
  "inatural.com.pl": { c: 0 },
  "netze-bw.de": { j: "5" },
  "astroeder.com": { s: "#acceptDisclaimer{display:none !important}" },
  "wikia.com": { c: 23 },
  "wikia.org": { c: 23 },
  "fandom.com": { c: 23 },
  "telia.no": {
    s: "#cookie-consent-form-container{display:none !important}body{overflow:visible !important}",
  },
  "winemag.com": { s: "#wmg-cookie-consent{display:none !important}" },
  "webaslan.com": { s: ".cookie-text{display:none !important}" },
  "mazda-autohaus-seifert-pinneberg.de": {
    s: '#root > div:not([class*=" "]){display:none !important}',
  },
  "mazda-autohaus-butz-und-muehlbach-andernach.de": {
    s: '#root > div:not([class*=" "]){display:none !important}',
  },
  "mazda-autohaus-gollan-hamm.de": {
    s: '#root > div:not([class*=" "]){display:none !important}',
  },
  "knaf.nl": { s: "#cp-wrap{display:none !important}" },
  "my.games": { s: ".ph-cookies,#app header .gdpr{display:none !important}" },
  "ikea.es": { c: 24 },
  "lobos.pl": { c: 0 },
  "meteo-parapente.com": { j: "5" },
  "spiele-offensive.de": { s: ".facebookfrage{display:none !important}" },
  "blackmoreops.com": { s: ".snp-subscribeform{display:none !important}" },
  "olesnica24.com": { j: "5" },
  "korsokolbuszowskie.pl": { j: "5" },
  "2x45.info": { c: 0 },
  "adainfo24.eu": { c: 0 },
  "atriumsystem.eu": { c: 0 },
  "ladulle.fi": { s: "gdpr{display:none !important}" },
  "respresso.io": { c: 3 },
  "kulturbolaget.se": { s: ".c-messages{display:none !important}" },
  "evermotion.org": { s: ".full-overlay{display:none !important}" },
  "asecos.com": { c: 133 },
  "vodafoneziggo.nl": { j: "6" },
  "naturocoaching.fr": {
    s: 'body > div[style*="red"]{display:none !important}',
  },
  "getzen.cash": { s: "#privacy-notification{display:none !important}" },
  "marktomarket.io": { j: "5" },
  "forum.mediathekview.de": { c: 6 },
  "every-tuesday.com": { s: "#et-gdpr-popup{display:none !important}" },
  "lagazettedemontpellier.fr": { j: "5" },
  "airvpn.org": { s: "#air_cookielaw_container{display:none !important}" },
  "daidometal.com": { s: "#announcement{display:none !important}" },
  "vvebelang.nl": { j: "5" },
  "krebsinformationsdienst.de": {
    s: "#quickhint-wrapper{display:none !important}",
  },
  "eboo.lu": { j: "5" },
  "mediaarena.pl": { c: 0 },
  "ziptransfers.com": { s: ".dvcookie{display:none !important}" },
  "workforce.com": { s: ".cookie__modal{display:none !important}" },
  "eurochrom.hu": {
    s: '.notification[data-options*="Cookiek"]{display:none !important}',
  },
  "opngo.com": { j: "5" },
  "thw-handball.de": {
    s: 'body > footer ~ div:not([class]) > div[style*="fixed"],body > .js-slide-in.is-active{display:none !important}',
  },
  "moteurnature.com": { j: "5" },
  "esn.com": { s: "#n_pop_overlayer,#n_cookie-popup{display:none !important}" },
  "hierhoudenwevan.nl": { c: 2 },
  "m.ugc.fr": { s: ".md-dialog-container{display:none !important}" },
  "nuxeo.com": { j: "5" },
  "bottegaverde.it": { c: 0 },
  "campagne.krant.nl": { j: "5" },
  "antjeroessler.de": { s: ".lawbar{display:none !important}" },
  "zappi.io": { j: "5" },
  "findmypast.com": {
    s: "#appRoot > div > div > div{display:none !important}",
  },
  "whatson.is": { s: ".elementor-location-popup{display:none !important}" },
  "mitsubishimotors.com.br": { s: ".cookies-header{display:none !important}" },
  "qitec.de": { s: "#QiCookieOptin{display:none !important}" },
  "player.hr": { s: ".popup_hr{display:none !important}" },
  "e-turysta.pl": { s: "#et-cookies-info{display:none !important}" },
  "dsdollrobotics.com": { j: "5" },
  "algarveholidayvillas.com": { s: ".cm-notice{display:none !important}" },
  "personaldienstleister.de": {
    s: 'div[id*="cookie_consent"]{display:none !important}',
  },
  "medicaltravelcompared.co.uk": {
    s: ".cookie-options{display:none !important}",
  },
  "opendataforafrica.org": { c: 3 },
  "newsletter2go.it": { s: "#hidecookien2go{display:none !important}" },
  "buyorbye.pl": { c: 0 },
  "kronehit.at": { j: "6" },
  "knoema.com": { c: 3 },
  "electrovoice.com": { c: 7 },
  "baldursgate3.game": { c: 0 },
  "frankfurt.de": { j: "6" },
  "jostchemical.com": { j: "5" },
  "ffm.to": { j: "5" },
  "tilda.cc": {
    s: '#t-footer > div > div[data-storage-item*="cookie"]{display:none !important}',
  },
  "download-manager.online": { s: ".cookie-bottom{display:none !important}" },
  "faire.fr": { s: "#cookieLab{display:none !important}" },
  "hackerrank.com": { j: "6" },
  "powershellgallery.com": { s: ".banner-notice{display:none !important}" },
  "dreammachines.pl": {
    s: "#qkies_info{display:none !important}",
    c: 14,
  },
  "mcdirect.com": { j: "5" },
  "pressdemocrat.com": { s: ".cph-ccpa_banner{display:none !important}" },
  "blackstonefootwear.com": { j: "5" },
  "dallasnews.com": {
    s: '#fusion-app > div[class^="app_banners"]{display:none !important}',
  },
  "consensys.net": {
    s: 'div[class*="notificationBar"]{display:none !important}',
  },
  "alugha.com": { s: "#root > div > footer ~ div{display:none !important}" },
  "mpbio.com": { c: 39 },
  "ghiseul.ro": { s: ".g-consent{display:none !important}" },
  "murata.com": {
    s: "#murata_gdpr_popup,#murata_gdpr_background{display:none !important}",
  },
  "playboy.com": { s: '#__next > div[style*="flex"]{display:none !important}' },
  "televisa.com": { s: "section.Privacy{display:none !important}" },
  "smartloop.be": { j: "5" },
  "calorieking.com": { s: "footer ~ .MuiPaper-root{display:none !important}" },
  "motocombo.pl": { j: "5" },
  "biker.wroclaw.pl": { s: "#cookies_apl{display:none !important}" },
  "burncoose.co.uk": { s: "#cNotice{display:none !important}" },
  "on.cc": { s: "#acceptDisclaimer{display:none !important}" },
  "elakolije.rs": { s: "#kolacic{display:none !important}" },
  "kundoc.com": { s: "#KUNDOCCOM_cookie_box{display:none !important}" },
  "erd.hu": { c: 3 },
  "print-idee.de": { s: "#CookieQuery{display:none !important}" },
  "thinktankphoto.com": { s: "#ttp-gdpr{display:none !important}" },
  "arclegal.co.uk": { s: ".pecr-message{display:none !important}" },
  "constantin-entertainment.de": { s: "#zcookie{display:none !important}" },
  "hohesalve.at": { s: ".c-window{display:none !important}" },
  "ukphonebook.com": { s: ".cookie-lightbox{display:none !important}" },
  "carsale24.com": { c: 0 },
  "zeta-producer.com": {
    s: "#consent,#consenttoggle{display:none !important}",
  },
  "moto-car.com.pl": { s: "#privacy-info-container{display:none !important}" },
  "alasatakunta.fi": { c: 1 },
  "volvopartswebstore.com": {
    s: ".notificationsDisplay{display:none !important}",
  },
  "reacapital.de": { c: 1 },
  "kfc.ru": { j: "6" },
  "waarmaarraar.nl": {
    s: "body > .container > div[style]{display:none !important}",
  },
  "ipill.de": { s: "#cookie-message ~ .design{display:none !important}" },
  "beep.es": { c: 0 },
  "speisekarte24.de": { s: "#dasu{display:none !important}" },
  "europa-vrachtwagens.nl": { c: 0 },
  "fh-muenster.de": { s: "#matomo-wrapper{display:none !important}" },
  "usedom.de": { s: "#header-notification{display:none !important}" },
  "geovelo.fr": { c: 32 },
  "raygun.com": { c: 148 },
  "bity.com": { c: 124 },
  "schneehoehen.de": { c: 0 },
  "herefordshire.gov.uk": { s: ".hc-cookies{display:none !important}" },
  "2plus2.ua": {
    s: "#page-2plus2.show-cookies{padding-top:0 !important}#page-2plus2.show-cookies .header{top:0 !important}",
  },
  "ecmguide.de": { c: 4 },
  "foodgroot.com": { c: 64 },
  "notebookinfo.de": { c: 4 },
  "oberlo.es": { s: "#oberloGdpr{display:none !important}" },
  "nalogia.ru": { s: ".b-person-data{display:none !important}" },
  "thawte.de": { c: 139 },
  "thawte.com": { c: 139 },
  "britrail.net": { c: 17 },
  "unaparolaalgiorno.it": { c: 2 },
  "xfarma.it": { c: 17 },
  "getresponse.com": { c: 6 },
  "poneranuncios.com": { s: "#index_cookies{display:none !important}" },
  "medlon.nl": { s: "#globalmessage_holder{display:none !important}" },
  "villaguardia.co.it": { c: 0 },
  "pcx.hu": { s: ".cookieFlyer{display:none !important}" },
  "paper.li": { s: "#info_banner,.MuiSnackbar-root{display:none !important}" },
  "wohr.com.au": { c: 0 },
  "digitick.com": { c: 113 },
  "reallygoodemails.com": { j: "5" },
  "huiles-et-sens.com": {
    s: 'body > div[id^="webp_popup_banner"]{display:none !important}',
  },
  "ssi.dk": { c: 2 },
  "newsday.com": { s: ".policy-alert{display:none !important}" },
  "milestonesrl.com": { c: 40 },
  "wisdy.co": { s: "#__next > .modal{display:none !important}" },
  "bellflight.com": { s: ".bg-gold.active{display:none !important}" },
  "mysimpleshow.com": { j: "5" },
  "dfinity.org": { s: "#gdpr-panel{display:none !important}" },
  "kirchengemeindeverband-koenigslutter.de": { c: 133 },
  "activtrak.com": { c: 3 },
  "dziennikwschodni.pl": { s: ".rodo-modal{display:none !important}" },
  "russellscanlan.com": { s: "#wp-notification{display:none !important}" },
  "podbean.com": { c: 1 },
  "neff-home.com": { j: "5" },
  "the12volt.com": { j: "5" },
  "maje.com": { s: ".donottrackBanner{display:none !important}" },
  "radiodienste.de": { j: "6" },
  "indicator.be": { s: ".cpolicy{display:none !important}" },
  "matrixgames.com": {
    s: ".globalAnnouncement,.blockingOverlay{display:none !important}",
  },
  "slitherine.com": {
    s: ".globalAnnouncement,.blockingOverlay{display:none !important}",
  },
  "thinglink.com": { s: "#tlCommonGdprBanner{display:none !important}" },
  "gfoe-conference.de": { s: "#sb-container{display:none !important}" },
  "specialdeal.at": { c: 2 },
  "wbkidsgo.com": { s: "#onetrust-outer{display:none !important}" },
  "anaciroma.it": { s: ".w2t-banner{display:none !important}" },
  "speicherguide.de": { c: 4 },
  "tvmalbork.pl": { j: "5" },
  "codesignal.com": { c: 5 },
  "cyfronika.com.pl": { c: 0 },
  "tiermaker.com": { s: "#agreementMessage{display:none !important}" },
  "oberharz.de": {
    s: ".consent-popup--bg,.consent-popup{display:none !important}",
  },
  "amw.com.pl": { c: 0 },
  "ggmgastro.com": { s: "ggm-cookie-hint{display:none !important}" },
  "rigb.org": { c: 2 },
  "horesta.dk": { c: 0 },
  "edge.pse.com.ph": { c: 47 },
  "hit-electronics.com": { c: 4 },
  "donauversicherung.at": { s: ".cookies,app-cookie{display:none !important}" },
  "xel.nl": { c: 6 },
  "wer-kennt-wen.net": { s: ".CookieLayout{display:none !important}" },
  "informiert.at": { s: ".CookieLayout{display:none !important}" },
  "odmladzanienasurowo.com": { c: 64 },
  "radiologie-dachau.de": { s: "#zcookie{display:none !important}" },
  "metrofixings.co.uk": { c: 0 },
  "heycar.co.uk": {
    s: '#app div[class*="ConsentManager"]{display:none !important}',
  },
  "larosiere.net": { c: 0 },
  "megasvet.cz": { c: 5 },
  "pkobp.pl": {
    s: "#pko-cookie-rodo,.js-ajax-overlay{display:none !important}",
  },
  "ass-team.net": { s: ".v-banner--sticky{display:none !important}" },
  "bardonecchiaski.com": { s: ".jconfirm{display:none !important}" },
  "nik.gov.pl": { s: ".informationBar{display:none !important}" },
  "verkehrsinformation.de": {
    s: ".growl-bottom .alert{display:none !important}",
  },
  "londonreal.tv": { s: "#notify-consent{display:none !important}" },
  "pineline.fi": { c: 7 },
  "wieisdemol.be": { s: "#cover-div{display:none !important}" },
  "xometry.com": { s: "#lo-privacy-banner{display:none !important}" },
  "comau.com": { c: 155 },
  "print24.com": { c: 155 },
  "animalchannel.co": { s: ".consent-box{display:none !important}" },
  "hallofbrands.gr": {
    s: "#gdpr-modal{display:none !important}",
    c: 14,
  },
  "marokko.nl": { j: "5" },
  "universiteitleiden.nl": { j: "5" },
  "icould.com": { j: "5" },
  "sofifa.com": {
    s: ".wrapper .bp3-callout.bp3-intent-danger{display:none !important}",
  },
  "stryker.com": { j: "5" },
  "direktno.rs": { s: "#saglasnost-container{display:none !important}" },
  "secunews.be": { s: ".pix-wrapper.pix-accept{display:none !important}" },
  "otto-office.com": {
    s: "#top-notification_accept-machmichweg-guidelines,.ooB-black-overlay-machmichweg{display:none !important}",
  },
  "spoonflower.com": {
    s: ".b-text-box.x-global-dialog{display:none !important}",
  },
  "htc.com": { c: 6 },
  "atramentowka.com": { c: 0 },
  "econsteel.de": { c: 0 },
  "eumobil.hu": { c: 2 },
  "bonpreuesclat.cat": {
    s: '.site--content > div[class*="toast"]{display:none !important}',
  },
  "propaganda.co.uk": { c: 156 },
  "e-reporter.pl": { c: 156 },
  "zh.ch": { s: "agb-bar{display:none !important}" },
  "onbeperktinbeweging.nl": { s: ".cookie__wall{display:none !important}" },
  "angouleme.fr": { c: 29 },
  "gokarting.com.pl": { c: 29 },
  "hallo-meinung.de": { c: 29 },
  "intothegrave.nl": { c: 29 },
  "kijkonderzoek.nl": { c: 29 },
  "meaculpa.gr": { c: 29 },
  "poesslforum.de": { c: 29 },
  "rover.nl": { c: 29 },
  "superconstellation.org": { c: 29 },
  "cityoflondon.gov.uk": {
    s: ".container-floating-notifications{display:none !important}",
  },
  "fusemagazine.com": { s: ".sqs-widget{display:none !important}" },
  "womex.com": { j: "5" },
  "kivra.se": { j: "5" },
  "scandalbeauties.com": { s: "#attention-msg{display:none !important}" },
  "theater-altenburg-gera.de": { s: "#cookie-row{display:none !important}" },
  "theaterhagen.de": { s: "#cookie-row{display:none !important}" },
  "ebz-bildung.de": { c: 2 },
  "fbhvc.co.uk": { c: 0 },
  "hackdoor.io": { c: 69 },
  "fh-dortmund.de": { c: 0 },
  "lifebutiken.se": {
    s: "#top-anchor ~ div ~ div:last-child{display:none !important}",
  },
  "cafe.se": { c: 6 },
  "psychicmonday.com": { c: 147 },
  "beuc.eu": { s: ".beuc-cookie{display:none !important}" },
  "ischias.se": { s: "#consent-wrap{display:none !important}" },
  "baza.io": { c: 0 },
  "toctoc.me": { s: ".toctoc-cookie{display:none !important}" },
  "dailymail.co.uk": {
    s: ".dailymailcouk-cookie-notification{display:none !important}",
  },
  "challengethebrain.com": { c: 145 },
  "gaffelamdom.de": { c: 2 },
  "so-magazyn.pl": { j: "5" },
  "9292.nl": {
    s: "#genericModal{display:none !important}",
    c: 14,
  },
  "scrum.org": { s: ".privacy-toast{display:none !important}" },
  "fanatical.com": { s: ".cookie-collapsible{display:none !important}" },
  "metallumnovum.lt": { s: "#parent-container-idgy{display:none !important}" },
  "dplay.nl": { s: "#header-wrapper ~ dialog{display:none !important}" },
  "umcutrecht.nl": { j: "5" },
  "werkenbijumcutrecht.nl": { c: 0 },
  "utrop.no": { s: ".wppopups-whole{display:none !important}" },
  "techcafe.nl": { j: "5" },
  "skb.si": { j: "5" },
  "papajohns.es": {
    s: '#root > div > div[class*="snackbar"]{display:none !important}',
  },
  "episerver.de": { c: 6 },
  "codeherent.tech": { c: 32 },
  "newscientist.com": { s: ".prompt--modal.section{display:none !important}" },
  "bbb.org": { s: "body > .MuiDrawer-root{display:none !important}" },
  "gadventures.com": { s: ".privacy-control{display:none !important}" },
  "teleticketservice.com": { s: ".ts-header-message{display:none !important}" },
  "siepomaga.pl": { c: 0 },
  "nodecheck.io": { s: "footer > .fixed-bottom{display:none !important}" },
  "1blu.de": { j: "5" },
  "bonify.de": { s: '#__next [class*="UserConsent"]{display:none !important}' },
  "krunker.io": { j: "5" },
  "creditkarma.co.uk": { j: "6" },
  "dofsimulator.net": { j: "6" },
  "bankcomat.org": { s: ".cucheck{display:none !important}" },
  "naukri.com": { c: 26 },
  "refoweb.nl": { j: "5" },
  "canaldigital.se": { j: "5" },
  "studienstiftung.de": { j: "5" },
  "vdk.de": { s: "#DSE{display:none !important}" },
  "lektury.gov.pl": { j: "5" },
  "androidapplications.ru": { s: ".user-agreement{display:none !important}" },
  "hawle.de": { j: "5" },
  "scamadviser.com": { s: ".cookie-nav{display:none !important}" },
  "omictools.com": { j: "5" },
  "steller.co": { s: "#root > div[class]{display:none !important}" },
  "trombocyter.se": { s: "#consent-wrap{display:none !important}" },
  "grunerundjahr.de": { c: 2 },
  "nytco.com": { s: ".a-cookie{display:none !important}" },
  "keesvanderspek.nl": { c: 0 },
  "vier-pfoten.de": { j: "5" },
  "rhymes.org.uk": { c: 145 },
  "etos.nl": { j: "5" },
  "aucoffre.com": { j: "5" },
  "fino.hr": { c: 0 },
  "beres.hu": { s: "#cookieContent,#cookieBtn{display:none !important}" },
  "mygovid.ie": { s: ".mygovid-overlay{display:none !important}" },
  "bazzar.hr": { j: "5" },
  "player.fm": { j: "5" },
  "gamer.nl": { j: "5" },
  "dehn.de": { j: "6" },
  "pzonline.com": { s: ".disclaimers{display:none !important}" },
  "inexio.net": { s: "app-popup{display:none !important}" },
  "hettalentenhuis.nl": { j: "5" },
  "tecnolatte.it": { s: "#page_hider{display:none !important}" },
  "marikakonyhaja.hu": { s: "#cookieblokk{display:none !important}" },
  "dn.no": { s: "#dninvestor-cookie-info{display:none !important}" },
  "telekom-dienste.de": { j: "5" },
  "future-x.de": { j: "5" },
  "wargaming.net": { s: ".warning-bar{display:none !important}" },
  "faidatehobby.it": { j: "5" },
  "queengarnet.com": { s: "header ~ .is-active{display:none !important}" },
  "cottonon.com": { j: "5" },
  "flintbek.de": { c: 117 },
  "surewise.com": { s: "#disclosure{display:none !important}" },
  "stat.si": { j: "5" },
  "quectel.com": { c: 0 },
  "gsk-gebro.at": { j: "5" },
  "m.bancopopular.com": { j: "5" },
  "wealdtech.com": { s: "#weald-gdpr-container{display:none !important}" },
  "portal.lanis-system.de": { c: 7 },
  "zeit.de": { j: "5" },
  "astro.com": { s: ".botbanner,#priv.dsmessage{display:none !important}" },
  "magyarorszag.hu": { j: "6" },
  "zee5.com": { j: "5" },
  "overdrive.com": { j: "5" },
  "thefork.it": { s: "#root > div > p{display:none !important}" },
  "strawpoll.me": { j: "5" },
  "alldomains.hosting": {
    s: "#adh-cookie-dnt,#adh-cookie-accept{display:none !important}",
  },
  "openuserjs.org": { c: 7 },
  "hobbyfarms.com": { s: ".cookieTkd{display:none !important}" },
  "condor.com": { s: ".cookie__bg{display:none !important}" },
  "helloclue.com": {
    s: "#gatsby-focus-wrapper > section:first-child{display:none !important}",
  },
  "coolmath.com": { j: "5" },
  "thegoodnessproject.co.uk": {
    s: "#cookies_enabled{display:none !important}",
  },
  "gruener-punkt.de": { j: "5" },
  "starmix.de": { s: "#muffin{display:none !important}" },
  "staedteregion-aachen.de": { s: "#cookiehuhu{display:none !important}" },
  "fega-schmitt.de": { j: "5" },
  "astro.hr": { j: "5" },
  "oberlo.com": { s: "#oberloGdpr{display:none !important}" },
  "steinhandel.no": { c: 90 },
  "dfds.com": { j: "6" },
  "idp.funktionstjanster.se": { j: "5" },
  "playvalorant.com": { s: ".riotbar-alert{display:none !important}" },
  "formyrights.eu": { c: 14 },
  "oster-gewinnspiele.de": { c: 81 },
  "hwbox.gr": { c: 40 },
  "top10vpn.com": { s: "#notification-bar{display:none !important}" },
  "pioneerdj.com": { c: 0 },
  "tides4fishing.com": { c: 0 },
  "leszno.pl": { c: 0 },
  "edgeent.com": { s: "#caja_flotante{display:none !important}" },
  "edgeent.fr": { s: "#caja_flotante{display:none !important}" },
  "tanie-leczenie.pl": { c: 68 },
  "regnauer.de": { c: 8 },
  "catchandrelease.com": {
    s: "#react-container > main > footer{display:none !important}",
  },
  "asustor.com": { s: "#gdpr_wrap{display:none !important}" },
  "getabstract.com": { s: ".notifybar--note{display:none !important}" },
  "akatronik.at": { c: 106 },
  "motionvfx.com": { c: 39 },
  "izotcomputers.com": { s: 'body [id^="aiva"]{display:none !important}' },
  "akvarista.cz": { s: "#topcookies{display:none !important}" },
  "consent.talpanetwork.com": { j: "5" },
  "ristorantino.no": {
    s: ".privacy-policy-container{display:none !important}",
  },
  "datacamp.com": { s: ".dc-cookie-banner-wrapper{display:none !important}" },
  "gezondheidsplein.nl": { j: "5" },
  "photoeffets.com": { s: "#TopSubscriptionPopUpBg1{display:none !important}" },
  "photoeffekte.com": {
    s: "#TopSubscriptionPopUpBg1{display:none !important}",
  },
  "leds-boutique.fr": { s: "#event_banner{display:none !important}" },
  "sosoitaly.com": { s: "#event_banner{display:none !important}" },
  "versailles.fr": { c: 23 },
  "king.com": {
    s: "#SiteMessages{display:none !important}.hasInfoHeader #PageContainer{top:0 !important}",
  },
  "planetkey.de": { s: ".alert-box{display:none !important}" },
  "setn.com": { s: ".privacy-area{display:none !important}" },
  "foxnews.com": { s: ".notification-banner{display:none !important}" },
  "revistainforetail.com": { j: "5" },
  "turn-keytechnologies.com": { s: ".b--cookies{display:none !important}" },
  "arbeiterkammer.at": { j: "5" },
  "alphr.com": { j: "5" },
  "videomapster.com": { s: ".privacy-box{display:none !important}" },
  "wunderground.com": { c: 32 },
  "swietawdomu.pl": { j: "5" },
  "linuxhandbook.com": { c: 108 },
  "tarnkappe.info": { j: "6" },
  "bbc.co.uk": {
    s: '#root > #header-content > div > div[class*="DialogBackdrop"]{display:none !important}',
  },
  "werkenindelandentuinbouw.nl": { c: 27 },
  "myki.com": { c: 0 },
  "hanover.com": { j: "5" },
  "delibio.fr": { c: 2 },
  "dollargeneral.com": { c: 149 },
  "patook.com": { s: "#cookies_subtext{display:none !important}" },
  "hpicheck.com": { s: "#toasts-container{display:none !important}" },
  "clubmed.fr": { s: ".Layout > .fixed{display:none !important}" },
  "xsports.lv": { j: "5" },
  "pvcvoordeel.nl": { j: "5" },
  "latestdeals.co.uk": {
    s: "#root > div > main + div{display:none !important}",
  },
  "audirvana.com": { c: 5 },
  "dvb-t2-portal.de": { s: "#coPolicyMain{display:none !important}" },
  "countwordsfree.com": { c: 8 },
  "s2studio.cz": { c: 0 },
  "genesis-mining.com": { c: 0 },
  "octapharma.com": { j: "5" },
  "rttshirts.de": { c: 60 },
  "alfabusinessweek.ru": {
    s: '#t-footer > div[style*="padd"]{display:none !important}',
  },
  "511tactical.com": { j: "5" },
  "skoledo.com": { s: ".avg{display:none !important}" },
  "spor.dk": { c: 0 },
  "uwafot.de": { c: 29 },
  "akasha.world": { s: "#gatsby-focus-wrapper > div{display:none !important}" },
  "certideal.com": { j: "5" },
  "rp-giessen.de": { s: "footer .note{display:none !important}" },
  "vakmedianet.nl": { j: "5" },
  "healthifyme.com": { s: "#popup-wrapper{display:none !important}" },
  "dlford.io": {
    s: "#gatsby-focus-wrapper > div > footer{display:none !important}",
  },
  "buerger.de": {
    s: "#consent-modal,.reveal-modal-bg{display:none !important}",
  },
  "ncov2019.live": { s: "#dcon-gdpr-container{display:none !important}" },
  "all-hashtag.com": { c: 152 },
  "natuurfotografie.nl": { s: "#cookieSettings{display:none !important}" },
  "fastighetsbyran.com": {
    s: "#root > div > section > div > .w-full{display:none !important}",
  },
  "belsat.eu": { j: "5" },
  "gazetabilgoraj.pl": { j: "5" },
  "medirect.com.mt": { j: "5" },
  "medirect.be": { j: "5" },
  "justhalal.dk": { s: "#fullscreen-container{display:none !important}" },
  "123gold.de": { s: "#OptOut{display:none !important}" },
  "gp-tuning.at": { j: "5" },
  "weblager.dk": { j: "5" },
  "kentbank.hr": {
    s: "#overlayCookie,#overlayContentCookie,.otvori_cookie_dialog{display:none !important}",
  },
  "monolith.xyz": {
    s: "#root > main > footer > div:first-child{display:none !important}",
  },
  "ideal-versicherung.de": { s: "#content-top{display:none !important}" },
  "nortonrosefulbright.com": {
    s: ".nrf-disclaimer{display:none !important}.nrf-disclaimer + .fixed-top{top:0 !important}",
  },
  "medeqstars.ru": { s: "#use-cookies{display:none !important}" },
  "vassla.com": {
    s: "#gatsby-focus-wrapper > .fixed{display:none !important}",
  },
  "famework.io": { c: 9 },
  "aioinissaydowa.eu": { c: 0 },
  "fesztivalonkentes.hu": { s: ".fo-cookie{display:none !important}" },
  "granice.pl": { j: "5" },
  "antiquite-neuvillefranck.fr": { j: "5" },
  "tego.fr": { s: ".fixed-bottom{display:none !important}" },
  "2x2tv.ru": { s: ".cook-web{display:none !important}" },
  "sufilog.com": { j: "5" },
  "bien-zenker.de": { j: "5" },
  "icontext.ru": { s: ".policy-disclaimer{display:none !important}" },
  "travelrepublic.co.uk": {
    s: ".sc-c-panel--offset.sc-c-panel--disable-gutters-x{display:none !important}",
  },
  "thewinecellarinsider.com": { j: "5" },
  "sparkassen-direkt.de": { j: "5" },
  "zst-tarnow.pl": { j: "5" },
  "celo.org": { j: "6" },
  "kognitio.com": { j: "5" },
  "readymag.com": { s: ".widget-rm-cookies{display:none !important}" },
  "test-achats.be": { j: "5" },
  "cloudeng.it": {
    s: ".commons-alert-box,.commons-alert-overlay{display:none !important}",
  },
  "bearable.app": { c: 5 },
  "caixabank.cat": { s: ".cookies-region{display:none !important}" },
  "caixabank.es": { s: ".cookies-region{display:none !important}" },
  "sixt.co.uk": { s: ".cro-background-shadow{display:none !important}" },
  "pruadviser.co.uk": { j: "5" },
  "uslugi.gov.mk": { c: 3 },
  "axa-im.fr": { j: "5" },
  "specialarad.ro": { c: 0 },
  "designingbuildings.co.uk": {
    s: "#overlay-designingBuildingsAnywhere{display:none !important}",
  },
  "unitedway.org": { s: ".footer-notification{display:none !important}" },
  "epri.com": { s: ".cookie-sheet,.md-scroll-mask{display:none !important}" },
  "moddrop.com": { s: "#app > .cm-row{display:none !important}" },
  "weerstatistieken.nl": { s: "#darker{display:none !important}" },
  "weather-gb.com": { j: "5" },
  "silicagel.de": { c: 1 },
  "verkuendung-bayern.de": {
    s: ".vkp-cookie-message{display:none !important}",
  },
  "brugge.be": { j: "5" },
  "clipartlogo.com": { c: 141 },
  "clipart.me": { c: 141 },
  "toestemming.ndcmediagroep.nl": { j: "5" },
  "freeletics.com": { j: "6" },
  "rynek-turystyczny.pl": { j: "5" },
  "der-farang.com": { j: "5" },
  "sweet.tv": { s: "#privacy_policy{display:none !important}" },
  "enzahome.com.tr": { s: ".kvkkFixed{display:none !important}" },
  "eduelo.pl": { j: "6" },
  "homeairguides.com": { c: 156 },
  "wunderino.com": {
    s: '#root div[class*="Snackbar"]{display:none !important}',
  },
  "everettspharmacy.co.uk": {
    s: "body > div[class]:not([style]):not([id]){display:none !important}",
  },
  "po-bandzie.com.pl": { c: 5 },
  "mesenzo.com": {
    s: "#OneTimePopupDialog,.OneTimePopupDialog-overlay{display:none !important}",
  },
  "diplomeo.com": { c: 6 },
  "bankgiroloterij.nl": { s: "#avgDialog{display:none !important}" },
  "norwegianreward.com": { j: "5" },
  "bsd.net": {
    s: 'div[data-which-id="eprivacy-banner"]{display:none !important}',
  },
  "hudy.cz": { s: ".info-bar{display:none !important}" },
  "top-trails-of-germany.de": { s: "footer .note{display:none !important}" },
  "neatorobotics.com": { s: "#neato_cp_notice{display:none !important}" },
  "geers.pl": { s: ".ConsentWrapper{display:none !important}" },
  "oney.pt": { j: "5" },
  "jacob.de": { s: "#jcc-consent{display:none !important}" },
  "portel.pl": { s: "#rodoCover{display:none !important}" },
  "clausporto.com": { s: "#gdpr-popup-modal{display:none !important}" },
  "onassis.org": {
    s: "#js-content > div > .relative > .bg-blue{display:none !important}",
  },
  "puppet.com": {
    s: ".pm-gdpr,.puppet-cookie-banner{display:none !important}",
  },
  "atal.pl": { j: "5" },
  "freudtools.com": { s: ".x-consent{display:none !important}" },
  "sanook.com": { s: "#__next > div > footer ~ div{display:none !important}" },
  "atu.de": { s: "#App .notificationBar{display:none !important}" },
  "prodyna.com": { j: "6" },
  "prodyna.ch": { j: "6" },
  "prodyna.at": { j: "6" },
  "prodyna.co.uk": { j: "6" },
  "icscards.nl": {
    s: 'body > [style*="brightness(50%)"]{filter:brightness(100%) !important}',
  },
  "magio.tv": {
    s: "#root > div[style]:not([class]):not([id]){display:none !important}",
  },
  "udemy.com": {
    s: ".ud-component--footer--eu-cookie-message{display:none !important}",
  },
  "financialexpress.com": {
    s: 'div[id^="google_ads_iframe"][id*="GDPR"]{display:none !important}',
  },
  "coinloan.io": { c: 0 },
  "nettbuss.no": { s: ".header__banner{display:none !important}" },
  "vodi.cc": { c: 0 },
  "work-discount.de": { c: 1 },
  "zawady19.pl": { c: 7 },
  "computacenter.com": { c: 157 },
  "sentinelprotocol.io": { c: 157 },
  "raumausbeute.de": { c: 60 },
  "lecourrierdelatlas.com": { s: ".cda_oic{display:none !important}" },
  "tacobot.tf": { c: 49 },
  "divvydiary.com": { s: "footer ~ .fixed{display:none !important}" },
  "zwolen.pl": { j: "5" },
  "boursorama.fr": { c: 0 },
  "superdrug.com": { j: "5" },
  "yoump3.app": { j: "5" },
  "gorillasports.co.uk": { c: 8 },
  "keideltherme.de": { c: 6 },
  "pancernik.eu": { c: 0 },
  "electromag.pl": { c: 0 },
  "fimportal.de": { c: 0 },
  "zeoob.com": { j: "5" },
  "nokautmoto.pl": {
    s: "#plugin-agree-Plugin,#GDPRModal{display:none !important}",
  },
  "nokaut.pl": {
    s: "#plugin-agree-Plugin,#GDPRModal{display:none !important}",
  },
  "talonai.lt": { s: "#root ~ div{display:none !important}" },
  "tracker.com": { s: ".ccModal{display:none !important}" },
  "pocztapolska24.pl": { j: "5" },
  "cooptravel.co.uk": { s: ".mailmunch-topbar{display:none !important}" },
  "hit.ro": { s: ".cookie_2019{display:none !important}" },
  "audiocite.net": { s: 'div[class*="fondcookies"]{display:none !important}' },
  "ldlc-pro.be": { s: "#privacy{display:none !important}" },
  "mixtools.pl": { c: 0 },
  "aktiefonline.nl": { s: "#avg-container{display:none !important}" },
  "spolem.olawa.pl": { c: 5 },
  "yespresso.it": { c: 60 },
  "conradconnect.com": { j: "5" },
  "budapestbank.hu": { j: "5" },
  "cupsell.pl": { j: "5" },
  "ergonbike.com": { s: "#tracking-modal{display:none !important}" },
  "cloudhealthtech.com": { j: "5" },
  "icomjapan.com": { c: 0 },
  "maklarf.se": { s: ".uk-notify{display:none !important}" },
  "visionsdureel.ch": { c: 2 },
  "puressentiel.com": { j: "5" },
  "booksy.com": {
    s: '#page > footer ~ div[class^="purify"]{display:none !important}',
  },
  "roms-download.com": { j: "5" },
  "sherwin-williams.com": { s: "#termsModal{display:none !important}" },
  "makelaarsland.nl": {
    s: ".is-cookie-notice::before{display:none !important}",
  },
  "botmasterlabs.net": { c: 26 },
  "ello.co": { s: ".AppContainer > nav + div{display:none !important}" },
  "devrans-schwelm.de": { c: 2 },
  "coolbird.nl": { c: 0 },
  "militarne.pl": { c: 0 },
  "distractify.com": { s: "#_ConsentBanner{display:none !important}" },
  "aave.com": { s: ".LegalBanner{display:none !important}" },
  "reference-gaming.com": {
    s: "#appMountPoint-cookies{display:none !important}",
  },
  "create-connectivity.com": { s: ".rstbox{display:none !important}" },
  "kieskeurig.nl": { j: "5" },
  "forumactif.org": { j: "6" },
  "bienwaldfitness.de": { j: "5" },
  "wissensnetz.dosb.de": { c: 0 },
  "store.leica-camera.com": { j: "5" },
  "leica-camera.com": { s: ".fullscreen{display:none !important}" },
  "lightblock.me": { s: "#div-policy-acception{display:none !important}" },
  "lickd.co": { s: "#root > div > div:last-child{display:none !important}" },
  "defiexplore.com": { c: 34 },
  "jejsklep.pl": {
    s: "#tws_i_100000,#topLayerBackDrop{display:none !important}",
  },
  "adrenaline.pl": {
    s: "#tws_i_100000,#topLayerBackDrop{display:none !important}",
  },
  "kolarzyk.pl": { s: "#cookie_info_kl{display:none !important}" },
  "virginbet.com": {
    s: ".virginbetSportsRoot > div > div:last-child{display:none !important}",
  },
  "dnb.com": { s: "header .banner{display:none !important}" },
  "matines.com": { j: "5" },
  "advaniadc.com": { s: ".adc__cookie-consent{display:none !important}" },
  "premiumkino.de": { j: "5" },
  "classification.gov.au": {
    s: '.views-row > div[style*="F6C257"]{display:none !important}',
  },
  "abc.com": { c: 143 },
  "tw-calc.net": { c: 2 },
  "solutions-numeriques.com": { c: 0 },
  "xn--strungsauskunft-9sb.de": { s: "#welcome{display:none !important}" },
  "alcatelmobile.com": {
    s: '.elementor-location-footer ~ div[class*="astra"],.acepta-cookies{display:none !important}',
  },
  "domodi.pl": { j: "5" },
  "telekom.de": {
    s: "#cookies.bounceInDown,.pi-notification{display:none !important}",
  },
  "top-dent.cz": { s: "body > .CA{display:none !important}" },
  "montersi.pl": { s: ".motersi-cookie-notice{display:none !important}" },
  "anhaenger-bayern.de": { s: "#privacyPolicyWindow{display:none !important}" },
  "betsson.com": { c: 32 },
  "pubpub.org": { s: ".legal-banner-component{display:none !important}" },
  "voterrecords.com": { s: ".tosbox-container{display:none !important}" },
  "bonami.ro": { s: ".productWatchdog + .rcic{display:none !important}" },
  "audiofan.eu": { c: 0 },
  "rylko.com": { c: 7 },
  "mp4repair.org": { s: "#light,#fade{display:none !important}" },
  "iproeb.ro": { s: "#gg{display:none !important}" },
  "ponovnauporaba.si": { c: 0 },
  "svo.aero": { c: 2 },
  "citizenticket.co.uk": {
    s: '#haveacookie[action*="cookie-policy"]{display:none !important}',
  },
  "geefvoorzorgverleners.nl": { j: "5" },
  "austrianairlines.ag": { s: ".ym-wrapper > .cop{display:none !important}" },
  "igbce.de": { j: "5" },
  "techguard.ie": { c: 13 },
  "arenamall.hu": { s: "#cp-bg,#cp-content{display:none !important}" },
  "virginholidays.co.uk": { s: ".mvh-gdpr-banner{display:none !important}" },
  "portuguesemask.com": {
    s: '.bl-section[data-bl-name*="cookies"]{display:none !important}',
  },
  "flevoland.nl": { c: 6 },
  "altomdinhelse.no": { j: "5" },
  "kioskbt.ru": { s: ".info-massage{display:none !important}" },
  "monterail.com": {
    s: ".topbar__cta_full,.extended-topbar .topbar{display:none !important}",
  },
  "polarbackup.com": {
    s: ".cp-slidein-popup-container{display:none !important}",
  },
  "fotav.hu": { s: ".consent__dialog{display:none !important}" },
  "ocs.fr": { j: "5" },
  "apqs.com": { s: ".cookieable{display:none !important}" },
  "lm.be": { j: "5" },
  "swipbox.com": { j: "5" },
  "omnifurgone.it": { c: 102 },
  "ercomer.pl": { c: 0 },
  "mobilpakke.dk": { s: ".menuCookie{display:none !important}" },
  "4gamers.be": { j: "5" },
  "betvictor.com": { s: ".bvs-overlay{display:none !important}" },
  "m.leroymerlin.pl": { j: "5" },
  "extraessay.com": { s: ".cc_info{display:none !important}" },
  "vitra.com": { j: "6" },
  "stormkit.io": { s: ".modal-overlay.fixed{display:none !important}" },
  "mind-ware.nl": {
    s: ".dcd-avg-banner,.dcd-avg-banner-bg{display:none !important}",
  },
  "eyescan.nl": { s: ".cookie-cta{display:none !important}" },
  "wiesenhof-online.de": { s: ".wsh-cookie-overlay{display:none !important}" },
  "themisbar.com": { j: "5" },
  "josephmoog.com": { c: 64 },
  "vils.at": { s: ".cookieErrorBox{display:none !important}" },
  "e-marcom.pl": { c: 33 },
  "bielawa.pl": { s: "#wiadomosccookie{display:none !important}" },
  "educationplatform.co.uk": {
    s: '#App > div > .container ~ div[class^="Wrap"]:last-child{display:none !important}',
  },
  "mi-home.no": { c: 0 },
  "correosexpress.pt": { j: "5" },
  "correosexpress.com": { j: "5" },
  "cexpr.es": { j: "5" },
  "stoiximan.gr": { s: ".sticky-notification{display:none !important}" },
  "muenzenwert.de": { s: "#callout{display:none !important}" },
  "usi.it": { j: "6" },
  "changehero.io": { s: ".privacy-notify{display:none !important}" },
  "northamptonshiresurprise.com": {
    s: "#popupbanner{display:none !important}",
  },
  "animade.tv": {
    s: 'body > div[data-react-class="Cookies"]{display:none !important}',
  },
  "localsearch.ch": { c: 146 },
  "orcd.co": { j: "5" },
  "mobilevikings.be": { j: "5" },
  "gyproc.it": { c: 8 },
  "gokom.eu": { s: "#gokom-cookies{display:none !important}" },
  "gfycat.com": {
    s: '.toast-notification[class*="privacy"],.announcement-banner{display:none !important}',
  },
  "onecall.no": { j: "5" },
  "mycall.no": { j: "5" },
  "xercise4less.co.uk": { j: "6" },
  "joeallen.co.uk": { s: "#wp-notification{display:none !important}" },
  "nhc.no": { s: "#dpm-consent-form{display:none !important}" },
  "inyourarea.co.uk": { j: "6" },
  "gardeningknowhow.com": { c: 4 },
  "sato.fi": {
    s: "#app-container > div > .hide-on-print > div{display:none !important}",
  },
  "aide.fi": { c: 42 },
  "bonprix.pl": { s: "#JOISH987_bar{display:none !important}" },
  "grenscorridorn69.nl": { c: 49 },
  "polskikoszyk.pl": { s: "body.cookie .topbar{top:0 !important}" },
  "play.pl": { s: ".cookies-mine{display:none !important}" },
  "acerta.be": { j: "5" },
  "hearingaidknow.com": { c: 3 },
  "coolors.co": { s: ".banner.is-visible{display:none !important}" },
  "popnable.com": { s: "#roar-alert{display:none !important}" },
  "hansaplast.ch": { c: 13 },
  "hansaplast.hu": { c: 13 },
  "hansaplast.de": { c: 13 },
  "hansaplast.es": { c: 13 },
  "hansaplast.nl": { c: 13 },
  "hansaplast.it": { c: 13 },
  "hansaplast.com": { c: 13 },
  "lg.com": { s: "#cookieAllPc,.dimmed{display:none !important}" },
  "minnemi.no": { c: 148 },
  "dideo.ir": { s: ".youtube-terms-banner{display:none !important}" },
  "claptzu.de": { s: "#cp-inner{display:none !important}" },
  "wolfgangkrebs.com": { c: 5 },
  "belarus24.by": { c: 0 },
  "kuntarekry.fi": { c: 13 },
  "theregister.com": { s: "#RegCTBWF{display:none !important}" },
  "switcher-shop.ch": { c: 60 },
  "contofacto.it": { j: "5" },
  "kawasaki.de": { j: "5" },
  "pldspace.com": { c: 29 },
  "tum.de": { c: 158 },
  "loading.io": {
    s: '.position-fixed[ld-scope="cookie-consent"]{display:none !important}',
  },
  "lohi.de": { s: "#lohiConsent{display:none !important}" },
  "opti-wohnwelt.de": {
    s: '.accContentWrapper div[class*="gdprBar"]{display:none !important}',
  },
  "123stahl-shop.de": { s: "#cookieholder{display:none !important}" },
  "quickappninja.com": {
    s: "#qan-cookie-policy-gdpr{display:none !important}",
  },
  "halebop.se": { j: "5", c: 85 },
  "packback.co": { j: "5" },
  "e-armet.pl": { c: 0 },
  "cb500.net": { s: "#keks{display:none !important}" },
  "ronproject.com": { s: ".consent-box{display:none !important}" },
  "schuhe-mustang.at": { c: 0 },
  "india.com": { s: "#co-container{display:none !important}" },
  "vapstore.de": { s: "#header-promo{display:none !important}" },
  "ueberlingen-bodensee.de": { c: 159 },
  "redbook.com.au": { j: "5" },
  "ipass4sures.com": { s: "#blockCookie{display:none !important}" },
  "polskieradio.pl": {
    s: ".rodo,.footer ~ .termsOfUse,.rodo-modal{display:none !important}",
  },
  "radkutsche.de": { s: "#pc{display:none !important}" },
  "vrporn.com": { s: ".noticepopup{display:none !important}" },
  "yodot.com": { s: ".yodotcookienotice{display:none !important}" },
  "moonpig.com": {
    s: "#__next > div:not([data-testid]):first-child{display:none !important}",
  },
  "forum-generationmobiles.net": {
    s: "#fb-root ~ div[id]:not(class){display:none !important}",
  },
  "tacticasdechoque.com": { s: ".jet-popup{display:none !important}" },
  "lemondeencommun.info": { c: 5 },
  "mysuzuki.hu": { j: "5" },
  "indkast.dk": { s: "#hp_cc{display:none !important}" },
  "nordictelecom.cz": { s: ".kukhorni{display:none !important}" },
  "radiogdansk.pl": { s: "#rodoModal{display:none !important}" },
  "mondedommagementnavigo.com": {
    s: "#app > div > .text-center{display:none !important}",
  },
  "yavitrina.ru": { c: 2 },
  "edimax.com": { j: "5" },
  "sportiva.com": { j: "5" },
  "huisjetehuur.nl": {
    s: "#home ~ div[id]:not([class]){display:none !important}",
  },
  "booli.se": { s: "#app > main ~ div{display:none !important}" },
  "voyageforum.com": { j: "5" },
  "vattenfalleldistribution.se": {
    s: "vfdso-cookie-consent{display:none !important}",
  },
  "mortonsalt.com": { s: ".ms-privacy-disclaimer{display:none !important}" },
  "apiko.com": { j: "5" },
  "tonerpartner.cz": { s: ".CookiesOk{display:none !important}" },
  "vansforbands.co.uk": {
    s: ".cookie2019-settings-icon,.cookie2019-settings-icon-inner,#mySidenav{display:none !important}",
  },
  "ciasteczka.org.pl": { s: "#ciasteczka\\.org\\.pl{display:none !important}" },
  "motherless.com": {
    s: ".motherless-cookie-wrapper{display:none !important}",
  },
  "securitywizardry.com": {
    s: ".uk-position-relative{display:none !important}",
  },
  "hari.ca": { c: 152 },
  "poolandspacentre.co.uk": { c: 7 },
  "sen360.sn": { c: 7 },
  "salesmate.io": { s: ".footer-popup{display:none !important}" },
  "pandahurt.pl": { s: ".panda_cookies_accept{display:none !important}" },
  "signupgenius.com": { s: ".sug-notice--privacy{display:none !important}" },
  "bibliotheque.toulouse.fr": { j: "5" },
  "dubplate.be": { j: "5" },
  "husqvarna-bicycles.com": { j: "5" },
  "anpost.ie": { s: "#scg_banner{display:none !important}" },
  "fysikoaerioellados.gr": { j: "5" },
  "zamika.pl": { c: 1 },
  "carrefour.pl": { j: "6" },
  "stadiblidene.lv": { s: "#mrcoockie{display:none !important}" },
  "amewi.com": { j: "5" },
  "norwegian.no": { j: "5" },
  "mailchi.mp": { s: ".mcnTemplatePageBanner{display:none !important}" },
  "freenet-energy.de": { j: "5" },
  "die-region.de": { c: 10 },
  "oneled.pl": { c: 0 },
  "wroled.pl": { c: 0 },
  "lajtit.pl": { c: 0 },
  "rebelwisdom.co.uk": { c: 40 },
  "cardzmania.com": { c: 4 },
  "levelwork.mx": { s: "#sticky-notice{display:none !important}" },
  "welovedevs.com": { j: "6" },
  "befit-fitness.com": { s: ".modal.undefined{display:none !important}" },
  "informatiabucuresti.ro": { s: "mg5-cookie-notice{display:none !important}" },
  "membermojo.co.uk": { s: ".mm2-cookiepref{display:none !important}" },
  "seewarte-schwerin.de": { s: "#mc-consent-window{display:none !important}" },
  "himla.com": {
    s: 'main > div > div > div[style*="fixed"]{display:none !important}',
  },
  "gurock.com": { s: "#gk-cookie-wrapper{display:none !important}" },
  "hypnose-raum.com": { s: ".blueline-content-popup{display:none !important}" },
  "asse.tv": { s: "#app_root ~ div{display:none !important}" },
  "backhaus-mildenberger.de": { c: 29 },
  "schott.com": { s: "#coo-box{display:none !important}" },
  "quixel.com": {
    s: '#app-page ~ div[class*="css"],#react-app > div[style*="hidden"] ~ div[class*="css"]{display:none !important}',
  },
  "feed-the-beast.com": {
    s: ".home > .container > .is-relative > div:first-child{display:none !important}",
  },
  "caseable.com": { s: ".data-privacy-panel{display:none !important}" },
  "rudrastyh.com": { c: 0 },
  "skitenis.pl": { j: "5" },
  "tureckisklep.pl": { j: "6" },
  "holdentalesklep.eu": { j: "5" },
  "polska6.pl": { j: "5" },
  "odbiory.pl": { s: ".uk-position-relative{display:none !important}" },
  "ekocell.pl": { s: "#darkBg,#noticeLayer{display:none !important}" },
  "przp.pl": { s: ".module-abovebox{display:none !important}" },
  "beautyart.pl": { s: "#header-bar{display:none !important}" },
  "noiz.gr": { s: ".bottom_notice{display:none !important}" },
  "legend.rs": { c: 2 },
  "malcoded.com": { j: "5" },
  "diablotools.com": { s: ".x-consent{display:none !important}" },
  "fiksaa.fi": { s: ".site-notification{display:none !important}" },
  "tradeville.eu": { s: "#AccCooTab{display:none !important}" },
  "alternative.me": {
    s: '#footer > div[style*="fixed"]{display:none !important}',
  },
  "goodfood.bg": { s: "#private_info{display:none !important}" },
  "lebara.com": { j: "5" },
  "positronx.io": { c: 0 },
  "mijn-artikel.nl": { c: 27 },
  "fanina.pl": { c: 0 },
  "brady.de": { c: 108 },
  "romo-tonder.dk": { c: 5 },
  "monasuniversum.se": {
    s: '#___gatsby main ~ div,button[name*="legal information"]{display:none !important}',
  },
  "maistendencia.com": { s: ".cnt-cookies{display:none !important}" },
  "siemensgamesa.com": { s: ".sg-cookie-policy{display:none !important}" },
  "billiger-aufladen.de": { j: "5" },
  "newsandnews.com": { s: ".bottom-popup{display:none !important}" },
  "stein.world": {
    s: "#stein-cookie-disclaimer-container{display:none !important}",
  },
  "niko.eu": { j: "5" },
  "geek17.com": { c: 1 },
  "my-meteo.com": { c: 0 },
  "wienholding.at": { j: "5" },
  "systweak.com": { s: ".footer-info{display:none !important}" },
  "promocjada.pl": { j: "5" },
  "peaks.com": { j: "5" },
  "peaks.nl": { j: "5" },
  "cashper.de": { j: "5" },
  "volkswagen-we.com": { s: ".system-notification{display:none !important}" },
  "tutolino.net": { c: 5 },
  "niveau-huile.com": { c: 65 },
  "verein-vpt.at": { s: "#announcement_popup{display:none !important}" },
  "spbtv.online": { s: "#agreeC{display:none !important}" },
  "costesfashion.com": {
    s: "header > div:first-child{display:none !important}",
  },
  "budni.de": { s: "#__next > div > footer ~ div{display:none !important}" },
  "duh.de": { s: "body > .cc{display:none !important}" },
  "leica-enthusiast.de": { c: 5 },
  "byutv.org": { c: 15 },
  "lehmanns.de": { s: ".cc_dialog{display:none !important}" },
  "rosatomflot.ru": { c: 8 },
  "cibusnordic.com": { c: 148 },
  "east.wtf": { c: 17 },
  "unogs.com": { s: 'div[data-bind*="eucookie"]{display:none !important}' },
  "cancercentrum.se": { j: "5" },
  "onlinesim.ru": { s: "#termsbox{display:none !important}" },
  "arconvert.it": {
    s: "#reveal-cookies,.reveal-modal-bg{display:none !important}",
  },
  "lagazettedenimes.fr": { j: "5" },
  "storaenso.com": { s: ".overlay-wrapper{display:none !important}" },
  "bittrex.com": { c: 9 },
  "mecindo.se": { s: "#c-bar{display:none !important}" },
  "comtradeshop.com": { c: 1 },
  "yoyogames.com": { j: "5" },
  "interamt.de": { s: ".ia-m-cookie-flyout{display:none !important}" },
  "hitachiaircon.ru": { c: 39 },
  "euroclear.com": { j: "6" },
  "myvalue.com": { s: ".chivato.uso_cookies{display:none !important}" },
  "bippit.com": { c: 64 },
  "discobag.de": { s: "#CookieQuery{display:none !important}" },
  "paragon-drivers.com": { s: ".b-psg-cookie{display:none !important}" },
  "baltnews.lt": { s: "#policy-warning{display:none !important}" },
  "salonynoma.pl": {
    s: "body > .alert-container.show-pp-alert{display:none !important}",
  },
  "bemo-dent.pl": { s: ".pravate_policy_popup{display:none !important}" },
  "one-insurance.com": { s: ".one-c-privacy{display:none !important}" },
  "app.one-insurance.com": { j: "5" },
  "esska.de": { c: 4 },
  "mini.de": { j: "5" },
  "118.lt": { j: "5" },
  "netcraft.app": { s: "#consent-form{display:none !important}" },
  "netcraft.com": { s: "#consent-form{display:none !important}" },
  "estendo.it": { s: ".jconfirm{display:none !important}" },
  "polskicaravaning.pl": { s: "#myModalpol{display:none !important}" },
  "goplextor.com": { s: "#notebox2{display:none !important}" },
  "morningstar.de": {
    s: "#divAudienceConfirmation #investmentInUK ~ div{display:none !important}",
  },
  "hundeschmuck.store": { j: "5" },
  "troyestore.com": { s: "._ed_cerez{display:none !important}" },
  "seikowatches.com": {
    s: ".blk-Disclaimer,.disclaimer{display:none !important}",
  },
  "regus.com": { j: "6" },
  "amcongmbh.de": { c: 4 },
  "voi-noi.gr": { s: ".bottombar{display:none !important}" },
  "gestionaleopen.org": { c: 3 },
  "pcformat.pl": { s: "#iframePopupContainer{display:none !important}" },
  "dhvseminare.de": {
    s: ".cel-info-box .cel-cookies{display:none !important}",
  },
  "devias.io": { j: "6" },
  "idealo.de": {
    s: '.App > div:first-child:not([class*="header"]){display:none !important}',
  },
  "curiousconcept.com": {
    s: ".notification.is-consent{display:none !important}",
  },
  "bonopoly.de": { s: "#hinweis_button{display:none !important}" },
  "daviddarling.info": { c: 0 },
  "insidegamer.nl": { j: "5" },
  "uni-lj.si": { s: "body > .dark{display:none !important}" },
  "sourcenaturals.com": { s: "#policy_div{display:none !important}" },
  "sanslicark.com": { s: ".v-snack{display:none !important}" },
  "samaritans.org": {
    s: '#footer ~ div[class*="root"]{display:none !important}',
  },
  "ooma.com": { j: "5" },
  "trontv.com": { s: ".jw-popups{display:none !important}" },
  "bad-reichenhaller.de": {
    s: ".vex-overlay,.preferences-alert{display:none !important}",
  },
  "tech-elektro.pl": { c: 0 },
  "dobrzenwielki.pl": { s: ".page-cookie{display:none !important}" },
  "przemysl.pl": { s: ".page-cookie{display:none !important}" },
  "tomford.co.uk": {
    s: ".ui-widget-overlay,.newsletter-signup{display:none !important}",
  },
  "masiaelaltet.com": { c: 0 },
  "magic.gg": {
    s: "#primary-area main ~ div,#primary-area article ~ div{display:none !important}",
  },
  "blasmusik-burgenland.at": { j: "5" },
  "caberstore.com": { c: 0 },
  "time-to-question.com": { c: 0 },
  "l-bank.de": { j: "5" },
  "crowdlitoken.ch": { j: "5" },
  "calameo.com": { j: "5" },
  "verifyemailaddress.org": { j: "5" },
  "upwork.com": { s: "up-cookie-banner{display:none !important}" },
  "80.lv": {
    s: "#__next > div:last-child:not(:only-child){display:none !important}",
  },
  "ross-simons.com": { s: ".lbh_privacy_alert{display:none !important}" },
  "isbank.com.tr": { s: ".blogCookieCover{display:none !important}" },
  "stiftung-managerohnegrenzen.de": { j: "5" },
  "musikguru.de": { s: "#CookieBox{display:none !important}" },
  "edecaformacion.com": { s: "#contenidoCookies{display:none !important}" },
  "foodtribe.com": {
    s: "#root > div[class]:last-child:not(:only-child){display:none !important}",
  },
  "neuefische.de": { j: "6" },
  "heimkinoraum.de": { s: 'div[id^="mod_cookie"]{display:none !important}' },
  "laboratoire-cellmade.fr": { j: "5" },
  "ryneklazienek.pl": { s: "#axnBodyContainer{display:none !important}" },
  "stationsdeski.net": { j: "5" },
  "shimano.com": { s: ".message.fixed{display:none !important}" },
  "brusletto.no": { c: 0 },
  "ao.com": {
    s: '#ao-cb[data-tag-section*="cookie_banner"]{display:none !important}',
  },
  "safedrivingforlife.info": {
    s: ".block-tso-cookie-preferences,.notification-banner-container,.shield{display:none !important}",
  },
  "freeimmo.de": { s: "#ourcookies{display:none !important}" },
  "taschen.com": { j: "5" },
  "budgetmobiel.nl": { s: "#cookie-wall{display:none !important}" },
  "hsv.de": { s: ".dsgvo-modal-overlay,.dsgvo-modal{display:none !important}" },
  "flex-tools.com": { j: "5" },
  "sklep.bialyklasztor.pl": { s: "#growls{display:none !important}" },
  "socialdemokraterna.se": { s: ".sos-cookie{display:none !important}" },
  "simplilearn.com": {
    s: ".eu-container,.sticky-footer-gdpr{display:none !important}",
  },
  "tennis24.bg": { s: "#private_info{display:none !important}" },
  "tenniskafe.com": { s: "#bar-message{display:none !important}" },
  "joingoodcompany.nl": { j: "5" },
  "nordaccount.com": {
    s: "#app > div > .bg-grey-lighter{display:none !important}",
  },
  "cinkciarz.pl": { j: "5" },
  "vecteezy.com": { s: '.ta-dm[data-qa="dm-Layer"]{display:none !important}' },
  "webhallen.com": { c: 6 },
  "axminstertools.com": {
    s: ".axmcookie-notice-container,.axmcookie-notice-conatiner{display:none !important}",
  },
  "ikea.gr": { c: 0 },
  "dailyfx.com": { j: "5" },
  "puritan.com": { s: ".p-cookies{display:none !important}" },
  "calovo.com": { s: ".ga-opt-in{display:none !important}" },
  "spreadshirt.dk": { s: ".container ~ div > .small{display:none !important}" },
  "delo.si": { c: 11 },
  "telegram.hr": { c: 8 },
  "pacma.es": { j: "5" },
  "philasearch.com": { j: "5" },
  "tipp3.at": {
    s: ".t3-app__overlay,.t3-privacyprotection{display:none !important}",
  },
  "aviationweek.com": { s: ".awn-cookie-compliance{display:none !important}" },
  "icscards.de": {
    s: 'body > [style*="brightness(50%)"]{filter:brightness(100%) !important}',
  },
  "siberianhealth.com": {
    s: ".top-informer-container{display:none !important}",
  },
  "glossika.com": { c: 3 },
  "sunny.co.uk": { j: "5" },
  "edu.ch": { s: ".mbdialog{display:none !important}" },
  "mam-bricolaj.ro": { s: ".footer_notif{display:none !important}" },
  "vindeurgent.ro": { s: ".bottom_notice{display:none !important}" },
  "papajohns.pl": {
    s: 'footer ~ div[style*="bottom"]{display:none !important}',
  },
  "wapex.pl": { j: "5" },
  "24opony.pl": { s: ".easyNotificationBck{display:none !important}" },
  "sportmaniac.ro": { j: "5" },
  "backl.ink": { j: "5" },
  "textlocal.com": { s: "#dallas-optin{display:none !important}" },
  "servocode.com": { c: 153 },
  "limemergency.co.uk": { s: "#consentPopup{display:none !important}" },
  "piw.pl": { j: "5" },
  "storia.ro": { c: 28 },
  "designisthis.com": { s: ".gppr-panel{display:none !important}" },
  "makc.ru": { s: "#bottom-notification{display:none !important}" },
  "rezanie-betonu.sk": { s: ".cc_disclaimer{display:none !important}" },
  "drugstore.bg": { c: 4 },
  "joker.es": { c: 0 },
  "zuckerjagdwurst.com": {
    s: '#gatsby-focus-wrapper > div[class^="index"],#gatsby-focus-wrapper > div[class^="index"] + div{display:none !important}',
  },
  "colors-effects.eu": { j: "5" },
  "acast.com": {
    s: ".acast-cookie-consent-portal,#app-root > footer ~ div > aside{display:none !important}",
  },
  "radnickafronta.hr": { c: 0 },
  "eurobuch.de": { s: "#consentBanner1{display:none !important}" },
  "radio17.pl": { c: 82 },
  "hardees.com": { s: ".notice-window{display:none !important}" },
  "starwindsoftware.com": { s: "#privacyPopup{display:none !important}" },
  "irebu.pl": { s: "#COOKIE{display:none !important}" },
  "sp34.waw.pl": { s: ".clause-top{display:none !important}" },
  "vectra.pl": {
    s: ".l-cookies,#root > div > footer ~ div{display:none !important}",
  },
  "thesiteoueb.net": { s: "#page ~ div{display:none !important}" },
  "vejdirektoratet.dk": { j: "5" },
  "audemarspiguet.com": { j: "5" },
  "notrehistoire.ch": {
    s: '#top > [data-promo*="cookie"]{display:none !important}',
  },
  "dsag.de": { s: "#dsag-cookie-compliance-overlay{display:none !important}" },
  "lbry.tv": { s: ".nag{display:none !important}" },
  "genesis-zone.com": { c: 0 },
  "session.de": { s: "#overlay-optin,#opt_in_modal{display:none !important}" },
  "vi.com": { s: "#site-content ~ #footerData{display:none !important}" },
  "mycujoo.tv": { s: "#GDPRModal{display:none !important}" },
  "plusserver.com": { s: "#ps-coockie-confirm{display:none !important}" },
  "unwetterzentrale.de": { c: 1 },
  "tsn.ua": { s: ".c-notification__box{display:none !important}" },
  "itproger.com": { c: 0 },
  "ageas.co.uk": { j: "5" },
  "rainforest-alliance.org": { s: "#modalOverlay{display:none !important}" },
  "wholesalescout.co.uk": {
    s: '.mpp-box[class*="right"]{display:none !important}',
  },
  "kbs.co.kr": { s: ".chrome_pick{display:none !important}" },
  "amarilisonline.com": { c: 0 },
  "agglo2b.fr": { s: "#tracker-warning{display:none !important}" },
  "kufar.by": { j: "6" },
  "gramatica-alemana.es": { j: "5" },
  "bazilik.media": { s: ".bz-cookie{display:none !important}" },
  "luebecker-bucht.guide": {
    s: "#app-container > div > div:not([id]){display:none !important}",
  },
  "hopenergie.com": { s: ".cosa{display:none !important}" },
  "movilcelular.es": { c: 3 },
  "rayjetlaser.com": { s: ".c-window{display:none !important}" },
  "medis.pt": { j: "5" },
  "xn--rzte-fr-aufklrung-pqbn68b.de": { c: 160 },
  "mercadao.pt": { s: "pdo-cookies-policy{display:none !important}" },
  "jufa.eu": {
    s: '.en-mdl-eye_catcher[data-en-tags*="cookie"]{display:none !important}',
  },
  "wonderplugin.com": { s: ".wonderplugin-box{display:none !important}" },
  "hanau.de": { s: "#pirvate_policy{display:none !important}" },
  "remontnik.ru": { s: "rtk-cookies-notice{display:none !important}" },
  "3sairbrushkunst.be": { s: ".cookie__block{display:none !important}" },
  "pacogames.com": { s: "#awagon_gdpr_bar{display:none !important}" },
  "brabilligt.se": { c: 40 },
  "ehrana.si": { s: ".cookies_holder{display:none !important}" },
  "discoveryfrance.fr": { c: 5 },
  "rigips.sk": { c: 8 },
  "wzorniki.eu": { c: 0 },
  "lanko.pl": { s: ".module-abovebox{display:none !important}" },
  "shelblock.com": { s: "#cc_overlay{display:none !important}" },
  "celiac.com": { s: ".cAnnouncements{display:none !important}" },
  "testzentrale.de": { j: "5" },
  "evileg.com": { j: "5" },
  "openx.com": { j: "5" },
  "edzl.lv": { c: 16 },
  "premier.one": { s: ".notifications-container{display:none !important}" },
  "octotree.io": { c: 2 },
  "koi-company.de": { s: ".cmnstr{display:none !important}" },
  "urbex-tour.com": { c: 5 },
  "coperion.com": { j: "5" },
  "texels.nl": { j: "5" },
  "persy.jobs": {
    s: ".cookies-confirmation-frame{display:none !important}.cookies-confirmation--body-hotfix{overflow:visible !important}",
  },
  "albahotelravenna.it": { c: 0 },
  "ivd.ru": { c: 150 },
  "joborgame.ru": { s: ".style__disclaimer{display:none !important}" },
  "evai.pl": { s: "#cffc{display:none !important}" },
  "onwebchange.com": { j: "5" },
  "adoc.tips": { s: "#ADOCTIPS_cookie_box{display:none !important}" },
  "bladehq.com": { s: ".message-accept-container{display:none !important}" },
  "novado.de": { j: "5" },
  "varfurdo.hu": { c: 1 },
  "ticketco.events": { s: "#tcCookiesMessage{display:none !important}" },
  "sixthcontinent.com": { c: 24 },
  "patronite.pl": { j: "5" },
  "vom-achterhof.de": { j: "5" },
  "furnitex.pl": { s: ".bottomWarning{display:none !important}" },
  "linergy.de": { s: "#linergy-cookie-accept{display:none !important}" },
  "rareaquaticplants.com": {
    s: ".art-postcontent > p:first-child{display:none !important}",
  },
  "euroelektronik.pl": { c: 0 },
  "autokult.pl": { j: "5" },
  "llamaya.com": { j: "5" },
  "popsockets.de": { c: 14 },
  "popsockets.com": { c: 14 },
  "shisha-brettl.de": { c: 160 },
  "burgopapers.com": { c: 125 },
  "botentekoop.nl": {
    s: 'div[id*="cookieConsentForm"]{display:none !important}',
  },
  "boten.nl": { s: "#cookieConsentForm33{display:none !important}" },
  "hitman.com": { s: 'div[class*="cookie-banner"]{display:none !important}' },
  "yourkit.com": { s: "#terms-wrapper-id{display:none !important}" },
  "petcure.be": { c: 35 },
  "owasp.org": { s: "#disclaimer-container{display:none !important}" },
  "360.cymru": { s: "#negesCaniatad{display:none !important}" },
  "s4c.cymru": { s: ".s4c-cookie-alert{display:none !important}" },
  "yow.ca": { s: "#sticky{display:none !important}" },
  "dotomi.com": { j: "5" },
  "spk.no": { s: ".MuiDialog-root{display:none !important}" },
  "sky.de": { s: ".top-notification-container{display:none !important}" },
  "karriere.de": { s: ".c-notification{display:none !important}" },
  "candysims.com": { c: 64 },
  "edelweiss-nauders.at": { s: "#cookiePrivacy{display:none !important}" },
  "arcgames.com": { s: "#gdpr-wall{display:none !important}" },
  "erdbeerprofi.de": { j: "5" },
  "ufurnish.com": { s: 'footer > [class^="Bottom"]{display:none !important}' },
  "leningrad.top": { s: ".page-notification{display:none !important}" },
  "bbr.ru": { s: ".is-message-ppd{display:none !important}" },
  "kapucyni.pl": { s: ".ofmcap-cookies,.top-screen{display:none !important}" },
  "tableau.com": { s: ".cTableau_CookieConsent{display:none !important}" },
  "niceshop.co": {
    s: 'div[class*="InformationModal"]{display:none !important}',
  },
  "mycare.de": { j: "5" },
  "ndzperformance.com": { s: ".footer #myModal{display:none !important}" },
  "adventurecorner.de": { s: "#ac-consent-overlay{display:none !important}" },
  "hijobs.net": { s: ".snackbar-container{display:none !important}" },
  "advanzia.com": { c: 0 },
  "christopherward.com": { c: 14 },
  "nyx-arch.ch": { s: "#ab-pop-up{display:none !important}" },
  "dark.netflix.io": { j: "5" },
  "mfs.com": { s: "#cookies-policies{display:none !important}" },
  "nestorparis.com": {
    s: "#gatsby-focus-wrapper > div > div[data-baseweb] ~ div[data-baseweb]:last-child{display:none !important}",
  },
  "emearecruitment.eu": { s: ".ns-type-notice{display:none !important}" },
  "180grader.dk": { j: "5" },
  "vl.ru": { s: "#app-wrapper ~ section{display:none !important}" },
  "plex.tv": { j: "6" },
  "champagne.fr": { c: 0 },
  "quermania.de": { s: "#cookiefeld{display:none !important}" },
  "libertex.com": { s: ".disclaimer__item.center-md{display:none !important}" },
  "arkadbudapest.hu": { s: "#mdl-overlay,.mdl-modal{display:none !important}" },
  "switcher.com": { c: 60 },
  "reisacher.de": { s: ".ch_banner-wrapper{display:none !important}" },
  "betway.se": { j: "5" },
  "ichhabediewahl.de": { s: "#idCP33Message{display:none !important}" },
  "indianexpress.com": {
    s: 'div[id*="google_ads_iframe"][id*="GDPR"]{display:none !important}',
  },
  "waldlandwelt.de": { j: "6" },
  "950bergen.no": { c: 82 },
  "teichdiscount24.de": { c: 82 },
  "servsafe.com": { s: "#ppID{display:none !important}" },
  "aut.cc": { s: "#viewlet-disclaimer{display:none !important}" },
  "timebreak.eu": { s: '.must-hide[style*="ececec"]{display:none !important}' },
  "fireandflower.com": { s: "#main > footer ~ div{display:none !important}" },
  "jeunesseglobal.com": { c: 83 },
  "ivnosys.com": {
    s: ".mpp-container-position-top-bar{display:none !important}",
  },
  "usecrypt.com": { s: ".cookies-ct{display:none !important}" },
  "toshiba-memory.com": { s: ".cookiesWrap{display:none !important}" },
  "pluto.tv": { j: "6" },
  "nichtohneuns.de": { c: 160 },
  "abicrash.com": { c: 0 },
  "cw.no": { s: ".cw-cookie-confirmation{display:none !important}" },
  "html-css-js.com": { s: "#hcjCookies{display:none !important}" },
  "neubaukompass.de": { c: 14 },
  "stockcharts.com": { s: "#sccCookieBanner{display:none !important}" },
  "radarbox.com": { c: 34 },
  "qliro.com": { s: "#react-app > div > [open]{display:none !important}" },
  "play-games.com": { c: 34 },
  "diffnow.com": { s: '#root > div[style*="fixed"]{display:none !important}' },
  "learningnetworkstore.cisco.com": { c: 20 },
  "kaspersky.com": {
    s: '.notification-bar,#banner-region,.disclaimer.wrapper,#app header ~ section[data-t],[class*="CookiesAccept_container"]{display:none !important}',
  },
  "niedziela.pl": { c: 0 },
  "waven-game.com": { s: ".privacy-notification{display:none !important}" },
  "hetwkz.nl": { j: "5" },
  "heinz.st": { j: "5" },
  "dplay.es": {
    s: '#app dialog[class*="notification"]{display:none !important}',
  },
  "got-it.ai": { s: ".gi-Cookie{display:none !important}" },
  "swstrings.com": { s: ".notification-container{display:none !important}" },
  "truefittandhill.co.uk": { c: 4 },
  "joker.com": { s: ".v-snack,.v-dialog--persistent{display:none !important}" },
  "metrobankonline.co.uk": {
    s: ".metro-cookiebar__block{display:none !important}",
  },
  "pudelek.pl": { j: "5" },
  "regmag.pl": { c: 0 },
  "donald.pl": { c: 159 },
  "scottevest.com": { c: 2 },
  "barclaycard.co.uk": {
    s: ".app-wrapper > [data-wrap]{display:none !important}",
  },
  "interfriendship.de": { j: "5" },
  "dissept.com": { c: 5 },
  "katsbotanicals.com": { s: ".conv_type_bar{display:none !important}" },
  "mazda-autohaus-schwenke-duisburg.de": { j: "5" },
  "weltbild.de": { j: "5" },
  "voo.be": { s: ".pastry{display:none !important}" },
  "verksamhetslokaler.se": { j: "5" },
  "uni-ulm.de": { c: 158 },
  "zapisanisobie.pl": { s: "#kremowka{display:none !important}" },
  "mehilainen.fi": { j: "5" },
  "audioboom.com": { j: "5" },
  "rdlfitness.com": { c: 5 },
  "compresss.com": { c: 7 },
  "square-enix.com": {
    s: 'div[class^="notice_Notices"]{display:none !important}',
  },
  "denizbank.com": { s: "#fixedFooterBar{display:none !important}" },
  "pibank.es": { j: "5" },
  "stabila.com": { j: "5" },
  "trdevents.no": { s: ".warning-message{display:none !important}" },
  "besteproduct.nl": { j: "5" },
  "converse.com": { j: "5" },
  "goteborgenergi.se": { s: ".Ge-Msg--cookie{display:none !important}" },
  "binumi.com": { j: "6" },
  "ravi.pl": { j: "6" },
  "system.t-mobilebankowe.pl": { j: "5" },
  "regnest.com": { c: 0 },
  "vigo-krankenversicherung.de": { s: "#cwarning{display:none !important}" },
  "lkh.de": { s: ".cc-blur,.cc-overlay{display:none !important}" },
  "mercedes-creditcard.de": { c: 0 },
  "indiearenabooth.com": { j: "5" },
  "molotov.tv": {
    s: '#app > div > div + div:not([class*=" "]){display:none !important}',
  },
  "sachsen-fernsehen.de": { j: "5" },
  "carlsjr.com": { s: ".notice-window{display:none !important}" },
  "tvtv.ca": { c: 24 },
  "kristeligt-dagblad.dk": { c: 4 },
  "nedsecure.co.za": { s: "#divnedbankretailcookie{display:none !important}" },
  "shpock.com": { j: "5" },
  "speedtest.net": {
    s: ".privacy-update,.notification-container{display:none !important}",
  },
  "ctshop.rs": { c: 1 },
  "radio-trausnitz.de": { j: "5" },
  "thunderfulgames.com": { c: 40 },
  "babanet.hu": { c: 0 },
  "generaltire.com": { s: ".gt-privacy-popup{display:none !important}" },
  "litebit.eu": { j: "5" },
  "linksfraktion-nordsachsen.de": { c: 8 },
  "fastcompany.com": { s: ".privacyPolicyPopup{display:none !important}" },
  "l-bank.info": { j: "5" },
  "deka.de": { j: "5" },
  "lbbw.de": { j: "5" },
  "timhortons.co.uk": { s: ".user-permission{display:none !important}" },
  "montanacolors.com": { j: "5" },
  "wetransfer.com": { j: "5" },
  "revolver.news": { c: 11 },
  "gongfm.de": { j: "5" },
  "newrepublic.com": { s: ".popup-consent{display:none !important}" },
  "gmu.edu": { s: "#mason-cookie-banner{display:none !important}" },
  "finanzia.no": { s: ".theme-privacy-container{display:none !important}" },
  "cookpad.com": {
    s: '.flex[data-id="cookie_dialog"]{display:none !important}',
  },
  "gezond.nl": { j: "5" },
  "reiseversicherung.de": { s: "#erv-cookie{display:none !important}" },
  "leagueoflegends.com": { s: ".riotbar-alert{display:none !important}" },
  "thecycleverse.com": { j: "6" },
  "codility.com": { c: 0 },
  "onzetaal.nl": { c: 4 },
  "mindmeister.com": { s: "#cb-wrapper{display:none !important}" },
  "music.yandex.ru": { j: "5" },
  "music.yandex.com": { j: "5" },
  "yandex.ru": {
    s: '.gdpr,div[data-react-widget-id="Gdpr"],.lc-gdpr{display:none !important}',
  },
  "latendresseencuisine.com": { s: ".mdc-snackbar{display:none !important}" },
  "realm667.com": { j: "5" },
  "mediathekviewweb.de": { j: "5" },
  "virginaustralia.com": { j: "5" },
  "cnam-bretagne.fr": { s: ".ojc_consent{display:none !important}" },
  "sendgb.com": { j: "5" },
  "hemdenbox.de": { j: "5" },
  "vectorizer.io": { c: 10 },
  "biker-boarder.de": { s: ".settings-parent{display:none !important}" },
  "police-auction.org.uk": { j: "5" },
  "aromatico.de": { s: ".js--overlay{display:none !important}" },
  "handy-deutschland.de": { j: "5" },
  "uniqa.at": { j: "5" },
  "yatego.com": { s: "#ycwBg,#ycwMo{display:none !important}" },
  "weltbild.at": { j: "5" },
  "lausitznews.de": { s: "#modal_cookie-consent{display:none !important}" },
  "backstagepro.de": { j: "5" },
  "radioeins.com": { j: "5" },
  "imoradar24.ro": { j: "5" },
  "quooker.de": { j: "5" },
  "sicomputers.nl": { s: "#mm-cc-wrap{display:none !important}" },
  "jus.com.br": { c: 3 },
  "andreaminini.com": { c: 16 },
  "ufz.de": { j: "5" },
  "ambientedirect.com": {
    s: ".ConsentOverlay,.ModalBackground{display:none !important}",
  },
  "esanum.de": { s: "esn-cookie-disclaimer{display:none !important}" },
  "travelbags.nl": { s: ".snackbar-container{display:none !important}" },
  "vtb.ru": { s: "#cookiemsgoffpls{display:none !important}" },
  "regio-tv.de": { j: "5" },
  "frontaliers-grandest.eu": { c: 0 },
  "ofisitebg.com": { s: ".bottom-freezed-bar{display:none !important}" },
  "droneacademy.com": { c: 5 },
  "pagetiger.com": { j: "6" },
  "regioactive.de": { j: "5" },
  "rittal.com": { j: "5" },
  "modelmanagement.com": { s: "#cookie_exp{display:none !important}" },
  "schwaebisch-hall.de": { j: "5" },
  "td-csk.ru": { s: ".cociess{display:none !important}" },
  "radio-bamberg.de": { j: "5" },
  "komoedie-steinstrasse.de": { s: "#cookie-row{display:none !important}" },
  "bo.de": { j: "5" },
  "minpension.se": { s: "mip-cookie-banner{display:none !important}" },
  "pepephone.com": { j: "2" },
  "gezeitenfisch.com": { c: 0 },
  "paylogic.com": { s: "ks-cookie-banner.d-block{display:none !important}" },
  "unikol.com.pl": { c: 0 },
  "ibutikk.no": { s: ".cookies-message_old{display:none !important}" },
  "cocktaildatenbank.de": { j: "5" },
  "nkbv.nl": { c: 2 },
  "ebike-bausatz.eu": {
    s: "#modal_cct{display:none !important}",
    c: 14,
  },
  "dunlop.eu": {
    s: ".cmp-responsivegrid--behavior-cookie{display:none !important}",
  },
  "uvex-safety.com": { j: "5" },
  "autism-society.org": { s: ".featherlight{display:none !important}" },
  "noovo.ca": { s: "#over-politique{display:none !important}" },
  "neliosoftware.com": { j: "5" },
  "ultimaker.com": {
    s: ".consent-bar,.um-consent-bar{display:none !important}",
  },
  "12xl.de": { j: "5" },
  "xrisiavgi.com": { c: 40 },
  "anacom.pt": { s: 'div[id^="cookieDiv"]{display:none !important}' },
  "etepetete-bio.de": { j: "5" },
  "tv-trwam.pl": { j: "6" },
  "spielexikon.de": { j: "5" },
  "supermenu.com.pl": { c: 97 },
  "nypost.com": { s: ".nyp-sitewide-notice{display:none !important}" },
  "jelenia.tv": { j: "5" },
  "calcolosconto.it": { s: ".panel-footer{display:none !important}" },
  "ls-tc.de": { j: "5" },
  "nieuwsmotor.nl": { s: ".uk-position-bottom{display:none !important}" },
  "duvel.com": { j: "5" },
  "legia.com": { j: "5" },
  "ewinner.pl": { s: ".cookiesComponent{display:none !important}" },
  "care-club.com": { s: ".cookie-blocker{display:none !important}" },
  "notaris.be": { j: "5" },
  "mubi.pl": {
    s: '.cookies,header ~ div[aria-label*="Cookie"]{display:none !important}',
  },
  "tdcx.com": {
    s: '#___portal > div > [class^="s-mod"]{display:none !important}',
  },
  "ns.nl": { j: "5" },
  "tigota.it": { s: "#ckInfo{display:none !important}" },
  "cluvens.net": { c: 3 },
  "karriere.nrw": { c: 13 },
  "kasuwa.de": { j: "5" },
  "drogariaspacheco.com.br": {
    s: ".rnk-componente-lgpd{display:none !important}",
  },
  "unit4.es": { s: "#cookies-law{display:none !important}" },
  "larepublica.co": { c: 0 },
  "agronegocios.co": { c: 0 },
  "asuntoslegales.com.co": { c: 0 },
  "bio-rad.com": { s: "#overlay-shadow{display:none !important}" },
  "vobox.ru": { s: ".vb-cookies-bar{display:none !important}" },
  "elnaro.pl": { c: 0 },
  "canaldigital.no": { j: "5" },
  "surelighttech.com": { s: "#growls-br{display:none !important}" },
  "biosyn.de": { c: 4 },
  "wabu-care.com": { c: 160 },
  "clubsim.com.hk": { c: 2 },
  "prohardver.hu": { s: "#accept-container{display:none !important}" },
  "logout.hu": { s: "#accept_container{display:none !important}" },
  "express.pl": { s: ".newWebsite{display:none !important}" },
  "ego4u.de": { c: 4 },
  "tripadvisor.com": { c: 18 },
  "tripadvisor.fr": { c: 18 },
  "tripadvisor.de": { c: 18 },
  "tripadvisor.com.mx": { c: 18 },
  "tripadvisor.com.ar": { c: 18 },
  "tripadvisor.cl": { c: 18 },
  "tripadvisor.co": { c: 18 },
  "tripadvisor.com.pe": { c: 18 },
  "tripadvisor.com.ve": { c: 18 },
  "tripadvisor.co.uk": { c: 18 },
  "tripadvisor.it": { c: 18 },
  "tripadvisor.es": { c: 18 },
  "tripadvisor.se": { c: 18 },
  "tripadvisor.nl": { c: 18 },
  "tripadvisor.dk": { c: 18 },
  "tripadvisor.ie": { c: 18 },
  "tripadvisor.cz": { c: 18 },
  "tripadvisor.at": { c: 18 },
  "tripadvisor.com.gr": { c: 18 },
  "tripadvisor.fi": { c: 18 },
  "tripadvisor.co.hu": { c: 18 },
  "tripadvisor.pt": { c: 18 },
  "tripadvisor.ch": { c: 18 },
  "tripadvisor.sk": { c: 18 },
  "tripadvisor.be": { c: 18 },
  "tripadvisor.co.za": { c: 18 },
  "dzbank-derivate.de": { s: "#screen-overlay{display:none !important}" },
  "secondsol.com": { j: "5" },
  "zkteco.com": { s: "#cmsg{display:none !important}" },
  "thegapdecaders.com": { c: 5 },
  "matratzen-concord.de": { c: 2 },
  "monese.com": { j: "5" },
  "wwdmag.com": {
    s: '.intercom-snippet > [class*="gdpr"]{display:none !important}',
  },
  "xsplit.com": { s: ".Toastify{display:none !important}" },
  "widiba.it": { s: ".wd-cookies{display:none !important}" },
  "kupredudominulosti.cz": { s: "#ktCookieStatement{display:none !important}" },
  "guesty.com": { s: ".guesty-cookie-notice{display:none !important}" },
  "startdevchange.com": { s: ".cookies-nav{display:none !important}" },
  "ponte.hu": { c: 3 },
  "officiallifeintheuk.co.uk": {
    s: '.shield,div[id*="cookie-preferences"]{display:none !important}',
  },
  "henschel-schauspiel.de": { j: "5" },
  "tieranwalt.at": { j: "5" },
  "voltadol.at": { j: "5" },
  "trustmate.io": {
    s: 'div[class*="CookiesWrapper"]{display:none !important}',
  },
  "k15t.com": { j: "5" },
  "birminghammidshires.co.uk": { c: 0 },
  "motor-stickers.com": { c: 71 },
  "svenskakyrkan.se": { j: "5" },
  "bebocommunication.fr": { c: 5 },
  "wackler-group.de": { s: ".z7cmbnr{display:none !important}" },
  "rbinternational.com.pl": {
    s: "#cms-cookie-approvment{display:none !important}",
  },
  "nettbil.no": { s: ".nb-cookie-bar{display:none !important}" },
  "brandwatch.com": { s: "#bw-cookie-sys-active{display:none !important}" },
  "kunstsammlung.de": { c: 0 },
  "f8.com": { s: ".v-snack--top{display:none !important}" },
  "eredivisie.pl": { s: '[id^="viewCookies"]{display:none !important}' },
  "euroleague.net": { j: "6" },
  "famobi.com": { j: "5" },
  "ergon.nl": { s: "#ergcb{display:none !important}" },
  "carinthia.eu": { s: ".dcCookieModal{display:none !important}" },
  "indigogames.xyz": { c: 15 },
  "akelius.com": { j: "5" },
  "costain.com": { c: 0 },
  "winfuture.mobi": { s: "#message_id{display:none !important;top:999999px}" },
  "finantia.com": { j: "6" },
  "finantia.es": { j: "6" },
  "qz.com": { s: "#main ~ div{display:none !important}" },
  "getraenke089.de": { s: ".DS_banner_wrapper{display:none !important}" },
  "mantel.com": { j: "5" },
  "magdalena24.pl": { c: 0 },
  "volleybal.nl": { j: "5" },
  "solaranlagen-portal.com": { c: 110 },
  "outdooractive.com": { j: "5" },
  "forsea.de": { s: '[id*="fuer_cookie"]{display:none !important}' },
  "enviam.de": { j: "6" },
  "restaurant-kitty-leo.de": { j: "5" },
  "tre.se": { j: "5" },
  "crowdfinder.be": { c: 2 },
  "vaadin.com": { s: "#haas-cookie-dialog{display:none !important}" },
  "bus-pvl.kz": { s: "#useragreement{display:none !important}" },
  "asgardia.space": {
    s: "#app > div:first-child > div:first-child,#app > div > button{display:none !important}",
  },
  "bodaskins.com": { c: 0 },
  "unimax.com.tw": { c: 2 },
  "designerdata.nl": { c: 4 },
  "newser.com": { s: "#divCM{display:none !important}" },
  "schauhoehle-breitscheid.de": { c: 40 },
  "retrosix.co.uk": { c: 60 },
  "visionexpress.pl": { s: "#bpr_cookie-alert{display:none !important}" },
  "vibez.pl": { j: "5" },
  "drogeriedepot.de": { s: "#light-box-bg{display:none !important}" },
  "cleanmymac.com": { s: ".bottom-banner{display:none !important}" },
  "fastforwardscience.de": { j: "5" },
  "adventurespiele.net": { j: "5" },
  "widewalls.ch": { s: ".ww-c-cookies__container{display:none !important}" },
  "intercom.com": {
    s: "#intercom-cookie-consent-banner{display:none !important}",
  },
  "wera.de": { s: '[id^="dsgvo-modal"]{display:none !important}' },
  "era.int": { s: "#__COOKIE_CONFIRM__{display:none !important}" },
  "simplybook.me": { c: 0 },
  "dieallianzdesguten.com": { j: "5" },
  "vuejsdevelopers.com": {
    s: ".navbar.is-fixed-bottom{display:none !important}",
  },
  "digas.gr": { s: "#tc-pnl{display:none !important}" },
  "lewissilkin.com": { c: 2 },
  "archivespasdecalais.fr": { c: 0 },
  "poppulo.com": { c: 11 },
  "antennaweb.org": {
    s: '#__next > div > div > [class*="TosCheck"]{display:none !important}',
  },
  "prosa.dk": { j: "5" },
  "buchbinder-auktion.de": {
    s: "#cookieSettings,#cookieBlur{display:none !important}",
  },
  "andyhayler.com": { c: 2 },
  "iperdi.de": { s: "#consent_info{display:none !important}" },
  "uptain.de": { c: 17 },
  "itis.swiss": { j: "5" },
  "kmweg.de": { c: 77 },
  "raiffeisen-immobilien.at": { j: "5" },
  "yuumari.com": { s: "footer ~ .banner-container{display:none !important}" },
  "fenb.be": { j: "5" },
  "claravital.de": { s: "#consentmanager{display:none !important}" },
  "linz.de": { s: "#sfCookie{display:none !important}" },
  "werkenbijcalco.nl": { j: "5" },
  "cliffordchance.com": { s: "#div_cc_cc{display:none !important}" },
  "quiziniere.com": { j: "5" },
  "happypancake.fi": { s: "#__next > div > .bar{display:none !important}" },
  "happypancake.se": { s: "#__next > div > .bar{display:none !important}" },
  "happypancake.nl": { s: "#__next > div > .bar{display:none !important}" },
  "unedtenerife.es": { j: "5" },
  "gcorelabs.com": { s: ".confirmed_cookie{display:none !important}" },
  "targoversicherung.de": { j: "5" },
  "alexmor.ru": { s: ".b-accept-cookie{display:none !important}" },
  "cetelem.es": { c: 99 },
  "takko.com": { j: "5" },
  "rgu.ac.uk": { s: "#cc-modal{display:none !important}" },
  "amareluna.com": { c: 6 },
  "foxford.ru": { c: 31 },
  "vacuubrand.com": { c: 31 },
  "nacex.es": { j: "5" },
  "startpagina.nl": { s: "body{top:0 !important}" },
  "myswisslife.fr": { s: "mysl-cookies{display:none !important}" },
  "eurocupbasketball.com": { j: "6" },
  "edeka-foodservice.de": { j: "5" },
  "abo24.de": { j: "5" },
  "lapaweb.com": { c: 16 },
  "envoituresimone.com": { j: "5" },
  "truepartnercapital.com": { j: "5" },
  "brk.de": { s: "#zcookie{display:none !important}" },
  "deepstash.com": { s: ".Toaster{display:none !important}" },
  "strummerradio.com": { c: 29 },
  "dopravnakarta.sk": { s: "#CookieAgree{display:none !important}" },
  "poplab.mx": { c: 105 },
  "lipapromet.hr": { s: ".coockiediv{display:none !important}" },
  "yna.co.kr": { s: "#layerAgree{display:none !important}" },
  "frischteigwaren-huber.de": { j: "5" },
  "aranafansub.moe": { c: 114 },
  "blot.fr": { s: "#tracker-warning{display:none !important}" },
  "ferienchecker.at": { j: "5" },
  "justjoin.it": { j: "5" },
  "playmagnus.com": {
    s: ".pm-header + .pm-black-background{display:none !important}",
  },
  "reviewmeta.com": { j: "5" },
  "dielinke-queer.de": { c: 8 },
  "plurall.net": { s: "#oPrivallyApp-Bar{display:none !important}" },
  "lecourrier.es": { s: "#times-legal-notice{display:none !important}" },
  "freiewaehler.eu": { s: "#myCookie{display:none !important}" },
  "pixel-offers.com": { s: ".v-cookie-policy{display:none !important}" },
  "connexion-emploi.com": { c: 135 },
  "connexion-francaise.com": { c: 135 },
  "aqua-medic.de": { c: 135 },
  "monheim.de": { j: "5" },
  "hs-coburg.de": { c: 158 },
  "aaal.org": { s: ".c-alert-one-time{display:none !important}" },
  "maengelmelder.de": { j: "5" },
  "xn--mngelmelder-l8a.de": { j: "5" },
  "emisora.org.es": { c: 6 },
  "godbolt.org": { j: "5" },
  "gulbenkian.pt": { j: "5" },
  "lotto-brandenburg.de": {
    s: "footer > div,footer > form{display:none !important}",
  },
  "brf.be": { s: "#cookieDashboard{display:none !important}" },
  "dungeondice.it": { s: "#yn-gdpr{display:none !important}" },
  "eden.de": { s: ".cc-blur,.cc-overlay{display:none !important}" },
  "gardenplaza.de": { s: "#cc_window{display:none !important}" },
  "larian.com": { c: 0 },
  "theorg.com": { s: "#app > span{display:none !important}" },
  "brujulea.net": { s: "#bckie{display:none !important}" },
  "aramido.de": { s: ".banner{display:none !important}" },
  "ep.de": { j: "5" },
  "uniroma1.it": { s: ".cookie-background{display:none !important}" },
  "podcloud.fr": { s: "#rgpd-modal{display:none !important}" },
  "adtinnova.ch": { c: 13 },
  "careercross.com": { c: 7 },
  "nextmarkets.com": { s: "nm-cookie-dialog{display:none !important}" },
  "findino.ch": { s: ".CookieView{display:none !important}" },
  "thairath.co.th": { s: "main > div > footer ~ div{display:none !important}" },
  "insighttimer.com": { s: "#footer ~ .rounded{display:none !important}" },
  "piranha.de": { j: "5" },
  "risekombucha.com": { s: "body > .widget{display:none !important}" },
  "rechtslupe.de": { s: "#dsChoice{display:none !important}" },
  "bgbasket.com": { s: "#private_info{display:none !important}" },
  "yuden.co.jp": { s: '[id^="yuden_gdpr"]{display:none !important}' },
  "poscielrodzinie.pl": { c: 0 },
  "danskemedier.dk": { j: "5" },
  "ardmediathek.de": {
    s: '#root > div > div > [class*="Root"] > [class*="Message"]{display:none !important}',
  },
  "wegedetektiv.de": { j: "5" },
  "nexthink.com": {
    s: "c-community-cookie-consent-banner{display:none !important}",
  },
  "studiobookr.com": { j: "5" },
  "mobiliperufficio.com": { c: 0 },
  "camellia.plc.uk": { s: ".sitealert{display:none !important}" },
  "thameswater.co.uk": { s: ".ico-compliance-plugin{display:none !important}" },
  "classic.co.uk": { c: 6 },
  "healthinsight.ca": { j: "5" },
  "phish-test.de": { j: "6" },
  "yobetit.com": { s: ".CookiesContainer{display:none !important}" },
  "giantswarm.io": { s: "#consent_dialog{display:none !important}" },
  "apps112.com": { s: "#s112_accept_cookies{display:none !important}" },
  "diebayerische.de": { j: "5" },
  "wohnmobilforum.de": { j: "5" },
  "wohnen-im-alter.de": { j: "5" },
  "astroreveal.com": { s: ".EU2018{display:none !important}" },
  "kobietaxl.pl": { s: ".cookie_al{display:none !important}" },
  "swissre.com": { s: ".Notification{display:none !important}" },
  "weeronline.nl": { j: "5" },
  "kbv.de": { s: ".layer-cookie{display:none !important}" },
  "wissenstexte.de": { s: "body > dialog{display:none !important}" },
  "aquanox.com": { c: 0 },
  "diaexpert.de": { s: ".dx_cookiebanner{display:none !important}" },
  "adomino.net": { s: "#cf__widget-outer{display:none !important}" },
  "apothekia.de": { j: "5" },
  "thecrag.com": { s: ".banner-message{display:none !important}" },
  "sea-seek.com": { j: "6" },
  "geef.nl": { s: "geef-cookie-settings{display:none !important}" },
  "vpnunlimitedapp.com": { s: ".badge_privacy{display:none !important}" },
  "keepsolid.com": { s: ".badge_privacy{display:none !important}" },
  "vpnlite.net": { s: ".badge_privacy{display:none !important}" },
  "abetterrouteplanner.com": {
    s: 'div[data-e2e="menu-button"] + div:not([data-e2e]){display:none !important}',
  },
  "feinewerkzeuge.de": { s: "#cookiefeinewerkzeuge{display:none !important}" },
  "fine-tools.com": { s: "#cookiefeinewerkzeuge{display:none !important}" },
  "utensiliprofessionali.com": {
    s: "#cookiefeinewerkzeuge{display:none !important}",
  },
  "tvo.de": { j: "5" },
  "nowonline.com.br": { s: 'div[id^="cookies"]{display:none !important}' },
  "fiftysix.nl": { j: "5" },
  "easycookasia.de": { c: 5 },
  "elekta.com": { j: "5" },
  "spectyou.com": { c: 32 },
  "dajar.cz": { j: "6" },
  "der-schumacher.de": { s: "#kruemel.cookieConfig{display:none !important}" },
  "donanimhaber.com": { s: ".cookie-kutu{display:none !important}" },
  "neonmob.com": { s: ".nm-tips{display:none !important}" },
  "bestdrive.fr": { j: "5" },
  "comprovendolibri.it": {
    s: "#CVLR_AdvPrivacy,#CVLR_AdvPrivacy ~ table{display:none !important}",
  },
  "vuweb.vu.nl": { j: "5" },
  "magentagaming.com": { j: "5" },
  "soft8soft.com": { s: ".total-plus-privacy-policy{display:none !important}" },
  "spiel.digital": { s: "#root > div:not([style]){display:none !important}" },
  "kartoteka.by": { c: 34 },
  "pc-college.de": { s: "#clayer{display:none !important}" },
  "langeland.nl": { j: "5" },
  "vinidex.com.au": { s: "#tde-gdpr{display:none !important}" },
  "stoffen-hemmers.nl": { c: 2 },
  "riteintherain.com": { s: "#screen-overlay-white{display:none !important}" },
  "fantasy.motogp.com": { s: "#root > div{display:none !important}" },
  "info-retraite.fr": { c: 0 },
  "was-reimt-sich-auf.de": {
    s: "#cookies-modal,#cookies-backdrop{display:none !important}",
  },
  "okpedia.it": { c: 16 },
  "uswitch.com": { s: "#us-cookies{display:none !important}" },
  "surveymonkey.com": {
    s: ".mds-gdpr-cookie-banner,.wds-overlay{display:none !important}",
  },
  "think-cell.com": { s: "body{margin-top:0 !important}" },
  "frameworktraining.co.uk": { s: ".fwt_cookie{display:none !important}" },
  "aarsfjv.dk": { s: "dffedb-cookie-consent{display:none !important}", j: "5" },
  "megascena.pl": { c: 0 },
  "evaair.com": { j: "5" },
  "optima.hr": { c: 0 },
  "troha-dil.hr": { s: "#kvnotice{display:none !important}" },
  "tokic.hr": { c: 2 },
  "deceuninck.hr": { s: ".page-wrapper > .popup{display:none !important}" },
  "7mind.de": { c: 2 },
  "pizzahut.pl": {
    s: "#__next > div > div + div:last-child{display:none !important}",
  },
  "qinetiq.com": { j: "5" },
  "greenflagaward.org": { c: 14 },
  "clasebcn.com": { c: 0 },
  "pracownia.org.pl": { c: 137 },
  "frankenfernsehen.tv": { j: "5" },
  "lurker.pl": { s: ".uk-alert{display:none !important}" },
  "einstel.pl": { c: 0 },
  "jelonka.com": { s: ".prywatnosc{display:none !important}" },
  "qwic.de": { j: "5" },
  "aia.com.my": { c: 7 },
  "jobalert.ie": { j: "6" },
  "motorsportz.nl": {
    s: ".overlay_div,.alert_wrapper{display:none !important}",
  },
  "ilmarinen.fi": { j: "5" },
  "didaxis.fr": { s: "#overlay-coockie{display:none !important}" },
  "madametussauds.com": { s: ".cme-container{display:none !important}" },
  "allibo.com": { s: "#ck_warn{display:none !important}" },
  "pas-hammerl.de": { c: 6 },
  "spielemax.de": { s: "#sukhvir-cookie-bar{display:none !important}" },
  "mamiweb.de": { c: 4 },
  "mymusictaste.com": {
    s: "#__MoaiPortal__Outmost__{display:none !important}",
  },
  "openjobmetis.it": { j: "5" },
  "puzzlemaster.ca": { c: 15 },
  "bansdiving.de": { c: 40 },
  "cliverton.co.uk": { s: ".popup-wrapper{display:none !important}" },
  "besplatka.ua": { s: "#cookie-bottom{display:none !important}" },
  "eurobuch.com": { s: "#consentBanner1{display:none !important}" },
  "yello.com": { s: ".cookieplaceholder{display:none !important}" },
  "daemmen-und-sanieren.de": { c: 110 },
  "foxtons.co.uk": { j: "5" },
  "phc-muenchen.de": {
    s: "#cookie_banner_modal{display:none !important}",
    c: 14,
  },
  "whiskybase.com": { s: ".cookie-question{display:none !important}" },
  "yourstory.com": { j: "6" },
  "bang-olufsen.com": { j: "5" },
  "rtlplay.be": { s: ".app__content ~ div{display:none !important}" },
  "poenvoorgroen.nl": { s: ".cc-layer{display:none !important}" },
  "reimbursement.institute": { s: "#bla{display:none !important}" },
  "alba.info": { c: 77 },
  "sued.aldi-liefert.de": { c: 14 },
  "qrd.by": { s: ".keckse{display:none !important}" },
  "proman-emploi.fr": { j: "5" },
  "storiepoesie.it": { s: "#stpo_cookielaw_banner{display:none !important}" },
  "lavoro-over40.it": { s: ".lo40-cookie-div{display:none !important}" },
  "volkswagen.co.uk": { s: "#bannerOverlay{display:none !important}" },
  "waze.com": { s: ".wz-cc-container{display:none !important}" },
  "konversionskraft.de": { s: ".kkcb_portal{display:none !important}" },
  "commentreparer.com": { j: "5" },
  "esanum.fr": { s: "esn-cookie-disclaimer{display:none !important}" },
  "mytime.de": {
    s: ".modal--cookie-notice{display:none !important}.modal__opened{overflow:visible !important}",
  },
  "combi.de": { j: "5" },
  "mathaeser.de": { j: "5" },
  "kinopolis.de": { j: "5" },
  "itopvpn.com": { s: ".footer ~ .content{display:none !important}" },
  "i-posciel.pl": { c: 0 },
  "servicestatus.net": { s: ".cf__visible{display:none !important}" },
  "nanu-nana.de": { c: 17 },
  "begroting-2021.nl": { j: "5" },
  "lebegesund.de": { s: "lgv-cookie-manager{display:none !important}" },
  "mazury24.eu": { j: "5" },
  "tarnobrzeg.info": { j: "5" },
  "blackboard.com": { j: "5" },
  "shsu.blackboard.com": {
    s: ".lb-overlay,.lb-wrapper-absolute{display:none !important}",
  },
  "unitedwardrobe.com": { s: "#__next > section{display:none !important}" },
  "hotel-neue-post.de": {
    s: ".evconsent-dialog-container{display:none !important}",
  },
  "nibcdirect.de": { j: "5" },
  "claudiakookt.nl": { s: "#sticky{display:none !important}" },
  "elexgame.com": { c: 0 },
  "cc.com": {
    s: "#balaMainContainer,.module-container-bala{display:none !important}",
  },
  "real.de": { j: "5" },
  "appyshop.co.uk": { c: 0 },
  "netztest.at": { j: "6" },
  "mazda-autohaus-schreier-biebergemuend-bieber.de": { j: "5" },
  "speakout7eleven.ca": {
    s: "#speakout-cookie-template{display:none !important}",
  },
  "financial-ombudsman.org.uk": { s: "#wrap{margin-top:0 !important}" },
  "antenne.at": { c: 49 },
  "ar-packaging.com": { c: 8 },
  "gumtree.com": { s: ".notification-box{display:none !important}" },
  "gamefreak.gr": { c: 71 },
  "spbtvonline.ru": { s: "#agreeC{display:none !important}" },
  "ab-m.de": { j: "5", s: ".wd-consent{display:none !important}" },
  "swrag.de": { j: "5" },
  "nzxt.com": { c: 6 },
  "ogrzewanie-domu.pl": { c: 0 },
  "autohaus24.de": { j: "5" },
  "keramiko.pl": { s: "#popAdvertising{display:none !important}" },
  "fzone.cz": { s: ".sys-alert{display:none !important}" },
  "supergres.com": { s: "#mk-cookie{display:none !important}" },
  "lavoroeconcorsi.com": { s: "#mk-cookie{display:none !important}" },
  "eplan.si": { c: 35 },
  "eplan.bg": { c: 35 },
  "eplan.com.cn": { c: 35 },
  "eplan.hr": { c: 35 },
  "eplan.ro": { c: 35 },
  "eplan.ch": { c: 35 },
  "eplan-sk.sk": { c: 35 },
  "eplan.hu": { c: 35 },
  "eplan.com.tr": { c: 35 },
  "eplan.blog": { j: "5" },
  "pschyrembel.de": { s: "#cbAlert{display:none !important}" },
  "celonis.com": { j: "5" },
  "hygiene-onlineshop.de": {
    s: 'div[id^="ecomas-scch"]{display:none !important}',
  },
  "ableton.com": { s: "#biscuits-overlay{display:none !important}" },
  "ebuyer.com": { s: ".cookies-not-accepted{display:none !important}" },
  "craftsportswear.com": { s: ".slide-in.bottom{display:none !important}" },
  "next-decision.fr": { c: 48 },
  "media.pl": { s: ".ui-notificationbar{display:none !important}" },
  "dkv-euroservice.com": { c: 103 },
  "html5games.com": { j: "5" },
  "meistertask.com": { s: "#cb-wrapper{display:none !important}" },
  "jsitor.com": { j: "5" },
  "idec.org.br": {
    s: "#block-system-main-menu ~ div + div{display:none !important}",
  },
  "psychiatry.org": { s: "#dvPrivacy{display:none !important}" },
  "dalbyherald.com.au": { s: "#pp-notice{display:none !important}" },
  "foto-lambertin.de": { j: "5" },
  "spaceapegames.com": {
    s: "#root > nav ~ div + div{display:none !important}",
  },
  "mcg-digital.de": { c: 5 },
  "boulderholisticvet.com": { c: 5 },
  "gutscheine.welt.de": {
    s: ".wlt-privacy-policy-widget{display:none !important}",
  },
  "freiwald.com": { j: "5" },
  "catpublications.com": { s: "#gtmAlert{display:none !important}" },
  "solid-thueringen.de": { c: 8 },
  "mcrent.de": { j: "5" },
  "wiltmann.de": { s: "#cde{display:none !important}" },
  "juitnow.com": { j: "5" },
  "homebook.pl": { s: ".hb-layout ~ div{display:none !important}" },
  "plein.nl": { j: "5" },
  "wschowa.info": { j: "5" },
  "seriea.pl": { s: '[id^="viewCookies"]{display:none !important}' },
  "undo.net": { s: "#fullpersonal,#fullboxpersonal{display:none !important}" },
  "deandavid.at": { c: 82 },
  "pee.place": { j: "6" },
  "postboxmap.com": { j: "6" },
  "nearest.place": { j: "6" },
  "boley.de": { s: ".ckmsg{display:none !important}" },
  "totallywicked-eliquid.co.uk": { c: 2 },
  "sebgroup.com": { c: 152 },
  "greenpandagames.com": { c: 69 },
  "deces-en-france.fr": { s: ".s-app-cookies{display:none !important}" },
  "ultraedit.com": { s: "#pp_b{display:none !important}" },
  "systemkamera.one": { s: "#privacyopt{display:none !important}" },
  "asv-grosskrotzenburg.de": {
    s: "#mb_boxcookie_banner,.bbody{display:none !important}",
  },
  "truefire.com": { s: ".alert{display:none !important}" },
  "agirc-arrco.fr": { c: 49 },
  "samengezond.nl": { j: "5" },
  "manpowergroup.at": { j: "5" },
  "neuseeland-haus.de": { j: "5" },
  "xscode.com": { s: "xsc-cookies-consent{display:none !important}" },
  "oliverfischer.de": {
    s: ".fullContainer.bgNoRepeat.noBorder{display:none !important}",
  },
  "amix.pl": { s: "#policy{display:none !important}" },
  "hagergroup.com": {
    s: ".cookie-hint-container + #header{top:0 !important}.index__cookie__body + #header + section:first-of-type,.index__cookie__body + #header + a + section:first-of-type{padding-top:0 !important}",
  },
  "playboyrussia.com": { c: 150 },
  "zaochnik.ru": { s: ".agree[data-agreement]{display:none !important}" },
  "holzhandlung-bremerhaven.de": { s: "#cp-inner{display:none !important}" },
  "dehn.at": { j: "5" },
  "eronity.com": { s: "#wantcookies{display:none !important}" },
  "gaana.com": { j: "6" },
  "keltican-forte.de": { j: "5" },
  "greengo.com": { c: 2 },
  "getraenke-news.de": { j: "5" },
  "conseil-national.medecin.fr": { j: "5" },
  "die-akademie.de": { s: "#__next > div:last-child{display:none !important}" },
  "magoshare.com": { s: "#user_popup{display:none !important}" },
  "fiction-addiction.com": { c: 6 },
  "discoverbooks.com": { s: "#privacy_div{display:none !important}" },
  "ing.ru": { s: ".glass,.dialog{display:none !important}" },
  "allnet-flat-vergleich-24.de": {
    s: "#ax_consent_inform{display:none !important}",
  },
  "beckett.com": { s: ".cookieTkd{display:none !important}" },
  "bezuzyteczna.pl": { c: 0 },
  "gesundheitsterminal.de": {
    s: ".jmg-googlemaps-dsgvo-notification{display:none !important}",
  },
  "dewalt.ru": { s: ".test-mode__wrap{display:none !important}" },
  "plcnext-community.net": { c: 17 },
  "lablue.de": { c: 6 },
  "bvkaiserslautern.de": { c: 0 },
  "crowd1.com": { s: ".cookie-concent{display:none !important}" },
  "burg-bentheim.de": { s: ".DSbox{display:none !important}" },
  "abramsbooks.com": { s: "#abr_cookie_modal{display:none !important}" },
  "raiffeisen-laborservice.de": { s: ".nptbccm{display:none !important}" },
  "szekelyhon.ro": { s: "#page-mask{display:none !important}" },
  "envialia.com": { s: ".tco-content-dock{display:none !important}" },
  "byclickeat.fr": { c: 49 },
  "wago.com": { s: ".wg-modal__overlay{display:none !important}" },
  "medidata.ch": { c: 2 },
  "gannikus-original.de": { c: 0 },
  "wsz-marburg.de": { s: "#js-cookie-text{display:none !important}" },
  "sharewise.com": { j: "5" },
  "weilburger.com": { s: ".lus-cookie{display:none !important}" },
  "opito.com": { s: "#app > footer ~ div{display:none !important}" },
  "xn---43-9cdulgg0aog6b.xn--p1ai": { j: "6" },
  "onlinezugangsgesetz.de": { j: "5" },
  "zonmw.nl": { s: ".header-notice{display:none !important}" },
  "aditum.de": { s: "#c_bg{display:none !important}" },
  "haus-des-meeres.at": { j: "5" },
  "novadb.com": {
    s: "#gatsby-focus-wrapper > footer ~ div{display:none !important}",
  },
  "gamingonlinux.com": { j: "5" },
  "alfakassan.se": { c: 0 },
  "esv-schwenger.de": { j: "5" },
  "elrongmbh.de": { j: "5" },
  "dnvgl.com": { c: 6 },
  "bonami.pl": { j: "5" },
  "tvaktuell.com": { j: "5" },
  "dhl.ru": { s: "#modcookie{display:none !important}" },
  "gehrplastics.com": { s: ".module-dataprotection{display:none !important}" },
  "gehr.de": { s: ".module-dataprotection{display:none !important}" },
  "kwyk.fr": { j: "5" },
  "canbeuseful.com": { c: 0 },
  "thenakedpharmacy.com": { c: 2 },
  "qbilon.net": { c: 2 },
  "ffr.fr": { j: "5" },
  "playstation.com": {
    s: '.psw-bottom-left[data-qa="gdpr-setting"]{display:none !important}',
  },
  "atozmath.com": { s: "#consentframe{display:none !important}" },
  "medcalc.org": { s: "#consentframe{display:none !important}" },
  "labyrinthos.co": { s: ".floating.bottom{display:none !important}" },
  "esmarket.gr": { s: "#mstm-cookie{display:none !important}" },
  "cleanairgm.com": { j: "6" },
  "cajeando.com": { c: 0 },
  "cbc.ca": { s: "#alert_modal.privacy{display:none !important}" },
  "aromatika.com.pl": { c: 0 },
  "onsite.fun": { c: 24 },
  "twe.no": { s: "body > div > div:last-child{display:none !important}" },
  "supermedia.pl": { c: 0 },
  "bild-online.dk": { s: "#fixedDiv2{display:none !important}" },
  "spbtv.com": {
    s: '#app > div > div > [class*="container"]{display:none !important}',
  },
  "easypark.fr": { s: '.header > [style*="visible"]{display:none !important}' },
  "makeproaudio.com": { j: "5" },
  "buchcopenhagen.dk": { j: "5" },
  "dragonshop.gr": { c: 80 },
  "medici-stomatologi.ro": { s: "#cookbox{display:none !important}" },
  "multibook.pl": { c: 0 },
  "sozialleistungen.info": { c: 15 },
  "techoral.com": {
    s: "#myCoockie{display:none !important}",
    c: 14,
  },
  "notebookgalerie.de": { s: ".loading-mask{display:none !important}" },
  "e-fundresearch.com": { j: "6" },
  "howsmart.pl": { c: 5 },
  "spw.ru": { s: ".confidential-block{display:none !important}" },
  "sembella.pl": { c: 137 },
  "nobilia.de": { j: "5" },
  "bde.es": { s: "#dvCookies{display:none !important}" },
  "motorsportmarkt.de": { j: "5" },
  "sheego.de": { j: "5" },
  "audacity-kurs.de": { s: ".elo-snackbar{display:none !important}" },
  "search.itaa.be": { j: "5" },
  "feldbusse.de": { s: ".show-cookie .footer{display:none !important}" },
  "edyoda.com": {
    s: '.App [class*="UserConsentBox"]{display:none !important}',
  },
  "ktr.com": { j: "5" },
  "eloboost24.eu": { c: 2 },
  "xiao-mi.fr": { c: 29 },
  "brusarul.com": { c: 0 },
  "hidrive.com": { j: "5" },
  "klaviano.com": { s: "#cooki_box{display:none !important}" },
  "cookmedical.eu": { s: ".cook-cookie-banner{display:none !important}" },
  "bonarkacitycenter.pl": { c: 0 },
  "faktograf.hr": { c: 5 },
  "antarestech.com": { c: 4 },
  "deceuninck.cz": { s: ".popup.block.next-top{display:none !important}" },
  "hoklartherm.de": { s: ".grey_ovarlay{display:none !important}" },
  "nxtbookmedia.com": { s: "#gdpr-pop{display:none !important}" },
  "nxm.ro": { s: ".footer_notif{display:none !important}" },
  "rondel.pl": { s: "#rondelpl_cookies{display:none !important}" },
  "apricon.se": { s: "#glass,#approvebox{display:none !important}" },
  "hotelsbarriere.com": { j: "5" },
  "brico.be": { j: "5" },
  "o2.fr": { j: "5" },
  "schindelhauerbikes.com": { s: "#etrpop{display:none !important}" },
  "trainsweateat.com": {
    s: "#root > div > div:first-child > div + div:last-child{display:none !important}",
  },
  "actionsport-rainbowdivers.de": { j: "5" },
  "vivaconagua.org": { s: "#sccBanner{display:none !important}" },
  "112groningen.nl": { j: "5" },
  "amd.com": { c: 34 },
  "nedeljnik.rs": { s: "#kuki_upozorenje{display:none !important}" },
  "wohnkonzept.co.at": { s: ".ConsentBanner{display:none !important}" },
  "playsnake.org": { c: 0 },
  "playtictactoe.org": { c: 0 },
  "schellenberg.de": { j: "5" },
  "content.de": { s: 'div[id*="hinweis-cookie"]{display:none !important}' },
  "livexlive.com": { s: ".tos-footer{display:none !important}" },
  "kissnofrog.com": { j: "5", s: ".nt-cc{display:none !important}" },
  "konzerthaus-dortmund.de": { j: "5" },
  "egumenita.ro": { c: 0 },
  "dellrefurbished.com": { j: "5" },
  "spandidos-publications.com": {
    s: ".footer > #navbar{display:none !important}",
  },
  "jobbsafari.se": { s: '#__next > [class^="Ufti"]{display:none !important}' },
  "plaster-miodu.pl": { s: "#growls-br{display:none !important}" },
  "dialdirect.co.uk": { c: 5 },
  "leica-microsystems.com": { j: "5" },
  "centogene.com": { j: "5" },
  "affairenmarktplatz.com": { s: "#overlay-content{display:none !important}" },
  "i-parcel.com": { s: ".iparCookieNotice{display:none !important}" },
  "computeruniverse.net": {
    s: ".c-consentLayer__drop{display:none !important}",
  },
  "javea.com": { s: "#dcip-cookies{display:none !important}" },
  "camtasia-training.de": { s: "#lscookr_form{display:none !important}" },
  "fleurop.nl": { s: ".app-info{display:none !important}" },
  "immobilien-zeitung.de": { s: "iz-cookie-banner{display:none !important}" },
  "surveymonkey.de": {
    s: ".mds-gdpr-cookie-banner,.wds-overlay{display:none !important}",
  },
  "groupelaposte.com": { s: "#root > div > div{display:none !important}" },
  "bremerhaven.de": { j: "5" },
  "schoenbrunn.at": {
    s: "#modal-cookie-notice{display:none !important}",
    c: 14,
  },
  "gerarddarel.com": { s: "#cookieLab{display:none !important;z-index:-1}" },
  "kitchentime.no": { c: 2 },
  "kitchentime.se": { c: 2 },
  "kitchentime.fi": { c: 2 },
  "kitchentime.dk": { c: 2 },
  "kitchentime.de": { c: 2 },
  "kitchentime.com": { c: 2 },
  "kiloo.com": { s: ".cmp-main{display:none !important}" },
  "zebrapen.ca": { c: 97 },
  "linfusion.fr": { c: 59 },
  "ankerbrot.at": { j: "5" },
  "bigmeatlove.de": { c: 4 },
  "idera.com": { s: ".idCookiePolicyBanner{display:none !important}" },
  "nikkei.com": {
    s: "k2-privacy-notification,.bpPrivacy,.f-privacy__modal{display:none !important}",
  },
  "nikkeibp.co.jp": { s: ".bpPrivacy{display:none !important}" },
  "dreame-technology.com": { s: ".jsFixedMessage{display:none !important}" },
  "shadowofwar.com": { j: "5" },
  "bretagne.bzh": { s: "#cnil-container{display:none !important}" },
  "bikemag.hu": { s: "#_ning_gdpr_approve{display:none !important}" },
  "dangenentertainment.com": { j: "5" },
  "vedes.com": { s: "#ch{display:none !important}" },
  "vedes.de": { s: "#ch{display:none !important}" },
  "trixie.de": {
    s: ".modal_cookie_banner,#DOMWindowOverlay{display:none !important}",
  },
  "keb.de": { j: "5" },
  "vytenio4.lt": { s: ".cookie-cover{display:none !important}" },
  "dresdner-fachanwaelte.de": { j: "5" },
  "phoenix.de": { j: "3" },
  "targeo.pl": { j: "5" },
  "celeraone.com": { j: "5" },
  "breitbandmessung.de": { j: "5" },
  "jokers.de": { j: "5" },
  "ostufer.net": { s: 'div[id^="popdown"]{display:none !important}' },
  "tohotheater.jp": { s: ".optIn{display:none !important}" },
  "peachnewmedia.com": { c: 103 },
  "profilcultura.it": { c: 2 },
  "dhlparcel.co.uk": { c: 0 },
  "die23er.de": { s: "#ot_consent{display:none !important}" },
  "darting.de": { s: ".acookie{display:none !important}" },
  "ahrsteig.de": { c: 65 },
  "falano.de": { c: 17 },
  "rexel.fr": { c: 14 },
  "rexel.de": { c: 14 },
  "genickbruch.com": {
    s: 'body > div > div[style*="fixed"]{display:none !important}',
  },
  "feuertrutz-katalog.de": { j: "5" },
  "r-raymon-bikes.com": { j: "5" },
  "hw-zuschuss.daimler.com": { c: 49 },
  "xentry.daimler.com": { s: ".xf-cookie-hint-color{display:none !important}" },
  "espadrij.com": { j: "5" },
  "mazda-autopark-rath-duesseldorf.de": { j: "5" },
  "bausep.de": { j: "5" },
  "cataloxy.es": { s: "#cookies_cond{display:none !important}" },
  "nigiara.it": { c: 16 },
  "blitzortung.org": { s: "#topdiv{display:none !important}" },
  "flotte.de": { s: "#rodo{display:none !important}" },
  "mesvoisins.fr": {
    s: '.c-layout-wrap ~ [class*="goodhood"]{display:none !important}',
  },
  "cleveron.com": { s: ".cookie-accept-modal{display:none !important}" },
  "fandomauth.gamepedia.com": { j: "5" },
  "sportpirate.com": { c: 147 },
  "cyclad.org": { s: ".bandeauninfo{display:none !important}" },
  "spektrumsports.com": { c: 2 },
  "xenofit.de": { s: ".xenofit-cookiebar{display:none !important}" },
  "solcom.de": { j: "5" },
  "sigma-foto.de": { s: ".cc-popup-wrapper{display:none !important}" },
  "reputationup.com": { c: 5 },
  "museenkoeln.de": { s: "#ac_cookiebanner{display:none !important}" },
  "job-impulse.com": { j: "5" },
  "speedmeter.sk": { s: "#w_notice{display:none !important}" },
  "pasteleria-jr.es": { j: "5" },
  "osborn.com": { s: ".ob-home-gdpr-banner-widget{display:none !important}" },
  "forumfree.it": { s: ".jnote,body > .note{display:none !important}" },
  "eltasat.cz": { s: ".shadow.ov{display:none !important}" },
  "farmer.pl": { j: "5" },
  "laboutiqueharibo.fr": { s: ".js-HarCookie{display:none !important}" },
  "peoplesenergy.co.uk": { s: "#prefs{display:none !important}" },
  "flowkey.com": {
    s: '#gatsby-focus-wrapper > [role="alert"]{display:none !important}',
  },
  "cassart.co.uk": { s: ".global-promotion{display:none !important}" },
  "model-bazar.cz": { c: 0 },
  "germany.travel": { j: "5" },
  "privacy.net": { s: ".di-cookie-consent-pop{display:none !important}" },
  "innsbruck-airport.com": { j: "5" },
  "psiquiatria.com": { j: "5" },
  "helpucover.co.uk": { c: 4 },
  "finex.cz": { s: ".finex-cookiebar{display:none !important}" },
  "prosenectute.ch": { c: 0 },
  "dlawas.info": { j: "5" },
  "infostrow.pl": { j: "5" },
  "halowawa.pl": { j: "5" },
  "popsockets.co.uk": { c: 14 },
  "largenet.de": { s: "#largenet_consent{display:none !important}" },
  "tw.de": { c: 40 },
  "techpackmobileandgadgetcover.co.uk": {
    s: "body > .alert:nth-of-type(1){display:none !important}",
  },
  "zs1mm.home.pl": { c: 1 },
  "astleyclarke.com": { s: "#ac-cookie-notice{display:none !important}" },
  "polskieskarby.pl": { c: 0 },
  "meble-4you.pl": { j: "5" },
  "roztoczanskipn.pl": { j: "5" },
  "parentclub.scot": { c: 2 },
  "cimetieres-de-france.fr": {
    s: "#js-header-cookie{display:none !important}",
  },
  "calimove.com": { c: 17 },
  "kartell.com": { s: "#gdprPopup{display:none !important}" },
  "orderbird.com": { c: 65 },
  "toggl.com": {
    s: ".toggl-cw-body,.consent-wrapper{display:none !important}",
  },
  "kora.fr": { c: 2 },
  "leirovins.be": { j: "5" },
  "zurich.co.uk": { s: "#opnotification{display:none !important}" },
  "whitepages.com": { s: ".v-snack__wrapper{display:none !important}" },
  "jiosaavn.com": { s: ".c-toast{display:none !important}" },
  "wegrow.info": { c: 14 },
  "clickandtoner.es": { s: "#beapp_cookies{display:none !important}" },
  "britannica.com": { s: ".bk-cookie-alert-snackbar{display:none !important}" },
  "clip-zip.com": { c: 41 },
  "diamantor.fr": { c: 41 },
  "lamaletaintima.com": { c: 41 },
  "lasvinotecas.es": { c: 41 },
  "norskuniform.no": { c: 41 },
  "plaidissimo.fr": { c: 41 },
  "grupovaughan.com": { c: 41 },
  "ehs.tv": { c: 41 },
  "smaer.ro": { c: 41 },
  "todoesled.com": { c: 41 },
  "porezna-uprava.hr": { s: "#cookie,.modal-cookie{display:none !important}" },
  "playmagic.com.mt": { c: 64 },
  "taxi-point.co.uk": { s: ".powr-popup{display:none !important}" },
  "wizconnected.com": { s: ".wiz-cookie-policy{display:none !important}" },
  "vitall.co.uk": { c: 3 },
  "point-s.de": { c: 0 },
  "second-hand-ikea.com": { j: "5" },
  "tbs-aachen.de": { s: ".new_cooky_layer{display:none !important}" },
  "surfacescan.co.uk": { c: 5 },
  "natuurmonumenten.nl": { j: "5" },
  "binance.com": { j: "5" },
  "ewebtrans.com": { s: "#webtrans_cookie_bar{display:none !important}" },
  "schullv.de": { j: "5" },
  "sync.me": { c: 0 },
  "futbollab.com": { s: "#overbox-politica{display:none !important}" },
  "ivideon.com": {
    s: '.iv-ui-website-cookie-compliance,.iv-persistent-notification[data-id*="cookie"],.iv-ui-q2a-cookie-compliance{display:none !important}',
  },
  "oxi-corp.com": { c: 39 },
  "cam4.com": { s: "#promptArea{display:none !important}" },
  "cam4.es": { s: "#promptArea{display:none !important}" },
  "cam4.fr": { s: "#promptArea{display:none !important}" },
  "holodilnik.ru": { s: ".alert-compliance{display:none !important}" },
  "geekjack.net": { c: 3 },
  "vitesse-waterontharder.com": { j: "5" },
  "meder-frankfurt.de": { s: "#ch{display:none !important}" },
  "portalnovosti.com": { c: 0 },
  "amministrazionicomunali.it": { j: "5" },
  "schaecke.at": { c: 14 },
  "impulse.de": { j: "5" },
  "rechtsanwaelte-pesch.de": { s: "#privacy{display:none !important}" },
  "spirou.com": { c: 59 },
  "vr-expert.nl": { c: 5 },
  "dish.com": { s: ".ccpa{display:none !important}" },
  "webdamdb.com": { j: "5" },
  "totallymoney.com": {
    s: ".tm-cookie-banner__spacer{display:none !important}",
  },
  "freeyou.ag": { j: "5" },
  "tickets.motorsport-total.com": {
    s: "#app > div:last-child:not(:only-child){display:none !important}",
  },
  "insomnia.gr": { s: "#elInsomniaCookieBar{display:none !important}" },
  "consolewars.de": { s: ".cookies_dim{display:none !important}" },
  "brightstar.com": { j: "5" },
  "fitnessraum.de": {
    s: ".cc-gdpr-modal{display:none !important}",
    c: 14,
  },
  "elkem.com": { j: "6" },
  "poessl4you.de": { c: 0 },
  "tonershop.at": { j: "6" },
  "coinmarket.network": { s: "#policymodal{display:none !important}" },
  "virtual-railroads.de": { s: ".gdpr_hook{display:none !important}" },
  "formula1game.com": {
    s: "#root > div:not([class]) > div{display:none !important}",
  },
  "heizung-solar24.de": { s: ".becc-ol{display:none !important}" },
  "scandinavianphoto.no": {
    s: '#content-container ~ [style*="height:0"] ~ div{display:none !important}',
  },
  "devmedia.com.br": { s: ".termos-politica{display:none !important}" },
  "verce.me": { j: "6" },
  "cheapenergy24.de": { j: "5" },
  "ujam.com": {
    s: "#ujam-tracking-cookiebanner{display:none !important}",
    c: 14,
  },
  "yoko.de": { j: "5" },
  "ricochet.com": { s: "#ricochet-cookie-bar{display:none !important}" },
  "wwz.ch": { j: "5" },
  "emarketer.com": { s: ".emgdpr-cookies{display:none !important}" },
  "kochen-und-design.de": { c: 1 },
  "napaonline.com": { s: ".CCPA{display:none !important}" },
  "quooker.be": { j: "5" },
  "kofc.org": { s: "kc-cookie-consent{display:none !important}" },
  "spalwart.com": { s: "#wa-message-container{display:none !important}" },
  "die-medienanstalten.de": { j: "5" },
  "porttechnology.org": { c: 5 },
  "taiga.io": { s: ".landend-infobar-dark{display:none !important}" },
  "velkaepocha.cz": { s: ".machr-cookie-message{display:none !important}" },
  "wanted.law": { j: "5" },
  "urgibl.de": { j: "5" },
  "kunzbaumschulen.ch": { j: "5" },
  "ptc-auto.hu": { s: "#hCookiePanel{display:none !important}" },
  "ridero.ru": {
    s: '#app > [class*="cont"],.b-root > [class*="layout"] > [class*="cont"]{display:none !important}',
  },
  "adventuregamestudio.co.uk": { c: 0 },
  "puritech.be": { s: 'div[id*="cookie__modal"]{display:none !important}' },
  "geolive.org": { j: "5" },
  "microchip.com": {
    s: ".cookieSettings,.mchp-cookie{display:none !important}",
  },
  "karkkikuja.fi": { s: "#cp_popup{display:none !important}" },
  "indiatimes.com": {
    s: ".consent-container,.du_consent,.cookie_stng{display:none !important}",
  },
  "stwbs.de": { j: "5" },
  "beertasting.com": { s: ".bts-cookie-notice{display:none !important}" },
  "legomastersloteria.pl": { s: "#cookies_modal{display:none !important}" },
  "urlaubsgruss.com": { s: ".dscheck{display:none !important}" },
  "balkdragers.com": { s: ".stn-cookies{display:none !important}" },
  "computerprofi.com": { j: "5" },
  "lepona.de": { j: "5" },
  "foxxshirts.de": { j: "5" },
  "textil-grosshandel.eu": { j: "5" },
  "sekwens.com": { s: "#module-aboveBox{display:none !important}" },
  "ventocom.at": { j: "5" },
  "resultsbase.net": { j: "5" },
  "hot.at": { j: "5" },
  "hot.si": { j: "5" },
  "hot.dk": { s: "#scw{display:none !important}" },
  "rba.hr": { s: "#cd-module-main{display:none !important}" },
  "rbainvest.hr": { s: "#cd-module-main{display:none !important}" },
  "mathem.se": { j: "5" },
  "nicequest.com": { s: "#footer ~ div{display:none !important}" },
  "orange.pl": {
    s: '#__next > div > section[role="region"],.opl-cookie-control{display:none !important}',
  },
  "stadt-galerie-hameln.de": { s: "#mdl-overlay{display:none !important}" },
  "lifepointspanel.com": { j: "5" },
  "pitstop.de": { j: "5" },
  "schaeffler.fr": { s: ".scha__cookie-banner{display:none !important}" },
  "auchan.ru": { s: "#root > div > footer ~ div{display:none !important}" },
  "migusto.migros.ch": {
    s: '[data-js-module*="cookie-banner"]{display:none !important}',
  },
  "hbs.hu": { s: "#sapper > footer{display:none !important}" },
  "ids-imaging.com": { s: "#privacycheck{display:none !important}" },
  "jateknet.hu": { s: "#profiling-accept{display:none !important}" },
  "esko-catering.de": { c: 2 },
  "agrarshop-online.com": { s: "#darkBack{display:none !important}" },
  "ztedevices.com": { s: ".cookies_tips{display:none !important}" },
  "fernsehturm-stuttgart.de": {
    s: "#modalCookie,#cookieManagment{display:none !important}",
  },
  "dstreet.pl": {
    s: "#ToplayerCover,#ToplayerConsent{display:none !important}",
  },
  "athlinks.com": { s: "#footer-container ~ div{display:none !important}" },
  "skysails-marine.com": { s: ".am-notification{display:none !important}" },
  "checkmyfile.com": { s: "#messageBanner{display:none !important}" },
  "matspar.se": { j: "5" },
  "shpr.fr": { s: "#script_analytics{display:none !important}" },
  "drewag.de": { s: ".mcfCookieAcceptanceContainer{display:none !important}" },
  "zekur.nl": { j: "5" },
  "mitgas.de": { j: "5" },
  "norddeutsch-gesund.de": { j: "5" },
  "regionalnetze-linzgau.de": {
    s: "#backgroundMessagebox{display:none !important}",
  },
  "services.gov.gr": { c: 24 },
  "clargesmayfair.com": { j: "5" },
  "kingstoncentre.co.uk": { j: "5" },
  "moomoo.io": { j: "5" },
  "datasite.com": { s: ".policybar{display:none !important}" },
  "dow.com": { s: ".screenBlockOverlay{display:none !important}" },
  "checkmate.gr": { c: 40 },
  "helium.com": { s: "article > footer ~ div{display:none !important}" },
  "invk.nl": { j: "5" },
  "it-shop24.pl": { c: 0 },
  "degum.de": { s: "#cookiemanager{display:none !important}" },
  "nespresso.com": { s: "#nes_cookie_banner_wrapper{display:none !important}" },
  "regione.lombardia.it": { j: "5" },
  "surfachem.pl": { s: ".rcsc-popup{display:none !important}" },
  "ogladajanime.pl": { j: "5" },
  "tri-shop24.de": { c: 2 },
  "osehero.pl": { j: "5" },
  "pronovabkk.de": { j: "5" },
  "thincast.com": { j: "5" },
  "sprintersports.com": { s: ".cookies-settings{display:none !important}" },
  "ryanair.com": {
    s: "rooms-cookies-policy,.trboModuleContainer,.ryr-cookie-popup{display:none !important}",
  },
  "robe-materiel-medical.com": { s: ".w3-container{display:none !important}" },
  "digitfoto.de": {
    s: "#cookieds,#cookiedsdetails,#bodygrau{display:none !important}",
  },
  "bim.yaskawa.com": { s: ".pop{display:none !important}" },
  "brwahl.de": { j: "5" },
  "betriebsrat.de": { j: "5" },
  "snp-online.de": { j: "5" },
  "verla.de": { j: "5" },
  "madalinliviu.ro": { c: 0 },
  "stadtwerke-stuttgart.de": { c: 161 },
  "magazineexchange.co.uk": { c: 27 },
  "jaimeattendre.com": { s: ".p_CookieConsent{display:none !important}" },
  "turbozentrum.de": { s: "#consentmanager{display:none !important}" },
  "oventrop.com": { j: "5" },
  "jurnalul.ro": { c: 3 },
  "audiotop.pl": { c: 0 },
  "medicina.ru": { s: "#policy{display:none !important}" },
  "avid.com": { j: "5" },
  "houthandelonline.nl": { c: 14 },
  "neucamed.pl": { s: ".cookiesactive .main{margin-top:0 !important}" },
  "mahindra.com": { s: ".privacy-warning{display:none !important}" },
  "neilpatel.com": { s: "#bottom-bar{display:none !important}" },
  "lcp.uk.com": { c: 6 },
  "perfumesclub.com": { c: 0 },
  "medimax.de": { j: "5" },
  "ruegenwalder.de": {
    s: 'body > [id*="csdialog"]{display:none !important}',
    j: "5",
  },
  "developpement-informatique.com": {
    s: ".gdpr-settings{display:none !important}",
  },
  "fass.se": {
    s: "#cookie-dialog-sidebar{display:none !important}#main-content{margin-left:0 !important}",
  },
  "merrell.pl": { j: "5" },
  "powercolor.com": { s: ".Privacy{display:none !important}" },
  "radio8.de": { j: "5" },
  "celticfc.com": { s: ".popup{display:none !important}" },
  "deutschertourismuspreis.de": { j: "5" },
  "markt-oberstdorf.de": { j: "5" },
  "tramino.de": { j: "5" },
  "ok-bergbahnen.com": { j: "5" },
  "hotel-mohren.de": { j: "5" },
  "alpinschule-oberstdorf.de": { j: "5" },
  "oberstdorf.de": { j: "5" },
  "isny.de": { j: "5" },
  "kjell.com": { j: "6" },
  "arteradio.com": { j: "5" },
  "fil-luge.org": { j: "5" },
  "schloss-arkaden.de": { s: "#mdl-overlay{display:none !important}" },
  "codeblick.de": { c: 2 },
  "smelettronica.com": { c: 71 },
  "algoriddim.com": { c: 4 },
  "pruefungshelden.de": { j: "6", s: ".elo-btn{display:none !important}" },
  "anhinternational.org": { j: "5" },
  "4webs.es": { s: "#cookiesdiv{display:none !important}" },
  "abfallwirtschaft-loerrach-landkreis.de": {
    s: "#advertArea{display:none !important}",
  },
  "amzpecty.com": { j: "5" },
  "m-plan.com": { c: 65 },
  "wienenergie.at": { j: "5" },
  "oxinst.com": { j: "5" },
  "szkolnenaklejki.pl": { c: 0 },
  "bueffelbill.com": { s: ".cn{display:none !important}" },
  "stiftungsland.de": { c: 8 },
  "matkahuolto.fi": {
    s: "#gatsby-focus-wrapper > div > div > div{display:none !important}",
  },
  "eufylife.com": { s: "#app > div:last-child{display:none !important}" },
  "austrian-standards.at": {
    s: ".as-consent-wrapper{display:none !important}",
  },
  "hawe.com": { c: 77 },
  "aha-buch.de": { s: ".bg{display:none !important}" },
  "obd2-elm327.es": { s: ".KS-cookies-div{display:none !important}" },
  "glavcom.ua": { s: ".kyk_menu{display:none !important}" },
  "iif.com": { s: ".Popup-overlay{display:none !important}" },
  "telekom.com": { j: "5" },
  "highlight-led.de": {
    s: "#PrivacyCategoryAlert{display:none !important}",
    c: 14,
  },
  "pizzabakeren.no": { s: ".politics_box{display:none !important}" },
  "pizza-baker.com": { s: ".politics_box{display:none !important}" },
  "pizzabaker.co.uk": { s: ".politics_box{display:none !important}" },
  "zomato.com": {
    s: "#root > div:first-child:not(:only-child){display:none !important}",
  },
  "pizza-markdorf.de": { c: 2 },
  "pizza-pepe-volkach.de": { j: "5" },
  "toni-maccaroni.de": { j: "5" },
  "aldiventskalender.de": {
    s: ".cookie-consent-nord-app{display:none !important}",
  },
  "electrogarden.pl": { c: 0 },
  "tammah.com": { s: ".slideInUp{display:none !important}" },
  "bundesanzeiger.de": { j: "5" },
  "unternehmensregister.de": { j: "5" },
  "covid19.gov.lv": { s: ".gdpr_discplaimer{display:none !important}" },
  "data.gov.lv": { s: "#AnalyticsPrompt{display:none !important}" },
  "gov.lv": { j: "5" },
  "riga.lv": { j: "5" },
  "iq.com": { j: "5" },
  "farmina.com": { c: 0 },
  "rum21.no": { s: "#root > div:last-child > span{display:none !important}" },
  "pracuj.pl": { s: ".cookie-agreements{display:none !important}" },
  "harvard.edu": { s: "#osmyModal{display:none !important}" },
  "lindenberg-bringts.de": { j: "5" },
  "hellospain.de": { c: 41 },
  "pushsquare.com": { s: ".dgp-consent{display:none !important}" },
  "bike-components.de": { j: "5" },
  "unimi.it": { s: "body > .container > .alert{display:none !important}" },
  "searchengines.guru": { s: ".float-vertical-panel{display:none !important}" },
  "mcmusic.ro": { s: "#ccContainer{display:none !important}" },
  "schwarzlicht.de": { c: 0 },
  "dji.com": {
    s: '#cookie-tip,div[class*="style__cookie-policy"],.cc-bar,.cc-window{display:none !important}',
  },
  "royaldanishacademy.com": { s: ".b14cc{display:none !important}" },
  "dailybest.it": { s: "#bcc-black,#bcc-consent{display:none !important}" },
  "rockit.it": { s: "#bcc-black,#bcc-consent{display:none !important}" },
  "monalbumphoto.fr": { s: ".arc3-cookie-bar{display:none !important}" },
  "wetaca.com": { s: ".main > div ~ div:last-child{display:none !important}" },
  "gurtshop.de": { s: ".sticky-wrapper{display:none !important}" },
  "aimotive.com": { j: "6" },
  "volkswohnung.com": { s: ".vw-cookiebanner{display:none !important}" },
  "tsouvelas.gr": { s: ".glcn_accept_cookie{display:none !important}" },
  "lsvd.de": { s: "#consent-request{display:none !important}" },
  "victoriananursery.co.uk": { c: 0 },
  "mobilepay.dk": { s: 'div[class*="cookie-dialog"]{display:none !important}' },
  "filecleaner.com": { s: ".cs{display:none !important}" },
  "schaeffler.de": { s: ".scha__cookie-banner{display:none !important}" },
  "intexty.com": { c: 2 },
  "toby.ink": { s: "#cookie_kwan{display:none !important}" },
  "ellexgk.cz": { c: 154 },
  "boxeez.no": { s: ".bz-no-click{display:none !important}" },
  "finansavisen.no": {
    s: "#finansavisen-gdpr-disclaimer{display:none !important}",
  },
  "kapital.no": { s: "#finansavisen-gdpr-disclaimer{display:none !important}" },
  "vzajemna.si": { c: 0 },
  "akubiz.biz": { c: 0 },
  "biotechusa.hu": { j: "5" },
  "biotechusa.fr": { j: "5" },
  "sixt-neuwagen.de": { j: "5" },
  "sixt-leasing.de": { j: "5" },
  "csub.edu": { s: "#consent-box{display:none !important}" },
  "heinrich-heine-schule.net": { c: 4 },
  "mocopinus.com": { c: 8 },
  "bhw.de": { j: "5" },
  "aptoide.com": { j: "5" },
  "co.aptoide.com": { s: "#news{display:none !important}" },
  "deno.land": { s: ".bg-black > .max-w-screen-xl{display:none !important}" },
  "aquaristic.net": { j: "5" },
  "ekosklad.si": { c: 0 },
  "manus-zeitforum.de": { s: "#cookie-shit{display:none !important}" },
  "everydaymarksman.co": { c: 5 },
  "norres.com": { j: "5" },
  "editalo.pro": { c: 5 },
  "skagerak.dk": { s: ".popup-msg{display:none !important}" },
  "gw2mists.com": { s: ".gm-cookie-consent{display:none !important}" },
  "grzejemy.pl": { c: 0 },
  "dahag.de": { s: "#dah-consent-manager-overlay{display:none !important}" },
  "photoephemeris.com": {
    s: '#root > [style*="fixed"]{display:none !important}',
  },
  "bestinver.es": { s: "#bst-cookie-alert{display:none !important}" },
  "tantris.de": { j: "5" },
  "doleasingu.com": { j: "5" },
  "puratos.pl": { j: "5" },
  "viennahouse.com": { j: "5" },
  "khw-ortenau.de": { s: "#bottom_popup{display:none !important}" },
  "hamburgische-buergerschaft.de": {
    s: "#hbCookieLayer{display:none !important}",
  },
  "meteovista.co.uk": { c: 73 },
  "meteovista.de": { c: 73 },
  "meteovista.com": { c: 73 },
  "legs.com.pl": { c: 2 },
  "findmypast.co.uk": {
    s: '#skip-to-content-link + div > [style*="transform"],#skip-to-content-link ~ [style*="transform"] {display:none !important}',
  },
  "national-lottery.co.uk": {
    s: "#cu_k_modal_main_box{display:none !important}",
  },
  "cosmos.network": {
    s: "#app > div > .banner-wrapper{display:none !important}",
  },
  "tele2.de": { j: "5" },
  "leireg.de": { j: "5" },
  "orbiprime.com": { s: "#privacy{display:none !important}" },
  "phonemore.com": { c: 3 },
  "ihreapotheken.de": { j: "5" },
  "correos.com": { s: "#myCookies{display:none !important}" },
  "campusjaeger.de": { j: "5" },
  "aral.de": { j: "5" },
  "simplyhealth.co.uk": { s: "#sh-cookie-banner{display:none !important}" },
  "indacoin.com": { s: '#root > div[style*="block"]{display:none !important}' },
  "116117.de": { s: ".layer-cookie{display:none !important}" },
  "narzedziawarszawa.pl": { c: 0 },
  "islandfreund.de": { j: "5" },
  "nickles.de": { j: "5" },
  "kronikaonline.ro": { s: "#page-mask{display:none !important}" },
  "parcel2go.com": { j: "6" },
  "lotosnavigator.pl": { c: 7 },
  "lemonade.com": { j: "5" },
  "brimfinancial.com": { s: ".statement_block{display:none !important}" },
  "schauspiel.koeln": { s: ".dataprotection{display:none !important}" },
  "parkster.com": { j: "5" },
  "wedoogift.com": {
    s: "wdgg-cookies-preferences-banner{display:none !important}",
  },
  "buffer.com": {
    s: '#__next > div > [class*="Banner"]{display:none !important}',
  },
  "enercoop.fr": { s: "#cookieLab{display:none !important}" },
  "hifi-schluderbacher.de": { c: 39 },
  "ponal.de": { j: "5" },
  "studentbeans.com": {
    s: 'body > div[data-hypernova-key^="Pages"] > div:not([style]){display:none !important}',
  },
  "rspb.org.uk": { s: ".cookie-preferences{display:none !important}" },
  "selgros.de": { s: "#overlay-oiljs{display:none !important}" },
  "radio886.at": { j: "5" },
  "vomar.nl": { s: "sw-cookiemessage{display:none !important}" },
  "primrose.co.uk": { c: 0 },
  "pizza-david.at": {
    s: "#app > .v-overlay,#app > .v-dialog__content{display:none !important}",
  },
  "intelligencefusion.co.uk": { c: 2 },
  "aiways-u5.nl": { j: "5" },
  "esquinarayuela.es": { j: "5" },
  "actiris.brussels": { s: ".cl-banner{display:none !important}" },
  "ledepartement66.fr": { s: ".cookie-bottom{display:none !important}" },
  "worldbank.org": { s: ".privacy-widget{display:none !important}" },
  "circuitmess.com": {
    s: "#main-app-container ~ div + div{display:none !important}",
  },
  "draco.de": { j: "5" },
  "buchbinder.de": { j: "5" },
  "nooch.ch": { c: 0 },
  "av-atlas.org": { j: "5" },
  "sportradio360.de": { c: 83 },
  "electronieto.es": { j: "5" },
  "controlewiki.be": { c: 0 },
  "deutschland-gegen-corona.org": {
    s: '#___gatsby > div > main > div[style*="fixed"]{display:none !important}',
  },
  "skagenfondene.no": { s: ".skagen-consent{display:none !important}" },
  "ybs-home-insurance.co.uk": {
    s: "#app > .container-fluid{display:none !important}",
  },
  "simplybook.it": { s: "#sb_cookies_block{display:none !important}" },
  "native-instruments.com": { j: "5" },
  "senmotic-shoes.eu": { j: "5" },
  "jobruf.de": { j: "5" },
  "city-center-chorweiler.de": {
    s: ".mdl-modal__backdrop,#mdl-overlay{display:none !important}",
  },
  "viataverdeviu.ro": { c: 0 },
  "brplynx.com": { s: "#consent-dialog{display:none !important}" },
  "wsldp.com": { c: 11 },
  "romertopfwinkel.nl": {
    s: "#wizkom-js-app > .fixed{display:none !important}",
  },
  "hochparterre.ch": { c: 2 },
  "tvprograma.lt": { s: ".cookieBubble{display:none !important}" },
  "bcu.ac.uk": { s: ".action-bar{display:none !important}" },
  "publikations-plattform.de": { j: "5" },
  "e-coop.it": { c: 0 },
  "thermengutscheine.at": { s: "#cmp-container{display:none !important}" },
  "festivo.de": { j: "5" },
  "campingwiesenbek.de": { j: "5" },
  "mercateo.sk": { s: "#header-popup-info{display:none !important}" },
  "ihtsdotools.org": { j: "5" },
  "fan.com.pl": { c: 0 },
  "ubs.com": { s: ".lightbox__container{display:none !important}" },
  "moto-opinie.info": { c: 77 },
  "jobst-mobile.de": { s: "#datenschutzBalgeNew{display:none !important}" },
  "half-the-battle.de": {
    s: 'div[data-editable*="CookieNotif"]{display:none !important}',
  },
  "dewalt.global": { s: "#block-privacypopup{display:none !important}" },
  "maereservation.sport2000.fr": { j: "5" },
  "strasbourg-europe.eu": { c: 5 },
  "technomarket.bg": { j: "5" },
  "asociacion-domitila.es": { j: "5" },
  "ntg24.de": { s: ".consent-wrapper{display:none !important}" },
  "diamantschleifer.net": { s: ".avia-popup{display:none !important}" },
  "prenumerata24.pl": { c: 0 },
  "diana-klinik.de": { s: ".asktracking{display:none !important}" },
  "argutus.de": { j: "5" },
  "galeriabaltycka.pl": {
    s: ".mdl-modal__backdrop,#mdl-overlay{display:none !important}",
  },
  "regen.network": {
    s: "#gatsby-focus-wrapper > div:not([class]) + div{display:none !important}",
  },
  "geiger-edelmetalle.de": {
    s: 'div[class*="cookie-consent"]{display:none !important}',
  },
  "honeygain.com": {
    s: "#root > footer ~ div,#root > div + div + div:last-child{display:none !important}",
  },
  "castforward.de": { s: ".footer-box ~ div{display:none !important}" },
  "swatch.com": { j: "5" },
  "greatis.com": { s: "#cookie-greatis{display:none !important}" },
  "medtronic-diabetes.nl": {
    s: ".block-medtronic-cookie{display:none !important}",
  },
  "forget.finance": { s: "#root > .MuiBox-root{display:none !important}" },
  "perfectpetinsurance.co.uk": {
    s: "#root > div > div:first-child:not(:only-child){display:none !important}",
  },
  "matthys.net": { j: "5" },
  "dictionnaire-synonyme.com": { c: 0 },
  "eam.de": { j: "5" },
  "eam-netz.de": { j: "5" },
  "faberkabel.de": { j: "5" },
  "alfredflechtheim.com": {
    s: ".SetNewMessageForUser{display:none !important}",
  },
  "postcodeloterij.nl": { s: "#container ~ [class]{display:none !important}" },
  "dyclassroom.com": { s: "#dy-cookieInfo-container{display:none !important}" },
  "tipser.co": { s: "#tnw_cookieconsent{display:none !important}" },
  "severin.de": { c: 14 },
  "mariecurie.org.uk": { s: ".cookie__menu__overlay{display:none !important}" },
  "deutsche-buchhandlung.de": { s: ".bg{display:none !important}" },
  "finanzpartner.de": { s: "#cc-button{display:none !important}" },
  "eon-highspeed.com": { j: "5" },
  "interestuff.com": { c: 1 },
  "sherwin-williams.com.br": { j: "5" },
  "graphs.ro": { s: "#cookietop{display:none !important}" },
  "geox-shop.de": { s: "#P_Consent_Manager{display:none !important}" },
  "melkshaminsurance.co.uk": { c: 0 },
  "bastler-zentrale.de": { s: "#dsok,#coplh{display:none !important}" },
  "jeugdbrandweer.nl": { j: "5" },
  "solvo.nl": { j: "5" },
  "vivat.de": { s: ".cs-cookie__wrapper{display:none !important}" },
  "zoo-leipzig.de": {
    s: ".cs-cookie__wrapper{display:none !important} [inert]{pointer-events: unset !important}",
  },
  "gamesfull.org": { c: 0 },
  "adtpostales.com": { s: ".loadingCookies{display:none !important}" },
  "veygo.com": { j: "5" },
  "periodex.co": { s: ".p-banner{display:none !important}" },
  "permettezmoideconstruire.fr": {
    s: ".alert-overlay{display:none !important}",
  },
  "moser.com": { c: 0 },
  "coopcad.it": { s: "#Banner{display:none !important}" },
  "vakcinainfo.gov.hu": { c: 105 },
  "steamstatus.io": { s: ".modal-bg{display:none !important}" },
  "polder.se": {
    s: ".sd-surface-top > .sd-object-if{display:none !important}",
  },
  "fastweb.it": { s: ".ck_if{display:none !important}" },
  "miniatures.com": { s: "#complianceBar{display:none !important}" },
  "restaurant-tribeca.com": { c: 5 },
  "walloniebelgiquetourisme.be": {
    s: ".block--cookie{display:none !important}",
  },
  "stadtenergie.de": { j: "5" },
  "otzyvua.net": { c: 3 },
  "cs.money": { c: 9 },
  "wiki.cs.money": { c: 65 },
  "siriusxm.com": {
    s: '#UserAgreement[data-componenttype="CookieBar"]{display:none !important}',
  },
  "boerse-stuttgart.de": {
    s: ".bsg-cookie-layer{display:none !important}",
    j: "5",
  },
  "traderfox.com": { j: "5" },
  "finanzen.net": { j: "5" },
  "rebrainme.com": { s: ".cookie-push{display:none !important}" },
  "moparshop.com": {
    s: "#moparshop--cookie-consent-manager{display:none !important}",
  },
  "bitamp.com": { s: ".welcome-popup{display:none !important}" },
  "bim.com.tr": { s: ".cookie-window-select{display:none !important}" },
  "loading.com.br": { c: 5 },
  "easylife.co.uk": { c: 6 },
  "photoshop-kopona.com": { s: ".message-alert{display:none !important}" },
  "track-trace.com": { j: "5" },
  "pakkesporing.no": { j: "5" },
  "forstasidorna.se": { j: "5" },
  "forsidene.no": { j: "5" },
  "hitachivantara.com": {
    s: ".hv_privacy_prompt,.cPLAcceptCookies{display:none !important}",
  },
  "rbc.ua": { s: "#privasypolicy-info,.privacy{display:none !important}" },
  "zmienolej.pl": { j: "5" },
  "hotels-insolites.com": { c: 0 },
  "99app.com": { j: "5" },
  "spyflix.com": { s: "#consentPopup{display:none !important}" },
  "altin.in": { s: "#kvkk{display:none !important}" },
  "activobank.pt": { c: 0 },
  "ghostery.com": { s: "#ghostery-consent{display:none !important}" },
  "fotooehlmann.com": {
    s: "#modal_cct{display:none !important}",
    c: 14,
  },
  "embl.org": { s: ".vf-banner{display:none !important}" },
  "zodio.fr": { s: ".zo-cookie__banner{display:none !important}" },
  "friedrich-maik.com": { j: "5" },
  "adchitects.co": { c: 0 },
  "corona.fo": { s: "#__qookies_habitat{display:none !important}" },
  "politikon.es": { c: 0 },
  "lamoda.ua": { s: ".page > .vue-widget{display:none !important}" },
  "atlant.by": { s: ".confirm-panel{display:none !important}" },
  "teamaretuza.com": { j: "5" },
  "lahitapiola.fi": { s: "#cookieTopCOntainer{display:none !important}" },
  "golfpass.com": { s: ".PolicyBanner{display:none !important}" },
  "orleans-metropole.fr": { s: ".cookie_enabled{display:none !important}" },
  "bitcoin.org": {
    s: '#root > .flex > div[class*="max"]{display:none !important}',
  },
  "feld-eitorf.de": { s: ".feld-cookienotice{display:none !important}" },
  "feld-eitorf.at": { s: ".feld-cookienotice{display:none !important}" },
  "monespaceclient.immo": { j: "5" },
  "hotels.com": { s: "#root > footer ~ section{display:none !important}" },
  "lottofy.com": { s: "#alertsMarquee{display:none !important}" },
  "ose.gov.pl": { j: "5" },
  "beckmann-kg.de": { s: "#consentLayer{display:none !important}" },
  "homeful.ly": { s: "#__next > .container{display:none !important}" },
  "schauinsland-reisen.de": {
    s: "#block-trackinginformationen{display:none !important}",
  },
  "patrickholford.com": { c: 0 },
  "tryggivann.no": { s: "#panCookiedisc{display:none !important}" },
  "honeywellhome.com": { s: ".homes-bp-cookiebanner{display:none !important}" },
  "what-matters.fr": {
    s: "#__next > div:last-child > div:last-child{display:none !important}",
  },
  "computerbase.de": { j: "5" },
  "keepersecurity.com": { j: "5" },
  "concrete-jungle.de": { s: ".banner{display:none !important}" },
  "infovac.ch": { s: ".eb-acc{display:none !important}" },
  "onb.ac.at": { c: 71 },
  "sass-ag.de": { s: ".ccp{display:none !important}" },
  "adoc.pub": { s: "#ADOCPUB_cookie_box{display:none !important}" },
  "beautywelt.de": { j: "5" },
  "auto-motor.at": { s: "#footer ~ #myModal{display:none !important}" },
  "ditto.fm": { j: "5" },
  "paninimania.com": { s: "#id_acco{display:none !important}" },
  "staedtler.com": { s: "staedtler-cookie-banner{display:none !important}" },
  "onepiecewt100.com": { c: 3 },
  "drogarianovaesperanca.com.br": {
    s: ".dgf-cookies{display:none !important}",
  },
  "dascom.co.uk": { c: 8 },
  "damensein.com": { s: ".welcome-modal{display:none !important}" },
  "krediidiraportid.ee": { s: ".kred-cookiemessage{display:none !important}" },
  "nationalprivacytest.org": { c: 142 },
  "365scores.com": {
    s: ".is-gdpr-visible ~ .toaster{display:none !important}",
  },
  "brandenburg.de": { s: ".ckb{display:none !important}" },
  "theheinekencompany.com": { j: "5" },
  "exporterhub.io": {
    s: 'main > div > section > [style*="fixed"]{display:none !important}',
  },
  "howmanyfps.com": { s: ".ReactModalPortal{display:none !important}" },
  "88nightmarket.com": { c: 0 },
  "weople.space": { j: "5" },
  "onzeveilingonline.nl": { c: 2 },
  "cioreview.com": { s: "#footerr{display:none !important}" },
  "webdeasy.de": { c: 34 },
  "checkrobin.com": { s: "#privacybox{display:none !important}" },
  "wearetennis.bnpparibas": { j: "5" },
  "teliacompany.com": { s: ".tc-modal{display:none !important}" },
  "explore.porto.pt": { j: "5" },
  "xpay.de": { s: "#xpCookieBanner{display:none !important}" },
  "knubel.de": { s: "#ConsentMsg.NotYetSelected{display:none !important}" },
  "foodengineeringmag.com": { j: "5" },
  "pcimag.com": { j: "5" },
  "assemblymag.com": { j: "5" },
  "securitymagazine.com": { j: "5" },
  "openfoodnetwork.org.uk": { j: "5" },
  "oetker.de": { s: ".pd-main{display:none !important}" },
  "5ingredients15minutes.com": {
    s: ".gpdr-agreement{display:none !important}",
  },
  "altmarkt-galerie-dresden.de": {
    s: ".mdl-modal__backdrop,#mdl-overlay{display:none !important}",
  },
  "shop.teekampagne.de": { c: 1 },
  "travelski.com": { s: "#tf-cookie{display:none !important}" },
  "kraehe.de": { s: ".nav-cookie{display:none !important}" },
  "medienzentrumonline.eu": { c: 14 },
  "tredy-fashion.de": { j: "5" },
  "entsoe.eu": { j: "5" },
  "krant.volkskrant.nl": { j: "3" },
  "krant.dg.nl": { j: "3" },
  "krant.demorgen.be": { j: "3" },
  "krant.trouw.nl": { j: "3" },
  "krant.ad.nl": { j: "3" },
  "krant.parool.nl": { j: "3" },
  "krant.ed.nl": { j: "3" },
  "zencare.org": { c: 5 },
  "huber.de": { j: "5" },
  "freudenberg.com": { j: "5" },
  "sklep.3mk.pl": { c: 0 },
  "newpharma.be": { j: "5" },
  "sabinastore.com": { j: "5" },
  "xiaomiromania.com": { j: "5" },
  "city-sightseeing.it": { s: ".csi-cookie-banner{display:none !important}" },
  "iys.org.tr": { s: ".cerezall{display:none !important}" },
  "propb.ru": { s: ".cooke{display:none !important}" },
  "risingtide-foundation.org": { s: "#fcCookie{display:none !important}" },
  "vwg.de": { s: ".wgc-cookie-box{display:none !important}" },
  "pfeffi.com": { j: "5" },
  "3daimtrainer.com": { s: ".cookiemodal{display:none !important}" },
  "struttandparker.com": {
    s: ".important-message-banner{display:none !important}",
  },
  "affittapresto.it": { s: "#cookie-dett{display:none !important}" },
  "paylax.de": { s: "#app > div > div:first-child{display:none !important}" },
  "halsoresurs.se": { s: ".cookie-mess{display:none !important}" },
  "rtlmost.hu": {
    s: ".app__content ~ div > .not-empty{display:none !important}",
  },
  "daa.de": { j: "5" },
  "tosdr.org": { s: ".toast.fixed-bottom{display:none !important}" },
  "powercord.dev": { s: "#react-root > footer ~ div{display:none !important}" },
  "grugliasco.to.it": { c: 0 },
  "rsj.com": { c: 0 },
  "pazarluk.com": { j: "5" },
  "vorteilshop.com": { j: "5" },
  "personalshop.com": { j: "5" },
  "chromeenterprise.google": {
    s: ".ce-cookie-banner{display:none !important}",
  },
  "subwayrewards.fr": {
    s: "#root > div > .green-link{display:none !important}",
  },
  "subwayrewards.at": {
    s: "#root > div > .green-link{display:none !important}",
  },
  "subwayrewards.de": {
    s: "#root > div > .green-link{display:none !important}",
  },
  "lhv.ee": { j: "5" },
  "goin.app": { s: "#__next > [style]{display:none !important}" },
  "jeanfil.fr": { c: 59 },
  "apollographql.com": {
    s: "#gatsby-focus-wrapper > .body ~ div{display:none !important}",
  },
  "toner.shop": { s: ".CookiesOk{display:none !important}" },
  "artemiskliniken.de": { s: "#myCookie{display:none !important}" },
  "minitab.com": { s: "#cpToaster{display:none !important}" },
  "aukcije.hr": { j: "5" },
  "severeweather.wmo.int": { c: 3 },
  "dzieje.pl": { c: 0 },
  "steigmiller.bio": { j: "6" },
  "vastelastenbond.nl": { s: ".vlb-cookies{display:none !important}" },
  "webmotors.com.br": { s: "#root > div{display:none !important}" },
  "e-mobile.ch": { s: ".site_notification{display:none !important}" },
  "herbiolys.fr": { c: 41 },
  "ag-visuell.de": { s: ".animating-screenIn-exit{display:none !important}" },
  "posttoday.com": { s: "#box-policy{display:none !important}" },
  "foodora.se": { s: ".top-banner-container{display:none !important}" },
  "foodora.no": { s: ".top-banner-container{display:none !important}" },
  "foodora.fi": { s: ".top-banner-container{display:none !important}" },
  "coingate.com": { c: 24 },
  "gettyimages.nl": { s: "#toaster-modal{display:none !important}" },
  "gettyimages.de": { s: "#toaster-modal{display:none !important}" },
  "eltern-bildung.at": { c: 11 },
  "crosscall.com": { s: ".consent-tracking{display:none !important}" },
  "werraenergie.de": { s: "#smartweb-eucookie-werra{display:none !important}" },
  "framer.com": { j: "5" },
  "nordusdecospan.com": { s: ".gdprForm{display:none !important}" },
  "geenstijl.nl": { j: "5" },
  "futurezone.at": { j: "5" },
  "profil.at": { j: "5" },
  "kurier.at": { j: "5" },
  "omroepbrabant.nl": { j: "5" },
  "cloudvps.nl": { j: "5" },
  "transip.nl": { j: "5" },
  "transip.eu": { j: "5" },
  "luftfahrtmuseum-wernigerode.de": { c: 40 },
  "dom-buchhandlung.de": { c: 103 },
  "buch-zur-heide.de": { c: 103 },
  "ratemyprofessors.com": {
    s: "#ccpa-footer,.reveal-modal-bg{display:none !important}",
    j: "5",
  },
  "forcepoint.com": { c: 6 },
  "mietz.app": { j: "5" },
  "ratatype.es": { s: ".alert-bottom{display:none !important}" },
  "syntusoverijssel.nl": { s: ".hc-banner{display:none !important}" },
  "eglue.it": {
    s: 'div[style*="inherit"] > div > div > div[style*="92"]{display:none !important}',
  },
  "admiral.com": { s: "hub-gdpr-popup{display:none !important}" },
  "cryptoquant.com": { s: "#__next > div > .ant-row{display:none !important}" },
  "sporx.com": { s: "#consentdiv{display:none !important}" },
  "phpipam.net": { c: 0 },
  "meine-bankid.de": { c: 49 },
  "vodafonemail.de": { s: "#cmpWrapper{display:none !important}" },
  "2020.swatch.com": { s: ".reveal-modal-bg{display:none !important}" },
  "edding.com": { s: ".e-note__cookies{display:none !important}" },
  "personalideal.de": { j: "5" },
  "sanko-solar.de": { s: ".avg-bar{display:none !important}" },
  "waterfall-d-mannose.com": { s: "#cc-cont{display:none !important}" },
  "emb-gmbh.de": { j: "5" },
  "entschuldigung.net": { s: "#divModalScreen{display:none !important}" },
  "charleslandaudentistry.co.uk": {
    s: "#cc-container{display:none !important}",
  },
  "eurozine.com": { c: 0 },
  "paschal.de": { s: "#decker{display:none !important}" },
  "togetherall.com": { s: ".light--MuiSnackbar-root{display:none !important}" },
  "notebookitalia.it": { c: 29 },
  "glassnode.com": { s: "#root > div:last-child{display:none !important}" },
  "glorian.org": { c: 29 },
  "mts.ru": { s: ".is-cookie-alert{display:none !important}" },
  "telemarket24.ru": { s: ".disklay-box{display:none !important}" },
  "lysa.se": { s: ".snackbar-wrapper{display:none !important}" },
  "filmstreaming-de.life": { s: ".notifier{display:none !important}" },
  "mroom.com": { s: "#cookies-check{display:none !important}" },
  "my.mroom.com": { j: "5" },
  "pickup.de": { j: "5" },
  "estadao.com.br": { s: ".lgpd-modal-content{display:none !important}" },
  "evarazdin.hr": { j: "5" },
  "gc.ca": { s: ".CookieModal{display:none !important}" },
  "5miles.com": { j: "5" },
  "okpedia.org": { c: 16 },
  "lizak-partner.at": { j: "5" },
  "file2send.eu": { j: "5" },
  "scamner.com": { c: 0 },
  "schulze-immobilien.de": {
    j: "5",
    s: ".wrap__undone{display:none !important}",
  },
  "ihk-nuernberg.de": { c: 17 },
  "townsmith.de": { c: 49 },
  "gemu-group.com": { c: 9 },
  "ace-ace.com": { j: "5" },
  "99airdrops.com": { s: ".legal-notice{display:none !important}" },
  "strato.de": { j: "5" },
  "noodweer.be": { j: "5" },
  "videoload.de": { j: "5" },
  "magentatv.de": { j: "5" },
  "billomat.com": { j: "5" },
  "teutoburger-muenzauktion.de": { j: "5" },
  "traxmag.com": { j: "5" },
  "generation-s.fr": { j: "5" },
  "bati-info.be": { s: 'div[class*="cookie-alert"]{display:none !important}' },
  "tecedo.at": { s: ".msg-banner{display:none !important}" },
  "lsdlibri.it": {
    s: "#inibisci_sfondo,.fullscreen_box_legale{display:none !important}",
  },
  "ubuntu18.com": { c: 11 },
  "xalingo.com.br": { s: "#wrng-agrmnt{display:none !important}" },
  "burg-lindenfels.de": { c: 0 },
  "numuki.com": { c: 4 },
  "inwerk.de": { j: "5" },
  "bioplanete.com": { j: "5" },
  "metradar.ch": { s: "#closeonaction{display:none !important}" },
  "purexbox.com": { s: ".dgp-consent{display:none !important}" },
  "taste-of-koroni.de": { c: 4 },
  "etowine.com": { c: 0 },
  "imagelinenetwork.com": { j: "5" },
  "swoodie.de": {
    s: '.module-wrap[data-label="Popup"].showPopup,.gf-popupOverlay{display:none !important}',
  },
  "laver.co.uk": { c: 0 },
  "factoryoficina.com": { c: 41 },
  "pharmazeutische-zeitung.de": { j: "5" },
  "digitalland.de": { s: "#ccm{display:none !important}" },
  "getir.com": { s: '#__next > [class*="Drawer"]{display:none !important}' },
  "teambank.de": {
    s: "cookie-layer,.cdk-overlay-container{display:none !important}",
  },
  "kupzidle.cz": { s: "body > .shadow{display:none !important}" },
  "what3words.com": { j: "5" },
  "bancaditalia.it": { j: "5" },
  "campbellsoup.co.uk": { c: 0 },
  "biathlonresults.com": { s: "popup-container{display:none !important}" },
  "prawdziwyonline.pl": { s: "#pp-consent{display:none !important}" },
  "kinoheld.de": { j: "6" },
  "orizonstore.gr": { c: 71 },
  "alexanderhall.co.uk": { j: "5" },
  "modrykonik.sk": { j: "5" },
  "besthomepageever.com": {
    s: "#modalCookie1{display:none !important}",
    c: 14,
  },
  "arcor.de": { s: "#cmpWrapper{display:none !important}" },
  "kanebo.com": { s: ".tmp-privacyNotice{display:none !important}" },
  "bafin.de": { j: "5" },
  "automobilwoche.de": { s: "#ccm{display:none !important}" },
  "5vor12.de": { s: ".consent_banner{display:none !important}" },
  "jimenezmovilidad.es": { c: 0 },
  "calm.com": { s: "#cookie-preferences-banner{display:none !important}" },
  "otv.de": { j: "5" },
  "nordicbet.dk": { c: 32 },
  "nordicbet.com": { c: 32 },
  "urbanista.de": { j: "5" },
  "chiptehnika.si": { s: ".noty_cont{display:none !important}" },
  "theweathernetwork.com": { s: ".woahbar{display:none !important}" },
  "meteomedia.com": { s: ".woahbar{display:none !important}" },
  "warp2search.net": { c: 100 },
  "doopla.pl": { s: "div[cmp]{display:none !important}" },
  "elektriker-wissen.de": { s: "#f_cookie{display:none !important}" },
  "amway.it": { j: "5" },
  "amway.es": { j: "5" },
  "planet-beruf.de": { s: ".coo-con{display:none !important}" },
  "cae.com": { c: 0 },
  "bienmanger.com": { j: "5" },
  "arburg.com": { s: "#field_popup{display:none !important}" },
  "virustotal.com": { j: "6" },
  "nmhh.hu": { j: "5" },
  "pelix-media.de": { j: "5" },
  "parship.de": { s: "uc-custom-layer{display:none !important}" },
  "windtre.it": { c: 0 },
  "xn--80aafey1amqq.xn--d1acj3b": {
    s: ".footer ~ .confirm{display:none !important}",
  },
  "dopportal.ru": { s: ".footer ~ .confirm{display:none !important}" },
  "spoferan.com": { s: ".fixed.overlay--active{display:none !important}" },
  "codit.eu": { s: ".langSelector{display:none !important}" },
  "ketnet.be": { s: "#root > div > div:last-child{display:none !important}" },
  "valitor.is": { c: 8 },
  "droptica.com": { j: "5" },
  "hejto.pl": { s: "footer ~ .fixed{display:none !important}" },
  "hrt.hr": { c: 142 },
  "prestaexpert.com": { j: "5" },
  "genesis.com": { s: ".privacy-dialog{display:none !important}" },
  "3dprinting.com": { s: ".mdl-js-bigsnackbar{display:none !important}" },
  "sammyspizza.de": { s: ".responsiveFooterBar{display:none !important}" },
  "oishisushi.club": { s: ".responsiveFooterBar{display:none !important}" },
  "airmates.eu": { j: "6" },
  "daffer.sk": { s: "footer + div + div{display:none !important}" },
  "airam.fi": { j: "5" },
  "fgov.be": { s: "cookie-law{display:none !important}" },
  "chiptuning-express-tirol.at": { j: "5" },
  "bulthaup.com": { s: ".bulthaup-cookie-notice{display:none !important}" },
  "realme.com": { j: "5" },
  "sportium.es": { c: 17 },
  "nasz-gabinet.pl": { s: ".message-window.show{display:none !important}" },
  "fabasoft.com": { s: ".tracking-alert{display:none !important}" },
  "blog2social.com": { s: ".cookie-cover{display:none !important}" },
  "astra-bier.de": { j: "5" },
  "aefinfo.fr": { s: ".bandeau_cgv{display:none !important}" },
  "hetcontact.nl": { c: 0 },
  "pott.de": { s: ".legacy{display:none !important}" },
  "nzbindex.com": { j: "5" },
  "winnicalidla.pl": { c: 34 },
  "imgw.pl": { s: "#rodo{display:none !important}" },
  "garten.ac": { c: 54 },
  "baumpflege.ac": { c: 54 },
  "swt.de": { s: "#COOKIE_POLICY{display:none !important}" },
  "twl.de": { j: "5" },
  "l2central.info": { s: ".notice_footer_right{display:none !important}" },
  "spieletastisch.de": { s: ".pageloading-mask{display:none !important}" },
  "axisbank.com": { s: "#HomePageStrip{display:none !important}" },
  "ingatlanbazar.hu": { s: ".ib-cookie-bar{display:none !important}" },
  "localyzeapp.com": { s: ".banner-container{display:none !important}" },
  "laposte.fr": { s: "#navigation_cookies{display:none !important}" },
  "valuetech.de": { s: "#GDPR{display:none !important}" },
  "ofertasinternet.net": { s: "#melindres{display:none !important}" },
  "dawonia.de": { j: "5" },
  "uptodate.com": {
    s: ".isDesktop.gdprBanner #appContainer > header{top:0 !important}",
  },
  "dbna.com": { s: ".consentbar{display:none !important}" },
  "mag.dbna.com": { j: "5" },
  "intersystems.com": {
    s: ".docscookie-notification{display:none !important}",
  },
  "innovaphone.com": { s: "#disableBackground{display:none !important}" },
  "constantcontact.com": { j: "5" },
  "svitla.com": { s: ".agree-popup{display:none !important}" },
  "andyguitar.co.uk": { c: 82 },
  "mentimeter.com": { j: "6" },
  "engelvoelkers.com": { j: "5" },
  "went.at": { j: "5" },
  "zappn.tv": { j: "5" },
  "kinocheck.de": { j: "5" },
  "eubos.de": {
    s: "#frameModalBottom{display:none !important}",
    c: 14,
  },
  "kohlhammer.de": { j: "5" },
  "kiusys.net": { j: "5" },
  "usave.co.uk": { c: 15 },
  "topographic-map.com": { s: ".popup{display:none !important}" },
  "fembio.org": { s: "#my-modal,.bg-wg-modal{display:none !important}" },
  "eddler.se": { s: ".dk-header-info-message{display:none !important}" },
  "le-fleuriste-22.fr": {
    s: "#rgpd_bouton,#rgpd_demande{display:none !important}",
  },
  "slantastoffe.de": { c: 17 },
  "solaredge.com": { s: "#se-cookies-usage-bar{display:none !important}" },
  "kennisnet.nl": {
    s: "#cookies{display:none !important}#cookies ~ #top,#cookies ~ #menu,#cookies ~ #search,#cookies ~ #banner,#cookies ~ #footer::before{margin-top:0}",
  },
  "winkelparade.nl": { s: "#notification-bar{display:none !important}" },
  "comstern.de": { s: "#cookit{display:none !important}" },
  "mellerud.de": { c: 13 },
  "augenchirurgie.clinic": { c: 0 },
  "weglot.com": { c: 5 },
  "notizieinunclick.com": {
    s: "body > .elementor-popup-modal{display:none !important}.dialog-prevent-scroll{overflow:visible !important;max-height:auto !important}",
  },
  "msg.com": {
    s: "#app > div > div:not([id]):not([class]){display:none !important}",
  },
  "nonstop2k.com": { s: "#consentFooter{display:none !important}" },
  "sh-mueller.de": { s: "#notify{display:none !important}" },
  "cameranu.nl": { s: ".stick-to-bottom{display:none !important}" },
  "barclays.net": { s: "#modal-pecr{display:none !important}" },
  "simsdom.com": { s: "#policies{display:none !important}" },
  "baukobox.de": { j: "6" },
  "wirtschaftsagentur.at": { j: "5" },
  "amsterdamlightfestival.com": { j: "5" },
  "gitlab.com": { s: ".privacy-announcement{display:none !important}" },
  "proelectronic.rs": { s: ".cookies-holder{display:none !important}" },
  "kristo-friseure.de": { s: ".cookies-holder{display:none !important}" },
  "adac.de": { s: ".cookie--layer{display:none !important}" },
  "sheldrickwildlifetrust.org": { c: 2 },
  "antwerpen.be": { s: "aui-cookie-consent{display:none !important}" },
  "rtvnoord.nl": { j: "5" },
  "wehkamp.nl": { s: "#header > aside{display:none !important}" },
  "novibet.gr": { s: ".setCookies{display:none !important}" },
  "elektro-met.pl": { c: 0 },
  "estetic-dent-sklep.pl": { c: 0 },
  "ebonline.be": { j: "5" },
  "21shares.com": { s: "cookie-control{display:none !important}" },
  "ab.gr": { j: "5" },
  "mega-image.ro": { j: "5" },
  "maxi.rs": { j: "5" },
  "jpmorgan.com": {
    s: ".jpm-wm-general-cookie-banner{display:none !important}",
  },
  "oktawave.com": { j: "5" },
  "yoigo.com": {
    j: "5",
    s: ".bw-overlay-cookies,.bw-overlay-cookies ~ div{display:none !important}",
  },
  "kontra.hu": { c: 4 },
  "portofrotterdam.com": { s: ".block-por-cookies{display:none !important}" },
  "emporium.si": { s: "#grayOut{display:none !important}" },
  "info-cooperazione.it": { s: ".my-cookies{display:none !important}" },
  "mixable.de": { s: "#ccDialog{display:none !important}" },
  "selectminds.com": {
    s: "#notify-banner,#cboxOverlay,#colorbox{display:none !important}",
  },
  "cooltura24.co.uk": { j: "5" },
  "bi-polska.pl": { j: "5" },
  "bbcrewind.co.uk": { s: "#root > .fixed{display:none !important}" },
  "fctables.com": { s: "#privacy-optin{display:none !important}" },
  "learndutch.org": { j: "5" },
  "xuite.net": { s: "#privacyDeclare{display:none !important}" },
  "listaspam.com": { c: 0 },
  "der-arzneimittelbrief.de": {
    s: "#LabelAnzeigeCookie,#LinkButtonDatenschutz,#ButtonAnzeigeSchließen{display:none !important}",
  },
  "stokke.com": { s: ".sk-cookie-message{display:none !important}" },
  "awesun.com": { c: 16 },
  "darmstadt.de": { j: "5" },
  "webo.hosting": { s: "#kt_cookies{display:none !important}" },
  "torneum.com": {
    s: "tor-gdpr-banner-dialog,.cdk-overlay-backdrop{display:none !important}",
  },
  "easyswimportal.com": { j: "5" },
  "euprava.gov.rs": { s: "#bottom-popup{display:none !important}" },
  "itv4.de": { s: ".cookieModal{display:none !important}" },
  "banknorwegian.dk": { j: "5" },
  "gartencenter-seebauer.de": { j: "5" },
  "onlineradiobox.com": { c: 161 },
  "jesse.trade": {
    s: "#app > section > div > .fixed,#app > section > .fixed{display:none !important}",
  },
  "asmonaco.com": { s: ".asm-rgpd-bar{display:none !important}" },
  "aventics.com": { s: ".avts-global-cookie{display:none !important}" },
  "olympiasports.net": { s: ".consent-notification{display:none !important}" },
  "orbassano.to.it": { c: 0 },
  "paybyphone.fr": {
    j: "5",
    s: '.MuiBox-root[data-testid="cookies-box"]{display:none !important}',
  },
  "uvex-safety-shop.de": { s: "uvex-cookie-banner{display:none !important}" },
  "mobileroadie.com": { c: 0 },
  "penny.at": { j: "5" },
  "stoxenergy.com": { j: "5" },
  "institutfrancais.de": { s: ".cookie-fn{display:none !important}" },
  "delta.app": { j: "6" },
  "dkb.de": { s: "#footer ~ .banner,.cookie{display:none !important}" },
  "harry-gerlach.de": { j: "5", s: ".wrap__undone{display:none !important}" },
  "tonhalle.de": { c: 151 },
  "arm.com": { s: ".fixedPolicyBox,.c-policies{display:none !important}" },
  "pff.se": { j: "5" },
  "asr.nl": { s: "ebc-notification-info{display:none !important}" },
  "sonicstate.com": { s: "#concord-banner-container{display:none !important}" },
  "edealinfo.com": { s: 'div[id*="showFTCMessage"]{display:none !important}' },
  "nv.ua": { s: ".cookie-label{display:none !important}" },
  "kent.ac.uk": { s: "#kent-cookie-bar{display:none !important}" },
  "campingandcaravanningclub.co.uk": {
    s: "#ml_banner{display:none !important}",
  },
  "hidemy.name": { s: "#gdpr-block{display:none !important}" },
  "solidarietaveneto.it": { c: 0 },
  "vibus.de": { c: 93 },
  "centreforaviation.com": {
    s: ".cookieConsent_consent_geb{display:none !important}",
  },
  "antiquariat.de": { s: ".confirm-cookie{display:none !important}" },
  "orange.jobs": { s: ".dgt-opt-inout{display:none !important}" },
  "leparfait.fr": { j: "5" },
  "prothomalo.com": { s: "#gdpr-policy{display:none !important}" },
  "sphinxcomputer.de": { s: "#sphinxcookie{display:none !important}" },
  "programmitv.it": { j: "3" },
  "allegro.eu": { j: "5" },
  "kayak.fr": { j: "6" },
  "provostvet.co.uk": { j: "5" },
  "myfamilyvets.co.uk": { j: "5" },
  "patisserie-cabosse.fr": { s: ".cabosseadsbottom{display:none !important}" },
  "grifols.com": {
    s: "#cookie-intro-modal,.aui-overlay{display:none !important}",
  },
  "verve5.de": {
    s: "#lux-cookie-dialog,#lux-cookie-show-modal-dialog,.backdrop,._dialog_overlay{display:none !important}",
  },
  "ybs.co.uk": { s: "#fullpage-filter{display:none !important}" },
  "zentia.com": { s: ".enigmaint_cookie-notice{display:none !important}" },
  "textil-mode.de": { s: ".vtm-cookiebanner{display:none !important}" },
  "takarekbank.hu": { j: "5" },
  "comfortclick.com": { s: ".footer ~ div{display:none !important}" },
  "haarem.de": { c: 4 },
  "vodafone.nl": { j: "5" },
  "simplydhl.com": { s: "#ixp-gate-frame{display:none !important}" },
  "parrotcoffee.com": { s: "#growls{display:none !important}" },
  "huzaro.pl": { c: 0 },
  "5ka.ru": { s: "#app > .message{display:none !important}" },
  "palazzogroep.nl": { j: "5" },
  "oed.com": { s: ".cookies-attention{display:none !important}" },
  "open-office.es": { c: 0 },
  "elperiodicodeaqui.com": { s: "#infop{display:none !important}" },
  "voip.ms": { c: 3 },
  "mrowka.com.pl": { s: ".cookies-header{display:none !important}" },
  "tweakbit.com": { c: 34 },
  "mio.se": { s: "div[data-am-cookiesdisclaimer]{display:none !important}" },
  "latam.com": { j: "5" },
  "faszination-suedostasien.de": {
    s: "#legal-notice{display:none !important}",
  },
  "abmotorcycles.de": { c: 40 },
  "uniprot.org": { s: "#privacy-panel{display:none !important}" },
  "nexus.gg": { j: "3" },
  "fdp.de": { j: "5" },
  "freiheit.org": { j: "5" },
  "freie-demokraten.de": { j: "5" },
  "growney.de": { s: ".block-07-cookie-banner{display:none !important}" },
  "rodopchani.bg": { s: "#abck{display:none !important}" },
  "daab.de": {
    s: "#damn_background_overlay,#damn_cookieconsent_banner{display:none !important}",
  },
  "shadow.tech": {
    s: '#___gatsby div[class*="CookiesComponent"],#root > main ~ div:last-child{display:none !important}',
  },
  "tasaciones-rasal-perytec.com": { j: "5" },
  "enidine.com": { c: 6 },
  "akcelo.de": { c: 4 },
  "bioprocessintl.com": { c: 162 },
  "ericdepaoli.com": { c: 162 },
  "benjamindubuc.fr": { c: 162 },
  "edizioni-gabriele.com": { c: 162 },
  "wo-ist-greta.de": { c: 8 },
  "pixlr.com": { s: ".policies,#agreement-wrapper{display:none !important}" },
  "mitsubishielectric.com": { j: "5" },
  "mea.com": { j: "5" },
  "info.pl": {
    j: "5",
    s: ".zgody-popup,.head-page-information{display:none !important}",
  },
  "bnext.es": { c: 0 },
  "solaris-store.com": { c: 0 },
  "racing-planet.de": { j: "5" },
  "cafeszaidin.es": { j: "5" },
  "bricomart.es": { j: "5" },
  "bricoman.fr": { j: "5" },
  "bricomarche.pt": { c: 0 },
  "slerp.com": {
    s: "#root > div > div + div ~ div:last-child{display:none !important}",
  },
  "ecwid.com": { s: ".gdpr-window,.ec-notices{display:none !important}" },
  "easyparkitalia.it": { s: ".rah-static{display:none !important}" },
  "pegasproductions.com": { c: 0 },
  "arena.pl": { c: 159 },
  "beesafe.pl": {
    s: "#root > div > div > div > .MuiGrid-root{display:none !important}",
  },
  "liquidweb.com": { s: ".lw-cookie-banner{display:none !important}" },
  "bitfineon.com": {
    s: '#root ~ div > [class*="StyledLayer"]{display:none !important}',
  },
  "mein-saunashop.de": { c: 82 },
  "koupelny-sen.cz": { c: 0 },
  "dish.co": { s: ".mod-cookie-consent{display:none !important}", j: "5" },
  "poool.tech": { s: "#app > .fade-in-enter-done{display:none !important}" },
  "poool.fr": { s: "#app > .fade-in-enter-done{display:none !important}" },
  "tme.eu": { j: "5" },
  "tme.com": { j: "5" },
  "txone-networks.com": { s: "#cookies_msak{display:none !important}" },
  "eldirectorio.co": { c: 3 },
  "ferchau.com": { j: "5" },
  "able-group.de": { j: "5" },
  "discordtemplates.com": { s: ".consent-card{display:none !important}" },
  "holidu.de": { s: "#cookie-selector{display:none !important}" },
  "zoot.ro": { s: ".gpdr{display:none !important}" },
  "coregames.com": {
    s: '.open [class*="modalBottom"]{display:none !important}',
  },
  "fibreglassdirect.co.uk": {
    s: ".activedemand-popup{display:none !important}",
  },
  "tcf.org": { c: 65 },
  "bajajauto.com": {
    s: ".disclaimerCommon{display:none !important}.topPosCss header{top:0 !important}",
  },
  "rnf.de": { j: "5" },
  "ravenind.com": { s: ".hello-bar{display:none !important}" },
  "costomovil.es": { j: "5" },
  "litebringer.com": { s: "#cookie-app{display:none !important}" },
  "dailybuzz.nl": { j: "5" },
  "museum.nl": { c: 17 },
  "hostgreen.com": { s: "#obal{display:none !important}" },
  "lmt.lv": { j: "5" },
  "masmovil.es": { j: "5" },
  "masmovil.com": { j: "5" },
  "elkar.eus": { s: "#cookie_oharra{display:none !important}" },
  "sigma-photo.fr": { s: ".choc-banner{display:none !important}" },
  "avfc.co.uk": { s: ".footer ~ .popup-wrapper{display:none !important}" },
  "music-city.cz": { s: "#js-agreement-stripe{display:none !important}" },
  "technischesmuseum.at": { j: "5" },
  "klett.de": { j: "5" },
  "forgeofempires.com": { j: "6" },
  "elvenar.com": { j: "6" },
  "deincamchat.de": { s: "#age-verification{display:none !important}" },
  "rammes-gruenland.com": { j: "5" },
  "turtlewax.com": { s: ".cozy-crd__modal-bar{display:none !important}" },
  "theweather.com": { s: "#gpdr{display:none !important}" },
  "fdp-rlp.de": { j: "5" },
  "theathletic.com": { j: "6" },
  "darksearch.io": {
    s: ".application--wrap > .blue--text{display:none !important}",
  },
  "poolebaypharmacy.co.uk": { j: "5" },
  "gira.de": {
    s: "#consent-dialog-wrapper,#cms-element-ac,#ac_frame{display:none !important}",
  },
  "gira.com": {
    s: "#consent-dialog-wrapper,#cms-element-ac{display:none !important}",
  },
  "yestersen.com": { s: "main > .d-print-none{display:none !important}" },
  "pri.org": {
    s: '#__next [class*="CtaMessage"],#cta_prompt_bottom{display:none !important}',
  },
  "realitysandwich.com": { c: 5 },
  "filmmakers.de": { s: ".Aligner{display:none !important}" },
  "kytta.at": { s: 'button[class*="dc-cookie"]{display:none !important}' },
  "conjunctconsulting.org": { c: 5 },
  "rosepartner.de": { s: "#rp-cookie-consent{display:none !important}" },
  "campusonline.com": { s: ".ui-pnotify{display:none !important}" },
  "gamecaster.com": { s: 'nav ~ [class*="growl"]{display:none !important}' },
  "vorteile.net": { j: "5" },
  "kayak.co.uk": { j: "6" },
  "orangebank.fr": { s: "#ob-cookie-banner-modal{display:none !important}" },
  "surveyjs.io": { s: ".surveyjs-cookie-info{display:none !important}" },
  "kremer-pigmente.com": { s: "#cclayer{display:none !important}" },
  "eichsfeld.de": { c: 9 },
  "fnatic.com": { j: "5" },
  "msa.fr": { s: "#consent-cookies{display:none !important}" },
  "expert.de": {
    s: ".widget-EyeCatcher---preset-fixed{display:none !important}",
  },
  "lufthansagroup.careers": { j: "5" },
  "z-immobilien.at": { j: "5" },
  "penny.hu": { j: "5" },
  "penny.cz": { j: "5" },
  "inwestinfo.pl": { s: '#up ~ [style*="fixed"]{display:none !important}' },
  "joolz.com": {
    s: ".jlz-cookie-consent--background-blur::before{display:none !important}",
  },
  "quixa.it": { c: 32 },
  "supermicro.com": {
    s: "#alert-container,#privacy-popup-agree{display:none !important}",
  },
  "puzzlegarage.com": { c: 161 },
  "rzeszow.pl": { s: "#__next > .fixed{display:none !important}" },
  "lifevantage.com": { j: "5" },
  "heatable.co.uk": { c: 0 },
  "learnattack.de": { j: "5" },
  "oberstdorf2021.com": { j: "5" },
  "cobasi.com.br": { s: ".lgpd{display:none !important}" },
  "mojoreads.de": {
    s: "main + div > div:first-child{display:none !important}",
  },
  "la-palma24.info": { s: ".dvcookies{display:none !important}" },
  "scitanie.sk": { s: ".c-banner{display:none !important}" },
  "lvhn.org": { s: "#block-lvhnconsentpopup{display:none !important}" },
  "vacuumclinic.ie": { c: 60 },
  "coder.com": { s: '#__next > [style*="opacity"]{display:none !important}' },
  "tt2-compendium.com": { s: "#cover,#consntcook{display:none !important}" },
  "cataloxy.co.uk": { s: "#cookies_cond{display:none !important}" },
  "motaclarity.co.uk": { c: 0 },
  "jasmin.com": {
    s: '#cookie_container ~ div[style=""]:not([id]){display:none !important}',
  },
  "gesundheit-nordhessen.de": { j: "5" },
  "mymoria.de": { j: "6" },
  "restaurantdepot.com": { s: "#consent-dialog{display:none !important}" },
  "mcdelivery.de": { j: "5" },
  "happiness-festival.de": { s: "#privacy-footer{display:none !important}" },
  "escueladesaludmurcia.es": {
    s: '.ui-dialog-mask,body > div[style*="center"]{display:none !important}',
  },
  "gamigo.net": { s: "#stayhome{display:none !important}" },
  "moviestillsdb.com": {
    s: '#app > [style*="fixed"]{display:none !important}',
  },
  "gasteig.de": { s: "#gasConsent{display:none !important}" },
  "helloasso.com": { s: ".BannerTrackers{display:none !important}" },
  "peticie.com": { j: "6" },
  "pro-housing.nl": { s: ".accept-alert{display:none !important}" },
  "octoparse.com": { s: "#snackbar{display:none !important}" },
  "baden-tv.com": { j: "5" },
  "viata-medicala.ro": { s: "#app_notice{display:none !important}" },
  "macmagazine.com.br": { s: ".adp-popup{display:none !important}" },
  "stockx.com": { s: '#root > [style*="visible"]{display:none !important}' },
  "studienwahl.de": { j: "5" },
  "teamtailor.com": { j: "5" },
  "youmail.com": { s: ".policy-notification{display:none !important}" },
  "netapp.com": { s: "n-cookie-notification{display:none !important}" },
  "inkoma.com": { s: "#eatcoockies{display:none !important}" },
  "shopsmartfoods.com": { c: 16 },
  "gradesfixer.com": { s: "#warning_popup{display:none !important}" },
  "njpw1972.com": { c: 3 },
  "quadlockcase.eu": { s: ".ip_cookie{display:none !important}" },
  "quadlockcase.co.uk": { s: ".ip_cookie{display:none !important}" },
  "musicalfreedom.com": {
    s: ".terms-and-policy-layer{display:none !important}",
  },
  "justanswer.com": { s: ".Banner__container{display:none !important}" },
  "houtwormboktor.com": { s: ".cc-popup{display:none !important}" },
  "stubai.at": { j: "5" },
  "go-fit.es": { s: "#barra-informativa{display:none !important}" },
  "rankia.com": { c: 0 },
  "lilly.gr": { s: ".consent-message{display:none !important}" },
  "portalnow.com": { c: 32 },
  "deurbeslag-expert.nl": { s: "#js-app > .fixed{display:none !important}" },
  "hacknplan.com": {
    s: '.application-footer[ng-class*="hasAcceptedCookies"]{display:none !important}',
  },
  "nanopay.net": { s: ".gdrp{display:none !important}" },
  "esv.info": { j: "5" },
  "tedquality.bg": { c: 71 },
  "beyondthebox.it": { c: 5 },
  "museot.fi": {
    s: '#body_area > [id*="cookie_ilmoitus"]{display:none !important}',
  },
  "vr.de": { s: ".yt-activator__wrapper{display:none !important}" },
  "wolterskluwer.nl": {
    s: "#udtCookiebox,#udtDark,#udtWhite{display:none !important}",
  },
  "otpbanka.hr": { j: "5" },
  "stockmann.com": { j: "5" },
  "burnleyfootballclub.com": {
    s: "footer ~ div > .fixed{display:none !important}",
  },
  "ipn.gov.pl": { c: 79 },
  "reiff-zuschnitt-konfigurator.de": { j: "5" },
  "reichelt-garten.de": { c: 29 },
  "muycomputer.com": { s: "#CSneak{display:none !important}" },
  "muycomputerpro.com": { s: "#CSneak{display:none !important}" },
  "tgz-ol.de": { j: "6" },
  "deily.hr": { s: ".basel_cookie_bar{display:none !important}" },
  "robert-thomas.de": { s: ".cookie--consent{display:none !important}" },
  "i4wifi.cz": { s: 'div[role="EuCookiesBar"]{display:none !important}' },
  "fishbrain.com": { s: "#root > div > .fixed{display:none !important}" },
  "ipper.ru": { c: 1 },
  "case-score.de": { j: "5" },
  "akces-markt.pl": { c: 0 },
  "academictimes.com": { s: "#euPopup{display:none !important}" },
  "karriere-jet.de": { j: "5" },
  "bewerbung-tipps.com": { j: "5" },
  "lindner-group.com": { s: ".cn-layer{display:none !important}" },
  "compravo.de": { j: "5" },
  "gamestar.de": { j: "5" },
  "jetcost.com": { j: "5" },
  "jetcost.co.uk": { j: "5" },
  "jetcost.de": { j: "5" },
  "jetcost.pt": { j: "5" },
  "blendtec.com": { s: "#pixelpop{display:none !important}" },
  "themilitarystore.co.uk": { s: "#pixelpop{display:none !important}" },
  "dunhamssports.com": { j: "6" },
  "bandainamcoent.eu": { j: "5" },
  "ricmais.com.br": { s: "#privacy_site{display:none !important}" },
  "malergeschaeft-eisenloeffel.de": {
    s: "#bottom_popup{display:none !important}",
  },
  "evangelisch.de": { j: "6" },
  "santanderconsumer.at": {
    s: ".sliding-popup-bottom{display:none !important}",
  },
  "a3quattro.de": { c: 13 },
  "gps-viewer.com": { s: ".popup{display:none !important}" },
  "skfbearingselect.com": { j: "5" },
  "fit4projects.at": { s: "#setcookie{display:none !important}" },
  "zoopla.co.uk": { j: "5" },
  "die-linke-grundeinkommen.de": { c: 8 },
  "fdpbt.de": { j: "5" },
  "epravda.com.ua": { s: "#checkUPcookies{display:none !important}" },
  "sigma-global.com": { s: ".c-info-pane{display:none !important}" },
  "akutbolig.dk": { s: "#app ~ div[class]:not([id]){display:none !important}" },
  "evangelisch-hochtaunus.de": { s: ".readcookie{display:none !important}" },
  "c-dating.fr": { j: "5" },
  "singles50.it": { j: "5" },
  "be2.it": { j: "5" },
  "justspices.de": { s: ".cookie_overlay::before{display:none !important}" },
  "leaseweb.com": { j: "5" },
  "rubberduckvba.com": { j: "5" },
  "plutogaming.net": { c: 15 },
  "centrumwedkarstwa.pl": { s: "body > .no_print{display:none !important}" },
  "oversightboard.com": { j: "5" },
  "fressnapf.hu": { s: ".grey-popup-layer{display:none !important}" },
  "fuckstudies.com": {
    s: ".cookie{display:none !important}.cookies .main{top:0 !important}",
  },
  "rawcouples.com": {
    s: ".cookie{display:none !important}.cookies .main{top:0 !important}",
  },
  "money2gocard.de": { j: "5" },
  "kyero.com": {
    s: 'div[data-component="cookies_policy_modal"],.fixed[data-cookie-toast]{display:none !important}',
  },
  "macrosat.pl": { s: "#footer ~ .top{display:none !important}" },
  "hostingsdc.pl": { s: "#informationbar{display:none !important}" },
  "tupowstalapolska.pl": { s: "#menusDiv{display:none !important}" },
  "muenchen.tv": { j: "5" },
  "ridersguide.nl": { j: "5" },
  "mondenissin.com": { c: 5 },
  "hombresevolucionantes.com": { c: 5 },
  "rse-get-it-right.org.uk": { c: 5 },
  "cocktails.de": { j: "5" },
  "podoplus.be": { c: 9 },
  "navigium.de": { j: "5" },
  "bankelf.de": { j: "5" },
  "bta-international.com": { s: ".cc-layer{display:none !important}" },
  "apllogistics.com": { c: 8 },
  "wit.edu.pl": { j: "5" },
  "ubi2.wit.edu.pl": { j: "6" },
  "themcelroy.family": { c: 3 },
  "evapolar.com": { s: 'footer ~ [style*="fixed"]{display:none !important}' },
  "aldi-sued.de": { j: "5" },
  "customessaymeister.com": { c: 2 },
  "mifas.cat": { j: "5" },
  "jetzendorf.de": { s: "#privacy-container{display:none !important}" },
  "lansberg.de": { j: "5" },
  "viamedica.pl": { s: ".dark-background::after{display:none !important}" },
  "buzzaar.eu": { c: 39 },
  "intelligentinsurer.com": { s: ".privacyLaw{display:none !important}" },
  "popeyeschicken.ca": {
    s: '#main ~ div[class*="Container"]{display:none !important}',
  },
  "icarros.com.br": { s: "#isView{display:none !important}" },
  "teijin.com": { s: "#assistClone{display:none !important}" },
  "fernwaerme-gemeinschaft.de": {
    s: ".cookie-overlay::before{display:none !important}",
  },
  "lovehoney.co.uk": { c: 163 },
  "lovehoney.com.au": { c: 163 },
  "europe-mountains.com": { c: 0 },
  "chemrxiv.org": { s: 'header > [role="alert"]{display:none !important}' },
  "artsper.com": {
    s: '.ui-pnotify[aria-role*="alert"]{display:none !important}',
  },
  "gidsingezondheid.nl": {
    s: "footer ~ .popup_overlay{display:none !important}",
  },
  "goldenline.pl": { j: "5" },
  "hagengrote.de": { j: "5" },
  "hagengrote.at": { j: "5" },
  "idagio.com": { j: "5" },
  "pushkin.institute": { s: ".beono-flashmessage{display:none !important}" },
  "seedrs.com": {
    s: "#__next > div:first-child,#root-header > div{display:none !important}",
  },
  "giffits.de": { c: 17 },
  "tata.com": { s: ".overlayPop{display:none !important}" },
  "berendsen.pl": { s: ".site--wrapper ~ div{display:none !important}" },
  "la7.it": { j: "5" },
  "delhaize.be": { j: "5" },
  "outandaboutlive.co.uk": { j: "6" },
  "syncfusion.com": { c: 0 },
  "rfo.de": { j: "5" },
  "tecnocasa.it": { s: ".cookie-status{display:none !important}" },
  "pwabuilder.com": { s: "#gdprDiv{display:none !important}" },
  "bruns.de": { j: "5" },
  "spainhouses.net": { s: ".persistentMessage{display:none !important}" },
  "wearemarketing.com": { c: 0 },
  "antilinkynord.fr": { s: ".accookie{display:none !important}" },
  "hallhuber.com": { j: "5" },
  "facultas.at": { s: ".bmcookie{display:none !important}" },
  "rupertusbuch.at": { s: ".bmcookie{display:none !important}" },
  "nhs.wales": {
    s: '.mura-cta__item[aria-describedby="Cookie notice"]{display:none !important}',
  },
  "green-circle.co": { s: 'body > [style*="fixed"]{display:none !important}' },
  "revistabula.com": { s: "#consent-box{display:none !important}" },
  "happycow.net": { s: "body > .fixed{display:none !important}" },
  "muehlenapotheken.de": {
    s: "#bg-datenschutz,.icon.cookies.cookies-aktivieren{display:none !important}",
  },
  "wakingup.com": {
    s: '#___gatsby ~ div:not([id]):not([class]),#root > div[style*="transform"]{display:none !important}',
  },
  "patreon.com": { j: "5" },
  "societegenerale.fr": { s: "#c-message{display:none !important}" },
  "aerolineas.com.ar": { s: "#c-message{display:none !important}" },
  "researchaffiliates.com": { j: "5" },
  "scleracontacts.com": {
    s: "#pushwix-popover-container.slide-down{display:none !important}",
  },
  "nineambell.com": { c: 5 },
  "promosejours.com": { c: 16 },
  "timberland.com.tw": {
    s: ".container-component > .dialog ~ div:last-child{display:none !important}",
  },
  "tibber.com": { j: "5", s: ".privacyButton{display:none !important}" },
  "tesa.com": { j: "6" },
  "tapir-store.de": { s: ".cs-cookie__wrapper{display:none !important}" },
  "quora.com": {
    s: '#root .q-box > .q-flex[class*="Banner"]{display:none !important}',
  },
  "material.io": { s: "mio-cookie-notice{display:none !important}" },
  "kh.hu": { j: "5" },
  "yubico.com": {
    s: ".MuiSnackbar-root,#yubi-root > .bottom-pop-up-container{display:none !important}",
  },
  "gainesvillecoins.com": { s: "#jsGDRP{display:none !important}" },
  "barnebys.se": {
    s: "#__next > div + div:last-child{display:none !important}",
  },
  "brookes.ac.uk": { s: "#PopUp{display:none !important}" },
  "brookesalumni.co.uk": { s: "#PopUp{display:none !important}" },
  "eltima.com": { s: ".float-message__wrap{display:none !important}" },
  "aboalarm.de": { j: "5" },
  "tomorrow.one": { j: "5" },
  "kdanmobile.com": {
    s: '#__next > div[style*="overflow"] > div[class*="ContentWrap"],#__next > div[class*="ContentWrap"],#gdpr-wrapper{display:none !important}',
  },
  "rademacher.de": {
    s: ".widget-Container ~ .widget-EyeCatcher{display:none !important}",
  },
  "rblx.trade": { s: ".card.fixed-bottom{display:none !important}" },
  "turboimagehost.com": { j: "6" },
  "emons.de": { j: "5" },
  "selectos.eu": { s: "#selectos-cookie-background{display:none !important}" },
  "e-fellows.net": { s: "#efnCookieConsent{display:none !important}" },
  "uchi.ru": { s: "._UCHI_COOKIE__widget{display:none !important}" },
  "foter.com": { s: ".fo4-cookie{display:none !important}" },
  "vestel-germany.de": { s: "#custom-modal-cookie{display:none !important}" },
  "warsztat.pl": { j: "5" },
  "bell-labs.com": { s: "#n-cookie-notice{display:none !important}" },
  "forum.brasil-web.de": { j: "5" },
  "change.org": { j: "5" },
  "tesco.pl": { s: "#privacyOuterContainer{display:none !important}" },
  "tesco.com": { s: "#sticky-bar-wrapper{display:none !important}" },
  "conso.ro": { j: "5" },
  "mubi.com": { j: "6" },
  "albaparty.org": { c: 8 },
  "lilies-diary.com": {
    s: ".lld-cookieconsentbanner{display:none !important}",
  },
  "powerspreadsheets.com": {
    s: ".thrv-ribbon,.thrv-leads-slide-in{display:none !important}",
  },
  "eurosportplayer.com": {
    s: '#app div[class^="cookie-policy"]{display:none !important}',
  },
  "hessen.de": { c: 7 },
  "gartencenter-bergerhoff.de": { j: "5" },
  "zonky.cz": {
    s: ".cookie-consent-shown .application > .flex{display:none !important}",
  },
  "kraken.com": {
    s: ".kraken-cookie-warning,.kraken-cookie-warning.show{display:none !important}",
  },
  "lovehoney.com": { c: 163 },
  "lovehoney.eu": { c: 163 },
  "stanley.ru": { s: ".test-mode__wrap{display:none !important}" },
  "bopla.de": { s: "#privacy-consent{display:none !important}" },
  "antenasgsm.com": { c: 0 },
  "laschensky.at": { j: "5" },
  "dynavap.com": { c: 0 },
  "urzadzamy.pl": { j: "5" },
  "cypress.com": {
    s: "#complianceoverlay.complianceoverlay{display:none !important}",
  },
  "sportsoft.co.uk": { c: 83 },
  "tomgarten.de": { j: "5" },
  "singleboersen-vergleich.de": { j: "5" },
  "preplounge.com": { j: "5" },
  "autocentrum.pl": { j: "5" },
  "beiersdorf.de": { s: "form > .popup{display:none !important}" },
  "beiersdorf.ch": { s: "form > .popup{display:none !important}" },
  "evavonangern.de": { c: 8 },
  "airsoft.ch": { s: ".cb{display:none !important}" },
  "ticket.io": { j: "5" },
  "courrierinternational.com": { j: "5" },
  "mediapart.fr": { s: ".cc-modal{display:none !important}" },
  "icabanken.se": {
    s: "#blockbackground,#removeOnClose{display:none !important}",
  },
  "labellevie.com": { s: "#confidentiality{display:none !important}" },
  "lcd-compare.com": { j: "5" },
  "rnbee.ru": { s: "#yw-cookie-gdpr{display:none !important}" },
  "jeanscentre.nl": {
    s: "#gatsby-focus-wrapper > div:last-child{display:none !important}",
  },
  "zoom.nl": { j: "5" },
  "centrumtenisa.pl": { j: "5" },
  "jetbluevacations.com": { j: "5" },
  "impericon.com": { j: "5" },
  "otelo.de": { j: "5" },
  "live.com": { j: "5" },
  "ikbenfrits.nl": { j: "5" },
  "diefabrik-sundern.de": { j: "5" },
  "uni-tuebingen.de": {
    s: ".in2-modal__blackbox,#privacy-background,#privacy-container{display:none !important}",
  },
  "eifel-antik.de": {
    s: ".jmg-googlemaps-dsgvo-notification{display:none !important}",
  },
  "green-24.de": { j: "5" },
  "markilux.com": { j: "5" },
  "salomon.com": { j: "5" },
  "flyrotax.com": { s: "#CookieSettingsContainer{display:none !important}" },
  "amorespossiveis.com.br": { s: "#idLGPD{display:none !important}" },
  "freiewelt.net": { s: "#cmmodal{display:none !important}" },
  "bankmillennium.pl": { s: "wc-cookies-marketing{display:none !important}" },
  "handelsbanken.se": {
    s: "shb-cookie-consent,.js-shb-inss-login__cookie-consent{display:none !important}",
  },
  "handelsbanken.nl": { s: "shb-cookie-consent{display:none !important}" },
  "ageofempires.com": { s: ".popup.disable-screen{display:none !important}" },
  "ultimatecourses.com": { s: ".uc-cookies{display:none !important}" },
  "royalmail.com": { j: "5" },
  "mauk-gartenwelt.de": { j: "5" },
  "streamelements.com": { j: "3" },
  "3gimmobilier.com": { j: "5" },
  "ihk-akademie.de": { s: "#privacy-statement{display:none !important}" },
  "ontariocolleges.ca": { s: "#privacy-statement{display:none !important}" },
  "dekra-norisko.fr": { s: ".dekra-gdpr{display:none !important}" },
  "starcar.de": { s: "#modal-overlay{display:none !important}" },
  "service.gov.uk": {
    s: ".cbanner-govuk-cookie-banner,#dm-cookie-banner{display:none !important}",
  },
  "passport.service.gov.uk": { j: "5" },
  "tierarzt24.de": { s: ".vet_cookies{display:none !important}" },
  "loewe.tv": { s: ".cookey-pop{display:none !important}" },
  "iconscout.com": { s: "#__layout > div > .rounded{display:none !important}" },
  "pngimg.com": { j: "5" },
  "verktygsboden.se": {
    s: "header > div:nth-child(2) .sd-surface-subtop > .sd-object-if{display:none !important}",
  },
  "kaufland.de": { j: "5" },
  "tinyurl.com": { c: 7 },
  "mcfit.com": { s: "#app ~ [opacity]{display:none !important}" },
  "scinapse.io": { s: "#react-app > div:last-child{display:none !important}" },
  "educative.io": { s: "#__next > .ed-grid ~ div{display:none !important}" },
  "cover-4-less.com": { c: 5 },
  "clem.mobi": { j: "5" },
  "gnosis.io": { c: 4 },
  "tingstad.com": { s: ".cookie-manager{display:none !important}" },
  "7plus.com.au": {
    s: '#app > [class*="cookieContainer"]{display:none !important}',
  },
  "sportsbikeshop.co.uk": { j: "5" },
  "jumingo.com": { j: "5" },
  "tuigroup.com": { s: "#tui-cc{display:none !important}" },
  "werkenbijlidl.nl": { j: "5" },
  "hoyavision.com": { j: "5" },
  "kino.dk": { j: "5" },
  "apotal.de": { s: "#footer::after{display:none !important}" },
  "focustaiwan.tw": { s: "#jsGDPR{display:none !important}" },
  "paravol.org": { j: "5" },
  "verfassungsblog.de": { s: ".tve-leads-ribbon{display:none !important}" },
  "cbtnuggets.com": {
    s: '#__next [class*="BannerContainer"]{display:none !important}',
  },
  "ersatzteilshop.de": { j: "6" },
  "picnic.app": { s: ".cookies,#modal{display:none !important}" },
  "funshop.ch": { s: ".ds_cookiebar_container{display:none !important}" },
  "gumenadom.si": { c: 0 },
  "backmomente.de": { j: "5" },
  "zeroco2.eco": { s: "#loadingShadow{display:none !important}" },
  "oxxio.nl": { j: "5" },
  "elavon.pl": { j: "5" },
  "zeg-holz.de": { s: "#ucShadowRoot{display:none !important}" },
  "xeev.net": { j: "5" },
  "claras-apotheke.de": { j: "5" },
  "mimibabytielt.be": { j: "5" },
  "stepstone.se": { j: "5" },
  "oculus.com": { j: "5" },
  "plushbezlimitu.pl": { s: ".modal-overlay{display:none !important}" },
  "dhbbank.nl": { j: "5" },
  "studyspace.eu": { j: "5" },
  "gamersgate.com": { j: "5" },
  "mein-apothekenmanager.de": { s: "#cn-wrapper{display:none !important}" },
  "ikarus.de": { j: "5" },
  "ntb.no": { s: ".footer__notification{display:none !important}" },
  "debenhams.com": { j: "5" },
  "corona-impfung.nrw": { j: "5" },
  "videosmile.ru": { s: "#accept_q{display:none !important}" },
  "mit-dem-rad-zur-arbeit.de": { j: "5" },
  "akpool.de": { c: 4 },
  "penguinrandomhouse.de": { s: ".cl-window-bg{display:none !important}" },
  "maiia.com": { j: "5" },
  "myrobotcenter.de": { j: "5" },
  "myrobotcenter.at": { j: "5" },
  "myrobotcenter.co.uk": { j: "5" },
  "ifaa.de": { s: ".cmnstr-outer{display:none !important}" },
  "allekringloopwinkels.nl": { j: "5" },
  "placedumarche.fr": { s: ".sky-cookies-banner{display:none !important}" },
  "xmlgold.eu": { s: ".cookie-window{display:none !important}" },
  "kedglobal.com": { s: ".cookies_layer{display:none !important}" },
  "dbb.de": { s: "#dbb-gdpr{display:none !important}" },
  "ga.de": { j: "5" },
  "satrucker.co.za": { s: 'div[id*="cookie-notice"]{display:none !important}' },
  "daad.de": { j: "5" },
  "fok.nl": { j: "5" },
  "almedina.net": { s: ".footer-fixed-bar{display:none !important}" },
  "lifesum.com": { j: "3" },
  "23degrees.io": { s: "consent-toast{display:none !important}" },
  "jku.at": { j: "5", s: ".ccpopup{display:none !important}" },
  "atlasformen.de": {
    s: ".cookie-modal{display:none !important}",
    c: 14,
  },
  "atlasformen.co.uk": { s: "#divBottomStickyLayer{display:none !important}" },
  "partssource.com": {
    s: "#divBodyContainer > div > div > .justify-content-center{display:none !important}",
  },
  "voeazul.com.br": { s: ".az_cookie{display:none !important}" },
  "sanitarium.com.au": { s: ".cookie--modal{display:none !important}" },
  "sanitarium.co.nz": { s: ".cookie--modal{display:none !important}" },
  "autosolar.es": { s: ".cookie-configuration{display:none !important}" },
  "crosig.hr": { s: "co-message{display:none !important}" },
  "desarrolloweb.com": { s: "dile-cookies-consent{display:none !important}" },
  "homecine-compare.com": { j: "5" },
  "oekt.de": { j: "5" },
  "pcsoft.fr": { j: "5" },
  "pnrtscr.com": { j: "5" },
  "avl-ludwigsburg.de": { s: ".page-overlay{display:none !important}" },
  "recordsale.de": { s: ".personalization-request{display:none !important}" },
  "servihabitat.com": {
    s: '.portlet-boundary[class*="condiciones"]{display:none !important}',
  },
  "calendly.com": {
    j: "5",
    s: '#gdpr-region ~ [data-component="sticker"]{display:none !important}',
  },
  "correos.es": {
    s: ".correosCookies,.sc-correos-cdk-cookies-module{display:none !important}",
  },
  "liverpoolfc.com": { s: "#LfcCookieContent{display:none !important}" },
  "pdfcoffee.com": { s: "#PDFCOFFEECOM_cookie_box{display:none !important}" },
  "extradom.pl": { j: "5" },
  "aldeparty.eu": { c: 8 },
  "remove.bg": { s: ".banner.fixed-bottom{display:none !important}" },
  "terveyskirjasto.fi": { j: "5" },
  "dagenssamhalle.se": {
    s: "#__next > div:last-child{display:none !important}",
  },
  "vermieterverein.de": { j: "5" },
  "censor.net": {
    s: "#usage_notice,#usage-notice-message{display:none !important;visibility:hidden}",
  },
  "oead.at": { j: "5" },
  "rcibanque.de": { s: '.ng-scope[ui-view="cookie"]{display:none !important}' },
  "tuttitalia.it": { j: "5" },
  "brabus.com": { j: "5" },
  "miltenyibiotec.com": { j: "5" },
  "immoscout24.ch": {
    s: 'section[class*="SeoLinks"] ~ div[class*="Box"]{display:none !important}',
  },
  "argent.xyz": {
    s: "#gatsby-focus-wrapper > div:not([id]):last-of-type{display:none !important}",
  },
  "thsrc.com.tw": { j: "5" },
  "login.nos.pt": { j: "5" },
  "pensjonistforbundet.no": { j: "5" },
  "oceanmata.com": { s: ".banner{display:none !important}" },
  "vr.fi": { j: "5" },
  "jamiebalfour.scot": { c: 0 },
  "bolighed.dk": { s: ".cookie__manager{display:none !important}" },
  "creampie-angels.com": {
    s: ".cookie{display:none !important}body.cookies{padding-top:0 !important}body.cookies header.main{top:0 !important}",
  },
  "moveyouroffice.io": { j: "5" },
  "digital-affin.de": { j: "5" },
  "chimpify.de": { j: "5" },
  "scoodleplay.be": { j: "3" },
  "euplf.eu": { j: "5" },
  "audiofanzine.com": {
    s: ".af-cookies,.af-cookies-background{display:none !important}",
  },
  "chess.com": { s: ".bottom-banner-component{display:none !important}" },
  "heizoel24.de": { j: "5" },
  "heizoel24.at": { j: "5" },
  "splu-engineers.com": {
    s: "#frontpage-banner-cover{display:none !important}",
  },
  "footroll.pl": { j: "5", c: 1 },
  "easycredit.de": { s: "cookie-layer{display:none !important}" },
  "cykelgear.dk": { j: "5" },
  "allround-pc.com": { j: "5" },
  "digikey.com": {
    s: "body.gdpr{margin-top:0 !important;background-position:initial !important}#header__storage{top:0 !important}",
  },
  "boschbad.nl": { j: "5" },
  "teikeicoffee.org": { j: "5" },
  "pocketbook.de": { j: "5" },
  "skatteverket.se": { s: "skv-cookie-banner{display:none !important}" },
  "jobs.at": { j: "5" },
  "karriere.at": { j: "5" },
  "share-now.com": { s: ".banner-placeholder{display:none !important}" },
  "gittigidiyor.com": {
    s: "#__next main > div:not([class]),.policy-alert-v2.show-policy{display:none !important}",
  },
  "touslesprix.com": { j: "5" },
  "alo.bg": { s: "#consent_main{display:none !important}" },
  "figuya.com": { j: "3" },
  "rtl.hr": { s: ".app__content ~ div{display:none !important}", j: "5" },
  "fernsehserien.de": { j: "5" },
  "nivea.pl": { s: ".policy-info{display:none !important}" },
  "supercast.tech": { c: 6 },
  "correios.com.br": { s: "#cookiesId{display:none !important}" },
  "citilink.ru": { s: ".PersonalDataConfirm{display:none !important}" },
  "auchan.pl": { j: "5" },
  "auchan.hu": { j: "5" },
  "werkstars.de": { s: ".wsr--data-protection{display:none !important}" },
  "lambdatest.com": { s: ".cookiesdiv{display:none !important}" },
  "dofus.com": {
    s: ".ak-modal-wrapper,.ui-widget-overlay{display:none !important}",
  },
  "modrinth.com": { s: ".container > .banner{display:none !important}" },
  "jadlonomia.com": { s: ".cbar-container{display:none !important}" },
  "twitch.tv": { j: "5" },
  "senec.com": { j: "5" },
  "taschenhirn.de": { j: "5" },
  "strefakonsumencka.pl": { c: 0 },
  "deutsche-diabetes-gesellschaft.de": { j: "5" },
  "awwwards.com": { j: "5" },
  "focus-home.com": { s: "#app > nav + div{display:none !important}" },
  "wayofleaf.com": { s: "#cpop{display:none !important}" },
  "crucial.com": {
    s: '.app-light > div[style*="fixed"]{display:none !important}',
  },
  "concursosnobrasil.com.br": { s: "#lgpd{display:none !important}" },
  "autopunkt.pl": { j: "5" },
  "euromobil.com.pl": { j: "5" },
  "euromotor.pl": { j: "5" },
  "koreamotors.pl": { j: "5" },
  "japanmotors.pl": { j: "5", c: 2 },
  "pgd.pl": { j: "5" },
  "eforia.pl": { j: "5" },
  "nordiskporselen.com": { s: "#kjeks{display:none !important}" },
  "3suisses.fr": { j: "5" },
  "lass-tanzen.de": { j: "5" },
  "camping.info": { j: "5" },
  "belgium.be": { c: 0 },
  "volksfreund.de": { j: "5" },
  "smitegame.com": { s: ".page > .is-visible{display:none !important}" },
  "ryd.one": { s: ".xy-consent{display:none !important}" },
  "onepercentclub.com": {
    s: ".notification-bar-container{display:none !important}",
  },
  "samenvoordebuurt.nl": {
    s: ".notification-bar-container{display:none !important}",
  },
  "tameteo.nl": { j: "5" },
  "tameteo.com": { j: "5" },
  "mapillary.com": { j: "5" },
  "voltus.de": { s: "#c4sCookieOneClickModal{display:none !important}" },
  "123rf.com": { s: ".AgreementBanner__wrapper{display:none !important}" },
  "smythstoys.com": { j: "5" },
  "ccoo.es": { j: "5" },
  "istockphoto.com": { s: ".banner.warning{display:none !important}" },
  "airtel.com": { c: 155 },
  "ford-weege-bad-salzuflen.de": { j: "5" },
  "waggel.co.uk": { j: "5" },
  "pingback.com": { c: 39 },
  "nettolohn.de": { s: 'div[id*="hinweis-cookie"]{display:none !important}' },
  "translit.ru": { j: "5" },
  "translit.net": { j: "5" },
  "talktomeinkorean.com": { c: 156 },
  "dpam.com": { j: "5" },
  "sylvania-automotive.com": { j: "5" },
  "valdemarne.fr": { j: "5" },
  "pu.nl": { j: "5" },
  "ringana.com": { j: "5" },
  "hampel-auctions.com": { s: "#consentmanager{display:none !important}" },
  "compress-or-die.com": {
    s: ".module_consent__main{display:none !important}",
  },
  "theater-essen.de": { s: ".dataprotection{display:none !important}" },
  "spotlightstores.com": { j: "5" },
  "anacondastores.com": { j: "5" },
  "akkushop.de": { j: "5" },
  "akkushop-austria.at": { j: "5" },
  "akkushop-schweiz.ch": { j: "5" },
  "batterie-boutique.fr": { j: "5" },
  "mfa.bg": { c: 0 },
  "platforma-karaulov.ru": { s: ".using-cookie{display:none !important}" },
  "plus.pl": { s: "#CAPPDialog,.modal-overlay{display:none !important}" },
  "a2mobile.pl": { s: ".topup-cookie{display:none !important}" },
  "green.hr": { c: 5 },
  "ebike-connect.com": { j: "5" },
  "kontrast.dk": { j: "5" },
  "drawabox.com": { j: "5" },
  "adfc.de": {
    s: "body > .ember-view > .ember-view:first-child{display:none !important}",
  },
  "totalmoney.pl": { j: "5" },
  "de.vanguard": { j: "5" },
  "merckgroup.com": { s: ".new-cookie__modal{display:none !important}" },
  "fruugo.fr": { j: "5" },
  "pspdfkit.com": { s: ".pspdfCookieDialog{display:none !important}" },
  "ovh.com": { j: "5" },
  "erkul.games": { j: "5" },
  "taimweser.com": { j: "5" },
  "konsumenternas.se": { s: "#tc-consent{display:none !important}" },
  "pepeenergy.com": { j: "5", c: 59 },
  "sava-osiguranje.hr": { j: "5" },
  "zav-sava.si": { j: "5" },
  "inselradio.com": { j: "5" },
  "futterhaus.de": { j: "5" },
  "elasticemail.com": { s: "#elastic-cookie-notice{display:none !important}" },
  "incibeauty.com": { j: "5" },
  "churchs.com": { s: "#ccpa{display:none !important}" },
  "lojabuettner.com.br": { s: ".eula-bg{display:none !important}" },
  "mobilarena.hu": { s: "#rules-accept{display:none !important}" },
  "medspa.bg": { s: ".popup-policy{display:none !important}" },
  "elevensports.com": {
    s: '#__next ~ div[class^="css"]{display:none !important}',
  },
  "elevensports.pl": { j: "5" },
  "hemamx.com": {
    s: ".no-scroll{position:relative !important}.has-cookie-message{padding-top:0 !important}",
  },
  "chregister.ch": { s: ".ui-notificationbar{display:none !important}" },
  "synology.com": { s: ".syno_cookie_element{display:none !important}" },
  "retroplace.com": { j: "5" },
  "aptekagemini.pl": { j: "5" },
  "r7.com": { s: ".toolkit-privacy-box{display:none !important}" },
  "skillbox.ru": { c: 0 },
  "autoalkatreszonline24.hu": { s: ".block-cookies{display:none !important}" },
  "saarbruecker-zeitung.de": { j: "5" },
  "bernau-bei-berlin.de": { j: "5" },
  "england.de": { s: "#apc{display:none !important}" },
  "mallorca.com": { s: "#apc{display:none !important}" },
  "voordeeluitjes.nl": { j: "5" },
  "hyundai-entdecken.de": { s: "#COOKIE_POLICY{display:none !important}" },
  "takealot.com": { s: 'div[class*="cookie-banner"]{display:none !important}' },
  "adtipp.de": { j: "5" },
  "handelsregister.de": { j: "5" },
  "niagara-pu.ru": {
    s: 'div[data-storage-item*="cookiename"]{display:none !important}',
  },
  "mu.se": {
    s: 'div[data-storage-item*="cookiename"]{display:none !important}',
  },
  "mega.io": { j: "5" },
  "mega.nz": { j: "5" },
  "mega.be": { j: "5" },
  "g2g.com": { s: ".q-page ~ div > .fixed-bottom{display:none !important}" },
  "tempo.com": { j: "5" },
  "bulletin.com": { j: "5" },
  "huk24.de": { j: "5" },
  "huk.de": { j: "5" },
  "myminifactory.com": { s: ".footerBottom ~ div{display:none !important}" },
  "findhs.codes": { s: "#PrivacyAlert{display:none !important}" },
  "group.rwe": { j: "5" },
  "rwe.com": { j: "5" },
  "festo.com": { j: "5" },
  "sberbankdirect.de": { s: ".cm{display:none !important}" },
  "toner-dumping.de": { s: ".js--overlay{display:none !important}" },
  "rackstore.be": { j: "5" },
  "fello.se": { j: "5" },
  "bazarchic.com": {
    s: "#react-footer > div > div:not([class]){display:none !important}",
  },
  "lotuscars.com": { c: 98 },
  "ajax.nl": { j: "5" },
  "deadbydaylight.com": { j: "5" },
  "edclub.com": { s: ".__CC_popup{display:none !important}" },
  "idoctors.it": { j: "5" },
  "vastervik.se": { c: 0 },
  "schloss-gluecksburg.de": { j: "5" },
  "vcu.edu": { j: "5" },
  "webflow.com": { s: "#consent-container{display:none !important}" },
  "softzone.es": { j: "5" },
  "motorola.com.br": { s: "#motorola-cookies{display:none !important}" },
  "mav.hu": { c: 105 },
  "yokanavi.com": { s: ".agreement{display:none !important}" },
  "manutd.com": { j: "5" },
  "fotor.com": { s: 'div[class*="UseCookie"]{display:none !important}' },
  "mym.fans": { j: "5" },
  "wacomstore.com.br": { c: 34 },
  "g-star.com": { j: "5" },
  "sbermarket.ru": { s: ".alerts + div{display:none !important}" },
  "redenacionalderadio.com.br": {
    s: "#viewlet-disclaimer{display:none !important}",
  },
  "moebel.de": { j: "5" },
  "eqmac.app": { j: "3" },
  "dvdoo.dk": { j: "5" },
  "altibox.no": { j: "5" },
  "minaftale.dk": { j: "5" },
  "babysam.dk": { j: "5" },
  "sj.no": {
    s: "#root header nav + .MuiBox-root,.experiencefragment > .MuiContainer-root:first-child{display:none !important}",
  },
  "vitrado.de": { s: "app-google-consent{display:none !important}" },
  "cinch.co.uk": {
    s: '#___gatsby > [data-testid="overlay"],#___gatsby > div > [data-testid="cookie-banner"]{display:none !important}',
  },
  "gutscheine.computerbild.de": {
    s: 'div[data-testid="CookieBanner"]{display:none !important}',
  },
  "gravitycoach.com": { s: ".elo-snackbar{display:none !important}" },
  "barzahlen.de": { j: "5" },
  "biblioteka.wroc.pl": { j: "5" },
  "fulhamfc.com": { j: "5" },
  "restegourmet.de": { j: "6" },
  "xe.com": {
    s: '#__next div[class*="ConsentBanner"]{bottom:-100% !important}',
  },
  "aion.eu": { j: "5" },
  "jovempan.com.br": { s: ".custom-container-lgpd{display:none !important}" },
  "thecompleteuniversityguide.co.uk": {
    s: ".cookie_lbox{display:none !important}",
  },
  "zyro.com": { s: ".zyro-cookies{display:none !important}" },
  "vinos.de": { s: ".consent-cookie-box--lightbox{display:none !important}" },
  "flipsnack.com": { c: 14 },
  "tiempo.com": { j: "5" },
  "pflanze2000.de": { j: "5" },
  "check24.de": { j: "6" },
  "chargify.com": { c: 3 },
  "airwallex.com": { s: "main > footer ~ div{display:none !important}" },
  "vivobarefoot.de": { s: "#cookieNote{display:none !important}" },
  "easycosmetic.de": { c: 17 },
  "easycosmetic.be": { c: 17 },
  "easycosmetic.ch": { c: 17 },
  "easycosmetic.at": { c: 17 },
  "webcontinental.com.br": { s: ".wc-accept-cookies{display:none !important}" },
  "sentry.io": { s: "#sentry-consent-widget{display:none !important}" },
  "mapcarta.com": { c: 4 },
  "diesiedleronline.de": { j: "5" },
  "quantum-inspire.com": { c: 2 },
  "direct-assurance.fr": { j: "5" },
  "paulcamper.de": {
    s: '.mainContainer > [class*="banner"]{display:none !important}',
  },
  "brandvital.eu": { c: 22 },
  "motorismo.com.pl": { c: 22 },
  "agrojd.com": { c: 22 },
  "aspel.com.pl": { c: 22 },
  "dozamel.pl": { c: 22 },
  "bosch.com.pl": { c: 22 },
  "estetiq.pl": { c: 22 },
  "galerialazienek.pl": { c: 22 },
  "ksiegarniarubikon.pl": { c: 22 },
  "papier24h.pl": { c: 22 },
  "papieryczerpane.pl": { c: 22 },
  "agro-eko.com.pl": { c: 22 },
  "balcamp.pl": { c: 22 },
  "mebloart.eu": { c: 22 },
  "phalanxgames.pl": { c: 22 },
  "rol-mech.pl": { c: 22 },
  "stalco.pl": { c: 22 },
  "tayama.pl": { s: ".config-messages-background{display:none !important}" },
  "spawalniczy-sklep.pl": { c: 22 },
  "swiatkoralikow2.pl": { c: 22 },
  "tvprodukt.pl": { c: 22 },
  "workstyle.pl": { c: 22 },
  "tychy.pl": { c: 36 },
  "arx.pl": { c: 36 },
  "agrospec.pl": { c: 36 },
  "babysensepolska.pl": { c: 36 },
  "e-oazakrakow.pl": { c: 36 },
  "elabrick24.pl": { c: 36 },
  "haczykowo.pl": { c: 36 },
  "kopalniasrebra.com": { c: 36 },
  "abydos.pl": { c: 36 },
  "budowniczy.com.pl": { c: 36 },
  "kotrak.com": { c: 36 },
  "miodyapis.pl": { c: 36 },
  "salvatti.pl": { c: 36 },
  "texasclub.pl": { c: 36 },
  "mammut.com": { j: "5" },
  "toysrus.ca": { c: 20 },
  "turn-on.de": { j: "5" },
  "dwd.de": { j: "5" },
  "nerdstar.tv": { j: "5" },
  "dagvandewetenschap.be": { j: "5" },
  "tinder.com": {
    s: ".App > [data-nosnippet],#___gatsby > [data-nosnippet]{display:none !important}",
  },
  "stec.es": { j: "5" },
  "cnnbrasil.com.br": { s: "#pop__gdpr{display:none !important}" },
  "tp-link.com": { s: "#tp-cookie{display:none !important}" },
  "musik-produktiv.de": { j: "5" },
  "musik-produktiv.at": { j: "5" },
  "musik-produktiv.fr": { j: "5" },
  "musik-produktiv.ch": { j: "5" },
  "musik-produktiv.com": { j: "5" },
  "pikapolonica.si": {
    s: ".gdpr-modal-wrapper,.modals-overlay{display:none !important}",
  },
  "order.fiveguys.de": { j: "5" },
  "order.fiveguys.es": { j: "5" },
  "order.fiveguys.fr": { j: "5" },
  "order.fiveguys.co.uk": { j: "5" },
  "asfinag.at": { j: "5" },
  "afar.com": {
    s: '.preloaded_lightbox[style*="overflow"]{display:none !important}',
  },
  "polsatgo.pl": { j: "5" },
  "ulefone.com": { s: ".footermsg{display:none !important}" },
  "unicajabanco.es": {
    s: ".CC05:not(.cc05-privada) #cookieModalStart{display:none !important}",
    j: "5",
  },
  "detmir.ru": { s: "#app-container footer ~ div{display:none !important}" },
  "br.de": {
    s: '#__next > .fixed,#__next [class*="CookieContainer"]{display:none !important}',
  },
  "anwb.nl": {
    s: ".TRCO-application,.critical-dialog{display:none !important}",
  },
  "petz.com.br": { s: ".policy-warning-banner{display:none !important}" },
  "scapino.nl": { j: "5" },
  "unwetterhilfen.de": { s: ".App > div > .banner{display:none !important}" },
  "screenbud.com": { s: ".ccWrapper{display:none !important}" },
  "flightspots.co": { s: "body > .FloatingGroup{display:none !important}" },
  "wiresoft.com": { s: ".Cookie{display:none !important}" },
  "chipsaway.co.uk": { j: "5" },
  "glashuette-original.com": {
    s: "#js_dataNnoticeBtns{display:none !important}",
  },
  "svt.se": { j: "6", s: ".svt-cookie-message{display:none !important}" },
  "elblandkliniken.de": { s: "#Datenschutz{display:none !important}" },
  "unitedutilities.com": { j: "5" },
  "bagaggio.com.br": { s: ".lgpd{display:none !important}" },
  "lineheart.lu": {
    s: "#policy_banner,.policy-banner-overlay{display:none !important}",
  },
  "frag.jetzt": { j: "5" },
  "particify.de": { j: "5" },
  "zig-star.com": { s: ".md-consent{display:none !important}" },
  "kvno.de": { j: "5" },
  "xetra-gold.com": { j: "5" },
  "aoc.com": { c: 0 },
  "waitrose.com": { j: "6" },
  "isawitfirst.com": {
    s: '.main-cpu[data-pu*="cookies"]{display:none !important}',
  },
  "simstime.net": { j: "5" },
  "chinahighlights.com": { s: ".web_cookie{display:none !important}" },
  "animaute.fr": { j: "5" },
  "fertighaus.de": { s: ".BannerWrapper{display:none !important}" },
  "sslplus.de": { s: "#ccmRoot{display:none !important}" },
  "wu.ac.at": { j: "5" },
  "canto.com": { j: "5" },
  "prisma.de": { j: "5" },
  "sportshop.com": { s: "#solar-app ~ div{display:none !important}" },
  "stoertebeker.com": { c: 17 },
  "cv.fr": { c: 83 },
  "qastack.fr": { j: "5" },
  "qastack.it": { j: "5" },
  "qastack.com.de": { j: "5" },
  "qa-stack.pl": { j: "5" },
  "uvex-sports.com": { s: ".as__cookie-banner{display:none !important}" },
  "atlasobscura.com": { j: "5" },
  "ohmydev.pl": {
    s: '#__next > [style*="transform"]{display:none !important}',
  },
  "porterbuddy.com": { j: "5" },
  "ankerkraut.de": { j: "5" },
  "dava.dk": { c: 151 },
  "polsatboxgo.pl": { j: "5" },
  "tulli.fi": {
    s: '#root [aria-label="Cookie banner"]{display:none !important}',
  },
  "olhardigital.com.br": { s: "#lgpd_optall{display:none !important}" },
  "liveagent.com": { j: "5" },
  "hl.co.uk": { j: "5" },
  "terra.com.br": {
    s: '.navbar-disclaimer[data-button-url*="cookies"]{display:none !important}',
  },
  "terra.bio": {
    s: '#root [aria-label="cookie consent banner"]{display:none !important}',
  },
  "bibliotheques-specialisees.paris.fr": {
    s: 'div[role="alertdialog"]{display:none !important}',
  },
  "paris.fr": { j: "5", s: ".paris-cookies-banner{display:none !important}" },
  "janto.es": {
    s: "#Transparente,#widgetCookiesPpal{display:none !important}",
  },
  "auditoriodetenerife.com": {
    s: "#Transparente,#widgetCookiesPpal{display:none !important}",
  },
  "allfinanz.ag": { j: "5" },
  "dvag.de": { j: "5" },
  "montafon.at": { j: "5" },
  "termeszetjaro.hu": { j: "5" },
  "teutonavigator.com": { j: "5" },
  "engadin.ch": { j: "5" },
  "tourenplaner-rheinland-pfalz.de": { j: "5" },
  "wanderservice-schwarzwald.de": { j: "5" },
  "alpenvereinaktiv.com": { j: "5" },
  "nakedwines.com": { s: "nkd-cookie-banner{display:none !important}" },
  "hellowatt.fr": { s: "#cookie-modal__container{display:none !important}" },
  "fancentro.com": {
    s: ".MuiContainer-root > div > header ~ div{display:none !important}",
  },
  "yoys.no": { s: "#section-cookies{display:none !important}" },
  "cirklo.io": { c: 32 },
  "shopfacil.com.br": { s: ".modal-lgpd__wrapper{display:none !important}" },
  "finanzchef24.de": { j: "5" },
  "sudoku-aktuell.de": { j: "5" },
  "sourceforge.net": { j: "5" },
  "bt.com": { s: "#cookiePreference{display:none !important}" },
  "pcorcloud.com": { j: "5" },
  "communityfibre.co.uk": { j: "5" },
  "easyname.at": { j: "5" },
  "easyname.de": { j: "5" },
  "easyname.fr": { j: "5" },
  "easyname.com": { j: "5" },
  "airbnb.org": {
    s: 'div[data-application="true"] div[data-theme] > div > div > div > section{display:none !important}',
  },
  "finanzwende.de": { s: ".cn-wrapper{display:none !important}" },
  "statik.be": { j: "5" },
  "wooclap.com": {
    s: 'span[aria-labelledby*="cookie-banner"]{display:none !important}',
  },
  "lyst.com": { j: "5" },
  "lyst.co.uk": { j: "5" },
  "lyst.de": { j: "5" },
  "lyst.at": { j: "5" },
  "lyst.fr": { j: "5" },
  "phase-6.de": { j: "5" },
  "goldbet.it": { s: "#drop-cookie,.cookieOC{display:none !important}" },
  "lcp.fr": { j: "5" },
  "wizards.com": {
    s: '#primary-area ~ .vue-portal-target ~ div,#app nav > .fixed,#wizardCookieBanner,div[data-fetch-key*="CookiePrompt"],#__layout footer ~ .vue-portal-target ~ [data-fetch-key]{display:none !important}',
  },
  "pciconcursos.com.br": { s: "#lgpd{display:none !important}" },
  "digitalife.com.mx": { c: 111 },
  "mandmdirect.de": { c: 111 },
  "domstol.se": { j: "5" },
  "rhb.ch": { c: 4 },
  "ing.fr": { s: ".ing-CookieManagementNext{display:none !important}" },
  "bayernlb.de": { s: ".lg-backdrop{display:none !important}" },
  "dbvis.com": { c: 40 },
  "aok-erleben.de": {
    s: '.csm[data-module="cookie-manager-dialog"]{display:none !important}',
  },
  "hyser.ua": { c: 26 },
  "rsts.cz": { s: ".CookieBubble{display:none !important}" },
  "eperearstikeskus.ee": { j: "5" },
  "aqara.com": { s: "#modal-agreement{display:none !important}" },
  "pirolam.pl": { s: 'body > div[style*="100%"]{display:none !important}' },
  "devexpress.com": {
    s: '#wsMsgWnd[msgid*="cookie-info"]{display:none !important}',
  },
  "foursquare.com": { j: "5" },
  "skd.museum": { j: "5" },
  "fortisclothing.co.uk": { c: 5 },
  "inwork.cz": { s: ".fixed-cookie{display:none !important}" },
  "aukey.com": { s: ".fixed-cookie{display:none !important}" },
  "vauen.de": { c: 84 },
  "immunspender.com": { c: 84 },
  "easybell.de": { c: 84 },
  "haema.de": { c: 84 },
  "bsh-group.com": { j: "5" },
  "bosch-home.com": { j: "5" },
  "bosch-home.fr": { j: "5" },
  "bosch-home.se": { j: "5" },
  "bosch-home.nl": { j: "5" },
  "bosch-home.fi": { j: "5" },
  "bosch-home.at": { j: "5" },
  "bosch-home.ro": { j: "5" },
  "bosch-home.lu": { j: "5" },
  "bosch-home.es": { j: "5" },
  "bosch-home.be": { j: "5" },
  "bosch-home.dk": { j: "5" },
  "bosch-home.no": { j: "5" },
  "bosch-home.lt": { j: "5" },
  "bosch-home.pl": { j: "5" },
  "bosch-home.gr": { j: "5" },
  "bosch-home.com.tr": { j: "5" },
  "bosch-home.co.uk": { j: "5" },
  "bosch-home.bg": { j: "5" },
  "bosch-home.pt": { j: "5" },
  "bosch-home.ee": { j: "5" },
  "bosch-home.hr": { j: "5" },
  "constructa.com": { j: "5" },
  "balay.es": { j: "5" },
  "home-connect.com": { j: "5" },
  "adidas.de": { j: "5" },
  "adidas.co.in": { j: "5" },
  "adidas.co.uk": { j: "5" },
  "adidas.gr": { j: "5" },
  "adidas.it": { j: "5" },
  "adidas.fr": { j: "5" },
  "adidas.es": { j: "5" },
  "adidas.se": { j: "5" },
  "adidas.nl": { j: "5" },
  "adidas.pl": { j: "5" },
  "adidas.sk": { j: "5" },
  "adidas.at": { j: "5" },
  "adidas.pt": { j: "5" },
  "adidas.dk": { j: "5" },
  "adidas.no": { j: "5" },
  "adidas.ie": { j: "5" },
  "adidas.ru": { j: "5" },
  "adidas.be": { j: "5" },
  "adidas.com": { j: "5" },
  "adidas.fi": { j: "5" },
  "adidas.ca": { j: "5" },
  "adidas.cz": { j: "5" },
  "adidas.cl": { j: "5" },
  "reebok.com": { j: "5" },
  "reebok.co.uk": { j: "5" },
  "reebok.it": { j: "5" },
  "reebok.de": { j: "5" },
  "reebok.nl": { j: "5" },
  "reebok.fr": { j: "5" },
  "reebok.be": { j: "5" },
  "reebok.pl": { j: "5" },
  "reebok.se": { j: "5" },
  "reebok.at": { j: "5" },
  "reebok.es": { j: "5" },
  "reebok.cz": { j: "5" },
  "reebok.ie": { j: "5" },
  "reebok.com.br": { j: "5" },
  "koupitvstupenku.cz": { s: "#sprivacy{display:none !important}" },
  "domaintools.com": { c: 20 },
  "findamasters.com": { j: "5" },
  "i-motion.de": { j: "5" },
  "migros.com.tr": {
    s: "fe-product-cookie-indicator{display:none !important}",
  },
  "codeeurope.pl": { j: "5" },
  "nrc.nl": { s: ".user-confirmation-screen{display:none !important}" },
  "sbk.org": { j: "5" },
  "ottobock.de": { s: "#ottobock-usercentrics{display:none !important}" },
  "today.ua": { s: ".politic_confidel{display:none !important}" },
  "tutorela.com": { c: 69 },
  "pricerunner.dk": { j: "5" },
  "pricerunner.se": { j: "5" },
  "pricerunner.com": { j: "5" },
  "dfmg.de": { s: 'div[id^="ro_cookie"]{display:none !important}' },
  "world4you.com": {
    s: "#xtxNavigationOffCookiePolicy{display:none !important}",
  },
  "avcesar.com": { j: "5" },
  "livelo.com.br": { s: ".notifi{display:none !important}" },
  "home.barclays": { c: 0 },
  "ledlenser.ru": { s: ".alerting{display:none !important}" },
  "stern.de": { j: "5" },
  "kevag-telekom.de": { j: "5" },
  "hotroxuk.com": { s: ".dot_cookies{display:none !important}" },
  "packrafting-store.de": { s: "#basharModal{display:none !important}" },
  "gloria-palast.de": { j: "5" },
  "ft.com": { j: "5" },
  "dobrzemieszkaj.pl": { c: 137 },
  "modepark.de": { j: "5" },
  "extract.pics": { j: "5" },
  "iol.im": { j: "5" },
  "frp.no": { j: "5", s: ".gdpr__btn{display:none !important}" },
  "ihk-krefeld.de": { c: 17 },
  "notaire.be": { j: "5" },
  "jooble.org": {
    s: '#root div[data-test-name="_termsOfServices"]{display:none !important}',
  },
  "wasakredit.se": { j: "5" },
  "kikkoman.de": { s: ".kik-cookiebanner{display:none !important}" },
  "lojadomecanico.com.br": { s: ".box-termo-lgpd{display:none !important}" },
  "wells.pt": { c: 14 },
  "silmaasema.fi": { c: 14 },
  "icelandair.com": {
    s: '#root > [class*="assets_container"]{display:none !important}',
  },
  "occrp.org": { s: ".occrp-cookie-overlay,.cookie{display:none !important}" },
  "linztourismus.at": { j: "5" },
  "cinemotion-kino.de": { s: "#cookie-layer{display:none !important}" },
  "sex.com": { j: "5" },
  "handyhuellen.de": { j: "5" },
  "floragard.de": { j: "5" },
  "2ip.ru": { j: "5" },
  "arabicpost.net": { c: 20 },
  "cualesmiip.com": { j: "5" },
  "powys.gov.uk": { s: "#cookie-consent-prompt{display:none !important}" },
  "sunderland.gov.uk": { j: "5" },
  "ozeaneum.de": { j: "5" },
  "sellmylivestock.com": { s: "#app > .fixed{display:none !important}" },
  "storececotec.com": { j: "5" },
  "routex.com": { j: "5" },
  "restore.co.uk": { s: ".restorealertBar{display:none !important}" },
  "pokemoncenter.com": { s: "footer > div ~ div{display:none !important}" },
  "pnp.co.za": { s: ".policiesPopup{display:none !important}" },
  "opositatest.com": { s: ".otcn{display:none !important}" },
  "sparda.de": { j: "5" },
  "sparda-n.de": { j: "5" },
  "sparda-bw.de": { j: "5" },
  "sparda-hessen.de": { j: "5" },
  "tonies.com": { c: 0 },
  "depop.com": { j: "5" },
  "autotrader.com": {
    s: "#mountNode > .fixed-bottom{display:none !important}",
  },
  "artigercek.com": { s: ".user-consent{display:none !important}" },
  "get-in-engineering.de": { j: "5" },
  "theathletic.co.uk": {
    s: 'div[class*="StickyBottomBanner"]{display:none !important}',
  },
  "primevideo.com": {
    s: '.DVWebNode[class*="wrapper"][class*="cookie"]{display:none !important}',
  },
  "otcmarkets.com": { s: "#userAgreementBanner{display:none !important}" },
  "zutobi.com": { s: 'div[class*="ModalCookies"]{display:none !important}' },
  "leeway.tech": { j: "5" },
  "regionalimmobilien24.de": { j: "5" },
  "amazon-affiliate.eu": { c: 6 },
  "polarstern-energie.de": { j: "5" },
  "certificat-covid.gov.ro": { s: ".bottom-banner{display:none !important}" },
  "aviva.fr": { j: "5", s: ".ccb-sticky{display:none !important}" },
  "salto.fr": { j: "5" },
  "clipchamp.com": { s: "main + div ~ div{display:none !important}" },
  "lichtblick.de": { s: "#uc_layer{display:none !important}" },
  "volimzmenu.cz": { c: 0 },
  "petlove.com.br": { s: ".card-bottom{display:none !important}" },
  "foussier.fr": { j: "5" },
  "farmaciasdirect.com": { s: ".fd-cookies{display:none !important}" },
  "posti.fi": { s: "#consent-popup{display:none !important}" },
  "tresorit.com": {
    s: "main ~ aside,sticky-notification{display:none !important}",
  },
  "bandaancha.eu": { s: ".euCk{display:none !important}" },
  "hertz.ca": {
    s: 'div[class*="PrivacyPolicyBanner"]{display:none !important}',
  },
  "sagepub.com": { s: 'header [role="alert"]{display:none !important}' },
  "edukatico.org": { j: "5" },
  "theartnewspaper.com": { c: 142 },
  "mitid.dk": { j: "5" },
  "people.cn": { s: "#shengmingTip{display:none !important}" },
  "cinemaxx.de": { j: "5" },
  "bipandgo.com": { s: ".ucm_wrapper{display:none !important}" },
  "uktv.co.uk": { j: "5" },
  "benq.eu": { j: "5", s: "#cookie-fullscreen{display:none !important}" },
  "plusmobile.fr": { c: 3 },
  "weddyplace.com": { j: "5" },
  "caimmo.com": { j: "5" },
  "svd.se": { s: "#schibsted-data-controller-sticky{display:none !important}" },
  "aftenposten.no": { s: "#data-controller-sticky{display:none !important}" },
  "bt.no": { s: "#data-controller-sticky{display:none !important}" },
  "volkswagen-newsroom.com": {
    s: 'body[style*="hidden"]{overflow:visible !important}',
  },
  "inwx.com": { j: "5" },
  "inwx.de": { j: "5" },
  "inwx.at": { j: "5" },
  "traderepublic.com": { s: ".consentCard{display:none !important}" },
  "grile-rezidentiat.ro": { j: "5" },
  "tfwm.org.uk": { s: ".wmnds-cookies-banner{display:none !important}" },
  "foodwatch.org": { s: ".cn-banner{display:none !important}" },
  "amazon.com": { j: "5" },
  "newsworthy.se": { s: ".Snack{display:none !important}" },
  "mobrog.com": { j: "5" },
  "avtomobilizem.com": { s: ".c-notice{display:none !important}" },
  "actual.at": { s: ".c-notice{display:none !important}" },
  "xing.com": { j: "5" },
  "techopital.com": { j: "5" },
  "ticsante.com": { j: "5" },
  "sandro-paris.com": { j: "5" },
  "feuvert.fr": { j: "5" },
  "wifi-ooe.at": { j: "5" },
  "wifiwien.at": { j: "5" },
  "wifi.at": { j: "5" },
  "atlatszo.hu": { s: "#the_popup{display:none !important}" },
  "cm.games": { c: 0 },
  "treasure.cloud": { j: "5" },
  "liftango.com": { s: ".fs-cc-symbol{display:none !important}" },
  "specscart.co.uk": { c: 2 },
  "consumentenbond.nl": {
    s: '.w-full[data-test="consent-banner"]{display:none !important}',
  },
  "galaxus.de": {
    s: "#__next > div[aria-hidden]:not([data-layout-container]){display:none !important}",
  },
  "galaxus.at": {
    s: "#__next > div[aria-hidden]:not([data-layout-container]){display:none !important}",
  },
  "brewdog.com": { s: "#segment-consent-banner{display:none !important}" },
  "fupro.de": { c: 14 },
  "host-unlimited.de": { j: "5" },
  "fujifilm.com": { s: ".m-cookie-confirm{display:none !important}" },
  "mezoko.com": { c: 0 },
  "gibgas.de": { j: "5" },
  "iebschool.com": { s: ".content-bottom-drawer{display:none !important}" },
  "smule.com": { j: "5" },
  "mydpd.at": { j: "5" },
  "2ip.io": { j: "5" },
  "cellbes.no": { j: "5" },
  "cellbes.cz": { j: "5" },
  "cellbes.dk": { j: "5" },
  "cellbes.ee": { j: "5" },
  "cellbes.fi": { j: "5" },
  "cellbes.lv": { j: "5" },
  "cellbes.pl": { j: "5" },
  "cellbes.sk": { j: "5" },
  "cellbes.se": { j: "5" },
  "etipolam.com.pl": { c: 3 },
  "ivolta.pl": { j: "5" },
  "kickbooster.me": { s: ".kb__cookie-consent{display:none !important}" },
  "thisinterestsme.com": { s: "#ww-blackout{display:none !important}" },
  "seb.lt": { j: "5" },
  "seb.ee": { j: "5" },
  "pensionikeskus.ee": { s: "#gdpr-confirm{display:none !important}" },
  "nasdaqbaltic.com": { s: "#gdpr-confirm{display:none !important}" },
  "lalettrea.fr": { j: "5" },
  "africaintelligence.fr": { j: "5" },
  "nintendo.com": {
    s: ".o_p-membership-cookie-law-message{display:none !important}",
    j: "5",
  },
  "nintendo.ch": { j: "5" },
  "nintendo.de": { j: "5" },
  "nintendo.fr": { j: "5" },
  "nintendo.at": { j: "5" },
  "nintendo.nl": { j: "5" },
  "nintendo.es": { j: "5" },
  "nintendo.pt": { j: "5" },
  "nintendo.it": { j: "5" },
  "nintendo.ru": { j: "5" },
  "nintendo.co.uk": { j: "5" },
  "nintendo.be": { j: "5" },
  "nintendo.co.za": { j: "5" },
  "pro-alarm.nl": {
    s: ".mgz-flex-position-bottom-center{display:none !important}",
  },
  "cpanel.net": { c: 157 },
  "hollisterco.com": {
    s: '.flash-message[data-flash-message-group-id*="cookie"]{display:none !important}',
  },
  "xn--bafa-frderung-nmb.de": {
    j: "5",
    s: ".CookieEButton{display:none !important}",
  },
  "brack.ch": { s: "#b2c-consent{display:none !important}" },
  "enpara.com": { s: ".enpara-web-cookie{display:none !important}" },
  "copenhagenstudios.com": { s: "#cookie-layer{display:none !important}" },
  "hevert.com": { s: "#cookie-options{display:none !important}" },
  "partech.nl": { s: ".cookies-gradient{display:none !important}" },
  "contabilizei.com.br": { c: 59 },
  "xn--80aesfpebagmfblc0a.xn--p1ai": {
    s: ".cv-cookie-banner__inner{display:none !important}",
  },
  "mudes.org.br": { c: 5 },
  "baufi24.de": { c: 59 },
  "pornpics.com": { s: "#cookie-contract{display:none !important}" },
  "dnbeiendom.no": { j: "5" },
  "ntcompatible.com": {
    s: 'script[src*="consent"] + .alert{display:none !important}',
  },
  "eportugal.gov.pt": { s: "#section-cookies{display:none !important}" },
  "molcesko.cz": { j: "5" },
  "slovnaft.sk": { j: "5" },
  "doppelherz.de": { j: "5" },
  "doppelherz.com": { j: "5" },
  "doppelherz.pl": { j: "5" },
  "visitmalta.com": { j: "5" },
  "pure.app": { s: "#__next main ~ div{display:none !important}" },
  "dominospizza.pl": { j: "5" },
  "bbvaapimarket.com": { j: "5" },
  "livemaster.ru": { s: ".cookieconsent-ru{display:none !important}" },
  "adrecord.com": { j: "5" },
  "burton.com": { j: "5" },
  "hotcoursesabroad.com": { s: "#ckieOvrlayDiv{display:none !important}" },
  "markt-lichtenau.de": { s: "#ck-overlay{display:none !important}" },
  "energijaplus.si": { s: "#ck-overlay{display:none !important}" },
  "telia.lt": { j: "5" },
  "metapop.com": { j: "5" },
  "douglas.de": { j: "5" },
  "douglas.at": { j: "5" },
  "douglas.ch": { j: "5" },
  "douglas.pl": { j: "5" },
  "douglas.nl": { j: "5" },
  "douglas.be": { j: "5" },
  "douglas.it": { j: 5 },
  "forbes.com": { j: "5" },
  "fortune.com": { j: "5" },
  "rhein-kreis-neuss.de": {
    s: ".rkn-row-footer-cookie-notice{display:none !important}",
  },
  "clickbus.com.br": { s: "#footer-policy{display:none !important}" },
  "linkaband.com": { s: "app-cookie-modal{display:none !important}" },
  "blokas.io": { s: "#__layout > div .bg-success{display:none !important}" },
  "cognex.com": { j: "5" },
  "vw-shop-zubehoer.de": { j: "5" },
  "audi-ingolstadt-shop.de": { j: "5" },
  "lth.se": { s: ".alert.fixed-bottom{display:none !important}" },
  "hotter.com": { s: ".enhanced-cookies__modal{display:none !important}" },
  "centauro.com.br": { j: "5" },
  "rgs.ru": { s: ".cookie,#rgs-main-context-bar{display:none !important}" },
  "acogo.pl": { c: 5 },
  "kyoceradocumentsolutions.eu": { j: "5" },
  "kyoceradocumentsolutions.de": { j: "5" },
  "kyoceradocumentsolutions.ru": { j: "5" },
  "kyoceradocumentsolutions.ch": { j: "5" },
  "kyoceradocumentsolutions.fr": { j: "5" },
  "kyoceradocumentsolutions.it": { j: "5" },
  "kyoceradocumentsolutions.co.uk": { j: "5" },
  "kyoceradocumentsolutions.us": { j: "5" },
  "kyoceradocumentsolutions.es": { j: "5" },
  "focus-entmt.com": { s: "#app > nav + div{display:none !important}" },
  "max-academy.de": { j: "5" },
  "bolagsverket.se": { c: 0 },
  "martha-maria.de": { s: "mama-cookie-banner{display:none !important}" },
  "futurzwei.org": { j: "5" },
  "autoglass.co.uk": { j: "5" },
  "c-klasse-forum.de": { s: "#consentBoxWrapper{display:none !important}" },
  "journalist.de": { c: 30 },
  "ecouter-en-direct.com": { c: 30 },
  "radioemu.com": { c: 30 },
  "neuwagenduft.de": { c: 30 },
  "languagelab.nl": { c: 30 },
  "camerapricebuster.co.uk": { c: 30 },
  "djv.de": { c: 30 },
  "bjr.de": { c: 30 },
  "bundesanzeiger-verlag.de": { c: 30 },
  "fairtrade.at": { c: 30 },
  "hey.bayern": { c: 30 },
  "actu-environnement.com": {
    s: "#cookies_preferences{display:none !important}",
  },
  "perekrestok.ru": { s: ".cookie-content{display:none !important}" },
  "ariaspa.it": { s: "#cookieAria{display:none !important}" },
  "eplaque.fr": { s: "#rgpd{display:none !important}" },
  "openreach.com": { j: "5" },
  "jobs.ch": { j: "5" },
  "online.sberbank.ru": {
    s: "footer > div > div + div{display:none !important}",
  },
  "sberbank.si": { j: "5" },
  "daswetter.com": { j: "5" },
  "daswetter.at": { j: "5" },
  "radio1.ch": { c: 0 },
  "jeremylikness.com": { j: "5" },
  "stooq.pl": { j: "5" },
  "stooq.com": { j: "5" },
  "sportoutlet.no": { s: ".main-layout > .fixed{display:none !important}" },
  "wirtualnemedia.pl": { j: "5" },
  "kinderaerzte-moelln.de": {
    s: ".wrapper-confirmation-privacy{display:none !important}",
  },
  "ouraring.com": { s: ".tailwind > .fixed{display:none !important}" },
  "iltalehti.fi": { j: "5" },
  "autotalli.com": { j: "5" },
  "tekniikkatalous.fi": { j: "5" },
  "mediuutiset.fi": { j: "5" },
  "e-kontakti.fi": { j: "5" },
  "tivi.fi": { j: "5" },
  "mikrobitti.fi": { j: "5" },
  "uusisuomi.fi": { j: "5" },
  "kauppalehti.fi": { j: "5" },
  "deepl.com": { s: "#dl_cookieBanner{display:none !important}" },
  "teknikkdeler.no": { c: 0 },
  "gymgrossisten.com": { s: ".overlay-banner{display:none !important}" },
  "marc-o-polo.com": { j: "5" },
  "sparda-west.de": { j: "5" },
  "e-rolety.eu": { c: 0 },
  "micronfrance.fr": { j: "5" },
  "babil.com": { s: ".bbl-cookie-consent{display:none !important}" },
  "ecoplus.at": { j: "5" },
  "frisco.pl": { j: "5" },
  "avg.com": { s: "#bottomBar #gdpr{display:none !important}" },
  "smartpost.ee": { j: "5" },
  "auszug.at": { j: "5" },
  "mozio.com": { s: "#container > .desktop ~ div{display:none !important}" },
  "svenskaspel.se": { j: "6" },
  "lokaleportalen.dk": { j: "5" },
  "bostadsdeal.se": { j: "5" },
  "cargoboard.com": {
    s: "body > .fixed-bottom.bg-gray{display:none !important}",
  },
  "pvs-studio.com": { s: ".personal-data-confirm{display:none !important}" },
  "verema.com": { c: 0 },
  "cfainstitute.org": { s: "#privacyWarning{display:none !important}" },
  "excellent-hemd.de": {
    j: "5",
    s: '.fixed-bottom .btn[onclick*="cookieModal"]{display:none !important}',
  },
  "libelium.com": { j: "5" },
  "euroimmun.de": { j: "5" },
  "action.com": { s: ".cookieModal{display:none !important}" },
  "myinvestor.es": { c: 0 },
  "labuenavidalg.es": { s: "#CookiesLayer{display:none !important}" },
  "otpbank.ro": { j: "5" },
  "e-shelter.de": { j: "5" },
  "anadibank.com": { j: "5" },
  "bitbrain.com": { j: "5" },
  "motorflash.com": { s: ".cookiesNew{display:none !important}" },
  "cornelsen.de": { j: "5" },
  "lawinsider.com": {
    s: "#header ~ .light-blue-bordered-card{display:none !important}",
  },
  "strawpoll.de": { s: "#consent-overlay{display:none !important}" },
  "mitsubishi-motors.ca": { s: ".cookiemodal{display:none !important}" },
  "eika.no": { s: ".no-eika-cookieconsent{display:none !important}" },
  "searchforsites.co.uk": {
    s: "#cookieConsent,#modal-overlay{display:none !important}",
  },
  "fvg.it": { c: 111 },
  "tsuche.com": { s: "#c-c{display:none !important}" },
  "lionsroar.com": { c: 5 },
  "schuurman-schoenen.nl": { j: "5" },
  "sazka.cz": { s: ".consent-bar{display:none !important}" },
  "0800repair.com": { s: "#wp-notification{display:none !important}" },
  "ecologi.com": { s: "#modal-root ~ div{display:none !important}" },
  "steambuy.com": { s: "#sb-privacy-policy{display:none !important}" },
  "dbk.de": { c: 30 },
  "schlauerlernen.de": { s: "#cookiereminder{display:none !important}" },
  "mcc.live": { c: 0 },
  "videogameschronicle.com": { j: "5" },
  "aktin.cz": { j: "5" },
  "supermiro.lu": { s: "#lightbox-gdpr{display:none !important}" },
  "supermiro.com": { s: "#lightbox-gdpr{display:none !important}" },
  "nsinternational.com": { j: "5" },
  "serasa.com.br": {
    s: 'div[aria-labelledby="m-acc-title"]{display:none !important}',
  },
  "bv-activebanking.de": { j: "5" },
  "whatsapp.com": {
    s: '.hasCookieBanner > div[data-testid="wa_cookies_banner_modal"]{display:none !important}',
  },
  "faq.whatsapp.com": {
    s: 'div[id^="mount_"] > div > div > div:last-child:not(:only-of-type){display:none !important}',
  },
  "italki.com": { s: 'div[class*="cookie_root"]{display:none !important}' },
  "ogulo.com": { j: "5" },
  "dr-gumpert.de": { s: "#cookie_modal_container{display:none !important}" },
  "lego.com": {
    j: "5",
    s: 'div[class*="CookieDisclaimer"],#footer ~ [class*="emotion-cache"],#prompt-footer{display:none !important}',
  },
  "ahaan.co.uk": { c: 24 },
  "bascom-kameras.de": { j: "5" },
  "le-livre.fr": { s: "#showcookie{display:none !important}" },
  "argeles-sur-mer.com": { s: ".cookies-global{display:none !important}" },
  "pharmasimple.com": { s: "#pharmabiscuit-popin{display:none !important}" },
  "ibisahome.com": { c: 0 },
  "investify.com": { j: "5" },
  "skuola.net": { j: "5" },
  "ubereats.com": { j: "5" },
  "century21.fr": { j: "5" },
  "gunfinder.de": { j: "5" },
  "westend61.de": { s: "#cookie_Modal{display:none !important}" },
  "aliexpress.ru": {
    s: 'div[class*="PrivacyPolicyBanner"]{display:none !important}',
  },
  "aliexpress.com": {
    s: '#gdpr-new-container,.ui-mask,.gdpr-dialog-class,#j-aliexpress-notice,#container-for-smart-banner ~ div:not([id]):not([class*=" "]):not([style]):nth-last-child(2),#voyager-gdpr,.site-notice-header{display:none !important}',
  },
  "aliexpress.us": {
    s: '#gdpr-new-container,.ui-mask,.gdpr-dialog-class,#j-aliexpress-notice,#container-for-smart-banner ~ div:not([id]):not([class*=" "]):not([style]):nth-last-child(2),#voyager-gdpr,.site-notice-header{display:none !important}',
  },
  "aromes-et-liquides.fr": { s: "#rgpdcookie{display:none !important}" },
  "boomin.com": {
    s: 'div[data-testid*="cookie-modal"]{display:none !important}',
  },
  "panasonicproclub.com": { s: "#over{display:none !important}" },
  "kontist.com": {
    s: '#__next > .fixed[class*="bg"],#__next > .fixed[class*="bottom"]{display:none !important}',
  },
  "medpets.fr": { s: '.tw-fixed[ref="cookie-modal"]{display:none !important}' },
  "pzu.pl": { j: "5" },
  "limaeasy.com": {
    s: '.rstbox.eb-custom.eb-bottom-left[data-options*="EngageBox"]{display:none !important}',
  },
  "pikolinos.com": { j: "5" },
  "kolejeslaskie.com": { c: 164 },
  "extrabux.com": { s: ".ccpabar{display:none !important}" },
  "timma.fi": { s: "#alert-root{display:none !important}" },
  "winamp.com": { c: 0 },
  "beatstars.com": { s: "mp-cookies-snackbar{display:none !important}" },
  "solicitor.info": { s: "#msgbg{display:none !important}" },
  "fintraffic.fi": { j: "5" },
  "sl.se": {
    s: 'body > div[class*="header"] > div > div:first-child:not([class]){display:none !important}',
  },
  "airfleets.net": { s: "#blur{display:none !important}" },
  "redis.com": { c: 3 },
  "bdz.bg": { j: "5" },
  "earlybird.delivery": { s: ".policy-notice{display:none !important}" },
  "conqblade.com": { s: ".gw-cookies{display:none !important}" },
  "dekamarkt.nl": { c: 2 },
  "psy.pl": {
    s: "#infoPopup{display:none !important}",
    c: 14,
  },
  "tldallas.com": { c: 0, j: "5" },
  "kupplung.de": { j: "5" },
  "keldoc.com": { j: "5" },
  "food-detektiv.de": { c: 20 },
  "mekongpackraft.com": { c: 5 },
  "gritija.lt": { s: ".gdprModal{display:none !important}" },
  "mkb.hu": { j: "5" },
  "bnpparibas.com": { s: "cts-disclaimer-cookies{display:none !important}" },
  "eurogarages.com": { s: "#cp-overlay{display:none !important}" },
  "bodohavn.no": { c: 16 },
  "catho.com.br": { j: "5" },
  "pyroweb.de": { j: "5" },
  "familieretshuset.dk": { j: "5" },
  "ouedkniss.com": { j: "5" },
  "kisailu.net": { j: "5" },
  "ditzozorg.nl": { j: "5" },
  "wgv.de": { j: "5" },
  "nordicnest.com": { c: 50 },
  "nordicnest.es": { c: 50 },
  "nordicnest.de": { c: 50 },
  "nordicnest.dk": { c: 50 },
  "nordicnest.fi": { c: 50 },
  "nordicnest.fr": { c: 50 },
  "nordicnest.kr": { c: 50 },
  "nordicnest.nl": { c: 50 },
  "nordicnest.no": { c: 50 },
  "nordicnest.se": { c: 50 },
  "studeersnel.nl": {
    s: "#main-wrapper ~ div > .undefined{display:none !important}",
  },
  "augen-lasern-vergleich.de": { j: "5" },
  "inrs.fr": { j: "5" },
  "disclose.ngo": { c: 0 },
  "infobox.ru": { s: ".ibx-coockie-agree{display:none !important}" },
  "oi.com.br": {
    s: '.info-bar,#root [class*="BannertContainer"]{display:none !important}',
  },
  "losteria.de": { j: "5" },
  "audiototaal.com": { c: 0 },
  "signalshares.com": { j: "5" },
  "universidadeuropea.com": {
    s: '#modal_footer[class*="cookies"]{display:none !important}',
  },
  "membersuite.com": { j: "5" },
  "viva.gr": { j: "5" },
  "wesendit.com": { j: "5" },
  "grander.com": { j: "5" },
  "portaleds.com": { s: "body > .cke{display:none !important}" },
  "googlewatchblog.de": { j: "5" },
  "100giornidaleoni.it": { j: "5" },
  "grab.com": { s: "#gr-cookie-notice-banner{display:none !important}" },
  "nocowanie.pl": { s: "#site-navigation ~ div{display:none !important}" },
  "dresden-elbland.de": { j: "5" },
  "teliacarrier.com": { s: "#modal-cookies-general{display:none !important}" },
  "lokinn.com": { c: 83 },
  "kfcvisit.com": { c: 83 },
  "erc-ingolstadt.de": { j: "5" },
  "livevacancies.co.uk": { j: "5" },
  "dr-braunger.de": { s: ".tx-dm-cookies{display:none !important}" },
  "nano.org": { c: 6 },
  "liste-finanzamt.de": { s: "#dsgvo{display:none !important}" },
  "fairgarage.com": { s: "#dsgvo{display:none !important}" },
  "koegel-touristik.de": {
    s: "#dsgvo,#dsgvo_bglayer{display:none !important}",
  },
  "workplace.com": { j: "5" },
  "topfarmacia.it": { s: ".gdprModal{display:none !important}" },
  "ntng.gr": { s: ".prvmodal{display:none !important}" },
  "intezer.com": { s: ".site-notification-message{display:none !important}" },
  "mujionline.eu": { s: "#cokbar{display:none !important}" },
  "napster.com": { j: "5" },
  "huawei.com": {
    s: ".huawei-convergent-cookie,#cookieTipOut,.hwid-bannerBox-portal,.privacy-dialog.is-show,.browsehappy.ReadPolicy,.huawei-app-cookie,.huawei-bootom-cookie{display:none !important}",
  },
  "huawei.eu": { s: "#cookieTipOut{display:none !important}" },
  "onebrandssweepstakes.com": { c: 3 },
  "elring.com": { j: "5" },
  "elring.ae": { j: "5" },
  "elring.cn": { j: "5" },
  "elring.com.tr": { j: "5" },
  "elring.de": { j: "5" },
  "elring.fr": { j: "5" },
  "elring.it": { j: "5" },
  "elring.pl": { j: "5" },
  "elring.pt": { j: "5" },
  "elring.ru": { j: "5" },
  "stemi.education": {
    s: '.app > [class*="Notification"]{display:none !important}',
  },
  "stark-watzinger.de": { j: "5" },
  "mathsisfun.com": { s: "#cookOK{display:none !important}" },
  "riigipilv.ee": { s: ".r-gdpr-popup{display:none !important}" },
  "awilime.com": { s: ".afcoo{display:none !important}" },
  "bike-transalp.de": { s: "#cookie-clicker{display:none !important}" },
  "visnos.com": { c: 1 },
  "spiderfoot.net": { c: 0 },
  "suzuki-alkatreszek.hu": { s: "#cookieC{display:none !important}" },
  "zuendstoff-clothing.de": {
    s: ".ConsentOverlay,.ModalBackground{display:none !important}",
  },
  "konzoluzlet.hu": { s: ".cookie_inform{display:none !important}" },
  "fixedfloat.com": { s: ".reminder{display:none !important}" },
  "bauermedia.co.uk": { j: "5" },
  "wincofoods.com": {
    s: "mct-templater-cookie-consent{display:none !important}",
  },
  "multibonus.ru": {
    s: '#root > div > header[color="info"]{display:none !important}',
  },
  "h24finance.com": { j: "5" },
  "headforpoints.com": { s: ".ancr-pos-bottom{display:none !important}" },
  "bbva.it": { j: "5" },
  "bbva.pt": { j: "5" },
  "bbva.es": { j: "5" },
  "catawiki.com": { j: "5" },
  "catawiki.nl": { j: "5" },
  "catawiki.de": { j: "5" },
  "catawiki.eu": { j: "5" },
  "catawiki.fr": { j: "5" },
  "catawiki.es": { j: "5" },
  "catawiki.pl": { j: "5" },
  "catawiki.it": { j: "5" },
  "catawiki.se": { j: "5" },
  "teacheconomy.de": {
    j: "5",
    s: ".cookie-banner-button{display:none !important}",
  },
  "zdrofit.pl": { s: "#cookies,#backdrop{display:none !important}" },
  "configure.bmw.ca": { j: "5" },
  "skandia.se": { s: "#kakhylla,#kakoverdrag{display:none !important}" },
  "trox.de": { s: ".trox-consent-manager{display:none !important}" },
  "schutzhuellenprofi.de": { j: "5" },
  "supremenewyork.com": { s: "#top_notice{display:none !important}" },
  "thesettlersonline.com": { j: "5" },
  "thesettlersonline.pl": { j: "5" },
  "krone.bz": { s: 'div[class*="cookie-banner"]{display:none !important}' },
  "fahrrad-xxl.de": {
    s: ".fxxl-cookie-mainmodal,.modal-overlay{display:none !important}",
  },
  "cartodebat.fr": { c: 11 },
  "roonlabs.com": { c: 5 },
  "mod.io": { s: "#achtung-overlay{display:none !important}" },
  "permisecole.com": { s: "#rgpd{display:none !important}" },
  "elisa.fi": {
    s: ".react-navi-ea-cookie-disclaimer,.ea-cookie-disclaimer{display:none !important}",
  },
  "medienportal-sachsen-anhalt.de": { s: ".hinweis{display:none !important}" },
  "gartentraeume-sachsen-anhalt.de": {
    s: '.vcModalOverlay[for="overlayPrivacySwitch"],.vcModalOverlay[for="overlayPrivacySwitch"] ~ .vcModal{display:none !important}',
  },
  "trasferirsiallecanarie.info": { j: "5" },
  "meinbildkalender.de": { j: "5" },
  "essent.nl": { j: "5" },
  "energiewonen.nl": { j: "5" },
  "verpackungsregister.org": { j: "5" },
  "leoprinting.fr": { j: "5" },
  "argenta.be": { j: "5" },
  "barcelonaled.fr": { j: "5" },
  "ivaucher.pt": { j: "5" },
  "pilot-frixion.uk": { c: 0 },
  "pilot-frixion.fr": { c: 0 },
  "global.bible": {
    s: "#root > section + div:not(:last-child){display:none !important}",
  },
  "sainsburysmagazine.co.uk": { s: "#CookieTool{display:none !important}" },
  "kotipizza.fi": { s: ".notification-bottom{display:none !important}" },
  "eutraining.eu": { s: "#eutraining-cookibar{display:none !important}" },
  "olafneumann.org": { s: "#rg_container_cookie{display:none !important}" },
  "brp.com": { s: "#consent-dialog{display:none !important}" },
  "min.io": { s: ".footer__banner{display:none !important}" },
  "rundfunkbeitrag.de": { s: "#optInId{display:none !important}" },
  "pizzafan.gr": { j: "5" },
  "mathaus.ro": { s: "#cookieOptionsFooter{display:none !important}" },
  "lagerbox.com": { s: ".modal-outer,.cookie-modal{display:none !important}" },
  "msp360.com": { s: ".use-cookie{display:none !important}" },
  "jcb.com": { s: ".jcb-cookie-disclaimer{display:none !important}" },
  "rocrivor.nl": { j: "5" },
  "sfirmware.com": { j: "5" },
  "lg-firmwares.com": { j: "5" },
  "call-a-pizza.de": { j: "5" },
  "telepizza.de": { j: "5" },
  "hellojoko.com": { j: "5" },
  "copmadrid.org": { s: "#div_cookies_nueva{display:none !important}" },
  "packster.de": { s: ".page-overlay{display:none !important}" },
  "hdg.de": { s: "#cookiebg,#hdg-cookie-accept{display:none !important}" },
  "zeitzeugen-portal.de": {
    s: "#cookiebg,#hdg-cookie-accept{display:none !important}",
  },
  "bitrefill.com": { s: "#consentDialog{display:none !important}" },
  "assurland.com": {
    s: "#consentManagementPlatform{display:none !important}",
    c: 14,
  },
  "travelsupermarket.com": { j: "5" },
  "bonami.hu": { j: "5" },
  "dunelm.com": { j: "5" },
  "web.dev": { s: "web-snackbar{display:none !important}" },
  "kraemer.de": { s: "#consentLayer{display:none !important}" },
  "landkreis-ostallgaeu.de": { c: 0 },
  "doordash.com": { j: "5" },
  "gordonua.com": { s: ".cookie-label{display:none !important}" },
  "eurogamer.net": { j: "5" },
  "crfashionbook.com": { j: "5" },
  "rockpapershotgun.com": { j: "5" },
  "mensjournal.com": { j: "5" },
  "assetstore.unity.com": { j: "5" },
  "popsugar.co.uk": { j: "5" },
  "rte.ie": { j: "5" },
  "sika.com": { j: "5" },
  "merkurmarkt.at": { j: "5" },
  "cnbc.com": { j: "5" },
  "dhl.de": { j: "5" },
  "sport.pl": { j: "5" },
  "mtvuutiset.fi": { j: "5" },
  "billa.at": { j: "5" },
  "aerztezeitung.de": { j: "5" },
  "werkenbijkruidvat.nl": { j: "5" },
  "metro.de": { j: "5" },
  "metro.fr": { j: "5" },
  "metro.at": { j: "5" },
  "metro.hu": { j: "5" },
  "metro.bg": { j: "5" },
  "metro.it": { j: "5" },
  "metro.co.uk": { j: "5" },
  "metro.pe": { j: "5" },
  "metro.ca": { c: 6 },
  "makro.nl": { j: "5" },
  "makro.cz": { j: "5" },
  "makro.pt": { j: "5" },
  "makro.pl": { j: "5" },
  "rejestracja.makro.pl": { c: 0 },
  "postel.it": { s: "#postel-cookies{display:none !important}" },
  "global.abb": { c: 2 },
  "smullers.nl": { s: ".alert{display:none !important}" },
  "atomichub.io": { j: "5" },
  "schweinske.de": { j: "5" },
  "marbles.com": { j: "5", s: "#cookie-consents{display:none !important}" },
  "caseys.ie": {
    s: "#caseys-cookie-modal{display:none !important}",
    c: 14,
  },
  "smallpdf.com": { s: ".rplgd-0{display:none !important}" },
  "talouselama.fi": { j: "5" },
  "nettiauto.com": { j: "5" },
  "hartz.info": { s: "#my_privacy_policy{display:none !important}" },
  "tumblr.com": { j: "5" },
  "lions.de": { s: "#cookieInformationPopup{display:none !important}" },
  "lotty.de": { s: ".npco_overlay{display:none !important}" },
  "sonchek.com": { j: "5" },
  "tv-sport.de": { s: ".rcb-banner{display:none !important}" },
  "yunexpress.com": { s: ".Cookie-wrapper{display:none !important}" },
  "lotto.pl": { j: "5" },
  "wodka-gorbatschow.de": { s: ".legacy{display:none !important}" },
  "allianz-pro-grundgesetz.de": { s: "#cookieEu{display:none !important}" },
  "bayern.de": {
    s: '#cookie,#matomoCookieNotification,div[id^="cbanner"],#message-container.message-container{display:none !important}',
    j: "5",
  },
  "fondmarknaden.se": {
    s: "#FM-cookie-consent-modal{display:none !important}",
  },
  "asus.com": { s: "#cookieTable{display:none !important}" },
  "delfi.ee": { s: 'div[class^="C-modal"]{display:none !important}' },
  "szerencsejatek.hu": { c: 110 },
  "magazineluiza.com.br": {
    s: "main > div:nth-of-type(1){display:none !important}",
  },
  "fussballgucken.info": { j: "5" },
  "markets.com": { j: "5" },
  "lavadoo.com": { s: ".cont-cookie{display:none !important}" },
  "glose.com": {
    s: '#app > div[class*="layout-wrapper"] > div[class*="root"]{display:none !important}',
  },
  "defence24.pl": { j: "5" },
  "verisart.com": { s: ".marketing nav ~ div{display:none !important}" },
  "carbonify.eu": { j: "5" },
  "fairtrade-deutschland.de": { c: 30 },
  "autodesk.com": { j: "5" },
  "orientalmart.co.uk": { c: 0 },
  "cian.ru": {
    s: 'div[data-name="CookiesNotification"]{display:none !important}',
  },
  "busliniensuche.de": { s: "#cookieWarning{display:none !important}" },
  "hs-esslingen.de": { c: 158 },
  "vy.se": { s: ".page > section,#center > section{display:none !important}" },
  "oengus.io": { s: ".privacy-consent{display:none !important}" },
  "headspace.com": {
    s: "#gatsby-focus-wrapper > div:last-child{display:none !important}",
    j: "5",
  },
  "sundhed.dk": { s: "sdk-layout-main-cookiebox{display:none !important}" },
  "calendrier-lunaire.net": { s: "#ezcc{display:none !important}" },
  "n26.com": { j: "5" },
  "akemi.de": { s: "#tw-cookie{display:none !important}" },
  "migros-shop.de": { j: "5" },
  "messmer.de": { j: "5" },
  "arctic.de": { j: "5" },
  "iew.be": { j: "5" },
  "classiquemaispashasbeen.fr": { j: "5" },
  "cmegroup.com": { s: "#cmePermissionQuestion{display:none !important}" },
  "choice.npr.org": { j: "5" },
  "biathlonworld.com": { j: "5" },
  "havahart.com": { s: "#gdpr-announcement{display:none !important}" },
  "buscojobs.com.uy": { s: 'div[class*="Cookies"]{display:none !important}' },
  "zesty.tech": { s: ".cc-window{display:none !important}" },
  "mercedes-benz-trucks.com": { j: "5" },
  "muenchen.de": { c: 2, j: "5" },
  "zusammen.de": { j: "5" },
  "energieatlas.eon.de": { j: "5" },
  "yle.fi": { j: "5" },
  "webscale.fi": { j: "5" },
  "nseguros.pt": { j: "5" },
  "cuevana3.io": { s: "#mdl-ads{display:none !important}" },
  "dovizborsa.com": {
    s: '#tools > div[style*="bottom"]{display:none !important}',
  },
  "dogedash.com": { j: "5" },
  "dreame.com": { s: ".drawer-wrapper{display:none !important}" },
  "justwatch.com": { j: "5" },
  "groovy.bot": { s: "#__layout > div > .bottom-0{display:none !important}" },
  "hydra.bot": { s: "#__layout > div > .bottom-0{display:none !important}" },
  "dagsavisen.no": { s: "#consent-container{display:none !important}" },
  "skysports.com": { j: "5" },
  "macupdate.com": { s: ".mu_cookie{display:none !important}" },
  "beamtic.com": { c: 9 },
  "llbean.com": { s: ".user-consent{display:none !important}" },
  "nordax.no": { j: "5" },
  "nordax.de": { j: "5" },
  "euromoney.com": { s: ".CookiePromo{display:none !important}" },
  "robotiq.ai": { s: "#cookie-cont{display:none !important}" },
  "rueducommerce.fr": { j: "5" },
  "smdv.de": { j: "5" },
  "digitalo.de": { j: "5" },
  "voelkner.de": { j: "5" },
  "getgoods.com": { j: "5" },
  "acquire.io": { s: ".home-announcement{display:none !important}" },
  "joom.com": {
    s: '#content > div[class*="container"]{display:none !important}',
  },
  "warszawa.pl": { j: "5" },
  "vod.warszawa.pl": { s: "#footer ~ div{display:none !important}" },
  "vapiano.warszawa.pl": { s: "#shark-cookie{display:none !important}" },
  "denley.pl": {
    s: "#dialog_cover,.dialog_wrapper_cookie{display:none !important}",
  },
  "fotopuzzle.de": { j: "5" },
  "monpuzzlephoto.fr": { j: "5" },
  "cazoo.com": {
    s: 'div[data-test-id="banner-wrapper-with-blocker"]{display:none !important}',
  },
  "cazoo.co.uk": {
    s: 'div[data-test-id="banner-wrapper-with-blocker"]{display:none !important}',
  },
  "naturgenussfestival.de": { c: 8 },
  "zehnthof-weickert.de": { s: "#agever{display:none !important}" },
  "volbers.com": { s: "#agever{display:none !important}" },
  "mhra.gov.uk": {
    s: "#__next > button,#__next > aside{display:none !important}",
  },
  "elvah.de": { j: "5" },
  "gold.de": { j: "5" },
  "goldpreis.de": { j: "5" },
  "formel-sammlung.de": { j: "5" },
  "silber.de": { j: "5" },
  "apksmods.com": { j: "5" },
  "radiomuseum.org": { j: "5" },
  "scm-shop.de": { j: "5" },
  "tourist-online.de": { s: ".cookieHintExtended{display:none !important}" },
  "freixenet-onlineshop.de": { j: "5" },
  "cornertrader.ch": { s: "#disclaimer-alert{display:none !important}" },
  "vaillant.de": { j: "5" },
  "engie.be": { s: ".modal.cookie-consent{display:none !important}" },
  "engie.com": { s: ".nj__cookies-politic{display:none !important}" },
  "tomtom.com": { j: "5" },
  "pathe-thuis.nl": { j: "5" },
  "zentica-global.com": { s: ".gdpr-settings{display:none !important}" },
  "clevertronic.de": { s: "#js-popup-cookie-block{display:none !important}" },
  "iqair.com": { j: "5" },
  "webcatalog.io": { s: "#___gatsby footer ~ .fixed{display:none !important}" },
  "tango.me": { s: "#root > div + div:last-child{display:none !important}" },
  "toscana.it": {
    s: "#epic_cookie,#cookPol,#banner-overlay-top-page,#myCookie{display:none !important}",
  },
  "accessosicuro.rete.toscana.it": { j: "5" },
  "windev.com": { j: "5" },
  "sw-greifswald.de": { s: ".swCookie{display:none !important}" },
  "broadbandspeedtest.org.uk": { s: ".cm-wrapper{display:none !important}" },
  "loveholidays.com": { s: ".c-o--{display:none !important}" },
  "reinigungsberater.de": { s: "#cCoverlay,#cC{display:none !important}" },
  "turnoffthelights.com": { c: 164 },
  "monster-soluce.com": { s: "#cookies-pop{display:none !important}" },
  "bobshop.com": { s: ".ccm-root{display:none !important}" },
  "buecher.de": { c: 165 },
  "nur-positive-nachrichten.de": { c: 165 },
  "nunido.de": { c: 165 },
  "buecher-sale.de": { c: 165 },
  "bintec-elmeg.com": { j: "5" },
  "facebookcareers.com": { j: "5" },
  "joox.com": { j: "5" },
  "tablesgenerator.com": { s: ".consent-dialog{display:none !important}" },
  "hotellhudik.se": {
    s: "#mb_modules_popups_Container{display:none !important}",
  },
  "bankinter.com": {
    j: "5",
    s: "#capabkpolicyInicial{display:none !important}",
  },
  "heilsteinwelt.de": { j: "5" },
  "elektroversand-schmidt.de": { j: "5" },
  "optikplus.de": { j: "5" },
  "heldenlounge.de": { j: "5" },
  "wissenschaft-shop.de": { j: "5" },
  "lignoshop.de": {
    s: "#cookieNote{display:none !important}",
    c: 14,
  },
  "hoyer.de": {
    s: '#___gatsby [class*="module--backdrop"]{display:none !important}',
  },
  "eko-motorwear.com": { j: "5" },
  "pd.it": { j: "5" },
  "moonpay.com": {
    j: "5",
    s: '#root > .flex[style*="min-height"] > div[class*="sm:max"]:first-child:not(:only-child){display:none !important}',
  },
  "planeo.de": { j: "5" },
  "koerbchen.app": {
    s: "body > flt-glass-pane > flt-scene-host > flt-scene > flt-transform > flt-clip{display:none !important}",
  },
  "zoobasel.ch": { j: "5" },
  "riseofgunpla.com": { c: 5 },
  "speicherkarten.guru": { s: "#GDPR{display:none !important}" },
  "memorycard.guru": { s: "#GDPR{display:none !important}" },
  "grills.de": { j: "5" },
  "ekoplaza.nl": { j: "5" },
  "epoha.com.hr": { c: 5 },
  "posta.si": {
    s: "#cookieModals,tn-theme-posta-cookie{display:none !important}",
    c: 14,
  },
  "klaus-grillt.de": { s: "body > [data-bg]{display:none !important}" },
  "promobricks.de": { s: "body > [data-bg]{display:none !important}" },
  "aktieninvestor.net": { s: "body > [data-bg]{display:none !important}" },
  "nilohealth.com": {
    s: '.page-container > [style*="fixed"]{display:none !important}',
  },
  "tvo.fi": { s: "#tietosuojainfo{display:none !important}" },
  "rednet.ag": { s: "#es_cookie_solution{display:none !important}" },
  "koupelny-dlazba.cz": { j: "5" },
  "datanyze.com": { s: "dn-drc-cmn-cookie-pop-up{display:none !important}" },
  "campingtrend.nl": { j: "5" },
  "modelle-hamburg.de": { j: "6" },
  "vuecinemas.nl": { s: ".privacy-consent-info-cta{display:none !important}" },
  "boutique.aero": { s: ".gdprModal{display:none !important}" },
  "mobile.de": { s: "#mde-consent-modal-container{display:none !important}" },
  "starjack.at": { j: "5" },
  "jobs.cz": { j: "5" },
  "prace.cz": { j: "5" },
  "readspeaker.com": { j: "5" },
  "proximus.be": { j: "5" },
  "concursolutions.com": { j: "5" },
  "tripit.com": { j: "5" },
  "formula1.com": { j: "5" },
  "techstores.gr": { s: "#cookie-consent-content{display:none !important}" },
  "sass-projects.info": { j: "5" },
  "transferxl.com": { j: "5" },
  "lvsas.sk": { c: 0 },
  "tally-weijl.com": { s: ".cookie,.overlay{display:none !important}" },
  "jak.se": { s: ".consent-backdrop{display:none !important}" },
  "endlessdungeon.game": { c: 0 },
  "swissborg.com": { s: "#main ~ div{display:none !important}" },
  "brak.de": { c: 84 },
  "eventwide.com": {
    s: ".privacy-blanket,.privacy-dialog{display:none !important}",
  },
  "zu-zweit.de": { c: 39 },
  "label2020.eu": { c: 14 },
  "songsterr.com": { j: "5" },
  "pentaxforum.nl": { j: "5" },
  "kibercar.com": { s: ".kbc_cookie{display:none !important}" },
  "sportfondsen.nl": { j: "5" },
  "peek-cloppenburg.at": { j: "5" },
  "peek-cloppenburg.de": { j: "5" },
  "peek-cloppenburg.nl": { j: "5" },
  "peek-cloppenburg.pl": { j: "5" },
  "fashionid.de": { j: "5" },
  "ansons.de": { j: "5" },
  "chartoo.de": { j: "5" },
  "chartoo.fr": { j: "5" },
  "chartoo.at": { j: "5" },
  "chartoo.ch": { j: "5" },
  "chartoo.co.uk": { j: "5" },
  "chartoo.in": { j: "5" },
  "chartoo.com": { j: "5" },
  "sofatutor.com": { j: "5" },
  "sofatutor.ch": { j: "5" },
  "sofatutor.at": { j: "5" },
  "alternate.de": { j: "5" },
  "vsv.be": { j: "5" },
  "umicore.com": { j: "5" },
  "rodekruis.be": { j: "5" },
  "veiligverkeer.be": { j: "5" },
  "workshopsveiligverkeer.be": { j: "5" },
  "vias.be": { j: "5" },
  "united-domains.de": { j: "5" },
  "reshade.me": { j: "5" },
  "nordcheckout.com": {
    s: "#__next > div > .text-grey-darker{display:none !important}",
  },
  "cirkwi.com": { s: ".mb_popin{display:none !important}" },
  "omsystembolaget.se": { s: ".consent-handler{display:none !important}" },
  "covidbevis.se": { s: ".v-system-bar{display:none !important}" },
  "1881.no": { s: ".adn-window,#ot-consent{display:none !important}" },
  "123-fluessiggas.de": { j: "5" },
  "portu.cz": { s: "#cookiescontent{display:none !important}" },
  "figma.com": { j: "5" },
  "favi.cz": { j: "5" },
  "techland.net": { s: "#gdpr-consent-form{display:none !important}" },
  "yum-audio.com": { j: "5" },
  "rc-xpress.com": {
    s: '.notification[data-options*="Privacy"]{display:none !important}',
  },
  "pneuhage.de": { s: ".site-blocker{display:none !important}" },
  "yachtclubgames.com": { c: 2 },
  "bijourama.com": { j: "5" },
  "grueneerde.com": { j: "5" },
  "skousen.dk": { j: "5" },
  "skousen.no": { j: "5" },
  "whiteaway.com": { j: "5" },
  "whiteaway.no": { j: "5" },
  "whiteaway.se": { j: "5" },
  "bacelic.hr": { c: 0 },
  "aurumcars.de": { j: "5" },
  "casinocosmopol.se": { s: "#casino-picker-modal{display:none !important}" },
  "netvibes.com": { j: "5" },
  "thesting.com": { j: "5" },
  "delicasaitalia-uk.com": { c: 60 },
  "uk.barclays": { s: ".barclays-consent{display:none !important}" },
  "truecaller.com": {
    s: '#app > .fixed[class*="bottom"]{display:none !important}',
  },
  "rsu.de": { j: "5" },
  "rp-online.de": { j: "5" },
  "arbetsformedlingen.se": { s: ".af-cookie{display:none !important}" },
  "lecoqsportif.com": {
    s: 'div[class*="cookiesPopup"]{display:none !important}',
  },
  "smashbros.com": { j: "5" },
  "sodresantoro.com.br": { s: ".ss-modal-cookies{display:none !important}" },
  "top-car-hire.com": { c: 0 },
  "munzinger.de": { j: "5" },
  "rs-online.com": { s: 'body[style*="margin-top"]{margin-top:0 !important}' },
  "foxracingshox.de": { j: "5" },
  "idoc.eu": { j: "5" },
  "skylinewebcams.com": { s: "#pref{display:none !important}" },
  "cofan.es": { s: ".block-cookies{display:none !important}" },
  "autohero.com": { j: "5" },
  "banknorwegian.de": { j: "5" },
  "passeidireto.com": { s: "pd-cookie-banner{display:none !important}" },
  "mp.cz": { j: "5" },
  "workwise.io": { j: "5" },
  "isc2.org": { s: ".notice--warning{display:none !important}" },
  "ebox-auto.com": { s: ".rgpd{display:none !important}" },
  "tylko.com": { s: ".ty-settings{display:none !important}" },
  "ma-calculatrice.fr": {
    s: "#manger-des-minis-gateaux{display:none !important}",
  },
  "halleysac.it": { j: "5" },
  "arbiton.com": { c: 0 },
  "audisto.com": { j: "5" },
  "contentkingapp.com": { j: "5" },
  "elopage.com": { j: "6", s: ".Toastify ~ .elo-btn{display:none !important}" },
  "gartenbaumschule-becker.de": { j: "5" },
  "deutsche-bank.es": { c: 59 },
  "dbschenker.com": { j: "5" },
  "northernpowergrid.com": {
    j: "5",
    s: "header > .ch2-icon{display:none !important}",
  },
  "hunqz.com": { j: "5" },
  "6play.fr": {
    j: "5",
    s: 'body[style*="hidden"]{overflow:visible !important}body[style*="hidden"] > div[tabindex]{display:none !important}',
  },
  "competitions.be": { j: "5" },
  "smartdroid.de": { j: "5" },
  "webfail.com": { j: "5" },
  "norcamp.de": { s: "#cookieCD{display:none !important}" },
  "banneke.com": { s: "#cookie-block{display:none !important}" },
  "kennisopenbaarbestuur.nl": {
    s: ".jqmConfirm,#cookieStatus{display:none !important}",
  },
  "buywholefoodsonline.co.uk": { j: "5" },
  "shirtlabor.de": { j: "5" },
  "bit-electronix.eu": { j: "5" },
  "berndes.com": { j: "5" },
  "steingemachtes.de": { j: "5" },
  "moebel-fundgrube.de": { j: "5" },
  "wuerdinger.de": { j: "5" },
  "fafit24.de": { j: "5" },
  "thiele-tee.de": { j: "5" },
  "bishopfox.com": { s: "body > div[x-data]{display:none !important}" },
  "carvago.com": {
    s: 'div[data-test-id="CookieBar-content"]{display:none !important}',
  },
  "crew-united.com": { s: ".opt-action-bar{display:none !important}" },
  "mein-gartenshop24.de": { j: "5" },
  "energie-und-management.de": {
    s: "#trackingConsent,#trackingConsentReminder{display:none !important}",
  },
  "schnelle-online.info": {
    s: ".cookiebanneraktiv .modal{display:none !important}",
  },
  "dmsg.de": { j: "5" },
  "hsga-gmbh.de": { j: "5" },
  "berlingske.dk": { j: "5" },
  "beinsports.com.tr": {
    s: '#__next > [class*="cookie"]{display:none !important}',
  },
  "aquacard.co.uk": { j: "5" },
  "briloner.com": { j: "5" },
  "petsathome.com": { s: ".onetrust{display:none !important}" },
  "e-podroznik.pl": { s: ".ep-cookies-info-wrapper{display:none !important}" },
  "duschmeister.de": {
    s: ".dm--cookie-consent-banner{display:none !important}",
  },
  "ichbindeinauto.de": { j: "5" },
  "ae.com": { s: 'div[class*="snackbar-container"]{display:none !important}' },
  "wiking.de": { s: "#nagme{display:none !important}" },
  "befunky.com": { s: ".toast--bottom-left{display:none !important}" },
  "nabytek-aldo.cz": { c: 166 },
  "kox-direct.de": { s: "#wsModalAgreementPrivacy{display:none !important}" },
  "box.gr": { s: "box-cookies{display:none !important}" },
  "flickr.com": { s: ".cookie-banner-reg{display:none !important}" },
  "wnp.pl": { j: "5" },
  "weingut-meintzinger.de": { s: "#agever{display:none !important}" },
  "dhlglobalmail.com": { j: "5" },
  "mol.hu": { j: "5" },
  "wins.pl": { j: "5" },
  "reidl.de": { j: "5" },
  "mifcom.de": { j: "5" },
  "mifcom.ch": { j: "5" },
  "postimees.ee": { j: "5" },
  "grdf.fr": { s: "#ckieBnr_banner{display:none !important}" },
  "st1.com": { s: ".cookie-consent-modal,.backdrop{display:none !important}" },
  "st1.se": { s: ".cookie-consent-modal,.backdrop{display:none !important}" },
  "st1.fi": {
    s: ".cookie-consent-modal,.backdrop{display:none !important}",
    j: "5",
  },
  "beincrypto.com": { s: "#amp-user-notification1{display:none !important}" },
  "edifier.com": { c: 0 },
  "onlyoffice.com": {
    s: '#portal div[class*="snackbar"]{display:none !important}',
  },
  "cheaptickets.ch": { j: "5" },
  "torrossa.com": { j: "5" },
  "iupp.com.br": { j: "5" },
  "materielelectrique.com": { j: "5" },
  "banggood.com": {
    s: ".modal-cookie,.bg_gdpr_popup{display:none !important}",
  },
  "dashlane.com": { s: ".privacy-consent-enter-done{display:none !important}" },
  "general-overnight.com": { s: ".cookie-layer{display:none !important}" },
  "bnn.de": { j: "5" },
  "bnn.in.th": { s: ".the-pdpa-consent-bar{display:none !important}" },
  "gouv.fr": {
    s: 'app-cookies-button,ensap-cookies,#cookieLab,header[class^="ants"] + div > div > div + div:last-child,app-cookie,app-core ~ [class*="gdpr_consent"],.eu-popup,dd1pnds-ng-bandeau{display:none !important}',
  },
  "moncompteformation.gouv.fr": { j: "5" },
  "ants.gouv.fr": { j: "3" },
  "moncompte.ants.gouv.fr": { s: ".info-ban{display:none !important}" },
  "tommy.com": { j: "5", c: 2 },
  "prostata-hilfe-deutschland.de": {
    s: "#ccModal{display:none !important}",
    c: 14,
  },
  "energiauutiset.fi": { s: ".ltcn{display:none !important}" },
  "uphold.com": { j: "3" },
  "internxt.com": {
    s: 'div[class*="cookiesBgFallback"]{display:none !important}',
  },
  "sportland-erlangen.de": {
    s: ".cookieflag,.cookieset{display:none !important}",
  },
  "curve.com": {
    s: "#gatsby-focus-wrapper > div:first-child{display:none !important}",
  },
  "uol.com.br": {
    s: ".ntv-lgpd-consent,.ms-footer-message,app-opt-in,#lgpd-ps-banner,.m1-footer-messages{display:none !important}",
  },
  "kauf-unique.de": { s: "#vu_consent{display:none !important}" },
  "discoup.com": { s: ".ch2{display:none !important}" },
  "burton.co.uk": { j: "5" },
  "dorothyperkins.com": { j: "5" },
  "sas.sk": { s: ".cookiesTextOutter{display:none !important}" },
  "howrse.de": { s: ".cmpoverlay{display:none !important}" },
  "howrse.com": { s: ".cmpoverlay{display:none !important}" },
  "meo.de": { j: "5" },
  "bridgestone.com.br": { j: "5" },
  "bridgestonesports.bridgestone.com.br": {
    s: ".modalContainer{display:none !important}",
  },
  "spilger.de": { j: "5" },
  "vg.no": { s: ".schibsted-data-controller{display:none !important}" },
  "youinvest.co.uk": { c: 20 },
  "dbfakt.de": { j: "5" },
  "modellbau-metz.com": { j: "5" },
  "huss-licht-ton.de": { j: "5" },
  "d-power-modellbau.com": { j: "5" },
  "der-druckerprofi.de": { j: "5" },
  "odenserundt.dk": { j: "5" },
  "iol.co.za": { c: 28 },
  "census.gov.scot": { s: ".below-cookie-bar{top:auto !important}" },
  "educhel.ru": { j: "5" },
  "eduface.ru": { j: "5" },
  "riverisland.com": { j: "5" },
  "edumsko.ru": { j: "5" },
  "armegoszto.hu": { s: ".v-snack--bottom{display:none !important}" },
  "rekonise.com": { s: ".consent-snackbar{display:none !important}" },
  "romeo.com": { j: "5" },
  "myoffice.ru": { c: 0 },
  "opensource.google": { c: 32 },
  "hsfo.dk": { j: "5" },
  "jobware.de": { j: "5" },
  "flintshire.gov.uk": { s: ".fcc-cookie-consent{display:none !important}" },
  "myunidays.com": { j: "5", c: 15 },
  "vista.com": {
    s: 'div[class*="footerNotificationWrapper"]{display:none !important}',
  },
  "alexia.fr": { s: "#_cc_a,._cc_op::before{display:none !important}" },
  "kingscross.co.uk": { s: ".argent_cookies{display:none !important}" },
  "omaolo.fi": { j: "5" },
  "careconord-pieces-occasion.fr": {
    s: "#choc-banner-dialog{display:none !important}",
  },
  "denbypottery.com": { j: "5" },
  "cdu-fraktion.berlin.de": { j: "5" },
  "payberry.ru": { s: ".noun-cookie-container{display:none !important}" },
  "hgk.hr": { s: ".cookie-options-container{display:none !important}" },
  "jeftinastruja.hr": { c: 2 },
  "wallhere.com": { s: ".policy-info{display:none !important}" },
  "inselfaehre.de": { j: "5" },
  "gemini.pl": { j: "5" },
  "ecosys.net": { j: "5" },
  "trade.bisonapp.com": { c: 146 },
  "eternit.at": { j: "5" },
  "eleventickets.com": {
    s: ".cookies-aceite-home-container{display:none !important}",
  },
  "eventail.be": {
    s: '#__next > div > div[style*="transform"]{display:none !important}',
  },
  "uhpa.hr": { c: 112 },
  "hansapark.de": { j: "5" },
  "sslmarket.de": { c: 166 },
  "open.pl": { c: 2 },
  "femina.in": { s: ".blocked{display:none !important}" },
  "hackensackmeridianhealth.org": {
    s: ".privacy-warning{display:none !important}",
  },
  "eledo.online": { s: "#CookiesConsentDialog{display:none !important}" },
  "odrabiamy.pl": { s: '.Toastify ~ [class*="Rodo"]{display:none !important}' },
  "wakfu.com": {
    s: ".ak-modal-wrapper,.ui-widget-overlay{display:none !important}",
  },
  "girlfriend.com": { s: "main ~ .grid{display:none !important}" },
  "metzler.com": { j: "5" },
  "domni.pl": { s: "aside[data-cookie-remind]{display:none !important}" },
  "meinegirokarte.de": {
    s: "#modalBackground,#modalCookieAcceptance{display:none !important}",
  },
  "vimpay.eu": {
    s: "#modalBackground,#modalCookieAcceptance{display:none !important}",
  },
  "bbc.com": {
    j: "5",
    s: '#main-wrapper > header[role="banner"] > div:first-child{display:none !important}',
  },
  "bbcrussian.com": {
    s: '#main-wrapper > header[role="banner"] > div:first-child{display:none !important}',
  },
  "wilanow-palac.pl": { c: 0 },
  "bat.com": { c: 17 },
  "soliver.de": { j: "5" },
  "soliver.at": { j: "5" },
  "soliver.nl": { j: "5" },
  "soliver.eu": { j: "5" },
  "soliver.ch": { j: "5" },
  "soliver.fr": { j: "5" },
  "soliver.si": { j: "5" },
  "soliver.cz": { j: "5" },
  "soliver.sk": { j: "5" },
  "soliver.hr": { j: "5" },
  "soliver-online.be": { j: "5" },
  "mnb.hu": { s: ".cb01-cookie-bar{display:none !important}" },
  "canalplus.com": { j: "5" },
  "final-materials.com": { j: "5" },
  "advancedinstaller.com": { c: 0 },
  "mysteriumvpn.com": { s: ".alert-popup{display:none !important}" },
  "vsgamers.es": { s: "#vs-cookies-policy{display:none !important}" },
  "postovnezdarma.cz": { j: "5" },
  "lequipe.fr": {
    j: "5",
    s: ".Alerts__item--nonBlockingAlert{display:none !important}",
  },
  "creality3dofficial.com": { s: ".pub-tip{display:none !important}" },
  "creality3dofficial.eu": { s: ".pub-tip{display:none !important}" },
  "easyparts-rollerteile.de": { j: "5" },
  "christopeit-sport.com": { j: "5" },
  "baer-schuhe.de": { j: "5" },
  "baer-shoes.com": { j: "5" },
  "swisse.nl": { j: "5" },
  "xn--90aivcdt6dxbc.xn--p1ai": {
    s: ".l-modal-cookie{display:none !important}",
  },
  "amplerbikes.com": { j: "5" },
  "pribram.cz": { c: 0 },
  "money.com.tr": { s: ".kvkk{display:none !important}" },
  "bintercanarias.com": { j: "5" },
  "24sata.hr": { s: "#didomi-host{display:none !important}" },
  "njuskalo.hr": { s: "#didomi-host{display:none !important}" },
  "huffingtonpost.es": { s: "#acceptationCMPWall{display:none !important}" },
  "independent.ie": {
    s: '#didomi-host,a[onclick*="Didomi.preferences"]{display:none !important}',
  },
  "programme-tv.net": { j: "5" },
  "bike-bild.de": { j: "5" },
  "cosmopolitan.de": { j: "5" },
  "golem.de": { j: "5" },
  "bold.dk": { j: "5" },
  "dell-xps.chip.de": { j: "5" },
  "i-de.es": {
    s: ".backdropCookies,.backdropCookies + div{display:none !important}",
  },
  "relago.hr": { s: "body > .container{display:none !important}" },
  "bgk.pl": { j: "5" },
  "wentronic.com": { j: "5" },
  "wentronic.pl": { j: "5" },
  "notion.so": {
    s: '#__next > section[class*="partial"]{display:none !important}',
    j: "5",
  },
  "notion.site": { j: "5" },
  "abercrombie.com": {
    s: '.flash-message[data-flash-message-group-id*="cookie-accept"]{display:none !important}',
  },
  "wolframalpha.com": {
    s: "#__next > div > section:last-of-type{display:none !important}",
  },
  "blukit.com.br": { j: "5" },
  "informator.ua": { c: 153 },
  "bund.de": { j: "5", s: "#bfr-cookielaw,.datahint{display:none !important}" },
  "sachsenenergie.de": { j: "6" },
  "wpengine.com": { s: ".opt-in-modal{display:none !important}" },
  "emojikopieren.de": { j: "5" },
  "tropicfeel.com": { j: "5" },
  "lacinetek.com": { s: "#overlay-privacy-policy{display:none !important}" },
  "konsument.at": { j: "5" },
  "clark.center": { s: "clark-cookies{display:none !important}" },
  "royaldesign.de": {
    s: "#root > div:last-child:not(:only-child){display:none !important}",
  },
  "hama.sk": { s: ".cookiesmanager{display:none !important}" },
  "bistum-essen.de": { c: 30 },
  "elcorteingles.es": { j: "5", c: 72 },
  "elcorteingles.com": { c: 72 },
  "elcorteingles.pt": { c: 72 },
  "hipercor.es": { c: 72 },
  "latiendaencasa.es": { c: 72 },
  "sfera.com": { s: "#dis_cookie.cab_cookies{display:none !important}" },
  "raildude.com": { j: "5" },
  "banbye.com": { j: "5" },
  "socradar.io": {
    s: "#modal-cookies{display:none !important}",
    c: 14,
  },
  "bkkgs.de": { s: ".cookie-layer{display:none !important}" },
  "al.to": { j: "5" },
  "mresell.at": { c: 61 },
  "mresell.de": { c: 61 },
  "mresell.es": { c: 61 },
  "mresell.fi": { c: 61 },
  "mresell.it": { c: 61 },
  "mresell.nl": { c: 61 },
  "mresell.se": { c: 61 },
  "mresell.co.uk": { c: 61 },
  "mresell.com.au": { c: 61 },
  "tu-darmstadt.de": { j: "5" },
  "tu-onlinedays.tu-darmstadt.de": { c: 146 },
  "flane.de": { s: ".nagmsg{display:none !important}" },
  "allianz.fr": { j: "5" },
  "caraudioshop.nl": { s: ".gmt_consent_popup{display:none !important}" },
  "toolstation.nl": { j: "5" },
  "toolstation.fr": { j: "5" },
  "toolstation.be": { j: "5" },
  "ti.com": { s: "#tiGDPRecModal{display:none !important}" },
  "telenor.se": { j: "5" },
  "uber.com": { s: 'body > [data-baseweb="toaster"]{display:none !important}' },
  "cliveemson.co.uk": { s: "#cookie-consent-form{display:none !important}" },
  "ranzijn.nl": { s: "#app > .fixed{display:none !important}" },
  "pch.com": { s: "#__tealiumDNS_banner{display:none !important}" },
  "picarto.tv": {
    s: 'div[class*="CookieCompliance"]{display:none !important}',
  },
  "cilgro.nl": { j: "5" },
  "landuwasco.nl": { j: "5" },
  "france24.com": { j: "5" },
  "franceinter.fr": { j: "5" },
  "pro.free.fr": { j: "5" },
  "abc.es": { j: "5" },
  "hoy.es": { j: "5" },
  "diariosur.es": { j: "5" },
  "elcorreo.com": { j: "5" },
  "surinenglish.com": { j: "5" },
  "eldiariomontanes.es": { j: "5" },
  "canarias7.es": { j: "5" },
  "elcomercio.es": { j: "5" },
  "getaround.com": { j: "5" },
  "wp.pl": { j: "5" },
  "classicube.net": { j: "5" },
  "basic-tutorials.de": {
    c: 1,
    s: "#cookiescript_injected_wrapper{display:none !important}",
  },
  "goodie.pl": {
    s: "#main-container > div > footer ~ div[class]{display:none !important}",
  },
  "wit.ai": { j: "5" },
  "pravda.ru": { c: 112 },
  "pravda.com.ua": { s: "#checkUPcookies{display:none !important}" },
  "decathlon.com.br": { s: ".cookie-policies{display:none !important}" },
  "check24.net": { j: "5" },
  "tarifcheck.de": { j: "5" },
  "affiliate-deals.de": { j: "5" },
  "sudoku-knacker.de": { s: ".v-bottom-sheet{display:none !important}" },
  "medicalseeds.cz": { s: ".cookieForward{display:none !important}" },
  "autodily-pema.cz": { j: "5" },
  "gov.br": {
    s: "#lgpd-cookie-banner-janela,#politicaPrivacidade,.br-cookiebar{display:none !important}",
  },
  "chargemyhyundai.com": { j: "5" },
  "kiacharge.com": { j: "5" },
  "easystempel.de": {
    s: "#cookie-modern-overlay,#cookie-modern-info{display:none !important}",
  },
  "mapquest.com": { j: "5" },
  "mapquest.co.uk": { j: "5" },
  "vulco.hr": { c: 2 },
  "vulco.es": { j: "5" },
  "eiendomspriser.no": { s: ".adn-window{display:none !important}" },
  "trenes.com": { j: "5" },
  "uhrzeit123.de": { j: "5" },
  "daiichisankyo.com": { s: "#cookieLicense{display:none !important}" },
  "buyon.it": { s: ".cc_placeholder{display:none !important}" },
  "medizinfuchs.de": { s: ".ConsentHint{display:none !important}" },
  "medizinfuchs.at": { s: ".ConsentHint{display:none !important}" },
  "timesnownews.com": {
    s: 'div[class*="GdprCSS-container"]{display:none !important}',
  },
  "interred.de": { s: "#cookieconsentmodal{display:none !important}" },
  "allgeier-it.de": {
    s: "#cookieconsentmodal{display:none !important}",
    c: 14,
  },
  "warthunder.com": { s: ".wt-cb{display:none !important}" },
  "lekarna-bella.cz": {
    j: "5",
    s: ".cookie-settings{display:none !important}",
  },
  "kastner-oehler.at": { j: "5" },
  "kastner-oehler.ch": { j: "5" },
  "kastner-oehler.de": { j: "5" },
  "gigasport.at": { j: "5" },
  "gigasport.ch": { j: "5" },
  "gigasport.de": { j: "5" },
  "fuehrerschein-bestehen.de": { j: "5" },
  "stapler.de": { j: "5" },
  "surveytandem.com": { j: "5" },
  "exagon.de": { j: "5" },
  "laboconnect.com": { j: "5" },
  "eduki.com": { j: "5" },
  "united-camera.at": { j: "5" },
  "weserbergland-tourismus.de": { j: "5" },
  "electroholic.gr": {
    s: ".footer ~ .ng-star-inserted{display:none !important}",
  },
  "privanet35.com": { j: "5" },
  "ford.de": { s: ".gdpr-visibility-on{display:none !important}" },
  "metacareers.com": { j: "5" },
  "meteostat.net": { j: "5" },
  "tempton.de": { s: 'div[class*="ConsentBanner"]{display:none !important}' },
  "vtelevizi.cz": { s: "#CCM_popup{display:none !important}" },
  "midwestgunworks.com": { s: "#privBanner{display:none !important}" },
  "stromnetz.berlin": { j: "5" },
  "vattenfall.com": { j: "5" },
  "zilek.com": { j: "5" },
  "bauhaus.se": { j: "5" },
  "bauhaus.no": { j: "5" },
  "bauhaus.cz": { j: "5" },
  "writerduet.com": {
    s: '#root > div > div[style*="fixed"],#cookie-law{display:none !important}',
  },
  "toppy.nl": { j: "5" },
  "armedangels.com": { j: "5" },
  "finom.co": { j: "5" },
  "allegro.pl": { j: "5" },
  "threshold.ie": { j: "5" },
  "dolarhoje.com": { s: "#privacy-warning{display:none !important}" },
  "lannebo.se": { s: ".lannebo-cookiebot{display:none !important}" },
  "musti.no": { j: "5" },
  "vetzoo.se": { j: "5" },
  "animail.se": { j: "5" },
  "arkenzoo.se": { j: "5" },
  "mustijamirri.fi": { j: "5" },
  "petenkoiratarvike.com": { j: "5" },
  "echirurgia.pl": { j: "5" },
  "jambit.com": { s: ".js-global-privacy{display:none !important}" },
  "start.canon": { j: "5" },
  "1001mobiles.fr": { s: "#cookiediv{display:none !important}" },
  "mirrormedia.mg": { s: ".the-gdpr{display:none !important}" },
  "mymuesli.com": { j: "5" },
  "dfwairport.com": { j: "5" },
  "snowthority.com": { j: "5" },
  "panodyssey.com": {
    s: "#rgpdbox{display:none !important}",
    c: 14,
  },
  "top-highlights.gr": { s: "#notificationsBox{display:none !important}" },
  "matador-diervoeders.be": {
    s: "footer ~ .container{display:none !important}",
  },
  "matador-diervoeders.com": {
    s: "footer ~ .container{display:none !important}",
  },
  "energetyka24.com": { j: "5" },
  "deployhq.com": { s: ".crumbs-banner{display:none !important}" },
  "paysend.com": { j: "5" },
  "goyabu.vip": { c: 8 },
  "ria.com": {
    s: "#gdpr_settings ~ .c-notifier-container{display:none !important}",
  },
  "begadi.com": { s: ".cookie-footer{display:none !important}" },
  "dosenbach.ch": { j: "5" },
  "thomas-krenn.com": { j: "5" },
  "bookmygarage.com": { j: "5" },
  "fedex.com": {
    s: "fedex-cookie-consent,fdx-caas-cookie-consent,.fxg-alert__fdx_cookie_notice{display:none !important}",
  },
  "kvk.nl": { j: "5" },
  "hostnet.nl": { j: "5" },
  "tiktok.com": { s: "tiktok-cookie-banner{display:none !important}" },
  "shopee.fr": {
    s: ".shopee-progress-bar ~ div:not([class]):not([id]) + div[class]:not([id]){display:none !important}",
  },
  "shopee.pl": {
    s: ".shopee-progress-bar ~ div:not([class]):not([id]) + div[class]:not([id]){display:none !important}",
  },
  "shopee.es": {
    s: ".shopee-progress-bar ~ div:not([class]):not([id]) + div[class]:not([id]){display:none !important}",
  },
  "nrk.no": {
    s: ".nrk-masthead__info-banner--cookie{display:none !important}",
  },
  "valasztas.hu": { s: "footer ~ .position-fixed{display:none !important}" },
  "olx.pl": { j: "5" },
  "opendemocracy.net": { j: "5" },
  "nelipyora.fi": { s: ".gw-cookie-consent{display:none !important}" },
  "bankenverband.de": { s: ".cookies-floating{display:none !important}" },
  "nationalgallery.co.uk": { j: "5" },
  "websupport.se": { s: ".b-toaster{display:none !important}" },
  "websupport.sk": { s: ".b-toaster{display:none !important}" },
  "shop4nl.com": { j: "5" },
  "shop4be.com": { j: "5" },
  "shop4de.com": { j: "5" },
  "shop4ch.com": { j: "5" },
  "365games.co.uk": { j: "5" },
  "ozgameshop.com": { j: "5" },
  "shop4world.com": { j: "5" },
  "shop4italia.com": { j: "5" },
  "shop4mama.nl": { j: "5" },
  "shop4tesla.com": { j: "5" },
  "timeshop4you.co.uk": { c: 0 },
  "uhren4you.de": { c: 0 },
  "horlogerie4you.fr": { c: 0 },
  "klockor4you.nu": { c: 0 },
  "orologi4you.it": { c: 0 },
  "relojes4you.es": { c: 0 },
  "squash4you.pl": { c: 0 },
  "printer-care.de": { s: ".wwwschutz_cmp_showing{display:none !important}" },
  "hifi4you.de": { c: 4 },
  "lemonde.fr": { j: "5" },
  "nouvelobs.com": { j: "5" },
  "send.cz": { s: ".cookie-ok{display:none !important}" },
  "oekolandbau.de": { j: "5" },
  "deutsches-sportabzeichen.de": { c: 84 },
  "blockchain.com": { j: "5" },
  "redhotpawn.com": { s: "#cookieConsentElId{display:none !important}" },
  "tools.se": { j: "5" },
  "escavador.com": { s: ".c-popup-consentimento{display:none !important}" },
  "vizjer.pl": { c: 0 },
  "kaartje2go.nl": { j: "5" },
  "eni.com": { s: "c-ecp-cookies-banner{display:none !important}" },
  "mathcitymap.eu": { s: "#mcm-cookie-notice{display:none !important}" },
  "10doigts.fr": { s: ".cmp-wrapper{display:none !important}" },
  "zer.gr": { s: "#emgcookie{display:none !important}" },
  "iservoetbalvanavond.nl": {
    s: "#__next > div:first-child:not(:only-child){display:none !important}",
  },
  "liberalerna.se": { s: "#ccnt-app{display:none !important}" },
  "impress.co.jp": { s: "#ipc_cookie_confirmation{display:none !important}" },
  "elkjop.no": { j: "5" },
  "mironet.cz": { j: "5" },
  "nike.com": { j: "5" },
  "deichmann.com": { j: "5" },
  "studio.benq.com": { j: "5" },
  "chase.co.uk": { j: "5" },
  "safemoon.com": { j: "5" },
  "tattoodo.com": {
    s: "#js-root > div > div:first-child:not([id]){display:none !important}",
  },
  "get-in-it.de": { j: "5" },
  "elnino-parfum.pl": { j: "5" },
  "frisonaut.de": { j: "5" },
  "sedep.com.br": { s: "#cookiesAceitar{display:none !important}" },
  "24ur.com": { j: "5" },
  "zadovoljna.si": { j: "5" },
  "connect.beinsports.com": {
    s: ".app-container > div:not(.app-content){display:none !important}",
  },
  "connect.bein.com": {
    s: ".app-container > div:not(.app-content){display:none !important}",
  },
  "bobex.be": { s: "#bbx_modal_cookie{display:none !important}" },
  "standaardboekhandel.be": { j: "5" },
  "club.be": { j: "5" },
  "economycarrentals.com": { j: "5" },
  "trading212.com": { j: "5" },
  "gns3.com": {
    s: "#oio-container > div + div + div ~ div:last-child{display:none !important}",
  },
  "continental-jobs.com": { j: "5" },
  "continental-mobility-services.com": { j: "5" },
  "haerke.de": {
    s: '#seite > div[style*="absolute"]{display:none !important}',
  },
  "riserapp.com": { s: ".Cookie{display:none !important}" },
  "webmdhealthservices.com": {
    s: ".cookiePolicyModal{display:none !important}",
  },
  "czc.cz": { j: "5" },
  "zeroscans.com": { j: "5" },
  "vertica.com": { j: "5" },
  "lovekrakow.pl": { j: "5" },
  "workspace.google.com": {
    s: "main > div:last-child:not(only-child){display:none !important}",
  },
  "business.google.com": { s: "#CookieDialog{display:none !important}" },
  "santatracker.google.com": { s: "santa-notice{display:none !important}" },
  "play.google.com": {
    s: '#gb iframe[src*="ogs.google."][src*="widget/callout"]{display:none !important}',
  },
  "io.google": { j: "5" },
  "watchpedia.com": { j: "5" },
  "truevirtualworld.com": { s: ".card-cookie{display:none !important}" },
  "punpro.com": { s: 'div[class*="CookieSession"]{display:none !important}' },
  "siamsport.co.th": { s: "#popup-ss{display:none !important}" },
  "reddit.com": {
    s: '#SHORTCUT_FOCUSABLE_DIV > div> div > section > [style*="Toaster"],shreddit-async-loader[bundlename*="cookie_banner"]{display:none !important}',
  },
  "reddit.watch": {
    s: ".v-content__wrap > .container > .align-end{display:none !important}",
  },
  "redd.it": {
    s: '#SHORTCUT_FOCUSABLE_DIV > div> div > section > [style*="Toaster"],shreddit-async-loader[bundlename*="cookie_banner"]{display:none !important}',
  },
  "pttavm.com": { c: 167 },
  "transa.ch": { c: 167 },
  "ftx.com": { j: "5" },
  "blickpunkt-lateinamerika.de": { j: "5" },
  "bynco.com": { j: "5" },
  "varcevanje-energije.si": { j: "5" },
  "neonet.pl": { s: 'div[class*="cookiesBlock"]{display:none !important}' },
  "talktalk.co.uk": { j: "5" },
  "deineapotheke.at": { j: "5" },
  "lebar.sncf.com": { j: "5" },
  "fireteam.net": { s: ".cc-container{display:none !important}" },
  "onrc.ro": { s: ".cc-container{display:none !important}" },
  "joberty.hr": { s: ".cc-container{display:none !important}" },
  "evertiq.se": { s: ".cc-box{display:none !important}" },
  "10015.io": { s: ".Toastify ~ div{display:none !important}" },
  "graphy.com": { s: ".Toastify ~ div{display:none !important}" },
  "pmdp.cz": { j: "5" },
  "sogeti.de": { j: "5" },
  "inyova.de": { j: "5" },
  "gamemaker.io": { s: "#yoyoCookie{display:none !important}" },
  "well.co.uk": { j: "5" },
  "taxfix.it": { j: "5" },
  "taxfix.de": { j: "5" },
  "portalpasazera.pl": { j: "5" },
  "wakacje.pl": { j: "5" },
  "freevpnplanet.com": { c: 0 },
  "jow.fr": { j: "5" },
  "foodetective.co": { j: "6" },
  "insidebruegel.net": { j: "6" },
  "grouperf.com": { s: "#rgpdModal{display:none !important}" },
  "danica.no": { j: "5" },
  "danskeci.com": { j: "5" },
  "danskebank.se": { j: "5" },
  "danskebank.dk": { j: "5" },
  "danskebank.no": { j: "5" },
  "danskebank.fi": { j: "5" },
  "danskebank.co.uk": { j: "5" },
  "danskebank.com": { j: "5" },
  "danicapension.dk": { j: "5" },
  "eversports.de": { j: "5" },
  "eversports.fr": { j: "5" },
  "eversports.at": { j: "5" },
  "exali.de": { j: "5" },
  "kupbilecik.pl": { j: "5" },
  "kupbilecik.de": { j: "5" },
  "kupbilecik.com": { j: "5" },
  "technikmuseum.berlin": { j: "5" },
  "bstbk.de": { j: "5" },
  "mein-grundeinkommen.de": { j: "5" },
  "whiskynet.hu": {
    s: "#__nuxt footer ~ div:not([style]){display:none !important}",
  },
  "norgesgruppen.no": { s: "#coco{display:none !important}" },
  "smakmagasinet.no": { s: "#coco{display:none !important}" },
  "naturvardsverket.se": { s: "#App > div{display:none !important}" },
  "thoracic.org": { c: 164 },
  "surplex.com": { j: "5" },
  "koh-i-noor.cz": {
    s: "#EuConsentV2{display:none !important}",
    c: 14,
  },
  "techmox.io": { j: "5" },
  "iplt20.com": { c: 2 },
  "kosmas.cz": { j: "5" },
  "mp.br": {
    s: "#termo-uso,#modalConsentimento,.lumis-service-privacyterm,.cookie-container.active{display:none !important}",
    c: 14,
  },
  "aida64.co.uk": { j: "5" },
  "odsluchane.eu": { s: ".alert-flash{display:none !important}" },
  "biomarkt.de": { s: "#CybotCookiebotDialog{display:none !important}" },
  "momenthouse.com": { j: "5" },
  "chromium.org": { c: 32 },
  "javarush.ru": { c: 6 },
  "altheaprovence.com": { j: "5" },
  "sfanytime.com": { j: "5" },
  "octopusev.com": { s: "footer ~ div{display:none !important}" },
  "ikb.at": { j: "5" },
  "tobii.com": {
    s: ".cookie-container,.cookie-modal{display:none !important}",
  },
  "kaffeemacher.ch": { j: "5" },
  "greenpeace.fr": { s: "#discreto.banner .consent{display:none !important}" },
  "greenpeace.org": {
    s: "#cookiePromptCenter{display:none !important}",
    c: 14,
  },
  "rows.com": { s: "#main ~ section{display:none !important}" },
  "fleetyards.net": { j: "5" },
  "br-automation.com": {
    s: "#siwa-cookiebar{display:none !important}",
    c: 14,
  },
  "carlin.es": { s: ".ovcookie{display:none !important}" },
  "curio.io": { s: "#__next > .fixed{display:none !important}" },
  "becteroradio.com": { s: ".policy{display:none !important}" },
  "teroradio.com": { s: ".policy{display:none !important}" },
  "komchadluek.net": { s: "#accept-cookie-footer{display:none !important}" },
  "nipa.co.th": { s: "#cookie-con-head{display:none !important}" },
  "or.th": {
    s: "#alert-policy,.cookies-pdpa,#pdpa-policy{display:none !important}",
  },
  "or.at": {
    s: "#cookie_shown,body > #coo,.cookie-consent.container{display:none !important}",
  },
  "or.jp": { s: ".l-fixedCookie-item{display:none !important}" },
  "settrade.com": { s: "#pdpa-policy{display:none !important}" },
  "starbucks.co.th": { j: "5" },
  "thaiza.com": { s: ".ck-acpt-container{display:none !important}" },
  "trendmicro.com": {
    s: ".cookie_verif,c-dcx-cookie{display:none !important}",
  },
  "tunetank.com": { s: 'div[class*="cookie_info"]{display:none !important}' },
  "petromax.de": {
    s: ".mpp-container-position-bottom-bar{display:none !important}",
  },
  "ziegert-group.com": { j: "5" },
  "uqwimax.jp": { s: "#consent-popup{display:none !important}" },
  "jus.br": { c: 0 },
  "starlingbank.com": { j: "5" },
  "tvprofil.com": { s: ".gdpr-container{display:none !important}" },
  "scb.co.th": { s: ".consent_section{display:none !important}" },
  "rapidonline.com": { j: "5" },
  "yealink.com": {
    s: ".cookie-go,.cookie-accept-style{display:none !important}",
  },
  "elsenaju.info": { j: "5" },
  "meteoblue.com": {
    j: "5",
    s: "#gdpr_consent_dialogue{display:none !important}",
  },
  "ddgfashion.rs": { c: 2 },
  "sanotechnik.com": { s: ".cookies-lightbox{display:none !important}" },
  "sanotechnik.at": { s: ".cookies-lightbox{display:none !important}" },
  "fromsmash.com": {
    s: ".cgu-cookie-overlay-shadow,app-cookie{display:none !important}",
  },
  "durchblick-durch-daten.de": { j: "5" },
  "4-72.com.co": { c: 0 },
  "pwsweather.com": {
    s: "#gatsby-focus-wrapper > div > div + div:last-child{display:none !important}",
  },
  "ezil.me": { j: "5" },
  "rollomeister.de": { s: ".cookie__consent{display:none !important}" },
  "sinalco.de": { s: "#bccs-modal ~ .modal-backdrop{display:none !important}" },
  "maxicoffee.com": { s: ".cookie-statement{display:none !important}" },
  "nhs.uk": {
    s: '.global-footer p ~ p,body > div[style*="E7E"],#nhsuk-cookie-banner,#cookie-banner ~ .notification,#phew_cookie_popup,.panel--cookie{display:none !important}',
  },
  "kaffeeverband.de": { c: 0 },
  "coffee-business-platform.de": { c: 111 },
  "toshiba-tv.com": {
    s: "#cookieModuleModal{display:none !important}",
    c: 14,
  },
  "etsy.com": { j: "5", s: ".wt-alert--fixed-bottom{display:none !important}" },
  "so.energy": { j: "5" },
  "interactivebrokers.com": { c: 20 },
  "interactivebrokers.co.uk": { c: 20 },
  "photopea.com": { s: "#uniccmp{display:none !important}" },
  "communaute.leboncoin.info": { j: "5" },
  "squarehabitat.fr": {
    s: '.TelerikModalOverlay,div[id*="Rgpd"]{display:none !important}',
  },
  "coindix.com": { s: "#xbanner{display:none !important}" },
  "tinnitusheilen.de": { j: "5" },
  "h2.live": { j: "5" },
  "nyulcipobolt.hu": {
    s: ".cookie-container,.cookie-button{display:none !important}",
  },
  "afkgaming.com": { s: "#snackbar ~ div{display:none !important}" },
  "smartsound.com": { c: 6 },
  "santacruzbicycles.com": {
    s: "#__next > div:first-child{display:none !important}",
  },
  "books-etc.com": { j: "5" },
  "atraveo.de": { s: ".disclaimer,.overlay{display:none !important}" },
  "e-domizil.de": {
    s: ".disclaimer,.overlay{display:none !important}",
    j: "5",
  },
  "kontaktlinsenforum.de": { s: ".m-cookie{display:none !important}" },
  "skyfoxlabs.com": { s: ".m-cookie{display:none !important}" },
  "sehen.de": { s: ".m-cookie{display:none !important}" },
  "profi-reifen.at": { j: "5" },
  "vergoelst.de": { j: "5" },
  "dekkmann.no": { j: "5" },
  "buero-bedarf-thueringen.de": { s: "#bbtCookieBG{display:none !important}" },
  "psd-rhein-ruhr.de": {
    s: ".lightbox--cookie-consent,.darken-layer{display:none !important}",
  },
  "michael-telecom.de": {
    s: "#consentModal{display:none !important}",
    c: 14,
  },
  "u-bordeaux.fr": { j: "5" },
  "nestbank.pl": { j: "5" },
  "tether.to": { j: "5" },
  "bportugal.pt": { j: "5" },
  "portainer.io": { j: "5" },
  "gitbook.io": { j: "5" },
  "extpose.com": { j: "5" },
  "hacktricks.xyz": { j: "5" },
  "golem.network": { j: "5" },
  "pokt.network": { j: "5" },
  "lightning.engineering": { j: "5" },
  "skynetlabs.com": { j: "5" },
  "econt.com": { c: 3 },
  "sickipedia.net": { s: ".policy-panel{display:none !important}" },
  "netbox.cz": { j: "5" },
  "veed.io": { s: ".fs-cc-banner3_component{display:none !important}" },
  "insse.ro": { s: "body > .wrapper{display:none !important}" },
  "laverdad.es": { j: "5" },
  "t3n.de": { j: "5" },
  "holmesplace.at": { s: ".cookie-window{display:none !important}" },
  "podimo.com": {
    j: "5",
    s: ".SmallCookieModalUI_container__MTAny{display:none !important}",
  },
  "sportmaster.ru": { s: ".sm-cookie-agreement{display:none !important}" },
  "sportmaster.dk": { c: 2 },
  "bestjobs.eu": { j: "5" },
  "glocalme.com": { s: ".cookies_declaration{display:none !important}" },
  "procoders.tech": { j: "5" },
  "eileenormsby.com": { j: "5" },
  "relai.app": { j: "5" },
  "culinaireambiance.com": { j: "5" },
  "figurelist.co": { j: "5" },
  "gateway-it.com": { j: "5" },
  "covid19awareness.sa": { j: "5" },
  "nurea.tv": { j: "5" },
  "investmentpunk.academy": { j: "5" },
  "alles-mahlsdorf.de": { j: "5" },
  "vulkansauna.de": { j: "5" },
  "ielb.org.br": { s: ".lgpd-all{display:none !important}" },
  "euranseurakunta.fi": { j: "5" },
  "rovaniemenseurakunta.fi": { j: "5" },
  "kity-rouen.com": { c: 0 },
  "bhaskar.com": {
    s: '#db-portal ~ div:not([style]),div[id*="gdpr"],.gdrpOverlay{display:none !important}',
  },
  "worldjournal.com": { s: "#privacy-agreement{display:none !important}" },
  "zentrale-pruefstelle-praevention.de": { j: "5" },
  "portalridice.cz": { j: "5" },
  "aeromexico.com": { j: "5" },
  "nsone.net": { s: "#gdpr-consent-modal{display:none !important}" },
  "hepster.com": { j: "5" },
  "fm-systeme.de": { j: "5" },
  "restaurant-ranglisten.de": { j: "5" },
  "qiwi.com": { s: "#app > div > div:first-child{display:none !important}" },
  "essayshark.com": { s: ".policies{display:none !important}" },
  "samsonite.ch": { j: "5" },
  "samsonite.de": { j: "5" },
  "samsonite.fr": { j: "5" },
  "samsonite.nl": { j: "5" },
  "samsonite.cz": { j: "5" },
  "samsonite.it": { j: "5" },
  "samsonite.es": { j: "5" },
  "samsonite.at": { j: "5" },
  "samsonite.pl": { j: "5" },
  "samsonite.be": { j: "5" },
  "samsonite.hu": { j: "5" },
  "samsonite.se": { j: "5" },
  "samsonite.dk": { j: "5" },
  "samsonite.no": { j: "5" },
  "samsonite.co.uk": { j: "5" },
  "samsonite.ro": { s: ".mainBlack{display:none !important}" },
  "annuaire-inverse-france.com": { c: 0 },
  "eventix.io": { j: "5" },
  "cire.pl": { j: "6" },
  "emmi-kaltbach.com": { j: "5" },
  "glaeserne-molkerei.de": { j: "5" },
  "donauregion.at": { j: "5" },
  "sorteonline.com.br": { s: ".cp-cookies{display:none !important}" },
  "b-parts.com": { j: "5" },
  "a1.si": { j: "5" },
  "ticketswap.com": { c: 51 },
  "ticketswap.uk": { c: 51 },
  "ticketswap.nl": { c: 51 },
  "ticketswap.fr": { c: 51 },
  "ticketswap.be": { c: 51 },
  "ticketswap.de": { c: 51 },
  "ticketswap.es": { c: 51 },
  "ticketswap.hu": { c: 51 },
  "ticketswap.it": { c: 51 },
  "ticketswap.se": { c: 51 },
  "ticketswap.com.br": { c: 51 },
  "tf1.fr": { j: "5" },
  "tf1info.fr": { j: "5" },
  "flyr.com": { j: "5" },
  "rewardlink.io": { c: 69 },
  "xhamster.com": {
    s: 'div[class^="cookiesAnnounce-"],.modal-4488f,.container-724f7{display:none !important}',
  },
  "xhamster2.com": {
    s: 'div[class^="cookiesAnnounce-"],.modal-4488f,.container-724f7{display:none !important}',
  },
  "xhamster3.com": {
    s: 'div[class^="cookiesAnnounce-"],.modal-4488f,.container-724f7{display:none !important}',
  },
  "xhamster.desi": {
    s: 'div[class^="cookiesAnnounce-"],.modal-4488f,.container-724f7{display:none !important}',
  },
  "xhamster18.desi": {
    s: 'div[class^="cookiesAnnounce-"],.modal-4488f,.container-724f7{display:none !important}',
  },
  "xhamster.xuxporner.com": {
    s: 'div[class^="cookiesAnnounce-"],.modal-4488f,.container-724f7{display:none !important}',
  },
  "bild.de": { j: "5" },
  "wetter.com": { j: "5" },
  "coolblue.nl": { j: "5" },
  "coolblue.be": { j: "5" },
  "coolblue.de": { j: "5" },
  "visualcrossing.com": { j: "5" },
  "culture.ru": {
    s: "#__next main + div ~ div:last-child,.notify-bar{display:none !important}",
  },
  "quantamagazine.org": { j: "5" },
  "winfuture.de": { j: "5" },
  "coupons.de": { j: "5", s: "#cmpwrapper{display:none !important}" },
  "okdo.com": {
    s: 'div[class*="c-notification-bar"]{display:none !important}',
  },
  "stark-suomi.fi": { c: 20 },
  "wimhofmethod.com": {
    s: "#appHeader > div:first-child:not(:only-child){display:none !important}",
  },
  "groupama.fr": { j: "5" },
  "interion.cz": { s: ".mcc-modal{display:none !important}" },
  "svtplay.se": { j: "5" },
  "mietausfall.immobilienscout24.de": { j: "5" },
  "compuprint.com": { s: "#pryck{display:none !important}" },
  "pagespeed.web.dev": {
    s: 'c-wiz > div > div > div > div[jscontroller][jsaction$=");"]{display:none !important}',
  },
  "billiger.de": { j: "5" },
  "passculture.app": { j: "5" },
  "kytary.cz": { j: "5" },
  "kytary.fr": { j: "5" },
  "kytary.de": { j: "5" },
  "kytary.es": { j: "5" },
  "kytary.ie": { j: "5" },
  "kytary.it": { j: "5" },
  "kytary.hu": { j: "5" },
  "kytary.nl": { j: "5" },
  "kytary.at": { j: "5" },
  "kytary.pl": { j: "5" },
  "kytary.ro": { j: "5" },
  "kytary.sk": { j: "5" },
  "scoresaber.com": { s: ".sticky-footer{display:none !important}" },
  "benu.at": { j: "5" },
  "ima.it": { j: "5" },
  "hotcleaner.com": {
    s: "footer > div > div:first-child{display:none !important}",
  },
  "lasprovincias.es": { j: "5" },
  "ideal.es": { j: "5" },
  "ideal.lv": { j: "5" },
  "ideal.ee": { j: "5" },
  "marginalen.se": { j: "5" },
  "kobo.com": { s: 'body > div[id^="cki"]{display:none !important}' },
  "underarmour.it": { s: ".l-consent_banner{display:none !important}" },
  "kronansapotek.se": { j: "5" },
  "udir.no": { c: 20 },
  "desmo-racing.com": { c: 0 },
  "direct-cuves.fr": { s: "#coockies-modal{display:none !important}" },
  "strana.one": { s: "#openModal{display:none !important}" },
  "strana.today": { s: "#openModal{display:none !important}" },
  "m-strana.ru": { s: ".agreement-cookie{display:none !important}" },
  "audiomack.com": { j: "5" },
  "gartenversandhaus.de": { j: "5" },
  "promondo.de": { j: "5" },
  "burgerkingrus.ru": { s: ".bk-cookie-message{display:none !important}" },
  "burgerking.co.uk": {
    s: 'div[class*="toast-container"] ~ div:not([data-testid]){display:none !important}',
  },
  "burgerking.fr": {
    s: "main > header ~ div:last-child{display:none !important}",
  },
  "clasohlson.com": { j: "5" },
  "makeship.com": { s: ".consent-wrapper{display:none !important}" },
  "sonofatailor.com": { j: "5" },
  "nindo.de": { j: "5" },
  "avisendanmark.dk": { j: "5" },
  "volmary.com": { j: "5" },
  "smartricity.de": { j: "5" },
  "modneiww.pl": { j: "5" },
  "nexera.pl": { j: "5" },
  "maree.info": { j: "5" },
  "realvnc.com": { j: "5" },
  "garten-und-freizeit.de": { j: "5" },
  "gv.at": { j: "5", s: "#am-cookie,#l42-cc__body{display:none !important}" },
  "parlament.gv.at": { s: ".popupOverlay{display:none !important}" },
  "groei.nl": { j: "5" },
  "coda.io": { j: "5" },
  "bakecaincontrii.com": { s: ".alert.fixed-bottom{display:none !important}" },
  "superology.com": { s: ".omnom-nom{display:none !important}" },
  "thephuketnews.com": { s: ".fixed-bottom{display:none !important}" },
  "capital.fr": { j: "5" },
  "mediaexpert.pl": { s: "#fastcookie{display:none !important}" },
  "abrdn.com": { s: ".cookie-policy-modal{display:none !important}" },
  "getrad.co": { s: ".cookie-policy-modal{display:none !important}" },
  "contino.io": { s: "main ~ footer ~ div{display:none !important}" },
  "rockstargames.com": { s: "main ~ footer ~ div{display:none !important}" },
  "vroomly.com": { j: "5" },
  "talkingtomandfriends.com": {
    s: "#cookie-settings{display:none !important}",
  },
  "gorillas.io": { s: "#cookie-settings{display:none !important}" },
  "rockmods.net": { s: ".cookies-show{display:none !important}" },
  "freesciencelessons.co.uk": {
    s: ".divibars-container{display:none !important}",
  },
  "namesilo.com": { s: "#app > header ~ section{display:none !important}" },
  "hansanders.nl": { s: "#cookie-dialog-wrapper{display:none !important}" },
  "hansanders.be": { s: "#cookie-module-js{display:none !important}" },
  "airgradient.com": { c: 112 },
  "ilmotorsport.de": { j: "5" },
  "techbone.de": { j: "5" },
  "techbone.fr": { j: "5" },
  "techbone.net": { j: "5" },
  "emsc.eu": { s: "#splashscreen{display:none !important}" },
  "sidusheroes.com": {
    s: 'div[class*="cookie__show"]{display:none !important}',
  },
  "groupeonepoint.com": { j: "5" },
  "dnb.no": { j: "5" },
  "wwf.fi": { j: "5" },
  "wwf.ru": { s: ".is-header-message-dock{display:none !important}" },
  "bever.nl": { j: "5" },
  "runnersneed.com": { j: "5" },
  "snowandrock.com": { j: "5" },
  "uni-rostock.de": { s: ".data-consent{display:none !important}" },
  "allocine.fr": { j: "5" },
  "algolia.com": {
    s: '#__next > div[class*="fixed"]{display:none !important}',
  },
  "caseking.de": { j: "5" },
  "plati.market": { c: 3 },
  "plati.ru": { c: 3 },
  "viva.com.ph": { s: ".pop-cookies{display:none !important}" },
  "mtbiker.sk": { s: "#biscuitModal{display:none !important}" },
  "sverigesingenjorer.se": { s: ".cookie-layer{display:none !important}" },
  "blocket.se": { j: "5" },
  "nowfoods.com": {
    s: ".block-sd-cookie-consent-block{display:none !important}",
  },
  "comparably.com": { s: ".section.cppa{display:none !important}" },
  "itella.ee": { j: "5" },
  "itella.lt": { j: "5" },
  "itella.lv": { j: "5" },
  "vh-polska.pl": { s: "#cookies__new{display:none !important}" },
  "hemnet.se": { j: "5" },
  "woerthersee.com": { j: "5" },
  "wirkaufendeinauto.de": { j: "5" },
  "wirkaufendeinauto.at": { j: "5" },
  "noicompriamoauto.it": { j: "5" },
  "vendezvotrevoiture.fr": { j: "5" },
  "norwegian.com": { j: "5" },
  "freeontour.com": { j: "5" },
  "medal.tv": { j: "5" },
  "wittgas.com": { j: "5" },
  "malighting.com": { j: "5" },
  "stahlportal.com": { j: "5" },
  "vmt-thueringen.de": { j: "5" },
  "learnrxjs.io": { j: "5" },
  "peatus.ee": { s: "#messageBar{display:none !important}" },
  "datenlogger-store.de": { j: "5" },
  "nova-motors.de": { j: "5" },
  "christy.co.uk": { j: "5" },
  "patronsdecouture.com": { j: "5" },
  "protest.eu": { j: "5" },
  "livsmedelsverket.se": { s: "#CookieConsent{display:none !important}" },
  "cnig.es": { s: "#layerCookie{display:none !important}" },
  "bubamara.eu": { s: ".gdpr-modal-wrapper{display:none !important}" },
  "iobroker.pro": { j: "5" },
  "iobroker.net": { j: "5" },
  "thecountersignal.com": { j: "5" },
  "softhints.com": { c: 2 },
  "clv.de": { j: "5" },
  "thenextcloset.com": {
    s: 'div[data-react-class*="CookieConsentBanner"]{display:none !important}',
  },
  "hardware.info": { j: "3" },
  "tudogostoso.com.br": { c: 8 },
  "healthygamer.gg": { j: "5" },
  "otrium.co.uk": { j: "5" },
  "otrium.fr": { j: "5" },
  "otrium.de": { j: "5" },
  "sellpy.se": {
    s: 'div[name="footerExpander"] + div ~ div:not([style]){display:none !important}',
  },
  "sellpy.de": {
    s: 'div[name="footerExpander"] + div ~ div:not([style]){display:none !important}',
  },
  "sellpy.com": {
    s: 'div[name="footerExpander"] + div ~ div:not([style]){display:none !important}',
  },
  "x-kom.pl": { j: "5" },
  "oscaro.es": { j: "5" },
  "oscaro.de": { j: "5" },
  "oscaro.pt": { j: "5" },
  "oscaro.be": { j: "5" },
  "oscaro.com": { j: "5" },
  "rollei.de": { j: "5" },
  "steuerbot.com": { j: "5" },
  "one2car.com": { s: "#cookies-content{display:none !important}" },
  "knowunity.de": { s: ".Toastify ~ div{display:none !important}" },
  "runcloud.io": { s: ".rc-cookie-banner{display:none !important}" },
  "mcreator.net": { j: "5" },
  "trustpid.com": { j: "5", s: "footer > button{display:none !important}" },
  "forskning.no": { s: ".adn-window,.adn-editButton{display:none !important}" },
  "opintopolku.fi": { j: "5" },
  "eperusteet.opintopolku.fi": {
    s: "#cookie-modal-backdrop{display:none !important}",
  },
  "dodo.fr": { j: "5" },
  "z4u.zurich.com.pt": { s: ".CookiesBox{display:none !important}" },
  "dreamdoors.co.uk": { s: ".cookie-acception{display:none !important}" },
  "unacademy.com": { j: "5" },
  "unilae.com": { c: 39 },
  "login.ladies.de": { j: "5" },
  "ladies-forum.de": { j: "5" },
  "you-ladies.de": { s: "#rto-cookie-notice{display:none !important}" },
  "scotiabank.com": { j: "5" },
  "jdsupra.com": { c: 166 },
  "vakantieveilingen.nl": {
    s: "#__next > div > div:first-child{display:none !important}",
  },
  "vakantieveilingen.be": {
    s: "#__next > div > div:first-child{display:none !important}",
  },
  "oase-teichbau.de": {
    s: 'div[x-data*="app.components.cookieConsent"]{display:none !important}',
  },
  "evium.de": { j: "5" },
  "boohoo.com": { j: "5" },
  "boohooman.com": { j: "5" },
  "karenmillen.com": { j: "5" },
  "warehousefashion.com": { j: "5" },
  "nastygal.com": { j: "5" },
  "endclothing.com": {
    s: '#footer ~ div[style*="opacity"]{display:none !important}',
  },
  "littlelunch.com": { j: "5" },
  "delorean.com": { j: "5" },
  "petalmaps.com": { s: '#app > [class*="privacy"]{display:none !important}' },
  "photospecialist.co.uk": { c: 20 },
  "photospecialist.at": { c: 20 },
  "photospecialist.de": { c: 20 },
  "kamera-express.nl": { c: 20 },
  "kamera-express.be": { c: 20 },
  "kamera-express.lu": { c: 20 },
  "kamera-express.de": { c: 20 },
  "helpster.de": { j: "5" },
  "livecounts.io": {
    s: "#__next > div > div > .w-full.fixed{display:none !important}",
  },
  "0815.at": { j: "5" },
  "badewanneneinstieg.com": { j: "5" },
  "bgvbruck.at": { j: "5" },
  "electronicbeats.pl": { j: "5" },
  "wkv.com": { s: "#priv-notice-container{display:none !important}" },
  "anker.com": { s: 'footer ~ [class*="FeatureBar"]{display:none !important}' },
  "mps.it": {
    s: ".sg-cookie_panel,#cookieModalPopup{display:none !important}",
  },
  "tricount.com": { j: "5" },
  "seduo.cz": { j: "5" },
  "atmoskop.cz": { j: "5" },
  "ably.com": { s: ".ui-cookie-message{display:none !important}" },
  "readly.com": { j: "5" },
  "ilmanifesto.it": { s: ".info-banner{display:none !important}" },
  "karrierekaserne.de": { s: ".autoprivacy{display:none !important}" },
  "abfallwirtschaft-freiburg.de": {
    s: "#pro_cookiebox{display:none !important}",
  },
  "darmas.de": { s: "#mod-darmas-cookies{display:none !important}" },
  "die-kolping-akademie.de": { j: "5" },
  "golvprofilshop.se": {
    s: "#cookie-consent-modal{display:none !important}",
    c: 14,
  },
  "showcasecinemas.co.uk": {
    j: "5",
    s: "s72-cookie-consent{display:none !important}",
  },
  "lamoda.ru": {
    s: '.page > [class*="widget"],.unipop__container ~ div{display:none !important}',
  },
  "pitch.com": { s: ".platform--cookies--container{display:none !important}" },
  "christian-lindner.de": { j: "5" },
  "flynorse.com": { j: "5" },
  "ghost-bikes.com": { s: ".cookie-styling{display:none !important}" },
  "roli.com": { j: "5" },
  "telnyx.com": { j: "5" },
  "kiepenkerl.de": { j: "5" },
  "moebel-buss.de": { j: "5" },
  "cafe-royal.com": {
    j: "5",
    s: "#cookie-bar-modal-wrapper{display:none !important}",
    c: 14,
  },
  "studi-kompass.com": { s: ".accept-privacy-policy{display:none !important}" },
  "ekstrabladet.dk": { j: "5" },
  "barnes-international.com": { s: "#managerCookies{display:none !important}" },
  "mycinema.pro": { s: "footer > div:not([class]){display:none !important}" },
  "biddit.be": { s: "app-cookies-notification-v2{display:none !important}" },
  "unicredit.it": { j: "5" },
  "ihk.de": {
    s: "#COOKIE_POLICY,#CybotCookiebotDialog,.ihk-switch{display:none !important}",
    j: "5",
  },
  "xbox.com": { j: "5" },
  "dmapraha.cz": { s: ".focus-cookies{display:none !important}" },
  "la-becanerie.com": { j: "5" },
  "unity.cn": {
    s: 'div[class*="cookies-permission"]{display:none !important}',
  },
  "deofhet.nl": {
    s: "#gatsby-focus-wrapper > div > footer ~ div{display:none !important}",
  },
  "afisha.ru": { s: "#popup-controller ~ div{display:none !important}" },
  "unstop.com": { s: ".cookies-save{display:none !important}" },
  "santanderconsumer.se": {
    s: 'div[data-react-component="@b2c/cookie-consent"]{display:none !important}',
  },
  "gaminganalytics.info": { j: "5" },
  "sds.com": {
    s: '.notification-banner[aria-describedby="cookie-notification-message"]{display:none !important}',
  },
  "hi-fi.ru": { c: 0 },
  "hi-fi.com.pl": { c: 0 },
  "t-mobile.pl": { s: ".topup-cookie{display:none !important}" },
  "intersport.hr": { j: "5" },
  "intersport.si": { j: "5" },
  "intersport.rs": { j: "5" },
  "intersport.ba": { j: "5" },
  "intersport.gr": { j: "5" },
  "intersport.ro": { j: "5" },
  "hondoscenter.com": { j: "5" },
  "tsp.gov": { s: ".tsp-cookie{display:none !important}" },
  "gigalekaren.sk": { s: "#dl_cookie{display:none !important}" },
  "gigalekarna.cz": { s: "#dl_cookie{display:none !important}" },
  "789ten.com": { s: "#app > .bg-black-deep{display:none !important}" },
  "teracom.se": { s: ".modal-cc-cookies{display:none !important}" },
  "nuuvem.com": { s: ".consent-warning{display:none !important}" },
  "aldi-blumen.de": { j: "5" },
  "azubiheft.de": { c: 151 },
  "inp-gruppe.de": { j: "5" },
  "altoetting.de": { j: "5" },
  "micronova.de": { j: "5" },
  "hek.de": { j: "5" },
  "peakd.com": { s: "#app > .navbar-fixed-bottom{display:none !important}" },
  "crossingeurope.at": { j: "5" },
  "austrocontrol.at": { j: "5" },
  "daneurope.org": { j: "5" },
  "nuri.com": { j: "5" },
  "flightradar24.com": { j: "5" },
  "amf-semfyc.com": { j: "5" },
  "hutchinson.com": { j: "5" },
  "whitebit.com": { s: "main ~ div.ui-kit{display:none !important}" },
  "ibispaint.com": { s: "#agreementPane{display:none !important}" },
  "mdcc.de": { j: "5" },
  "temple.edu": { s: "#tu-cookies-eu-compliance{display:none !important}" },
  "lgdisplay.com": { s: ".cookie_pop{display:none !important}" },
  "ppg.com": { s: ".cm{display:none !important}" },
  "lemoncurve.com": { j: "5" },
  "ulysse.com": { s: "nav ~ .fixed,.shadow-cookie{display:none !important}" },
  "blackyak.com": { j: "5" },
  "pro-biomarkt.de": { j: "5" },
  "lra-mue.de": { s: "#lab-slide-bottom-popup{display:none !important}" },
  "vontobel.com": { j: "5" },
  "swiatloistyl.pl": { c: 0 },
  "elia.eus": {
    s: "#cookies_modal{display:none !important}",
    c: 14,
  },
  "mobills.com.br": { c: 24 },
  "henleyglobal.com": { j: "5" },
  "arbeitsagentur.de": { j: "5" },
  "lush.com": { j: "5" },
  "fixtout.fr": { s: ".gtcookies-change-settings{display:none !important}" },
  "kotas.com.br": { j: "5" },
  "money.pl": { j: "5" },
  "carrefour.es": { j: "5" },
  "carrefour.pf": { s: "#__next > div > span{display:none !important}" },
  "poliklinikaprosek.cz": { s: ".cookie_opruz{display:none !important}" },
  "semper.se": { s: 'div[class*="CookieContainer"]{display:none !important}' },
  "form.bar": { s: ".formbarConsent{display:none !important}" },
  "bittitan.com": { c: 0 },
  "lepotcommun.fr": { j: "5" },
  "koryotel.com": { s: "#footer_overlay{display:none !important}" },
  "satisfactorygame.com": { c: 2 },
  "blockfi.com": { j: "5" },
  "mi.com": {
    s: '.micloud-app > div > div[class*="policy"]{display:none !important}',
  },
  "mottavisconti.mi.it": { s: ".wp-exclude-emoji{display:none !important}" },
  "cut.org.br": { c: 20 },
  "chapel-hydraulique.com": { s: "#tc_rgpd_popup{display:none !important}" },
  "11teamsports.com": { s: "#TrackingTipp{display:none !important}" },
  "benify.com": { j: "5" },
  "salzkammergut.at": { j: "5" },
  "aargautourismus.ch": { j: "5" },
  "resinet.pl": { s: "#cookie-bg{display:none !important}" },
  "ii.co.uk": { j: "5" },
  "ironhack.com": { j: "5" },
  "wows-gamer-blog.com": { s: "#supermag-cookie-ify{display:none !important}" },
  "vloot.io": { s: '#app > .fixed[class*="rounded"]{display:none !important}' },
  "myanimelist.net": { s: ".modal-content-overlay{display:none !important}" },
  "myanimelist.vip": { c: 8 },
  "kulturhusetstadsteatern.se": {
    s: "#block-cookieapproval{display:none !important}",
  },
  "wielkiegranie.pl": { j: "5" },
  "promobit.com.br": { c: 159 },
  "flender.com": { j: "5" },
  "lampak.hu": { s: ".cookie-setting{display:none !important}" },
  "zakonyprolidi.cz": { s: ".CookiePerm{display:none !important}" },
  "smileoptic.de": { j: "5" },
  "nigelfrank.com": { j: "5" },
  "vivo.com": { s: "#vcm-v-consent-sdk{display:none !important}" },
  "maandag.nl": { j: "5" },
  "shipping-portal.com": { j: "5" },
  "krungsricard.com": { j: "5" },
  "bashmaistora.bg": { s: ".cookies-cont{display:none !important}" },
  "swapcard.com": { j: "5" },
  "goteborg.com": { j: "5" },
  "generali.at": { j: "5", c: 166 },
  "generali.co.uk": { s: ".cookies-container-uk{display:none !important}" },
  "generali.si": { s: ".cd-overlay,.cd-module-modal{display:none !important}" },
  "ammerlaender-versicherung.de": { j: "5" },
  "mobylines.com": { c: 0 },
  "ubiwayretail.be": { j: "5" },
  "refashion.fr": { s: ".block-cookies-rgpd{display:none !important}" },
  "linak.es": { j: "5" },
  "linak.de": { j: "5" },
  "palixi.net": { c: 72 },
  "treinaweb.com.br": {
    s: 'div[c_data="c_cookie_main"]{display:none !important}',
  },
  "opensocietyfoundations.org": { s: "#cc_div{display:none !important}" },
  "mondverlauf.de": { s: "#cc_div{display:none !important}" },
  "sonnenverlauf.de": { s: "#cc_div{display:none !important}" },
  "revolut.com": {
    s: 'div[role="dialog"][aria-label*="Cookie"]{display:none !important}',
    j: "5",
  },
  "volkssolidaritaet.de": { j: "5" },
  "allani.pl": { s: ".off-canvas-wrap ~ div{display:none !important}" },
  "vanharen.nl": { j: "5" },
  "g2a.com": { j: "6" },
  "g2a.co": { j: "6" },
  "abc-mallorca.com": { s: ".abc-cookies-wrapper{display:none !important}" },
  "porsche.pl": { c: 39 },
  "porsche.com": {
    s: ".pocs-legal-disclaimer,myservices-cookie-banner{display:none !important}",
  },
  "ruzomberok.sk": { s: "#cookie-global-envelope{display:none !important}" },
  "studyinjapan.go.jp": { s: "#js_cookie_modal{display:none !important}" },
  "lexar.com": { s: "#lexar-accept-cookie{display:none !important}" },
  "tooltester.com": { s: "#tt-cookie-notice{display:none !important}" },
  "cruisemapper.com": { s: ".sitePrivacyPolicy{display:none !important}" },
  "studentenwerkfrankfurt.de": { j: "5" },
  "d-luft.de": { s: ".banner-consent-all{display:none !important}" },
  "tvsmotor.com": { s: ".cookie_bot{display:none !important}" },
  "love.ru": { s: "#gdpr_popup{display:none !important}" },
  "ataccama.com": { j: "5" },
  "kellermann-online.com": { j: "5" },
  "yopmail.com": { j: "5" },
  "yopmail.fr": { j: "5" },
  "chrome-stats.com": {
    s: ".consent-overlay,.cookie-consent{display:none !important}",
  },
  "sf.gr": { s: "#cookiesManagement{display:none !important}" },
  "cardinal.gr": { s: "#cookiesManagement{display:none !important}" },
  "pokemondb.net": { s: "#gdpr-confirm{display:none !important}" },
  "schroders.com": { j: "5" },
  "hero-wars.com": {
    s: ".modal-cookie,#app > .disclaimer{display:none !important}",
  },
  "techgig.com": { s: ".gdpr-info{display:none !important}" },
  "rocket.chat": { j: "5" },
  "hardforce.com": { s: "#rgpd-cookies{display:none !important}" },
  "radio-canada.ca": {
    s: "#react-app > div:first-child:not(:only-child)[class]{display:none !important}",
  },
  "petofilive.hu": { s: ".resultCookie{display:none !important}" },
  "roms-hub.com": { j: "5" },
  "roms-telecharger.com": { j: "5" },
  "herunterladenroms.com": { j: "5" },
  "descargarroms.com": { j: "5" },
  "sofiacomputers.net": { s: "#uslpolzvane{display:none !important}" },
  "stormgain.com": { s: 'div[id*="gdprcookies"]{display:none !important}' },
  "adulttime.com": {
    s: ".CookieConsent-Wrapper-BackgroundBox{display:none !important}",
  },
  "calendardate.com": {
    s: 'footer ~ [style*="fixed"]{display:none !important}',
  },
  "fpv24.com": { j: "5" },
  "sakret.de": { j: "5" },
  "lynkco.com": { j: "5" },
  "lynkco.com.cn": { c: 26 },
  "visiontimes.com": { s: ".cookieNotice--isVisible{display:none !important}" },
  "boords.com": {
    s: '#__next > .fixed[class*="bottom"]{display:none !important}',
  },
  "sparebank1.no": { s: "#opt-in{display:none !important}" },
  "atlantic.money": { s: "#opt-in{display:none !important}" },
  "ionity.eu": { j: "5" },
  "autoteile-favorit.com": {
    s: ".ets_cookie_banber_block{display:none !important}",
  },
  "obenaufs.com": { j: "5" },
  "2gis.com.cy": { s: "#confirm ~ div{display:none !important}" },
  "2gis.ru": { s: "#confirm ~ footer{display:none !important}" },
  "sites.google.com": { j: "5" },
  "canva.com": { j: "5" },
  "ertflix.gr": { j: "6" },
  "sky.com": { j: "5" },
  "xt500parts.com": {
    s: ".amgdprcookie-modal-container{display:none !important}",
  },
  "flaschenpost.de": { j: "5" },
  "notco.com": { s: ".CookiesContainer{display:none !important}" },
  "nytimes.com": {
    j: "5",
    s: '.free-form-content > .banner__container,.CookieBanner > .banner__container,#alertBannerMount,.gdpr.expanded-dock + div,.CookieBanner ~ .banner__container,span[data-testid="onsite-messaging-unit-gdprDock"]{display:none !important}',
  },
  "abconcerts.be": { j: "5" },
  "kulturprojekte.berlin": { j: "5" },
  "humboldtforum.org": { j: "5" },
  "dw.com": { c: 155 },
  "fz-juelich.de": { j: "5" },
  "thepensionsregulator.gov.uk": { j: "5" },
  "kaggle.com": { j: "5" },
  "vsninfo.de": { j: "5" },
  "stadtwerke-weilburg.de": { j: "5" },
  "freilandmuseum-fladungen.de": { j: "5" },
  "tweakers.net": {
    j: "5",
    s: "#koekieBar:not(.tall){display:none !important}",
  },
  "quantifycrypto.com": { j: "5" },
  "mirells.se": { j: "5" },
  "pelckmans.net": { j: "5" },
  "reimsuche.de": { j: "5" },
  "smashurandompicker.web.app": { j: "5" },
  "buildup.group": { j: "5" },
  "devicespecifications.com": { c: 6 },
  "foncia.com": { s: "app-foncia-cookie-banner{display:none !important}" },
  "webfleet.com": { j: "5" },
  "nordnet.no": { c: 6 },
  "nordnet.fi": { c: 6 },
  "nordnet.dk": { c: 6 },
  "truphone.com": { j: "5" },
  "forestgum.de": { c: 0 },
  "yosoylebara.es": { j: "5" },
  "welt.de": { j: "5" },
  "vy.no": { s: ".page > section{display:none !important}" },
  "bt.dk": { j: "5" },
  "bt.se": { s: '#root > [class*="fluffy"]{display:none !important}' },
  "linkio.com": { s: ".linkio_cookieconsent{display:none !important}" },
  "marketinghack.net": { s: ".bot-alert-box{display:none !important}" },
  "afiklmem.com": { j: "5" },
  "chromeactions.com": {
    s: "footer > div:not([class]){display:none !important}",
  },
  "veikkaus.fi": { j: "5" },
  "tass.ru": {
    s: 'div[class*="Cookies_container"]{display:none !important;position:absolute;left:-99999px}',
  },
  "meteored.cl": { j: "5" },
  "meteored.com.ec": { j: "5" },
  "adm.gov.it": { s: "#cookiebar-adm{display:none !important}" },
  "lotteriadegliscontrini.gov.it": { s: "#coockie{display:none !important}" },
  "csirt.gov.it": { s: "header ~ .fixed{display:none !important}" },
  "crazyslip.com": { s: "#ccon{display:none !important}" },
  "tvtv.us": { c: 24 },
  "nejlevnejsinabytek.cz": { j: "5" },
  "motointegrator.de": { j: "5" },
  "motointegrator.fr": { j: "5" },
  "notebooksbilliger.de": { j: "5" },
  "peerberry.com": {
    s: ".tpl-layout ~ div:not([id]):not([class]){display:none !important}",
  },
  "immerag.ch": { c: 30 },
  "aknw.de": { j: "5" },
  "stadtwerke-bonn.de": { j: "5" },
  "bbc.global.ssl.fastly.net": {
    s: '#main-wrapper > header > div[class*="bbc"]:first-child{display:none !important}',
  },
  "ankama.com": { j: "5" },
  "palixi.com": { c: 72 },
  "rugbyworldcup.com": { j: "5" },
  "world.rugby": { j: "5" },
  "premierleague.com": { j: "5" },
  "birmingham2022.com": { j: "5" },
  "elbphilharmonie.de": { c: 98 },
  "kyivindependent.com": {
    s: 'div[class*="Footer_cookies"]{display:none !important}',
  },
  "dashboard-deutschland.de": { j: "5" },
  "bulldogjob.pl": { s: "#__next > footer ~ .fixed{display:none !important}" },
  "muni.cz": { s: ".muniweb-cookies{display:none !important}" },
  "futurumshop.nl": { j: "5" },
  "1avisum.de": { s: ".announcement{display:none !important}" },
  "moneyfarm.com": {
    s: '#gatsby-focus-wrapper > div[class*="header"] > div:first-child{display:none !important}',
  },
  "majkl3d.cz": { c: 154 },
  "majkl3d.sk": { c: 154 },
  "turk.net": { s: ".rey-cookieNotice{display:none !important}" },
  "cpfc.co.uk": { j: "5" },
  "nottinghamforest.co.uk": { s: ".popup-wrapper{display:none !important}" },
  "luzern.com": { j: "5" },
  "torcedores.com": { s: "#navve-cookie-block{display:none !important}" },
  "pebmed.com.br": { c: 59 },
  "adler-farbenmeister.com": { j: "5" },
  "lexibo.com": { j: "5" },
  "cotswoldoutdoor.com": { j: "5" },
  "cotswoldoutdoor.ie": { j: "5" },
  "asadventure.com": { j: "5" },
  "asadventure.fr": { j: "5" },
  "asadventure.nl": { j: "5" },
  "asadventure.lu": { j: "5" },
  "sorare.com": {
    s: "#root > .webp > div:first-child{display:none !important}",
  },
  "santediscount.com": { j: "5" },
  "atida.fr": { j: "5" },
  "myfitnesspal.com": {
    s: ".MuiSnackbar-anchorOriginBottomCenter{display:none !important}",
  },
  "myfitnesspal.cn": {
    s: ".MuiSnackbar-anchorOriginBottomCenter{display:none !important}",
  },
  "beamdog.com": { s: "#gdpr-consent-form{display:none !important}" },
  "mensxp.com": { c: 157 },
  "sentaifilmworks.com": { s: "#sfw-msg{display:none !important}" },
  "scienceopen.com": { j: "5" },
  "bactrade.cz": { j: "5" },
  "scb.se": { j: "5" },
  "vsezaodvoz.cz": { j: "5" },
  "grafik-werkstatt.de": { j: "5" },
  "pdfforge.org": { j: "5" },
  "ing.lu": { j: "5" },
  "ing.it": { s: "#sticky-page-top-cnt{display:none !important}", j: "5" },
  "ing.com.tr": { s: ".kvk-footer-warning{display:none !important}" },
  "ing.jobs": { j: "5" },
  "coinbase.com": {
    s: '#root > div + div[class^="esm__Container"]:last-child,div[class*="ContentHub__FooterWrapper"] ~ div:last-child,#popup-root ~ div[class*="Layout"] ~ div:not([data-element]){display:none !important}',
  },
  "pro.coinbase.com": {
    s: "#page_content > div + div:last-child{display:none !important}",
  },
  "help.coinbase.com": {
    s: '#__next > section[class*="footer"] ~ div{display:none !important}',
  },
  "login.coinbase.com": {
    s: 'div[data-testid="banner-container"]{display:none !important}',
  },
  "t-mobile.nl": { j: "5" },
  "tele2.nl": { j: "5", s: "#targetedPopupFrame{display:none !important}" },
  "privatbank.ua": { c: 0 },
  "stickerapp.com": { j: "5" },
  "stickerapp.de": { j: "5" },
  "stickerapp.co.uk": { j: "5" },
  "stickerapp.it": { j: "5" },
  "gamesforplay.com": { c: 9 },
  "satel.pl": { j: "5" },
  "fashionunited.info": { c: 24 },
  "fashionunited.com": { c: 24 },
  "fashionunited.fr": { c: 24 },
  "fashionunited.uk": { c: 24 },
  "fashionunited.de": { c: 24 },
  "fashionunited.nl": { c: 24 },
  "fashionunited.be": { c: 24 },
  "fi.google.com": {
    s: 'span[jsslot] > div > div > div > span[jsslot] > div[data-visible="true"]{display:none !important}',
  },
  "hoppscotch.io": { s: ".toasted-container{display:none !important}" },
  "hattrick.org": { j: "5" },
  "telia.se": { j: "5" },
  "wolters-rundreisen.de": { j: "5" },
  "cloud.im": { j: "5" },
  "balluff.com": { s: 'div[x-data*="ConsentDialog"]{display:none !important}' },
  "tk.de": { j: "5" },
  "conduktor.io": {
    s: ".cookie-though{display:none !important;left:-99999px}",
  },
  "autodoc.de": { s: ".gdpr-pane{display:none !important}" },
  "italotreno.it": {
    s: ".pre-header-bar.cookies,#cookie-row{display:none !important}",
  },
  "bagsandcoversdirect.co.uk": { s: ".cookbx{display:none !important}" },
  "bazaartracker.com": { j: "5" },
  "seatris.ai": { j: "5" },
  "erli.pl": { j: "5" },
  "moovitapp.com": { s: "mv-cookie-banner{display:none !important}" },
  "replika.com": { s: 'div[class*="GdprPopup"]{display:none !important}' },
  "replika.ai": { s: 'div[class*="GdprPopup"]{display:none !important}' },
  "otherbundesliga.com": { j: "5" },
  "torg-pc.ru": { s: ".marketing-popup{display:none !important}" },
  "jlcpcb.com": { s: ".jlc-wm-cookie-policy{display:none !important}" },
  "smd-led.pl": { s: "#__pb-cookie{display:none !important}" },
  "dext.com": { j: "5" },
  "diehl.com": { s: ".notice-overlay{display:none !important}" },
  "vamox.io": { j: "5" },
  "superpantofi.ro": { s: "#app > .fixed-top{display:none !important}" },
  "premierinn.com": { j: "5" },
  "brewersfayre.co.uk": { j: "5" },
  "lolja.com.br": { s: "#lgpd-popup{display:none !important}" },
  "xp-pen.com": { s: ".cookie_tag{display:none !important}" },
  "xp-pen.de": { s: ".cookie_tag{display:none !important}" },
  "robinhood.com": { j: "5" },
  "innn.it": { s: "#cookieConsentModal ~ div{display:none !important}" },
  "factoryberlin.com": {
    s: '.flyntComponent[is*="cookie-optin"]{display:none !important}',
  },
  "hellotv.nl": { j: "5" },
  "werk-stadt.com": { j: "5" },
  "fydeos.com": { c: 20 },
  "sanarmed.com": {
    s: '#__next > nav + div > div[class*="Wrapper"]{display:none !important}',
  },
  "nebenan.de": { s: ".c-layout-wrap ~ article{display:none !important}" },
  "4game.com": { s: ".fcw-wrap{display:none !important}" },
  "onlyandsons.com": { s: ".overlay-backdrop{display:none !important}" },
  "muziker.com": { j: "5" },
  "muziker.at": { j: "5" },
  "muziker.be": { j: "5" },
  "muziker.bg": { j: "5" },
  "muziker.hr": { j: "5" },
  "muziker.cz": { j: "5" },
  "muziker.nu": { j: "5" },
  "muziker.ee": { j: "5" },
  "muziker.fi": { j: "5" },
  "muziker.fr": { j: "5" },
  "muziker.de": { j: "5" },
  "muziker.gr": { j: "5" },
  "muziker.hu": { j: "5" },
  "muziker.ie": { j: "5" },
  "muziker.it": { j: "5" },
  "muziker.lv": { j: "5" },
  "muziker.lt": { j: "5" },
  "muziker.lu": { j: "5" },
  "muziker.nl": { j: "5" },
  "muziker.pl": { j: "5" },
  "muziker.pt": { j: "5" },
  "muziker.ro": { j: "5" },
  "muziker.sk": { j: "5" },
  "muziker.si": { j: "5" },
  "muziker.es": { j: "5" },
  "muziker.se": { j: "5" },
  "muziker.co.uk": { j: "5" },
  "answear.com": { j: "5" },
  "answear.ua": { j: "5" },
  "answear.ro": { j: "5" },
  "answear.cz": { j: "5" },
  "answear.hu": { j: "5" },
  "answear.sk": { j: "5" },
  "answear.bg": { j: "5" },
  "incomputer.cz": { s: ".cookies-fixed-left{display:none !important}" },
  "mujnuz.cz": { s: 'div[id*="cookie-modal"]{display:none !important}' },
  "starwalk.space": {
    s: "#button-actions-container ~ div{display:none !important}",
  },
  "pr0gramm.com": { j: "5" },
  "toruniak.pl": { j: "5" },
  "krakusik.pl": { j: "5" },
  "kaliszak.pl": { j: "5" },
  "kudyznudy.cz": { s: ".j-cinfo{display:none !important}" },
  "proxyparts.com": { c: 0 },
  "proxyparts.fr": { c: 0 },
  "proxyparts.de": { c: 0 },
  "proxyparts.es": { c: 0 },
  "proxyparts.pl": { c: 0 },
  "onderdelenlijn.nl": { c: 0 },
  "continental.com": { j: "5" },
  "uniroyal.pl": { j: "5" },
  "uniroyal.de": { j: "5" },
  "uniroyal.at": { j: "5" },
  "continental.ba": { j: "5" },
  "continental.bg": { j: "5" },
  "continental.hr": { j: "5" },
  "continental.ee": { j: "5" },
  "continental.hu": { j: "5" },
  "continental.mk": { j: "5" },
  "continental.lt": { j: "5" },
  "barum-reifen.de": { j: "5" },
  "uniroyal-tyres.com": { j: "5" },
  "continental-daek.dk": { j: "5" },
  "continental-opony.pl": { j: "5" },
  "continental-tires.gr": { j: "5" },
  "continental-pneus.fr": { j: "5" },
  "continental-pneus.pt": { j: "5" },
  "continental-banden.nl": { j: "5" },
  "continental-reifen.de": { j: "5" },
  "continental-reifen.ch": { j: "5" },
  "continental-banden.be": { j: "5" },
  "continental-rengas.fi": { j: "5" },
  "continental-riepas.lv": { j: "5" },
  "continental-tires.com": { j: "5" },
  "continental-tyres.co.uk": { j: "5" },
  "continental-pneumatiky.cz": { j: "5" },
  "continental-pneumatici.it": { j: "5" },
  "continental-neumaticos.es": { j: "5" },
  "xn--continental-dck-dlb.se": { j: "5" },
  "app.klarna.com": { j: "3" },
  "flip.ro": { j: "5" },
  "flip.bg": { j: "5" },
  "flip.pt": { s: "#access{display:none !important}" },
  "culturecalling.com": {
    s: ".hiddenFields ~ .consent{display:none !important}",
  },
  "turismo.gal": { s: ".bandaAceptacion{display:none !important}" },
  "xunta.gal": { s: ".bandaAceptacion{display:none !important}" },
  "aok.de": { j: "5" },
  "online-trainer-lizenz.de": { j: "5" },
  "hsbc.com": { j: "5" },
  "hsbc.co.uk": { j: "5" },
  "hsbc.de": { j: "5" },
  "shopmate.eu": {
    s: "#__layout > main > div:first-child:not([id]){display:none !important}",
  },
  "112press.hu": { c: 164 },
  "waldbuehne-berlin.de": { s: "#cookieManager{display:none !important}" },
  "bardeen.ai": { s: ".fs-cc-banner_component{display:none !important}" },
  "sygic.com": { c: 20 },
  "deviantart.com": { j: "5" },
  "geizhals.at": {
    s: ".gh-notification--type-info{display:none !important}",
    j: "5",
  },
  "geizhals.de": {
    s: ".gh-notification--type-info{display:none !important}",
    j: "5",
  },
  "geizhals.eu": {
    s: ".gh-notification--type-info{display:none !important}",
    j: "5",
  },
  "komplettbank.se": { s: ".kb-cc{display:none !important}" },
  "komplettbank.fi": { s: ".kb-cc{display:none !important}" },
  "komplettbank.no": { s: ".kb-cc{display:none !important}" },
  "hertz.co.uk": { s: "#new_cookie_container{display:none !important}" },
  "baden-wuerttemberg.de": { j: "5" },
  "fbreader.org": { j: "5" },
  "neo24.pl": { s: 'div[class*="cookiesBlock"]{display:none !important}' },
  "tyg.se": { j: "5" },
  "stoffe.de": { j: "5" },
  "myfabrics.co.uk": { j: "5" },
  "ejot.de": { j: "5" },
  "ejot.at": { j: "5" },
  "ejot.cn": { j: "5" },
  "ejot.co.uk": { j: "5" },
  "mylife.com": { s: ".ccpa-container,.eula-terms{display:none !important}" },
  "picrew.me": { s: ".st-Terms_Wrapper{display:none !important}" },
  "levykauppax.fi": { s: "#cookieconsent-sticky{display:none !important}" },
  "wpolityce.pl": { j: "5" },
  "www-youtube-com.translate.goog": {
    s: "ytd-consent-bump-v2-lightbox,tp-yt-iron-overlay-backdrop{display:none !important}",
  },
  "barnardos.org.uk": { j: "5" },
  "kvwl.de": { s: ".m-react-ccm{display:none !important}" },
  "corona-kvwl.de": { s: ".m-react-ccm{display:none !important}" },
  "oasis.app": { j: "5" },
  "stadtwerke-flensburg.de": { j: "5" },
  "4sgm.com": { s: "#policy-bar{display:none !important}" },
  "midi.pl": { s: "#cb-cookie{display:none !important}" },
  "onedayonly.co.za": {
    s: '#__next > div > div[width*="100%"]{display:none !important}',
  },
  "polygamia.pl": { j: "5" },
  "caymancompass.com": { s: "#s-consent-modal{display:none !important}" },
  "inet.se": { j: "5" },
  "yesty.nl": { s: "#Footer p ~ div:last-child{display:none !important}" },
  "jacobin.de": { s: "#__next > .bottom-0{display:none !important}" },
  "baumer.com": { s: ".notification-modal.consent{display:none !important}" },
  "phdessay.com": { s: ".catfish-banner{display:none !important}" },
  "tommy.hr": { j: "5" },
  "diariovasco.com": { j: "5" },
  "matadornetwork.com": { s: "#tracking-notice{display:none !important}" },
  "videnov.bg": { j: "5" },
  "videnov.gr": { j: "5" },
  "videnov.mk": { j: "5" },
  "videnov.ro": { j: "5" },
  "cashconverters.es": { j: "5" },
  "cashconverters.pt": { j: "5" },
  "lykke.com": { s: 'div[class*="privacy-settings"]{display:none !important}' },
  "dnzb.nl": { c: 168 },
  "pccomponentes.com": { c: 39 },
  "pelando.com.br": { c: 168 },
  "curiositystream.com": { c: 168 },
  "steambackgrounds.com": { c: 168 },
  "deutsche-pop.com": { s: "#ccm{display:none !important}" },
  "stagent.com": { s: 'div[x-show="consent"]{display:none !important}' },
  "lelum.pl": { j: "5" },
  "quae-open.com": { s: "#acceptance_of_cookies{display:none !important}" },
  "kafkas.gr": { j: "5" },
  "bb.com.br": { s: ".bb-cookies{display:none !important}" },
  "gsm55.com": { s: 'div[class*="cookie-module"]{display:none !important}' },
  "dpa.gr": { c: 112 },
  "ikea.com": { j: "5" },
  "maxaro.nl": { c: 69 },
  "mydealz.de": { j: "5" },
  "dealabs.com": { j: "5" },
  "preisjaeger.at": { j: "5" },
  "chollometro.com": { j: "5" },
  "pepper.com": { j: "5" },
  "pepper.pl": { j: "5" },
  "pepper.it": { j: "5" },
  "hotukdeals.com": { j: "5" },
  "lnk.bio": { s: "#pb_cookie_consent{display:none !important}" },
  "eon.pl": { j: "5" },
  "hey.car": { j: "5" },
  "thekrazycouponlady.com": { c: 110 },
  "hella.com": { s: ".black-overlay{display:none !important}" },
  "prowaretech.com": { s: "#warn-cookies{display:none !important}" },
  "avocode.com": { s: "#notification-bar + div{display:none !important}" },
  "apteka911.ua": { c: 2 },
  "deutsches-meeresmuseum.de": { s: ".data-consent{display:none !important}" },
  "ticketfritz.de": { j: "5" },
  "tavex.dk": { j: "5" },
  "tavex.pl": { j: "5" },
  "tavex.fi": { j: "5" },
  "tavex.bg": { j: "5" },
  "tavex.lv": { j: "5" },
  "tavex.se": { j: "5" },
  "tavex.no": { j: "5" },
  "zsroznavska.cz": { s: ".uu5-bricks-cookie-bar{display:none !important}" },
  "filman.cc": { c: 0 },
  "naf.no": { c: 6 },
  "bnb.bg": { s: ".dvCookies{display:none !important}" },
  "bnb.by": { s: ".warning{display:none !important}" },
  "denikreferendum.cz": {
    s: ".PopupBackground,.GDPRPopup{display:none !important}",
  },
  "sevdesk.de": { j: "5" },
  "sevdesk.at": { j: "5" },
  "aerospace.org": { c: 3 },
  "spotic.net": { s: ".App > footer ~ div{display:none !important}" },
  "yourstorebox.com": { j: "5" },
  "50five.com": { j: "5" },
  "ebilet.pl": { j: "5" },
  "theknowledgeacademy.com": { c: 0 },
  "finance-heros.fr": { j: "5" },
  "fichier-pdf.fr": { j: "5" },
  "petit-fichier.fr": { j: "5" },
  "pdf-archive.com": { j: "5" },
  "clubrural.com": { s: "#cookieveil,#cookielegal{display:none !important}" },
  "gen.tr": { s: ".fixed-bottom{display:none !important}" },
  "gewinnabfrage.at": { s: "#CL{display:none !important}" },
  "associationeconomienumerique.fr": {
    j: "5",
    s: "#cmp-settings-button{display:none !important}",
  },
  "deco-et-ambiances.fr": {
    j: "5",
    s: "#cmp-settings-button{display:none !important}",
  },
  "les-aides.fr": { s: "#mask,#consents{display:none !important}" },
  "theinformation.com": { s: "#gdpr-modal-container{display:none !important}" },
  "directpeople.nl": { j: "5" },
  "epochtimes.fr": { j: "5" },
  "epochtimes.de": { j: "5" },
  "hoyoverse.com": {
    s: ".mihoyo-cookie-tips,.cookie-tip{display:none !important}",
  },
  "hoyolab.com": { s: ".mihoyo-cookie-tips{display:none !important}" },
  "traefik.io": { s: ".site-footer ~ div{display:none !important}" },
  "chrono24.de": { j: "5" },
  "chrono24.com": { j: "5" },
  "chrono24.ch": { j: "5" },
  "chrono24.pl": { j: "5" },
  "chrono24.com.gr": { j: "5" },
  "chrono24.fr": { j: "5" },
  "chrono24.co.uk": { j: "5" },
  "chrono24.at": { j: "5" },
  "chrono24.cz": { j: "5" },
  "chrono24.com.tr": { j: "5" },
  "chrono24.it": { j: "5" },
  "chrono24.ca": { j: "5" },
  "chrono24.be": { j: "5" },
  "chrono24.hu": { j: "5" },
  "chrono24.cn": { j: "5" },
  "chrono24.nl": { j: "5" },
  "chrono24.com.au": { j: "5" },
  "chrono24.dk": { j: "5" },
  "chrono24.com.hr": { j: "5" },
  "chrono24.hk": { j: "5" },
  "chrono24.es": { j: "5" },
  "chrono24.mx": { j: "5" },
  "chrono24.se": { j: "5" },
  "chrono24.ro": { j: "5" },
  "chrono24.kr": { j: "5" },
  "chrono24.pt": { j: "5" },
  "chrono24.com.br": { j: "5" },
  "chrono24.com.ar": { j: "5" },
  "chrono24.com.ru": { j: "5" },
  "chrono24.jp": { j: "5" },
  "chrono24.in": { j: "5" },
  "chrono24.fi": { j: "5" },
  "chrono24.no": { j: "5" },
  "chrono24.sk": { j: "5" },
  "chrono24.tw": { j: "5" },
  "chrono24.co.nz": { j: "5" },
  "chrono24.sg": { j: "5" },
  "chrono24.ae": { j: "5" },
  "chrono24.co.za": { j: "5" },
  "chrono24.cl": { j: "5" },
  "chrono24.co.id": { j: "5" },
  "chrono24.my": { j: "5" },
  "chrono24.ph": { j: "5" },
  "chrono24.co.th": { j: "5" },
  "reishunger.de": { c: 6 },
  "openbase.com": {
    s: '#__next [class*="GdprCookieFooter"]{display:none !important}',
  },
  "lavueltaholanda.com": {
    s: ".cookie-prefs-wrapper{display:none !important}",
  },
  "qmee.com": { s: 'div[class*="CookieDialog"]{display:none !important}' },
  "gob.es": {
    s: "#epd,.alert__msg-Wrapper,.tuss-cookies,#fondotransparencia-gris,#avisoUsoCookies,#phAvisoCookie{display:none !important}",
  },
  "unihobby.cz": { s: ".cookies-confirm{display:none !important}" },
  "lawline.se": { s: 'div[class*="CookiesModal"]{display:none !important}' },
  "west-dunbarton.gov.uk": { j: "5" },
  "n8n.io": { s: ".consent_modal{display:none !important}" },
  "plos.org": { c: 6 },
  "vodafone.de": { j: "5" },
  "vodafone.es": { j: "5" },
  "skyperfectjsat.space": { s: ".m-box-policy{display:none !important}" },
  "plaque-immatriculation-auto.com": {
    s: "#rgpd-consent{display:none !important}",
  },
  "in.puma.com": { s: "puma-cookie-banner{display:none !important}" },
  "sfc.com": { j: "5" },
  "dirtsheets.net": { j: "5" },
  "intur.com": { c: 0 },
  "interhyp.de": { j: "5" },
  "reviewsolicitors.co.uk": { c: 0 },
  "zockn.com": { s: "#pandectes-banner{display:none !important}" },
  "guard.io": {
    s: '#gatsby-focus-wrapper > img ~ div[style*="transform"]{display:none !important}',
  },
  "essential.gg": { s: ".c-confirmation{display:none !important}" },
  "mcdonalds.hu": { c: 4 },
  "mcdonalds.si": { j: "5" },
  "ccc.eu": {
    s: ".c-layout_row.is-cookies,#cm-overlay{display:none !important}",
  },
  "ocaso.es": {
    j: "5",
    s: ".modal__container.modal-cookies{display:none !important}",
  },
  "coinmerce.io": { s: ".bottommodal{display:none !important}" },
  "mastersport.cz": { j: "5" },
  "leaseplan.com": { c: 14 },
  "bankiros.ru": { s: ".xxx-cookies-tooltip{display:none !important}" },
  "zabkagroup.com": { j: "5" },
  "sarajevo-airport.ba": { s: ".cp-area{display:none !important}" },
  "maxxis.de": { j: "5" },
  "cac-chem.de": { j: "5" },
  "faircore4eosc.eu": { j: "5" },
  "markantmoebel.de": {
    s: "#cookie-approval,#cookie-approval-revoke{display:none !important}",
  },
  "toyotabank.pl": { j: "5" },
  "privateproperty.co.za": { s: "#consentManager{display:none !important}" },
  "esotravel.cz": { s: "#warning-modal{display:none !important}" },
  "accu.co.uk": { s: 'div[x-data="cookies"]{display:none !important}' },
  "unesc.br": { s: ".lgpd{display:none !important}" },
  "bankera.com": { s: 'div[class*="cookie-module"]{display:none !important}' },
  "book-n-drive.de": {
    j: "5",
    s: ".modal_cookies_and_ga_compliance{display:none !important}",
  },
  "snapchat.com": { j: "5" },
  "youcom.com.br": { s: "#modal_aceiteycpol{display:none !important}" },
  "carscz.eu": { s: "#cookiesI{display:none !important}" },
  "transglobalexpress.co.uk": { s: "#GDPRFooter{display:none !important}" },
  "transglobalexpress.de": { s: "#GDPRFooter{display:none !important}" },
  "findpenguins.com": { j: "5" },
  "ahotu.com": { j: "5" },
  "bancobmg.com.br": { s: ".acceptance-terms{display:none !important}" },
  "prima-obchod.cz": { s: ".wcookies{display:none !important}" },
  "francisetsonami.ch": { j: "5" },
  "lastminute.co.il": { s: ".messages-container{display:none !important}" },
  "alternativestomee6.com": { j: "5" },
  "twitchcon.com": { s: 'div[x-data="gdpr"]{display:none !important}' },
  "vinborsen.se": { j: "5" },
  "displayspecifications.com": { c: 6 },
  "yazio.com": { j: "5" },
  "miui.com": {
    s: '#_navbar ~ .fixed[class*="rounded"]{display:none !important}',
  },
  "smiteproleague.com": { s: ".root > .is-visible{display:none !important}" },
  "topformula.se": { s: ".ca-cookie-consent{display:none !important}" },
  "getsquire.com": { s: "#__next > div:first-child{display:none !important}" },
  "bizkaia.eus": { j: "5" },
  "stihl.com": { j: "5" },
  "huescalamagia.es": { j: "5" },
  "additioapp.com": { s: "#btn-cookies{display:none !important}" },
  "se-ecatalog.ru": { s: ".coockie_box{display:none !important}" },
  "multivia-suite.de": { s: ".standard-dialog{display:none !important}" },
  "bitpanda.com": { s: "bpc-cookie-banner{display:none !important}" },
  "12min.com": { s: "#twlvidck{display:none !important}" },
  "dtvp.de": { c: 30 },
  "tmarket.bg": { j: "5" },
  "payback-ltd.com": {
    s: 'div[class*="cookiesPopUp"]{display:none !important}',
  },
  "elnortedecastilla.es": { j: "5" },
  "gelsia.it": { s: ".cao{display:none !important}" },
  "emailoctopus.com": { j: "5" },
  "teufelaudio.fr": { j: "5" },
  "teufelaudio.at": { j: "5" },
  "teufelaudio.nl": { j: "5" },
  "teufelaudio.pl": { j: "5" },
  "teufelaudio.be": { j: "5" },
  "teufelaudio.es": { j: "5" },
  "teufelaudio.it": { j: "5" },
  "teufelaudio.com": { j: "5" },
  "teufel.de": { j: "5" },
  "teufel.ch": { j: "5" },
  "fredolsen.es": { j: "5" },
  "myprivacy.dpgmedia.nl": { j: "5" },
  "thephoblographer.com": { s: "#nebothemeCookieBar{display:none !important}" },
  "omg.de": {
    s: "#CookiePlus{display:none !important}",
    c: 14,
  },
  "sole-runner.com": {
    s: "#CookiePlus{display:none !important}",
    c: 14,
  },
  "loterija.si": { c: 6 },
  "lefigaro.fr": { j: "5", s: ".fig-consent-banner{display:none !important}" },
  "everywhere.game": {
    s: "main > div > div + div ~ div:last-child{display:none !important}",
  },
  "oneal.eu": { j: "5" },
  "oneal-b2b.com": { j: "5" },
  "worksheetcrafter.com": {
    s: "#cookiesFormContainer{display:none !important}",
  },
  "mobility.ch": { j: "5" },
  "museumsportal-berlin.de": { j: "5" },
  "onatera.com": { j: "5" },
  "beleuchtung.de": { s: ".cookie-setting{display:none !important}" },
  "rode.com": { c: 3 },
  "cpk.com": { j: "5" },
  "sachsen.de": { s: ".privacy-modal,.ld_container{display:none !important}" },
  "lansstyrelsen.se": { j: "5", s: "#widgets_splash{display:none !important}" },
  "stockholmresilience.org": { j: "5" },
  "sentres.com": { j: "5" },
  "cyberpowerpc.com": { s: "#pp_cookie{display:none !important}" },
  "cyberpowersystem.co.uk": {
    s: "#pp_cookie_consent{display:none !important}",
  },
  "lightinthebox.com": { s: ".cookie-allow-confirm{display:none !important}" },
  "keqingmains.com": { j: "5" },
  "myfitnessplace.pl": { s: "#cookies,#backdrop{display:none !important}" },
  "nabrigadu.info": { s: ".c--anim{display:none !important}" },
  "leoni.com": { j: "5" },
  "femundo.de": { s: "#femundo-cookie-bar{display:none !important}" },
  "fundacionvital.eus": { s: "veiss-cookies{display:none !important}" },
  "podchaser.com": {
    s: "#app > div > div:last-child:not(:only-of-type){display:none !important}",
  },
  "bb-portal.mercedes-benz.com": { s: ".mgs-cookie{display:none !important}" },
  "bibliotheque.bordeaux.fr": {
    s: 'div[aria-describedby="message-id"]{display:none !important}',
  },
  "cyu.fr": { s: ".cnil-panel,.hide_click{display:none !important}" },
  "aperitif.no": { s: ".privacy-fixed{display:none !important}" },
  "petcity.lt": { j: "5" },
  "weremember.com": { j: "5" },
  "leo.org": { j: "5" },
  "digimobil.es": {
    s: "#infocookies2,.modal-cookies-warning,.modal-overlay,.modal-cookies-info{display:none !important}",
    c: 14,
  },
  "journalisten.no": {
    s: ".adn-window,.adn-editButton{display:none !important}",
  },
  "ddos-guard.net": { c: 2 },
  "mince.nl": { s: "#sbeu-cookie{display:none !important}" },
  "filescan.io": { c: 2 },
  "kodiko.gr": { j: "5" },
  "only.com": { s: ".overlay-backdrop{display:none !important}" },
  "sj.se": { j: "5" },
  "vitalsource.com": {
    s: '.dismiss-cookie,div[aria-describedby*="CookieBanner"],.App > footer + div[role="dialog"]{display:none !important}',
  },
  "abb.com": { s: '.footer ~ div[style*="fixed"]{display:none !important}' },
  "trincheiramilitar.com": { s: ".gdpr-settings{display:none !important}" },
  "winparts.nl": { j: "5" },
  "winparts.be": { j: "5" },
  "winparts.eu": { j: "5" },
  "winparts.ie": { j: "5" },
  "winparts.fr": { j: "5" },
  "winparts.se": { j: "5" },
  "rammstein.de": { j: "5" },
  "spiele-kostenlos-online.de": { j: "5" },
  "global-wines.cz": { c: 20 },
  "newdaycards.com": {
    s: '#cookie-consents,div[data-testid="page-content"] + div{display:none !important}',
  },
  "anyxvideos.com": { j: "5" },
  "bike24.de": { j: "5" },
  "bike24.fr": { j: "5" },
  "bike24.at": { j: "5" },
  "bike24.it": { j: "5" },
  "bike24.es": { j: "5" },
  "bike24.com": { j: "5" },
  "hosteurope.de": { j: "5" },
  "sehkraft.de": { j: "5" },
  "lenovo.com": {
    s: ".banner_alert,.cookies,.cookie-remind-warpper{display:none !important}",
  },
  "solarlux.com": { j: "5" },
  "jsps.go.jp": { s: ".notepanel{display:none !important}" },
  "amboss.com": { j: "5" },
  "pindi.ee": { s: ".cookie-header{display:none !important}" },
  "pronouns.page": {
    s: ".cc-modal,.modal-shown.d-block{display:none !important}",
  },
  "advantech.com": { c: 6 },
  "merkur.si": { j: "5" },
  "merkur.dk": { j: "5" },
  "theguardian.com": {
    s: 'div[id^="sp_message_container_"]{display:none !important}',
    j: "5",
  },
  "theguardian.com.": {
    s: 'div[id^="sp_message_container_"]{display:none !important}',
    j: "5",
  },
  "kungahuset.se": { j: "5" },
  "id.nl": { j: "5" },
  "lcsc.com": { s: ".v-footer.privacy{display:none !important}" },
  "historyofdatascience.com": { s: ".cookies-holder{display:none !important}" },
  "nio.com": {
    s: 'div[class*="GDPRConsent"],div[class*="GDPRPopup"]{display:none !important}',
  },
  "enscape3d.com": { s: "#backdrop{display:none !important}" },
  "phrase.com": { s: ".gdpr__A{display:none !important}" },
  "rambox.app": { s: "footer ~ .fixed{display:none !important}" },
  "regielive.ro": { s: "#cc-mesaj-box-wrapper{display:none !important}" },
  "thegoodocs.com": { s: ".cookie__form{display:none !important}" },
  "lordicon.com": { c: 0 },
  "ai-ways.eu": { j: "5" },
  "jaki-chippy.co.uk": { j: "5" },
  "eib.org": {
    s: "#eib-popup-policy,.cookies-home_overlay{display:none !important}",
  },
  "paard.nl": { j: "5" },
  "berlinartweek.de": { j: "5" },
  "wannonce.com": { j: "5" },
  "vanmoer.com": { j: "5" },
  "assura.ch": {
    s: "#__next > div[class] > div[display]{display:none !important}",
  },
  "filen.io": { c: 6 },
  "capcut.com": { s: ".lv_cookie_banner-wrapper{display:none !important}" },
  "hyundai.pt": { j: "5" },
  "hyundai.com": { s: ".mainTopBanner{display:none !important}" },
  "hyundai.com.br": { s: ".footertextbox{display:none !important}" },
  "torpedoconnect.de": { j: "5" },
  "dailymotion.com": { j: "5", s: "#consent-group{display:none !important}" },
  "1pmobile.com": { j: "5" },
  "pro-doma.cz": { j: "5" },
  "truthsocial.com": {
    s: '#soapbox > [data-testid="banner"]{display:none !important}',
  },
  "kaptainmusic.com": { j: "6" },
  "voebb.onleihe.de": { j: "6" },
  "prosciutteriasandaniele.it": {
    s: "#page_hider{display:none !important} body{overflow-y: unset !important}",
  },
  "schobuell-wetter.de": { c: 4 },
  "yellow.systems": { j: "3" },
  "withings.com": { c: 85 },
  "larrychenphoto.com": { j: "6" },
  "fostertechnologies.pl": { c: 0 },
  "schlauer-shop24.de": { j: "3" },
  "gbnews.uk": { j: "3" },
  "maisonstandards.com": {
    s: ".popin_consent{display:none !important} overlay_full_screen{display:none !important}",
  },
  "notify.events": { j: "6" },
  "pricewise.nl": { j: "6" },
  "apotheke-villingen.de": {
    s: "#elementor-popup-modal-710{display:none!important}",
  },
  "pngwebicons.com": { s: "#myModal{display:none!important}" },
  "lokalplus.nrw": { j: "6" },
  "passadena.gr": { c: 6 },
  "cleantalk.org": { s: "#uses_c{display:none !important}" },
  "holmasto.fi": { s: "gds-consent-manager{display:none !important}" },
  "dafy-moto.com": { j: "5" },
  "daim-schokolade.de": { s: "allow-cookies{display:none !important}" },
  "picwish.com": { s: "#cookies-win{display:none !important}" },
  "publishwhatyoufund.org": { c: 0 },
  "rcwilley.com": { s: "#rcDrawer{display:none !important}" },
  "bigfishgames.com": { s: ".ReactModalPortal{display:none !important}" },
  "elektro-plus.com": { s: ".consent-overlay{display:none !important}" },
  "pokalkoenig.de": {
    s: "#cookie-permission-modal{display:none !important}",
    c: 14,
  },
  "wifikaernten.at": { j: "6" },
  "tenis.net": { c: 0 },
  "dimotisnews.gr": { s: ".cc_obx{display:none !important}" },
  "jegveremklima.hu": {
    s: ".jegverem-cookie-wrapper{display:none !important}",
  },
  "cpia1.roma.it": { c: 0 },
  "agazeta.com.br": { s: ".notification-footer{display:none !important}" },
  "pisoscentro.com": { c: 0 },
  "hintertuxergletscher.at": { j: "6" },
  "pornorama.com": { j: "5" },
  "xvideos.es": { j: "5" },
  "xvideos.com": { j: "5" },
  "xnxx.com": { j: "5" },
  "worktop-express.de": { c: 85 },
  "palmangels.com": { j: "3" },
  "innerengineering.com": {
    s: ".MuiSnackbar-anchorOriginBottomCenter{display:none !important}",
  },
  "animeschedule.net": { s: ".custom-consent-popup{display:none !important}" },
  "hayloft.co.uk": { s: ".cookieControl{display:none !important}" },
  "goetel.de": { s: ".cookieControl{display:none !important}" },
  "sbt.siemens.com": { s: "#CookieDiscl{display:none !important}" },
  "ems.press": {
    s: 'section[aria-labelledby*="analytics-consent"]{display:none !important}',
  },
  "spigen.com": { s: ".pd-cookie-banner-window{display:none !important}" },
  "fizyka.org": { s: "#pp{display:none !important}" },
  "tusclasesparticulares.com": { s: "#pp{display:none !important}" },
  "edywerder.ch": { s: ".kadence-conversion-banner{display:none !important}" },
  "xxxlutz.at": { j: "5" },
  "xxxlutz.de": { j: "5" },
  "xxxlutz.ch": { j: "5" },
  "xxxlutz.hu": { j: "5" },
  "xxxlutz.cz": { j: "5" },
  "moemax.at": { j: "5" },
  "moemax.hu": { j: "5" },
  "moemax.de": { j: "5" },
  "moemax.ch": { j: "5" },
  "moebelix.at": { j: "5" },
  "moebelix.cz": { j: "5" },
  "moebelix.sk": { j: "5" },
  "moebelix.de": { j: "5" },
  "xxxlesnina.si": { j: "5" },
  "moemax.hr": { j: 5 },
  "moemax.ro": { j: 5 },
  "moebelix.hu": { j: 5 },
  "xxxlesnina.hr": { j: 5 },
  "xxxlesnina.rs": { j: 5 },
  "amara.org": {
    s: ".cookie-consent-cover{display:none !important} body{overflow: unset!important}",
  },
  "imobiliariabaron.com.br": { s: ".sc-eyulwr-0{display:none !important}" },
  "ciaoflorence.it": { c: 4 },
  "berocca.com.au": { c: 85 },
  "geogra.ro": { s: "#popup-bottom{display:none !important}" },
  "bbg.gv.at": {
    s: ".guglercookies{display:none !important}.focustrap{overflow:unset!important}",
  },
  "search.brave.com": { s: "#usage-metrics #notice{display:none !important}" },
  "cleverdirekt.de": { s: ".privacyBackground{display:none !important}" },
  "meteoradar.com": { s: "#closeonaction{display:none !important}" },
  "deporteam.es": { s: "#garrampa-cookienotice{display:none !important}" },
  "augsburger-allgemeine.de": { j: "5" },
  "dualuniverse.game": { j: "6" },
  "evertiq.com": { j: "6" },
  "kaidee.com": { j: "6" },
  "benchmark.pl": { j: "5" },
  "huffingtonpost.fr": {
    j: "6",
    s: ".popin-gdpr-no-scroll{overflow: unset!important} .gdpr-hfp-wall{display:none !important}",
  },
  "cowiiaccess.deltekenterprise.com": {
    s: "dm-cookie-consent{display:none !important}",
  },
  "sparda-h.de": {
    s: ".darken-layer.open,.lightbox--cookie-consent{display:none !important}body.no-scroll{position:unset!important}",
  },
  "wunderkind-custom.com": {
    j: "5",
    s: ".wd-consent{display:none !important}",
  },
  "gamers.si": { c: 112 },
  "parfimo.ro": { j: "3" },
  "creopard.de": { j: "6" },
  "belenergy.com.br": { c: 0 },
  "brikett-rekord.com": {
    s: ".modal-backdrop{display:none !important}",
    c: 85,
  },
  "coquedetelephone.fr": { j: "3" },
  "de-vogel.nl": { j: "6" },
  "huizenzoeker.nl": { j: "6" },
  "itau.com.br": { s: ".marco-civil-container{display:none !important}" },
  "nordvpn.com": {
    s: ".CookieConsentExperiment,.CookieConsentV2{display:none !important}",
  },
  "jw.org": { s: ".lnc-firstRunPopup{display:none !important}" },
  "dndbeyond.com": { j: "6" },
  "commanderspellbook.com": { s: ".border-b-2{display:none !important}" },
  "education.lego.com": { j: "6" },
  "bonobology.com": { s: ".dialog-widget-content{display:none !important}" },
  "bodypak.pl": { s: ".pop-cookiebox{display:none !important}" },
  "beurer.se": { j: "6" },
  "arsys.es": { s: 'div[name="cookies"]{display:none !important}' },
  "swb-busundbahn.de": { c: 85 },
  "uni-mozarteum.at": { j: "6" },
  "simplywebshop.de": { j: "6" },
  "tyma.eu": { j: "6" },
  "crown.com": { j: "6" },
  "seznam.cz": { s: ".scmp_noscroll{overflow:unset !important}" },
  "kumori.com.br": {
    s: 'div[data-controller="aviso-cookies"]{display:none !important}',
  },
  "xoxo-mobile.at": { j: "6" },
  "guideme.me": { s: "#pameto{display:none !important}" },
  "panduit.com": { s: ".panduit-cookie-banner{display:none !important}" },
  "edziennik.bialystok.uw.gov.pl": {
    s: ".is-show-cookie{display:none !important}",
  },
  "go-e.com": { j: "5" },
  "monsitemedia.fr": { j: "5" },
  "arlettie.com": {
    s: "#___smooth > div > .sui-grid{display:none !important}",
  },
  "fandor.com": { c: 100 },
  "poco.de": { c: 28 },
  "waidhofen.at": { j: "5" },
  "mein-lehrbetrieb.at": { j: "5" },
  "infranken.de": { j: "5" },
  "partenamut.be": { j: "5" },
  "moreysa.com": { s: "#sdgdpr_modal_wrapper{display:none !important}" },
  "youngcourtesans.com": { s: ".cookie-request{display:none !important}" },
  "dirtyflix.com": { s: ".cookie-request{display:none !important}" },
  "riscocloud.com": { s: "rc-cookies-alert{display:none !important}" },
  "kontorsmaterial.se": {
    s: 'body > div[id^="cbck"]{display:none !important}',
  },
  "braze.com": { s: ".opt-in--background{display:none !important}" },
  "2gis.cz": { s: "#confirm + div{display:none !important}" },
  "joinhoney.com": {
    s: 'div[class*="cookieConsentBanner"]{display:none !important}',
  },
  "backmarket.com": { j: "5" },
  "backmarket.fr": { j: "5" },
  "backmarket.de": { j: "5" },
  "backmarket.it": { j: "5" },
  "backmarket.es": { j: "5" },
  "backmarket.be": { j: "5" },
  "backmarket.at": { j: "5" },
  "backmarket.fi": { j: "5" },
  "backmarket.pt": { j: "5" },
  "backmarket.se": { j: "5" },
  "backmarket.gr": { j: "5" },
  "backmarket.nl": { j: "5" },
  "backmarket.co.uk": { j: "5" },
  "hejfish.com": { s: 'div[class*="CookieConsent"]{display:none !important}' },
  "gamefound.com": {
    s: 'div[data-qa*="cookie-policy-box"]{display:none !important}',
  },
  "ionos.de": { j: "5" },
  "ionos.fr": { j: "5" },
  "ionos.at": { j: "5" },
  "swedbank.se": { j: "5" },
  "swedbank.lv": { j: "5" },
  "swedbank.lt": { j: "5" },
  "swedbank.com": { j: "5" },
  "soignez-moi.ch": { s: ".gdpr-container{display:none !important}" },
  "mercusys.com": { s: "#mercusys-cookie{display:none !important}" },
  "kb-home.nl": { j: "5" },
  "membean.com": { c: 0 },
  "designmynight.com": { j: "5" },
  "gmx.ch": { j: "5" },
  "gmx.at": { j: "5" },
  "gmx.net": { j: "5" },
  "web.de": { j: "5" },
  "onleihe.de": { c: 14 },
  "onleihe.com": { j: "5" },
  "fufunovel.com": { s: "#gnews-pro-cookie-ify{display:none !important}" },
  "akari46.blogspot.com": { s: "#xix0op-cookies{display:none !important}" },
  "mamabartka.blogspot.com": { s: "#pierwszy{display:none !important}" },
  "posta.sk": {
    s: 'iframe[src*="cookies-consents/dialog/sk"]{display:none !important}',
  },
  "trickyoldteacher.com": { c: 2 },
  "fuckpassvr.com": { s: ".blog-cookie{display:none !important}" },
  "hobby.porn": { s: ".sgdpr-box{display:none !important}" },
  "zurueckzumursprung.at": { j: "5" },
  "gx.games": { j: "5" },
  "analog.com": { j: "5" },
  "happysocks.com": { j: "5" },
  "mediaset.it": { j: "5" },
  "nepszamlalas2022.hu": { s: ".offcanvas-bottom{display:none !important}" },
  "commentcoder.com": {
    s: 'div[class*="gdpr__Modal"]{display:none !important}',
  },
  "nablawave.com": { j: "5" },
  "esm-computer.de": { j: "5" },
  "carsized.com": { s: "body > center ~ center{display:none !important}" },
  "mycards.hdfcbank.com": {
    s: '.hdfc-page > div[style*="center"]{display:none !important}',
  },
  "stromnetz-hamburg.de": { j: "5" },
  "bol.com": { j: "5" },
  "unigine.com": { s: ".bottom-notice{display:none !important}" },
  "healthline.com": { j: "5" },
  "gruene-bundestag.de": { s: ".cn-wrapper{display:none !important}" },
  "erp-up.de": { j: "5" },
  "sbb-deutschland.de": { j: "5" },
  "netz-noe.at": { j: "5" },
  "qualenergia.it": { s: "#cookies-win{display:none !important}" },
  "reolink.com": { s: 'div[class*="cookie-popup"]{display:none !important}' },
  "chaincheck.de": { s: "#float-bar{display:none !important}" },
  "sofort.com": { s: "#Cookietext{display:none !important}" },
  "meta.com": { j: "5" },
  "kurzurlaub.at": { j: "5" },
  "kurzurlaub.de": { j: "5" },
  "sicherheitsdienst-harz.de": { s: "#cookieBs{display:none !important}" },
  "sdaa-france.com": { s: "#cc-bar{display:none !important}" },
  "bilibili.tv": { s: ".bstar-cookie-info{display:none !important}" },
  "forbo.com": { j: "5" },
  "studocu.com": {
    s: "#main-wrapper ~ div > .undefined{display:none !important}",
  },
  "lda-portal.siemens.com": { j: "5" },
  "mitarbeiteraktionen.de": { j: "5" },
  "falter.at": { j: "5" },
  "bulk.com": { j: "5" },
  "slupsk.eu": {
    s: 'body > div > div[style*="182968"],body > #cookies{display:none !important}',
  },
  "whatismymovie.com": { j: "5" },
  "corriere.it": { s: ".tp-modal.manine-modal{display:none !important}" },
  "video.corriere.it": { j: "5" },
  "fxhome.com": {
    s: '.elementor-location-footer[data-elementor-type="section"],section[class*="cookiesContainer"]{display:none !important}',
  },
  "wearmedicine.com": { j: "5" },
  "esports.com": { j: "5" },
  "joyn.de": { j: "5" },
  "prosieben.de": { j: "5" },
  "optoma.co.uk": { s: "#msgbg{display:none !important}" },
  "optoma.com": {
    s: "#optomaCookieWrap,.cookieBackgaround{display:none !important}",
  },
  "dreamersforum.nl": { s: "#cookiewarning_header{display:none !important}" },
  "piensasolutions.com": {
    s: '.drop[name="cookies"]{display:none !important}',
  },
  "journal.hr": { j: "5" },
  "open-broker.ru": {
    s: 'div[class*="CookieDisclaimer"]{display:none !important}',
  },
  "crossfit.com": {
    s: '#app ~ #modal,#globalMenu ~ div[style*="fixed"]{display:none !important}',
  },
  "pretto.fr": { j: "6" },
  "biscuiteers.com": { j: "5" },
  "oliverbonas.com": { j: "5" },
  "gen-i.si": { s: ".cookie,.cookies_new{display:none !important}" },
  "hrw.org": { s: "#hrw-cookie-dialog{display:none !important}" },
  "agar.io": { s: ".mc-cookiebar{display:none !important}" },
  "telesec.de": { j: "5" },
  "easyphp.org": { j: "5" },
  "systembolaget.se": { j: "5" },
  "filmmusic.io": { j: "5" },
  "blix.gg": { j: "5" },
  "startmail.com": { s: "#__main ~ .banner{display:none !important}" },
  "tropter.com": { s: ".tropter-cookiesbar{display:none !important}" },
  "play.hbomax.com": { j: "5" },
  "jackjones.com": { j: "5" },
  "razer.com": {
    s: ".tos-razer-js,#tos-razer,.component-sticky-dialog{display:none !important}",
  },
  "luxuryalleydessous.com": { j: "5" },
  "la-brodeuse.com": { j: "5" },
  "toothbrushbattery.com": {
    s: ".woocommerce-store-notice{display:none !important}",
  },
  "retevis.eu": { s: ".woocommerce-store-notice{display:none !important}" },
  "retevis.info": { s: ".woocommerce-store-notice{display:none !important}" },
  "nederlandseloterij.nl": { j: "5" },
  "kapodistrias-tyres.com.cy": { s: "#vlcookies_box{display:none !important}" },
  "stadtmobil.de": { s: ".CybotEdge{display:none !important}" },
  "gov.nl": { s: 'div[data-ui-test="cookieAlert"]{display:none !important}' },
  "evri.com": { j: "5" },
  "rejoy.hu": { j: "5" },
  "pimido.com": { j: "5" },
  "etudes-et-analyses.com": { j: "5" },
  "c24.de": { c: 105 },
  "routedurhum.com": {
    s: 'div[aria-describedby="cookie-box-message"]{display:none !important}',
  },
  "bonn.de": { s: ".SP-ConsentBanner__spacer{display:none !important}" },
  "manduka.com": { j: "5" },
  "meliuz.com.br": { s: ".cookies-c{display:none !important}" },
  "dhbbank.de": { j: "5" },
  "lhotellerie-restauration.fr": {
    s: "#cookieConsent{display:none !important}",
  },
  "rawpixel.com": {
    s: 'div[data-test-id="check-cookie-consent"]{display:none !important}',
  },
  "csob.sk": { j: "5" },
  "vigo.de": { s: ".wx_consentbanner{display:none !important}" },
  "tallink.com": { j: "5" },
  "samsung.com": {
    s: ".helptips__container,#cookie_component{display:none !important}",
    j: "5",
  },
  "dier-en-dokter.nl": { j: "5" },
  "saurclient.fr": {
    s: "#cookies,.sds-m-cookiebanner{display:none !important}",
  },
  "posylka.de": { j: "5" },
  "europa.eu": {
    s: "#edp-cookies-banner,.customCookie{display:none !important}",
    j: "5",
  },
  "soundsmag.com": {
    s: "#lepopup-popup-23,#lepopup-popup-23-overlay{display:none !important}",
  },
  "stihl.de": { s: "body,#__next{overflow: unset !important}" },
  "drouwenerzand.nl": { s: ".js-fever-cookies{display:none !important}" },
  "tourisme-lodevois-larzac.fr": { j: "5" },
  "fakenewsfrance.com": {
    s: "#js-cc-modal{display:none !important} html{overflow-y: unset !important}",
  },
  "123inkt.nl": {
    s: '.simple-popup-container[data-action="CookiePopup"]{display:none !important}',
  },
  "123tinta.es": {
    s: '.simple-popup-container[data-action="CookiePopup"]{display:none !important}',
  },
  "beruby.com": { s: "#box-shadow{display:none !important}" },
  "arche.net": {
    s: "#cookieModal{display:none !important}",
    c: 14,
  },
  "scaleway.com": { j: "6" },
  "fresh-pool.de": { c: 14 },
  "vakin.se": {
    s: 'div[data-testid="modal-backdrop"],.sv-cookie-consent-modal{display:none !important} body{overflow: unset !important; position: unset !important}',
  },
  "deckardpenfield.com": { j: "6" },
  "ostfriesische-brandkasse.de": { j: "6" },
  "shop.zoo-leipzig.de": { j: "6" },
  "elektronik-lavpris.dk": { j: "6" },
  "yes2move.com": { c: 0 },
  "zugportal.de": { j: "3" },
  "swiss.com": { j: "5" },
  "befirst.info": { s: ".p-cookies{display:none !important}" },
  "cleveroad.com": { s: ".bZ_vx{display:none !important}" },
  "etiskarna.si": { s: ".cookie__content{display:none !important}" },
  "solvimus.de": { j: "6" },
  "archerresourcing.co.uk": { j: "6" },
  "plateuptools.com": { j: "5" },
  "roland-rechtsschutz.de": { j: "5" },
  "honda.co.za": { c: 0 },
  "dlive.tv": { j: "5" },
  "aviyel.com": { s: "#av_cookie_pref{display:none !important}" },
  "snwa.com": { c: 20 },
  "ecobikecompany.com": { s: ".cookie-model{display:none !important}" },
  "beste-badstudios.de": { s: ".do-cookie-notice{display:none !important}" },
  "lvvwd.com": { c: 20 },
  "avax.network": { s: ".analytics_item{display:none !important}" },
  "cteasy.com": { c: 14 },
  "marcos.com": { s: ".policy-alert{display:none !important}" },
  "pravniprostor.cz": {
    s: ".CookiesNoticestyle__Wrapper-sc-1vzpzm5-0{display:none !important}",
  },
  "bev.gv.at": {
    s: 'div[class="MuiBox-root css-1z0mgm7"]{display:none !important}',
  },
  "candis.io": { j: "6" },
  "kauppakeskuswilla.fi": {
    s: ".cdk-global-overlay-wrapper{display:none !important}",
  },
  "hd.digital": {
    s: "body{overflow: unset !important}",
    c: 14,
  },
  "parkside-interactive.com": {
    s: "#SirPauls-cookie{display:none !important}",
  },
  "scienceinsport.com": {
    s: 'aside[data-role="gdpr-cookie-container"]{display:none !important}',
  },
  "knowunity.fr": {
    s: 'div[data-cy="cookie-banner"]{display:none !important}',
  },
  "batna24.com": { s: "#CookieSnackbar{display:none !important}" },
  "kalahariresorts.com": { s: ".c-dialog-cookie{display:none !important}" },
  "nationalgeographicla.com": {
    s: ".cookie-footer__placeholder, .cookie-footer{display:none !important}",
  },
  "seekube.com": { s: "._1AsHk{display:none !important}" },
  "smart.com": { j: "6" },
  "mesdroitssociaux.gouv.fr": { c: 49 },
  "remarkable.com": { s: 'div[data-cy="cookiebar"]{display:none !important}' },
  "accu-components.com": {
    s: 'div[x-data="cookies"]{display:none !important}',
  },
  "penlab.ink": {
    s: 'div[uid="aec8beb2-be85-4d15-86db-11a1a7cdc6c2"]{display:none !important}',
  },
  "lufthansa.com": { s: "#__tealiumGDPRcpPrefs{display:none !important}" },
  "eneba.com": {
    s: "#app > footer ~ div, main > div + div + div:last-child{display:none !important}",
  },
  "kampanje.com": { s: ".adn-window{display:none !important}" },
  "wassererleben.ch": { s: ".static{overflow-y: unset !important}" },
  "cryptomaan.eu": { s: ".bottom-0{display:none !important}" },
  "dotnetconf.net": { c: 6 },
  "wenance.com": { s: ".js-consent{display:none !important}" },
  "leer.com": { s: ".nine-gdpr{display:none !important}" },
  "aroma.cz": { s: "#lista-cookies{display:none !important}" },
  "pzkosz.pl": { s: ".zgoda_na_przetwarzanie{display:none !important}" },
  "kei.pl": { j: "6" },
  "blim.com": {
    s: "#blim-header > blim-header-message:first-child{display:none !important}",
  },
  "regiojethotels.com": { s: "div.fixed{display:none !important}" },
  "laeckerli-huus.ch": { s: "#ds_cookiebar{display:none !important}" },
  "la-vie-naturelle.com": {
    s: ".ea-cookies-popin{display:none !important} body{overflow: unset !important}",
  },
  "mairie-blagnac.fr": { s: "#rgpdOverlay{display:none !important}" },
  "elialocardi.com": { s: ".sm-cookie-consent{display:none !important}" },
  "sergas.gal": {
    s: "#cookies-notices-container,.cookies-policy{display:none !important}",
  },
  "click-learn.de": {
    s: "#ccm-widget{display:none !important} .ccm-blocked{overflow: unset !important}",
  },
  "lernenundhelfen.de": { s: "#cookie-layer{display:none !important}" },
  "classicalarchives.com": { s: ".Cdiv{display:none !important}" },
  "bitso.com": { s: "#__next > div + div{display:none !important}" },
  "flaixfm.cat": { s: ".popup_bg{display:none !important}" },
  "lasseron-associes.com": { s: "#rgpd-background{display:none !important}" },
  "auctioneve.com": { s: "#rgpd-background{display:none !important}" },
  "just-mining.com": { s: ".cookieAcceptationModule{display:none !important}" },
  "esto.eu": { s: ".modal-coockies{display:none !important}" },
  "regiojet.com": { s: ".fixed{display:none !important}" },
  "obuvki.bg": {
    s: "#marketing-approvals{display:none !important} ._no-scroll-modal{position: unset !important}",
  },
  "freemap.sk": { c: 100 },
  "nuessing.de": { c: 14 },
  "dovolena.cz": { s: ".Cookies_wrapper__ovIeZ{display:none !important}" },
  "eberry.cz": { s: ".c-cookie-consent-bar{display:none !important}" },
  "els.spb.ru": { s: "#client-cookies-notice{display:none !important}" },
  "puravita.ch": {
    s: ".modals-wrapper{display:none !important} ._has-modal{overflow: unset !important}",
  },
  "cmteb.ro": {
    s: "#InfoPD{display:none !important} .modal-backdrop{position: unset !important}",
    c: 14,
  },
  "ludonauta.es": { c: 14 },
  "oponeo.co.uk": {
    s: "body > form + div{display:none !important} .noScroll{overflow: unset !important}",
  },
  "herbata.info": { s: "#elementor-popup-modal-3197{display:none !important}" },
  "gouv.qc.ca": { s: ".notifier--consent{display:none !important}" },
  "grandprixradio.nl": {
    s: ".cookies-popup-dialog,.cookies-popup-background{display:none !important}",
  },
  "selexium.com": {
    s: "#coolkiesModale{display:none !important}",
    c: 14,
  },
  "xsolla.com": { s: "#gdpr-consent-form{display:none !important}" },
  "mattel163.com": { s: ".use-cookie{display:none !important}" },
  "bs-energy.de": {
    s: ".modal{display:none !important}",
    c: 14,
  },
  "astroportal.com": {
    s: "#plusgate{display:none !important} body{overflow: unset !important}",
  },
  "glinche-automobiles.com": { s: "#user-consent{display:none !important}" },
  "turkishbank.co.uk": {
    s: ".ulp-overlay,.ulp-window{display:none !important}",
  },
  "shop.canariassmart.com": { c: 60 },
  "cupper-teas.de": { s: "body._has-modal{overflow:unset !important}" },
  "business.whatsapp.com": {
    s: 'div[data-testid="wa_cookies_banner_modal"]{display:none !important} body.hasCookieBanner,._ab-4{overflow-y:unset !important}',
  },
  "imax.cn": { s: ".ly_cookie{display:none !important}" },
  "le106.com": {
    s: ".lwt-popup{display:none !important} body[data-lwt-popup] #wrapper{filter: unset!important}",
  },
  "climshop.com": { c: 0 },
  "diners.hr": { c: 85 },
  "kriminalita.policie.cz": { j: "6" },
  "brightfm.com": { s: ".zn-cookies{display:none !important}" },
  "gibson.com": { c: 111 },
  "mypikpak.com": { s: ".cookie-tip{display:none !important}" },
  "confcommercio.it": {
    s: ".cookieInterceptorWrapper{display:none !important}",
  },
  "elearningindustry.com": { j: "6" },
  "supraphonline.cz": {
    s: 'div[style*="position: fixed; bottom: 0;"]{display:none !important}',
  },
  "theweather.net": {
    s: "#gpdr{display:none !important} body{position: unset !important}",
  },
  "pacificpower.net": { s: "wcss-cookie-banner{display:none !important}" },
  "encazip.com": { s: ".eHzdtJ{display:none !important}" },
  "thomas-elliott.co.uk": { c: 0 },
  "landrover.co.jp": { s: ".notificationBarsWrapper{display:none !important}" },
  "lupine.de": { c: 6 },
  "nylander.no": {
    s: ".v-dialog__content,.v-overlay{display:none !important}",
  },
  "alecu.org": { s: '[data-name="gdpr"]{display:none !important}' },
  "bodenaturkost.de": { s: "body > div{display:none !important}" },
  "radionikkei.jp": { s: ".cookie-consent-wrap{display:none !important}" },
  "nikkeimm.co.jp": { s: ".c-cookiePolicy{display:none !important}" },
  "nikkei-r.co.jp": { s: ".c-cookiePolicy{display:none !important}" },
  "smtb.jp": { s: ".unq-cookie{display:none !important}" },
  "tokyostarbank.co.jp": { s: "#floatArea{display:none !important}" },
  "yamagatabank.co.jp": { c: 3 },
  "riksbyggen.se": { c: 110 },
  "museum-brandhorst.de": { c: 65 },
  "doratoon.com": { c: 167 },
  "enseignement.catholique.be": {
    s: ".cookies-law-info{display:none !important}",
  },
  "koempf24.de": { s: 'div[x-data^="cookieConsent"]{display:none !important}' },
  "astrid.tech": {
    s: 'div[style^="width: 100vw; position: fixed; bottom: 0px"]{display:none !important}',
  },
  "latoquedor.com": { j: "6" },
  "performancefoodservice.com": {
    s: ".tracking-consent-banner{display:none !important}",
  },
  "imaxchina.com": { s: ".ly_cookie{display:none !important}" },
  "icanw.org": { c: 8 },
  "esimplus.me": { s: "#App > :first-child{display:none !important}" },
  "repubblica.it": { s: "#iubenda-cs-banner{display:none !important}" },
  "arduino.cc": { s: "#iubenda-cs-banner{display:none !important}" },
  "terre-des-seniors.fr": { s: "#valid-cookies{display:none !important}" },
  "oponeo.it": {
    s: "body > div{display:none !important} .noScroll{overflow: unset !important}",
  },
  "meteoprog.com": { c: 17 },
  "ridex.eu": { s: ".block-cookies{display:none !important}" },
  "dsw.nl": { s: "mijn-cookie-consent{display:none !important}" },
  "taste-market.de": {
    s: ".is-modal{display:none !important} .no-scroll{overflow: unset !important}",
    c: 14,
  },
  "dayspedia.com": { c: 161 },
  "junodownload.com": { s: "#juno-cookie-consent{display:none !important}" },
  "comparethemarket.com": {
    s: "#__tealiumGDPRcpPrefs{display:none !important}",
  },
  "lamnia.com": { s: ".cookie-background{display:none !important}" },
  "payhawk.com": { s: ".wookiee-wrapper{display:none !important}" },
  "apfelpage.de": {
    s: "#ccm-widget{display:none !important} .ccm-blocked{overflow: unset !important}",
  },
  "inlingua-muenchen.de": {
    s: "#ccm-widget{display:none !important} .ccm-blocked{overflow: unset !important}",
  },
  "airteam.eu": { c: 14 },
  "jeancoutu.com": { c: 6 },
  "paulus.com.br": {
    s: "#loader-overlay,.vtex-modal-layout-0-x-modal{display: none !important} .vtex-modal-layout-0-x-hiddenContainer{overflow: unset !important}",
  },
  "gotenehus.se": {
    s: "#duva_cc-banner,#duva_cc-banner-backdrop{display:none !important}",
  },
  "daskannwas.ch": { c: 167 },
  "cosmosdirekt.de": { c: 85 },
  "middlesexccc.com": {
    s: 'div[aria-describedby="modalContent"],.ui-widget-overlay{display:none !important}',
  },
  "anundos.com": {
    s: "#cc--main{display:none !important}",
    c: 85,
  },
  "tab.digital": { j: "6" },
  "cibeg.com": { c: 0 },
  "jazzkeller69.de": {
    s: "#jkjazzBackground, #jkjazzWidget{display:none !important}",
  },
  "autoefl.pl": { s: ".modal-legal{display:none !important}" },
  "pharminfo.fr": {
    s: ".NavigationTracker__container{display:none !important}",
  },
  "komkompro.com": {
    s: ".gb-global-scrollblock{overflow:unset !important}",
    c: 49,
  },
  "centres-vaccination.fr": {
    s: ".modal-backdrop{display:none !important} .modal-open{overflow:unset !important}",
    c: 111,
  },
  "livelarq.com": { s: "#__next > :last-child{display:none !important}" },
  "sabi-online.at": { c: 106 },
  "wentworthpuzzles.com": { s: "privacy-settings{display:none !important}" },
  "fitzandhuxley.com": {
    s: "#gdpr-blocking-page-overlay{display:none !important}",
  },
  "azslides.com": {
    s: ".altumcode-cookie-notification-wrapper{display:none !important}",
  },
  "filen.io": {
    s: ".chakra-toast__inner > :first-child{display:none !important}",
  },
  "dkkk.co.jp": { s: ".p-cookieBox{display:none !important}" },
  "manda.co.jp": { c: 3 },
  "ymir.co.jp": { s: ".cookie_area{display:none !important}" },
  "copyright.com": { s: ".site-wide-notice--gdpr{display:none !important}" },
  "creaform3d.com": { s: ".gpdr-agreement{display:none !important}" },
  "criminalip.io": {
    s: '[class^="CookiePolicyAgreementsPopup"]{display:none !important}',
  },
  "cryoutcreations.eu": {
    s: "#cryout-cookies-notification{display:none !important}",
  },
  "daidan.co.jp": { s: ".p-gdpr{display:none !important}" },
  "dbschenker-seino.jp": {
    s: ".dialog--open{display:none !important} .no-scroll--dialog-open{overflow:unset !important}",
  },
  "delta.exchange": { s: ".de-footer__cookie{display:none !important}" },
  "designs.ai": { c: 47 },
  "dfi.com": { s: "#gdrp-wrapper{display:none !important}" },
  "dic-kikin.or.jp": { s: ".footer-gdpr{display:none !important}" },
  "dynacw.co.jp": { s: "#GDPR_warning{display:none !important}" },
  "elleair.jp": { s: ".tf-cookiePolicyModal{display:none !important}" },
  "epidemicsound.com": { s: "#es-consent{display:none !important}" },
  "festo.com.cn": {
    s: '[class^="overlay"]{display:none !important} [class*="hide-overflow"]{overflow:unset !important}',
  },
  "figshare.com": { s: "header > :first-child{display:none !important}" },
  "nmsu.edu": { s: ".bottom-0{display:none !important}" },
  "fincity.tokyo": { c: 47 },
  "ferrotec.co.jp": { s: ".policyFix{display:none !important}" },
  "framer.com": { s: ".cy-cookieBanner{display:none !important}" },
  "freeromsdownload.com": {
    s: "#kuk{display:none !important} .modal-open{overflow:unset !important}",
  },
  "gctengine.co.jp": { s: ".wrap_cookie{display:none !important}" },
  "guerbet.com": { s: '[class*="cookie-banner"]{display:none !important}' },
  "lilac.co.jp": { s: "#ft_privacy{display:none !important}" },
  "hicbc.com": { s: "#optInfo{display:none !important}" },
  "honeys-onlineshop.com": { s: "#policy_modal{display:none !important}" },
  "hyojito.co.jp": { s: "#agreement-area{display:none !important}" },
  "hyundai.mu": { s: ".cookiePolicyAgreement{display:none !important}" },
  "incyte.jp": { s: "#topHeader > :first-child{display:none !important}" },
  "internationalmedicalcorps.org": {
    s: ".cookie__callout{display:none !important}",
  },
  "mamastar.jp": { s: "#personalInfo{display:none !important}" },
  "jaa.or.jp": { s: "#js-gdpr{display:none !important}" },
  "jasis.jp": { s: "#agreePanel{display:none !important}" },
  "jbpo.or.jp": { s: "#c_policy_wrap{display:none !important}" },
  "jpfbs.com": { s: ".cook-popup{display:none !important}" },
  "jpsearch.go.jp": { s: ".jps-privacy-confirmation{display:none !important}" },
  "jti.co.jp": { s: ".p-top_cookie-agreement{display:none !important}" },
  "juken-mikata.net": { s: "#cookieAlt{display:none !important}" },
  "kaigolink.com": {
    s: '[class^="CookiePanel__Panel"]{display:none !important}',
  },
  "kankocho.jp": {
    s: ".v-snack__wrapper.theme--light{display:none !important}",
  },
  "kureha.co.jp": { s: ".cookie_block{display:none !important}" },
  "porrima.org": { s: ".cookie_block{display:none !important}" },
  "kyounoryouri.jp": { s: ".swal2-popup{display:none !important}" },
  "labsnews.com": { s: ".modal__policy{display:none !important}" },
  "legoschool.jp": { s: "#cookie-config{display:none !important}" },
  "linkfly.to": { s: ".linkfly-ctx-notification{display:none !important}" },
  "lintec.co.jp": { s: "#FooterPolicy{display:none !important}" },
  "tomtop.com": {
    s: '.m_privacy_statement,[name="confirm2"]{display:none !important}',
  },
  "manga-yomeru.com": { s: "#tc_cookie_opt{display:none !important}" },
  "manychat.com": {
    s: '[class^="CookieBumper_wrap"]{display:none !important}',
  },
  "marubun.co.jp": { s: ".l-cookie-consent-popup{display:none !important}" },
  "maruchiba.jp": { s: "#tmp_wrap_main{display:none !important}" },
  "microjet.com.tw": { s: "#ck_footer{display:none !important}" },
  "mitsubishicarbide.net": { c: 17 },
  "nlc-japan.com": { s: ".l-cookie{display:none !important}" },
  "valorholdings.co.jp": { s: ".l-cookie{display:none !important}" },
  "moresco.co.jp": { s: "#js_allow{display:none !important}" },
  "mt-pharma.co.jp": { s: ".acceptUseCookie{display:none !important}" },
  "yamahamusic.jp": { s: ".bf_gdpr_box{display:none !important}" },
  "resmed.com": { s: ".c-notifications-wrapper{display:none !important}" },
  "navita.co.jp": { s: ".c-cookiePolicy{display:none !important}" },
  "ncsoft.jp": { s: "#ncCookieAlert{display:none !important}" },
  "neimanmarcus.com": { s: ".privacy_banner{display:none !important}" },
  "nyit.edu": { s: ".tracking{display:none !important}" },
  "pdftoexcel.com": { s: ".policy-box{display:none !important}" },
  "reuters.com": { s: ".iziToast{display:none !important}" },
  "pie.co.jp": { s: ".confirmationWording{display:none !important}" },
  "pixilart.com": { s: ".ckie{display:none !important}" },
  "plusjam.jp": { s: "#gdpr_cookie{display:none !important}" },
  "pronews.com": { s: ".cookieGate{display:none !important}" },
  "royalpanda.com": { s: "#__next > div + div{display:none !important}" },
  "sankeibldg.co.jp": { s: ".un_cookieConfirm{display:none !important}" },
  "scania.com": { s: ".m-cookie{display:none !important}" },
  "toyosenpaku.com": { s: ".cookie-container{display:none !important}" },
  "seminolestate.edu": { s: "#sscCookieStatement{display:none !important}" },
  "seagaia.co.jp": { s: "#js-gdpr-box{display:none !important}" },
  "shichida.com": { s: ".l-cookiePopup{display:none !important}" },
  "kuki.cz": { c: 14 },
  "simcast.com": { s: ".gdpr-block{display:none !important}" },
  "labro.com.pl": { s: "#colorbox,#cboxOverlay{display:none !important}" },
  "smcworld.com": { s: "#s-modal{display:none !important}" },
  "dreamworks.com": { s: ".notice-modal{display:none !important}" },
  "geotastic.net": { j: "3" },
  "beefeater.co.uk": {
    s: "pi-cookie-policy-modal{display:none !important}",
    c: 85,
  },
  "chem-space.com": {
    s: "#gdpr-notify{display:none !important} .modalpage{overflow:unset !important}",
    c: 65,
  },
  "oponeo.nl": { s: "#consentsPolicyDialog{display:none !important}" },
  "warnerbros.com": { s: "#WB-floating-notice{display:none !important}" },
  "bootstrap.academy": { j: "6" },
  "zoxs.de": {
    s: ".modal-open{overflow:unset !important}",
    c: 14,
  },
  "buyzoxs.de": {
    s: ".modal-open{overflow:unset !important}",
    c: 14,
  },
  "foxracing.ro": {
    s: "#overlay_gdpr_autentic_content,#overlay_gdpr_autentic{display:none !important}",
  },
  "zoxs.de": { c: 14 },
  "buyzoxs.de": { c: 14 },
  "foxracing.ro": {
    s: "#overlay_gdpr_autentic_content,#overlay_gdpr_autentic{display:none !important}",
  },
  "intellias.com": { s: ".showed-cookie-notice{display:none !important}" },
  "promobit.com.br": { s: "#__next > :nth-child(5){display:none !important}" },
  "fvd.nl": { s: ".fixed{display:none !important}" },
  "roshtein.com": {
    s: '[class*="Navigation_locked"]{filter:unset !important; pointer-events:unset !important}',
  },
  "kteohellas.gr": { s: "#cookiesettings-dialog{display:none !important}" },
  "shiftdelete.net": { s: ".banner{display:none !important}" },
  "afaudio.co.uk": {
    s: "#cookiew{display:none !important}",
    c: 14,
  },
  "kokoomus.fi": { s: "gds-consent-manager{display:none !important}" },
  "allegro.cz": { j: "5" },
  "pah.org.pl": { s: ".cookies-notice__container{display:none !important}" },
  "cupt.gov.pl": {
    s: "#wiCookieBar1,#wiCookieBar2{display:none !important}",
    c: 85,
  },
  "workbreakdownstructure.com": { s: "#consentpopup{display:none !important}" },
  "fanipogody.pl": {
    s: "#cmp-iframe{display:none !important}",
    c: 85,
  },
  "worksmile.com": { s: ".cookies-component{display:none !important}" },
  "dryg.pl": { s: '[class^="CookiesNotification"]{display:none !important}' },
  "theprotocol.it": {
    s: '[class^="Container_"]{display:none !important}',
    c: 85,
  },
  "centrumrowerowe.pl": { s: "#consentsPolicyDialog{display:none !important}" },
  "centrumrowerowe.pl": { s: "#consentsPolicyDialog{display:none !important}" },
  "img.ly": { s: ".cke-overlay{display:none !important}" },
  "bm-grenoble.fr": { s: "#app > div > :last-child{display:none !important}" },
  "tarifcheck-partnerprogramm.de": { j: "6" },
  "ulm-dsl.de": { j: "6" },
  "conrad.com": { s: ".vue-portal-target{display:none !important}" },
  "precision-people.uk": { s: ".ns-box{display:none !important}" },
  "hstock.org": { c: 16 },
  "merecerise.com": {
    s: ".wz-rgpd{display:none !important}",
    c: 85,
  },
  "saleae.com": { s: "#portals-root > div > div{display:none !important}" },
  "samsungknox.com": { c: 6 },
  "catania.it": {
    s: ".chefcookie--blur body::after{backdrop-filter: unset !important; position: unset !important} .chefcookie--fade body::after{background-color: unset !important}",
  },
  "daemmen-lohnt-sich.de": {
    s: "#QdevConsentContainer{display:none !important}",
  },
  "skinmc.net": { s: ".eu-popup{display:none !important}" },
  "residentportal.com": {
    s: "#root > main > div + div{display:none !important}",
  },
  "verwaltungs-jobs.ch": {
    s: "#modal-privacy-settings{display:none !important}",
    c: 14,
  },
  "mejorologiajazztel.com": { s: ".ons-cookie{display:none !important}" },
  "misterworker.com": { s: "#tmbcookie-cs-banner{display:none !important}" },
  "amt-kellinghusen.de": { s: "#privacy-container{display:none !important}" },
  "casetify.com": { s: ".cookie-option{display:none !important}" },
  "just-normlicht.com": { c: 4 },
  "flying-pizza.de": { j: "6" },
  "barax.de": { s: "#es-cookie-solution{display:none !important}" },
  "miravia.es": { s: ".cookies-authorize{display:none !important}" },
  "seriesmania.com": { j: "6" },
  "epo.org": { s: "#matomoBanner{display:none !important}" },
  "orangebank.fr": {
    s: "#didomi-popup{display:none !important} .didomi-popup-open{overflow: unset !important}",
  },
  "schulkreis.de": { s: "#divModalScreen{display:none !important}" },
  "flyingblue.se": {
    s: "body{overflow:unset !important}",
    c: 49,
  },
  "eframe.co.uk": { c: 0 },
  "lichtblick.de": { s: ".overflowHidden{overflow:unset !important}" },
  "combat.pl": {
    s: ".modals-overlay{display:none !important} ._has-modal{overflow: unset !important}",
  },
  "lit.dev": { s: "litdev-cookie-banner{display:none !important}" },
  "ipernity.com": { s: "#cookie_consent_outer{display:none !important}" },
  "ihk-weiterbildung.de": { s: ".cmnstr{display:none !important}" },
  "thekey.academy": { s: ".p-dialog-mask{display:none !important}" },
  "gruporesolve.com.br": { s: "#over-cookies{display:none !important}" },
  "podarujwigilie.pl": { s: "footer ~ div{display:none !important}" },
  "band.us": { s: ".bcm_bandCookieModuleWrap{display:none !important}" },
  "filen.io": {
    s: "#__next > div + div,#root > div + div{display:none !important}",
  },
  "awwwards.com": { j: "6" },
  "olvg.nl": {
    s: "#gdpr-selection-screen{display:none !important}",
    c: 85,
  },
  "moises.ai": { s: ".floating-banner{display:none !important}" },
  "bionic-reading.com": { j: "3" },
  "starnecker.com": { c: 6 },
  "aikikai.de": { c: 14 },
  "kick.com": { s: "#app > .main-html + .fixed{display:none !important}" },
  "primus-apotheken-stadecken.de": {
    s: "#ccModal{display:none !important}",
    c: 14,
  },
  "castorama.pl": { s: ".background-overlay{display:none !important}" },
  "wijnbeurs.nl": { s: "._has-modal{overflow: unset !important}" },
  "nordnet.se": { c: 6 },
  "playstartrekonline.com": { s: "#gdpr-wall{display:none !important}" },
  "gerep.fr": { c: 24 },
  "lokalninja.de": {
    s: "#chimpify-popup-2,#chimpify-overlay{display:none !important}",
    c: 85,
  },
  "qwertee.com": { s: "#root > .fixed{display:none !important}" },
  "factcool.com": {
    s: "#__next > div > div + div > div > :nth-child(3),.fScrmm{display:none !important}",
  },
  "nightcafe.studio": { j: "3" },
  "dilynakotle.cz": {
    s: ".focus-cookiebara{display:none !important} .focus-opened{overflow:unset !important}",
  },
  "hoptimist.com": { c: 14 },
  "zill.de": {
    s: "#modal-agreementPrivacy{display:none !important}",
    c: 14,
  },
  "bushnell.com": { s: "#consent-tracking{display:none !important}" },
  "oko.press": { s: "#__next > .fixed{display:none !important}" },
  "dafy-moto.com": { j: "5" },
  "myeventeo.com": { s: ".box-container{display:none !important}" },
  "minervamagazine.com": { s: ".pcb{display:none !important}" },
  "ancientegyptmagazine.com": { s: ".pcb{display:none !important}" },
  "andreashop.sk": { s: "#eu-cookies-popup{display:none !important}" },
  "thesourcemodels.com": { s: "#cookie-bottom{display:none !important}" },
  "video.gazzetta.it": { j: "5" },
  "sreality.cz": {
    s: ".szn-cmp-dialog-container{display:none !important}",
    c: 85,
  },
  "penta.cz": { c: 85 },
  "przemyslprzyszlosci.gov.pl": { s: "._consent{display:none !important}" },
  "jobretraite.fr": { s: ".pixim-cookie{display:none !important}" },
  "3ds.com": { s: ".gdpr-modal{display:none !important}" },
  "tickets.dieeisbaeren.de": {
    s: 'div[style*="position: fixed; left: 0px;"]{display:none !important}',
  },
  "gerardmer.net": { s: "#bandeau_rgpd_cookies{display:none !important}" },
  "blog.thedigitalgroup.com": { s: "#modalCookies{display:none !important}" },
  "zlocinozrouti.cz": { j: "6" },
  "stefanvd.net": { s: "#cookie-law{display:none !important}" },
  "defence24.pl": { j: "3" },
  "cyberdefence24.pl": { j: "3" },
  "energetyka24.com": { j: "3" },
  "space24.pl": { j: "3" },
  "defence24.com": { j: "3" },
  "infosecurity24.pl": { j: "3" },
  "dsmart.com.tr": { s: ".kvkk{display:none !important}" },
  "kuchniasklep.pl": { s: "ks-cookie-popup{display:none !important}" },
  "aptekawsieci.pl": { c: "68" },
  "sportrebel.pl": { j: "6" },
  "callusan.sklep.pl": { s: ".m-cookie-alert-1{display:none !important}" },
  "lovrin.pl": { s: "#privacy-message{display:none !important}" },
  "materacezgor.pl": { s: "#privacy-message{display:none !important}" },
  "psiakostka.eu": { s: ".configMessages__footer{display:none !important}" },
  "browar-tenczynek.pl": { s: "#privacy-policy-info{display:none !important}" },
  "lek24.pl": { s: "#notice_bar{display:none !important}" },
  "chrissiecosmetics.com.pl": {
    s: ".m-cookie-alert-1{display:none !important}",
  },
  "pizz.uno": { s: "#cookie-consent{display:none !important}" },
  "powerboard.basemark.com": { c: "3" },
  "carry.pl": { j: "6" },
  "supermercadosmas.com": { j: "6" },
  "sonicsvpn.com": { s: 'div[class^="index_cookie"]{display:none !important}' },
  "wolczanka.pl": { s: "#bottom-cookies{display:none !important}" },
  "pogodadlaslaska.pl": {
    s: "#elementor-popup-modal-1823{display:none !important}",
  },
  "cem.polskieradio.pl": {
    s: 'div[class^="ModalTerms"]{display:none !important}',
  },
  "northpole.com": { s: "#cookies-pop{display:none !important}" },
  "knightsofhonor.com": { c: 0 },
  "dubina-chachar.cz": { s: ".fworks_consent_bar {display:none !important}" },
  "mentta.com": { c: "85" },
  "ebookrenta.com": { s: "#js-ccpa_dialog{display:none !important}" },
  "kaartje2go.nl": { s: ".consentmodal{display:none !important}" },
  "jb-lighting.de": {
    s: ".cookiefensterdeckflaeche, .cookiefenster{display:none !important}",
  },
  "coe.int": { s: ".coe-cookies-consent-popup{display:none !important}" },
  "hyrican.de": { s: "#dywc,#dywc_bglayer{display:none !important}" },
  "prva.si": { s: ".gcc-cookies{display:none !important}" },
  "lampshoponline.com": { s: "#illow-banner-widget{display:none !important}" },
  "vistula.pl": { s: "#bottom-cookies{display:none !important}" },
  "espa.com": { s: ".cookienator{display:none !important}" },
  "sivasdescalzo.com": {
    s: 'aside[data-role="gdpr-cookie-container"]{display:none !important}',
  },
  "gothic-gifts.com": { s: "#CCM_popup{display:none !important}" },
  "stempelplatte.de": {
    s: "#cookie-modern-info,#cookie-modern-overlay{display:none !important}",
  },
  "stempelwerk.de": {
    s: "#cookie-modern-info,#cookie-modern-overlay{display:none !important}",
  },
  "thefancytext.com": { c: "112" },
  "riceundspice.de": {
    s: "body.disabled > *:not(.cookie-wrapper){pointer-events: unset !important; opacity: unset !important;}",
  },
  "assure.ameli.fr": {
    s: "#idPopupWARecueilConsentement{display:none !important}",
  },
  "webhero.be": { s: "div[data-cookie-popup]{display:none !important}" },
  "compendium.com.ua": { c: "6" },
  "bibloo.cz": { s: "consent-dialog{display:none !important}" },
  "spartorama.gr": { s: "#myModal{display:none !important}" },
  "predecessorgame.com": { c: "0" },
  "korg.co.uk": {
    s: "#gdpr-blocking-page-overlay{display:none !important}",
    c: "85",
  },
  "mydigitalschool.com": {
    s: ".eu-cookie-compliance-status-null{display:none !important}",
    c: "85",
  },
  "kostickylega.cz": { s: "#snippet-cookieBar-{display:none !important}" },
  "orangebank.es": { s: ".modal-cookies{display:none !important}" },
  "sunweb.fr": { s: ".c-backdrop, #w-cookie-consent{display:none !important}" },
  "sunweb.nl": { s: ".c-backdrop, #w-cookie-consent{display:none !important}" },
  "sunweb.be": { s: ".c-backdrop, #w-cookie-consent{display:none !important}" },
  "na-kd.com": { s: "body{overflow-y:scroll !important}" },
  "pflanzenkatalog.ley-baumschule.de": {
    s: ".cookiemessagebackground{display:none !important}",
    c: "85",
  },
  "blog.flota.es": {
    s: 'div[c_data="c_cookie_main"]{display:none !important}',
    c: "85",
  },
  "smallerearth.com": { c: "0" },
  "mr-electric.co.uk": { s: ".cookie-acception{display:none !important}" },
  "oscarproperties.com": {
    s: 'div[class^="CookiesBanner"]{display:none !important}',
  },
  "vestavis.eu": { s: ".bottom-freezed-bar{display:none !important}" },
  "arendalsound.com": { s: "#cookie_dialog_wrap{display:none !important}" },
  "quorn.co.uk": { s: ".qcmp-modal{display:none !important}", c: "85" },
  "mymorrisons.com": {
    s: "body > #reactive-modal-root{display:none !important}",
  },
  "graviti.com": { s: ".gas-cookie-bar{display:none !important}" },
  "my.kuka.com": { s: "c-osf-cookie-consent-banner{display:none !important}" },
  "narzedzia.pl": { s: ".cookie-background{display:none !important}" },
  "rotopino.pl": { s: ".cookie-background{display:none !important}" },
  "buehlerzuerich.ch": {
    s: "#elementor-popup-modal-8679{display:none !important}",
  },
  "energenie.com": { s: "#Footer_Cookie{display:none !important}" },
  "traseo.pl": { c: "34" },
  "trendwatcher.cz": {
    s: "#dynamic-cookies-bar,#dynamic-cookies-bar-overlay{display:none !important}",
  },
  "telecopro.com": { s: "#elementor-popup-modal-548{display:none !important}" },
  "pagefly.io": { c: "0" },
  "mapy.spravazeleznic.cz": { c: "0" },
  "csgo.mtsl.dk": { s: "#cookie-accepter{display:none !important}" },
  "nappy.co": {
    s: ".btn-block.text-center.class-montserrat.showBanner.padding-top-10.padding-bottom-10{display:none !important}",
  },
  "elmachips.com.br": { c: "0" },
  "goflink.com": { c: "6" },
  "advantest.com": { c: "3" },
  "autoscout24.de": {
    s: 'div[class^="_consent-popup"]{display:none !important}',
  },
  "playdarktide.com": { c: "6" },
  "moodle.com": { s: ".cli-popupbar-overlay{display:none !important}" },
  "milopiwo.pl": {
    s: ".configMessages.configMessages__footer{display:none !important}",
  },
  "toyota.com.br": {
    s: 'div[class*="cookies-banner-container"]{display:none !important}',
  },
  "flex.orange.pl": {
    s: 'div[id*="CookiesPopup_cookies"]{display:none !important}',
  },
  "alifragis.com.gr": {
    c: "85",
    s: "#cookies2020,#cookies2020overlay{display:none !important}",
  },
  "cricut.com": { s: "#consent-tracking{display:none !important}" },
  "ebilet.pl": { s: "eb-cookies-policy-dialog{display:none !important}" },
  "lilysilk.com": { s: ".privacywrap{display:none !important}" },
  "community.tp-link.com": { s: "#tp-cookie-script{display:none !important}" },
  "interbank.pe": { s: ".o-cookies-banner{display:none !important}" },
  "stackguides.com": { s: "#spopupCont{display:none !important}" },
  "drc.bz": { s: ".modal-cacsp-position{display:none !important}" },
  "miljayega.com": { s: ".cookie_bot{display:none !important}" },
  "fxhome.com": { s: ".cookie-container{display:none !important}" },
  "modivo.lt": { j: "3" },
  "modivo.pl": { j: "3" },
  "modivo.cz": { j: "3" },
  "modivo.hr": { j: "3" },
  "modivo.ro": { j: "3" },
  "modivo.sk": { j: "3" },
  "modivo.hu": { j: "3" },
  "modivo.bg": { j: "3" },
  "modivo.gr": { j: "3" },
  "modivo.de": { j: "3" },
  "modivo.fr": { j: "3" },
  "modivo.it": { j: "3" },
  "modivo.ua": { j: "3" },
  "modivo.lv": { j: "3" },
  "modivo.si": { j: "3" },
  "modivo.at": { j: "3" },
  "harrisscarfe.com.au": { s: ".modal-backdrop{display:none !important}" },
  "vitens.nl": { c: "20" },
  "rapiddc.pl": { s: "#cookies-consent-container{display:none !important}" },
  "kupkolo.cz": { s: ".focus-cookiebara{display:none !important}", c: "85" },
  "kanalsportowy.pl": { j: "6" },
  "meduniwien.ac.at": { s: "#fccCookieModal{display:none !important}" },
  "klachtenkompas.nl": {
    s: 'div[data-test="consent-banner"]{display:none !important}',
  },
  "huutokaupat.com": { j: "6" },
  "mein-eigenheim.de": { s: ".overlay_cookiebanner{display:none !important}" },
  "jetbrains.com": {
    s: ".jetbrains-cookies-banner-3{display:none !important}",
  },
  "dreamingreece.com": { s: ".cookie-consent-inner{display:none !important}" },
  "seb.se": { j: "6" },
  "shop.dicompass.cloud": { s: "#cc_div{display:none !important}" },
  "mycashbacks.com": { c: "2" },
  "futura-sciences.com": { s: "#overlay{display:none !important}", c: "85" },
  "sslmarket.com": { s: ".modal-cookies{display:none !important}" },
  "trucksbook.eu": { s: "#cookieModal{display:none !important}", c: "85" },
  "julieandrieu.com": { s: "#cookie-modal{display:none !important}", c: "85" },
  "ratatype.fr": { s: ".alert-bottom{display:none !important}" },
  "aachen.de": { s: "#cookiehuhu{display:none !important}" },
  "setasdesevilla.com": { c: "85" },
  "apk-store.org": { s: ".cop_dmca{display:none !important}" },
  "monte-mare.de": { c: "4" },
  "chatreplay.stream": { s: ".svelte-dx0l3i{display:none !important}" },
  "ford.si": { c: "20" },
  "dartshop-bonn.de": {
    s: ".lightbox-backdrop-cc-dialog,.cc-dialog{display:none !important}",
  },
  "shopforyou47.de": {
    s: ".lightbox-backdrop-cc-dialog,.cc-dialog{display:none !important}",
  },
  "zitis.bund.de": { s: ".mfp-ready{display:none !important}" },
  "ar-demo.tradesoft.pro": { s: ".cookies-window{display:none !important}" },
  "goodnotes.com": { s: ".fscc{display:none !important}" },
  "leslipfrancais.fr": {
    s: "#nq_cnilbanner_container{display:none !important}",
    c: "85",
  },
  "nextenergy.nl": { s: ".fs-cc-banner2_component{display:none !important}" },
  "cosmosmagazine.com": { s: ".adn-window{display:none !important}" },
  "nicepage.com": { s: "#np-cookie-consent{display:none !important}" },
  "actievandedag.nl": {
    s: ".fixed.z-20.bottom-0.left-0.right-0.py-4.bg-black.bg-opacity-80{display:none !important}",
  },
  "trampaboards.com": { s: "#eu_cookie_instructions{display:none !important}" },
  "mvz-krankenhaus-weilburg.de": { s: "#pg_cTBanner{display:none !important}" },
  "super-hobby.com": { s: ".message-footer-panel{display:none !important}" },
  "super-hobby.co.uk": { s: ".message-footer-panel{display:none !important}" },
  "super-hobby.de": { s: ".message-footer-panel{display:none !important}" },
  "super-hobby.be": { s: ".message-footer-panel{display:none !important}" },
  "super-hobby.at": { s: ".message-footer-panel{display:none !important}" },
  "super-hobby.it": { s: ".message-footer-panel{display:none !important}" },
  "super-hobby.es": { s: ".message-footer-panel{display:none !important}" },
  "super-hobby.fr": { s: ".message-footer-panel{display:none !important}" },
  "fa-mag.com": { s: "#privacy-policy-sticky{display:none !important}" },
  "dfg.de": { s: ".bab-modul-cookie-consent{display:none !important}" },
  "moebel-rieger.de": {
    s: ".cookie-permission-background{display:none !important}",
  },
  "i4wifi.eu": { s: "#CPrivacy-Panel{display:none !important}" },
  "herole.de": {
    s: "#incredible-cookie-furnace-generator{display:none !important}",
  },
  "mygym.com": { s: "#cookies-pop-up{display:none !important}" },
  "ssceindhoven.tue.nl": { s: "#cookie-consent{display:none !important}" },
  "gross-zimmern.de": { c: "85" },
  "lacid.org": { s: ".topLayer{display:none !important}" },
  "massgeneralbrigham.org": {
    s: ".footer__notice modal{display:none !important}",
  },
  "pccomponentes.pt": { c: "39" },
  "plancha-grillen.com": {
    s: ".lightbox-backdrop.lightbox-backdrop-cc-dialog{display:none !important}",
  },
  "6paknutrition.com": { s: ".pop-cookiebox{display:none !important}" },
  "skyscanner.net": { j: 6 },
  "skyscanner.ru": { j: 6 },
  "skyscanner.fi": { j: 6 },
  "skyscanner.no": { j: 6 },
  "skyscanner.nl": { j: 6 },
  "skyscanner.ro": { j: 6 },
  "skyscanner.com.ni": { j: 6 },
  "skyscanner.at": { j: 6 },
  "skyscanner.com.sg": { j: 6 },
  "skyscanner.es": { j: 6 },
  "skyscanner.co.nz": { j: 6 },
  "skyscanner.com.sa": { j: 6 },
  "skyscanner.com.bo": { j: 6 },
  "skyscanner.com.br": { j: 6 },
  "skyscanner.mx": { j: 6 },
  "skyscanner.it": { j: 6 },
  "skyscanner.ae": { j: 6 },
  "skyscanner.in": { j: 6 },
  "skyscanner.com.sv": { j: 6 },
  "skyscanner.ie": { j: 6 },
  "skyscanner.co.kr": { j: 6 },
  "skyscanner.com.pe": { j: 6 },
  "skyscanner.com.ph": { j: 6 },
  "skyscanner.com.pa": { j: 6 },
  "skyscanner.hu": { j: 6 },
  "skyscanner.com.gt": { j: 6 },
  "skyscanner.com.co": { j: 6 },
  "skyscanner.dk": { j: 6 },
  "skyscanner.co.th": { j: 6 },
  "skyscanner.com.hn": { j: 6 },
  "skyscanner.pt": { j: 6 },
  "skyscanner.tw": { j: 6 },
  "skyscanner.de": { j: 6 },
  "skyscanner.com.hk": { j: 6 },
  "skyscanner.com.tw": { j: 6 },
  "skyscanner.pl": { j: 6 },
  "skyscanner.com.tr": { j: 6 },
  "skyscanner.cz": { j: 6 },
  "skyscanner.com": { j: 6 },
  "skyscanner.cr": { j: 6 },
  "skyscanner.com.py": { j: 6 },
  "skyscanner.cl": { j: 6 },
  "skyscanner.com.ua": { j: 6 },
  "skyscanner.com.do": { j: 6 },
  "skyscanner.kr": { j: 6 },
  "skyscanner.co.id": { j: 6 },
  "skyscanner.ch": { j: 6 },
  "skyscanner.gg": { j: 6 },
  "skyscanner.ca": { j: 6 },
  "skyscanner.com.uy": { j: 6 },
  "skyscanner.com.ec": { j: 6 },
  "skyscanner.co.il": { j: 6 },
  "skyscanner.co.in": { j: 6 },
  "skyscanner.com.vn": { j: 6 },
  "skyscanner.se": { j: 6 },
  "skyscanner.com.ar": { j: 6 },
  "skyscanner.com.au": { j: 6 },
  "skyscanner.fr": { j: 6 },
  "skyscanner.jp": { j: 6 },
  "skyscanner.com.my": { j: 6 },
  "skyscanner.com.mx": { j: 6 },
  "milenio.com": { s: "#camus-cookie-disclaimer{display:none !important}" },
  "energylivenews.com": {
    s: "#cookie-notification-mask{display:none !important}",
  },
  "dslbank.de": { j: 6 },
  "metzgerei.org": {
    s: "#consent-modal-fw,#consent-banner-fw{display:none !important}",
  },
  "lizy.be": {
    s: 'div[class^="PopupCookies-module_wrapper"]{display:none !important}',
  },
  "cuxlandparks.de": { s: "sw-cookiemessage{display:none !important}" },
  "europa-plc.com": { s: "#cookieplate{display:none !important}" },
  "checkfrank.dk": { c: "14" },
  "como-se-escribe.com": { s: "#rgpd_pp{display:none !important}" },
  "obarbershop.com": { s: ".cookies_section{display:none !important}" },
  "radioforen.de": { s: ".notice--cookieAdvanced{display:none !important}" },
  "sena.com": { c: "112" },
  "unions-pompiers.fr": { s: "#bandeau_consent{display:none !important}" },
  "fermedelinciaux.be": {
    s: "#elementor-popup-modal-3101{display:none !important}",
  },
  "webapps.geohive.ie": {
    s: "#widgets_Splash_Widget_14{display:none !important}",
  },
  "vicampo.de": { j: 3 },
  "yap-app.it": { s: ".yap-cookie-bar{display:none !important}" },
  "filoalfa3d.com": { s: ".gdprModal{display:none !important}" },
  "hallakonsument.se": {
    s: 'section[aria-label="Kakinformation"]{display:none !important}',
  },
  "mitteldithmarschen.de": { s: "#privacy-container{display:none !important}" },
  "sauvequiveut.fr": { s: "#zCookieConsent{display:none !important}" },
  "armadamusic.com": {
    s: ".cookie-bar-notifications{display:none !important}",
  },
  "nadia.gov.gr": { j: 6 },
  "stevensbikes.de": { j: 6 },
  "bikesale.de": { c: 14 },
  "klook.com": { s: ".klk-notification{display:none !important}" },
  "accordbank.com.ua": { s: "#setcookie-agreement{display:none !important}" },
  "studentbostader.se": { s: ".cc-container{display:none !important}" },
  "finnair.com": { s: "fin-cookie-policy{display:none !important}", c: 14 },
  "postleitzahl.org": { s: "#cmp{display:none !important}" },
  "mondomebeli.com": { c: 0 },
  "sa.wahl.com": { s: "#form-popups{display:none !important}" },
  "domicile-emploi.net": { c: 30 },
  "zps.si": { s: "#preload_over{display:none !important}" },
  "engelvoelkers.com": { s: "#didomi-popup{display:none !important}" },
  "ajanvaraus.veripalvelu.fi": {
    s: "#cookie-consent-content{display:none !important}",
    c: 85,
  },
  "cazenovecapital.com": {
    s: "#disclaimerModal{display:none !important}",
    c: 14,
  },
  "culturehustle.com": { s: ".cookie-model{display:none !important}" },
  "idream.pl": { s: "#garua_cookie_consent_popup{display:none !important}" },
  "blog.andwork.com": { s: ".overlay{display:none !important}" },
  "support.lexmark.com": { s: ".tui-gdpr{display:none !important}" },
  "deskmat.io": { s: 'div[class*="CookieThingy"]{display:none !important}' },
  "cyscale.com": { s: ".banner-enter-done,.overlay{display:none !important}" },
  "sescsp.org.br": { s: ".container-policy,.overlay{display:none !important}" },
  "timeweb.cloud": { s: ".cc{display:none !important}" },
  "schaffer-polska.pl": { s: "#pnscookie{display:none !important}" },
  "ecclesiae.com.br": { s: ".box-aceite-privacidade{display:none !important}" },
  "designalive.pl": { s: ".advancedCookiesPopup{display:none !important}" },
  "snowleader.co.uk": { s: ".c-bandeau-rgpd{display:none !important}" },
  "rupertspira.com": { s: ".cookie-warning__overlay{display:none !important}" },
  "archiveofourown.org": { s: "#tos_prompt{display:none !important}" },
  "palit.com": { s: "#pp_overlay,#pp_info{display:none !important}" },
  "trixxo-arena.be": {
    s: 'section[vue-app="storage-settings"]{display:none !important}',
  },
  "camp-fire.jp": {
    s: ".cookie-policy-agreement-notification{display:none !important}",
  },
  "sandberg.es": { s: "#privalert-container{display:none !important}" },
  "baskbank.com": {
    s: "#cpt_cookie_consent_prompt_container{display:none !important}",
  },
  "francebenevolat.org": { s: ".mgdpr-popup{display:none !important}" },
  "vitotechnology.com": { s: ".hXtGXC{display:none !important}" },
  "stadtwerke-witten.de": { s: "#vinegar-bottle{display:none !important}" },
  "guarconsa.com": { s: "#avisocookies1{display:none !important}", c: 14 },
  "rktbns.de": { c: 0 },
  "hyrabostad.se": { c: 157 },
  "refunder.se": {
    s: 'div[data-modal="cookie-consent-modal"]{display:none !important}',
    c: 85,
  },
  "nouvelair.com": {
    s: 'div[style*="width: 100%; height: 100%; z-index: 999; background-color: rgba(0, 0, 0, 0.3);"]{display:none !important}',
  },
  "pon20142020.indire.it": { s: "#bannerContent{display:none !important}" },
  "reka.ch": { c: 4 },
  "uninter.com": { s: ".lgpd-box{display:none !important}" },
  "fleetlogistics.com": {
    s: "#gdpr-cookie-message-container{display:none !important}",
  },
  "church-footwear.com": { c: 85 },
  "ppk.pzu.pl": { s: ".cdk-overlay-container{display:none !important}", c: 85 },
  "easyparts.fr": {
    s: "#div_popup_cookies,#cover{display:none !important}",
    c: 85,
  },
  "vente-unique.nl": { s: "#vu_consent{display:none !important}" },
  "wakkap.com": { c: 0 },
  "liveagent.com": { s: ".Medovnicky{display:none !important}" },
  "samueladams.com": { s: ".notification-banner{display:none !important}" },
  "rockboard.de": {
    s: ".cookie-outer-container-wrap{display:none !important}",
  },
  "gleerupsportal.se": {
    s: 'div[role="complementary"]{display:none !important}',
  },
  "3f-filippi.com": { c: 85 },
  "prowin.net": { c: 0 },
  "dstgb.de": { c: 85 },
  "59northwheels.se": { j: 6 },
  "bszam.de": { s: ".ccm-root{display:none !important}" },
  "karriere.hofer.at": { s: ".ppms_cm_popup_overlay{display:none !important}" },
  "nyman.media": { s: ".alert-dismissible{display:none !important}" },
  "aitopics.org": { s: "#fixed-footer{display:none !important}" },
  "socofe.pzu.pl": { s: ".cdk-overlay-container{display:none !important}" },
  "schrack-seconet.com": { s: ".pageOverlay{display:none !important}" },
  "vectornator.io": { s: ".cookies-wrap{display:none !important}" },
  "wetaca.com": {
    s: 'div[class^="cookiesBanner-module_cookiesBanner"]{display:none !important}',
  },
  "micro-nh.de": {
    s: ".amgdprcookie-modal-container,.ammodals-overlay{display:none !important}",
  },
  "skyfi.com": {
    s: 'section[class="fixed bottom-0 px-20 pb-25 left-0 right-0 lg:right-[unset] lg:p-30 z-[5000]"]{display:none !important}',
  },
  "lendwise.com": { c: 14 },
  "nbg.gov.ge": {
    s: 'div[class="md:w-61-1 right-0 w-full md:block absolute bottom-0 bg-primary-main md:py-2-1 pt-2-1 pb-4-0 px-3-0 no-print"]{display:none !important}',
  },
  "cancerfonden.se": {
    s: 'div[class^="CookieDisclaimer__Wrapper"]{display:none !important}',
  },
  "onexgroup.pl": {
    s: 'div[class^="PrivacyPolicyBanner"]{display:none !important}',
  },
  "lama-media.com": { c: 0 },
  "elektor.de": { c: 85 },
  "sharely.ch": { c: 0 },
  "lightyear.one": {
    s: 'div[class="fixed left-8 md:left-auto right-8 bottom-8 bg-white p-8 max-w-2xl drop-shadow-[0_4px_4px_rgba(0,0,0,0.25)]"]{display:none !important}',
  },
  "loewenapothekebetzdorf.de": {
    s: ".consent-management{display:none !important}",
    c: 85,
  },
  "educa2.madrid.org": { s: "#emCookieWrapper{display:none !important}" },
  "heroesofdataprivacy.com": {
    s: "#jentis-consent-main{display:none !important}",
  },
  "hostinger.fr": { s: ".h-cookie-consent{display:none !important}" },
  "lecrabeinfo.net": { c: 10 },
  "e100.eu": { c: 14 },
  "imem.app": { s: ".cookies-window{display:none !important}" },
  "minhabcimoveis.com.br": {
    s: ".lgpd-aceite-container{display:none !important}",
  },
  "bynco.com": { s: "#cookieWallContainer{display:none !important}", c: 85 },
  "tickets.siampark.net": { s: ".panel_cookies{display:none !important}" },
  "kidstaff.com.ua": { s: "#gdpr_panel{display:none !important}" },
  "natureguide.gr": { c: 0 },
  "espressimo.bg": { s: ".notification-wrapper{display:none !important}" },
  "giromatch.com": { s: "#cookienoteGm{display:none !important}", c: 14 },
  "minarsidur.hms.is": { s: "#snackbar{display:none !important}" },
  "renovatie-gids.be": { s: "#bbx_modal_cookie{display:none !important}" },
  "remember.de": {
    s: "#twt-cookie-consent-modal{display:none !important}",
    c: 85,
  },
  "3rdrockclothing.com": {
    s: ".pd-cookie-banner-window{display:none !important}",
  },
  "diddit.be": { s: "dd-cookies-banner{display:none !important}" },
  "szeged365.hu": { s: ".popup-screen{display:none !important}" },
  "loveandpeas.de": {
    s: ".lightbox-backdrop-cc-dialog{display:none !important}",
  },
  "beleaf.eu": {
    s: ".js-o-page__gdpr-overlay{display:none !important}",
    c: 85,
  },
  "cicenergigune.com": { s: "#over-cookies-msg{display:none !important}" },
  "allsaints.com": { s: ".b-notification_dialogs{display:none !important}" },
  "play.geforcenow.com": { c: 49 },
  "flybair.ch": { s: "#gdprcookie{display:none !important}" },
  "planningportal.co.uk": { s: ".tqc-portal{display:none !important}", c: 85 },
  "jemako.com": { s: "#acb-wrapper{display:none !important}" },
  "digiseller.market": { c: 3 },
  "freeyourmusic.com": { c: 6 },
  "startfrei.at": { s: "#cookie-consent-modal{display:none !important}" },
  "startfrei.at": { j: 6 },
  "tcgplayer.com": { s: ".compliance-banner{display:none !important}" },
  "verbandsgemeindeweissenthurm.de": { c: 85 },
  "accolade.eu": { s: "#cookies-component{display:none !important}" },
  "erzgebirgsstuebchen.de": { s: "#cookie-bar2{display:none !important}" },
  "aktualnosci.komputronik.com": {
    s: ".pr-cookie-policy{display:none !important}",
  },
  "clubmed.co.uk": {
    s: 'section[class="bg-white fixed bottom-0 shadow w-full z-6"]{display:none !important}',
  },
  "sfd.pl": { s: "#cc--main{display:none !important}", c: 85 },
  "papiernikbyempik.com": { c: 0 },
  "empik.com": { c: 85, s: ".css-zemqkq-wrapper{display:none !important}" },
  "health-platform.online": {
    s: ".MuiSnackbar-root,.MuiBackdrop-root{display:none !important}",
  },
  "heidisql.com": { c: 6 },
  "ironmaxx.de": { s: ".amgdprcookie-bar-container{display:none !important}" },
  "herbiesheadshop.com": {
    s: ".cookies-politic__section,.disclaimer-popup__overlay{display:none !important}",
  },
  "defencediscountservice.co.uk": {
    s: ".jquery-modal{display:none !important}",
    c: 85,
  },
  "vyos.io": { s: 'div[class^="Cookies_cookies"]{display:none !important}' },
  "odlewkiperfum.pl": { s: ".jconfirm{display:none !important}" },
  "tierschutzverein-diez.de": {
    s: "#consent-content{display:none !important}",
    c: 14,
  },
  "sainttropeztourisme.com": { s: ".RGPD_message{display:none !important}" },
  "innovationsstiftung-bildung.at": { c: 14 },
  "gebuhrenfrei.com": { c: 85 },
  "stephanealligne.com": {
    s: 'div[id^="bandeauCookie"]{display:none !important}',
  },
  "e-herbapol.com.pl": { s: "#cc--main{display:none !important}", c: 85 },
  "wyprzedzmeningokoki.pl": {
    s: "#__tealiumGDPRcpPrefs{display:none !important}",
  },
  "optomausa.com": { s: "#msgbg{display:none !important}" },
  "cik-solutions.com": { s: ".cookie-box{display:none !important}" },
  "autograph.io": { s: ".modal-bg{display:none !important}" },
  "weserwohnwelt.de": { s: "#datenschutzBalgeNew{display:none !important}" },
  "heni-werkzeuge.de": { s: "#dsvgoOverlay{display:none !important}" },
  "snowtrex.at": { c: 6 },
  "snowtrex.be": { c: 6 },
  "snowtrex.ch": { c: 6 },
  "snowtrex.co.uk": { c: 6 },
  "snowtrex.com": { c: 6 },
  "snowtrex.cz": { c: 6 },
  "snowtrex.de": { c: 6 },
  "snowtrex.dk": { c: 6 },
  "snowtrex.es": { c: 6 },
  "snowtrex.fr": { c: 6 },
  "snowtrex.ie": { c: 6 },
  "snowtrex.it": { c: 6 },
  "snowtrex.lt": { c: 6 },
  "snowtrex.nl": { c: 6 },
  "snowtrex.pl": { c: 6 },
  "snowtrex.pt": { c: 6 },
  "snowtrex.ro": { c: 6 },
  "snowtrex.se": { c: 6 },
  "snowtrex.si": { c: 6 },
  "snowtrex.sk": { c: 6 },
  "snowtrex.us": { c: 6 },
  "wintertrex.be": { c: 6 },
  "wintertrex.nl": { c: 6 },
  "sunfun.pl": { s: 'div[class^="CookieBar"]{display:none !important}' },
  "regent.pl": { s: "#wezcookie{display:none !important}" },
  "tourist.pl": { s: "#wezcookie{display:none !important}" },
  "bpmarco.pl": {
    s: "#cookies-floating-strip,#privacy-floating-strip{display:none !important}",
  },
  "bfc.pl": { c: 0 },
  "ogloszenia.jmlnet.pl": { c: 14 },
  "fiberatlantic.com": { c: 0 },
  "link.co": { s: ".LinkNotificationCenter{display:none !important}" },
  "pricellent.pl": { s: ".MuiSnackbar-root{display:none !important}" },
  "jobb.dafgards.se": {
    s: 'dialog[data-controller="common--cookies--alert"]{display:none !important}',
  },
  "reifen24.de": { s: ".cookie-cover{display:none !important}" },
  "kappa-shop.de": { s: ".amgdprjs-bar-template{display:none !important}" },
  "dallasinnovates.com": { s: "#acceptance{display:none !important}" },
  "voipstudio.de": { c: 6 },
  "vegmart.sk": {
    s: "#bb-cookies-dialog-state-default{display:none !important}",
  },
  "777score.com": { s: ".cookie-modal{display:none !important}" },
  "malijunaki.si": { s: "#cookies{display:none !important}", c: 85 },
  "energydashboard.co.uk": {
    s: 'div[class^="z-50 fixed"]{display:none !important}',
  },
  "singaporeair.com": {
    s: ".dwc--SiaCookie__PopupEUTint{display:none !important}",
  },
  "silverstonetek.com": { c: 0 },
  "techlord.pl": { s: "#InfoCookieTlo{display:none !important}" },
  "careers.debricked.com": {
    s: 'dialog[data-controller="common--cookies--alert"]{display:none !important}',
  },
  "codeclimate.com": {
    s: 'div[x-data*="cookie-policy"]{display:none !important}',
  },
  "bimibrokkoli.de": { c: 0 },
  "zero-to-nix.com": {
    s: 'div[class="fixed left-6 bottom-6 z-50 print:hidden"]{display:none !important}',
  },
  "educado.pl": { c: 20 },
  "theadelphileeds.co.uk": { c: 85 },
  "data-driven-forms.org": { j: 3 },
  "electropapa.com": { s: "#ccAcivateModal{display:none !important}", c: 14 },
  "toyota.co.th": { s: ".popup__pdpa{display:none !important}" },
  "tidesmarine.com": { c: 3 },
  "alma.be": { c: 85 },
  "helmut-fischer.com": { s: "#🍪{display:none !important}" },
  "oldirishpub.fi": { c: 14 },
  "qm-pilot.ch": { s: "#dsgvo--popup{display:none !important}" },
  "vegmart.cz": {
    s: "#bb-cookies-dialog-state-default{display:none !important}",
  },
  "fullbay.com": { s: ".cookie-consent-modal{display:none !important}" },
  "bridgeland.com": { s: ".disclaimer{display:none !important}" },
  "rds.live": { c: 167 },
  "britishcornershop.co.uk": { s: "#overlay{display:none !important}" },
  "centreforaviation.com": {
    s: 'div[class^="cookieConsent_consent"]{display:none !important}',
  },
  "voordeeluitjes.nl": { j: 6 },
  "afilio.de": { s: ".component-c-overlay{display:none !important}" },
  "turkishairlines.com": {
    s: "#cookieWarningMessageNew{display:none !important}",
  },
  "olerum.de": {
    s: ".cookiemessagebackground{display:none !important}",
    c: 85,
  },
  "devicespecifications.com": {
    s: "#window_cookie_consent_1_overlay{display:none !important}",
    c: 85,
  },
  "net-pocket.com": {
    s: 'div[class*="CookiesBanner"]{display:none !important}',
  },
  "theupgradeguide.com": { s: ".stpd_cmp{display:none !important}" },
  "sportano.cz": { j: 6 },
  "sportano.ro": { j: 6 },
  "sportano.hu": { j: 6 },
  "sportano.de": { j: 6 },
  "sportano.sk": { j: 6 },
  "nutsinbulk.ie": { s: "#CookieModal{display:none !important}", c: 14 },
  "nutsinbulk.eu": { s: "#CookieModal{display:none !important}", c: 14 },
  "nutsinbulk.co.uk": { s: "#CookieModal{display:none !important}", c: 14 },
  "gregorypacks.com": {
    s: ".overlay-wrapper__background{display:none !important} body{width: unset !important}",
    c: 85,
  },
  "alkoholizm-leczenie.eu": { s: ".cookieMonit{display:none !important}" },
  "freeway-camper.com": { s: ".c-cookiePolicy{display:none !important}" },
  "deadisland.com": { s: ".is-modal-visible{overflow:unset !important}" },
  "idw.de": { s: ".cookie-manager__overlay{display:none !important}" },
  "datarejestracji.senda.pl": { j: 6 },
  "praca.modivo.pl": { s: ".plate-cookies{display:none !important}" },
  "beta.character.ai": {
    s: 'div[style="position: relative; z-index: 1050; display: block;"]{display:none !important}',
  },
  "easyticket.de": {
    s: "html,body{overflow: unset !important; margin-right: unset !important;}",
  },
  "cbsnews.com": { s: "#cps-shaman-notifier{display:none !important}" },
  "puregoldprotein.com": {
    s: ".cookieConsentDialog{display:none !important}",
    c: 85,
  },
  "hero-wars.com": { s: ".overlay__cookie{display:none !important}" },
  "shanebarker.com": { s: ".kadence-conversion{display:none !important}" },
  "profim.pl": { s: 'div[class^="Cookies__content"]{display:none !important}' },
  "adressmonster.de": { c: 0 },
  "astra-mag.com": { c: 0 },
  "ebatpro.fr": { j: 6 },
  "centrumdobrejterapii.pl": {
    s: ".bottom-cookie-info{display:none !important}",
  },
  "autohaus24.de": { j: 6 },
  "ras.bz.it": {
    s: "body.dp--cookie-consent .body-inner::before{opacity: 0 !important}",
  },
  "jugendkulturkarte.berlin": { s: ".cookie-layer{display:none !important}" },
  "mullvad.careers": {
    s: 'dialog[data-controller="common--cookies--alert"]{display:none !important}',
  },
  "zdajmyrazem.pl": {
    s: "#gdprModal{display:none !important;}body{padding-right: 0px !important}",
    c: 14,
  },
  "careers.equinix.com": {
    s: ".consent-modal{display:none !important}",
    c: 14,
  },
  "piearsta.lv": { s: ".acceptCookiesBlock,.mask{display:none !important}" },
  "bikebox-shop.de": { s: "#ccAcivateModal{display:none !important}", c: 14 },
  "mline.com": { s: "#ccAcivateModal{display:none !important}", c: 14 },
  "portal.librus.pl": {
    s: ".consent-categories-modal-wrapper{display:none !important}",
    c: 85,
  },
  "logopaedie-balzer.de": {
    s: ".ch-popup-cookies,.chimpify-overlay{display:none !important}",
    c: 85,
  },
  "entuk.org": { s: "#cookieModal{display:none !important}", c: 14 },
  "teufelaudio.pl": { s: "p-layer{display:none !important}", c: 85 },
  "oficinasmontiel.com": { s: "#darklayer{display:none !important}" },
  "aia.com.sg": {
    s: ".cmp-notification-action-panel{display:none !important}",
  },
  "bloemenvanblok.nl": { s: "#cookieSettings{display:none !important}" },
  "lafermeducbd.fr": { s: ".gdprModal{display:none !important}" },
  "hendy.co.uk": {
    s: 'div[x-init^="hide_cookie_banner"]{display:none !important}',
  },
  "physikinstrumente.de": { c: 85 },
  "seb.lv": { c: 14 },
  "group.emmi.com": {
    s: ".js-o-page__gdpr-overlay{display:none !important}",
    c: 85,
  },
  "metar-taf.com": { c: 0 },
  "spiele-offensive.de": { s: "#consentContainer{display:none !important}" },
  "khrono.no": { s: ".adn-window.adn-message{display:none !important}" },
  "llull.cat": { s: "#backBlackCookies{display:none !important}" },
  "savoo.co.uk": { s: "#cookie-consent{display:none !important}" },
  "sutars.com": { s: "#CookiesSettings{display:none !important}" },
  "thedutchonlineacademy.com": {
    s: "#cookie-consent{display:none !important}",
  },
  "tourismecote-nord.com": { s: ".bar.is-active{display:none !important}" },
  "tameteo.nl": { s: ".cmp-main,#gpdr{display:none !important}", c: 85 },
  "bammusic.com": { s: ".cookie-modal{display:none !important}" },
  "esprit.presse.fr": { s: "#CookieConsentPopup{display:none !important}" },
  "xxxl.gr": {
    s: ".notification-wrapper.notification-wrapper-bottom{display:none !important}",
  },
  "skateshop.gr": {
    s: ".notification-wrapper.notification-wrapper-bottom{display:none !important}",
  },
  "vicuspelle.ch": { s: ".cookie-model{display:none !important}" },
  "sunsky-online.com": { s: "#cookiesHint_1{display:none !important}" },
  "reishunger.com": { c: 6 },
  "muenchen.rotary.de": { s: "#overlay{display:none !important}", c: 6 },
  "reservations.hotel-spider.com": { j: 3 },
  "pfleiderer.com": {
    s: '.cc--banner, div[data-locks="cookieconsent"]{display:none !important}',
    c: 85,
  },
  "redokun.com": { s: ".cookie-banner-component{display:none !important}" },
  "endora.cz": { c: 6 },
  "halonen.fi": { j: 6 },
  "bokadirekt.se": { j: 6 },
  "educacionadistancia.juntadeandalucia.es": {
    s: ".app-cookies{display:none !important}",
    c: 85,
  },
  "uniqueshop.gr": { j: 6 },
  "hartorama.gr": { j: 6 },
  "cinobo.com": { j: 6 },
  "carlson.fi": { j: 6 },
  "gametime.chipsnsips.com": {
    s: ".third-party-optin{display:none !important}",
  },
  "idg.se": { j: 5 },
  "judge.me": { s: ".jm-cookie-bar{display:none !important}" },
  "misterhorse.com": { s: "#cookies-start-modal{display:none !important}" },
  "mohrsiebeck.com": { s: "#cookieman-modal{display:none !important}" },
  "starofservice.com": { j: "5" },
  "tu.no": { s: "#__next > .fixed{display:none !important}" },
  "digi.no": { s: "#__next > .fixed{display:none !important}" },
  "buki.org.pl": { j: "3" },
  "vicuspelle.ch": { s: ".cookie-model{display:none !important}" },
  "airitsystems.de": { j: "6" },
  "tatararazors.com": { j: "6" },
  "sunsky-online.com": { s: "#cookiesHint_1{display:none !important}" },
  "akakce.com": { s: ".banner{display:none !important}" },
  "uni-passau.de": { s: ".upa_cookie{display:none !important}" },
  "sunroom.it": {
    s: "#my-agile-privacy-notification-content{display:none !important}",
  },
  "tulipsmarket.com": {
    s: ".CybotCookiebotDialogActive{display:none !important}",
  },
  "object-carpet.com": {
    s: ".hidden.cookieNoticeWrapper{display:none !important}",
  },
  "tricount.com": { s: ".c--anim{display:none !important}" },
  "jobware.de": { s: ".cdk-overlay-container{display:none !important}" },
  "mjcb.io": { s: ".active.gdpr-container{display:none !important}" },
  "baden-tv.com": {
    s: ".--active.cmms_cookie_consent_manager{display:none !important} body{overflow: unset !important;}",
  },
  "termshub.io": { s: "#TermsHubCookieConsent{display:none !important}" },
  "app.outwrite.com": {
    s: ".e1nzdohi4.css-1kyupjy-cookie-popup-Wrapper{display:none !important}",
  },
  "logowanie.nn.pl": {
    s: ".Portal_module_portalDefault__af0b797a{display:none !important}",
  },
  "freizeitbad-greifswald.de": { s: ".fzbCookie{display:none !important}" },
  "linuxtechmore.com": { s: "#supermag-cookie-ify{display:none !important}" },
  "it.cmlink.com": { s: ".CookiesWrap{display:none !important}" },
  "dartshopper.de": { s: "#cookie{display:none !important}" },
  "ubook.at": { s: "#supi{display:none !important}", c: 85 },
  "sw-lindau.de": {
    s: "#gdpr-cookie-message-container{display:none !important}",
  },
  "auf1.info": { s: ".overflow-scroll{display:none !important}" },
  "auf1.tv": { s: ".overflow-scroll{display:none !important}" },
  "store.duolingo.com": {
    s: ".pd-cookie-banner-window{display:none !important}",
  },
  "revista.seg-social.es": {
    s: "#p_p_id_com_ss_cookies_layout_set_portlet_CookiesLayoutSetPortlet_{display:none !important}",
  },
  "thealliance.ai": {
    s: ".CookieAcceptance_cookieAcceptance__OPnox{display:none !important}",
  },
  "mytonafntastic.com": {
    s: ".Cookie_cookie-btn__EiMrW,#portal-root{display:none !important}",
  },
  "financestrategists.com": { s: "#gdrp{display:none !important}" },
  "traveloptimizer.de": { c: 85 },
  "schwiizer-schueuemli.de": {
    s: ".cookieBanner_bannerWrapper__J3Ikd{display:none !important}",
  },
  "1a-sehen.de": { s: "#cc-container{display:none !important}" },
  "cherryservers.com": {
    s: "div[x-data^=cookiesConsent]{display:none !important}",
  },
  "saturn.de": { c: 169 },
  "wong.pe": {
    s: ".swal2-shown.swal2-fade.swal2-bottom-left.swal2-container{display:none !important}",
    c: 85,
  },
  "iconnectfx.com": {
    s: ".cdk-overlay-container{display:none !important} html{overflow:unset !important} div[id*='AllowCookiePopup']{display:none !important}",
  },
  "saechsische.de": { j: 5 },
  "motorsport-total.com": { j: 5 },
  "gabler.de": { j: 5 },
  "autohaus.de": { j: 5 },
  "formel1.de": { j: 5 },
  "it-daily.net": { j: 5 },
  "radiobielefeld.de": { j: 5 },
  "verkehrsrundschau.de": { j: 5 },
  "insideevs.de": { j: 5 },
  "motor1.com": { j: 5 },
  "netzwelt.de": { j: 5 },
  "kicker.de": { j: 5 },
  "kicker.ch": { j: 5 },
  "zdf.de": { j: 5 },
  "3sat.de": { j: 5 },
  "heise.de": { j: 5 },
  "temu.com": { j: 6 },
  "all3dp.com": { j: 5 },
  "komoot.de": { j: 5 },
  "komoot.com": { j: 5 },
  "amiunique.org": { s: ".v-snack{display:none !important}" },
  "kbs-frb.be": { s: ".block-extendedcookiebanner{display:none !important}" },
  "tickets.ua": { s: ".app-cookies{display:none !important}" },
  "zentalk.asus.com": { c: 85 },
  "wir-machen-druck.de": { s: ".overflow-hidden{overflow: unset  !important}" },
  "sysdream.com": { c: 14 },
  "dlnews.com": { s: "#id-ts52sz{display:none !important}" },
  "technikum-wien.at": { c: 85 },
  "kwik-fit.com": { c: 14 },
  "iledefrance-mobilites.fr": { j: 5 },
  "handbuch-experten.de": { c: 85 },
  "malmoopera.se": { c: 85 },
  "angelplatz.de": { c: 85 },
  "livejasmin.com": {
    s: "#consent_modal{display:none !important} .consent_overlay_show{overflow:visible !important}",
  },
  "global.hario.com": { s: "#CookieDialog{display:none !important}" },
  "efortuna.pl": { s: "#cookie-consent-app{display:none !important}" },
  "growtopiagame.com": {
    s: ".in.fade.modal-backdrop{display:none !important} #consentModal{display:none !important}",
    c: 85,
  },
  "sklep.insel.pl": { s: "#st_notification_1{display:none !important}" },
  "pracodawcy.pracuj.pl": {
    s: "div[data-test=modal-cookie-bottom-bar]{display:none !important}",
  },
  "milford.de": {
    s: "div.acris-cookie-consent.is--modal{display: none !important} .show.fade.modal-backdrop{display: none !important} .modal-open{overflow: visible !important}",
  },
  "tweetyai.com": { s: "app-snackbar{display: none !important}" },
  "pradel-france.com": { s: "#bagdpr{display:none !important}" },
  "cfos-emobility.de": {
    s: "#modal_container{display: none !important} .modal-backdrop.fade.show{display:none !important}",
    c: 85,
  },
  "intelligenceonline.fr": {
    s: "#modalCookieConsent{display:none!important} .show.fade.modal-backdrop{display: none !important} .modal-open{overflow: visible !important}",
  },
  "antena3.com": { c: 85 },
  "bauer-baumschulen.ch": { c: 85 },
  "cameraworld.co.uk": { c: 85 },
  "favoptic.se": { c: 85 },
  "sorglos-guenstig-fahren.com": {
    s: ".ccm-root{display:none!important}",
    c: 85,
  },
  "douglas.nl": {
    s: ".modal-overlay__root.modal-overlay__general.uc-banner-modal.modal-overlay__transition-appear-done.modal-overlay__transition-enter-done{display:none!important} .modal-overlay__backdrop-enter-done.modal-overlay__backdrop-appear-done.modal-overlay__backdrop{display:none!important}",
    c: 85,
  },
  "biggreenegg.co.uk": {
    s: ".TheBiscuitBanner{display: none !important}",
    c: 85,
  },
  "makro.nl": {
    s: ".consent-disclaimer-intrusive.intrusive.consent-disclaimer.cms.component-position.generic-component.component{display: none !important}",
    c: 85,
  },
  "vinos.ch": {
    s: ".consent-cookie-box-light-box{display:none !important} .page-overlay{display:none!important}",
    c: 85,
  },
  "quiksilver-europe.at": { c: 85 },
  "podcast.hu": { c: 85 },
  "dt.mef.gov.it": { c: 85 },
  "leopoldshoehe.de": { c: 85 },
  "ladyzone.bg": { c: 85 },
  "kreis-bad-duerkheim.de": { c: 85 },
  "koveb.de": { c: 85 },
  "kg-camping.dk": { c: 85 },
  "all4running.be": { c: 85 },
  "atu.de": { c: 85 },
  "auto1.com": { c: 85 },
  "autohaus-reitermayer.de": { c: 85 },
  "autohaus24.de": { c: 85 },
  "kalmthout.bibliotheek.be": { c: 85 },
  "bihomes.es": { c: 85 },
  "btvnovinite.bg": { c: 85 },
  "btvplus.bg": { c: 85 },
  "btvsport.bg": { c: 85 },
  "businessnovinite.bg": { c: 85 },
  "bzfe.de": { c: 85 },
  "canterbury.ac.nz": { c: 85 },
  "cathaypacific.com": { c: 85 },
  "claussen-simon-stiftung.de": { c: 85 },
  "commerzbank.de": { c: 85 },
  "correos.es": { c: 85 },
  "crocs.co.uk": { j: "5" },
  "e-zikoapteka.pl": { j: 5 },
  "foraum.de": { c: 85 },
  "freiheit.org": { c: 85 },
  "gesipa.de": { c: 85 },
  "goteborg2023.com": { c: 85 },
  "haustier-berater.de": { c: 85 },
  "ijaminecraft.com": { c: 85 },
  "iskon.hr": { c: 85 },
  "renault-hoffmann-niedernhausen.de": { c: 85 },
  "renault-spenrath-juelich.de": { c: 85 },
  "roundhouse.org.uk": { c: 85 },
  "slow-cosmetique.com": { c: 85 },
  "swedbankrobur.se": { c: 85 },
  "tobycarvery.co.uk": { c: 85 },
  "toshiba-aircondition.com": { c: 85 },
  "box.baldursgate3.game": { s: ".ciastko{display: none !important}" },
  "macerkopf.de": { c: 85 },
  "www.mjob.si": { s: ".jss78{display: none !important}" },
  "autoweek.nl": { j: 5 },
  "tunemymusic.com": {
    s: ".HeaderMenu_CookieAlert__ipEfK{display:none !important}",
  },
  "webopedia.com": { s: ".wo-consent{display:none !important}" },
  "drudgereport.com": { s: "#dr_dae_consent{display:none !important}" },
  "parksystems.com": {
    s: ".seers-cmp-cookie-data-hol{display:none !important}",
  },
  "lightexpert.nl": { s: "#cookie{display:none !important}" },
  "biggreenegg.co.uk": {
    s: ".TheBiscuitBanner{display:none !important}",
    c: 85,
  },
  "cameraworld.co.uk": {
    j: 5,
    s: "._has-modal{overflow: unset!important} .pr-cookie-modal-wall, .modals-overlay{display:none !important}",
  },
  "favoptic.se": { c: 14 },
  "1000.menu": { s: "#cookiescript_injected_wrapper{display:none!important}" },
  "1a-garten-krauss.de": { c: 85 },
  "365direkte.no": {
    s: ".cookie-consent-banner-modal{display:none!important}",
    c: 85,
  },
  "acierto.com": { s: ".vwo-overlay{display:none!important}", c: 85 },
  "advantageaustria.org": { s: "#cookies{display: none !important}", c: 85 },
  "amd.by": { c: 85 },
  "americanexpress.ch": {
    s: ".a-backdrop.state-a-backdrop--visible{display: none !important; visibility: hidden}",
    c: 85,
  },
  "andersiahotel.pl": { c: 85 },
  "toyota.astra.co.id": { s: "#cookieSection{display:none!important}" },
  "auo.com": {
    s: ".gdpr-mask{display:none!important} .gdpr{display: none !important}",
    c: 85,
  },
  "autocont.cz": { s: ".cookie-fade-window{display:none!important}", c: 85 },
  "autodoc.fi": { s: ".overlay{display:none!important}", c: 85 },
  "baldursgate3.game": { s: "div[class=ciastko]{display:none!important}" },
  "bargaintown.ie": { s: "#cookies-popup{display:none!important}", c: 85 },
  "bbr.dk": { s: ".eksCookieContainer{display:none!important}", c: 85 },
  "becharge.de": { s: ".cookie_blocker{display:none!important}" },
  "bidli.cz": { s: ".cookies-canvas{display:none!important}", c: 85 },
  "bingen-ruedesheimer.de": {
    s: ".pcblocker{display:none!important} .pc_privacy-badge{display: none !important}",
    c: 85,
  },
  "bunq.com": { s: ".fs-cc-components{display:none!important}" },
  "centrotiziano.it": { c: 85 },
  "cinch.co.uk": {
    s: ".cookie-consent_overlay__QytSD{display:none!important}",
    c: 85,
  },
  "crossnative.com": {
    s: ".cookie-consent_overlay__X8p9d{display:none!important}",
  },
  "delano.de": {
    s: "#gatewayWindowShadestacks_in_3313_5{display:none!important}",
  },
  "digineb.eu": { c: 85 },
  "etelecinema.hu": {
    s: ".etele-mainlayout-cookieconsent{display:none!important}",
    c: 85,
  },
  "fixpart.be": { s: ".fp-cookie-modal{display:none!important}", c: 85 },
  "flip.gr": { s: ".cookie-modal{display:none!important}", c: 85 },
  "focusonreproduction.eu": { s: ".jss157{display:none!important}", c: 85 },
  "foma.cz": {
    s: ".mfp-wrap{display:none!important} .mfp-bg{display: none !important}",
    c: 85,
  },
  "garten-sauer.de": { c: 85 },
  "gastrokuchyn.cz": { s: ".electro-overlay{display:none!important}", c: 85 },
  "grandcentralhotelbelfast.com": {
    s: "#ACClayerBackground{display:none!important}",
    c: 85,
  },
  "badlion.net": { c: 85 },
  "empik.com": { c: 85 },
  "play.esea.net": { c: 85 },
  "humanic.net": { c: 85 },
  "kontist.com": { c: 85 },
  "make-it-in-germany.com": { c: 85 },
  "dt.mef.gov.it": { c: 85 },
  "mybestbrands.de": { c: 85 },
  "myunidays.com": { c: 85 },
  "presseportal.de": { c: 85 },
  "region-bayreuth.de": { c: 85 },
  "soliver.si": { c: 85 },
  "tech-faq.net": { c: 85 },
  "thega-filmpalast.de": { c: 85 },
  "trendmutti.com": { c: 85 },
  "tvo.de": { c: 85 },
  "pawsact.vier-pfoten.de": { c: 85 },
  "happiesthealth.com": {
    s: "#elementor-popup-modal-9004111222217834{display:none!important}",
    c: 85,
  },
  "sportland.com": { c: 85 },
  "med.uni-rostock.de": {
    s: ".mm-menu{display:none!important} body > dialog{display: none!important}",
    c: 85,
  },
  "testo.com": { c: 23 },
  "bunq.com": { s: ".fs-cc-components{display:none !important}" },
  "hypeclothinga.com": { s: "#__next > .chakra-fade{display:none !important}" },
  "watch-strap.eu": { s: ".cookies_panel_2022{display:none !important}" },
  "remienky.sk": { s: ".cookies_panel_2022{display:none !important}" },
  "incrypted.com": { s: ".incrypted-cookie-bar{display:none !important}" },
  "hello.one": { c: 3 },
  "postoffice.co.uk": { s: "#app > .absolute.w-full{display:none !important}" },
  "opovo.com.br": { s: ".notificacao-estatica{display:none !important}" },
  "websummit.com": { s: 'div[class*="civic_cookie"]{display:none !important}' },
  "lezec-shop.cz": { s: "#ccmng{display:none !important}" },
  "christabehr-jerusalem.de": {
    s: ".mini_cookie_stack{display:none !important}",
  },
  "thiriet.ch": { s: "#pv{display:none !important}" },
  "fizza.se": {
    s: 'div[data-storage-item*="cookiename"]{display:none !important}',
  },
  "ecos.am": { s: ".cookies-modal{display:none !important}" },
  "myorbit.id": {
    s: "#nav-bar > div:first-child:not(:only-child){display:none !important}",
  },
  "justice.cz": { c: 34 },
  "madrid.es": { s: 'div[id*="iam-cookie"]{display:none !important}' },
  "luminpdf.com": {
    s: '#app > div[style=""]:nth-child(2){display:none !important}',
  },
  "vsemayki.ru": {
    s: '#__next > div > section[style*="bottom"]{display:none !important}',
  },
  "rejlers.fi": {
    s: '.shadow-form[data-controller*="cookies--alert"]{display:none !important}',
  },
  "bestofdate.com": { s: "#ww-blackout{display:none !important}" },
  "umm.nordpoolgroup.com": { s: "#modal-overlay{display:none !important}" },
  "insightsforprofessionals.com": {
    s: ".cookie-container{display:none !important}",
  },
  "icex.es": { s: "#cookies,#cookies-message-new{display:none !important}" },
  "slidelizard.com": { s: "#cookie-info-dialog{display:none !important}" },
  "becherovka.com": { s: ".visible_cookie_panel{display:none !important}" },
  "d2iq.com": { s: ".banner-alert{display:none !important}" },
  "morfose.flexxis.nl": { s: "footer{display:none !important}" },
  "askimsrostfria.se": { s: ".cm-claw{display:none !important}" },
  "tcs-mymed.ch": {
    s: "#__next > div > div[class]:nth-last-child(2){display:none !important}",
  },
  "fotka.com": {
    s: '#app-core div[class*="cookies-info"]{display:none !important}',
  },
  "johanneswerk.de": { s: "#cc{display:none !important}" },
  "escrapalia.com": {
    s: ".visible.transition.cookies-policy{display:none !important}",
  },
  "kaartje2go.be": { s: ".consentmodal{display:none !important}" },
  "sendasmile.de": { s: ".consentmodal{display:none !important}" },
  "starbucks.com.sg": { s: ".cookie-modal{display:none !important}" },
  "educont.ru": { s: ".cookies-dialog-container{display:none !important}" },
  "liberties.eu": { s: ".gdpr-window{display:none !important}" },
  "nativebase.io": { s: "#__next > .font-poppins{display:none !important}" },
  "technologynetworks.com": {
    s: ".base_privacy_policy_notification{display:none !important}",
  },
  "charactercountonline.com": { s: "#consentBox{display:none !important}" },
  "ivry94.fr": { s: "#myModalCookieConsent{display:none !important}" },
  "grillfuerst.de": { s: "#cb-overlay{display:none !important}" },
  "teleauskunft.de": { s: ".cookie-container{display:none !important}" },
  "i-surance.eu": { s: "#cookiesAcceptance{display:none !important}" },
  "ungeziefer-ratgeber.info": { s: "#cc--main{display:none !important}" },
  "antagning.se": { s: "#cookie-law{display:none !important}" },
  "flockler.com": {
    s: '.fl-cookie-banner[data-state="open"]{display:none !important}',
  },
  "einkaufsbahnhof.de": {
    s: ".btn--cookies,.cookies{display:none !important}",
  },
  "xn--gnstiger-reisen-zvb.de": { s: "#overlay{display:none !important}" },
  "xn--80aalaegy7apkaw4n.xn--p1ai": {
    s: "#privacypolicy{display:none !important}",
  },
  "xn--80ahmohdapg.xn--80asehdb": {
    s: ".cookie,#app .page-notification{display:none !important}",
  },
  "xn--xxlmbel-d1a.de": { s: ".cookie-container{display:none !important}" },
  "xn--ko-roller-z7a.at": { s: "#gdpr-w,#gdpr-o{display:none !important}" },
  "xn--ko-roller-z7a.ch": { s: "#gdpr-w,#gdpr-o{display:none !important}" },
  "scooter-elettrici.it": { s: "#gdpr-w,#gdpr-o{display:none !important}" },
  "electricscooters.eu": { s: "#gdpr-w,#gdpr-o{display:none !important}" },
  "lekker.de": { s: "#cookieboxBackgroundModal{display:none !important}" },
  "loteriamkcafe.pl": { s: "#pop_up{display:none !important}" },
  "bloomreach.com": { s: ".exp-cookies-obal{display:none !important}" },
  "frigelar.com.br": { s: "#modalPrivacyPolicy{display:none !important}" },
  "hospitalesparque.es": { s: "#gdpr-modal{display:none !important}" },
  "optoma.de": { s: "#msgbg{display:none !important}" },
  "optoma.it": { s: "#msgbg{display:none !important}" },
  "optoma.fr": { s: "#msgbg{display:none !important}" },
  "optoma.nl": { s: "#msgbg{display:none !important}" },
  "optoma.es": { s: "#msgbg{display:none !important}" },
  "optoma.ru": { s: "#msgbg{display:none !important}" },
  "optoma.pl": { s: "#msgbg{display:none !important}" },
  "optoma.be": { s: "#msgbg{display:none !important}" },
  "optomaeurope.com": { s: "#msgbg{display:none !important}" },
  "stagobel.be": { s: 'div[x-data*="alpineGdpr"]{display:none !important}' },
  "monuta.nl": {
    s: "monuta-cookie-compliance-banner{display:none !important}",
  },
  "nplus1.ru": { s: "footer .fixed{display:none !important}" },
  "joomshaper.com": { s: "#cookie-consent{display:none !important}" },
  "didriksons.com": {
    s: 'div[class*="tracking-consent"]{display:none !important}',
  },
  "fondsclever.de": { s: "#cWgtCooHin{display:none !important}" },
  "pascoe.de": { s: ".tx-pascoe-consent-manager{display:none !important}" },
  "2captcha.com": {
    s: ".app-level-notifications__item_cookies-policy{display:none !important}",
  },
  "spendee.com": {
    s: "#app > div > div:last-child > div:first-child{display:none !important}",
  },
  "forklog.com": { s: ".terms_popup{display:none !important}" },
  "hollandbikeshop.com": { s: ".cookies-sec{display:none !important}" },
  "ncgmovies.com": { s: ".v-notification-list{display:none !important}" },
  "intelligent-heizen.info": { s: "#bs-cookie-bar{display:none !important}" },
  "back4app.com": { s: "footer ~ .w-full.fixed{display:none !important}" },
  "smahospital.jp": { s: ".p-gdpr{display:none !important}" },
  "vr.it": { c: 3 },
  "hardstuck.gg": { s: "#hs-accept-cc{display:none !important}" },
  "aena.es": { s: ".cookies-elixregtech{display:none !important}" },
  "niederoesterreich-card.at": { s: ".cc{display:none !important}" },
  "e-muse.com.tw": {
    s: ".container-component > .dialog ~ div:last-child,.ns-cookie-privacy-wrapper{display:none !important}",
  },
  "libmanuels.fr": { s: "ion-app ~ div{display:none !important}" },
  "blog.mega-energie.fr": { s: "#cookiesModal{display:none !important}" },
  "npl.co.uk": { c: 20 },
  "socialstyrelsen.se": { s: ".sos-ck-cnsnt-mgnr{display:none !important}" },
  "sportson.se": { s: ".info-message{display:none !important}" },
  "theglobaleconomy.com": { c: 2 },
  "unscreen.com": { s: ".banner.fixed-bottom{display:none !important}" },
  "visitczechrepublic.com": {
    s: ".czt-cookie-bar__backdrop{display:none !important}",
  },
  "samsungpromotions.claims": {
    s: ".v-cookie-policy{display:none !important}",
  },
  "24smi.org": { s: ".cookie-modal{display:none !important}" },
  "xeit.ch": {
    s: "#x-cookie-banner,.xeit-dsgvo-alert{display:none !important}",
  },
  "biomecanics.com": { c: 34 },
  "garvalin.com": { c: 34 },
  "grahamhancock.com": { s: "#cookie-law{display:none !important}" },
  "8x8.vc": { s: "#success > div > div:last-child{display:none !important}" },
  "volksbund.de": { s: "#cc{display:none !important}" },
  "oneclickcover.com": { s: "footer ~ .root{display:none !important}" },
  "outl1.se": {
    s: 'footer ~ div:not([style*="fixed"]){display:none !important}',
  },
  "pcradio.ru": { s: ".privacy-block{display:none !important}" },
  "sharphomeappliances.com": {
    s: "#cookieModuleModal{display:none !important}",
  },
  "testfully.io": { s: ".cookie-modal{display:none !important}" },
  "knigogid.ru": { s: ".b-cookie{display:none !important}" },
  "uwec.edu": { s: "#_pc{display:none !important}" },
  "wspay.info": { s: "#open_preferences_center{display:none !important}" },
  "kiswe.com": { s: ".popup{display:none !important}" },
  "tietalent.com": { s: "#__next footer ~ div{display:none !important}" },
  "spokojenypes.cz": { s: ".cookie-setting{display:none !important}" },
  "rudderstack.com": {
    s: "#footer-container ~ div,.headerNav ~ .bottom-0{display:none !important}",
  },
  "rodadas.net": { s: ".faldonCookies{display:none !important}" },
  "ajbell.co.uk": { s: "#cookie-modal{display:none !important}" },
  "hendrix-genetics.com": { s: ".cookie-container{display:none !important}" },
  "tise.com": { s: "#app > nav + div ~ div{display:none !important}" },
  "motorola.com.ar": { s: "#motorola-cookies{display:none !important}" },
  "whos-perfect.de": { s: "#cookie-consent{display:none !important}" },
  "bigcommerce.com": {
    s: 'div[class*="ConsentManager"]{display:none !important}',
  },
  "insolve.hr": { s: "#cookieModal{display:none !important}" },
  "long-covid.at": { s: "#consent{display:none !important}" },
  "koketsfavoriter.se": { c: 20 },
  "iru.ru": { s: "#policyBlockForFirstVisit{display:none !important}" },
  "suntransfers.com": { s: ".c-alert-cookie{display:none !important}" },
  "ampli.com.br": { s: "cookie-police-bar{display:none !important}" },
  "vitriini.fi": { s: ".ltcn{display:none !important}" },
  "arbesko.com": { s: ".ltcn{display:none !important}" },
  "remitly.com": {
    s: 'footer > [class^="footer"] ~ div{display:none !important}',
  },
  "privfile.com": { s: "#scNotiBanner{display:none !important}" },
  "smugmug.com": {
    s: ".sm-cookie-consent{display:none !important;visibility:hidden}",
  },
  "planethappy.de": { s: ".popup-overlay{display:none !important}" },
  "businessinsider.in": { s: ".consent-popup{display:none !important}" },
  "politico.eu": { s: "#pl-sp-privacy-button{display:none !important}" },
  "picoxr.com": {
    s: "#pico_website > section:first-of-type:not(:only-of-type){display:none !important}",
  },
  "secrid.com": { s: 'div[class*="CookiesLabel"]{display:none !important}' },
  "camping-app.info": {
    s: "#cokmodal,.modal-backdrop{display:none !important}",
  },
  "gateway.one": { s: ".alert-info{display:none !important}" },
  "lada.ru": { s: "#main-scroll-layer ~ div{display:none !important}" },
  "ixbt.com": { s: ".gdpr-root{display:none !important}" },
  "localrent.com": { s: ".privacy_policies{display:none !important}" },
  "epiphone.com": { s: "#cookieModal{display:none !important}" },
  "frenchentree.com": { s: ".dpl-cookie-banner{display:none !important}" },
  "sonarworks.com": { s: "footer ~ .sticky{display:none !important}" },
  "vecer.com": { s: 'div[x-show="show"] > .fixed{display:none !important}' },
  "veho.fi": { s: ".z-cookie-alert{display:none !important}" },
  "bau-tech.shop": { s: "#cookie-consent{display:none !important}" },
  "foxtrail.fjallraven.com": { s: "main ~ section{display:none !important}" },
  "raeer.com": { s: "#RaeerGoogleCookiesBox{display:none !important}" },
  "cyberfolks.pl": { s: ".cfGdprCookieConsentPopup{display:none !important}" },
  "logitec.co.jp": {
    s: "datasign-widget-web-component{display:none !important}",
  },
  "completeaquatics.co.uk": {
    s: ".carcona-cookie-notice{display:none !important}",
  },
  "rollstuhl-kurier.de": { s: "#webwerk-cookies{display:none !important}" },
  "infiniti.com": { s: ".c_128{display:none !important}" },
  "spinbackup.com": { s: ".spin-ai-gtm-banner{display:none !important}" },
  "finna.cat": { s: "#cookies_configuration{display:none !important}" },
  "rikstv.no": { s: "#cookie-consent{display:none !important}" },
  "tue.nl": { s: "#cookie-consent{display:none !important}" },
  "inserv.lv": { s: "#cookie-consent{display:none !important}" },
  "rockymountaineer.com": { s: ".l-page__cookies{display:none !important}" },
  "prozon.com": { s: "#rgpd-popup-container{display:none !important}" },
  "aplikuj.pl": { s: 'div[x-data="cookie"]{display:none !important}' },
  "mybanker.dk": { s: "#mybanker-cookie-consent{display:none !important}" },
  "ullstein.de": {
    s: 'div[role="alertdialog"][aria-label*="Cookies"]{display:none !important}',
  },
  "tehnomanija.rs": { s: ".CookiesConsentSlot{display:none !important}" },
  "kramerguitars.com": { s: "#cookieModal{display:none !important}" },
  "melectronics.ch": {
    s: ".skel--main ~ div:last-of-type{display:none !important}",
  },
  "mainz.de": { s: "sp-consent-banner{display:none !important}" },
  "movieinsider.de": { s: "#consent{display:none !important}" },
  "fs.com": { c: 20 },
  "confused.com": { s: "t-cookie-popup{display:none !important}" },
  "akwarystyczny24.pl": {
    s: 'div[id*="cookiemodule"]{display:none !important}',
  },
  "bons-plans-voyage-new-york.com": {
    s: "#vef-cookie-notice{display:none !important}",
  },
  "yandex.com": {
    s: '.app div[class*="Cookie__cookie"],div[data-cookiebanner]{display:none !important}',
  },
  "toloka.ai": { s: "div[data-cookiebanner]{display:none !important}" },
  "webnode.com": { s: ".w-cookie-bar{display:none !important}" },
  "angel-domaene.de": { s: "#cookie-consent{display:none !important}" },
  "volvocars-partner.pl": { s: ".cookies_relative{display:none !important}" },
  "them.us": {
    s: '.page > div[class*="MessageBanner"]{display:none !important}',
  },
  "wired.com": {
    s: '.page > div[class*="MessageBanner"]{display:none !important}',
  },
  "gq.com": {
    s: '.page > div[class*="MessageBanner"]{display:none !important}',
  },
  "spoutible.com": {
    s: ".cookie-alert-modal,.modal-backdrop{display:none !important}",
  },
  "krasserstoff.com": { s: "#messageboard{display:none !important}" },
  "mvideo.ru": { s: "mvid-cookie-notification{display:none !important}" },
  "chipsnsips.com": { s: ".third-party-optin{display:none !important}" },
  "caf.com": { s: "#cafModal{display:none !important}" },
  "sweez.ch": { s: "#cookies-adviser{display:none !important}" },
  "esbank.pl": { s: "#cookie_info_es{display:none !important}" },
  "nexcess.net": {
    s: 'div[class*="CookieAcceptance"]{display:none !important}',
  },
  "woolworth.de": { s: "#CybotCookiebotDialog{display:none !important}" },
  "woolworth.pl": { s: "#CybotCookiebotDialog{display:none !important}" },
  "uwartsonline.nl": { s: "#cookie-consent-modal{display:none !important}" },
  "clubmed.us": { s: ".Layout > .fixed{display:none !important}" },
  "yamibuy.com": { c: 20 },
  "atlasstoked.com": { s: ".gdprModal{display:none !important}" },
  "finn.no": { s: "#schibsted-banner{display:none !important}" },
  "motek.no": { s: ".js-gdpr{display:none !important}" },
  "coloursofistria.com": { s: ".altcm-fixed{display:none !important}" },
  "levnesporaky.cz": {
    s: "#EuConsentV2,.modal-backdrop{display:none !important}",
  },
  "startapro.hu": { c: 3 },
  "barenbrug.fr": { s: "vk-cookie-manager{display:none !important}" },
  "hdz-nrw.de": { s: ".cc{display:none !important}" },
  "mbl.is": { s: "#cookie-consent{display:none !important}" },
  "cdlens.com": { s: ".jsPrivacy{display:none !important}" },
  "bitvavo.com": { s: "#cookie-wall{display:none !important}" },
  "viperhardseltzer.nl": { s: ".customOverlaybc{display:none !important}" },
  "mazout-on-line.be": { s: ".cl-banner{display:none !important}" },
  "nitropack.io": { s: "#cookie-consent{display:none !important}" },
  "magentatv.pl": { s: 'nav > [class*="InfoBar"]{display:none !important}' },
  "globalsolaratlas.info": { s: "gsa-cookie-banner{display:none !important}" },
  "digita.ai": { s: ".alert-popup{display:none !important}" },
  "ruegenmagic.de": { s: "#confirm_cookies{display:none !important}" },
  "licenseglobal.com": {
    s: "#__next > .fixed.bottom-0{display:none !important}",
  },
  "bellevue-hamburg.de": {
    s: "body > div > .fixed.bottom-0{display:none !important}",
  },
  "bibleserver.com": { s: "#CybotCookiebotDialog{display:none !important}" },
  "lexmark.com": { s: ".tui-gdpr{display:none !important}" },
  "calabria7.it": { s: ".elementor-location-popup{display:none !important}" },
  "syrovarnya.com": {
    s: 'div[class*="cookiesMessage"]{display:none !important}',
  },
  "venngage.com": { s: ".gdpr{display:none !important}" },
  "weedmaps.com": {
    s: 'div[data-testid="notification"]{display:none !important}',
  },
  "met.com": { s: ".met-cookie{display:none !important}" },
  "satfilm.pl": { s: ".App > footer ~ div{display:none !important}" },
  "drank.nl": { s: "header ~ .fixed.bottom-0{display:none !important}" },
  "florinus.lt": { s: ".blah_blah_blah_holder{display:none !important}" },
  "finis-feinstes.at": { s: ".cookie-shadow{display:none !important}" },
  "chocoladepartners.nl": { s: ".ec-notices{display:none !important}" },
  "superbexperience.com": {
    s: "#root > div > .container-style{display:none !important}",
  },
  "historiademexicobreve.com": {
    s: ".wpfront-fixed-position{display:none !important}",
  },
  "wasserkunst-hamburg.de": { s: '[id*="koekje"]{display:none !important}' },
  "toolfix.ie": {
    s: "#mz_genericOverlay,.mz_cookieConsent{display:none !important}",
  },
  "heavins.ie": {
    s: "#mz_genericOverlay,.mz_cookieConsent{display:none !important}",
  },
  "metademolab.com": {
    s: '#root > div[style*="fixed"]{display:none !important}',
  },
  "zen.com": {
    s: '.disable-background::before,div[id*="ppms_cm"]{display:none !important}',
  },
  "economictimes.com": {
    s: ".privacy_block,.du_consent{display:none !important}",
  },
  "miniclip.com": { s: ".mc-consents-wrapper{display:none !important}" },
  "mekkafood.com": { s: "#cookieprefs{display:none !important}" },
  "laboremus.de": { s: 'body > div[style*="fixed"]{display:none !important}' },
  "defacto.com.tr": { s: "#kvkk_notification{display:none !important}" },
  "ebc.com.br": {
    s: "#sliding-popup,#viewlet-disclaimer{display:none !important}",
  },
  "shopee.com.br": {
    s: '#main > div > div[style*="z-index"]{display:none !important}',
  },
  "kp.ua": { s: ".modal_policy{display:none !important}" },
  "thepodcasthost.com": { s: ".tph-cookie-notice{display:none !important}" },
  "swisstours.com": { s: ".cookiesApproval{display:none !important}" },
  "eobuwie.com.pl": { s: ".modal-consents{display:none !important}" },
  "jvctv.eu": { s: 'div[id*="cookieModule"]{display:none !important}' },
  "yesterdaystractors.com": { s: "#dvCookieMessage{display:none !important}" },
  "solidaris-wallonie.be": {
    s: "app-pop-up-tracking{display:none !important}",
  },
  "stuffthatworks.health": {
    s: ".snackbar-disclaimer{display:none !important}",
  },
  "space.cc": { s: 'div[class*="cookiepig"]{display:none !important}' },
  "gcore.com": { s: "gcore-cookies-settings{display:none !important}" },
  "smallworldfs.com": { s: "#barCookies{display:none !important}" },
  "asna.ru": { s: 'div[class*="modalCookies"]{display:none !important}' },
  "jtl-software.de": { s: "#consent{display:none !important}" },
  "nooz-optics.com": {
    s: "#gatsby-focus-wrapper > .fixed.bottom-0{display:none !important}",
  },
  "tuasaude.com": { s: ".consent-bar-wrapper{display:none !important}" },
  "webshop.nl": { s: 'div[class*="Gdpr-module"]{display:none !important}' },
  "kicksmaniac.com": {
    s: "#cookie-modal,.cookie-button{display:none !important}",
  },
  "huge.se": { s: ".section-cookies-notice-outer{display:none !important}" },
  "knime.com": { s: ".cookie-modal{display:none !important}" },
  "public.gr": {
    s: 'section[class*="CookiesConsent"]{display:none !important}',
  },
  "fresha.com": {
    s: 'div[class*="Toast"] ~ div[class*="Wrapper"] ~ div{display:none !important}',
  },
  "singlebox.app": { s: "footer ~ .fixed{display:none !important}" },
  "telekom.mk": { s: "#cookiesModal{display:none !important}" },
  "telekom.sk": { s: ".con-ban-wrapper{display:none !important}" },
  "yourwineonline.be": { c: 34 },
  "fh-zwickau.de": {
    s: ".tx-whzcookieconsent-banner{display:none !important}",
  },
  "emailleschilder.de": { s: ".cb-wrapper{display:none !important}" },
  "eventfrog.ch": { s: "#tf-modal-container{display:none !important}" },
  "eventfrog.de": { s: "#tf-modal-container{display:none !important}" },
  "addnorth.se": { s: "footer ~ .messages{display:none !important}" },
  "mubert.com": { s: ".notification-manager{display:none !important}" },
  "e-food.gr": {
    s: "#smartbanner-container + div > div:last-child:not(:only-child){display:none !important}",
  },
  "wszystko.pl": { s: "wpl-cookies{display:none !important}" },
  "arsys.fr": { s: '.drop[name="cookies"]{display:none !important}' },
  "arsys.pt": { s: '.drop[name="cookies"]{display:none !important}' },
  "arsys.net": { s: '.drop[name="cookies"]{display:none !important}' },
  "canyon.eu": { s: ".fixed.bottom-0{display:none !important}" },
  "helthjem.no": { s: ".schibsted-bar{display:none !important}" },
  "sunglasses-shop.bg": { s: ".notification-wrapper{display:none !important}" },
  "lazoptics.gr": { s: ".new-cookie-supercontainer{display:none !important}" },
  "eyeons.com": { s: ".alternis-cookie{display:none !important}" },
  "book.io": { s: ".foobar-cookie{display:none !important}" },
  "ncts.ie": { s: ".nctoverlay,#cookiesBtn{display:none !important}" },
  "tapo.com": { s: "#tapo-cookie{display:none !important}" },
  "evercast.us": {
    s: ".ck-cookie-w,.cookie-preference-button{display:none !important}",
  },
  "learngerman.dw.com": {
    s: ".content-container > footer ~ div{display:none !important}",
  },
  "surfshark.com": {
    s: '#__next > footer ~ div[class*="animationEnterDone"]{display:none !important}',
  },
  "lekarna.cz": { s: "#popup-customer-data{display:none !important}" },
  "suhrkamp.de": { s: "#whcm{display:none !important}" },
  "gov.in": { s: ".cookies-wrapper{display:none !important}" },
  "moneytalksnews.com": { s: "#footer-overlay{display:none !important}" },
  "mango.com": { c: 2 },
  "koenigsegg.com": {
    s: 'section[data-component*="cookie-notice"]{display:none !important}',
  },
  "kozterkep.hu": { s: "#cookie-consent{display:none !important}" },
  "studentendrukker.be": {
    s: "#cookieConsentModal,.iziModal-overlay{display:none !important}",
  },
  "autokiila.fi": { s: ".cookie-box{display:none !important}" },
  "ipon.hu": { s: 'div[x-data="cookiePolicy"]{display:none !important}' },
  "thenounproject.com": {
    s: 'div[data-callback*="CookiesBanner"]{display:none !important}',
  },
  "tzdubrovnik.hr": { s: "#mygdprPopupHR{display:none !important}" },
  "forbesenespanol.com": {
    s: '.fixed[data-toast*="cookies"]{display:none !important}',
  },
  "incogni.com": {
    s: 'aside[class*="cookie-consent"]{display:none !important}',
  },
  "reimaginethegame.economist.com": {
    s: 'div[class*="tracking_banner"]{display:none !important}',
  },
  "myshopify.com": {
    s: "#shopillaxcookielaw-wrapper{display:none !important}",
  },
  "shopify.com": {
    s: '.tw-sticky[data-controller="cookies-notice"]{display:none !important}',
  },
  "hospitaldaluz.pt": { s: "#RootCookieTool{display:none !important}" },
  "pildorasdefe.net": { c: 34 },
  "academy.com": {
    s: '.content-wrapper > div > div[role="complementary"]{display:none !important}',
  },
  "menobr.ru": { s: 'div[class*="cookieContainer"]{display:none !important}' },
  "alvexo.com": { s: ".sticky_cookies_txt{display:none !important}" },
  "att.com": { s: "#gpc-banner-container{display:none !important}" },
  "cvent.com": {
    s: 'div[data-cvent-id*="cookie-banner"]{display:none !important}',
  },
  "nchsoftware.com": { s: "#ckndiv{display:none !important}" },
  "bulgarianproperties.com": { s: "#cookie_bar_new{display:none !important}" },
  "bulgarianproperties.bg": { s: "#cookie_bar_new{display:none !important}" },
  "landtag.de": { s: "#matomo-cookie-consent{display:none !important}" },
  "uferstudios.com": { s: "hylo-cookie-banner{display:none !important}" },
  "weingarten-grosse-groessen.de": {
    s: ".cc-overlay{display:none !important}",
  },
  "der-metronom.de": { s: ".cc-overlay{display:none !important}" },
  "wd40.nl": { s: 'div[x-data="cookieModal"]{display:none !important}' },
  "laumat.at": { s: "#laumatcookiebox{display:none !important}" },
  "stempel-bestellen.de": { s: "#swCookieAccept{display:none !important}" },
  "pornmd.com": { s: "#hiding_div{display:none !important}" },
  "webex.com": {
    s: "#theme-provider > div[class]:first-child:not(:only-child){display:none !important}",
  },
  "montaleparfums.com": {
    s: "#montale_cookie_consent_banner{display:none !important}",
  },
  "agoda.com": { s: ".ConsentBanner{display:none !important}" },
  "reebok.eu": {
    s: 'section[data-test="cookie-banner"]{display:none !important}',
  },
  "miles-mobility.com": {
    s: 'div[data-testid="cookie-consent"]{display:none !important}',
  },
  "librinova.com": { s: ".ln-cookie-consent{display:none !important}" },
  "wpbakery.com": { s: ".top-message{display:none !important}" },
  "visualcomposer.com": { s: ".top-message{display:none !important}" },
  "macpaw.com": {
    s: '#root > div[class*="notification"]{display:none !important}',
  },
  "privacysavvy.com": { s: ".ps-cookiebar{display:none !important}" },
  "cgd.pt": { s: "#CgdCookieManager{display:none !important}" },
  "jobs.jobconvo.com": { s: "#root ~ div{display:none !important}" },
  "ed-live.de": { s: "#mhCookie_container{display:none !important}" },
  "velovert.com": { s: "#modal_cookies{display:none !important}" },
  "geld.de": { s: ".geld-layer-cookie-approval{display:none !important}" },
  "voissy.com": { s: "#pb-navbar-cookies-accept{display:none !important}" },
  "charliemonroe.net": { c: 20 },
  "helitransair.com": { s: ".privacyoption_overlay{display:none !important}" },
  "answerthepublic.com": { s: ".cookie-main{display:none !important}" },
  "timestore.cz": { c: 3 },
  "ljekarna-pablo.hr": {
    s: ".gdpr-container-wrapper{display:none !important}",
  },
  "destinations.ua": { c: 34 },
  "l28.nl": { s: "#cookie_popup_body{display:none !important}" },
  "24tv.ua": { s: ".private-policy{display:none !important}" },
  "postnl.nl": { s: "pnl-cookie-wall-widget{display:none !important}" },
  "postnl.be": { s: "pnl-cookie-wall-widget{display:none !important}" },
  "vente-unique.com": { s: "#vu_consent{display:none !important}" },
  "vente-unique.be": { s: "#vu_consent{display:none !important}" },
  "vente-unique.it": { s: "#vu_consent{display:none !important}" },
  "vente-unique.pl": { s: "#vu_consent{display:none !important}" },
  "vente-unique.ch": { s: "#vu_consent{display:none !important}" },
  "vente-unique.pt": { s: "#vu_consent{display:none !important}" },
  "vente-unique.es": { s: "#vu_consent{display:none !important}" },
  "vente-unique.lu": { s: "#vu_consent{display:none !important}" },
  "venta-unica.com": { s: "#vu_consent{display:none !important}" },
  "kauf-unique.at": { s: "#vu_consent{display:none !important}" },
  "millenniumbcp.pt": { s: 'div[id*="CookiesMsg"]{display:none !important}' },
  "gocompare.com": { s: "#gc-stickee-cookie-banner{display:none !important}" },
  "telcel.com": {
    s: ".telcel-banner-aviso-cookies,.comp-telcel-banner-superior{display:none !important}",
  },
  "swedoffice.se": { s: "#cbckchangeholderFirst{display:none !important}" },
  "panelinha.com.br": { s: "#lgpd{display:none !important}" },
  "hmv.com": { s: ".ns-type-notice{display:none !important}" },
  "meteum.ai": { s: ".gdpr__form{display:none !important}" },
  "softwaretested.com": { s: "#privacy-popup{display:none !important}" },
  "atende.net": {
    s: ".termos_cookie_privacidade,#btn-open-preferencia-cookies{display:none !important}",
  },
  "meduza.io": { s: ".GDPRPanel-module-root{display:none !important}" },
  "esjobogarden.se": {
    s: "#cookie-consent-modal,.modal-backdrop{display:none !important}",
  },
  "biancodipuro.ch": { s: ".ngcookiewarning{display:none !important}" },
  "greatone.pl": { s: "#zamknij_cookies{display:none !important}" },
  "recortelirico.com.br": {
    s: 'div[class*="s-gdpr-c-c"]{display:none !important}',
  },
  "fler.cz": { s: 'div[class*="unit-cookies"]{display:none !important}' },
  "loombard.pl": { s: '.modal[id*="cookieconsent"]{display:none !important}' },
  "megfoglak.hu": { s: ".modal.consent{display:none !important}" },
  "cmo.de": { c: 33 },
  "eurosender.com": {
    s: '#__next > div[class*="container"]{display:none !important}',
  },
  "suncalc.org": { s: "#cc--main{display:none !important}" },
  "brico-travo.com": {
    s: "#modal-rgpd,.overlay::after{display:none !important}",
  },
  "partille-tool.se": { s: "#CookiesSettings{display:none !important}" },
  "tonerlagret.se": { s: ".cookie-cutter{display:none !important}" },
  "euskadi.eus": { s: "#cookies-block{display:none !important}" },
  "blogger.com": {
    s: 'div[data-noticekey*="EuCookieNotice"]{display:none !important}',
  },
  "watson.ch": { s: ".watson-cookie-footer{display:none !important}" },
  "minecraftfortress.org": {
    s: '#t-footer div[class*="banner"]{display:none !important}',
  },
  "prk24.pl": { s: ".rk-cookie-overlay{display:none !important}" },
  "landi.ch": { s: ".ccm-root{display:none !important}" },
  "tproger.ru": { s: ".tp-cookie-notify{display:none !important}" },
  "moneycontrol.com": { s: "#ccw{display:none !important}" },
  "ground.news": { s: ".fixed.bottom-0{display:none !important}" },
  "clinic3.ru": { s: "#agreedBanner{display:none !important}" },
  "yomiuri.co.jp": { s: "#consentModal{display:none !important}" },
  "helmholtz.software": {
    s: '.fixed[data-testid="cookie-consent-matomo"]{display:none !important}',
  },
  "withlocals.com": {
    s: 'aside[class*="CookieConsent"],div[class*="CookieOverlay"]{display:none !important}',
  },
  "xs.cz": { c: 20 },
  "codegym.cc": { c: 41 },
  "eppkarsin.com": { c: 41 },
  "javarush.com": { c: 41 },
  "cecotec.es": { c: 41 },
  "oraclecloud.com": { c: 41 },
  "datatilsynet.no": { c: 41 },
  "visionexpress.hu": { c: 41 },
  "erotik.com": { s: ".swinger-consent{display:none !important}" },
  "food.ru": { s: 'div[class*="cookieNotice"]{display:none !important}' },
  "goout.net": { s: ".goout-cookie-overlay{display:none !important}" },
  "maxforlive.com": { s: "#cookie-consent{display:none !important}" },
  "mywheels.nl": {
    s: ".di-popup-container.isVisible{display:none !important}",
  },
  "veepn.com": { s: ".cookie_privacy{display:none !important}" },
  "velophil.berlin": { s: ".cookie-z-index{display:none !important}" },
  "simbrief.com": { s: "#cookie-settings{display:none !important}" },
  "byfood.com": { s: "#page-footer ~ div{display:none !important}" },
  "cadena88.com": { s: 'body > div[id*="cookie"]{display:none !important}' },
  "assurances.groupebpce.com": { c: 77 },
  "sky.com.br": { s: "#wrap-aviso-cookie{display:none !important}" },
  "getmailbird.com": { s: "#mb-footer-lawmsg{display:none !important}" },
  "blueridgemountains.com": {
    s: ".msg[data-cookie-consent]{display:none !important}",
  },
  "lemmofuture.com": {
    s: ".policy-initiative-ask-box-cover{display:none !important}",
  },
  "eltrox.pl": { s: ".modal-gdpr,.overlay-gdpr{display:none !important}" },
  "woccu.org": { s: "#cookie_area{display:none !important}" },
  "unclutterapp.com": { s: ".useCookiesAccept{display:none !important}" },
  "warspotting.net": { s: ".toast-message{display:none !important}" },
  "kensington.com": { s: ".Promotional-corner{display:none !important}" },
  "cinemark.cl": { s: "#modal-cookies-template{display:none !important}" },
  "nemocnicepribram.cz": { s: "#cookies_lista_2022{display:none !important}" },
  "mojandroid.sk": { s: "#cookie-law-info-bar{display:none !important}" },
  "procurator.com": {
    s: "py-anonymous-consent-management{display:none !important}",
  },
  "velotaf.com": { s: "#modal_cookies{display:none !important}" },
  "nendaz.org": { s: "#disclaimerCtn{display:none !important}" },
  "mediamarkt.pl": { s: ".cookie-box{display:none !important}" },
  "ostsee24.de": { s: ".consent-box{display:none !important}" },
  "expocasa.it": { s: ".cc-window{display:none !important}" },
  "androidide.com": {
    s: "body > .fixed.bottom-0.left-0.right-0{display:none !important}",
  },
  "wsa.gov.pl": { s: "#bipCookieModal{display:none !important}" },
  "hkw.de": { s: ".hkw-cookie-consent{display:none !important}" },
  "filmelier.com": { s: ".lgpd{display:none !important}" },
  "domclick.ru": { s: 'div[class*="CookieAlert"]{display:none !important}' },
  "pernambucanas.com.br": {
    s: 'div[class*="CookieContent"]{display:none !important}',
  },
  "fameplay.tv": { s: ".privacy-wrapper{display:none !important}" },
  "praxisplan.at": { s: "#consent-modal{display:none !important}" },
  "isybank.com": {
    s: ".cookie-modal,.modal-backdrop{display:none !important}",
  },
  "aimtuto.com": { s: "#ckWrap{display:none !important}" },
  "techedubyte.com": { s: "#ckWrap{display:none !important}" },
  "lvgmc.lv": { s: ".cookies__container{display:none !important}" },
  "opera.com": { s: "#cookie-consent{display:none !important}" },
  "gameleap.com": { s: "core-banner{display:none !important}" },
  "boosty.to": { s: 'div[class*="GdprOffer"]{display:none !important}' },
  "cint.com": { s: ".cint-cookiebot{display:none !important}" },
  "mydirtyhobby.de": { s: ".MuiDialogActions-root{display:none !important}" },
  "letuelezioni.it": { s: "#pp{display:none !important}" },
  "stadler.de": { s: "#backgroundMessagebox{display:none !important}" },
  "vanrobaeysrevolution.com": {
    s: "#privacyConsentInfo{display:none !important}",
  },
  "kamiennagrota.pl": { s: ".uk-notification{display:none !important}" },
  "sonomix.ch": { s: "#rgpd{display:none !important}" },
  "lydshop.no": {
    s: "#cookie-consent-modal,.modal-backdrop{display:none !important}",
  },
  "gvg-glasfaser.de": { s: ".Container_CookieHint{display:none !important}" },
  "gasspisen.se": {
    s: "#__next > #slide-out + div ~ div{display:none !important}",
  },
  "cc.cz": { s: ".b-cookie-bar{display:none !important}" },
  "octopusenergy.it": { s: "#content ~ div{display:none !important}" },
  "drive-image.com": { s: "#pp-info{display:none !important}" },
  "1password.com": {
    s: "main ~ .w-full.fixed.bottom-0,#js-cookie-banner-new{display:none !important}",
  },
  "volanbusz.hu": { s: ".accept-cookies{display:none !important}" },
  "metaratings.ru": {
    s: 'div[class*="CookieAllowance"]{display:none !important}',
  },
  "fraenkische-rezepte.de": {
    s: 'div[aria-labelledby*="cmpbox"]{display:none !important}',
  },
  "obligacjeskarbowe.pl": { c: 20 },
  "communitynotes.twitter.com": {
    s: 'div[aria-labelledby="notice-floating-ui-3-heading"]{display:none !important}',
  },
  "secure-awards.com": {
    s: '.ui-dialog[aria-describedby*="cookieConsent"],.ui-widget-overlay{display:none !important}',
  },
  "hotel-metropol.at": { s: ".mod-cr{display:none !important}" },
  "pkw.gov.pl": { s: ".rodo_info{display:none !important}" },
  "zoho.com": { s: ".zbottom-cookie-container{display:none !important}" },
  "kickz.com": { s: "#consent-dialog{display:none !important}" },
  "hh.ru": {
    s: 'div[data-qa*="lux-container"] > div[class*="wrapper_static-mobile"]{display:none !important}',
  },
  "funmail2u.de": { s: "td > #message{display:none !important}" },
  "perplexity.ai": {
    s: ".fixed.bottom-sm.left-sm.bg-background{display:none !important}",
  },
  "pkgs.org": { s: "#consent_notice{display:none !important}" },
  "smartthingsfind.samsung.com": {
    s: ".fixed.bottom-0{display:none !important}",
  },
  "audacityteam.org": {
    s: 'astro-island[component-url*="CookieConsent"]{display:none !important}',
  },
  "ameli.fr": {
    s: "#idPopupWARecueilConsentement,#bandeauConsentement,#pageConsentement{display:none !important}",
  },
  "eiendomsmegler1.no": { s: "#opt-in{display:none !important}" },
  "sonusparadisi.cz": { s: "#cookie-form{display:none !important}" },
  "exitlag.com": { s: "#cookie-exitlag{display:none !important}" },
  "audental.co.uk": { s: ".DmxlabsKooke{display:none !important}" },
  "coop.ch": { s: "swc-cookie-banner{display:none !important}" },
  "coop.br": { s: ".ui-notificationbar{display:none !important}" },
  "3dcoat.com": { s: "#cookiesModal{display:none !important}" },
  "casellimoveis.com.br": {
    s: '#__next > div[class*="Terms"]{display:none !important}',
  },
  "providenciadedeus.org.br": { s: ".aceite{display:none !important}" },
  "his-mobile.com": { s: ".cookieagree{display:none !important}" },
  "sage.hr": { s: "#landing-consent{display:none !important}" },
  "teamgroupinc.com": { s: ".privacyArea{display:none !important}" },
  "sfc.edu": { s: '.fixed[x-data*="noticeAccepted"]{display:none !important}' },
  "findmcserver.com": { s: ".ant-notification{display:none !important}" },
  "atlasformen.ch": {
    s: "#modalCookies,.modal-backdrop{display:none !important}",
  },
  "maxoutil.com": {
    s: '.fixed[x-data*="Amasty.Cookie"]{display:none !important}',
  },
  "evernote.com": { s: "footer ~ .fixed.w-full{display:none !important}" },
  "magadanmedia.ru": { s: ".cookies-wrap{display:none !important}" },
  "shuttle.rs": {
    s: '#__next > div > div[class*="bottom"]{display:none !important}',
  },
  "axo-actifs.fr": { s: "#cookies_frame{display:none !important}" },
  "lexiq.hu": { c: 3 },
  "isbank.de": { s: ".cookie-container{display:none !important}" },
  "skoob.com.br": { s: ".container-lgpd{display:none !important}" },
  "centrumzdrowegowlosa.pl": { s: "#gmgdpr-overlay{display:none !important}" },
  "e-file.pl": { s: "#cookiemodal{display:none !important}" },
  "vanostassenenkoffers.nl": {
    s: ".cookie_text_container{display:none !important}",
  },
  "ford.hr": { s: ".cookie-modal{display:none !important}" },
  "ford.lt": { s: ".cookie-modal{display:none !important}" },
  "midasbuy.com": {
    s: "#cookie-agreement-pop,.eea-pop{display:none !important}",
  },
  "supply.amazon.co.uk": { s: "#body > span{display:none !important}" },
  "bankinform.ru": { s: "#bisCookieCompliance{display:none !important}" },
  "freesound.org": { s: ".toast{display:none !important}" },
  "schaden.news": { s: "#cmp_modal,.modal-backdrop{display:none !important}" },
  "raider.bg": { s: "#cookie_script{display:none !important}" },
  "duunitori.fi": { s: ".gdpr-modal{display:none !important}" },
  "spitfireaudio.com": { s: ".cookie-consent{display:none !important}" },
  "mangooutlet.com": { c: 2 },
  "crocoblock.com": { s: "#modal-cookie{display:none !important}" },
  "bhaptics.com": { s: "#__next > .fixed.w-full{display:none !important}" },
  "bgextras.co.uk": { s: 'body > div[class*="opts"]{display:none !important}' },
  "wmt.top": { c: 20 },
  "bialettikave.hu": {
    s: "#popup_hatter,#popop_cont{display:none !important}",
  },
  "grandoptical.cz": { s: ".cookie-consent{display:none !important}" },
  "polsatbox.pl": { s: ".modal-overlay{display:none !important}" },
  "bezpiecznedane.gov.pl": {
    s: ".cookie-popup-modal,.modal-backdrop{display:none !important}",
  },
  "nft.coinbase.com": {
    s: 'footer ~ div[style*="bottom"][style*="fixed"]{display:none !important}',
  },
  "groundies.com": { j: 5 },
  "nyiron.hu": { j: 5 },
  "tfc-frankfurt.de": { j: 5 },
  "1und1.net": { j: 5 },
  "pepperstone.com": { j: 5 },
  "sovendus.com": { j: 5 },
  "jps.de": { j: 5 },
  "finanzchecks.de": { j: 5 },
  "123-reg.co.uk": { j: 5 },
  "managerohnegrenzen.de": { j: 5 },
  "mojelekarna.cz": { j: 5 },
  "leserservice.ch": { j: 5 },
  "fiberplane.com": { j: 5 },
  "radiobielsko.pl": { j: 5 },
  "frankenergie.nl": { j: 5 },
  "urbanitae.com": { j: 5 },
  "sq.gouv.qc.ca": { j: 5 },
  "towerhousewares.co.uk": { j: 5 },
  "winehouseportugal.com": { j: 5 },
  "avoury.com": { j: 5 },
  "fydeos.io": { j: 5 },
  "matheguru.com": { j: 5 },
  "allgaeuer-zeitung.de": { j: 5 },
  "kiwa.com": { j: 5 },
  "christianbook.com": { j: 5 },
  "team.blue": { j: 5 },
  "wtk.pl": { s: "#cookie-consent{display:none !important}", j: 5 },
  "arztnoe.at": { j: 5 },
  "assos.com": { j: 5 },
  "deuxiemeavis.fr": { j: 5 },
  "energieschweiz.ch": { j: 5 },
  "hair-express.de": { j: 5 },
  "habsburger.net": { j: 5 },
  "gasag.de": { j: 5 },
  "flatspot.pictures": { j: 5 },
  "tiwag.at": { j: 5 },
  "veriff.com": { j: 5 },
  "yachtall.com": { j: 5 },
  "lastmile.lt": {
    s: 'button[aria-label="Slapukų nustatymai"]{display:none !important}',
    j: 5,
  },
  "tokyocheapo.com": { j: 5 },
  "nettest.cz": { j: 5 },
  "visti.it": { j: 5 },
  "nhs-tickets.de": { j: 5 },
  "aida64russia.com": { j: 5 },
  "warsteiner.de": { j: 5 },
  "gift.be": { j: 5 },
  "reaguurder.gs": { j: 5 },
  "grupomasmovil.com": { j: 5 },
  "geocoindealer.de": { j: 5 },
  "sternwarte-muenchen.de": { j: 5 },
  "jyllands-posten.dk": { j: 5 },
  "ac-elektro.net": { j: 5 },
  "kurse.eatsmarter.de": {
    s: 'button[class*="consentFloatBtn"]{display:none !important}',
    j: 5,
  },
  "bestcarbuyer.co.uk": { j: 5 },
  "computerwoche.de": { j: 5 },
  "cert-bund.de": { j: 5 },
  "pro-sec.dk": { j: 5 },
  "patosnoticias.com.br": { j: 5 },
  "rhein-main-steht-auf.de": {
    s: ".privacy-settings-root{display:none !important}",
    j: 5,
  },
  "hornet.com": { j: 5 },
  "sreal.at": { j: 5 },
  "fleurop.de": { j: 5 },
  "budgetthuis.nl": { j: 5 },
  "wolfspeed.com": { j: 5 },
  "ncoi.nl": { j: 5 },
  "parken-in-mainz.de": { j: 5 },
  "fit-plus.info": { j: 5 },
  "bitfocus.io": { j: 5 },
  "lebonlogiciel.com": { j: 5 },
  "cgi.com": { j: 5 },
  "100partnerprogramme.de": { j: 5 },
  "jugendundmedien.ch": { j: 5 },
  "rappjmed.ch": { j: 5 },
  "wartezeiten.app": { j: 5 },
  "librus.pl": { s: ".x-float-wrap{display:none !important}", j: 5 },
  "inps.it": { j: 5 },
  "jobcenter-ge.de": { j: 5 },
  "devworkplaces.com": { j: 5 },
  "mccarthyandstone.co.uk": { j: 5 },
  "tvgids.nl": { j: 5 },
  "bernstein-badshop.de": { j: 5 },
  "bernstein-badshop.com": { j: 5 },
  "dvwg.de": { j: 5 },
  "eccediciones.com": { j: 5 },
  "hans-bunte.de": { j: 5 },
  "eldorado.ru": { j: 5 },
  "zeichen.tv": { j: 5 },
  "carvertical.com": { j: 5 },
  "eurowings.com": { j: 5 },
  "oberoesterreich.at": { j: 5 },
  "okko.tv": { j: 5 },
  "atresplayer.com": { j: 5 },
  "coinc.es": { j: 5 },
  "fubo.tv": { j: 5 },
  "hydroscand.se": { j: 5 },
  "korsettmanufaktur.de": { j: 5 },
  "hidealite.com": { j: 5 },
  "crazypatterns.net": { j: 5 },
  "lessonup.com": { j: 5 },
  "peddler.com": { j: 5 },
  "norli.no": { j: 5 },
  "prorail.nl": { j: 5 },
  "auto.nl": { j: 5 },
  "auto.ru": { j: 5 },
  "my.ua": { j: 5 },
  "vandeca.com": { j: 5 },
  "psinfoodservice.com": { j: 5 },
  "kodinerds.net": { j: 5 },
  "covomo.de": { j: 5 },
  "movistar.es": { j: 5 },
  "21vek.by": { j: 5 },
  "toonpool.com": { j: 5 },
  "undelucram.ro": { j: 5 },
  "everon.io": { j: 5 },
  "bijou-brigitte.com": { j: 5 },
  "autohaus-boettche.de": { j: 5 },
  "logpay.de": { j: 5 },
  "airastana.com": { j: 5 },
  "eversheds-sutherland.com": {
    s: "#cp-cookie-popup{display:none !important}",
    j: 5,
  },
  "vmock.com": { j: 5 },
  "alpinewhite.com": { j: 5 },
  "telekom.net": { j: 5 },
  "smartrezo.com": { j: 5 },
  "toit.io": { j: 5 },
  "wolt.com": { j: 5 },
  "airfrance.com": { j: 5 },
  "leetchi.com": { j: 5 },
  "velo-traumreise.de": { j: 5 },
  "wienerzeitung.at": { j: 5 },
  "cowaymega.com": { j: 5 },
  "vodafone.com": { j: 5 },
  "allegrolokalnie.pl": { j: 5 },
  "tonarinoyj.jp": { j: 5 },
  "remax.com": { j: 5 },
  "dosenmatrosen.de": { j: 5 },
  "airbaltic.com": { j: 5 },
  "mobiflip.de": { j: 5 },
  "shoot-club.de": { j: 5 },
  "tandem.net": { j: 5 },
  "wd40.fr": { j: 5 },
  "stackry.com": { j: 5 },
  "dutchexpatshop.com": { j: 5 },
  "threads.net": { j: 5 },
  "berlinerfestspiele.de": { j: 5 },
  "deal.by": { j: 5 },
  "bayernportal.de": { j: 5 },
  "eurogrow.es": { j: 5 },
  "forbes.co": { j: 5 },
  "uwv.nl": { j: 5 },
  "postal.ninja": { j: 5 },
  "pons.com": { j: 5 },
  "soundboks.com": { j: 5 },
  "idealcountryproperty.com": { j: 5 },
  "katespapermoney.co.uk": { j: 5 },
  "klasse.be": { j: 5 },
  "telekom.hu": { j: 5 },
  "jbfo.nl": { j: 5 },
  "sportdeutschland.tv": { j: 5 },
  "rikstoto.no": { j: 5 },
  "tellows.de": { j: 5 },
  "bokio.se": { j: 5 },
  "piratinviaggio.it": { j: 5 },
  "wakacyjnipiraci.pl": { j: 5 },
  "bostad.blocket.se": { j: 5 },
  "aquatuning.com": { j: 5 },
  "manga-passion.de": { j: 5 },
  "makro.co.za": { j: 5 },
  "zawszepomorze.pl": { j: 5 },
  "afbmotorcycles.co.uk": { j: 5 },
  "effector.pl": { j: 5 },
  "gronkh.tv": { j: 5 },
  "kps.com": { j: 5 },
  "uizard.io": { j: 5 },
  "africam.com": { j: 5 },
  "bandenconcurrent.nl": { j: 5 },
  "ehrensache.jetzt": { j: 5 },
  "ejobs.ro": { j: 5 },
  "datagrottan.se": { j: 5 },
  "g2000.com.tw": { j: 5 },
  "118712.fr": { j: 5 },
  "konectis.com": { j: 5 },
  "reifentiefpreis.de": { j: 5 },
  "trezor.io": { j: 5 },
  "mercedes-benz.cr": { j: 5 },
  "morethantech.it": { j: 5 },
  "allinone.im": { j: 5 },
  "pacstall.dev": { j: 5 },
  "emall.by": { j: 5 },
  "fdm.dk": { j: 5 },
  "campusbrno.cz": { j: 5 },
  "nova-web.de": { j: 5 },
  "wokularach.pl": { j: 5 },
  "nibc.de": { j: 5 },
  "fftir.org": { j: 5 },
  "leki.pl": { j: 5 },
  "leki.com": { j: 5 },
  "schindler.de": { j: 5 },
  "craftelier.com": { j: 5 },
  "herbal-store.cz": { j: 5 },
  "qdq.com": { j: 5 },
  "edeka.de": { j: 5 },
  "10migliori-sondaggi.com": { j: 5 },
  "seguroscatalanaoccidente.com": { c: 77, j: 5 },
  "dlalakierni.pl": { j: 5 },
  "nelson.nl": { j: 5 },
  "marshall.com": { j: 5 },
  "mydhlfreight.com": { j: 5 },
  "depo.ee": { s: ".depo-cookies{display:none !important}", j: 5 },
  "tesco.hu": { j: 5 },
  "octopusenergy.es": {
    s: 'div[data-testid="iconCookies"]{display:none !important}',
    j: 5,
  },
  "primor.eu": { j: 5 },
  "meschaussures.fr": { j: 5 },
  "kempten.de": { j: 5 },
  "regenwald-schuetzen.org": { j: 5 },
  "rtl9.com": { s: "#rgpdModal{display:none !important}", j: 5 },
  "mvmnext.hu": { j: 5 },
  "pubg.com": { j: 5 },
  "turnier.de": { j: 5 },
  "greenpanda.de": { j: 5 },
  "sfgate.com": { j: 5 },
  "airbike.pl": { j: 5 },
  "yamaha-motor.eu": { j: 5 },
  "yamaha-motor.com.ph": { j: 5 },
  "albert.cz": { j: 5 },
  "drogeriapigment.pl": { j: 5 },
  "prisjagt.dk": { j: 5 },
  "odido.nl": { j: 5 },
  "game.es": { j: 5 },
  "citibankonline.pl": {
    s: "#cookiePolicyBanner.show{display:none !important}",
    j: 5,
  },
  "sp215.info": { j: 5 },
  "kisters.de": { j: 5 },
  "cheersapp.io": { j: 5 },
  "rolenplay.fr": { j: 5 },
  "dokiliko.com": { j: 5 },
  "menti.com": { j: 5 },
  "longines.com": { j: 5 },
  "kkh.de": { j: 5 },
  "microbit.org": { j: 5 },
  "evropochta.by": { j: 5 },
  "app-evs2023.de": { j: 5 },
  "ichgcp.net": { j: 5 },
  "leroymerlin.fr": { j: 5 },
  "leroymerlin.es": { j: 5 },
  "jawoll.de": { j: 5 },
  "aalto.fi": { j: 5 },
  "carbonify.de": { j: 5 },
  "groby.hu": { j: 5 },
  "worldshop.eu": { j: 5 },
  "janushenderson.com": {
    s: "#ccc-action-button{display:none !important}",
    j: 5,
  },
  "gereedschapcentrum.nl": { j: 5 },
  "ub.edu": { j: 5 },
  "sumsub.com": {
    s: 'button[class*="CookieButton"]{display:none !important}',
    j: 5,
  },
  "keyweb.de": { j: 5 },
  "hola.org": { j: 5 },
  "folders.nl": { j: 5 },
  "picockpit.com": { j: 5 },
  "efeedback.de": { j: 5 },
  "madrid.org": { s: "#emCookieWrapper{display:none !important}", j: 5 },
  "gripgrab.com": { j: 5 },
  "ibracorp.io": { j: 5 },
  "hokify.at": { j: 5 },
  "hokify.de": { j: 5 },
  "artifica.fr": { j: 5 },
  "ville-gif.fr": { j: 5 },
  "badundheizung.de": { j: 5 },
  "warpedsense.com": { j: 5 },
  "albamclothing.com": { j: 5 },
  "nykvarn.se": { j: 5 },
  "refunder.pl": { j: 5 },
  "fitnessgym-monheim.de": { j: 5 },
  "microshift.com": { j: 5 },
  "hofats.com": { j: 5 },
  "gesundheitsmanufaktur.de": { j: 5 },
  "microsolidarity.cc": { j: 5 },
  "mobilityurban.fr": { j: 5 },
  "ardutronix.de": { j: 5 },
  "ale.se": { s: ".MuiSnackbarContent-root{display:none !important}", j: 5 },
  "netcom-kassel.de": { j: 5 },
  "plnts.com": { j: 5 },
  "praxis.nl": { j: 5 },
  "resales.de": { j: 5 },
  "electronforge.io": { j: 5 },
  "coffeelab.nl": { j: 5 },
  "gazzetta.it": { j: 5 },
  "pysznosci.pl": { j: 5 },
  "campact.de": { j: 5 },
  "swedbank.ee": { j: 5 },
  "tradingdesk.finanzen.net": { j: 5 },
  "mainpost.de": { j: 5 },
  "genialne.pl": { j: 5 },
  "rangle.io": { j: 5 },
  "echo-online.de": { j: 5 },
  "tomshw.it": { j: 5 },
  "macnab.eu": { j: 5 },
  "jastrzabpost.pl": { j: 5 },
  "jmlnet.pl": { j: 5 },
  "senda.pl": { j: 5 },
  "aachener-zeitung.de": { j: 5 },
  "itextpdf.com": { j: 5 },
  "webasto.com": { j: 5 },
  "powershelluniversal.com": { j: 5 },
  "koeln.de": { j: 5 },
  "ilsole24ore.com": { s: "body{overflow:visible !important}", j: 5 },
  "voici.fr": { j: 5 },
  "gala.fr": { j: 5 },
  "telex.hu": { j: 5 },
  "gentside.com": { j: 5 },
  "telepolis.de": { j: 5 },
  "thestreet.com": { j: 5 },
  "rnd.de": { j: 5 },
  "stuttgarter-nachrichten.de": { j: 5 },
  "is.fi": { j: 5 },
  "hs.fi": { j: 5 },
  "computerbild.de": { j: 5 },
  "lotusbakeries.nl": { j: 5 },
  "mchs.se": { j: 5 },
  "itasportpress.it": { j: 5 },
  "fcinter1908.it": { j: 5 },
  "toronews.net": { j: 5 },
  "iodonna.it": { j: 5 },
  "juvenews.eu": { j: 5 },
  "leblob.fr": { j: 5 },
  "pcsoft-windev-webdev.com": { j: 5 },
  "e-pages.pub": { j: 5 },
  "kostencheck.de": { j: 5 },
  "sundair.com": { j: 5 },
  "naturschutz-sh.de": { j: 5 },
  "upperaustria.com": { j: 5 },
  "hornirakousko.cz": { j: 5 },
  "gorna-austria.pl": { j: 5 },
  "hornerakusko.sk": { j: 5 },
  "oberoesterreich.nl": { j: 5 },
  "geo.fr": { j: 5 },
  "tuebinger-umwelten.de": { j: 5 },
  "pcbleiterplatte.com": { j: 5 },
  "lomax.dk": { j: 5 },
  "lomax.se": { j: 5 },
  "jolstad.no": { s: ".show-cookie-pop-up{display:none !important}", j: 5 },
  "pompo.cz": { j: 5 },
  "pompo.sk": { j: 5 },
  "rockpoint.cz": { j: 5 },
  "deutschland.de": { j: 5 },
  "fbsbx.com": { j: 5 },
  "norlys.dk": { j: 5 },
  "naas.ai": { j: 5 },
  "ipn.pt": { s: "#cookie-law-panel{display:none !important}", j: 5 },
  "autoersatzteile.de": { j: 5 },
  "autoteiledirekt.de": { j: 5 },
  "swffm.de": { j: 5 },
  "kuestenpatent.info": { j: 5 },
  "der-hollaender.de": { j: 5 },
  "latka.cz": { j: 5 },
  "threads.com": { j: 5 },
  "rtvdrenthe.nl": { j: 5 },
  "rtvoost.nl": { j: 5 },
  "omroepzeeland.nl": { j: 5 },
  "omroepwest.nl": { j: 5 },
  "gld.nl": { j: 5 },
  "rijnmond.nl": { j: 5 },
  "1limburg.nl": { j: 5 },
  "omropfryslan.nl": { j: 5 },
  "rtvutrecht.nl": { j: 5 },
  "suedkurier.de": { j: 5 },
  "urlaubspiraten.de": { j: 5 },
  "urlaubspiraten.at": { j: 5 },
  "kayak.co.kr": { j: 5 },
  "cn.kayak.com": { j: 5 },
  "sparbankentanum.se": { j: 5 },
  "gx.me": { j: 5 },
  "wohn-design.com": { j: 5 },
  "draussenstadt.berlin": { j: 5 },
  "godox.eu": { j: 5 },
  "salonydenon.cz": { j: 5 },
  "salonydenon.pl": { j: 5 },
  "frischeparadies.de": { j: 5 },
  "besutilities.co.uk": { j: 5 },
  "lajtmobile.pl": { j: 5 },
  "sosfanta.com": { j: 5 },
  "voipshop.nl": { j: 5 },
  "routershop.nl": { j: 5 },
  "headsetwinkel.nl": { j: 5 },
  "gaggenau.com": { j: 5 },
  "tio.ch": { j: 5 },
  "metro.sk": { j: 5 },
  "makro.es": { j: 5 },
  "multiplayer.it": { j: 5 },
  "forbidmedia.com": { j: 5 },
  "expressvpn.com": { j: 5 },
  "bike-onlineshop.de": { j: 5 },
  "be2.cz": { j: 5 },
  "be2.fr": { j: 5 },
  "ohmymag.com": { j: 5 },
  "tormek.com": { j: 5 },
  "music.amazon.de": { j: 5 },
  "music.amazon.fr": { j: 5 },
  "music.amazon.co.uk": { j: 5 },
  "larousse.fr": { j: 5 },
  "hellozdrowie.pl": { j: 5 },
  "eurogamer.pl": { j: 5 },
  "calmwaters.de": { j: 5 },
  "centrumxp.pl": { j: 5 },
  "onexstore.pl": { j: 5 },
  "migros.ch": {
    s: '[data-js-module*="cookie-banner"]{display:none !important}',
    j: 5,
  },
  "coopmobile.ch": { j: 5 },
  "ledenicheur.fr": { j: 5 },
  "pricespy.co.uk": { j: 5 },
  "hintaopas.fi": { j: 5 },
  "pricespy.co.nz": { j: 5 },
  "trixonline.be": { j: 5 },
  "deroma.be": { j: 5 },
  "allecco.pl": { j: 5 },
  "zikodermo.pl": { j: 5 },
  "swiatleku.pl": { j: 5 },
  "nauka.rocks": { j: 5 },
  "corrieredellosport.it": { j: 5 },
  "tuttosport.com": { j: 5 },
  "buss-wohnen.de": { j: 5 },
  "refurbed.pl": { j: 5 },
  "refurbed.dk": { j: 5 },
  "refurbed.fr": { j: 5 },
  "refurbed.nl": { j: 5 },
  "refurbed.se": { j: 5 },
  "calvendo.com": { j: 5 },
  "calvendo.fr": { j: 5 },
  "calvendo.de": { j: 5 },
  "clickdoc.de": { j: 5 },
  "clickdoc.fr": { j: 5 },
  "aida64.it": { j: 5 },
  "aida64.de": { j: 5 },
  "aida64.hu": { j: 5 },
  "aida64.com.ua": { j: 5 },
  "favi.hu": { j: 5 },
  "favi.hr": { j: 5 },
  "favi.pl": { j: 5 },
  "favi.sk": { j: 5 },
  "favi.ro": { j: 5 },
  "favi.it": { j: 5 },
  "favi.se": { j: 5 },
  "favi.co.uk": { j: 5 },
  "regiojet.de": { j: 5 },
  "regiojet.cz": { j: 5 },
  "regiojet.sk": { j: 5 },
  "regiojet.at": { j: 5 },
  "regiojet.hu": { j: 5 },
  "regiojet.ua": { j: 5 },
  "regiojet.pl": { j: 5 },
  "resursbank.no": { j: 5 },
  "resursbank.dk": { j: 5 },
  "resursbank.fi": { j: 5 },
  "handelsbanken.com": { j: 5 },
  "handelsbanken.fi": { j: 5 },
  "handelsbanken.dk": { j: 5 },
  "handelsbanken.no": { j: 5 },
  "handelsbanken.co.uk": { j: 5 },
  "austria-email.at": { j: 5 },
  "austria-email.de": { j: 5 },
  "austria-email.com": { j: 5 },
  "stilord.pl": { j: 5 },
  "stilord.it": { j: 5 },
  "stilord.es": { j: 5 },
  "stilord.de": { j: 5 },
  "stilord.fr": { j: 5 },
  "stilord.com": { j: 5 },
  "hanos.de": { j: 5 },
  "renishaw.se": { j: 5 },
  "renishaw.fr": { j: 5 },
  "renishaw.it": { j: 5 },
  "renishaw.de": { j: 5 },
  "renishaw.es": { j: 5 },
  "renishaw.hu": { j: 5 },
  "renishaw.nl": { j: 5 },
  "renishaw.pl": { j: 5 },
  "renishaw.si": { j: 5 },
  "renishaw.jp": { j: 5 },
  "renishaw.com": { j: 5 },
  "renishaw.co.kr": { j: 5 },
  "renishaw.com.cn": { j: 5 },
  "renishaw.com.tw": { j: 5 },
  "renishaw.com.br": { j: 5 },
  "renishaw.com.tr": { j: 5 },

  "kika.ee": { j: 5 },
  "kika.lt": { j: 5 },
  "eneco.com": { j: 5 },
  "saniweb.nl": { j: 5 },
  "saniweb.be": { j: 5 },
  "euronics.ee": { j: 5 },
  "euronics.lv": { j: 5 },
  "adidas.ch": { j: 5 },
  "adidas.co.za": { j: 5 },
  "adidas.com.eg": { j: 5 },
  "adidas.co.kr": { j: 5 },
  "adidas.com.br": { j: 5 },
  "adidas.com.ar": { j: 5 },
  "colourbox.com": { j: 5 },
  "colourbox.de": { j: 5 },
  "colourbox.dk": { j: 5 },
  "colourbox.es": { j: 5 },
  "hema.com": { j: 5 },
  "hema.nl": { j: 5 },
  "dafy-moto.be": { j: 5 },
  "aviasales.com": { j: 5 },
  "aviasales.ru": { j: 5 },
  "crocs.de": { j: 5 },
  "umarex.com": { j: 5 },
  "umarex.de": { j: 5 },
  "petcity.lv": { j: 5 },
  "petcity.ee": { j: 5 },
  "apotheka.lt": { j: 5 },
  "apotheka.lv": { j: 5 },
  "apotheka.ee": { j: 5 },
  "inshared.de": { j: 5 },
  "ravensburger.de": { j: 5 },
  "ravensburger.co.uk": { j: 5 },
  "c-date.de": { j: 5 },
  "c-date.at": { j: 5 },
  "c-date.pl": { j: 5 },
  "c-date.com": { j: 5 },
  "c-date.com.hr": { j: 5 },
  "amway.si": { j: 5 },
  "amway.ro": { j: 5 },
  "amway.de": { j: 5 },
  "amway.cz": { j: 5 },
  "amway.be": { j: 5 },
  "amway.fr": { j: 5 },
  "amway.ie": { j: 5 },
  "amway.at": { j: 5 },
  "amway.co.uk": { j: 5 },
  "amway.com.tr": { j: 5 },
  "drinkcentrum.cz": { j: 5 },
  "drinkcentrum.sk": { j: 5 },
  "drinkcentrum.hu": { j: 5 },
  "backmarket.ie": { j: 5 },
  "backmarket.sk": { j: 5 },
  "backmarket.co.jp": { j: 5 },
  "pccomponentes.fr": { j: 5 },
  "allegro.sk": { j: 5 },
  "banknorwegian.se": { j: 5 },
  "banknorwegian.fi": { j: 5 },
  "banknorwegian.no": { j: 5 },
  "submodica.xyz": { j: 5 },
  "submodica.com": { j: 5 },
  "bestdrive.at": { j: 5 },
  "bestdrive.no": { j: 5 },
  "bestdrive.ch": { j: 5 },
  "bestdrive.cz": { j: 5 },
  "bestdrive.sk": { j: 5 },
  "character.ai": { j: 5 },
  "account.yougov.com": { j: 5 },
  "order.fiveguys.nl": { j: 5 },
  "webstore.zvw.de": { j: 6 },
  "krant.bndestem.nl": { j: 3 },
  "ezeitung.weser-kurier.de": { j: 3 },
  "blaetterkatalog.welt.de": { j: 3 },
};

const blockUrls = {
  common: [
    {
      r: "/iubenda_cs",
      e: [
        "radiomontecarlo.net",
        "video.repubblica.it",
        "video.lastampa.it",
        "nablawave.com",
        "buondi.it",
        "tgcom24.mediaset.it",
        "mediasetinfinity.mediaset.it",
        "mediaset.it",
        "telerama.fr",
        "skuola.net",
      ],
    },
    {
      r: "/ccm19_",
      e: ["ccm19.de"],
    },
    {
      r: "static.clickskeks.at",
    },
    { r: "/amp-user-notification-" },
    { r: "sn.sanoma.fi/js/sccm" },
    {
      q: true,
      r: "/api/rest/settings/public?fields=endUserAgreement",
    },
    { r: "congstar-media.de/fileadmin/cpolicy/" },
    { r: "connect.danone.es" },
    { r: "/js/components/es6/PrivacyPolicy" },
    { r: "codice.shinystat.it/cgi-bin/getcod.cgi" },
    { r: "whitepress.pl/common/pltk/" },
    { r: "js.hs-analytics.net/analytics" },
    { r: "jsdelivr.net/wp/wp-slimstat" },
    { r: "/js/dsvgo." },
    { r: "/Flurrybox_EnhancedPrivacy/" },
    { r: "static.axept.io/sdk" },
    { r: "/tarteaucitron.css" },
    { r: "notice.sp-prod.net" },
    { r: "htmedia.in/analytics-js" },
    { r: "campact.containers.piwik.pro" },
    { r: "containers.piwik.pro" },
    { r: "wpcc.io/lib" },
    { r: "tag.goadopt.io" },
    { r: "/typo3conf/ext/supi/" },
    { r: "omnigrafitalia.it/policy" },
    { r: "/edgecastcdn.net" },
    { r: "/koriolis_gtm/theshield" },
    { r: "fourmizz.fr/rgpd" },
    { r: "hu-manity.co/hu-banner" },
    { r: "/ConsentManager,Sticky" },
    { r: "/js/rgpd/" },
    { r: "/module-rgpd/" },
    { r: "/rcs_cpmt/", e: ["video.corriere.it", "video.gazzetta.it"] },
    { r: "/bloc/django/ckcsfrg" },
    { r: "ccm19.vucx.de" },
    { r: "/avia-bootstrap/js/klaro/" },
    { r: "exm-medien.de/cman" },
    { r: "e2d-cms.de/cman" },
    { r: "/usercentrics-sdk/" },
    { r: "cc.dalten.cz/ccJs" },
    { r: "/ccm19os/" },
    { r: "transcend.io/cm/" },
    { r: "/avisopcdidomi" },
    { r: "/ccm19/public/app" },
    { r: "webcache.datareporter.eu" },
    { r: "webcache-eu.datareporter.eu" },
    { r: "cdn.realpeoplemedia.co.uk" },
    { r: "/assets-usercentrics/uc-version" },
    { r: "/Sticky2,ConsentManager" },
    { r: "cnilCookie.js" },
    { r: "basketballbelieve.com" },
    { r: "app.usercentrics.eu/browser-ui/", e: ["kicker.de", "kicker.ch"] },
    { r: "cc.anytrack.de/app.js" },
    { r: "/utag/ctm/business-insurance/prod/utag.js" },
    { r: "/GDPRPanelComponent" },
    { r: "aida.de/assets/coobann/" },
    { r: "/ModalEngage,ConsentManager,Sticky" },
    { r: "/coolkies-walkies/" },
    { r: "/tagcommander/tc_" },
  ],
  common_groups: {
    cookie: [
      { r: "/media/plg_system_cookieconfirm" },
      { r: "cookie_meldung.js" },
      { r: "cookiewarning.js" },
      { r: "cookiewarning4.js" },
      { r: "catalogocoop.it/cookie.js" },
      { r: "/wp-content/mu-plugins/cookie_notifier" },
      { r: "freegamehosting.eu/js/cookies.js" },
      { r: "jp2w.pl/a/cookie.js" },
      {
        r: "https://cdn.serviceform.com/serviceform-tools/privacy/sf-privacy-partner.js?v=nethit",
        e: ["https://www.lumise.se/"],
      },
      {
        r: "cookieConsent.js",
        e: ["talktalk.co.uk", "blackboard.com", "kayak.pl", "gamersgate.com"],
      },
      { r: "/inc/cookiechoices.js" },
      { r: "metpartner.pl/cookie/info_cookie.js" },
      { r: "catalogo.pusc.it/pusc_jquery.cookie.min.js" },
      { r: "cookie_law.js" },
      {
        r: "lebendiges-aachen.de/includes/javascript/cookiechoices/cookiechoices.js",
      },
      {
        r: "cookies.reedbusiness.nl/script/cookiechecker/cookiejs.js",
      },
      { r: "/javascript/garante-privacy/js-cookie-master" },
      { r: "/wp-content/plugins/cookie-compliance" },
      {
        r: "cdn.webgenerator.nl/_NoCDN/Javascript/CookieBar/cookies.min.js",
      },
      { r: "cookiesamtykke.js" },
      { r: "/modules/mod_pescookies" },
      { r: "/cookiesdirective" },
      { r: "/webapps/bb-cookie-disclosure" },
      { r: "cookie-use-policy.js" },
      { r: "cookies.orangegames.com/assets/js/cc.js" },
      { r: "/cookie-policy.js", e: ["newpharma.be"] },
      { r: "/ico_cookies.js" },
      { r: "/comun/cookie_comercial.js" },
      { r: "hogarutil.com/js/cookies.js" },
      { r: "/cookielaw.js" },
      { r: "bootstrap-cookie-consent.js" },
      { r: "cookieDisclaimer.js" },
      { r: "/public/scripts/cookie/popup.js" },
      {
        r: "gartneriraadgivningen.dk/skinCss/website/js/cookie/cookie.js",
      },
      {
        r: "/cookieconsent.js",
        e: [
          "blackboard.com",
          "kayak.pl",
          "portal.easygreenenergy.at",
          "oekostrom.at",
          "gin-rummy-online.com",
          "gamersgate.com",
          "spielemax.de",
          "tonershop.at",
          "plus-gp-joule.de",
        ],
      },
      { r: "/cookieconsentpopup.js" },
      { r: "cookiePolicyEUPopin" },
      { r: "cookielawscript.js" },
      { r: "cookiepolicy-client.js" },
      { r: "cookie-disclaimer.lemm.de/cd.js" },
      { r: "cookiebar-init.js" },
      { r: "cookie_consent.js", e: ["check24.de"] },
      { r: "cookiewarning2.js" },
      { r: "phufart.pl/info_o_cookie_utf8.js" },
      { r: "cookieInfo.js" },
      { r: "oleificiozucchi.it/cookie.js" },
      { r: "/cookieAccept.js" },
      { r: "videoland.com/external/cookiewall" },
      { r: "/cookiesDirective.min.js" },
      { r: "/cookie-law-plugin_en.js" },
      {
        r: "/wp-content/plugins/libernazione-utils/js/libcookies.js",
      },
      { r: "aegon.nl/data/cookiewall" },
      {
        r: "cultizm.com/templates/c2012light/javascript/cookies",
      },
      { r: "cookieprivacygenerator.js" },
      { r: "blogcindario.com/cookie.php" },
      { r: "promoracing.it/cookies/popup.cookie.js" },
      { r: "harazd.net/info_o_cookie_utf8.js" },
      { r: "cookie_acceptance_modal.js" },
      { r: "eurail_responsive_law_cookie_banner.js" },
      { r: "/dometic/dist/components/cookiescomponent" },
      { r: "basiszinssatz.info/cookiescript.js" },
      {
        r: "leporc.com/sites/all/modules/custom/info_cookies/info_cookies.js",
      },
      {
        r: "static.origos.hu/s/js/custom/origo/accept-cookie.js",
      },
      { r: "jquery-easy-eu-cookie-law.js" },
      { r: "shop.szakalmetal.hu//js/cookies.js" },
      {
        r: "cdn.nwmgroups.hu/s/js/custom/origo/accept-cookie.js",
      },
      {
        r: "bootsticks.npage.de/assets/js/cookieconsent.latest.min.js",
      },
      { r: "blogspot.it/js/cookiechoices.js" },
      { r: "blogspot.at/js/cookiechoices.js" },
      { r: "blogspot.es/js/cookiechoices.js" },
      { r: "blogspot.ee/js/cookiechoices.js" },
      { r: "blogspot.pl/js/cookiechoices.js" },
      { r: "blogspot.cz/js/cookiechoices.js" },
      { r: "blogspot.dk/js/cookiechoices.js" },
      { r: "blogspot.ie/js/cookiechoices.js" },
      { r: "blogspot.fr/js/cookiechoices.js" },
      { r: "blogspot.si/js/cookiechoices.js" },
      { r: "blogspot.hu/js/cookiechoices.js" },
      { r: "blogspot.sk/js/cookiechoices.js" },
      { r: "blogspot.se/js/cookiechoices.js" },
      { r: "blogspot.fi/js/cookiechoices.js" },
      { r: "blogspot.lt/js/cookiechoices.js" },
      { r: "blogspot.gr/js/cookiechoices.js" },
      { r: "blogspot.ro/js/cookiechoices.js" },
      { r: "blogspot.bg/js/cookiechoices.js" },
      { r: "blogspot.be/js/cookiechoices.js" },
      { r: "blogspot.hr/js/cookiechoices.js" },
      { r: "blogspot.de/js/cookiechoices.js" },
      { r: "blogspot.pt/js/cookiechoices.js" },
      { r: "blogspot.nl/js/cookiechoices.js" },
      { r: "blogspot.no/js/cookiechoices.js" },
      { r: "blogspot.is/js/cookiechoices.js" },
      { r: "blogspot.cl/js/cookiechoices.js" },
      { r: "blogspot.lv/js/cookiechoices.js" },
      { r: "blogspot.ch/js/cookiechoices.js" },
      { r: "blogspot.ba/js/cookiechoices.js" },
      { r: "blogspot.lk/js/cookiechoices.js" },
      { r: "blogspot.ru/js/cookiechoices.js" },
      { r: "blogspot.com/js/cookiechoices.js" },
      { r: "blogspot.co.uk/js/cookiechoices.js" },
      { r: "blogspot.ca/js/cookiechoices.js" },
      { r: "/ext/zt_popupcookies/" },
      { r: "iti.si/deljene_datoteke/cookies.js" },
      {
        r: "/wp-content/plugins/responsive-cookie-consent/",
      },
      { r: "skm.warszawa.pl/js/cookie.js" },
      { r: "/js/cookie-info.js" },
      { r: "/cookie_law/plugin.js" },
      { q: true, r: "/jslibrary/cookiewarning?" },
      {
        r: "/wp-content/plugins/cookie-notice",
        e: ["kapitalkontor.com", "barzahlen.de"],
      },
      {
        r: "airnewzealand.co.nz/vbook/actions/cookieconsent",
      },
      { r: "/cg_cookie.js" },
      { r: "grsuk.com/scripts/cookie-info.js" },
      { r: "cookie-consent.es5.min.js" },
      { r: "/js/cookielaw_mip.js" },
      { r: "informacja_cookies.js" },
      { r: "cookiefix.dynamicline.hu/fixcookie.js" },
      { r: "/cookie-consent.min.js" },
      { r: "/cookie-policy.min.js" },
      {
        r: "/wp-content/plugins/eu-cookie-law-wp-cookie-law/",
      },
      { r: "eurocookie.galilcloud.wixapps.net" },
      { r: "/cookie-terms.min.js" },
      { r: "/js/cookieStatement.js" },
      { r: "wawona.hu/cookie-box/" },
      { r: "/js/components/cookiescomponent" },
      { r: "/cookiesinfo/cookieinfo.min.js" },
      { r: "/cookie-consent/cookie-consent.umd.js" },
      {
        r: "/cookiebanner.",
        e: [
          "huk24.de",
          "huk.de",
          "adtipp.de",
          "nectar.com",
          "neckermann.de",
          "exali.de",
          "raiplaysound.it",
          "check24.de",
        ],
      },
      { r: "/common/cpol/cookiepolicy.php" },
      { r: "/cookie-widget/latest/cookiewidget.js" },
      { r: "static.talparadio.nl/js/cookiecheck.js" },
      { r: "bmedonline.es/js/cookies.js" },
      { r: "/consentcookie.min.js" },
      { r: "cookie.consent.is" },
      { r: "/cookie-notification.js" },
      { r: "filer_-_cookie_disclaimer_ny/" },
      { r: "/cpresources/cookieconsent/js/cookies.min.js" },
      { r: "layer22.net/scripts/cookies-no-conflict-naxa" },
      { r: "/cookiecuttr-eu-cookie-law-compliance/" },
      { r: "jquery.eu-cookie-consent.min.js" },
      { r: "/cookiebar.jquery.js" },
      { r: "trashmail.com/js/cookie" },
      { r: "gratiz.nl/cookie-script.js" },
      { r: "/cookie-service/js/client.js" },
      { r: "/js/euc_cookie.js" },
      { r: "/web/components/cookie-consent/" },
      {
        r: "/jquery.cookiesdirective.js",
        e: ["servizionline.gruppoascopiave.it"],
      },
      { r: "cookie-consent.azureedge.net/gdpr.js" },
      { r: "jquery.cookie.policy.min.js" },
      { r: "/prettycookies.js" },
      { r: "/accept-ad-targeting/cookie.js" },
      { r: "api.cookielaw.eu" },
      { r: "api.cookielaw-script.it" },
      { r: "/cookiealert.js", e: ["viessmann.com.pl"] },
      { r: "/external/ico.cookie." },
      { r: "/script/ico.cookie." },
      { r: "cookiewall.es5.min.js" },
      { r: "/cookiecompliance.js" },
      { r: "/remote/v1/cookie-notification" },
      { r: "/cookie-warning.js" },
      { r: "/cookienotice.js", e: ["betterworldbooks.com"] },
      { r: "private.dmscookie.com/scripts/" },
      { r: "tgory.sr.gov.pl/js/cookie.js" },
      { q: true, r: "/eu-cookie-law.js?browserId" },
      { r: "cookies.innershed.co.uk" },
      {
        r: "/wp-content/mu-plugins/cookie_notifier/cn.min.js",
      },
      { r: "/cookiebar_tls.js" },
      { r: "/wp-content/plugins/smart-cookie-kit/" },
      { r: "/cookie-notice.js" },
      {
        r: "/CookiePolicy/resources/scripts/cookie.policy.min.js",
      },
      { r: "/modules/cookieconsent/js/" },
      { r: "jquery.cookiepol.js" },
      { r: "/cookie-bar.js" },
      { r: "/cookie/cc_min.js" },
      { r: "/cookielaw/piskotkar.js" },
      { r: "myportalcms.com/template/js/mp_acookie.js" },
      { r: "/cookieplugin/cookie.js" },
      { r: "/cookie-message.js" },
      { r: "/cookies-banner.js" },
      {
        r: "doitonlinemedia.nl/global-js/avg-cookie.js",
        e: ["palazzogroep.nl"],
      },
      {
        r: "privacy.digimedia.com/check_cookie_country_code.js",
      },
      { r: "/fortune_cookie_popup.js" },
      { r: "/cookiecsnt2/js/cookie.min.js" },
      { r: "/cookies-note.js" },
      {
        r: "policy.app.cookieinformation.com",
        e: [
          "kartor.eniro.se",
          "kart.gulesider.no",
          "kort.degulesider.dk",
          "map.krak.dk",
          "altibox.no",
          "babysam.dk",
          "elkjop.no",
          "minaftale.dk",
          "skousen.dk",
          "skousen.no",
          "whiteaway.com",
          "whiteaway.no",
          "whiteaway.se",
          "dvdoo.dk",
        ],
      },
      { r: "/cookienotice/Js/" },
      {
        r: "/wp-content/plugins/fortune-cookie-consent-policy/",
      },
      { r: "gdl-cookiebar.tnt-digital.com/js/" },
      { r: "/nl-cookie-law.js" },
      { r: "/cookieaccept.js" },
      { r: "/ercookiebar." },
      { r: "/cookiewarn.js" },
      { r: "/cookie-hinweis/script-v2.js" },
      { r: "/js/cookieMessage.js" },
      { r: "/assets/js/sera/web/cookie.js" },
      { r: "cookiebanner.min.js" },
      { r: "/z7_cookiemanager.js" },
      { r: "/cookie-consent/js/", e: ["kawalekkodu.pl"] },
      { r: "cookieconsentnotice.js" },
      { r: "/modules/tnzcookie/" },
      { r: "/wp-content/plugins/gdpr-cookie-compliance" },
      { r: "/components/cookie-modal/cookie-modal.js" },
      { r: "/cookies-window.min.js" },
      { r: "/cookiewall-inline-for-popup.js" },
      { r: "/wp-content/plugins/cc-cookie-consent/" },
      { r: "/cookiePolicyV4.js" },
      { r: "/modules/cookiechoices.js" },
      { r: "/cookie-widget/bootstrap.js" },
      { r: "/jquery.tipsy.cookie.js" },
      { r: "cookie_choices.min.js" },
      {
        r: "/wp-content/plugins/wp-cookie-allow/",
        e: ["learndutch.org"],
      },
      { r: "/wp-content/plugins/cookiemedia/" },
      { r: "/Resources/Public/js/cookiebar." },
      { r: "/plugins/system/cookiespolicynotificationbar" },
      { r: "cookieassistant.com/widget.js" },
      { r: "/helper-scripts/cookieconsent/" },
      { r: "/msifestiwal/Scripts/cookies.js" },
      { r: "/cookie-overlay-pl.js" },
      { r: "/cookie.notify.js" },
      { r: "/cpol/cookiepolicy.php" },
      { r: "/cookie-consent-manager.js" },
      {
        r: "dtt.taleo.net/careersection/theme/381362/1547022019000/en/theme/js/cookies.js",
      },
      { r: "/gdpr/cookies/cookiesLayer.js" },
      { r: "/CookiePolicyGa/cookiepolicyga.js" },
      { r: "/sdc/cookie_consent.html" },
      {
        r: "/tmo_cookies/Resources/Public/Javascript/CookieSettings.js",
      },
      { r: "deltaxmultimedia.com/cookielaw" },
      { r: "/web/components/cookieusage" },
      { r: "/wp-content/plugins/eagerly-tools-cookie" },
      { r: "/scripts/cookiebar" },
      { r: "/resources/CookieConsent/cookies.js" },
      { r: "buro-3.nl/cookie/cookie.js" },
      { r: "/ll_cookie_bar.js" },
      { r: "api.cookiemonster.is/embed" },
      { r: "/wp-content/plugins/g361-cookies-consents" },
      { r: "/Scripts/Cookies/cookieacceptance.js" },
      { r: "/extimages/scripts/ukcookie.js" },
      { r: "cookies.aptelink.pl/nc.js" },
      { r: "eu_cookie_banner.js" },
      { r: "/eu_cookie_compliance.js" },
      { r: "/dc-cookie-privacy-settings.min.js" },
      { r: "/cookiesPolicy/static/lib.js" },
      { r: "/cookiewarning-nosql.js" },
      { r: "/jquery.bpcookies.min.js" },
      { r: "/resources/js/cookie/cookie-bar" },
      { r: "/cookieConsentDialog.js" },
      { r: "/wp-content/plugins/bc-cookie-consent" },
      { r: "/modules/idxcookies/" },
      { r: "/javascript/cookieser.js" },
      { r: "/cookiesWidget/widget.js" },
      {
        r: "consent.cookiebot.com",
        e: [
          "storyhouseegmont.dk",
          "storyhouseegmont.no",
          "storyhouseegmont.se",
          "egmont.com",
          "stadtmobil.de",
          "wwf.fi",
          "login.nos.pt",
          "asambeauty.com",
          "cineplex.de",
          "berlingske.dk",
          "digimon.kochfilms.de",
          "kino.dk",
          "hoyavision.com",
          "linak.es",
          "linak.de",
          "cajamar.es",
          "digitaltrends.com",
          "mein-grundeinkommen.de",
          "werder.de",
          "finanzmarktwelt.de",
          "danbolig.dk",
          "bt.dk",
          "scubadiving.com",
          "biomarkt.de",
          "harzwasserwerke.de",
          "stern.de",
          "dasinvestment.com",
          "derivate.bnpparibas.com",
          "werkenbijlidl.nl",
          "swspremberg.de",
          "nngroup.com",
          "bankia.es",
          "bergbauernmilch.de",
          "spiele-kostenlos-online.de",
          "ekstrabladet.dk",
          "epochtimes.de",
        ],
      },
      {
        r: "/ccp-sites/components/structure/cookie-notification/",
      },
      { r: "/cookies-info.js" },
      { r: "cookies.algo.at" },
      { r: "cookiehub.net/c" },
      { r: "/widgets/eu-cookie-law/" },
      { r: "app.cookieyes.com/client_data" },
      { r: "/skinCss/website/js/cookie/cookie.js" },
      { r: "freeprivacypolicy.com/cookie-consent" },
      { r: "/cookie-consent-module/dist" },
      { r: "/cookieOptIn.js" },
      { r: "/js/cookie_banner" },
      { r: "/jquery-cookies-alert.min.js" },
      { r: "cookielaw.emea.fcagroup.com" },
      { r: "/wp-content/plugins/tnk-cookies" },
      { r: "/cookiepopup.js" },
      {
        r: "consent.cookiefirst.com",
        e: ["swietawdomu.pl", "deutschesapothekenportal.de"],
      },
      { r: "/cookies-policy.js" },
      { r: "/wp-content/plugins/liquorice-cookies" },
      { r: "cookie-switch.viminds.de/api" },
      {
        r: "skyscnr.com/sttc/oc-registry/components/cookie-banner",
      },
      { r: "/modules/cookiesplus/views/js/cookiesplus.js" },
      { r: "/mws-cookie-solution.min.js" },
      {
        r: "/ajax/libs/cookieconsent2",
        e: [
          "membersuite.com",
          "la-becanerie.com",
          "rijbewijskeuringennederland.nl",
          "download.pixelexperience.org",
          "ceramtec-group.com",
        ],
      },
      {
        r: "/cookie-consent.js",
        e: [
          "talktalk.co.uk",
          "codexis.cz",
          "lacoste.com",
          "huuray.se",
          "indiearenabooth.com",
        ],
      },
      { r: "/cookienotice-bootstrap.js" },
      { r: "/wp-content/plugins/cookieEuGH" },
      { r: "/cookiebar.js" },
      { r: "/gdpr/cookie-notice" },
      { r: "/cookiechoices.min.js" },
      { r: "/cookie-consent-min.js" },
      {
        r: "cookieconsent.popupsmart.com/src/js/popper.js",
      },
      { r: "flixbus.com/cookie-consent" },
      { r: "/typo3conf/ext/jscookieconsent" },
      { r: "/jquery.cookie-policy.js" },
      { r: "/cookie-alert.js" },
      { r: "up-cookiemon.wavecdn.net" },
      {
        r: "/cookieBanner.",
        e: [
          "adtipp.de",
          "nectar.com",
          "neckermann.de",
          "exali.de",
          "raiplaysound.it",
          "check24.de",
        ],
      },
      { r: "/politica-cookies/leyCookies.js" },
      { r: "/trwcookieconsent/" },
      { r: "/dc_components/site/cookie-control/" },
      { r: "cookie-manager.de/cookie-manager/" },
      { r: "/pxpcookies.js" },
      { r: "/cookie/uccb-main" },
      { r: "/cookie_consent_min_js.js" },
      { r: "/onlinemanufaktur-cookie-notice/" },
      { r: "/mq_cookieconsent/" },
      { r: "/static/cookies/cookie-layer-wc-" },
      { r: "/cookie-bar/", e: ["vectra.pl", "urbanista.de"] },
      { r: "/cookiebar/scripts.js" },
      { r: "/fileadmin/cookieconsent/" },
      { r: "/cookieopt-min.js" },
      { r: "/micado.web.dsgvo.cookie" },
      { r: "wip.pl/js/cookie.js" },
      { r: "/docroot/js/app/modules/cookies-selection.js" },
      { r: "/typo3conf/ext/cookieman/" },
      { r: "/cookiecode.dist.min.js" },
      { r: "/cookie_agreement_dialogue.js" },
      { r: "googleapis.com/55_cookie-consent" },
      { r: "/nsd-cookie-banner.js" },
      {
        r: "/wp-content/plugins/responsive-eu-cookie-notice",
      },
      { r: "/wp-content/plugins/master-popups-cookieplus" },
      { r: "/cookie-banner-one.js" },
      { r: "/cookiemanagement.js" },
      { r: "/modules/mod_eu_cookies/" },
      { r: "/jquery.cookiefy/" },
      { r: "websitepolicies.com/lib/cookieconsent" },
      { r: "/typo3conf/ext/aip_cookie_law" },
      { r: "cookie.gg/c" },
      { r: "/plg_system_vpcookieconsent/" },
      { r: "/p8-cookie-bar.js" },
      { r: "/cookie-banner/cb.js" },
      { r: "/echonetcookie.js" },
      { r: "/cookie-policy-en.js" },
      { r: "/bb_cookieconsent/" },
      { q: true, r: "/?tx_z7cookiemanager" },
      { r: "/typo3conf/ext/kmacookies" },
      { r: "/_hw_cookie_dialog.js" },
      { r: "/cookie-consent-settings-ui/" },
      { r: "cookietrust.eu/script" },
      { r: "bs-cookie.staging.springbok.agency" },
      { r: "/cookie-banner.min.js", e: ["nice.org.uk"] },
      { r: "/WebUI/Cookies/allowcookies.js" },
      {
        r: "/SharedComponents/bundle-scripts/cookie-consent",
      },
      { r: "/cookieconsent.klaro." },
      { r: "/js/cookies_bar" },
      { q: true, r: "/modal/cookie-wall/?modal_view=true" },
      { r: "/wp-content/plugins/better_cookie_consent/" },
      { r: "/js/jquery-eu-cookie-law-popup" },
      { r: "flipdish-cookie-consent" },
      { r: "/js/cookie-law-ansi" },
      { r: "cookieconsent.syreta.com" },
      { r: "/js/deferred/cookie-consent" },
      { r: "/js/rodo-cookie" },
      { r: "/hw-cookie-dialog.js" },
      { r: "/accept-cookies.js" },
      { r: "/cookie_warning.js" },
      { r: "/plugins/cookies/tinybox.js" },
      { r: "/web/components/cookieconsent/" },
      { r: "cookie-bar.salessquad.co.uk" },
      { r: "/cookieMunchr.min.js" },
      { r: "nicmanager.com/static/cookie_guideline" },
      { r: "traderfox.de/lib/tfcookie.js" },
      { r: "/amadeus-plugin-cookies/" },
      { r: "/rh-cookieconsent-microsites.min.js" },
      { r: "/components/content/cookie-overlay/" },
      { r: "cookiemon.atcom.gr" },
      { r: "nbcsports.com/cookie-ack.js" },
      { r: "/js/gdpr/gdpr-cookie" },
      { r: "/jquery.ihavecookies.", e: ["wisla-plock.pl"] },
      { r: "/b2b-market/src/addons/cookie-consent/" },
      { r: "/vue/components/cookie-monster" },
      { r: "/wp-content/plugins/do-you-want-cookies/" },
      { r: "bascom.nl/cookies/consent.js" },
      { r: "/fluvius-eu-cookies.js" },
      { r: "/lyxor-cookies-disclaimer.js" },
      { r: "/grt-cookie-consent.js" },
      { r: "/bundles/cookiebar" },
      { r: "/avia-snippet-cookieconsent.js" },
      { r: "/user-cookie-banner/" },
      { r: "/typo3conf/ext/we_cookie_consent" },
      { r: "/wp-content/plugins/vp-cookies/" },
      {
        r: "/system/modules/cookiecontrol/assets/js/cc.js",
      },
      { r: "/cookieConsentNotif.js" },
      { r: "/typo3conf/ext/ne_cookies/" },
      { r: "/cookie-bar.min.js" },
      { r: "/ilovecookies.min.js" },
      { r: "/luxcookieconsent/" },
      { r: "/cookiehint/" },
      { r: "/cookieOptIn.min.js" },
      { r: "/sg_cookie_optin/" },
      { r: "/cookiebox.min.js", e: ["footroll.pl"] },
      { r: "/cookie.privacy.protection.js" },
      { r: "/new-cookie-policy." },
      { r: "/cookiehint.js" },
      { r: "/public-cookie-consent/" },
      { r: "/mod_jt_cookies/" },
      { r: "/js/dist/cookieAcceptance" },
      { r: "/cookiebanner/" },
      { r: "/acc.cookienotification.js" },
      { r: "/cookiepolicy.js" },
      { r: "cookie_api/cccframe" },
      { r: "/cookienote-" },
      {
        q: true,
        r: "/metro?sc_device=webcomponent&components=cookie",
      },
      { r: "/cookie_msg.js" },
      { r: "/cookie_info.js" },
      { r: "js.cookietagmanager.net" },
      { r: "/assets/mnd-cookie-consent" },
      { r: "/js_cookies_legal.js" },
      { r: "/ys_cookie_consent/" },
      { r: "/cookie-consent-v2/" },
      { r: "/beautiful-and-responsive-cookie-consent/" },
      { r: "/cookie/banner" },
      { r: "/widget-module-cookies" },
      { r: "/lightweight-cookie-notice/" },
      { r: "/ocean-cookie-notice/" },
      { r: "/jst_eu_cookie/" },
      { r: "procookie.by.nf" },
      { r: "/gdpr-cookie.js" },
      { r: "jquery-eu-cookie-law-popup" },
      { r: "/cp_cookieconsent.js" },
      { r: "cookies.ae-webdesign.com" },
      { r: "/ws5_eucookie/" },
      { r: "/cookieConsent/cookieModal.js" },
      { r: "/js/consent-cookie" },
      { r: "cookies.fo/qookies" },
      { r: "/hw-cookie-consent/" },
      {
        r: "/cookie-banner.js",
        e: ["labs.strava.com", "crossfit.com"],
      },
      { r: "/w4.cookiebar.js" },
      { r: "/wp-content/plugins/cookielay/" },
      { r: "plugin-cookie-consent/build" },
      { r: "/cookie/onetrust/" },
      { r: "/cookie-consent-settings-modal/" },
      { r: "/components/consent-cookie/" },
      { r: "/cookie-consent-service.js" },
      { r: "/cookieconsent.bundle.js" },
      { r: "/lgpd-cookie/" },
      {
        r: "/wp-content/plugins/cookies-and-content-security-policy/",
      },
      { r: "/cookiebox_uc_build.js" },
      { r: "/gen/cookie-notification" },
      { r: "/cookiesjsr.min.js", e: ["lcp.fr"] },
      { r: "/wp-content/plugins/eu-cookies-bar/" },
      { r: "/cookieOverlay-view.js" },
      { r: "/js/Widgets/cookieWidget", e: ["losteria.de"] },
      { r: "/js/minified/cookiecontrol.js" },
      { r: "/typo3conf/ext/ab1d_cookieconsent/" },
      { r: "/module/kabimba_cookie/" },
      { r: "/woody-addon-cookies/" },
      { r: "/__enzuzo-cookiebar.js" },
      { r: "/cookie_policy/ack.js" },
      { r: "/cookies-popup.js", e: ["northernpowergrid.com"] },
      { r: "/zedwcookie/" },
      { r: "/cookiedisclosure/core.js" },
      { r: "cookie.thynk.media/app.js" },
      { r: "/usercentrics/cookiebox" },
      { r: "/cookie-consent-tool/" },
      { r: "/cookie-notification.min.js" },
      { r: "onetrust.com/cookieconsentpub", e: ["fujifilm-x.com"] },
      { r: "/typo3conf/ext/dp_cookieconsent" },
      { r: "/cookie_banner.js" },
      { r: "/om_cookie_main.js" },
      { r: "/jquery.rgpd-cookies.js" },
      { r: "/bandeau_cookie.js" },
      { r: "/dist/js/cookie-consent" },
      {
        r: "/cookieconsent.min.js",
        e: [
          "sonnenverlauf.de",
          "mondverlauf.de",
          "leanlibrary.com",
          "retrogames.cc",
          "exagon.de",
          "sozialversicherung-kompetent.de",
          "varcevanje-energije.si",
          "khl.ru",
          "bauen-und-heimwerken.de",
          "carport-diagnose.de",
          "tricount.com",
        ],
      },
      { r: "/cookieConsentApp.js.gz" },
      { r: "/fileadmin/templates/cookie/fc_thin.js" },
      { r: "cdn.cookiecode.nl" },
      { r: "/wp-content/plugins/nd-cookie/" },
      { r: "/cookieconsent-all.min.js" },
      { r: "/cookieBanner.js" },
      { r: "/cookie-wall.js" },
      { r: "cookies.giant.cz/assets/consent" },
      { r: "cookies.praguebest.cz/dist" },
      { r: "/cookies-prompt/", e: ["gestiontv.vodafone.es"] },
      { r: "/bootstrap-cookie-consent-settings.js" },
      { r: "/rails_cookie_consent" },
      { r: "/rgpd/js/cookies.js" },
      { r: "/cookieBannerLoader.js" },
      { r: "cookieform.pl/assets/js/plugin" },
      { r: "/assets/components/cookiemanager/" },
      { r: "/ewcookienoteext.js" },
      {
        r: "/clientlibs/components/content/cookie/cookielayer",
      },
      { r: "/rm-cookieconsent.js" },
      { r: "/cookie-banner-vue" },
      { r: "cookiecdn.com/cwc.js" },
      { r: "/om-gdpr-cookie-consent.js" },
      { r: "cdn-cookieyes.com/client_data" },
      { r: "digitalsternemarketing.de/dscookie" },
      { r: "/modal-acceptare-cookie" },
      { r: "/cookies-bar/" },
      { r: "cookieconsent.blob.core.windows.net" },
      { r: "/all-cookieconsent-js.js" },
      { r: "/cookies-browser-alert-ui.fragment.js" },
      { r: "/tcf/cookie.js" },
      { r: "/bsgdprcookies/" },
      { r: ".cookiehub.eu" },
      {
        r: "traveljuice-engines.prod.traveljuice.fr/cookies",
      },
      { r: "/eu_cookie_compliance_override.js" },
      { r: "/smart-eu-cookies.min.js" },
      { r: "/gdpr-cookie-consent/" },
      { r: "/Pictorium/scripts/cookie-consent" },
      { r: "/jsLib/gdpr/cookie.js" },
      { r: "/cookieBar.js" },
      { r: "cc.controlcookies.com" },
      { r: "/cookieNotice.build.js" },
      { r: "/ux.ui-cookie-consent/" },
      { r: "/cookiesPopUp/" },
      { r: "/in2cookiemodal" },
      { r: "/cookie-banner/cookie-banner" },
      { r: "/polityka-prywatnosci/js/cookie-overlay" },
      { r: "/cookie-consent-portlet/" },
      {
        r: "/wp-content/plugins/simple-gdpr-cookie-compliance/",
      },
      { r: "/cookies-consents.js", e: ["posta.sk"] },
      { r: "theme-cookie/app/cookie.min.js" },
      { r: "plugins/ShprCookieFavour/" },
      { r: "cookies.ptj.de" },
      { r: "/cookieModal/clientlib" },
      { r: "/cookie-consent-banner/" },
      { r: "/dxcookieconsent/" },
      { r: "/wp-content/plugins/real-cookie-banner" },
      { r: "sohoshopcookies.js" },
      { r: "am-static.com/cookie-banner/sdk.js" },
      { r: "/marked-cookie-consent-web/app.js" },
      { r: "cdn.cookielaw.org", e: ["cnn.com"] },
      { r: "/wp-content/plugins/borlabs-cookie/" },
      { r: "/wp-content/plugins/gdpr-cookie-compliance/" },
      { r: "/etagen_cookie/" },
      { r: "/cookie_overlay.js" },
      { r: "/plugins/cookies-and-content-security-policy/" },
      { r: "/cookieBar.min.js" },
      { r: "/cookiedialog/cookieutility.js" },
      { r: "/wp-content/plugins/creare-eu-cookie-law-banner" },
      { r: "jsdelivr.net/npm/@finsweet/cookie-consent" },
      { r: "/cookieseubox.js" },
      { r: "/cookie/cc_cookie.js" },
      { r: "/cookieConsent.min.js", e: ["fransdewitte.nl"] },
      { r: "/category-assets/experiences/recurring/cookies" },
      { r: "/storage/ui/cookies-banner" },
      { r: "/cookiedisturber/" },
      { r: "/wp-content/plugins/lightweight-cookie-notice" },
      { r: "/typo3conf/ext/dm_cookies/" },
      { r: "/cookie-consent-dialogue.js" },
      { r: "/dist/scripts/cookie-control" },
      { r: "am-static.com/cookie-banner" },
      { r: "/marked-cookie-consent-web/" },
      { r: "app.falconcookie.de/storage" },
      { r: "/brd_cookies_consent/" },
      { r: "/modules/hicookielaw/" },
      { r: "/kbv-cookieconsent.js" },
      { r: "/cookie-consent-mycity.js" },
      { r: "/components/src/cookie-consent/" },
      { r: "/webtoffee-gdpr-cookie-consent/", e: ["altheaprovence.com"] },
      { r: "cookies.neuca24.pl/nc.js" },
      { r: "/cookies/manage-cookies-runtime" },
      { r: "/typo3conf/ext/ppw_cookie/" },
      { r: "/cookie-consent-widget/" },
      { r: "/modules/pages/js/cookie-dialog.js" },
      { r: "/typo3temp/assets/compressed/cookieman" },
      { r: "/cookiethough.min.js" },
      { r: "beyond-cookiebanner.de/app.js" },
      { r: "/assets/js/cookie_consent_manager" },
      { r: "/wp-content/plugins/viva-cookie-consent/" },
      { r: "/cookieMessage.min.js" },
      { r: "/michnhokn/cookie-banner/" },
      { r: "ddjnocookie.com/prod_public" },
      { r: "/modules/cookie_policy/frontend/" },
      { r: "/cookie_popup.js" },
      { r: "gdpsystem.eu/pl/cookiesprivacy" },
      { r: "/fcc-cookie-consent.js" },
      { r: "/gdpr-cookie-consent.min.js" },
      { r: "/cookieConsentScript" },
      { r: "/cookienoticepro.script.js" },
      { r: "/dsgvo/js/cookiemonster" },
      { r: "/cookie_consent_js" },
      { r: "/cookie-consent-request.js" },
      { r: "wko.at/gcm/cookie.js" },
      { r: "wko.at/css-js/scripts/cookie.js" },
      { r: "/frontend-core/js/cookieBox.js" },
      { r: "cookiemanager.dk/js/cm.js" },
      { r: "/mod_pixim_cookie/" },
    ],
    consent: [
      { r: "tmgonlinemedia.nl/consent/script/consent.js" },
      { r: "privacy.ariadneathome.nl/script/consent.js" },
      { r: "privacy.vtwonen.nl/script/consent.js" },
      { r: "wpjslib-chunk-consent-form.js" },
      { r: "/js/consentbar.js" },
      { r: "/gdprpro/views/js/gdpr-consent.js" },
      { r: "/js/consent-banner.js" },
      { r: "s.clickiocdn.com/t/consent_" },
      { r: "/jppol-consent/js/bootstrap.js" },
      { r: "/opbox-rodo-consent-modal/index" },
      { r: "optanon.blob.core.windows.net/consent" },
      { r: "libertatea.ro/consent/config.js" },
      { r: "consent-notice.magix.com" },
      { r: "/taunton-user-consent-eu" },
      { r: "consensu.org/t/consent_", e: ["softzone.es"] },
      {
        r: "consentmanager.mgr.consensu.org",
        e: ["sourceforge.net", "webfail.com", "sudoku-aktuell.de"],
      },
      { r: "/consently.min.js" },
      { r: "s.adroll.com/j/consent.js" },
      { r: "/consent-panel-vue.chunk.js" },
      { r: "consent.theneweuropean.co.uk" },
      { r: "/privacy-consent-banner.js" },
      { r: "thezen.garden/projects/zenconsent/" },
      { r: "smartconsent.ro/js/smart-consent.js" },
      { r: "/js/webflow-consent-manager" },
      { r: "app.consentassist.com/widget.js" },
      { r: "s.luxupcdnc.com/t/consent_" },
      { r: "cdn.appconsent.io", e: ["lefigaro.fr"] },
      { r: "consent.23g.io" },
      { r: "browser-consent-front.coco.s-cloud.fi" },
      { r: "/assets/consent-manager.js" },
      { r: "consent.weersvoorspelling.nl/v1" },
      { r: "/consent.webmasterplan.com/v2" },
      { r: "/js/adsconsent.min.js" },
      { q: true, r: "consent.truste.com/get?name=notice.js" },
      {
        r: "consent.trustarc.com/notice",
        e: [
          "tripit.com",
          "concursolutions.com",
          "fortune.com",
          "formula1.com",
          "forbes.com",
        ],
      },
      { r: "consent-manager.metomic.io" },
      { r: "cmp.uniconsent.com", e: ["photopea.com"] },
      { r: "/consent-banner-bootstrap" },
      { r: "tmgrup.com.tr/tmd-consent" },
      { r: "/js/consent-modal.js" },
      { r: "/api/snippets/js/consent-banner" },
      { r: "sixfifty.com/consent.js" },
      { r: "/gdpr/consent.js" },
      { r: "choices.consentframework.com" },
      { r: "cache.consentframework.com" },
      { r: "consentserve.mgr.consensu.org" },
      { r: "analytics-consent-manager.azureedge.net" },
      { r: "/mgm_consent.js" },
      { r: "hoffmann-group.com/common/consent" },
      { r: "/dv_t3_consent_management/" },
      { r: "/gsso_consent_manager.js" },
      { r: "avandor.com/consent" },
      { r: "/typo3conf/ext/data_consent/" },
      { r: "smart.idmnet.pl/consent" },
      { r: "kalevakonserni.fi/consent/gravito" },
      { r: "/bundle-consent-banner" },
      { r: "/modal-consent-component.min.js" },
      { r: "/consent-management/_include/init_consent.js" },
      { r: "pitcom-webanalyse.de/dsgvo/consent-banner" },
      { r: "wrd-aws.com/consent/" },
      {
        r: "/wp-content/plugins/ag-consentmanager-no-bootstrap/",
      },
      { r: "/static/consent-dialog." },
      { r: "/opbox-gdpr-consents/" },
      { r: "/cmp/consent-manager.js" },
      {
        r: "ampproject.org/v0/amp-consent",
        e: ["smartdroid.de", "lelum.pl"],
      },
      { r: "consent.trustarc.com/v2/notice" },
      { r: "/resources/onetrust/js/consent.js" },
      { r: "/consent-manager/lazy-consent-manager" },
      { r: "/addons/consent_manager/" },
      { r: "/npm/ez-consent" },
      { r: "/piwik-consent-banner-script.js" },
      { r: "/fileadmin/template/js/cconsent.js" },
      { r: "/kconsent/kconsent29.js" },
      { r: "/consent-layer/js/consent-layer-loader.js" },
      { r: "/tm-gdpr-consent/" },
      { r: "snigelweb.com/adconsent" },
      { r: "sncmp.com/adconsent" },
      {
        r: "consentmanager.net/delivery/js/cmp",
        e: ["winfuture.de", "infranken.de"],
      },
      { r: "consent-manager.confirmic.com" },
      { r: "consentbanner.de/public/app.js" },
      { r: "classistatic.de/consent-statics" },
      { r: "/consentcheck.de" },
      { r: "/gdpr-consent-management-platform/" },
      { r: "/drdsgvo-consent-script.js" },
      { r: "/gdpr-consent.bundle.js" },
      { r: "/consent/civic-bundle.js" },
      { r: "totalweb.gr/gdpr/consent" },
      { r: "/epaas.consentdrawer.bundle" },
      { r: "/consentbanner-fragment/" },
      { r: "altravia.com/connector/consent_mode.js" },
      {
        r: "consentmanager.net/delivery/cmp",
        e: ["winfuture.de", "infranken.de"],
      },
      { r: "/taunton-user-consent.js" },
      { r: "/fileadmin/templates/js/cconsent.js" },
      { r: "/wp-content/plugins/okf-euconsent" },
      { r: "consent.daa.net/app.js" },
      { r: "/gdpr-consent-banner/" },
      { r: "/consent-management-app/" },
      { r: "consent.hr/delivery/js/cmp" },
      { q: true, r: "/bundles/consent-init?v=" },
      { r: "/acc.consent.js" },
      { r: "consent.scm-verlagsgruppe.de" },
      { r: "/wp-content/plugins/consent-magic-pro" },
      { r: "7gra.us/consentbar" },
      { r: "/dgp-cookie-consent" },
      { r: "/assets/as24-cmp/consent-banner/" },
      { r: "/wp-content/plugins/log-user-consents/" },
      { r: "consent-bist.de/public/app.js" },
      { r: "consent.digiapi.com/consent.js" },
      { r: "idealo.com/storage/cmp/consent-management.js" },
      { r: "consent.prointernet.com/consent.js" },
      { r: "/coockieconsent.js" },
      {
        r: "consentmanager.net/delivery",
        e: [
          "winfuture.de",
          "echo-online.de",
          "stern.de",
          "spar.hu",
          "spar.hr",
          "spar.at",
          "spar.si",
          "interspar.at",
        ],
      },
      { r: "consent.comply-app.com" },
      { r: "kesko.fi/kconsent" },
      { r: "unpkg.com/@segment/consent-manager" },
      { r: "wko.at/static/ct/consent.js" },
      { r: "consenttool.haendlerbund.de/app.js?apiKey", q: true },
      { r: "consent.extrazimut.net/consent.js" },
      { r: "/cs_consent_modal.js" },
    ],
    gdpr: [
      { r: "/js/gdpr_footer.js" },
      { r: "/js/gdpr.min.js" },
      { r: "/js/comun/avisopcgdpr.js" },
      { r: "/gdpr/gdpr.js" },
      { r: "gdpr.internetbrands.com" },
      { r: ".be/api/gdpr" },
      { r: ".nl/api/gdpr" },
      { r: "-gdpr-min.js" },
      {
        r: "/gdpr-transparency-apnxs/latest/gdpr-bundle.js",
      },
      { r: "sitemaps.services.zam.com/gdpr_optout.js" },
      { r: "/ibeugdpr.min.js" },
      { r: "consensu.org/gdpr/cmp/gdpr-cmp-ui.js" },
      {
        r: "s3.amazonaws.com/sitemaps.services.zam.com/gdpr_standalone.js",
      },
      { r: "/sizzlegdpr.snippet.min.js" },
      { r: "/js/gdpr/messaging." },
      { r: "/mdp.javascript.gdpr.min" },
      { r: "/emg-framework/public/js/gdpr" },
      { r: "/emg-framework/assets/js/gdpr" },
      { q: true, r: "/assets/js/gdpr.js?ver" },
      { r: "/gdpr/injectable.min.js" },
      { r: "/ishop-plugins/gdpr" },
      { r: "secure-cdn.mplxtms.com/gdpr" },
      { r: "/gdpr-banner.js" },
      { r: "/am2-gdpr-public.js" },
      { r: "/gdprscript.js" },
      { r: "/plugins/surbma-gdpr" },
      { r: "/gdpr-banner.min.js" },
      { r: "libraries.wmgartistservices.com/gdpr" },
      { r: "/gdprmain/prod/utag.js" },
      { r: "cdn.thisisdone.com/gdpr/" },
      { r: "gdpr-banner.awsmpsa.com" },
      { r: "securebrainpull.com/gdpr/" },
      { r: "gdpr500.com/widget/pandawidget/" },
      { r: "/bundle-gdpr.min.js" },
      { r: "/gdpr/CookieConsent", e: ["kayak.pl"] },
      { r: "/2018-gdpr.js" },
      { r: "/gdpr-cmp-ui.js" },
      { r: "/js/gdpr.min." },
      { r: "/plugins/gdpr/gdpr_ncoi.js" },
      { r: "/static/new/js/gdpr.js" },
      { r: "/libs/gdpr/cmp/cmp.bundle.js" },
      { r: "/pgdpr.min.js" },
      { r: "/policies/gdpr.js" },
      { r: "/gdpr/spd.js" },
      { r: "prizelogic.com/gdpr/third-party-optin.min.js" },
      { r: "/gdpr-popup.js" },
      { r: "/wordpress-ptchrgdprplugin/" },
      {
        r: "gdpr-wrapper.privacymanager.io",
        e: [
          "kinuskikissa.fi",
          "geenstijl.nl",
          "dailybuzz.nl",
          "rtvnoord.nl",
          "omroepbrabant.nl",
          "futurezone.at",
          "profil.at",
          "kurier.at",
          "weeronline.nl",
          "lablue.de",
          "vesti.bg",
        ],
      },
      { r: "evidon.com/pub/gdprnotice.js" },
      { r: "/wp-content/plugins/ct-ultimate-gdpr" },
      { r: "gdpr.mandarin-medien.de/manager.js" },
      {
        r: "gdpr-tcfv2.sp-prod.net",
        e: [
          "computerbild.de",
          "programme-tv.net",
          "bold.dk",
          "welt.de",
          "sport1.de",
          "ostsee-zeitung.de",
          "sky.com",
          "lvz.de",
          "mein-schoener-garten.de",
          "autobild.de",
          "bike-bild.de",
          "bz-berlin.de",
          "travelbook.de",
          "si.com",
          "capital.fr",
          "t3n.de",
          "is.fi",
        ],
      },
      { r: "yastatic.net/s3/gdpr" },
      { r: "/zgdpr.min.js" },
      { r: "/gdpr/pp_agreement.pc." },
      { r: "/gdpr/cmp/cmpBundle.min.js" },
      { r: "/webmd.gdpr/" },
      { r: "/wp-content/plugins/motus-gdpr" },
      { r: "/plugins/gdprprivacysetup/" },
      { r: "/cc-gdpr.js" },
      { r: "metronom.com/library/scripts/gdpr" },
      { r: "/typo3conf/ext/lin_gdpr/" },
      { r: "/tronic-gdpr/" },
      { r: "/gdpr-banner/" },
      { r: "/typo3conf/ext/dbb_gdpr" },
      { r: "/gdpr-appliance.js" },
      { r: "pdcc.gdpr.es" },
      { r: "/gdpr-redirect.min.js" },
      { r: "/js/shared/gdpr.js" },
      { r: "/sdk-gdpr.min.js" },
      { r: "/js/gdpr-component" },
      { r: "/gdprDialog.js" },
      { r: "/bluelabs-gdpr/" },
      { r: "/gdprScriptComponent.js" },
      { r: "mediavine.com/tags/gdpr" },
      { r: "pubnation.com/tags/gdpr" },
      { r: "ecos.am/gdpr.js" },
      { r: "/modal-gdpr.umd.js" },
      { r: "/gdpr_notice.js" },
      { r: "/wp-content/plugins/lexon-gdpr/" },
      { r: "/popin-gdpr.js" },
      { r: "/modules/gdprpro/" },
      { r: "gdpr-api.sharethis.com/cmp" },
    ],
    privacy: [
      { r: "/media/plg_system_eprivacy", e: ["reshade.me"] },
      { r: "recepttar.hu/js/privacy.js" },
      {
        r: "cmp.dmgmediaprivacy.co.uk",
        e: ["metro.co.uk", "gbnews.uk"],
      },
      { r: "jssdk.privacy.pre.schibsted.com" },
      { r: "secureprivacy.ai/secureprivacy-plugin/" },
      { r: "/vendor/weka/privacykit/" },
      { r: "privacy.clym.io/js/clym-widget.js" },
      { r: "/js/privacypolicy.js" },
      { r: "/bosch-privacy-settings-" },
      { r: "/js/general/avada-privacy.js" },
      {
        r: "public.message-business.com/Javascript/mb.privacyManager",
      },
      { r: "cdn.reeltime.no/pm_assets/privacy/" },
      { r: "ftcguardian.com/privacy-update" },
      { r: "privacypolicy.trgr.be/widget" },
      { r: "/privacyopt.js" },
      {
        r: "/privacypolicy/styles/all/template/remove_url.js",
      },
      {
        r: "psi.schibsted.com/api/v2/privacy/notification",
      },
      { r: "/wp-content/plugins/privacy-policy-info/" },
      { r: "/e-privacy.min.js" },
      { r: "/privacyConsentBar.js" },
      { r: "tagcommander.com/privacy", e: ["labanquepostale.fr"] },
      {
        r: "isgprivacy.cbsi.com/dist/optanon",
        e: [
          "cbsnews.com",
          "startrek.com",
          "insideedition.com",
          "cbslocal.com",
          "etonline.com",
        ],
      },
      { r: "/contao-privacy-center.js" },
      { r: "privacy-policy.u-lab.nl" },
      {
        r: "trustcommander.net/privacy",
        e: ["tf1info.fr", "tf1.fr"],
      },
      { r: "app.eprivacy-keeper.eu" },
      { r: "/wp-content/plugins/en-privacy-notification/" },
      { r: "privacy.claytonhomes.com" },
      { r: "shopify.com/shopifycloud/privacy-banner" },
      { r: "/wp-content/plugins/enua-privacy-policy/" },
      { r: "demotywatory.pl/res/js/privacy_policy.js" },
      { r: "/eprivacy/js/eprivacy.js" },
      { r: "/sf-tagomo-privacy.js" },
      { r: "/s4s-privacy-module/" },
      { r: "/shopsshort/privacy/" },
      { r: "heg-cp.com/upm/privacy-manager" },
      { q: true, r: "tag=ui/privacy/CookiesConsent" },
      { r: "/dock-privacy-settings.esm.js" },
      { r: "privacy.wum.rocks/public/app.js" },
      { r: "/tagcommander/privacy_" },
      { r: "/serviceform-tools/privacy/sf-privacy" },
      { r: "/privacy-dialog-tracking.js" },
      { r: "/privacy/providers/CookiesDataProvider" },
      { r: "/contao-privacy-center" },
      { r: "/wp-content/plugins/myagileprivacy/" },
    ],
    cmp: [
      { r: "cmp.lemonde.fr" },
      { r: "cmp.quantcast.com" },
      { r: "cmp.nextday.media/cmp", e: ["vi.nl", "omroepwest.nl"] },
      { r: "cmp.dreamlab.pl" },
      { r: "/media/cmp/int_cmp_banner" },
      { r: "consensu.org/delivery/cmp.min.js" },
      { r: "sipaof.mgr.consensu.org/sipacmp" },
      { r: "/cmp/sourcepoint/sp-msg.js" },
      { r: "cmp.cdntrf.com" },
      { r: "cmp.mediavine.com" },
      { r: "/cmpCookie.js" },
      { r: "/js/library/cmp/cmp.bundle-" },
      { r: "cmp-loader.choice.faktor.io" },
      { r: "/diyscmp.min.js" },
      { r: "bilsyndication.com/js/cmp" },
      { r: "bilsyndication.com/plugins/cmp" },
      { r: "cmp.osano.com" },
      { r: "vlitag.com/plugins/cmp" },
      { r: "cmp.md-nx.com" },
      { r: "cdn.opencmp.net", e: ["foraum.de", "idowa.de"] },
      {
        r: "cmp.faktor.mgr.consensu.org",
        e: ["omroepwest.nl", "consent.talpanetwork.com"],
      },
      { r: "gravito.net/cmp" },
      { r: "cdncmp.richaudience.com" },
      { r: "heymatic.com/assets/cmp" },
      { r: "/cmp/js/vendors~cmpUi" },
      { r: "ustatik.com/public/cmp" },
      { r: "mrf.io/cmp" },
      { r: "cmp.cls.pm" },
      { r: "gravito.net/lightcmp" },
      { r: "onetag-sys.com/cmp" },
      { r: "/truendo_cmp.pid.js" },
      { r: "cmp.optad360.io" },
      { r: "snigelweb.com/sncmp" },
      { r: "seznam.cz/js/cmp" },
      { r: "/pubtech-cmp" },
      { r: "cmp.pafo.fairbung.com" },
      { r: "sibbo.net/v2/sibbo-cmp" },
      { r: "24net.cz/resources/js/cmp.js" },
      { r: "/quorn-cmp.min.js" },
      { r: "cmps.o2.cz/delivery" },
      { r: "/tcf-cmp.min.js" },
      { r: "fastcmp.com/fast-cmp.js" },
      { r: "apps.ludostation.com/cmp/v2/cmp.js" },
      { r: "mrdev-cmp/assets/js/script.js" },
      { r: "cmp.setupcmp.com" },
      { r: "cmp.meteored.com" },
      { r: "veodys.fr/api/cmp" },
      { r: "/sibbo-cmp-core.js", e: ["atresplayer.com"] },
      { r: "gravito.net/alehdetcmp" },
      { r: "fastcmp.com/fast-cmp" },
      { r: "/sibbo-cmp-loader.js" },
      { r: "cmp.springernature.com" },
      { r: "determinator.service-cmp.com" },
      { r: "seznam.cz/js/cmp2/scmp.js" },
      { r: "seznam.cz/js/cmp2/scmp-external.js" },
    ],
    Cookie: [
      { r: "gofundme.com/js/3.0/visitorCookie.js" },
      { r: "/CookiesDirective" },
      { r: "CookieAccept/affirmation.js" },
      {
        r: "ariba.com/assets/scripts/classes/Ariba.Compliance.CookieConsent.js",
      },
      {
        r: "aldermore.co.uk/Scripts/Logic/CookieDisclaimer.js",
      },
      { r: "tweeboo.com/r/js/CookieDirective" },
      { r: "/jqueryCookieGuard" },
      { r: "jquery.smartCookie.min.js" },
      { r: "/cc-bar/cCookiesH.js" },
      { r: "/CookieDirective.js" },
      { r: "/setPrivacyCookie.min.js" },
      { r: "/clientlib-webpack-publish/js/CookiesApp-" },
      { r: "/js/CookieManager.js" },
      { r: "/bundle_CookieLegalNotice.prod.js" },
      { r: "/acceptCookies.js" },
      { r: "/i_CookieConsent.js" },
      {
        r: "/Amasty_GdprCookie",
        e: [
          "planet-cards.co.uk",
          "sunkost.no",
          "wondrium.com",
          "nova-motors.de",
          "moleonline.com",
          "durstexpress.de",
          "littlelunch.com",
          "twinpack.nl",
          "eckeroline.fi",
          "eilles.de",
          "xt500parts.com",
          "cupper-teas.de",
        ],
      },
      { r: "/ts/components/CookieConsent." },
      { r: "/SDG_CookieLayer.min.js" },
      { r: "/slr_js/allowCookies.js" },
      { r: "/javascript/component-CookieConsent" },
      { r: "/whCookieManager" },
      { r: "/Cookie-GetCookieModal" },
      { r: "/wp-content/plugins/1990KB-CookieConsent/" },
      { r: "/Magento_Cookie/js/notices" },
      { r: "/iwCookieBanner" },
      {
        r: "/CookieConsent.js",
        e: ["blackboard.com", "kayak.pl", "gamersgate.com"],
      },
      { r: "/js/CookieConsentNew" },
      { r: "/CookieManagerUi.js" },
      { r: "/widgets/global/vendors~LegalCookies" },
      { r: "/getCookieConsent" },
      { r: "/kssCookieManager/" },
      { r: "/ModalCookiesPrivacy.php" },
      { r: "/CookiesManager/CookiesManager.js" },
      { r: "/components/CookieManager/" },
      { r: "/SiteElements/Scripts/CookieBanner.js" },
      { r: "/plugins/CookiePop/" },
      { r: "/IntegerNet_CookieConsent/" },
      { r: "/new_Cookiebanner.js" },
      { r: "/feoCookies.min.js" },
      { r: "/Plumrocket_CookieConsent/", e: ["8020.net"] },
      { r: "/static/CookieManager/js/app" },
      { r: "/optInCookies.min.js" },
      { r: "/ja/controlCookies.js" },
      { r: "/utils/CookiePrompter" },
      { r: "/Wamoco_CookieConsentUi/" },
      { r: "/standaloneModalCookie.js" },
      { r: "/Detco_CookieBanner/" },
      { r: "/vfConsentCookies" },
      { r: "/Cookie-Interfrog/" },
    ],
    consensu: [
      {
        r: "quantcast.mgr.consensu.org",
        e: [
          "sourceforge.net",
          "tumblr.com",
          "wpolityce.pl",
          "player.livespotting.com",
          "indy100.com",
          "vi.nl",
          "independent.co.uk",
          "express.co.uk",
          "joe.ie",
          "joe.co.uk",
          "standard.co.uk",
          "avsforum.com",
          "pcgamer.com",
          "nfl.com",
          "filmvandaag.nl",
          "gamesradar.com",
          "iol.pt",
        ],
      },
      { r: "gemius.mgr.consensu.org" },
      { r: "sddan.mgr.consensu.org" },
      { r: "digitrust.mgr.consensu.org" },
      { r: "sharethis.mgr.consensu.org" },
      { r: "webads.mgr.consensu.org" },
      { r: "etarget.mgr.consensu.org" },
      {
        r: "optad360.mgr.consensu.org",
        e: ["infogliwice.pl"],
      },
      { r: "shinystat.mgr.consensu.org" },
      { r: "dan.mgr.consensu.org" },
      { r: "ogury.mgr.consensu.org" },
      { r: "inforpl.mgr.consensu.org" },
      { r: "sibboventures.mgr.consensu.org" },
      { r: "consensu.infor.pl" },
    ],
    script: [
      { r: "ciasteczkowapolityka.pl/getscript" },
      { r: "bsl.nl/extern/smbv-incl/script.js" },
      { r: "ssl.synovite-scripts.com/ut" },
      { r: "zoneadsl.com/clientscript/cnil.min.js" },
      {
        r: "angrybirdsmovie.net/site/scripts/nettracking4.js",
      },
      { r: "bobulous.org.uk/javascript-head-sitewide.js" },
      {
        r: "wroclaw.pl/portal/themes/js/script-rodo.min.js",
      },
      { r: "/scripts/pookie.js" },
      { r: "metasrc.com/assets/javascripts/compliance.js" },
      { r: "geo.fr/assets/scripts/sourcepoint.js" },
      { r: "/wp-content/plugins/rodo/rodo_script.js" },
      { r: "cdn.praivacy.eu/scripts" },
      {
        r: "script.getcomplied.com/scripts/complyWidget/assets/getCompliedListWidget.js",
      },
      { r: "/Gpdr/assets/ccc-script.js" },
      { r: "kookiecheck.cz/static/script" },
      { r: "legalblink.it/api/scripts/lb_cs.js" },
      { r: "/dgsvo/script.js" },
    ],
    plugin: [
      { r: "/wp-content/plugins/cc/js/cc.min.js" },
      { r: "common.i12.de/cms/file/plugin/dp/dp.js" },
      { r: "/wp-content/plugins/shapepress-dsgvo/" },
      { r: "/wp-content/plugins/iticonseil-rgpd/" },
      { r: "/wp-content/plugins/pixelmate/" },
      { r: "/wp-content/plugins/pixelmate-opt-in/" },
      { r: "static.trbo.com/plugin" },
      { r: "/wp-content/plugins/fb-pixel-dsgvo/" },
      { r: "id-ward.com/static/idw_plugin" },
      { r: "/ishop-plugins/ishop-cp" },
      { r: "/wp-content/plugins/rrze-legal" },
      { r: "/wp-content/plugins/rrze-legal" },
      { r: "/wp-content/plugins/jjarolim-tracking/" },
    ],
    track: [
      { r: "/acton/bn/tracker" },
      { r: "etracker.de/optin_overlay.php" },
      { r: "/libraries/google/do-not-track.js" },
      { r: "/tracking-permission-dialog.js" },
      {
        r: "origin-images.wikia.com/fandom-ae-assets/tracking-opt-in",
      },
      { r: "/tracking-opt-in.min.js" },
      { r: "/contaotrackingmanager/" },
      { r: "/peg_utils/tracking/" },
      { r: "/kixsimpletrack/" },
    ],
    rodo: [
      { q: true, r: "/rodo.js?pp_pr=" },
      { r: "/templates/rodo/rodo.js" },
      { r: "/js/rodo/rodo.js" },
      { r: "/js/rodo.js" },
      { r: "rodo.agora.pl/agreement/check" },
      { q: true, r: "/min-js?f=js/rodo.js" },
      { r: "/rodo_rmf" },
      { r: "/popup/rodo.min.js" },
      { r: "/rodo/rodo.js" },
      { r: "/rodo-agreement-popup.min.js" },
    ],
    cnil: [
      { r: "www.capitol.fr/streaming/cnil/cnil.js" },
      { r: "prismamediadigital.com/cnil.min.js" },
      { r: "newsletters.ftv-preprod.fr/cnil/js" },
    ],
    GDPR: [
      { r: "/Dock/DockContent/Cards/GDPRCard/index.js" },
      { r: "nanoGDPR.min.js" },
      { r: "/GDPR/GDPR.js", e: ["3ds.com"] },
      { r: "/GDPRPanelComponent" },
    ],
    ".com": [
      { r: "tdn.r42tag.com/lib/ut" },
      { r: "c.betrad.com/pub/third.js" },
      { r: "fundingchoices.google.com" },
      {
        r: "fundingchoicesmessages.google.com",
        e: [
          "rtl.hr",
          "fernsehserien.de",
          "bbc.com",
          "iol.pt",
          "stooq.pl",
          "stooq.com",
        ],
      },
      { r: "spiffymachine.com/v2/" },
      { r: "cdn.userdatatrust.com" },
      { r: "cdn.pubguru.com/pg.js" },
      {
        r: "qualtrics.com/WRSiteInterceptEngine",
        e: ["logmeininc.com"],
      },
      { r: "a.svtrd.com", e: ["ns.nl"] },
      {
        r: "foolcdn.com/mms/resources/js/international-visitor-notice-js",
      },
      {
        r: "heraeus.com/media/system_files/special_applications/heraues_datapolicy",
      },
      { r: "libraries.wmgartistservices.com/pplightbox" },
      { r: "assets.ubembed.com/universal" },
      { r: "pi.pardot.com/analytics" },
      { r: "api.useinsider.com/ins.js" },
      { r: "a.optmnstr.com/app/js" },
      { r: "borderfree.com/v1/dist/cbt.js" },
      { r: "cdn.justuno.com/mwgt" },
      { r: "caringzinc.com/v2" },
      {
        r: "dam.bbcchannels.com/m/2fmpg/js/outside-iframe.js",
      },
      {
        r: "dam.bbcchannels.com/m/2fmph/js/outside-iframe.js",
      },
      { r: "cdn.truendo.com" },
      { r: "intelligentscissors.com/v2" },
      { r: "cdn.adnuntius.com/adn.dmp.js" },
      { r: "cct-pubweb.com/ccpa" },
      { r: "widgets.legalmonster.com" },
      { r: "nexus.ensighten.com" },
      { r: "einfachonline.com/sid" },
      { r: "/railwayreason.com" },
      { r: "/teenytinycellar.com" },
      { r: "/lovelydrum.com" },
      { r: "/hatefulrequest.com" },
      { r: "/aloofvest.com" },
      { r: "privacidade.api.milvus.com.br" },
      { r: "global.ketchcdn.com" },
      { r: "e-i.com/SITW" },
      { r: "/pleasantpump.com" },
      { r: "/fearlessfaucet.com" },
      { r: "unpkg.com/orejime" },
      { r: "/superficialeyes.com" },
      { r: "cassiecloud.com/loader.js" },
      { r: "/childlikeform.com" },
      { r: "baycloud.com/tgcl.min.js" },
      { r: "/chickensstation.com" },
      { r: "/handsomelyhealth.com" },
      { r: "s2.getsitecontrol.com/widgets" },
      { r: "prismamediadigital.com/cnil.min.js" },
      { r: "cdn.efilli.com/efl.js" },
      { r: "api.brookiebot.com" },
      { r: "tiqcdn.com/utag/tui/" },
      { r: "/basketballbelieve.com" },
      { r: "/colossalchance.com" },
      { r: "/aliasanvil.com" },
      { r: "api.byscuit.com/data/client" },
      { r: "cdn.lawwwing.com/widgets" },
      { r: "/hallowedinvention.com" },
    ],
    ".js": [
      { r: "pcz.pl/static/js/moo-cooker.js" },
      { r: "/eucd/eucd.min.js" },
      { r: "cinabre.sudoc.abes.fr/psi_gui/js/bandeau.js" },
      { r: "/euopties.js" },
      { r: "/cknotiz.js" },
      { r: "/common/disclaimer/load.min.js" },
      { r: "wpjslib-chunk-notification.js" },
      { r: "/js/cpb.min.js" },
      { r: "/utag.tagsOptOut.js" },
      { r: "app.termly.io/embed.min.js" },
      {
        r: "static.wpolityce.pl/rhododendron/js/terms_of_service.js",
      },
      { r: "/info_cook.js" },
      { r: "/js/datenschutz.js" },
      { r: "c.sd1.fr/cn/cn.min.js" },
      { r: "zgody.infor.pl/build/assets/js/main.js" },
      { r: "static.s-sfr.fr/stats/sbtF.js" },
      { r: "/dsgvo_2018.js" },
      { r: "/js/dsgvo.js" },
      { r: "partner.vxcp.de/_js/vxcp_Common.js" },
      { q: true, r: "/cc.js?renew=false&referer=www.rs2.de" },
      { r: "/twcdisclaimer.js" },
      { r: "/jqueryCL.min.js" },
      { r: "/trustArcHelper.js" },
      { r: "widget.clym.io/clym.js" },
      { r: "htmedia.in/analytics-js/dap.js" },
      { r: "/ufti/uftiLoader.min.js" },
      { r: "/includes/pltk/pltk.js" },
      {
        r: "/onstuimig-tag-manager/base/adf-tm-base-min.js",
      },
      { r: "/GDRP_banner.js" },
      { r: "/ads/rgpd.js" },
      { r: "samtykker.agm.as/agent.js" },
      { r: "samtykker.agdermedia.no/agent.js" },
      { r: "/PopUpPriva/PopPrivacymin.js" },
      {
        r: "dialogue.sp-prod.net/messagingWithoutDetection.js",
        e: ["globalplayer.com"],
      },
      { r: "/datenschutz.min.js" },
      { r: "/ccm19.js" },
      { r: "/app.dsgvo.min.js" },
      { r: "/trigoAboveBox.jquery.js" },
      { r: "/dsgvoinit.min.js" },
      { r: "/styleguide/mxqasqco.js" },
      { r: "/tvp-tcfapi.js" },
      { r: "ccm19.de/app/public/app.js" },
      { r: "ccm.ceasy.de/public/app.js" },
      { r: "/js/orejime/js/orejime.js" },
      { q: true, r: "/ccm/public/app.js?apiKey" },
      { r: "ccm19.de/app.js" },
      { r: "/wwwschutz.min.js" },
      { r: "/ccm19/app.js" },
      { r: "/dsvgobanner.js" },
      { r: "/wecoma-lite.js" },
      { r: "resourcesurw.azureedge.net/js/cc55.js" },
      { r: "/ccnst/ccbundle.min.js" },
      { r: "cc.mpa-web.de/public/app.js" },
      { r: "/klaro/klaro-pe.js" },
      { r: "klaro-no-css.js" },
      { r: "ionic-consent.js" },
      { r: "ckpl-webc.min.js" },
      { r: "wagtail_tag_manager/wtm.bundle.js" },
      { r: "www.capitol.fr/streaming/cnil/cnil.js" },
      { r: "/Dock/DockContent/Cards/GDPRCard/index.js" },
      { r: "nanoGDPR.min.js" },
      { r: "newsletters.ftv-preprod.fr/cnil/js" },
      { r: "/js/components/es6/PrivacyPolicy" },
      { r: "js.hs-analytics.net/analytics" },
      { r: "jsdelivr.net/wp/wp-slimstat" },
      { r: "/js/dsvgo." },
      { r: "/GDPR/GDPR.js" },
      { r: "htmedia.in/analytics-js" },
      { r: "/js/rgpd/" },
      { r: "/avia-bootstrap/js/klaro/" },
      { r: "/js/tarteaucitron" },
      { r: "/pandectes-core.js" },
      { r: "/orejime.js" },
      { r: "jsdelivr.net/npm/cookify" },
      { r: "/cbgCConsent.js" },
      { r: "/ckpl-webc.min.js" },
      { r: "/js/klaro-no-" },
      { r: "/tcfapi/tcfapi.umd.js" },
      { r: "mein.clickskeks.at/app.js?apiKey", q: true },
    ],
  },
  specific: {
    "bt.com": ["/consumer/cookie/client"],
    "romstal.ro": ["/frontend/ajax/cookies"],
    "gremimedia.pl": ["/rodo-agreement-"],
    "zw.com.pl": ["/rodo-agreement-"],
    "fullrate.dk": ["/gtm.js?id=GTM-TCT2RJ"],
    "paruvendu.fr": ["/cmp.min.js"],
    "wumpus-gollum-forum.de": ["datenschutz.js"],
    "ruecken-zentrum.de": ["bho_infobar.js"],
    "ksta.de": ["/consent/message.js"],
    "oracle.com": ["consent.truste.com"],
    "congstar.de": ["/cui-cookie-policy"],
    "bitly.com": ["/gdpr.js"],
    "cdaction.pl": ["/privacy/popup.js"],
    "knaufdoehetzelf.nl": ["/cookies.js"],
    "louisvuitton.com": ["/utag.js"],
    "tvspielfilm.de": ["/spmsg_addetection.js"],
    "thelittleboxoffice.com": ["/firebox-gdpr.js"],
    "scholieren.com": ["/consent.css"],
    "basiszinssatz.de": ["/cookiescript.js"],
    "lucozadeenergy.com": ["/cookies/bundle"],
    "guitarbackingtrack.com": ["/cmp/"],
    "weersverwachting.nl": ["/ip-consent.min.js"],
    "fluke.com": ["cookiebot.com"],
    "tuicruises.com": ["/tui-cookie-bar.html"],
    "der-warnemuender.de": ["/cookie-option.js"],
    "sexmarkt.nl": ["/jquery.cookie.js"],
    "haag-streit.com": ["/ato-cookiebanner.js"],
    "cummins.com": ["/cookie.popup.js"],
    "woman.bg": ["/spd/spd.js"],
    "novini.bg": ["/spd/spd.js"],
    "sportal.bg": ["/spd.js"],
    "erfurter-bahn.de": ["/cookieman.min.js"],
    "lombardafiltri.it": ["/rg-gdpr.js"],
    "aqualip.de": ["/ibox.js"],
    "convertir-une-image.com": ["/cb-scripts"],
    "teraz.sk": ["cookies.teraz.sk"],
    "independent.com.mt": ["/cookie-policy.css"],
    "yello.de": ["/yello-cookie-layer.js"],
    "cashconverters.es": ["/cookies.js"],
    "christian.education": ["/zsmessagebar.js"],
    "rollingstone.com": ["/pmc-pp-tou/privacy.min.js"],
    "outage.report": ["/cookie-consent"],
    "gamigo.de": ["/meWantCookies"],
    "gamigo.com": ["/meWantCookies"],
    "bonniermag.se": ["/cmp/"],
    "lakesideparkmodels.com": ["/ccpa/"],
    "yoyogames.com": ["/cookie.umdaac.min.js"],
    "norma-connect.de": ["/vendor/cookies"],
    "test-aankoop.be": ["/CookiePolicy/"],
    "dailydot.com": ["aliveachiever.com"],
    "blochworld.com": ["cookie-bar.salessquad.co.uk"],
    "aida.de": ["/coobann"],
    "strabag-pfs.de": ["/dsgvoCC.js"],
    "avon-insurance.co.uk": ["/cookie.euck.js"],
    "simyo.nl": ["/js/cookie-popup"],
    "herokuapp.com": ["/bottom.js"],
    "melaniemartinezmusic.com": ["/cookie_banner"],
    "tarnkappe.info": ["/cm-body.js"],
    "metallumnovum.lt": ["/idgy_gdpr.js"],
    "jacquelinewilson.co.uk": ["/jw.cookies.js"],
    "iban-rechner.de": ["/consent_"],
    "hanseaticbank.de": ["/kameleoon.js"],
    "carriereonline.com": ["/cmp/"],
    "visma.fi": ["/eloqua"],
    "visma.no": ["/eloqua"],
    "visma.se": ["/eloqua"],
    "visma.nl": ["/eloqua"],
    "visma.com": ["/eloqua"],
    "shinedown.com": ["/cookie_banner_test.js"],
    "streamingbolaget.se": ["/streamify-gdpr.js"],
    "lineadombra.it": ["/cookies_alert.js"],
    "kidstaff.com.ua": ["/gdpr.js"],
    "catan.com": ["/privacy"],
    "winbrok.es": ["cookies.js"],
    "jcbeurope.eu": ["/eurogdpr"],
    "volksbund.de": ["/ig_cookie_frontend"],
    "lumberliquidators.com": ["bounceexchange.com"],
    "keltendorf-mitterkirchen.at": ["/cookie.js"],
    "mitterkirchen.at": ["/cookie.js"],
    "vils.at": ["/cookie.js"],
    "ratp.fr": ["/tarteaucitron/"],
    "remixshop.com": ["CheckCookiePolicy"],
    "myfridgefood.com": ["/japfg/"],
    "raggal.at": ["/cookie.js"],
    "haugsdorf.at": ["/cookie.js"],
    "umhausen.at": ["/cookie.js"],
    "wittetools.com": ["/cookienote/"],
    "vejutechnika.lt": ["/gdpr-idgy"],
    "goodcontent.pl": ["/pltk.js"],
    "arena-now.de": ["/tarteaucitron/"],
    "bysarahkhan.com": ["/surbma-yes-no-popup/"],
    "tryinteract.com": ["/consent.js"],
    "comdirect.de": ["/consentMgmt/"],
    "pasztor.at": ["/privacy.js"],
    "weltverbesserer.de": ["/tealium-external/"],
    "aarhusmotion.dk": ["/cookiesettings.js"],
    "tv2.dk": ["/oil"],
    "goettgen.de": ["/cookieajx"],
    "parkers.co.uk": ["cmp.parkers.co.uk"],
    "insidermonkey.com": ["lovelydrum.com"],
    "intu.co.uk": ["/intuCookieConsent.js"],
    "123-reg.co.uk": ["tags.tiqcdn.com/utag"],
    "thewindowsclub.com": ["stormyachiever.com", "thirstylettuce.com"],
    "gallup.com": ["/gcb/"],
    "wiwo.de": ["/gdpr/native-message"],
    "baustellenabsicherung24.de": ["koekje.js"],
    "wikifolio.com": ["/getdisclaimer"],
    "muenchenticket.de": ["/echonetcookie"],
    "premiosopenbank.com": ["/cookies-anekis.js"],
    "latoisondor.com": ["cookie-consent"],
    "carlsberggroup.com": ["/cbgCConsent.js"],
    "jugendregion.at": ["/cookie.js"],
    "youmath.it": ["/cmp-v2/"],
    "1und1.de": ["/permission/"],
    "zenroom.org": ["js.driftt.com"],
    "nosta.com": ["/bwx-cookie-consent.js"],
    "aerotime.aero": ["cookie_settings"],
    "stadt-bobingen.de": ["/cookieconsent."],
    "interestingengineering.com": ["troubledtail.com", "spellsalsa.com"],
    "arsys.es": ["/tracking.js"],
    "arsys.fr": ["/tracking.js"],
    "arsys.pt": ["/tracking.js"],
    "arsys.net": ["/tracking.js"],
    "tescobank.com": ["/privacy/Bootstrap"],
    "adlkofen.de": ["/cookieconsent"],
    "klinikwersbach.de": ["/cc_cookie.js"],
    "innogy.pl": ["/CookieWall/clb.js"],
    "e-pages.dk": ["/gdpr/"],
    "lagerhaus.at": ["/easycmp"],
    "ol.fr": ["/cookielab/"],
    "megadruck.de": ["/thcookie.js"],
    "catan.de": ["/privacy"],
    "qcnet.com": ["/gdpr.js"],
    "moneysupermarket.com": ["/msmCookieConsent.js"],
    "eon.com": ["/eon-com-tracking-consent"],
    "nationaltrust.org.uk": ["/website-cookie-preferences"],
    "zoopla.co.uk": ["/cookie-bundle"],
    "xebia.com": ["/cookie-wall"],
    "dhl.com": ["/otBannerSdk.js"],
    "jzzo.com": ["/cp01.js"],
    "salesviewer.com": ["/klaro/"],
    "mediacourant.nl": ["/gdpr.bundle.js"],
    "plasteurope.com": ["/consent-management/"],
    "dragnsurvey.com": ["/cookies.js"],
    "maggiore.it": ["/snap-popup.js"],
    "amicoblu.it": ["/snap-popup.js"],
    "podrozerowerowe.info": ["/apprise"],
    "stadtwerke-luebz.de": ["/data-consent."],
    "united-domains.de": ["/neo-cookie-layer.js", "/cookie-layer.js"],
    "peter-bringts.de": ["/cookieWidget.min.js"],
    "lux-residence.com": ["/cookie-consent/"],
    "df.eu": ["privacy-manager-v"],
    "mobilejob.com": ["/consent.js"],
    "strato.de": ["/consent."],
    "strato.nl": ["/consent."],
    "strato.fr": ["/consent."],
    "strato.es": ["/consent."],
    "strato-hosting.co.uk": ["/consent."],
    "renault.de": ["/consent/"],
    "andrewssykes.fr": ["/checkCookieConsent/"],
    "cornelsen.de": ["/consent-manager/"],
    "synopsys.com": ["/gdpr/"],
    "total.com": ["/utag.js"],
    "0calc.com": ["/tcf2.js"],
    "0rechner.de": ["/tcf2.js"],
    "0calc.fr": ["/tcf2.js"],
    "gusto.at": ["/otBannerSdk.js"],
    "kosta.at": ["/dsgvo-opt-in.css"],
    "total.nl": ["/utag.js"],
    "radioschwaben.de": ["/dywc.js"],
    "lyxoretf.com": ["/microsite-consent-disclaimer.js"],
    "psychcentral.com": ["/eea"],
    "storage-mart.com": ["/sm-policy-banner.js"],
    "juedische-allgemeine.de": ["/unitb-cmp"],
    "casanetwork.hu": ["/cookie.js"],
    "kamkabel.ru": ["/legal/"],
    "oreluniver.ru": ["/accept.js"],
    "lactease.com": ["/doria.js"],
    "ikonltd.co.uk": ["js.driftt.com"],
    "erstebank.hr": ["/esb-privacy.js"],
    "swl-unser-stadtwerk.de": ["/mediamus-cookie.js"],
    "stadtwerke-herne.de": ["/vinegar.js"],
    "planet-beruf.de": ["/vhs-assets-cookie-control-js.js"],
    "orangebank.fr": ["/ob_rgpd/"],
    "mintos.com": ["/otBannerSdk.js"],
    "synology.com": ["/syno_cookie_element"],
    "javhd.com": ["/jcookie/"],
    "sparkasse.at": ["/cmp/"],
    "fincaraiz.com.co": ["/PoliticaCookies.js"],
    "kleiderhelden.com": ["/Team23_SimpleCookie/"],
    "esprit.de": ["/utag.js"],
    "thebureauinvestigates.com": ["/cookieCutter"],
    "ing.es": ["/utag.js"],
    "tenable.com": ["/cookie.js"],
    "thetrainline.com": ["/otBannerSdk.js"],
    "op.fi": ["/consent.js"],
    "fastbill.com": ["/cookie.bundle.js"],
    "gaming-style.com": ["/Consent.js"],
    "transparenzregister.de": ["/cc.js"],
    "mcmakler.de": ["/uc/"],
    "ubuntu.com": ["cookie-policy"],
    "zitatezumnachdenken.com": ["consent.js"],
    "metoffice.gov.uk": ["cdn.civiccomputing.com"],
    "churchofengland.org": ["cdn.civiccomputing.com"],
    "tauschticket.de": ["/cnst.js"],
    "liberbank.es": ["/cookies/"],
    "h-supertools.com": ["/iCookie/"],
    "dennree.de": ["/he-consent/"],
    "gastro24.de": ["/uc_cookie"],
    "bopla.de": ["/Privacy"],
    "telerama.fr": ["cmp."],
    "courrierinternational.com": ["cmp."],
    "vodkaster.com": ["cmp."],
    "boursorama.com": ["brsimg.com/gdpr"],
    "canalplus.com": ["trcking.min.js"],
    "hauptbahnhofcity.wien": ["/cookie-banner"],
    "pons.com": ["/otBannerSdk.js"],
    "internet-rockstars.com": ["/cookiefly/"],
    "stepstone.de": ["/utag.js"],
    "stepstone.at": ["/utag.js"],
    "santander.pl": ["/utag.js"],
    "canal-plus.com": ["trcking.min.js"],
    "aftenposten.no": ["cmp."],
    "coca-cola-deutschland.de": ["/otBannerSdk.js"],
    "bahn.de": ["/consent-layer/"],
    "yodel.co.uk": ["cdn.civiccomputing.com"],
    "digit-photo.com": ["/cookie.js"],
    "iracing.com": ["/checkcookies.js"],
    "avast.com": ["/otBannerSdk.js"],
    "vg.no": ["/messagingNoTcfApi.js"],
    "tek.no": ["cmp."],
    "finn.no": ["cmp."],
    "lifesycle.co.uk": ["/ice.js"],
    "next-immo.com": ["/cookies"],
    "financer.com": ["/fnGdpr.js"],
    "mercedes-benz.io": ["/cookie-layer.js"],
    "svd.se": ["/messagingNoTcfApi.js", "cmp."],
    "blitzrechner.de": ["/sygnal42-gdpr/"],
    "multipower.com": ["/CookieLayer.js"],
    "meteoradar.ch": ["/cookie_management.js"],
    "halebop.se": ["/cookie-preferences"],
    "nif.no": ["/Cookie/"],
    "frag-einen-anwalt.de": ["/klaro-no-css.js"],
    "stema.de": ["/cookieconsent/"],
    "vinos.de": ["/cookieBox.js"],
    "swisscom.ch": ["/utag.js"],
    "schwaebische.de": ["/cmp"],
    "guldsmykket.dk": ["/cookies.js"],
    "mieterengel.de": ["/cookieconsent"],
    "gastro-hero.de": ["/uc_cookie"],
    "kurnik.pl": ["/cookie.js"],
    "nytimes.com": ["/dg-governance/"],
    "inyt.com": ["/dg-governance/"],
    "zukunftsheizen.de": ["/cookies.js"],
    "truphone.com": ["/cookies.js"],
    "oka.be": ["/cookie.js"],
    "prada.com": ["/utag.js"],
    "online-spellcheck.com": ["/cookie.js"],
    "geze.de": ["/it-cc.js"],
    "geze.pl": ["/it-cc.js"],
    "smartphonehoesjes.nl": ["/ConsentInit.min.js"],
    "aco.com.pl": ["/cookieser.js"],
    "bluelightcard.co.uk": ["/cookies.js"],
    "vodafone.cz": ["/vfConsentCookiesCs.js"],
    "bt.no": ["cmp."],
    "nwb-jobboerse.de": ["consent-"],
    "ampparit.com": ["/almacmp"],
    "avg.com": ["/otBannerSdk.js"],
    "washingtonpost.com": ["/otBannerSdk.js"],
    "aftenbladet.no": ["cmp."],
    "festo.com": ["/cookie_flyout.js"],
    "beckhoff.com": ["/klaro.js"],
    "manoloblahnik.com": ["/Manolo_CookieConsent/"],
    "landkreis-eichstaett.de": ["/LdCookieConsent.js"],
    "meineapotheke.de": ["/legal-consent/"],
    "inishpharmacy.com": ["/gdpr"],
    "godaddy.com": ["/consent-main"],
    "ultraleicht-trekking.com": ["/consent/"],
    "lecanardenchaine.fr": ["/base-nf.js"],
    "snp.nl": ["toestemmingen.snp.nl"],
    "mendeley.com": ["/otBannerSdk.js"],
    "howatherm.de": ["/cm/"],
    "tvgids.nl": ["/osb-cmp.min.mjs"],
    "01net.com": ["/cmp/"],
    "maerkischekiste.de": ["consent.maerkischekiste.de"],
    "coca-cola.pl": ["/otBannerSdk.js"],
    "coca-cola.co.uk": ["/otBannerSdk.js"],
    "coca-cola.dk": ["/otBannerSdk.js"],
    "nonsolocap.it": ["/it_nsc.min.js"],
    "totalwar.com": ["cdn.civiccomputing.com"],
    "gameswelt.ch": ["/cmp"],
    "gameswelt.de": ["/cmp"],
    "gameswelt.at": ["/cmp"],
    "versicherungsjournal.de": ["h1.versicherungsjournal.de"],
    "topannonces.fr": ["/cmp.min.js"],
    "ellisphere.fr": ["/cookies.min.js"],
    "biehler-cycling.com": ["/mdv.cookie.js"],
    "here.com": ["/utag.js"],
    "gizchina.com": ["/cmp/"],
    "consorsbank.de": ["/privacy"],
    "asus.com": ["/alert-info.js"],
    "asus.com.cn": ["/alert-info_cn.js"],
    "etuovi.com": ["/almacmp"],
    "vuokraovi.com": ["/almacmp"],
    "arvopaperi.fi": ["/almacmp"],
    "vodafone.de": ["/cmp.genesis"],
    "vape-phone.fr": ["/newCookieChoice.js"],
    "aok.de": ["/cookie-settings-manager"],
    "slaters.co.uk": ["/Ronis_Cookie/"],
    "zaehlerschrank24.de": ["/Hmm24_Cookiebanner/"],
    "shinden.pl": ["consensu.org"],
    "e24.no": ["js_privacy_cmp", "cmp."],
    "wochenblitz.com": ["/CookieThough.js"],
    "beethoven.de": ["/cookie.js"],
    "eon.pl": ["/CookieWall/"],
    "technics.com": ["/otBannerSdk.js"],
    "unibo.it": ["cookiebanner"],
    "guloggratis.dk": ["/utag.js"],
    "avantiwestcoast.co.uk": ["trustarc.com"],
    "stickypassword.com": ["/cookies/"],
    "billiger-mietwagen.de": ["/cookie_layer.js"],
    "cd.cz": ["/c22.js", "/c22cs.js"],
    "o2.cz": ["/cmp."],
    "flaine.com": ["/tarteaucitron/"],
    "nettikaravaani.com": ["/almacmp"],
    "immozentral.com": ["/stylecc"],
    "loesdau.de": ["/cookieConsent"],
    "zugtouren.de": ["/cc_cookie.js"],
    "t-mobile.cz": ["consent"],
    "gfps.com": ["cdn.civiccomputing.com"],
    "dgeg.gov.pt": ["/jquery.cookiekit.js"],
    "minmote.no": ["cmp."],
    "matmut.fr": ["/tc_privacy/"],
    "shirtee.com": ["/cookie_modal/"],
    "finance-magazin.de": ["/borlabs-cookie"],
    "elle.se": ["/otBannerSdk.js"],
    "fyens.dk": ["/otBannerSdk.js"],
    "chatfuel.com": ["/cf-analytics/"],
    "labu24.de": ["cc.labu24.de"],
    "ptj.de": ["cookies.ptj.de"],
    "autopflege24.net": ["consent.autopflege24.net"],
    "natune.net": ["/consent"],
    "studio3t.com": ["cookie-banner"],
    "pensionlisboa.com": ["/cookies_2020"],
    "britishairways.com": ["/ensighten/"],
    "ba.com": ["/ensighten/"],
    "finanz-forum.de": ["/consent.js"],
    "konsultacjejst.pl": ["/cookies.min.js"],
    "tarif4you.de": ["/klaro"],
    "carpassion.com": ["ccm.carpassion.com"],
    "godt.no": ["cmp."],
    "pent.no": ["cmp."],
    "rtr.at": ["/cookie.js"],
    "hotmart.com": ["/cookie-policy/"],
    "widforss.no": ["/consent-"],
    "ameblo.jp": ["/acmp.js"],
    "regentcentre.co.uk": ["/cookies.js"],
    "fightful.com": ["/dkmb_gdpr.js"],
    "arktis.de": ["/pandectes-core.js"],
    "apfelband.de": ["/pandectes-core.js"],
    "schvarz.com": ["/pandectes-core.js"],
    "santander.de": ["/uc-cmp/"],
    "electromenager-compare.com": ["/cookpop.min.js"],
    "klart.se": ["cmp."],
    "tv.nu": ["cmp."],
    "hemnet.se": ["/consent"],
    "soprema.fr": ["/aw-cookie.min.js"],
    "bosch-stiftung.de": ["/fc_cookie.js"],
    "zurich.it": ["/cookies.js"],
    "lavie.fr": ["cmp.lavie.fr"],
    "twisto.pl": ["/cookieconsent"],
    "koestritzer.de": ["/cookie.js"],
    "postfinance.ch": ["/cookiestarter"],
    "santanderconsumer.se": ["/b2c.cookie-consent@latest/"],
    "televes.com": ["/melindres/"],
    "broedersgezondheidswinkel.nl": ["/gdpr/"],
    "vontobel.com": ["/DisclaimerControl.js"],
    "fixtout.fr": ["/gtcookies/"],
    "le-jackpot-des-medailles-safti.fr": ["/cookie.js"],
    "kefalonia-griechenland.com": ["/RR_KE_ccm19/"],
    "porsche.com": ["/udg-uc-sdk.min.js"],
    "mann.tv": ["cdn.civiccomputing.com"],
    "wz.de": ["/consent-page.js"],
    "intex.fr": ["/tarteaucitron.js"],
    "mtb-news.de": ["/otBannerSdk.js"],
    "rennrad-news.de": ["/otBannerSdk.js"],
    "emtb-news.de": ["/otBannerSdk.js"],
    "cyberghostvpn.com": ["/cookie-consent/"],
    "playok.com": ["/cookie.js"],
    "ing.de": ["api.usercentrics.eu"],
    "mamacar.cz": ["/iceCookie.js"],
    "springerprofessional.de": ["/otBannerSdk.js"],
    "tui.se": ["/utag.js"],
    "tui.fi": ["/utag.js"],
    "papierkram.de": ["/index.php?consent_manager"],
    "americanexpress.com": ["/user-consent-management/"],
    "privatebanking.hsbc.com": ["/utag.js"],
    "hsbc.pl": ["/utag.js"],
    "renzgroup.de": ["/smedia_cookie/"],
    "tanke-guenstig.de": ["cookies.tanke-guenstig.de"],
    "histoire-et-civilisations.com": ["cmp."],
    "santander.com.br": ["/mfe-cookies/"],
    "dlr.de": ["ccm1."],
    "pdf24.org": ["/consent-manager/"],
    "lawgazette.co.uk": ["cdn.civiccomputing.com"],
    "abload.de": ["ccm."],
    "uca.es": ["/cookies_utils.js"],
    "bensanitair.nl": ["cookie-overlay.js"],
    "investice.cz": ["/boldCookie_custom.js"],
    "ccm19.de": ["/cmapp/"],
    "gfms.com": ["cdn.civiccomputing.com"],
    "meinaccount.gmx.net": ["/ppp/js/permission-client"],
    "hilfe.gmx.net": ["/ppp/js/permission-client"],
    "mein.web.de": ["/ppp/js/permission-client"],
    "lineadirecta.com": ["tags.tiqcdn.com/utag"],
    "ujam.com": ["/ujam_tracking/"],
    "ae.com": ["/ugp-api/webcontent/v1/"],
    "jobsireland.ie": ["/Cookieconsent/"],
    "mainpost.de": ["app.usercentrics.eu"],
    "czasnaherbate.net": ["pdcookiepro//views/js/"],
    "zs-watch.com": ["/dtc-fe/policy-control"],
    "loveholidays.ie": ["cookies.js"],
    "georg.at": ["/inc/cookie_modal_ajax.php"],
    "galaxus.fr": ["/_next/static/chunks/cookieOverlay"],
    "werner-mertz.de": ["consent.werner-mertz.de"],
    "corporate.modivo.com": ["/dist/js/cmp.js"],
    "jimms.fi": ["/jimmsconsent"],
    "jobup.ch": ["chunk-cookie-consent-modal"],
    "condair.de": ["/Cookie/ccm19/public/index.php/app.js?"],
    "eurostar.com": ["/utag.js"],
    "wko.at": ["/static/ct/consent.js"],
    "oem.no": ["/ui/common/scripts/cookies/cookieModalComponent-797ec8a07a.js"],
    "politico.eu": ["/wrapperMessagingWithoutDetection"],
    "lovelybooks.de": ["/wrapperMessagingWithoutDetection"],
    "idealo.de": ["/wrapperMessagingWithoutDetection"],
    "idealo.at": ["/wrapperMessagingWithoutDetection"],
    "idealo.es": ["/wrapperMessagingWithoutDetection"],
    "idealo.fr": ["/wrapperMessagingWithoutDetection"],
    "idealo.it": ["/wrapperMessagingWithoutDetection"],
    "idealo.co.uk": ["/wrapperMessagingWithoutDetection"],
    "femmeactuelle.fr": ["/wrapperMessagingWithoutDetection"],
    "hausjournal.net": ["/wrapperMessagingWithoutDetection"],
    "lepoint.fr": ["/wrapperMessagingWithoutDetection"],
    "chefkoch.de": ["/wrapperMessagingWithoutDetection"],
    "vg.no": ["/wrapperMessagingWithoutDetection.js", "cmp."],
    "boerse.de": ["/wrapperMessagingWithoutDetection.js"],
    "bt.no": ["/wrapperMessagingWithoutDetection.js"],
    "liberation.fr": ["/wrapperMessagingWithoutDetection.js"],
    "caradisiac.com": ["/wrapperMessagingWithoutDetection"],
    "anderes-wort.de": ["/wrapperMessagingWithoutDetection"],
    "bauer-baumschulen.ch": ["/CookieBanner.js"],
    "strato.se": ["/consent."],
    "imusic.de": ["/cc.js"],
    "imusic.dk": ["/cc.js"],
    "imusic.no": ["/cc.js"],
    "imusic.se": ["/cc.js"],
    "imusic.co": ["/cc.js"],
    "comparethemarket.com": ["/utag.js"],
    "malservice.aftonbladet.se": ["cmp."],
    "brandpreventiewinkel.nl": ["/brabo-cookie/"],
    "nettimoto.com": ["/almacmp"],
    "futura-sciences.com": ["privacy-center.org"],
    "schmalz.com": ["/cookie-box"],
    "the-fence.com": ["/popupConsent/"],
    "paradoxwikis.com": ["/cookie-files/"],
    "expert.es": ["/cookieconsent/"],
    "gettr.com": ["cmp.quantcast.com"],
    "we-online.com": ["coco.we-online.com"],
    "villagrancanaria.com": ["/modulos/cookies"],
    "carhartt.com": ["/consent.js"],
    "kotikokki.net": ["/almacmp"],
    "open.online": ["/rcs_cpmt/"],
    "style.corriere.it": ["/rcs_cpmt/"],
    "uwartsonline.nl": ["/ph-cookie-helper-mu/"],
    "pcgames.de": [".consent-"],
    "deviantart.com": ["cmp.quantcast.com"],
    "omni.se": ["cmp."],
    "nadeta.cz": ["/Libs/cookies"],
    "standard.sk": ["/standard-cookies/"],
    "private.com": ["/Disclaimer.js"],
    "seeandso.com": ["consent."],
    "patente.it": ["/privacy/"],
    "tk-aerztefuehrer.de": ["/utag.js"],
    "giroditalia.it": ["/rcs_cpmt/"],
    "behindthename.com": ["/cmp.js"],
    "boellhoff.com": ["it-cc.index.js"],
    "rembutiken.se": ["/cookiecontrol.js"],
    "deutsches-schulportal.de": ["consent."],
    "ofdb.de": ["/Custom_clubhinweis"],
    "elpais.com": ["privacy-center.org"],
    "pr0gramm.com": ["cmp.quantcast.com"],
    "helthjem.no": ["cmp."],
    "webkamery.online": ["/cookies/"],
    "nofluffjobs.com": ["/infrasdk.js"],
    "diariodejerez.es": ["privacy-center.org"],
    "leonoticias.com": ["privacy-center.org"],
    "bayern.de": ["/cookies_master.js"],
    "france24.com": ["privacy-center.org"],
    "caseking.de": ["/CKCookieConsent.js"],
    "gea-waldviertler.at": ["/cookie-consent/"],
    "gea-waldviertler.de": ["/cookie-consent/"],
    "kro-ncrv.nl": ["/ccm_"],
    "retinatendencias.com": ["privacy-center.org"],
    "avenuedelabrique.com": ["/tac.js"],
    "eldiadecordoba.es": ["privacy-center.org"],
    "flvw.de": ["/ConsentManager/"],
    "terveystalo.com": ["analytics-consent-manager"],
    "firmy.cz": ["seznam.cz"],
    "fameplay.tv": ["privacy-center.org"],
    "spektrum.de": ["poool.fr/access.min.js"],
    "wingo.ch": ["/wimc_gtm_consent/"],
    "commerzbank.de": ["/cmp_puk.js"],
    "mapy.cz": ["/scmp-int.js"],
    "immobilien.derstandard.at": ["privacy-mgmt.com"],
    "atu.de": ["/js/privacy"],
    "onlinestempel.ch": ["/consent."],
    "saeco.de": ["/cookiewall/"],
    "sage.co.uk": ["/Cookies.js"],
    "liebherr.com": ["/cmp/"],
  },
};

export { blockUrls, rules, commons, commonJSHandlers };
